#include "SseSpi.h"

DemoSseSpi::DemoSseSpi()
{
}

DemoSseSpi::~DemoSseSpi()
{
}

int DemoSseSpi::Init(int cpu_id, SsePrinter *printer)
{
    m_printCpu = cpu_id;
    m_ssePrinter = printer;
    for (int i = 0; i < TICK_QUEUE_CNT; i++)
    {
        try
        {
            tickUdpQueue[i] = new SPSCQueueOPT<MSG_CONTENT, UDP_RINGBUFFER_SIZE>();
        }
        catch (...)
        {
            printf("UdpQueue init failed\n");
            return -1;
        }
    }

    for (int i = 0; i < OTHER_QUEUE_CNT; i++)
    {
        try
        {
            otherUdpQueue[i] = new SPSCQueueOPT<MSG_CONTENT, SMALL_RINGBUFFER_SIZE>();
        }
        catch (...)
        {
            printf("UdpQueue init failed\n");
            return -1;
        }
    }

    m_printThread = new std::thread(&DemoSseSpi::PrintPacket, this);

    return 0;
}

void DemoSseSpi::onMarketDataSnapshotSse(MarketDataSnapshotSse *p)
{
    CopyMsgToQueue(p, sizeof(MarketDataSnapshotSse), 0);
}

void DemoSseSpi::onBestOrdersSse(BestOrdersSse *p)
{
    CopyMsgToQueue(p, sizeof(BestOrdersSse) + p->number * 8, 0);
}

void DemoSseSpi::onIndexSse(IndexSse *p)
{
    CopyMsgToQueue(p, sizeof(IndexSse), 1);
}

void DemoSseSpi::onETFSnapshotSse(ETFSnapshotSse *p)
{
    CopyMsgToQueue(p, sizeof(ETFSnapshotSse), 2);
}

void DemoSseSpi::onTickMergeSse(TickMergeSse *p)
{
    CopyTickMsgToQueue(p, sizeof(TickMergeSse), 1);
}

void DemoSseSpi::onAfterTradeSse(AfterTradeSse *p)
{
    CopyMsgToQueue(p, sizeof(AfterTradeSse), 3);
}

void DemoSseSpi::onAfterSnapshotSse(AfterSnapshotSse *p)
{
    CopyMsgToQueue(p, sizeof(AfterSnapshotSse), 4);
}

void DemoSseSpi::onBondSnapshotSse(BondSnapshotSse *p)
{
    CopyMsgToQueue(p, sizeof(BondSnapshotSse), 5);
}

void DemoSseSpi::onBondTickSse(BondTickSse *p)
{
    CopyTickMsgToQueue(p, sizeof(BondTickSse), 2);
}

void DemoSseSpi::onMarketDataTreeSnapSse(MarketDataTreeSnapSse* p)
{
    CopyTickMsgToQueue(p, sizeof(MarketDataTreeSnapSse), 3);
}

void DemoSseSpi::onBondTreeSnapSse(MarketDataTreeSnapSse* p)
{
    CopyTickMsgToQueue(p, sizeof(MarketDataTreeSnapSse), 4);
}

void DemoSseSpi::onStaticInfoSse(StaticInfoSse* p)
{
    CopyMsgToQueue(p, sizeof(StaticInfoSse), 6);
}

//=================== L1 ====================
void DemoSseSpi::onIndexSseL1(IndexSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(IndexSseL1), 5);
}

void DemoSseSpi::onStockSnapSseL1(StockBondSnapSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(StockBondSnapSseL1), 5);
}

void DemoSseSpi::onBondSnapSseL1(StockBondSnapSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(StockBondSnapSseL1), 5);
}

void DemoSseSpi::onFundSseL1(FundSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(FundSseL1), 5);
}

void DemoSseSpi::onOptionSseL1(OptionSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(OptionSseL1), 5);
}

void DemoSseSpi::onNationalDebtSseL1(NationalDebtSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(NationalDebtSseL1), 5);
}

void DemoSseSpi::onAfterTradeSseL1(AfterTradeSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(AfterTradeSseL1), 5);
}

void DemoSseSpi::onBond201SnapSseL1(StockBondSnapSseL1 *p)
{
    CopyMsgToQueue(p, sizeof(StockBondSnapSseL1), 5);
}

void DemoSseSpi::PrintPacket()
{
    MSG_CONTENT *pCurMsg;

    bindCpu(m_printCpu);

    struct timespec ts;

    while (true)
    {
        for (int i = 0; i < TICK_QUEUE_CNT; i++)
        {
            pCurMsg = tickUdpQueue[i]->front();

            if (!pCurMsg)
            {
                continue;
            }

            ts = pCurMsg->ts;

            m_ssePrinter->PrintSse(pCurMsg->buf, ts);
            tickUdpQueue[i]->pop();
        }

        for (int i = 0; i < OTHER_QUEUE_CNT; i++)
        {
            pCurMsg = otherUdpQueue[i]->front();

            if (!pCurMsg)
            {
                continue;
            }

            ts = pCurMsg->ts;

            if (pCurMsg->buf[5] == 1) //上交L2
            {
                m_ssePrinter->PrintSse(pCurMsg->buf, ts);
            }
            else //上交L1
            {
                m_ssePrinter->PrintSseL1(pCurMsg->buf, ts);
            }

            otherUdpQueue[i]->pop();
        }
    }
}

inline void DemoSseSpi::CopyMsgToQueue(void *p, uint64_t len, uint32_t queueIndex)
{
    MSG_CONTENT *pCurMsg = otherUdpQueue[queueIndex]->alloc();

    if (unlikely(!pCurMsg))
    {
        printf("UdpQueue Buffer is full\n");
        return;
    }

    clock_gettime(CLOCK_REALTIME, &pCurMsg->ts);

    memcpy(pCurMsg->buf, p, len);

    otherUdpQueue[queueIndex]->push();
}

inline void DemoSseSpi::CopyTickMsgToQueue(void *p, uint64_t len, uint32_t queueIndex)
{
    MSG_CONTENT *pCurMsg = tickUdpQueue[queueIndex]->alloc();

    if (unlikely(!pCurMsg))
    {
        printf("tickUdpQueue Buffer is full\n");
        return;
    }

    clock_gettime(CLOCK_REALTIME, &pCurMsg->ts);

    memcpy(pCurMsg->buf, p, len);

    tickUdpQueue[queueIndex]->push();
}
