#include <map>
#include <stdio.h>
#include <string.h>
#include <string>
#include "XeleCommon.h"

#include "SzsePrinter.h"

using namespace std;

#define WRITE_TIME 1

void SzsePrinter::flush()
{
    fflush(m_fp_snap);
    fflush(m_fp_trade);
    fflush(m_fp_order);
    fflush(m_fp_index);
    fflush(m_fp_bond_trade);
    fflush(m_fp_bond_snap);
    fflush(m_fp_bond_order);
    fflush(m_fp_tree_snap);
}

void SzsePrinter::PrintSz(char *buf, struct timespec ts)
{
    switch (buf[0])
    {
    case MSG_TYPE_SNAPSHOT:
    {
        MarketDataSnapshotSz *p = (MarketDataSnapshotSz *)buf;
        PrintL2SnapSz(p, ts);
    }
    break;
    case MSG_TYPE_BEST_ORDERS:
    {
        BestOrdersSz *p = (BestOrdersSz *)buf;
        PrintL2BestOrdersSz(p, ts);
    }
    break;
    case MSG_TYPE_INDEX:
    {
        IndexSz *p = (IndexSz *)buf;
        PrintIndexSz(p, ts);
    }
    break;
    case MSG_TYPE_TRADE:
    {
        TradeSz *p = (TradeSz *)buf;
        PrintTradeSz(p, ts);
    }

    break;
    case MSG_TYPE_ORDER:
    {
        OrderSz *p = (OrderSz *)buf;
        PrintOrderSz(p, ts);
    }
    break;
    case MSG_TYPE_AFTER_SNAP_SZ:
    {
        AfterSnapshotSz *p = (AfterSnapshotSz *)buf;
        PrintAfterSnapSz(p, ts);
    }
    break;
    case MSG_TYPE_BLOCKTRADE_SZ:
    {
        BlockTradeSz *p = (BlockTradeSz *)buf;
        PrintBlockTradeSz(p, ts);
    }
    break;
    case MSG_TYPE_TREE_SNAP_SZ:
    case MSG_TYPE_BOND_TREE_SNAP_SZ:
    {
        MarketDataTreeSnapSz *p = (MarketDataTreeSnapSz *)buf;
        PrintTreeSnapSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_TRADE:
    {
        BondTradeSz *p = (BondTradeSz *)buf;
        PrintBondTradeSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_BID_TRADE:
    {
        BondBidTradeSz *p = (BondBidTradeSz *)buf;
        PrintBondBidTradeSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_BLOCKTRADE:
    {
        BondBlockTradeSz *p = (BondBlockTradeSz *)buf;
        PrintBondBlockTradeSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_ORDER:
    {
        BondOrderSz *p = (BondOrderSz *)buf;
        PrintBondOrderSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_BID_ORDER:
    {
        BondBidOrderSz *p = (BondBidOrderSz *)buf;
        PrintBondBidOrderSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_BLOCKORDER:
    {
        BondBlockOrderSz *p = (BondBlockOrderSz *)buf;
        PrintBondBlockOrderSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_SNAPSHOT:
    {
        BondSnapshotSz *p = (BondSnapshotSz *)buf;
        PrintBondSnapSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_SNAP_SZ_L1:
    {
        L1BondSnapSz *p = (L1BondSnapSz *)buf;
        PrintL1BondSnapSz(p, ts);
    }
    break;
    case MSG_TYPE_SNAP_SZ_L1:
    {
        L1MarketDataSnapSz *p = (L1MarketDataSnapSz *)buf;
        PrintL1SnapSz(p, ts);
    }
    break;
    case MSG_TYPE_BOND_BEST_ORDERS:
    {
        BondBestOrdersSz *p = (BondBestOrdersSz *)buf;
        PrintBondBestOrdersSz(p, ts);
    }
    break;
    case MSG_TYPE_IOPV:
    {
        IOPVSnapshotSz *p = (IOPVSnapshotSz *)buf;
        PrintIOPVSz(p, ts);
    }
    break;
    default:
        break;
    }
}

void SzsePrinter::PrintL2SnapSz(MarketDataSnapshotSz *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_szse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu", p->messageType, p->sequence, p->exchangeID, 
    p->securityID, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, ",%lu,%lu,%ld,%lu", p->preClosePrice, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->lastPrice, p->openPrice, p->openInterest, p->highPrice);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->lowPrice, p->upperlmtPrice, p->lowerlmtPrice, p->bidAvgPrice);

    fprintf(file, ",%ld,%lu,%ld", p->bidTotalQty, p->askAvgPrice, p->askTotalQty);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }

    fprintf(file, ",%u,%u", p->channelNo, p->mdstreamid);

    fprintf(file, ",%lu", p->IOPV);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu", p->bidNumOfOrders[i]);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu", p->askNumOfOrders[i]);
    }

    fprintf(file, ",%lu,%lu,%lu,%lu", p->etfBidQty, p->etfBidNum, p->etfAskQty, p->etfAskNum);

    fprintf(file, "\n");
}

void SzsePrinter::PrintIOPVSz(IOPVSnapshotSz* p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_szse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu", p->messageType, p->sequence, p->exchangeID,
    p->securityID, p->tradingPhaseCode, p->timeStamp);
    fprintf(file, ",%lu", p->IOPV);
    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);   
}

void SzsePrinter::PrintTreeSnapSz(MarketDataTreeSnapSz *p, struct timespec ts)
{
    CheckFile(m_fp_tree_snap, "tree_szse.csv");
    FILE *file = m_fp_tree_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s", p->messageType, p->sequence, p->exchangeID, p->securityID);
    fprintf(file, ",%u", p->signLoss);
    fprintf(file, ",%lu", p->applSeqNum);
    fprintf(file, ",%lu", p->timeStamp);
    fprintf(file, ",%lu", p->preClosePrice);
    fprintf(file, ",%lu", p->numTrades);
    fprintf(file, ",%ld", p->totalVolumeTrade);
    fprintf(file, ",%lu", p->totalValueTrade);
    fprintf(file, ",%lu", p->lastPrice);
    fprintf(file, ",%lu", p->openPrice);
    fprintf(file, ",%lu", p->highPrice);
    fprintf(file, ",%lu", p->lowPrice);
    fprintf(file, ",%lu", p->upperlmtPrice);
    fprintf(file, ",%lu", p->lowerlmtPrice);
    fprintf(file, ",%ld", p->bidAvgPrice);
    fprintf(file, ",%ld", p->bidTotalQty);
    fprintf(file, ",%ld", p->askAvgPrice);
    fprintf(file, ",%ld", p->askTotalQty);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }
	    

    fprintf(file, "\n");
}

void SzsePrinter::PrintL1SnapSz(L1MarketDataSnapSz *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_szse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, ",%lu,%lu,%ld,%lu", p->preClosePrice, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->lastPrice, p->openPrice, p->openInterest, p->highPrice);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->lowPrice, p->upperlmtPrice, p->lowerlmtPrice, p->bidAvgPrice);

    fprintf(file, ",%ld,%lu,%ld", p->bidTotalQty, p->askAvgPrice, p->askTotalQty);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }

    fprintf(file, ",%u,%u", p->channelNo, p->mdstreamid);

    fprintf(file, ",%lu", p->IOPV);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu", p->bidNumOfOrders[i]);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu", p->askNumOfOrders[i]);
    }

    fprintf(file, ",%lu,%lu,%lu,%lu", p->etfBidQty, p->etfBidNum, p->etfAskQty, p->etfAskNum);

    fprintf(file, "\n");
}

void SzsePrinter::PrintOrderSz(OrderSz *p, struct timespec ts)
{
    CheckLost(p->channelNo, p->applSeqNum);
    CheckFile(m_fp_order, "order_szse.csv");
    FILE *file = m_fp_order;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%c,%lu,%lu,%lu,%ld,%u,%u\n", p->messageType, p->sequence,
            p->exchangeID, p->securityID, p->side, p->orderType, p->applSeqNum, p->transactTime, p->price, p->qty, p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintTradeSz(TradeSz *p, struct timespec ts)
{
    CheckLost(p->channelNo, p->applSeqNum);
    CheckFile(m_fp_trade, "trade_szse.csv");
    FILE *file = m_fp_trade;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u,%lu,%ld,%lu,%lu,%ld,%ld,%u,%u\n", p->messageType, p->sequence, p->exchangeID, p->securityID, p->execType, p->applSeqNum, p->transactTime, p->tradePrice, p->tradeQty, p->bidapplSeqnum, p->offerapplSeqnum, p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBlockTradeSz(BlockTradeSz *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_szse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->preClosePrice, p->bidPrice, p->bidQty, p->askPrice);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->askQty, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintIndexSz(IndexSz *p, struct timespec ts)
{
    CheckFile(m_fp_index, "index_szse.csv");
    FILE *file = m_fp_index;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu,", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, "%lu,", p->preClosePrice);
    fprintf(file, "%lu,", p->openPrice);
    fprintf(file, "%lu,", p->lastPrice);
    fprintf(file, "%lu,", p->highPrice);
    fprintf(file, "%lu,", p->lowPrice);
    fprintf(file, "%lu,", p->closePrice);
    fprintf(file, "%lu,", p->tradeNum);
    fprintf(file, "%lu,", p->totalVolume);
    fprintf(file, "%lu,", p->totalValue);

    fprintf(file, "%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintAfterSnapSz(AfterSnapshotSz *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_szse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u,%s,%lu", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, ",%lu,%lu,%ld,%lu", p->preClosePrice, p->bidPrice, p->bidQty, p->askPrice);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->askQty, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBondSnapSz(BondSnapshotSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_snap, "bond_snap_szse.csv");
    FILE *file = m_fp_bond_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, ",%lu,%lu,%ld,%lu", p->preClosePrice, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%lu,%lu,%lu,%lu,%lu", p->lastPrice, p->openPrice, p->highPrice, p->lowPrice, p->closePrice);

    fprintf(file, ",%lu,%lu,%ld,%lu,%ld", p->latestMatchPrice, p->bidAvgPrice, p->bidTotalQty, p->askAvgPrice, p->askTotalQty);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%s,%u", p->subStatus[i].SubTradingPhaseCode, p->subStatus[i].tradingType);
    }

    fprintf(file, ",%lu,%lu", p->auctionVolumeTrade, p->auctionValueTrade);

    fprintf(file, ",%u,%u", p->channelNo, p->mdstreamid);

    fprintf(file, ",%lu", p->IOPV);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu", p->bidNumOfOrders[i]);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%lu", p->askNumOfOrders[i]);
    }

    fprintf(file, "\n");
}

void SzsePrinter::PrintBondTradeSz(BondTradeSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_trade, "bond_trade_szse.csv");
    FILE *file = m_fp_bond_trade;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u,%lu,%ld,%lu,%lu,%lu,%lu", p->messageType, p->sequence, p->exchangeID, p->securityID, p->execType, p->applSeqNum, p->transactTime, p->tradePrice, p->tradeQty, p->bidapplSeqnum, p->offerapplSeqnum);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBondBlockTradeSz(BondBlockTradeSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_trade, "bond_trade_szse.csv");
    FILE *file = m_fp_bond_trade;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u,%lu,%ld,%lu,%lu,%lu,%lu,%u,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->execType, p->applSeqNum, p->transactTime, p->tradePrice, p->tradeQty, p->bidapplSeqnum, p->offerapplSeqnum, p->settlePeriod, p->settleType);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBondBidTradeSz(BondBidTradeSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_trade, "bond_trade_szse.csv");
    FILE *file = m_fp_bond_trade;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u,%lu,%ld,%lu,%lu,%lu,%lu,%lu,%s,%u,%u,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->execType, p->applSeqNum, p->transactTime, p->tradePrice, p->tradeQty, p->bidapplSeqnum, p->offerapplSeqnum, p->marginPrice, p->secondaryOrderID, p->settlePeriod, p->settleType, p->bidExecInstType);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBondOrderSz(BondOrderSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_order, "bond_order_szse.csv");
    FILE *file = m_fp_bond_order;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%c,%lu,%lu,%lu,%ld", p->messageType, p->sequence,
            p->exchangeID, p->securityID, p->side, p->orderType, p->applSeqNum, p->transactTime, p->price, p->qty);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBondBlockOrderSz(BondBlockOrderSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_order, "bond_order_szse.csv");
    FILE *file = m_fp_bond_order;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%lu,%lu,%lu,%lu", p->messageType, p->sequence,
            p->exchangeID, p->securityID, p->side, p->applSeqNum, p->transactTime, p->price, p->qty);

    fprintf(file, ",%s,%s,%s,%s,%s,%s,%u,%u", p->quoteID, p->memberID,
            p->investorType, p->investorID, p->investName, p->traderCode, p->settlePeriod, p->settleType);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintBondBidOrderSz(BondBidOrderSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_order, "bond_order_szse.csv");
    FILE *file = m_fp_bond_order;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%lu,%lu,%lu,%lu", p->messageType, p->sequence,
            p->exchangeID, p->securityID, p->side, p->applSeqNum, p->transactTime, p->price, p->qty);

    fprintf(file, ",%s,%s,%s,%s,%s", p->memberID,
            p->investorType, p->investorID, p->investName, p->traderCode);

    fprintf(file, ",%u,%u,%lu,%lu,%lu,%s,%u,%u,%u", p->bidTransType, p->bidExecInstType,
            p->lowLimitPrice, p->highLimitPrice, p->minQty, p->secondaryOrderID, p->tradeData, p->settlePeriod, p->settleType);

    fprintf(file, ",%u,%u\n", p->channelNo, p->mdstreamid);
}

void SzsePrinter::PrintL1BondSnapSz(L1BondSnapSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_snap, "bond_snap_szse.csv");
    FILE *file = m_fp_bond_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%lu", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradingPhaseCode, p->timeStamp);

    fprintf(file, ",%lu,%lu,%ld,%lu", p->preClosePrice, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%lu,%lu,%lu,%lu", p->lastPrice, p->openPrice, p->highPrice, p->lowPrice);

    fprintf(file, ",%lu,%lu,%lu,%ld,%lu,%ld", p->upperlmtPrice, p->lowerlmtPrice, p->bidAvgPrice, p->bidTotalQty, p->askAvgPrice, p->askTotalQty);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%s,%u", p->subStatus[i].SubTradingPhaseCode, p->subStatus[i].tradingType);
    }

    fprintf(file, ",%lu,%lu", p->auctionVolumeTrade, p->auctionValueTrade);

    fprintf(file, ",%u,%u", p->channelNo, p->mdstreamid);

    fprintf(file, ",%lu", p->IOPV);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu", p->bidNumOfOrders[i]);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%lu", p->askNumOfOrders[i]);
    }

    fprintf(file, "\n");
}

void SzsePrinter::PrintL2BestOrdersSz(BestOrdersSz *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_szse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%.6s,%lu,%d,", p->messageType, p->sequence, p->exchangeID, p->securityID, p->timeStamp, p->side);

    fprintf(file, "%d,", p->number);
    fprintf(file, "%lu,", p->price);
    fprintf(file, "%ld,", p->orders);
    fprintf(file, "%u,", p->channelNo);
    fprintf(file, "%u", p->mdstreamid);

    for (int i = 0; i < p->number; i++)
    {
        fprintf(file, ",%ld", p->volume[i]);
    }

    fprintf(file, "\n");
}

void SzsePrinter::PrintBondBestOrdersSz(BondBestOrdersSz *p, struct timespec ts)
{
    CheckFile(m_fp_bond_snap, "bond_snap_szse.csv");
    FILE *file = m_fp_bond_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);

    fprintf(file, "%u,%u,%u,%.6s,%lu,%d,", p->messageType, p->sequence, p->exchangeID, p->securityID, p->timeStamp, p->side);

    fprintf(file, "%d,", p->number);
    fprintf(file, "%lu,", p->price);
    fprintf(file, "%ld,", p->orders);
    fprintf(file, "%u,", p->channelNo);
    fprintf(file, "%u", p->mdstreamid);

    for (int i = 0; i < p->number; i++)
    {
        fprintf(file, ",%ld", p->volume[i]);
    }

    fprintf(file, "\n");
}

void SzsePrinter::CheckLost(uint32_t channel, uint64_t index)
{    
    auto it = m_channel_index_map.find(channel);

    if (it == m_channel_index_map.end())
    {
        m_channel_index_map.insert({channel, index});
    }
    else
    {
        if (index != (it->second  + 1))
        {
            CheckFile(m_fp_drop, "drop_szse.log");
            struct timespec ts;
            clock_gettime(CLOCK_REALTIME, &ts);
            struct tm *tmp = localtime(&ts.tv_sec);
            fprintf(m_fp_drop, "%02d%02d%02d channel %u, expert %lu, recv %lu\n", 
            tmp->tm_hour, tmp->tm_min, tmp->tm_sec, channel, it->second  + 1, index);
            fflush(m_fp_drop);
        }

        it->second = index; 
    }  
}
