#include "SzseSpi.h"

DemoSzseSpi::DemoSzseSpi()
{
}

DemoSzseSpi::~DemoSzseSpi()
{
}

int DemoSzseSpi::Init(int cpu_id, SzsePrinter *printer)
{
    m_printCpu = cpu_id;
    m_szsePrinter = printer;
    for (int i = 0; i < TICK_QUEUE_CNT; i++)
    {
        try
        {
            tickUdpQueue[i] = new SPSCQueueOPT<MSG_CONTENT, UDP_RINGBUFFER_SIZE>();
        }
        catch (...)
        {
            printf("UdpQueue init failed\n");
            return -1;
        }
    }

    for (int i = 0; i < OTHER_QUEUE_CNT; i++)
    {
        try
        {
            otherUdpQueue[i] = new SPSCQueueOPT<MSG_CONTENT, SMALL_RINGBUFFER_SIZE>();
        }
        catch (...)
        {
            printf("UdpQueue init failed\n");
            return -1;
        }
    }

    m_printThread = new std::thread(&DemoSzseSpi::PrintPacket, this);

    return 0;
}

void DemoSzseSpi::PrintPacket()
{
    MSG_CONTENT *pCurMsg;

    bindCpu(m_printCpu);

    struct timespec ts;

    while (true)
    {
        for (int i = 0; i < TICK_QUEUE_CNT; i++)
        {
            pCurMsg = tickUdpQueue[i]->front();

            if (!pCurMsg)
            {
                continue;
            }

            ts = pCurMsg->ts;

            m_szsePrinter->PrintSz(pCurMsg->buf, ts);
            tickUdpQueue[i]->pop();
        }

        for (int i = 0; i < OTHER_QUEUE_CNT; i++)
        {
            pCurMsg = otherUdpQueue[i]->front();

            if (!pCurMsg)
            {
                continue;
            }

            ts = pCurMsg->ts;

            m_szsePrinter->PrintSz(pCurMsg->buf, ts);
            otherUdpQueue[i]->pop();
        }
    }
}

void DemoSzseSpi::onMarketDataSnapshotSz(MarketDataSnapshotSz *p)
{
    CopyMsgToQueue(p, sizeof(MarketDataSnapshotSz), 0);
}

void DemoSzseSpi::onBestOrdersSz(BestOrdersSz *p)
{
    CopyMsgToQueue(p, sizeof(BestOrdersSz) + p->number * 8, 0);
}

void DemoSzseSpi::onL1MarketDataSnapSz(L1MarketDataSnapSz *p)
{
    CopyMsgToQueue(p, sizeof(L1MarketDataSnapSz), 0);
}

void DemoSzseSpi::onIOPVSz(IOPVSnapshotSz *p)
{
    CopyMsgToQueue(p, sizeof(IOPVSnapshotSz), 1);
}

void DemoSzseSpi::onBlockTradeSz(BlockTradeSz *p)
{
    CopyMsgToQueue(p, sizeof(BlockTradeSz), 2);
}

void DemoSzseSpi::onAfterSnapshotSz(AfterSnapshotSz *p)
{
    CopyMsgToQueue(p, sizeof(AfterSnapshotSz), 3);
}

void DemoSzseSpi::onIndexSz(IndexSz *p)
{
    CopyMsgToQueue(p, sizeof(IndexSz), 4);
}

void DemoSzseSpi::onTradeSz(TradeSz *p)
{
    CopyTickMsgToQueue(p, sizeof(TradeSz), 0);
}

void DemoSzseSpi::onOrderSz(OrderSz *p)
{
    CopyTickMsgToQueue(p, sizeof(OrderSz), 0);
}

void DemoSzseSpi::onBondSnapshotSz(BondSnapshotSz *p)
{
    CopyMsgToQueue(p, sizeof(BondSnapshotSz), 5);
}

void DemoSzseSpi::onBondBestOrdersSz(BondBestOrdersSz *p)
{
    CopyMsgToQueue(p, sizeof(BondBestOrdersSz) + p->number * 8, 5);
}

void DemoSzseSpi::onL1BondSnapSz(L1BondSnapSz *p)
{
    CopyMsgToQueue(p, sizeof(L1BondSnapSz), 5);
}

void DemoSzseSpi::onBondOrderSz(BondOrderSz *p)
{
    CopyTickMsgToQueue(p, sizeof(BondOrderSz), 1);
}

void DemoSzseSpi::onBondTradeSz(BondTradeSz *p)
{
    CopyTickMsgToQueue(p, sizeof(BondTradeSz), 1);
}

void DemoSzseSpi::onBondBlockTradeSz(BondBlockTradeSz *p)
{
    CopyTickMsgToQueue(p, sizeof(BondBlockTradeSz), 1);
}

void DemoSzseSpi::onBondBidTradeSz(BondBidTradeSz *p)
{
    CopyTickMsgToQueue(p, sizeof(BondBidTradeSz), 1);
}

void DemoSzseSpi::onBondBlockOrderSz(BondBlockOrderSz *p)
{
    CopyTickMsgToQueue(p, sizeof(BondBlockOrderSz), 1);
}

void DemoSzseSpi::onBondBidOrderSz(BondBidOrderSz *p)
{
    CopyTickMsgToQueue(p, sizeof(BondBidOrderSz), 1);
}

void DemoSzseSpi::onMarketDataTreeSnapSz(MarketDataTreeSnapSz *p)
{
    CopyTickMsgToQueue(p, sizeof(MarketDataTreeSnapSz), 2);
}

void DemoSzseSpi::onBondTreeSnapSz(MarketDataTreeSnapSz *p)
{
    CopyTickMsgToQueue(p, sizeof(MarketDataTreeSnapSz), 3);
}

inline void DemoSzseSpi::CopyMsgToQueue(void *p, uint64_t len, uint32_t queueIndex)
{
    MSG_CONTENT *pCurMsg = otherUdpQueue[queueIndex]->alloc();

    if (unlikely(!pCurMsg))
    {
        printf("UdpQueue Buffer is full\n");
        return;
    }

    clock_gettime(CLOCK_REALTIME, &pCurMsg->ts);

    memcpy(pCurMsg->buf, p, len);

    otherUdpQueue[queueIndex]->push();
}

inline void DemoSzseSpi::CopyTickMsgToQueue(void *p, uint64_t len, uint32_t queueIndex)
{
    MSG_CONTENT *pCurMsg = tickUdpQueue[queueIndex]->alloc();

    if (unlikely(!pCurMsg))
    {
        printf("tickUdpQueue Buffer is full\n");
        return;
    }

    clock_gettime(CLOCK_REALTIME, &pCurMsg->ts);

    memcpy(pCurMsg->buf, p, len);

    tickUdpQueue[queueIndex]->push();
}