#ifndef SSE_PRINTER_H
#define SSE_PRINTER_H
#include <map>
#include "SseXeleMdStruct.h"

#define PRICE_CONVERSION 0.00001
#define TOTAL_VALUE_CONVERSION 0.01

class SsePrinter
{
    public:
    //按结构体中的顺序落除保留字段外的所有字段
    void PrintSse(char* buf, struct timespec ts);

    void PrintAfterTradeSSe(AfterTradeSse *p, struct timespec ts);
    void PrintIndexSse(IndexSse *p, struct timespec ts);
    void PrintLevel2SnapSse(MarketDataSnapshotSse *p, struct timespec ts);
    void PrintBestOrderSse(BestOrdersSse *p, struct timespec ts);
    void PrintAfterSnapSse(AfterSnapshotSse *p, struct timespec ts);
    void PrintBondTickSse(BondTickSse *p, struct timespec ts);
    void PrintBondSnapshotSse(BondSnapshotSse *p, struct timespec ts);
    void PrintTickMergeSse(TickMergeSse *p, struct timespec ts);
    void PrintEtfSnapSse(ETFSnapshotSse *p, struct timespec ts);
    void PrintTreeSnapSse(MarketDataTreeSnapSse *p, struct timespec ts);
    void PrintStaticInfoSse(StaticInfoSse *p, struct timespec ts);

    void PrintSseL1(char* buf, struct timespec ts);
    void PrintSnapL1(StockBondSnapSseL1* p, struct timespec ts);
    void PrintIndexL1(IndexSseL1* p,struct timespec ts);
    void PrintOptionL1(OptionSseL1* p,struct timespec ts);
    void PrintFundL1(FundSseL1* p, struct timespec ts);
    void PrintAfterTradeL1(AfterTradeSseL1* p, struct timespec ts);
    void PrintNationalDebtL1(NationalDebtSseL1* p, struct timespec ts);
    void flush();

private:
    FILE* m_fp_snap = nullptr;     //csv中包含快照，盘后快照，最优50笔消息类型,etf统计
    FILE* m_fp_aft_trade = nullptr;        //csv中包含盘后逐笔成交类型
    FILE* m_fp_index = nullptr;      //csv中包含指数类型

    FILE* m_fp_bond_tick = nullptr;  //csv中包含债券逐笔类型
    FILE* m_fp_bond_snap = nullptr;  //csv中包含债券快照类型

    FILE* m_fp_tick_merge = nullptr;  //csv中包含逐笔合并类型
    FILE* m_fp_tree_snap = nullptr;   //csv中包含逐笔构建快照类型

    FILE* m_fp_l1 = nullptr;         //csv中包含所有L1消息

    FILE* m_fp_static = nullptr;

    void CheckLost(uint32_t channel, uint64_t index);

    std::map<uint64_t, uint64_t> m_channel_index_map;
    FILE* m_fp_sse_drop;
};
#endif