//
// 上交行情回调
//
#ifndef MD_SSE_SPI_H
#define MD_SSE_SPI_H
#include "XeleMdSpi.h"
#include "SPSCQueue.hpp"
#include "XeleCommon.h"
#include "SsePrinter.h"
#include <thread>

class DemoSseSpi : public XeleMdSseSpi
{
public:
    DemoSseSpi();
    ~DemoSseSpi();

    /**
     * @brief 从配置文件中初始化API模块
     * @param[in] strConfigFile 配置文件路径，默认从应用程序当前目录加载文件
     * @return 初始化执行结果
     *   @retval 0：初始化成功
     *   @retval -1：初始化失败，初始化失败后，应用程序应避免任何后续的API调用。
     **/
    int Init(int cpu_id, SsePrinter *printer);

    //上交L2股票快照
    virtual void onMarketDataSnapshotSse(MarketDataSnapshotSse *p);

    //上交L2订单详情
    virtual void onBestOrdersSse(BestOrdersSse *p);

    //上交L2指数
    virtual void onIndexSse(IndexSse *p);

    //上交股票盘后逐笔成交
    virtual void onAfterTradeSse(AfterTradeSse *p);

    //上交股票盘后快照
    virtual void onAfterSnapshotSse(AfterSnapshotSse *p);

    //上交L2债券快照
    virtual void onBondSnapshotSse(BondSnapshotSse *p);

    //上交债券逐笔
    virtual void onBondTickSse(BondTickSse *p);

    //上交逐笔合并
    virtual void onTickMergeSse(TickMergeSse *p);

    //上交EFT快照
    virtual void onETFSnapshotSse(ETFSnapshotSse *p);

    //上交逐笔转快照行情（订单簿）
	void onMarketDataTreeSnapSse(MarketDataTreeSnapSse* p);

    //上交债券逐笔转快照行情（订单簿）
	virtual void onBondTreeSnapSse(MarketDataTreeSnapSse* p);

    //上交静态行情
	virtual void onStaticInfoSse(StaticInfoSse* p);

    //==================== L1 ================================
    //上交L1指数
    virtual void onIndexSseL1(IndexSseL1 *p);

    //上交L1股票快照
    virtual void onStockSnapSseL1(StockBondSnapSseL1 *p);

    //上交L1债券分销快照，对应原始行情类别为MD003
    virtual void onBondSnapSseL1(StockBondSnapSseL1 *p);

    //上交L1基金快照
    virtual void onFundSseL1(FundSseL1 *p);

    //上交L1期权快照
    virtual void onOptionSseL1(OptionSseL1 *p);

    //上交L1国债快照
    virtual void onNationalDebtSseL1(NationalDebtSseL1 *p);

    //上交L1盘后固定价格
    virtual void onAfterTradeSseL1(AfterTradeSseL1 *p);

    //上交L1债券快照，对应原始行情类别为MD201
    virtual void onBond201SnapSseL1(StockBondSnapSseL1 *p);

    /*
    用三个较大的队列分别缓存股票逐笔、股票逐笔合并、债券的逐笔，
    其它较小的队列缓存其它类型消息
    */
    static const int TICK_QUEUE_CNT = 5;
    static const int OTHER_QUEUE_CNT = 7;
    SPSCQueueOPT<MSG_CONTENT, UDP_RINGBUFFER_SIZE> *tickUdpQueue[TICK_QUEUE_CNT];
    SPSCQueueOPT<MSG_CONTENT, SMALL_RINGBUFFER_SIZE> *otherUdpQueue[OTHER_QUEUE_CNT];

    void PrintPacket();

    int m_printCpu;
    SsePrinter *m_ssePrinter;
    std::thread *m_printThread;

private:
    inline void CopyMsgToQueue(void *p, uint64_t len, uint32_t queueIndex);
    inline void CopyTickMsgToQueue(void *p, uint64_t len, uint32_t queueIndex);
};

#endif
