#ifndef SZSE_PRINTER_H
#define SZSE_PRINTER_H
#include <map>
#include "SzseXeleMdStruct.h"


class  SzsePrinter
{
public:    
    //按结构体中的顺序落除保留字段外的所有字段
    void PrintSz(char* buf, struct timespec ts);
    void PrintTradeSz(TradeSz *p, struct timespec ts);
    void PrintBlockTradeSz(BlockTradeSz *p, struct timespec ts);
    void PrintOrderSz(OrderSz *p, struct timespec ts);
    void PrintIndexSz(IndexSz *p, struct timespec ts);
    void PrintL2SnapSz(MarketDataSnapshotSz *p, struct timespec ts);
    void PrintL1SnapSz(L1MarketDataSnapSz *p, struct timespec ts);
    void PrintAfterSnapSz(AfterSnapshotSz *p, struct timespec ts);
    void PrintTreeSnapSz(MarketDataTreeSnapSz* p, struct timespec ts);
    void PrintL2BestOrdersSz(BestOrdersSz* p, struct timespec ts);
    void PrintIOPVSz(IOPVSnapshotSz* p, struct timespec ts);

    void PrintBondSnapSz(BondSnapshotSz *p, struct timespec ts);
    void PrintL1BondSnapSz(L1BondSnapSz *p, struct timespec ts);
    void PrintBondBestOrdersSz(BondBestOrdersSz *p, struct timespec ts);   
    void PrintBondTradeSz(BondTradeSz *p, struct timespec ts);
    void PrintBondBlockTradeSz(BondBlockTradeSz *p, struct timespec ts);
    void PrintBondOrderSz(BondOrderSz *p, struct timespec ts);
    void PrintBondBlockOrderSz(BondBlockOrderSz *p, struct timespec ts);
    void PrintBondBidTradeSz(BondBidTradeSz *p, struct timespec ts);
    void PrintBondBidOrderSz(BondBidOrderSz *p, struct timespec ts);
    void flush();

private:
    FILE *m_fp_trade = nullptr;      //csv中包含逐笔成交和盘后逐笔成交类型
    FILE *m_fp_order = nullptr;    //csv中包含逐笔委托类型
    FILE *m_fp_index = nullptr;    //csv中包含指数类型
    FILE *m_fp_snap = nullptr;   //csv中包含L1、L2快照，盘后快照，最优50笔消息类型
	FILE *m_fp_tree_snap = nullptr; //csv中包含逐笔转快照类型

    FILE* m_fp_bond_trade = nullptr;  //csv中包含债券逐笔成交类型
    FILE* m_fp_bond_order = nullptr;  //csv中包含债券逐笔委托类型
    FILE* m_fp_bond_snap = nullptr;   //csv中包含债券L1、L2快照类型，债券最优50笔

    void CheckLost(uint32_t channel, uint64_t index);

    std::map<uint64_t, uint64_t> m_channel_index_map;

    FILE* m_fp_drop;
};

#endif