#include <map>
#include <stdio.h>
#include <string.h>
#include <string>

#include "SsePrinter.h"
#include "XeleCommon.h"

using namespace std;

void SsePrinter::flush()
{
    fflush(m_fp_snap);
    fflush(m_fp_aft_trade);
    fflush(m_fp_index);
    fflush(m_fp_bond_tick);
    fflush(m_fp_bond_snap);
    fflush(m_fp_tick_merge);
    fflush(m_fp_l1);
    fflush(m_fp_static);
}

void SsePrinter::PrintSse(char *buf, struct timespec ts)
{
    switch (buf[0])
    {
    case MSG_TYPE_SNAPSHOT:
    {
        MarketDataSnapshotSse *p = (MarketDataSnapshotSse *)buf;
        PrintLevel2SnapSse(p, ts);
    }
    break;
    case MSG_TYPE_BEST_ORDERS:
    {
        BestOrdersSse *p = (BestOrdersSse *)buf;
        PrintBestOrderSse(p, ts);
    }
    break;
    case MSG_TYPE_INDEX:
    {
        IndexSse *p = (IndexSse *)buf;
        PrintIndexSse(p, ts);
    }
    break;
    case MSG_TYPE_AFTER_TRADE_SSE:
    {
        AfterTradeSse *p = (AfterTradeSse *)buf;
        PrintAfterTradeSSe(p, ts);
    }
    break;
    case MSG_TYPE_AFTER_SNAP_SSE:
    {
        AfterSnapshotSse *p = (AfterSnapshotSse *)buf;
        PrintAfterSnapSse(p, ts);
    }
    break;
    case MSG_TYPE_BOND_SNAPSHOT:
    {
        BondSnapshotSse *p = (BondSnapshotSse *)buf;
        PrintBondSnapshotSse(p, ts);
    }
    break;
    case MSG_TYPE_BOND_TICK:
    {
        BondTickSse *p = (BondTickSse *)buf;
        PrintBondTickSse(p, ts);
    }
    break;
    case MSG_TYPE_TICK_MERGE:
    {
        TickMergeSse *p = (TickMergeSse *)buf;
        PrintTickMergeSse(p, ts);
    }
    break;
    case MSG_TYPE_ETF_SNAPSHOT:
    {
        ETFSnapshotSse *p = (ETFSnapshotSse *)buf;
        PrintEtfSnapSse(p, ts);
    }
    break;
    case MSG_TYPE_TREE_SNAP_SSE:
    case MSG_TYPE_BOND_TREE_SNAP_SSE:
    {
        MarketDataTreeSnapSse *p = (MarketDataTreeSnapSse *)buf;
        PrintTreeSnapSse(p, ts);
    }
    break;
    case MSG_TYPE_STATIC_SSE:
    {
        StaticInfoSse *p = (StaticInfoSse *)buf;
        PrintStaticInfoSse(p, ts);
    }
    break;
    default:
        break;
    }
}

void SsePrinter::PrintSseL1(char *buf, struct timespec ts)
{
    switch (buf[0])
    {
    case MSG_TYPE_INDEX_SSE_L1:
    {
        IndexSseL1 *p = (IndexSseL1 *)buf;
        PrintIndexL1(p, ts);
    }
    break;
    case MSG_TYPE_STOCK_SNAP_SSE_L1:
    case MSG_TYPE_BOND_SNAP_SSE_L1:
    case MSG_TYPE_MD201_BOND_SNAP:
    {
        StockBondSnapSseL1 *p = (StockBondSnapSseL1 *)buf;
        PrintSnapL1(p, ts);
    }
    break;
    case MSG_TYPE_FUND_SSE_L1:
    case MSG_TYPE_IOPV_L1:
    {
        FundSseL1 *p = (FundSseL1 *)buf;
        PrintFundL1(p, ts);
    }
    break;
    case MSG_TYPE_OPTION_SSE_L1:
    {
        OptionSseL1 *p = (OptionSseL1 *)buf;
        PrintOptionL1(p, ts);
    }
    break;
    case MSG_TYPE_NATIONAL_DEBT_SSE_L1:
    {
        NationalDebtSseL1 *p = (NationalDebtSseL1 *)buf;
        PrintNationalDebtL1(p, ts);
    }
    break;
    case MSG_TYPE_AFTER_TRADE_SSE_L1:
    {
        AfterTradeSseL1 *p = (AfterTradeSseL1 *)buf;
        PrintAfterTradeL1(p, ts);
    }
    break;
    default:
        break;
    }
}

void SsePrinter::PrintLevel2SnapSse(MarketDataSnapshotSse *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_sse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradingPhaseCode, p->instrumentStatus, p->timeStamp);

    fprintf(file, ",%u,%u,%ld,%lu", p->preClosePrice, p->numTrades, p->totalVolumeTrade, p->totalValueTrade);

    fprintf(file, ",%u,%u,%u,%u,%u,%lu", p->lastPrice, p->openPrice, p->closePrice, p->highPrice, p->lowPrice, p->IOPV);

    fprintf(file, ",%lu,%u,%lu,%u,%lu", p->warUpperPx, p->bidAvgPrice, p->bidTotalQty, p->askAvgPrice, p->askTotalQty);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%u,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%u,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }

    fprintf(file, ",%u", p->msgSeqID);
    fprintf(file, ",%u,%lu,%lu", p->withdrawBuyNum, p->withdrawBuyAmount, p->withdrawBuyMoney);
    fprintf(file, ",%u,%lu,%lu\n", p->withdrawSellNum, p->withdrawSellAmount, p->withdrawSellMoney);
}

void SsePrinter::PrintBestOrderSse(BestOrdersSse *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_sse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->timeStamp);

    fprintf(file, ",%u", p->side);
    fprintf(file, ",%u", p->number);
    fprintf(file, ",%u", p->price);
    fprintf(file, ",%lu", p->orders);

    for (int i = 0; i < p->number; ++i)
    {
        fprintf(file, ",%lu", p->volume[i]);
    }
    fprintf(file, "\n");
}

void SsePrinter::PrintAfterTradeSSe(AfterTradeSse *p, struct timespec ts)
{
    CheckFile(m_fp_aft_trade, "aft_trade_sse.csv");
    FILE *file = m_fp_aft_trade;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%d,%u,%u,%u,%lu,%lu,%lu,%lu,%u\n", p->messageType, p->sequence, p->exchangeID, p->securityID, p->tradeBSFlag, p->tradeIndex, p->channelNo, p->transactTime, p->tradePrice, p->tradeQty, p->tradeMoney, p->bidapplSeqnum, p->offerapplSeqnum, p->msgSeqID);
}

void SsePrinter::PrintIndexSse(IndexSse *p, struct timespec ts)
{
    CheckFile(m_fp_index, "index_sse.csv");
    FILE *file = m_fp_index;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u,", p->messageType, p->sequence, p->exchangeID, p->securityID, p->timeStamp);
    fprintf(file, "%u,", p->tradeTime);
    fprintf(file, "%u,", p->msgSeqID);
    fprintf(file, "%lu,", p->preClosePrice);
    fprintf(file, "%lu,", p->openPrice);
    fprintf(file, "%lu,", p->lastPrice);
    fprintf(file, "%lu,", p->highPrice);
    fprintf(file, "%lu,", p->lowPrice);
    fprintf(file, "%lu,", p->closePrice);
    fprintf(file, "%lu,", p->totalVolume);
    fprintf(file, "%lu\n", p->totalValue);
}

void SsePrinter::PrintAfterSnapSse(AfterSnapshotSse *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_sse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%u,", p->messageType, p->sequence, p->exchangeID, p->securityID, p->instrumentStatus, p->timeStamp);
    fprintf(file, "%u,%u,%ld,%lu,%lu,%lu", p->closePrice, p->numTrades, p->totalVolumeTrade, p->totalValueTrade, p->totalBidQty, p->totalAskQty);
    fprintf(file, ",%u,%lu,%u,%lu,%u,%u,%u", p->withdrawBuyNumber, p->withdrawBuyAmount, p->withdrawSellNumber, p->withdrawSellAmount, p->msgSeqID, p->noBidLevel, p->noOfferLevel);
    fprintf(file, ",%lu,%lu,%lu,%lu\n", p->bidQty, p->askQty, p->bidOrderNum, p->askOrderNum);
}

void SsePrinter::PrintBondSnapshotSse(BondSnapshotSse *p, struct timespec ts)
{
    CheckFile(m_fp_bond_snap, "bond_snap_sse.csv");
    FILE *file = m_fp_bond_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->instrumentStatus, p->timeStamp);

    fprintf(file, ",%u,%u,%u,%u,%u,%u", p->preClosePrice, p->openPrice, p->highPrice, p->lowPrice, p->lastPrice, p->closePrice);

    fprintf(file, ",%u,%ld,%lu", p->numTrades, p->totalVolumeTrade, p->totalValueTrade);
    fprintf(file, ",%ld,%u,%ld,%u,%u", p->bidTotalQty, p->bidAvgPrice, p->askTotalQty, p->askAvgPrice, p->avgPrice);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%u,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%u,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }

    fprintf(file, ",%u", p->msgSeqID);
    fprintf(file, ",%u,%lu,%lu", p->withdrawBuyNum, p->withdrawBuyAmount, p->withdrawBuyMoney);
    fprintf(file, ",%u,%lu,%lu\n", p->withdrawSellNum, p->withdrawSellAmount, p->withdrawSellMoney);
}

void SsePrinter::PrintBondTickSse(BondTickSse *p, struct timespec ts)
{
    CheckFile(m_fp_bond_tick, "bond_tick_sse.csv");
    FILE *file = m_fp_bond_tick;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%c,%u,%u,%u,%lu,%lu,%u,%lu,%lu,%u", 
    p->messageType, p->sequence, p->exchangeID, p->securityID, p->tickType,
    p->tickBSFlag, p->tickIndex, p->channelNo, p->tickTime, p->buyOrderNo,
    p->sellOrderNo, p->price, p->qty, p->tradeMoney, p->msgSeqID);
    fprintf(file, ",%u\n", p->isLast);
}

void SsePrinter::PrintTickMergeSse(TickMergeSse *p, struct timespec ts)
{
    CheckFile(m_fp_tick_merge, "tick_merge_sse.csv");
    CheckLost(p->channelNo, p->bizIndex);
    FILE *file = m_fp_tick_merge;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%c,%c,%lu,%u,%u,%lu,%lu,%u,%lu,%lu,%u", 
    p->messageType, p->sequence, p->exchangeID, p->securityID, p->tickType, 
    p->tickBSFlag, p->bizIndex, p->channelNo, p->tickTime, p->buyOrderNo, p->sellOrderNo,
    p->price, p->qty, p->tradeMoney, p->msgSeqID);
    fprintf(file, ",%u\n", p->isLast);
}

void SsePrinter::PrintEtfSnapSse(ETFSnapshotSse *p, struct timespec ts)
{
    CheckFile(m_fp_snap, "snap_sse.csv");
    FILE *file = m_fp_snap;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->timeStamp);

    fprintf(file, ",%u,%lu,%lu", p->etfBuyNum, p->etfBuyAmount, p->etfBuyMoney);

    fprintf(file, ",%u,%lu,%lu,%u\n", p->etfSellNum, p->etfSellAmount, p->etfSellMoney, p->msgSeqID);
}

void SsePrinter::PrintStaticInfoSse(StaticInfoSse *p, struct timespec ts)
{
    CheckFile(m_fp_static, "static_sse.csv");
    fprintf(m_fp_static, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(m_fp_static, "%u,%u,%u,%s", p->messageType, p->sequence, p->exchangeID, p->securityID);
    fprintf(m_fp_static, ",%f", p->upperLimitPrice);
    fprintf(m_fp_static, ",%f", p->lowerLimitPrice);
    fprintf(m_fp_static, "\n");
}

void SsePrinter::PrintSnapL1(StockBondSnapSseL1 *p, struct timespec ts)
{
    CheckFile(m_fp_l1, "l1_sse.csv");
    FILE *file = m_fp_l1;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%d,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag);

    fprintf(file, ",%u,%u,%lu,%u,%u", p->securityType, p->tradSesMode, p->sendingTime, p->tradeDate, p->lastUpdateTime);

    fprintf(file, ",%.5f,%lu,%lu,%.2f,%s", p->preClosePrice * PRICE_CONVERSION, p->totalVolumeTraded, p->tradeNum,
            p->totalValueTraded * TOTAL_VALUE_CONVERSION, p->tradingPhaseCode);

    fprintf(file, ",%.5f", p->lastPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->openPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->closePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->settlePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->highPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->lowPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->preSettlePrice * PRICE_CONVERSION);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->bidPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->bidPriceQty[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->askPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->askPriceQty[i].qty);
    }

    fprintf(file, "\n");
}

void SsePrinter::PrintIndexL1(IndexSseL1 *p, struct timespec ts)
{
    CheckFile(m_fp_l1, "l1_sse.csv");
    FILE *file = m_fp_l1;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%d,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag);

    fprintf(file, ",%u,%u,%lu,%u,%u", p->securityType, p->tradSesMode, p->sendingTime, p->tradeDate, p->lastUpdateTime);

    fprintf(file, ",%.5f,%lu,%lu,%.2f,%s", p->preClosePrice * PRICE_CONVERSION, p->totalVolumeTraded, p->tradeNum,
            p->totalValueTraded * TOTAL_VALUE_CONVERSION, p->tradingPhaseCode);

    fprintf(file, ",%.5f", p->lastIndex * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->openIndex * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->closeIndex * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->highIndex * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->lowIndex * PRICE_CONVERSION);
    fprintf(file, "\n");
}

void SsePrinter::PrintOptionL1(OptionSseL1 *p, struct timespec ts)
{
    CheckFile(m_fp_l1, "l1_sse.csv");
    FILE *file = m_fp_l1;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%d,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag);

    fprintf(file, ",%u,%u,%lu,%u,%u", p->securityType, p->tradSesMode, p->sendingTime, p->tradeDate, p->lastUpdateTime);

    fprintf(file, ",%.5f,%lu,%lu,%.2f,%s", p->preClosePrice * PRICE_CONVERSION, p->totalVolumeTraded, p->tradeNum,
            p->totalValueTraded * TOTAL_VALUE_CONVERSION, p->tradingPhaseCode);

    fprintf(file, ",%.5f", p->lastPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->openPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->closePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->settlePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->highPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->lowPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->preSettlePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->auctionPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->auctionQty * PRICE_CONVERSION);
    fprintf(file, ",%lu", p->totalLongPosition);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->bidPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->bidPriceQty[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->askPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->askPriceQty[i].qty);
    }

    fprintf(file, "\n");
}

void SsePrinter::PrintFundL1(FundSseL1 *p, struct timespec ts)
{
    CheckFile(m_fp_l1, "l1_sse.csv");
    FILE *file = m_fp_l1;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%d,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag);

    fprintf(file, ",%u,%u,%lu,%u,%u", p->securityType, p->tradSesMode, p->sendingTime, p->tradeDate, p->lastUpdateTime);

    fprintf(file, ",%.5f,%lu,%lu,%.2f,%s", p->preClosePrice * PRICE_CONVERSION, p->totalVolumeTraded, p->tradeNum,
            p->totalValueTraded * TOTAL_VALUE_CONVERSION, p->tradingPhaseCode);

    fprintf(file, ",%.5f", p->lastPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->openPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->closePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->settlePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->highPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->lowPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->preSettlePrice * PRICE_CONVERSION);

    fprintf(file, ",%.5f", p->IOPV * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->preCloseIOPV * PRICE_CONVERSION);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->bidPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->bidPriceQty[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->askPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->askPriceQty[i].qty);
    }

    fprintf(file, "\n");
}

void SsePrinter::PrintAfterTradeL1(AfterTradeSseL1 *p, struct timespec ts)
{
    CheckFile(m_fp_l1, "l1_sse.csv");
    FILE *file = m_fp_l1;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%d,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag);

    fprintf(file, ",%u,%u,%lu,%u,%u", p->securityType, p->tradSesMode, p->sendingTime, p->tradeDate, p->lastUpdateTime);

    fprintf(file, ",%.5f,%lu,%lu,%.2f,%s", p->preClosePrice * PRICE_CONVERSION, p->totalVolumeTraded, p->tradeNum,
            p->totalValueTraded * TOTAL_VALUE_CONVERSION, p->tradingPhaseCode);

    fprintf(file, ",%lu", p->notTradedBidVolume);
    fprintf(file, ",%lu", p->notTradedAskVolume);
    fprintf(file, ",%.5f", p->closePrice * PRICE_CONVERSION);

    fprintf(file, "\n");
}

void SsePrinter::PrintNationalDebtL1(NationalDebtSseL1 *p, struct timespec ts)
{
    CheckFile(m_fp_l1, "l1_sse.csv");
    FILE *file = m_fp_l1;
    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%d,%s,%u", p->messageType, p->sequence, p->exchangeID, p->securityID, p->flag);

    fprintf(file, ",%u,%u,%lu,%u,%u", p->securityType, p->tradSesMode, p->sendingTime, p->tradeDate, p->lastUpdateTime);

    fprintf(file, ",%.5f,%lu,%lu,%.2f,%s", p->preClosePrice * PRICE_CONVERSION, p->totalVolumeTraded, p->tradeNum,
            p->totalValueTraded * TOTAL_VALUE_CONVERSION, p->tradingPhaseCode);

    fprintf(file, ",%.5f", p->lastPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->openPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->closePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->settlePrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->highPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->lowPrice * PRICE_CONVERSION);
    fprintf(file, ",%.5f", p->preSettlePrice * PRICE_CONVERSION);

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->bidPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->bidPriceQty[i].qty);
    }

    for (int i = 0; i < 5; i++)
    {
        fprintf(file, ",%.5f", p->askPriceQty[i].price * PRICE_CONVERSION);
        fprintf(file, ",%lu", p->askPriceQty[i].qty);
    }

    fprintf(file, "\n");
}

void SsePrinter::PrintTreeSnapSse(MarketDataTreeSnapSse *p, struct timespec ts)
{
    CheckFile(m_fp_tree_snap, "tree_sse.csv");
    FILE *file = m_fp_tree_snap;

    fprintf(file, "%ld,", ts.tv_sec * 1000000000 + ts.tv_nsec);
    fprintf(file, "%u,%u,%u,%s", p->messageType, p->sequence, p->exchangeID, p->securityID);
    fprintf(file, ",%u", p->signLoss);
    fprintf(file, ",%lu", p->applSeqNum);
    fprintf(file, ",%u", p->timeStamp);
    fprintf(file, ",%u", p->preClosePrice);
    fprintf(file, ",%u", p->numTrades);
    fprintf(file, ",%lu", p->totalVolumeTrade);
    fprintf(file, ",%lu", p->totalValueTrade);
    fprintf(file, ",%u", p->lastPrice);
    fprintf(file, ",%u", p->openPrice);
    fprintf(file, ",%u", p->highPrice);
    fprintf(file, ",%u", p->lowPrice);
    fprintf(file, ",%u", p->bidAvgPrice);
    fprintf(file, ",%lu", p->bidTotalQty);
    fprintf(file, ",%u", p->askAvgPrice);
    fprintf(file, ",%lu", p->askTotalQty);

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%u,%lu", p->bidInfo[i].price, p->bidInfo[i].qty);
    }

    for (int i = 0; i < 10; i++)
    {
        fprintf(file, ",%u,%lu", p->askInfo[i].price, p->askInfo[i].qty);
    }
    fprintf(file, "\n");
}

void SsePrinter::CheckLost(uint32_t channel, uint64_t index)
{
    auto it = m_channel_index_map.find(channel);

    if (it == m_channel_index_map.end())
    {
        m_channel_index_map.insert({channel, index});
    }
    else
    {
        if (index != (it->second + 1))
        {
            CheckFile(m_fp_sse_drop, "drop_sse.log");
            struct timespec ts;
            clock_gettime(CLOCK_REALTIME, &ts);
            struct tm *tmp = localtime(&ts.tv_sec);
            fprintf(m_fp_sse_drop, "%02d%02d%02d channel %u, expert %lu, recv %lu\n",
                    tmp->tm_hour, tmp->tm_min, tmp->tm_sec, channel, it->second + 1, index);
            fflush(m_fp_sse_drop);
        }

        it->second = index;
    }
}
