#include "XeleCommon.h"
#include <string>

using namespace std;

int bindCpu(int i)
{
    if (i < 0)
        return -1;
    cpu_set_t mask;
    CPU_ZERO(&mask);
    
    CPU_SET(i, &mask);
    
    if (-1 == pthread_setaffinity_np(pthread_self(), sizeof(mask), &mask))
    {
        fprintf(stderr, "pthread_setaffinity_np erro\n");
        return -1;
    }
    return 0;
}

//鉴权
void ProcessAuth(xini_file_t &xini_file, XeleMd *xeleMd)
{
    std::string strIp = xini_file["auth_info"]["tcp_ipaddr"];
    uint16_t uPort = xini_file["auth_info"]["tcp_port"];
    std::string strUsername = xini_file["auth_info"]["username"];
    std::string strPasswd = xini_file["auth_info"]["password"];
    std::string strEth = xini_file["channel1"]["interface_name"];
    
    if (strIp.empty() || uPort == 0 || strUsername.empty() || strPasswd.empty() || strEth.empty())
    {
        return;
    }
    
    struct LoginReq login_req = {0};
    memcpy(login_req.server_ip, strIp.data(), strIp.size());
    login_req.server_port = uPort;
    memcpy(login_req.username, strUsername.data(), strIp.size());
    memcpy(login_req.password, strPasswd.data(), strIp.size());
    memcpy(login_req.eth_name, strEth.data(), strIp.size());
    
    LoginRsp login_rsp{};
    struct MulticastAddr *addrBegin;
    if (!xeleMd->Login(&login_req, &login_rsp, &addrBegin))
    {
        printf("switch to backup auth server...");
        //鉴权失败，尝试登录备用鉴权服务器
        string strBackIp = xini_file["auth_info"]["backup_tcp_ipaddr"];
        uPort = xini_file["auth_info"]["backup_tcp_port"];
        
        if (!strBackIp.empty() && uPort > 0)
        {
            memcpy(login_req.server_ip, strBackIp.data(), strBackIp.size());
            login_req.server_port = uPort;
            
            if (!xeleMd->Login(&login_req, &login_rsp, &addrBegin))
            {
                printf("ReqUserLogin return false,exit!\n");
                exit(0);
            }
        }
        else
        {
            printf("ReqUserLogin return false,exit!\n");
            exit(0);
        }
    }
    
    printf("Login Success\n");
    
    printf("num addr = %u\n", login_rsp.numAddr);
    auto tempPtr = addrBegin;
    /*  登录响应会返回所有组播地址，比如对于上交行情，在上海和在深圳收组播地址不同，同时又有主备的区别，
    **  请根据实际情况加入组播组，不要重复添加，否则会收到重复的数据。  
    */
    for (unsigned int i = 0; i < login_rsp.numAddr; i++)
    {
        printf("md_system = %#010x, ip = %s, port = %hu, md_type = %s\n",
              tempPtr->md_system, tempPtr->ip, tempPtr->port, tempPtr->md_type);
              tempPtr++;
    }
    
    return;
}

void InitChannel(xini_file_t &xini_file, const char* channel_name, MdParam& param)
{
    memset(&param, 0, sizeof(MdParam));
    string channelName(channel_name);
    printf("Init channle %s\n", channelName.data());
    string strEth = xini_file[channelName]["interface_name"];
    string strEthIp = xini_file[channelName]["interface_ip"];
    string strMcastIp = xini_file[channelName]["mcast_ip"];
    strcpy(param.m_interfaceName, strEth.c_str());
    strcpy(param.m_localIp, strEthIp.c_str());
    strcpy(param.m_mcastIp, strMcastIp.c_str());
    param.m_mcastPort = xini_file[channelName]["mcast_port"];
    
    printf("interface_name : %s, interface_ip : %s, mcast_addr : %s:%u\n", strEth.c_str(),
    strEthIp.c_str(), strMcastIp.c_str(), param.m_mcastPort);
    
    param.m_backupMcastPort = xini_file[channelName]["back_mcast_port"];
    
    if (param.m_backupMcastPort)
    {
        string strBackEthIp = xini_file[channelName]["back_interface_ip"];
        string strBackEth = xini_file[channelName]["back_interface_name"];
        string strbackMcastIp = xini_file[channelName]["back_mcast_ip"];
        strcpy(param.m_backupIntName, strBackEth.c_str());
        strcpy(param.m_backupLocalIp, strBackEthIp.c_str());
        strcpy(param.m_backupMcastIp, strbackMcastIp.c_str());
        
        int nic_type = xini_file[channelName]["back_nic_type"];
        param.m_backupNicType = (ENicType)nic_type;
        param.m_backupCpuId = xini_file[channelName]["back_cpu_id"];
        
        string strbackSwitchTime = xini_file[channelName]["back_switch_time"];
        
        printf("back interface_name: %s, interface_ip: %s, mcast_addr : %s:%u, switch time: %s\n",
        strBackEth.data(), strBackEthIp.data(), strbackMcastIp.data(), param.m_backupMcastPort, strbackSwitchTime.data());
        
        if (!strbackSwitchTime.empty())
        {
            param.m_backupSwitchTime = stoi(strbackSwitchTime);
        }
    }
    
    param.m_bindCpuId = xini_file[channelName]["bind_cpu_id"];
    
    int nic_type = xini_file[channelName]["nic_type"];
    param.m_nicType = (ENicType)nic_type;
    
    std::string strIsPolling = xini_file[channelName]["is_polling"];
    if (!strIsPolling.empty())
    {
        param.m_polling = strIsPolling == "true" ? true : false;
    }
    
    param.m_cache = xini_file[channelName]["cache_size"];
    param.m_cacheCpuId = xini_file[channelName]["cache_cpu_id"];
    
    param.m_tickToSnap = xini_file[channelName]["tick_to_snap"];
    param.m_rxMerge = xini_file[channelName]["use_merge"];
    
    if (param.m_tickToSnap)
    {  
        param.m_tickSnapCpuId = xini_file[channelName]["tick_to_snap_cpu"];
        
        string strSubFile = xini_file[channelName]["tick_to_snap_subscribe"];
        if (!strSubFile.empty())
        {
        memcpy(param.m_tickSnapSubscribe, strSubFile.data(), strSubFile.size());
        }
    }
    
    param.m_lastFlag = xini_file[channelName]["mark_last"];
}

void CheckFile(FILE*& file, const char* file_name)
{
    if (file)
    {
        return;
    }

    time_t now = time(NULL);
    tm *ltm = localtime(&now);

    char str_full_name[128];
    memset(str_full_name, 0, sizeof(str_full_name));
    sprintf(str_full_name, "%04d%02d%02d_%s", ltm->tm_year + 1900, ltm->tm_mon + 1, ltm->tm_mday, file_name);

    file = fopen(str_full_name, "w+");
    if (!file)
    {
        printf("Creat file %s failed, program exit\n", str_full_name);
        exit(-1);
    }
    return;
}
