//
// 上交行情回调
//
#ifndef MD_SZSE_SPI_H
#define MD_SZSE_SPI_H
#include "XeleMdSpi.h"
#include "SPSCQueue.hpp"
#include "XeleCommon.h"
#include "SzsePrinter.h"
#include <thread>

class DemoSzseSpi : public XeleMdSzseSpi
{
public:
    DemoSzseSpi();
    ~DemoSzseSpi();

    /**
     * @brief 从配置文件中初始化API模块
     * @param[in] strConfigFile 配置文件路径，默认从应用程序当前目录加载文件
     * @return 初始化执行结果
     *   @retval 0：初始化成功
     *   @retval -1：初始化失败，初始化失败后，应用程序应避免任何后续的API调用。
     **/
    int Init(int cpu_id, SzsePrinter *printer);

    //深交股票L2快照
    virtual void onMarketDataSnapshotSz(MarketDataSnapshotSz *p);

    //深交逐笔转快照行情
    virtual void onMarketDataTreeSnapSz(MarketDataTreeSnapSz *p);

    //深交订单详情
    virtual void onBestOrdersSz(BestOrdersSz *p);

    //深交指数行情
    virtual void onIndexSz(IndexSz *p);

    //深交逐笔成交
    virtual void onTradeSz(TradeSz *p);

    //深交逐笔委托
    virtual void onOrderSz(OrderSz *p);

    //深交股票L2盘后快照
    virtual void onAfterSnapshotSz(AfterSnapshotSz *p);

    //深交股票L1快照
    virtual void onL1MarketDataSnapSz(L1MarketDataSnapSz *p);

    //深交基金实时参考值
    virtual void onIOPVSz(IOPVSnapshotSz *p);

    //深交盘后大宗成交快照
    virtual void onBlockTradeSz(BlockTradeSz *p);

    //深交债券L2快照
    virtual void onBondSnapshotSz(BondSnapshotSz *p);

    //深交债券逐笔转快照行情（订单簿）
	virtual void onBondTreeSnapSz(MarketDataTreeSnapSz* p);

    //深交债券订单详情
    virtual void onBondBestOrdersSz(BondBestOrdersSz *p);

    //深交债券逐笔成交
    virtual void onBondTradeSz(BondTradeSz *p);

    //深交债券大额逐笔成交
    virtual void onBondBlockTradeSz(BondBlockTradeSz *p);

    //深交债券竞买逐笔成交
    virtual void onBondBidTradeSz(BondBidTradeSz *p);

    //深交债券逐笔委托
    virtual void onBondOrderSz(BondOrderSz *p);

    //深交债券大额逐笔委托
    virtual void onBondBlockOrderSz(BondBlockOrderSz *p);

    //深交债券竞买逐笔委托
    virtual void onBondBidOrderSz(BondBidOrderSz *p);

    //深交债券L1快照
    virtual void onL1BondSnapSz(L1BondSnapSz *p);

    /*
    用三个容量较大的队列分别缓存股票逐笔、债券的逐笔、逐笔构建快照消息，
    其它较小的队列缓存其它类型消息
    */
    static const int TICK_QUEUE_CNT = 4;
    static const int OTHER_QUEUE_CNT = 6;
    SPSCQueueOPT<MSG_CONTENT, UDP_RINGBUFFER_SIZE> *tickUdpQueue[TICK_QUEUE_CNT];
    SPSCQueueOPT<MSG_CONTENT, SMALL_RINGBUFFER_SIZE> *otherUdpQueue[OTHER_QUEUE_CNT];

    void PrintPacket();

    int m_printCpu;
    SzsePrinter *m_szsePrinter;
    std::thread *m_printThread;

private:
    inline void CopyMsgToQueue(void *p, uint64_t len, uint32_t queueIndex);
    inline void CopyTickMsgToQueue(void *p, uint64_t len, uint32_t queueIndex);
};
#endif
