#ifndef _XELE_COMMON_H_
#define _XELE_COMMON_H_
#include <time.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>
#include <thread>
#include "XeleMd.h"
#include "ConfigFile.h"


#define MAX_MSG_LEN 712

typedef struct _MSG_CONTENT
{    
    struct timespec ts;
    char buf[MAX_MSG_LEN];
}MSG_CONTENT;

static inline bool(likely)(bool x) { return __builtin_expect((x), true); }
static inline bool(unlikely)(bool x) { return __builtin_expect((x), false); }

int bindCpu(int i);
//登录鉴权系统
void ProcessAuth(xini_file_t &xini_file, XeleMd* xeleMd);
//根据配置文件构造初始化参数
void InitChannel(xini_file_t &xini_file, const char* channel_name, MdParam& param);
//判断文件是否已创建，如果没有则创建
void CheckFile(FILE*& file, const char* file_name);

#endif
