#include <unistd.h>
#include <signal.h>
#include "XeleMd.h"
#include "ConfigFile.h"
#include <stdio.h>
#include <string.h>
#include "SseSpi.h"
#include "SzseSpi.h"
#include <string>

using namespace std;

SsePrinter *ssePrinter = nullptr;
SzsePrinter *szsePrinter = nullptr;

void stop(int sig)
{
    printf("==========force stop==========\n");
    
    if (ssePrinter)
    {
        ssePrinter->flush();
    }
    
    if (szsePrinter)
    {
        szsePrinter->flush();
    }
    
    exit(0);
}


int main()
{
    printf("[md_xele_demo] main begin.\n");
    signal(SIGINT, stop);
    
    xini_file_t xini_file("../md_xele.conf");
    XeleMd* xeleMd = XeleMd::CreatInstance();
    //用户鉴权
    ProcessAuth(xini_file, xeleMd);
    
    // 根据配置传入多组组播参数
    int channelCnt = xini_file["common"]["channel_num"];
    printf("channel count %d\n", channelCnt);
    
    MdParam param[channelCnt];
    for (int i = 0; i < channelCnt; i++)
    {
        string channelName = "channel" + to_string(i + 1);
        InitChannel(xini_file, channelName.data(), param[i]);
    }
    xeleMd->Init(param, channelCnt);
    
    int enable_sse = xini_file["common"]["enable_sse"];
    if (enable_sse == 1)
    {
	    auto ssePrinter = new SsePrinter();
	    DemoSseSpi *pSpi = new DemoSseSpi();
	    
	    int printCpu = xini_file["common"]["print_sse_cpu_id"];
	    if (pSpi->Init(printCpu, ssePrinter) != 0)
	    {
	        exit(-1);
	    }
	    
	    xeleMd->RegisterSseSpi(pSpi);
    }
    
    int enable_szse = xini_file["common"]["enable_szse"];
    if (enable_szse == 1)
    {
        auto szPrinter = new SzsePrinter();
        
        DemoSzseSpi *pSpi = new DemoSzseSpi();
        int printCpu = xini_file["common"]["print_szse_cpu_id"];
        if (pSpi->Init(printCpu, szPrinter) != 0)
        {
            exit(-1);
        }
        xeleMd->RegisterSzseSpi(pSpi);
    }
    
    int ret = xeleMd->Start();
    
    if (ret < 0)
    {
        printf("Start recv failed, exit.\n");
        exit(0);
    }
        
    //30秒后开始查询上交静态行情
    sleep(30);
    const StaticInfo *pInfo = xeleMd->QueryStatic("600488");
    if (pInfo)
    {
        printf("QueryStatic succeed!\n");
    }
    
    while (1)
    {
        sleep(1);
    }
    
    xeleMd->Stop();
    
    return 0;
}
