#ifndef __CONFIG_FILE_H__
#define __CONFIG_FILE_H__

#include <string>
#include <map>
#include "Chameleon.h"

#define X_INFO(fp, fmt, ...) \
    do { \
      fprintf(fp, fmt "\n", ## __VA_ARGS__); \
    } \
    while(0)

class ConfigFile {
 private:
  std::map<std::string,Chameleon> content_;
  Chameleon prefixChameleon_;
  Chameleon emptyChameleon_;

public:
  explicit ConfigFile(std::string const& configFilePath);

  bool CheckConfExists(std::string const& entry) const;
  bool reloadConfigFile(std::string const& configFilePath);

  Chameleon const& Value(std::string const& entry) const;

  Chameleon const& Value(std::string const& section, std::string const& entry) const;
  Chameleon const& Value(std::string const& section, std::string const& entry, double value);
  Chameleon const& Value(std::string const& section, std::string const& entry, std::string const& value);
};

#endif
