#include "iostream"
#include "clientDemo.h"

int main(int argc, char **argv) {
  PRINT_INFO("hello xele demo");
  /*
   * 注意：此处使用到的地址以及各种参数只是用来模拟，具体的参数设置清根据实际使用场景进行正确的设置
   * 也可以将参数配置到配置文件中，避免重复编译
   * */
  GlobalDataManager::GetInstance().setAccountInfo("301320341480", "111111");
  /// manager ip : 127.0.0.1
  GlobalDataManager::GetInstance().setManagerIp("127.0.0.1");
  GlobalDataManager::GetInstance().setManagerPort(12345);
  /// 交易链路的本端网卡ip
  GlobalDataManager::GetInstance().setTradeSourceIp("127.0.0.1");
  /// 交易链路的本端网卡port
  GlobalDataManager::GetInstance().setTradeSourcePort(54321);
  GlobalDataManager::GetInstance().setAppID("XeleDemo");
  GlobalDataManager::GetInstance().setOperWay("0");
  GlobalDataManager::GetInstance().setAppIDExt("BCD");
  GlobalDataManager::GetInstance().setBusinessCode("XeleTest");
  GlobalDataManager::GetInstance().setClientIp("127.0.0.1");
  GlobalDataManager::GetInstance().setClientMac("11:22:33:44:55:66");
  GlobalDataManager::GetInstance().setHostname("CD127");
  GlobalDataManager::GetInstance().setCpu_serial("F1060400FFFBEBBF");
  GlobalDataManager::GetInstance().setHard_disk_serial("PDNLH0BRH9R95N");
  GlobalDataManager::GetInstance().setHdPartitionInfo("XeleHdPartitionInfo");
  /// 监管信息
  GlobalDataManager::GetInstance().setAllSuperviseInfo("PC;IIP=NA;IPORT=NA;LIP=127.0.0.1;MAC=30E1716E081C;HD=PDNLH0BRH9R95N;PCN=CD127;CPU=F1060400FFFBEBBF@windows");
  /// 连接上交柜台
  GlobalDataManager::GetInstance().setMarket(XELE_MARKET_SS);
  /// 使用节点0登录
  GlobalDataManager::GetInstance().setNode(0);
  GlobalDataManager::GetInstance().setPcPrefix("@Xele");

  /// 设置合约买卖字段
  GlobalDataManager::GetInstance().setSecuritiesID("600000");
  GlobalDataManager::GetInstance().setVolume(200);
  GlobalDataManager::GetInstance().setLimitPrice(100);
  GlobalDataManager::GetInstance().setDirection(XELE_ORDER_BUY);

  /*
   * 首先建立了和manager的tcp连接，然后往该链路发送登录请求；
   * 在manager的登录答应中获取到柜台查询链路地址，与柜台建立tcp连接，然后往该链路发送登录请求；
   * 在柜台的登录应答中获取到交易链路地址，建立连接后，发送校验请求；
   * 以上步骤完成后即与柜台成功建立连接，可以正常进行心跳交互以及报单、撤单、查询等操作。
   * 提示：
   * demo中将manager查询，柜台查询，柜台交易链路都放到了同一个epoll中管理，
   * 在实际使用中，可以考虑单独控制交易链路以提升该链路性能，避免查询等慢速操作影响报单等及时性高的接口
   * */
  /// demo入口
  auto clientDemo = new ClientDemo();
  clientDemo->run();

  /// 先连接manager的tcp
  auto res = clientDemo->connectManager();
  if (res > 0) {
    /// 发起登录请求
    PRINT_INFO("******************start test manager login******************");
    clientDemo->TestManagerLogin();

    /// 测试柜台的报单以及撤单接口
    /// 下面的接口调用无固定顺序，根据实际场景进行调用
    while (true) {
      if (clientDemo->isCounterTradeLogin()) {
        sleep(2);
        PRINT_INFO("******************start test order insert******************");
        clientDemo->TestOrderInsert();

        sleep(2);
        PRINT_INFO("******************start test order action******************");
        clientDemo->TestOrderAction();
        sleep(2);

        break;
      }
      sleep(2);
    }

    /// 测试柜台的查询报单接口
    while (true) {
      if (clientDemo->isCounterQueryLogin()) {
        PRINT_INFO("******************start test order query******************");
        clientDemo->TestOrderQuery();
        sleep(2);
        break;
      }
      sleep(1);
    }

    /// 测试柜台和manager的登出功能
    while (true) {
      /// 登出时建议先登出柜台，再登出manager，再关闭tcp连接
      if (clientDemo->isCounterQueryLogin()) {
        PRINT_INFO("******************start test counter logout******************");
        clientDemo->TestCounterLogout();
        PRINT_INFO("******************start test manager logout******************");
        clientDemo->TestManagerLogout();
        sleep(2);
        /// 关闭tcp连接
        clientDemo->disConnectTcp();
        sleep(2);
        break;
      }
      sleep(1);
    }

    while (clientDemo->isRunning()) {
      /// 等待，check一下，是否有心跳存在了
      PRINT_INFO("wait 6s, check...");
      sleep(6);
      delete clientDemo;
      sleep(1);
      break;
    }
  } else {
    PRINT_INFO("connect manager tcp fail");
  }


  PRINT_INFO("end xele demo");
  PRINT_INFO("main thread end...");

  return 0;
}