//
// Created by langf on 21-10-15.
//
#include <string>
#include <unistd.h>
#include <atomic>
#include <sys/mman.h>
#include <fcntl.h>

#ifndef XELE_SECURITY_STATISTIC_DELAY_H
#define XELE_SECURITY_STATISTIC_DELAY_H

#define TYPESIZE 20
#define TIMESIZE 100000
#define TYPE_TO_CHAR(type) #type
#define MAX_SAMPLES 512
#define CYCLE_SAMPLES_MASK (MAX_SAMPLES -1)

typedef uint64_t timing_t;
typedef struct tsc_sample_struct {
    timing_t seq;
    timing_t tsc;
    int      len;
} tsc_sample_struct_t;

typedef struct series_struct {
    tsc_sample_struct_t samples[MAX_SAMPLES];
    uint32_t count;
} series_struct_t;

static timing_t now_tsc0,now_tsc1,now_tsc2,now_tsc3,now_tsc4,now_tsc5,now_tsc6,now_tsc7,now_tsc8;

#define timing_now(val) do { \
struct timespec abc; \
clock_gettime(CLOCK_REALTIME, &abc); \
(val) = (unsigned long)abc.tv_sec * 1000000000lu + (unsigned  long)abc.tv_nsec; \
} while(0)

class statistic_delay {
public:

    statistic_delay();

    ~statistic_delay();

    static bool init();

    static void start(int type, int i);

    static void end(int type, int i);

    static void read_time(int type,int i);

    static void *thread_write_time(void *arg);

    static void calculation(int head);

    static uint64_t charToUint64(const std::string &str);

    static std::atomic<uint32_t> index;

    static int endSize[TYPESIZE];

private:
    static uint64_t (*startTime)[TIMESIZE];
    static uint64_t (*endTime)[TIMESIZE];
    static bool lastTimeCount[TYPESIZE];
};


#endif //XELE_SECURITY_STATISTIC_DELAY_H
