/**
 * @file XeleSecuritiesUserApiStruct_Bare.h
 * @author root
 * @brief 业务数据结构
 * @date 25-7-16
 *
 * 详细的文件描述或注意事项可以放在这里。
 */

#ifndef _XELE_API_STRUCT_H
#define _XELE_API_STRUCT_H

#include "XeleSecuritiesUserApiData_Bare.h"

#pragma pack(push, 1)

///心跳
struct CXeleHeartBeat {
  ///预留
  char                            Reserved[1];
};

///Fair协议头
struct CXeleFairReqHeadField {
  ///协议号
  TXeleFairProtocolType           ProtocolID;
  ///消息编号
  TXeleMessageIDType              MessageID;
  ///消息长度
  TXeleMessageLenType             MessageLength;
  //会话代码
  TXeleSessionIDType              SessionID;
  //校验用
  TXeleTokenType                  Token;
  ///序列号
  TXeleSeqNoType                  SeqNo;
  ///请求编号
  TXeleRequestIDType              RequestID;
};

///Fair响应协议头
struct CXeleFairRspHeadField {
  ///协议号
  TXeleFairProtocolType           ProtocolID;
  ///消息编号
  TXeleMessageIDType              MessageID;
  ///消息长度
  TXeleMessageLenType             MessageLength;
  ///请求编号
  TXeleRequestIDType              RequestID;
  ///序列号
  TXeleSeqNoType                  SeqNo;
  ///流序号
  TXeleSeqSeriesType              SeqSeries;
  ///结束标识
  TXeleIsLastType                 IsLast;
  ///错误编号
  TXeleErrorIdType                ErrorID;
  ///错误类型
  TXeleErrorTypeType              ErrorType;
  ///交易所类型
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[2];
};

////////Ctrl_F_System//////////
///////////////////////////////
/////// 系统相关 //////////////
//////////////////////////////

///登录请求
struct CXeleReqUserLoginField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///交易用户密码
  TXeleUserPasswordType           Password;
  ///终端软件AppID
  TXeleAppIDType                  AppID;
  ///终端软件授权码(暂不使用)
  TXeleAuthCodeType               AuthCode;
  ///客户端IP,自动获取
  TXeleClientIpType               ClientIp;
  ///客户端MAC,自动获取
  TXeleClientMacType              ClientMac;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///客户端报单IP(暂未使用)
  TXeleClientIpType               OrderIp;
  ///委托方式
  TXeleOperwayType                Operway;
  ///流水重构标志
  TXeleFlowRebuildType            FlowRebuildFlag;
  ///TXeleProtocolFlag Api协议号标记字段 ‘0’表示2.5（含）之前的协议 ‘1’表示3.0协议 用户无需填写
  TXeleProtocolFlag               ProtocolFlag;
  ///软件节点是否接收其他节点回报信息
  TXeleSoftRspRcvType             SoftRspRcv;
  ///站点前缀信息
  TXelePcPreFixType               PcPrefix;
  ///硬盘分区信息
  TXeleHardDiskPartitionType      HdPartitionInfo;
  ///营业部代码
  TXeleOrgIDType                  BusinessCode;
  ///重连校验字段(内部使用)
  TXeleDateType                   TradingDay;
  ///终端软件AppID扩展字段
  TXeleAppIDExtType               AppIDExt;
  ///硬件节点是否接收其他节点回报信息
  TXeleFpgaRspRcvType             FpgaRspRcv;
  ///预留
  char                            Reserved[19];
};

///登录应答
struct CXeleRspUserLoginField {
  ///交易日
  TXeleDateType                   TradingDay;
  ///登录成功时间
  TXeleShortTimeType              LoginTime;
  ///用户本地最大报单号
  TXeleOrderIDType                MaxUserLocalID;
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///会话代码
  TXeleSessionIDType              SessionID;
  ///校验用
  TXeleTokenType                  Token;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///交易ip
  TXeleTradeIPType                TradeDestIp;
  ///交易端口
  TXeleTradePortType              TradeDestPort;
  ///交易通道有效标志, 0:无效，1:有效
  TXeleTradeFlagType              TradeFlag;
  ///委托方式
  TXeleOperwayType                Operway;
  ///交易所类型
  TXeleMarketType                 Market;
  ///报单通道,'0':硬件通道 '1':软件通道
  TXeleTradeType                  TradeType;
  ///心跳时间
  TXeleHeartBeatInterval          HeartBeatInterval;
  ///心跳超时时间
  TXeleHeartBeatTimeout           HeartBeatTimeout;
  ///登录的是互联网端口(内部使用)
  TXeleInternetType               IsInternetConnect;
  ///预留
  char                            Reserved[97];
};

///添加交易链路请求
struct CXeleReqInitTraderField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///交易ip
  TXeleTradeIPType                TradeDestIp;
  ///交易端口
  TXeleTradePortType              TradeDestPort;
  ///源ip
  TXeleTradeIPType                TradeSrcIp;
  ///源端口
  TXeleTradePortType              TradeSrcPort;
  /// 预留
  char                            Reserved[94];
};

///添加交易链路请求响应
struct CXeleRspInitTraderField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  // 预留
  char                            Reserved[113];
};

///用户密码修改请求
struct CXeleReqUserPasswordUpdateField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///新密码
  TXeleUserPasswordType           NewPassword;
  ///旧密码
  TXeleUserPasswordType           OldPassword;
  ///预留
  TXeleReserved1Type              Reserved;
};

///用户密码修改应答
struct CXeleRspUserPasswordUpdateField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///新密码
  TXeleUserPasswordType           NewPassword;
  ///旧密码
  TXeleUserPasswordType           OldPassword;
  ///预留
  TXeleReserved1Type              Reserved;
};

///用户登出请求
struct CXeleReqUserLogoutField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///预留
  TXeleReserved1Type              Reserved;
};

///用户登出应答
struct CXeleRspUserLogoutField {
  ///交易日
  TXeleDateType                   TradingDay;
  ///登出时间
  TXeleShortTimeType              LogoutTime;
  ///本地最大报单号
  TXeleOrderIDType                MaxUserLocalID;
  ///资金账户
  TXeleUserIDType                 AccountID;
  //会话代码
  TXeleSessionIDType              SessionID;
  ///预留
  TXeleReserved1Type              Reserved;
};

////////Ctrl_F_Public//////////
///////////////////////////////
/////// 证券、期权公用 /////////
//////////////////////////////

///报单请求
struct CXeleReqOrderInsertField {
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志(股票不填)
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///限价价格
  TXelePriceType                  LimitPrice;
  ///报单数量
  TXeleVolumeType                 Volume;
  ///报单价格条件
  TXeleOrderTypeType              OrderType;
  ///有效期类型
  TXeleTimeConditionType          TimeCondition;
  ///合约类型(暂不使用)
  TXeleSecuritiesType             SecuritiesType;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///预留
  char                            Reserved[2];
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  ///委托方式
  TXeleOperwayType                Operway;
  ///交易前置id,默认或者未填写为0网关轮询,查询接口返回的网关需要转换成整型，如'1'转换成1后填充该字段
  TXeleExchangeIDType             ExchangeFrontID;
  ///内部使用
  unsigned char                   ReservedNum;
  ///委托方式扩展字段,部分券商支持
  char                            OperWayEx[3];
  ///预留
  TXeleErrorIdType                ErrorId;
};

///报单应答
struct CXeleRspOrderInsertField {
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志（股票不填）
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///限价价格
  TXelePriceType                  LimitPrice;
  ///报单数量
  TXeleVolumeType                 Volume;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  ///有效期类型
  TXeleTimeConditionType          TimeCondition;
  ///交易所类型
  TXeleMarketType                 Market;
  ///预埋单标记 '0':非预埋单 '1':预埋单
  TXelePreOrderFlag               PreOrderFlag;
  ///错误编号，拒单使用
  TXeleErrorIdType                ErrorID;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///交易所报单编号(暂不使用)
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///交易前置id(暂不使用)
  TXeleExchangeIDType             ExchangeFrontID;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///预留
  char                            Reserved[12];
};

///撤单请求
struct CXeleReqOrderActionField {
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///撤单报单编号
  ///值为0时，使用OrigUserLocalID撤单；非0时，使用OrigSysID进行撤单
  TXeleOrigSysIDType              OrigSysID;
  ///被撤单用户本地报单编号
  TXeleOrderIDType                OrigUserLocalID;
  ///预留
  char                            Reserved[20];
  ///业务单元，(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  ///订单所有类型(暂不使用)
  TXeleTradeOwnerType	          OwnerType;
  ///委托方式
  TXeleOperwayType                Operway;
  ///交易前置id(暂不使用)
  TXeleExchangeIDType             ExchangeFrontID;
  ///委托方式扩展字段,部分券商支持
  char                            OperWayEx[3];
  ///预留
  char                            Reserved1[2];
};

///撤单应答
struct CXeleRspOrderActionField {
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///被撤单柜台报单编号
  TXeleOrigSysIDType              OrigSysID;
  ///被撤单用户本地报单编号
  TXeleOrderIDType                OrigUserLocalID;
  ///被撤单柜台报单编号str类型
  TXeleStrOrderSysIDType          OrigStrOrderSysID;
  ///预埋单标记 '0':非预埋单 '1':预埋单
  TXelePreOrderFlag               PreOrderFlag;
  ///预留
  char                            Reserved1[7];
  ///错误编号
  TXeleErrorIdType                ErrorID;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  ///预留
  char                            Reserved2[1];
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///交易所类型
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved3[28];
};

///报撤单回报
struct CXeleRtnOrderField {
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///价格(期权精度0.0001, 股票精度0.001)
  TXelePriceType                  LimitPrice;
  ///报单数量
  TXeleVolumeType                 Volume;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  ///有效期类型
  TXeleTimeConditionType          TimeCondition;
  ///交易所类型
  TXeleMarketType                 Market;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///交易所报单编号(撤单不使用)
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///接受请求时间
  TXeleTimeType                   TransactTime;
  ///对应申报市价转限价的订单，这里填写转为限价订单的价格，
  TXelePriceType                  DiscretionPrice;
  ///累计成交数量
  TXeleVolumeType                 TradeVolume;
  ///未成交手数
  TXeleVolumeType                 LeavesVolume;
  ///订单状态
  TXeleOrderStatusType            OrderStatus;
  ///预留
  char                            Reserved[24];
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  // 流水重构报文标记
  TXeleRecoveryFlagType           RecoveryFlag;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///交易前置id,多网关版本使用
  ///返回值为实际报单的网关id + 1
  ///返回值为1代表是0号网关,2代表1号网关
  TXeleExchangeIDType             ExchangeFrontID;
  ///被撤单用户本地报单编号
  TXeleOrderIDType                OrigUserLocalID;
  ///被撤单柜台报单编号int类型
  TXeleOrigSysIDType              OrigOrderSysID;
  ///被撤单柜台报单编号str类型
  TXeleStrOrderSysIDType          OrigStrOrderSysID;
  ///预留
  char                            Reserved1[74];
};

///成交回报
struct CXeleRtnTradeField {
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志，股票不填
  TXeleOffsetFlagType             CombOffsetFlag;
  ///限价价格(期权精度0.0001, 股票精度0.001)
  TXelePriceType                  LimitPrice;
  ///数量
  TXeleVolumeType                 Volume;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  ///有效期类型
  TXeleTimeConditionType          TimeCondition;
  ///交易所类型
  TXeleMarketType                 Market;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///交易所报单编号
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///预留
  char                            Reserved1[4];
  ///成交价格(期权精度0.0001, 股票精度0.001)
  TXelePriceType                  TradePrice;
  ///成交数量
  TXeleVolumeType                 TradeVolume;
  ///未成交手数（报单数量-累计成交数量）
  TXeleVolumeType                 LeavesVolume;
  ///订单执行时间
  TXeleTimeType                   TransactTime;
  ///原有订单接受时间(上交使用)
  TXeleTimeType                   OrigTime;
  ///订单状态
  TXeleOrderStatusType            OrderStatus;
  ///成交金额，精度0.01
  TXeleMoneyType                  TotalValueTraded;
  ///佣金
  TXeleSecuritiesCommissionType   Commission;
  ///印花税
  TXeleStampTaxRateType           StampTax;
  ///过户费
  TXeleTransferFeeRateType        Transfer;
  ///总手续费
  TXeleTotalFeeType               TotalFee;
  ///预留
  char                            Reverse16[16];
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  // 流水重构报文标记
  TXeleRecoveryFlagType           RecoveryFlag;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  ///投资者账号
  TXeleUserIDType                 AccountID;
  /// 交易所执行编号
  TXeleOrderExchangeIDType        ExecID;
  ///交易前置id,多网关版本使用
  ///返回值为实际报单的网关id + 1
  ///返回值为1代表是0号网关,2代表1号网关
  TXeleExchangeIDType             ExchangeFrontID;
  /// 累计成交手数
  TXeleVolumeType                 CumQty;
  /// 本市场成份证券数
  TXeleRecordNumType              RecordNum;
  /// 成份证券代码
  TXeleSecuritiesIDType           ComponentSecurityID;
  /// 成份证券来源
  TXeleSecuritySourceType         ComponentSecuritySource;
  /// 使用老仓数量
  TXeleQuantityType               UseOldQty;
  /// 成份股份成交数量
  TXeleQuantityType               ComponentTradeQty;
  /// 现金替代金额
  TXelePriceType                  ContAmtValue;
  ///预留
  char                            Reserved2[45];
};

///订单查询请求
struct CXeleReqQryOrderField {
  ///柜台报单编号int类型，不为0表示精确查询，本地报单编号、合约和时间条件都无效
  TXeleOrderIDType                OrderSysID;
  ///证券代码 范围查询，配合分页查询变量使用
  TXeleSecuritiesIDType           SecuritiesID;
  ///本地报单编号，不为0表示精确查询，合约和时间条件无效
  TXeleOrderIDType                UserLocalID;
  ///开始时间   格式：HHMMSSmmm(时分秒毫秒) 范围查询
  TXeleShortTimeType              TimeStart;
  ///结束时间   格式：HHMMSSmmm(时分秒毫秒) 范围查询
  TXeleShortTimeType              TimeEnd;
  ///分页查询起始值 不填，默认从第一条开始
  TXeleVolumeType                 StartNum;
  ///单次分页查询数量 不填，使用系统参数表配置分页数量
  TXeleVolumeType                 QryNum;
  ///排序类型
  TXeleSortType                   SortType;
  ///订单查询状态
  TXeleQryStatusType              QryOrderStatus;
  ///订单状态类型，仅期权使用
  TXeleQryBusinessType            QryBusinessType;
  ///预留
  char                            Reserved[115];
};

///订单查询应答
struct CXeleRspQryOrderField {
  ///用户报单编号
  TXeleOrderIDType                UserLocalID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///价格
  TXelePriceType                  LimitPrice;
  ///数量
  TXeleVolumeType                 Volume;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  ///有效期类型
  TXeleTimeConditionType          TimeCondition;
  ///交易所类型
  TXeleMarketType                 Market;
  ///委托方式
  TXeleOperwayType                Operway;
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///交易所报单编号
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///接受请求时间
  TXeleTimeType                   TransactTime;
  ///对应申报市价转限价的订单，这里填写转为限价订单的价格，单位：元
  TXelePriceType                  DiscretionPrice;
  ///累计成交数量
  TXeleVolumeType                 TradeVolume;
  ///未成交手数
  ///如果状态是撤单或者部撤 ，leavesVolume是已经成功撤单的数量；
  ///如果报单状态是部分成交 ，leavesVolume表示未成交数量 = 报单数量 - 累计成交数量
  TXeleVolumeType                 LeavesVolume;
  ///订单状态
  TXeleOrderStatusType            OrderStatus;
  ///佣金
  TXeleSecuritiesCommissionType   Commission;
  ///印花税
  TXeleStampTaxRateType           StampTax;
  ///过户费
  TXeleTransferFeeRateType        Transfer;
  ///流量费
  TXeleTrafficFeeType             TrafficFee;
  ///总手续费
  TXeleTotalFeeType               TotalFee;
  ///预留
  char                            Reserved1[16];
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  ///报单类型
  TXeleMessageIDType              OrderMessageId;
  ///证券类别代码
  TXeleSecuritiesType             SecuritiesType;
  ///预埋单标记
  TXelePreOrderFlag               PreOrderFlag;
  ///报单错误编号
  TXeleErrorIdType                ErrorID;
  ///分页查询结束值 用来作为下次查询的起始值，来实现分页
  TXeleVolumeType                 EndNum;
  ///分页查询条件下，是否可以再次进行查询 只在最后一条回报中有效
  TXeleIsLastType                 QryAgain;
  ///当前条件下查询到的回报总数
  TXeleVolumeType                 QryTotalNum;
  ///投资者股东账号
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  ///成交金额
  TXelePriceType                  TradeAmount;
  ///主柜台未同步到备机的委托类型
  TXeleUnSyncOrderFlag            UnSyncOrderFlag;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///被撤单柜台报单编号str类型(带号段)
  TXeleStrOrderSysIDType          OrigStrOrderSysID;
  ///报单来源,支持接入网关的柜台,此字段有效
  TXeleOrderSourceType            OrderSource;
  ///交易前置id
  ///返回值为实际报单的网关id + 1
  ///例如: 返回值为1代表是0号网关,2代表1号网关
  TXeleExchangeIDIntType          ExchangeFrontNo;
  ///委托方式扩展字段,部分券商支持
  char                            OperWayEx[3];
  ///预留
  char                            Reserved2[27];
};

///成交查询请求
struct CXeleReqQryTradeField {
  ///柜台报单编号int类型，不为0表示精确查询，本地报单编号、合约和时间条件都无效
  TXeleOrderIDType                OrderSysID;
  ///证券代码 范围查询，配合分页查询变量使用
  TXeleSecuritiesIDType           SecuritiesID;
  ///开始时间  格式：HHMMSSmmm(时分秒毫秒) 范围查询，配合分页查询变量使用
  TXeleShortTimeType              TimeStart;
  ///结束时间  格式：HHMMSSmmm(时分秒毫秒) 范围查询，配合分页查询变量使用
  TXeleShortTimeType              TimeEnd;
  ///用户本地报单编号，不为0表示精确查询，合约和时间条件无效
  TXeleOrderIDType                UserLocalID;
  ///分页查询起始值 不填，默认从第一条开始
  TXeleVolumeType                 StartNum;
  ///单次分页查询数量 不填，使用系统参数表配置分页数量
  TXeleVolumeType                 QryNum;
  ///排序类型
  TXeleSortType                   SortType;
  ///预留
  char                            Reserved[115];
};

///成交查询应答
struct CXeleRspQryTradeField {
  ///用户本地报单编号
  TXeleOrderIDType                UserLocalID;
  ///交易日
  TXeleDateType                   TradingDay;
  ///成交数量
  TXeleVolumeType                 TradeVolume;
  ///未成交手数（报单数量-累计成交数量）
  TXeleVolumeType                 LeavesVolume;
  //证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  //申报时间
  TXeleShortTimeType              OrderTime;
  //成交时间
  TXeleShortTimeType              TradeTime;
  //成交价格
  TXelePriceType                  TradePrice;
  //成交金额
  TXelePriceType                  TradeAmount;
  ///预留
  char                            Reserved1[4];
  ///交易所类型
  TXeleMarketType                 Market;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///交易所报单编号
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志，股票不填
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///佣金
  TXeleSecuritiesCommissionType   Commission;
  ///印花税
  TXeleStampTaxRateType           StampTax;
  ///过户费
  TXeleTransferFeeRateType        Transfer;
  ///总手续费
  TXeleTotalFeeType               TotalFee;
  ///预留
  char                            Reserved2[16];
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///订单状态
  TXeleOrderStatusType            OrderStatus;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  /// 交易所执行编号
  TXeleOrderExchangeIDType        ExecID;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///分页查询结束值 用来作为下次查询的起始值，来实现分页
  TXeleVolumeType                 EndNum;
  ///分页查询条件下，是否可以再次进行查询 只在最后一条回报中有效
  TXeleIsLastType                 QryAgain;
  ///当前条件下查询到的回报总数
  TXeleVolumeType                 QryTotalNum;
  ///投资者股东账号
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  ///报单来源,支持接入网关的柜台,此字段有效
  TXeleOrderSourceType            OrderSource;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  /// 本市场成份证券数
  TXeleRecordNumType              RecordNum;
  /// 成份证券代码
  TXeleSecuritiesIDType           ComponentSecurityID;
  /// 成份证券来源
  TXeleSecuritySourceType         ComponentSecuritySource;
  /// 使用老仓数量
  TXeleQuantityType               UseOldQty;
  /// 成份股份成交数量
  TXeleQuantityType               ComponentTradeQty;
  /// 现金替代金额
  TXelePriceType                  ContAmtValue;
  ///预留
  char                            Reserved3[14];

};

///QFII订单查询请求
struct CXeleReqQryQFIIOrderField {
  ///柜台报单编号int类型，不为0表示精确查询，本地报单编号、合约和时间条件都无效
  TXeleOrderIDType                OrderSysID;
  ///证券代码 范围查询，配合分页查询变量使用
  TXeleSecuritiesIDType           SecuritiesID;
  ///QFII用户报单编号，不为0表示精确查询，合约和时间条件无效
  TXeleQFIIOrderIDType            QFIIUserLocalID;
  ///开始时间   格式：HHMMSSmmm(时分秒毫秒) 范围查询
  TXeleShortTimeType              TimeStart;
  ///结束时间   格式：HHMMSSmmm(时分秒毫秒) 范围查询
  TXeleShortTimeType              TimeEnd;
  ///分页查询起始值 不填，默认从第一条开始
  TXeleVolumeType                 StartNum;
  ///单次分页查询数量 不填，使用系统参数表配置分页数量
  TXeleVolumeType                 QryNum;
  ///排序类型
  TXeleSortType                   SortType;
  ///订单查询状态
  TXeleQryStatusType              QryOrderStatus;
  ///预留
  char                            Reserved[87];
};

///QFII订单查询应答
struct CXeleRspQryQFIIOrderField {
  ///QFII用户报单编号
  TXeleQFIIOrderIDType            QFIIUserLocalID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///价格
  TXelePriceType                  LimitPrice;
  ///数量
  TXeleVolumeType                 Volume;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  ///有效期类型
  TXeleTimeConditionType          TimeCondition;
  ///交易所类型
  TXeleMarketType                 Market;
  ///委托方式
  TXeleOperwayType                Operway;
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///交易所报单编号
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///接受请求时间
  TXeleTimeType                   TransactTime;
  ///对应申报市价转限价的订单，这里填写转为限价订单的价格，单位：元
  TXelePriceType                  DiscretionPrice;
  ///累计成交数量
  TXeleVolumeType                 TradeVolume;
  ///未成交手数
  ///如果状态是撤单或者部撤 ，leavesVolume是已经成功撤单的数量；
  ///如果报单状态是部分成交 ，leavesVolume表示未成交数量 = 报单数量 - 累计成交数量
  TXeleVolumeType                 LeavesVolume;
  ///订单状态
  TXeleOrderStatusType            OrderStatus;
  ///佣金
  TXeleSecuritiesCommissionType   Commission;
  ///印花税
  TXeleStampTaxRateType           StampTax;
  ///过户费
  TXeleTransferFeeRateType        Transfer;
  ///流量费
  TXeleTrafficFeeType             TrafficFee;
  ///总手续费
  TXeleTotalFeeType               TotalFee;
  ///预留
  char                            Reserved1[16];
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///业务单元(用户定义)
  TXeleBusinessUnitType           BusinessUnit;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  ///报单类型
  TXeleMessageIDType              OrderMessageId;
  ///证券类别代码
  TXeleSecuritiesType             SecuritiesType;
  ///预埋单标记 '0':非预埋单 '1':预埋单
  TXelePreOrderFlag               PreOrderFlag;
  ///报单错误编号
  TXeleErrorIdType                ErrorID;
  ///分页查询结束值 用来作为下次查询的起始值，来实现分页
  TXeleVolumeType                 EndNum;
  ///分页查询条件下，是否可以再次进行查询 只在最后一条回报中有效
  TXeleIsLastType                 QryAgain;
  ///当前条件下查询到的回报总数
  TXeleVolumeType                 QryTotalNum;
  ///投资者股东账号
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  ///成交金额
  TXelePriceType                  TradeAmount;
  ///主柜台未同步到备机的委托类型
  TXeleUnSyncOrderFlag            UnSyncOrderFlag;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///被撤单柜台报单编号str类型(带号段)
  TXeleStrOrderSysIDType          OrigStrOrderSysID;
  ///报单来源,支持接入网关的柜台,此字段有效
  TXeleOrderSourceType            OrderSource;
  ///交易前置id(QFII中暂不使用)
  ///返回值为实际报单的网关id + 1
  ///例如: 返回值为1代表是0号网关,2代表1号网关
  TXeleExchangeIDIntType          ExchangeFrontNo;
  ///预留
  char                            Reserved2[64];
};

///QFII成交查询请求
struct CXeleReqQryQFIITradeField {
  ///柜台报单编号int类型，不为0表示精确查询，本地报单编号、合约和时间条件都无效
  TXeleOrderIDType                OrderSysID;
  ///证券代码 范围查询，配合分页查询变量使用
  TXeleSecuritiesIDType           SecuritiesID;
  ///开始时间  格式：HHMMSSmmm(时分秒毫秒) 范围查询，配合分页查询变量使用
  TXeleShortTimeType              TimeStart;
  ///结束时间  格式：HHMMSSmmm(时分秒毫秒) 范围查询，配合分页查询变量使用
  TXeleShortTimeType              TimeEnd;
  ///QFII用户本地报单编号，不为0表示精确查询，合约和时间条件无效
  TXeleQFIIOrderIDType            QFIIUserLocalID;
  ///分页查询起始值 不填，默认从第一条开始
  TXeleVolumeType                 StartNum;
  ///单次分页查询数量 不填，使用系统参数表配置分页数量
  TXeleVolumeType                 QryNum;
  ///排序类型
  TXeleSortType                   SortType;
  ///Etf成交记录查询标志, qfii柜台使用
  TXeleQryEtfTradeFlag            QryEtfTradeFlag;
  ///预留
  char                            Reserved[114];
};

///QFII成交查询应答
struct CXeleRspQryQFIITradeField {
  ///QFII用户本地报单编号
  TXeleQFIIOrderIDType            QFIIUserLocalID;
  ///交易日
  TXeleDateType                   TradingDay;
  ///成交数量
  TXeleVolumeType                 TradeVolume;
  ///未成交手数（报单数量-累计成交数量）
  TXeleVolumeType                 LeavesVolume;
  //证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  //申报时间
  TXeleShortTimeType              OrderTime;
  //成交时间
  TXeleShortTimeType              TradeTime;
  //成交价格
  TXelePriceType                  TradePrice;
  //成交金额
  TXelePriceType                  TradeAmount;
  ///暂不使用
  TXeleOrderIDType                TradeID;
  ///交易所类型
  TXeleMarketType                 Market;
  ///备兑标志(期权使用)
  TXeleCoveredFlagType            CoveredOrUncovered;
  ///柜台报单编号int类型
  TXeleOrderIDType                OrderSysID;
  ///交易所报单编号
  TXeleOrderExchangeIDType        OrderExchangeID;
  ///买卖方向
  TXeleDirectionType              Direction;
  ///开平标志，股票不填
  TXeleOffsetFlagType             CmbOffsetFlag;
  ///佣金
  TXeleSecuritiesCommissionType   Commission;
  ///印花税
  TXeleStampTaxRateType           StampTax;
  ///过户费
  TXeleTransferFeeRateType        Transfer;
  ///总手续费
  TXeleTotalFeeType               TotalFee;
  ///预留
  char                            Reserved1[16];
  ///投资者账号
  TXeleUserIDType                 AccountID;
  ///订单状态
  TXeleOrderStatusType            OrderStatus;
  ///柜台报单编号str类型
  TXeleStrOrderSysIDType          StrOrderSysID;
  /// 交易所执行编号
  TXeleOrderExchangeIDType        ExecID;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///分页查询结束值 用来作为下次查询的起始值，来实现分页
  TXeleVolumeType                 EndNum;
  ///分页查询条件下，是否可以再次进行查询 只在最后一条回报中有效
  TXeleIsLastType                 QryAgain;
  ///当前条件下查询到的回报总数
  TXeleVolumeType                 QryTotalNum;
  ///投资者股东账号
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  ///报单来源,支持接入网关的柜台,此字段有效
  TXeleOrderSourceType            OrderSource;
  ///报单类型
  TXeleOrderTypeType              OrderType;
  /// 本市场成份证券数
  TXeleRecordNumType              RecordNum;
  /// 成份证券代码
  TXeleSecuritiesIDType           ComponentSecurityID;
  /// 成份证券来源
  TXeleSecuritySourceType         ComponentSecuritySource;
  /// 使用老仓数量
  TXeleQuantityType               UseOldQty;
  /// 成份股份成交数量
  TXeleQuantityType               ComponentTradeQty;
  /// 现金替代金额
  TXelePriceType                  ContAmtValue;
  ///Etf成交记录查询标志, QFII柜台使用
  TXeleQryEtfTradeFlag            QryEtfTradeFlag;
  ///预留
  char                            Reserved2[64];
};

///QFII持仓查询请求
struct CXeleReqQryQFIIPositionField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///交易所类型,查询登录的市场的持仓记录
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[104];
};

///QFII证券持仓查询应答
struct CXeleRspQryQFIIStockPositionField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///证券类别代码
  TXeleSecuritiesType             SecuritiesType;
  ///今买仓
  TXeleQFIIPositionType           TdBuyPosition;
  ///今卖仓
  TXeleTdSellPositionType         TdSellPosition;
  ///在途买仓
  TXeleQFIIPositionType           UnTdBuyPosition;
  ///在途卖仓
  TXeleQFIIPositionType           UnTdSellPosition;
  ///昨持仓（不变）
  TXeleQFIIPositionType           YdPosition;
  ///昨持仓剩余
  TXeleQFIIPositionType           YdPositionLeft;
  ///持仓成本
  TXeleTotalCostType              TotalCost;
  ///交易所类型
  TXeleMarketType                 Market;
  ///日内可转交易类型,Y表示T+0，N表示T+1
  TXeleDayTradingType             DayTrading;
  ///股东账户
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  ///当日申购持仓数量
  TXeleQFIIPositionType           TdCreationQty;
  ///当日赎回成分股数量
  TXeleQFIIPositionType           TdRedemptionQty;
  ///在途申购数量
  TXeleQFIIPositionType           UnTdCreationQty;
  ///出入仓数量
  TXeleQFIIPositionType           InOutPosition;
  ///在途赎回数量
  TXeleQFIIPositionType           UnTdRedemptionQty;
  ///在途卖来自赎回成分股数量
  TXeleQFIIPositionType           UnTdSellFromRedemptionQty;
  ///在途卖来自申购数量
  TXeleQFIIPositionType           UnTdSellFromCreationQty;
  ///预留
  char                            Reserved[141];
};

///费率查询(印花税率、过户费率、佣金率、流量费、最小佣金、多冻值)请求
struct CXeleReqQryStockFeeField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///预留
  char                            Reserved1[12];
  ///证券类型
  TXeleSecuritiesType             SecuritiesType;
  ///预留
  char                            Reserved2[127];
};

///费率查询(印花税率、过户费率、佣金率、流量费、最小佣金、多冻值)应答
struct CXeleRspQryStockFeeField {
  ///资金账户
  TXeleUserIDType                            AccountID;
  ///证券代码
  TXeleSecuritiesIDType                      SecuritiesID;
  ///预留
  char                                       Reserved1[12];
  ///印花税率
  TXeleStampTaxRateType                      StampTaxRate;
  ///过户费率
  TXeleTransferFeeRateType                   TransferFee;
  ///佣金率
  TXeleSecuritiesCommissionType              CommissionRate;
  ///流量费
  TXeleTrafficFeeType                        TrafficFee;
  ///交易所类型
  TXeleMarketType                            Market;
  ///证券类型
  TXeleSecuritiesType                        SecuritiesType;
  ///最小佣金
  TXeleMinCommissionType                     MinCommission;
  ///多冻值
  TXeleMoreFreeze                            MoreFreeze;
  ///ETF申赎附加费,若该合约不支持申赎，值为0
  TXeleETFCreationRedemptionExtraFee         ETFCreationRedemptionExtraFee;
  ///ETF申赎佣金费率,若该合约不支持申赎，值为0
  TXeleETFCreationRedemptionCommFeeRate      ETFCreationRedemptionCommFeeRate;
  ///ETF申赎过户费,若该合约不支持申赎，值为0
  TXeleETFCreationRedemptionTransferFeeRate  ETFCreationRedemptionTransferFeeRate;
  ///预留
  char                                       Reserved2[86];
};

////////Ctrl_F_Stock///////////
///////////////////////////////
/////// 证券相关 //////////////
//////////////////////////////

/// 资金调拨请求
struct CXeleReqCapTransferField {
  ///机构代码（客户不填）
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///币种（客户不填）
  TXeleCurrencyType               Currency;
  ///返还日期（客户不填）
  TXeleRtnDateType                RtnDate;
  ///冻结,解冻金额
  TXeleMoneyType                  Fundamt;
  ///预留
  char                            Reserved1[32];
  ///执行标记(内部使用,客户不填)
  TXeleCallOneceFlag              CallOnce;
  ///分支机构（内部使用,客户不填）
  TXeleBranchNoType               BranchNo;
  ///客户代码（内部使用,客户不填）
  TXeleUserIDType                 CustID;
  ///调入/调出类型,0:可用资金，1 rtfs额度
  TXeleTransferType               TransferType;
  ///预留
  char                            Reserved2[43];
};

// 资金调拨应答
struct CXeleRspCapTransferField {
  ///机构代码
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///币种
  TXeleCurrencyType               Currency;
  ///操作流水号
  TXeleSnoType                    Sno;
  ///调取前可用(恒生柜台：该字段暂未使用)
  TXeleMoneyType                  BefFundavl;
  ///资金余额
  TXeleMoneyType                  Fundbal;
  ///调整后可用(恒生柜台：该字段暂未使用)
  TXeleMoneyType                  AftFundavl;
  ///调整前可取(恒生柜台：该字段暂未使用)
  TXeleMoneyType                  BefCashbal;
  ///调整后可取(恒生柜台：该字段暂未使用)
  TXeleMoneyType                  AftCashbal;
  ///调入资金,调取资金
  TXeleMoneyType                  Fundamt;
  ///集中交易柜台响应错误码
  TXeleCentralTradingErrorIdType  CtErrorId;
  ///集中交易柜台响应错误信息
  TXeleCentralTradingErrorMsgType CtErrorInfo;
  ///fpga资金是否更新
  TXeleIsUpdateFpgaFundType       IsUpdateFpgaFund;
  ///调入/调出类型,0:可用资金，1 rtfs额度
  TXeleTransferType               TransferType;
  ///预留
  char                            Reserved[10];
};

///集中柜台资金调拨记录查询请求
struct CXeleReqQryCapTransferRecordField {
  ///机构代码(QFII中暂不使用)
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///预留
  TXeleReserved1Type              Reserved;
};

///集中柜台资金调拨记录查询应答
struct CXeleRspQryCapTransferRecordField {
  ///机构代码(QFII中暂不使用)
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///冻结/解冻金额
  TXeleMoneyType                  Fundamt;
  ///操作方向, '1'：冻结集中资金，'2':解冻集中资金
  TXeleDirectionType              TransferDirection;
  ///操作流水号
  TXeleSnoType                    Sno;
  ///操作时间
  TXeleShortTimeType              OperateTime;
  ///交易所类型
  TXeleMarketType                 Market;
  ///操作来源
  TXeleActionSourceType           ActionSource;
  ///预留
  char                            Reserved[62];
};

///资金查询请求
struct CXeleReqQryClientAccountField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///预留
  TXeleReservedType               Reserved;
};

///资金查询应答
struct CXeleRspQryStockClientAccountField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///预留
  char                            Reserved1[1];
  ///冻结资金
  TXeleFrozeMarginType            FrozeCapital;
  ///冻结手续费
  TXeleFrozenFeeType              FrozenFee;
  ///已付手续费
  TXeleUsedFeeType                UsedFee;
  ///初始上场资金（不变）
  TXeleTotalFundType              InitTotalFund;
  ///上场资金（可变）； 初始上场资金 + 出入金额 ，可能为负（建议客户不使用）
  TXeleTotalFundType              TotalFund;
  ///总卖出
  TXeleSellFund                   SellFund;
  ///总买入
  TXeleBuyFund                    BuyFund;
  ///预留
  char                            Reserved2[16];
  ///可用资金
  TXeleAvailableFundType          AvailableFund;
  ///交易所类型
  TXeleMarketType                 Market;
  ///投资者股东账号
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  ///被证券公司冻结的资金
  TXeleFrozenFundType             FrozenFund;
  ///预留
  char                            Reserved3[94];
};

///证券持仓查询请求
struct CXeleReqQryPositionField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///交易所类型,不填查询登录的市场，填写查询对应的市场，'a'查询全部
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[127];
};

///证券持仓查询应答
struct CXeleRspQryPositionField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///证券类别代码
  TXeleSecuritiesType             SecuritiesType;
  ///预留
  char                            Reserved1[2];
  ///证券子类别代码，暂不使用
  TXeleSecuritiesSubTypeType      SubSecuritiesType;
  ///今买仓
  TXeleTdBuyPositionType          TodayBuyPosition;
  ///今卖仓
  TXeleTdSellPositionType         TdSellPosition;
  ///在途买仓
  TXeleUnTdPositionType           UnTodayBuyPosition;
  ///在途卖仓
  TXeleUnTdPositionType           UnTodaySellPosition;
  ///预留
  char                            Reserved2[8];
  ///昨持仓（不变）
  TXeleYdPositionType             YesterdayPosition;
  ///预留
  char                            Reserved3[16];
  ///总持仓 = 老仓 + 今买仓  - 今卖仓
  TXeleTotalPositionType          TotalPosition;
  ///持仓成本
  TXeleTotalCostType              TotalCost;
  ///持仓均价
  TXeleAvgPxType                  AvgPrice;
  ///备兑锁定持仓
  TXeleCoveredFrozenPositionType  CoveredFrozenPosition;
  ///交易所类型
  TXeleMarketType                 Market;
  ///现有持仓数量（含未卖持仓）=老仓 + 今买仓 (-+)出入仓 - 今卖仓
  TXeleRemainingPosition          RemainingPosition;
  ///可卖持仓数量
  TXeleAvailablePosition          AvailablePosition;
  ///日内可转交易类型,Y表示T+0，N表示T+1
  TXeleDayTradingType             DayTrading;
  ///股东账户
  TXeleInvestorIDType             InvestorID;
  ///客户代码
  TXeleUserIDType                 CustID;
  //被证券公司冻结的持仓
  TXeleFrozenPositionType         FrozenPosition;
  ///可备兑锁定持仓,允许备兑锁定的持仓数量
  TXeleCoveredFrozenPositionType  AvailableCoverLockPosition;
  ///可申购数量
  TXeleQtyType                    AvailableCreationQty;
  ///可赎回数量
  TXeleQtyType                    AvailableRedemptionQty;
  ///预留
  char                            Reserved4[57];
};

/// 证券代码信息查询请求
struct CXeleReqQrySecuritiesField {
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///预留
  TXeleReservedType               Reserved;
};

/// 证券代码信息查询应答
struct CXeleRspQryStockSecuritiesField {
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///合约名称
  TXeleSecuritiesNameType         SecuritiesName;
  ///证券类别代码
  TXeleSecuritiesType             SecuritiesType;
  ///预留
  char                            Reserved1[2];
  ///证券子类别代码,枚举详见文档
  TXeleSecuritiesSubType          SecuritiesSubType;
  ///预留
  char                            Reserved2[4];
  ///最小变动价位
  TXeleMinTickPriceType           TickPrice;
  ///预留
  char                            Reserved3[9];
  ///昨结算价
  TXelePreSettlePriceType         PreSettlePrice;
  ///涨跌幅限制类型
  TXeleLimitPriceClassType        LimitPriceClass;
  ///限价单最大买单量
  TXeleMaxLimitOrderVolumeType    MaxLimitBuyVolume;
  ///限价单最大卖单量
  TXeleMaxLimitOrderVolumeType    MaxLimitSellVolume;
  ///限价单最小买单量
  TXeleMinLimitOrderVolumeType    MinLimitBuyVolume;
  ///限价单最小卖单量
  TXeleMinLimitOrderVolumeType    MinLimitSellVolume;
  ///市价单最大买单量
  TXeleMaxMarketOrderVolumeType   MaxMarketBuyVolume;
  ///市价单最大卖单量
  TXeleMaxMarketOrderVolumeType   MaxMarketSellVolume;
  ///市价单最小买单量
  TXeleMinMarketOrderVolumeType   MinMarketBuyVolume;
  ///市价单最小卖单量
  TXeleMinMarketOrderVolumeType   MinMarketSellVolume;
  ///跌停板价
  TXeleLowerPriceType             LowerPrice;
  ///涨停板价
  TXeleUpperPriceType             UpperPrice;
  ///交易所类型
  TXeleMarketType                 Market;
  ///日内可转交易类型,Y表示T+0，N表示T+1
  TXeleDayTradingType             DayTrading;
  ///股票风险级别 , '0' 正常, '1' 风险警示, '2' 退市整理期
  TXeleStockLevel                 StockLevel;
  ///最小报单数量单位
  TXeleLotSize                    LotSize;
  ///发行方式
  TXeleIssueType                  IssueType;
  ///是否注册制
  TXeleIsRegistration             IsRegistration;
  ///是否非交易
  TXeleIsNoTrading                IsNoTrading;
  ///昨收盘价
  TXelePriceType                  PreClosePrice;
  ///预留
  char                            Reserved4[110];
};

///ETF申赎成份股信息查询
struct CXeleReqQryETFCreationRedemptionComponentSecuritiesField {
  ///证券代码 必填 指母基金证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///成份证券代码 选填 不填查所有
  TXeleSecuritiesIDType           ComponentSecurityId;
  ///预留
  char                            Reserved[112];
};

///ETF申赎成股信息查询应答
struct CXeleRspQryETFCreationRedemptionComponentSecuritiesField {
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///成份证券代码
  TXeleSecuritiesIDType           ComponentSecurityId;
  ///成份证券名称
  TXeleSecurityName               ComponentSecurityName;
  ///成份证券来源
  TXeleSecuritySourceType         ComponentSecuritySource;
  ///现金替代标记
  TXeleSubstituteFlag             SubstituteFlag;
  ///成份证券数
  TXeleQuantityType               ComponentShare;
  ///溢价比例
  TXelePriceType                  PremiumRatio;
  ///折价比例
  TXelePriceType                  DiscountRatio;
  ///申购替代金额
  TXelePriceType                  CreationCashSubstitute;
  ///赎回替代金额
  TXelePriceType                  RedemptionCashSubstitute;
  ///预留
  char                            Reserved[160];
};

///ETF申赎母基金信息查询
struct CXeleReqQryETFCreationRedemptionSecuritiesField {
  ///证券代码 选填 不填查所有
  ///注意：在此接口里面指母基金证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///预留
  char                            Reserved[120];
};

///ETF申赎母基金信息查询应答
struct CXeleRspQryETFCreationRedemptionSecuritiesField {
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///合约名称
  TXeleSecurityName               SecurityName;
  ///证券来源
  TXeleSecuritySourceType         SecuritiesSource;
  ///最小申赎单位
  TXeleQuantityType               CreationRedemptionUnit;
  ///预估现金差额
  TXelePriceType                  EstimateCashComponent;
  ///最大现金替代比例
  TXelePriceType                  MaxCashRatio;
  ///申购权限
  TXeleRightFlag                  CreationRight;
  ///赎回权限
  TXeleRightFlag                  RedemptionRight;
  ///本市场成份证券数
  TXeleRecordNumType              RecordNum;
  ///所有成份证券数
  TXeleTotalRecordNum             TotalRecordNum;
  ///现金余额
  TXelePriceType                  CashComponent;
  ///申赎基准单位净值
  TXelePriceType                  NAVperCU;
  ///单位净值
  TXelePriceType                  NAV;
  ///红利金额
  TXelePriceType                  DividendPerCU;
  ///预留
  char                            Reserved[151];
};

/// 股份额度查询请求
struct CXeleReqQryStockQuotaField{
  ///资金账号
  TXeleUserIDType              AccountID;
  ///合约类型
  TXeleSecuritiesType          SecuritiesType;
  ///证券代码
  TXeleSecuritiesIDType        SecuritiesID;
  ///预留
  TXeleReservedType            Reserved;
};

/// 股份额度查询响应
struct CXeleRspQryStockQuotaField {
  ///资金账号
  TXeleUserIDType              AccountID;
  ///合约类型
  TXeleSecuritiesType          SecuritiesType;
  ///证券代码
  TXeleSecuritiesIDType        SecuritiesID;
  ///新股额度
  TXeleStockQuotaType          StockQuota;
  ///新股已申购额度
  TXeleStockQuotaType          StockHoldQuota;
  ///新股剩余额度
  TXeleStockQuotaType          StockAvlQuota;
  ///交易所类型
  TXeleMarketType              Market;
  ///账户级主板新股总额度
  TXeleStockQuotaType          MainBoardStockQuota;
  ///账户级科创板新股总额度
  TXeleStockQuotaType          TechBoardStockQuota;
  ///预留
  char                         Reserved[111];
};

/// 集中交易资金查询请求
struct CXeleReqQryCentralTradingFundField{
  ///机构代码（客户不填）
  TXeleOrgIDType              OrgID;
  ///客户代码（客户不填）
  TXeleUserIDType             CustId;
  ///资金账号
  TXeleUserIDType             AccountID;
  ///币种（客户选填）
  TXeleCurrencyType           Currency;
  ///预留
  char                        Reserved[160];
};

/// 集中交易资金查询响应  
struct CXeleRspQryCentralTradingFundField {
  ///机构代码
  TXeleOrgIDType           OrgID;
  ///客户代码
  TXeleUserIDType          CustId;
  ///资金账号 
  TXeleUserIDType          AccountID;
  ///币种
  TXeleCurrencyType        Currency;
  ///资金余额
  TXeleMoneyType           Fundbal;
  ///资金可用
  TXeleMoneyType           Fundavl;
  ///资金资产
  TXeleMoneyType           Fund;
  ///主资金标志
  TXeleFundType            FundFlag;
  ///预留
  TXeleReservedType        Reserved;
};

/// 交易所网关查询请求
struct CXeleReqQryExChangeGateWayField {
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///预留
  char                            Reserved[49];
};

/// 交易所网关查询响应
struct CXeleRspQryExChangeGateWayField {
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///通道类型
  TXeleChannelType                ChannelType;
  ///网关编号
  TXeleGateWayID                  GateWayID;
  ///网关类型
  TXeleGateWayType                GateWayType;
  ///网关状态
  TXeleGateWayStatus              GateWayStatus;
  ///最近一次网关状态的更新时间
  TXeleEnterTime                  EnterTime;
  ///市场
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[100];
};

////////Ctrl_F_Manager/////////
///////////////////////////////
/////// 其他 //////////////////
//////////////////////////////
///Manager心跳
struct CXeleHeartBeatManager {
  ///预留
  char                            Reserved[9];
};

///Manager登录请求
struct CXeleReqUserLoginManagerField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///交易用户密码
  TXeleUserPasswordType           Password;
  ///终端软件AppID
  TXeleAppIDType                  AppID;
  ///预留
  char                            Reserved1[17];
  ///客户端IP,自动获取
  TXeleClientIpType               ClientIp;
  ///客户端MAC,自动获取
  TXeleClientMacType              ClientMac;
  ///预留
  char                            Reserved2[25];
  ///委托方式
  TXeleOperwayType                Operway;
  ///交易所类型
  TXeleMarketType                 Market;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///站点前缀信息
  TXelePcPreFixType               PcPrefix;
  ///预留
  char                            Reserved3[21];
  ///营业部代码
  TXeleOrgIDType                  BusinessCode;
  ///重连校验字段(内部使用)
  TXeleDateType                   TradingDay;
  ///终端软件AppID扩展字段
  TXeleAppIDExtType               AppIDExt;
  ///预留
  char                            Reserved4[20];
};

///Manager登录应答
struct CXeleRspUserLoginManagerField {
  ///交易日
  TXeleDateType                   TradingDay;
  ///登录成功时间
  TXeleShortTimeType              LoginTime;
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///会话代码
  TXeleSessionIDType              SessionID;
  ///校验用
  TXeleTokenType                  Token;
  ///委托方式
  TXeleOperwayType                Operway;
  ///柜台连接地址
  TXeleCounterURL                 CounterUrl;
  ///客户端登录子节点
  TXeleSubClientIndexType         SubClientIndex;
  ///心跳时间
  TXeleHeartBeatInterval          HeartBeatInterval;
  ///心跳超时时间
  TXeleHeartBeatTimeout           HeartBeatTimeout;
  ///登录的是互联网端口(内部使用)
  TXeleInternetType               IsInternetConnect;
  ///预留
  char                            Reserved[69];
};

///Manager用户登出请求
struct CXeleReqUserLogoutManagerField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///交易所类型
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[63];
};

///Manager用户登出应答
struct CXeleRspUserLogoutManagerField {
  ///交易日
  TXeleDateType                   TradingDay;
  ///登出时间
  TXeleShortTimeType              LogoutTime;
  ///资金账户
  TXeleUserIDType                 AccountID;
  //会话代码
  TXeleSessionIDType              SessionID;
  ///预留
  TXeleReserved1Type              Reserved;
};

///Manager沪深资金调拨请求
struct CXeleReqBTCapTransferManagerField {
  ///预留
  char                            Reserved1[4];
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///币种,该字段无用，默认使用人民币
  TXeleCurrencyType               Currency;
  ///调拨金额
  TXeleMoneyType                  Fundamt;
  ///操作方向
  TXeleDirectionType              TransferDirection;
  ///预留
  char                            Reserved2[63];
};

///Manager沪深资金调拨应答
struct CXeleRspBTCapTransferManagerField {
  ///全局唯一消息编号 从1开始递增
  TXeleUniqueNumberType           UniqueNumber;
  ///机构代码
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///币种
  TXeleCurrencyType               Currency;
  ///调拨金额
  TXeleMoneyType                  Fundamt;
  ///操作方向
  TXeleDirectionType              TransferDirection;
  ///预留
  char                            Reserved[63];
};

///Manager沪深资金调拨结果回报
struct CXeleRtnBtCapTransferManagerField {
  ///全局唯一消息编号
  TXeleUniqueNumberType           UniqueNumber;
  ///机构代码
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///币种
  TXeleCurrencyType               Currency;
  ///调拨金额
  TXeleMoneyType                  Fundamt;
  ///操作方向
  TXeleDirectionType              TransferDirection;
  ///操作结果, '0':调拨失败,'1':调拨成功
  char                            TransferResult;
  ///预留
  char                            Reserved[63];
};

///Manager沪深资金调拨记录查询请求
struct CXeleReqQryBTCapTransferManagerField {
  ///预留
  char                            Reserved1[4];
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///预留
  char                            Reserved2[63];
};

///Manager沪深资金调拨记录查询应答
struct CXeleRspQryBTCapTransferManagerField {
  ///全局唯一消息编号
  TXeleUniqueNumberType           UniqueNumber;
  ///机构代码
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///币种
  TXeleCurrencyType               Currency;
  ///调拨金额
  TXeleMoneyType                  Fundamt;
  ///操作方向
  TXeleDirectionType              TransferDirection;
  ///操作时间
  TXeleShortTimeType              TransferTime;
  ///错误编号
  TXeleErrorIDType                ErrorNo;
  ///内部调用过程，不用关注
  ///'1'接受到调拨消息,'2'发出调拨请求结束,'3'接受到调出结束消息,'4'发出调入消息请求结束,'5'接受到调入结束消息,'6'操作结束
  TXeleOrderStatusType            TransferProcessFlag;
  ///资金冲正操作标记
  TXeleIsFundReversalType         IsFundReversal;
  ///资金冲正柜台
  TXeleReversalCounterType        ReversalCounter;
  ///资金冲正结果标记
  TXeleReversalResultType         ReversalResult;
  ///资金自动调拨
  TXeleIsAutoTransFlag            IsAutoTrans;
  ///预留
  char                            Reserved[61];
};

///Manager沪深柜台资金账户查询请求
struct CXeleReqQryClientAccountFundManagerField{
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///交易所类型
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[48];
};

///Manager沪深柜台资金账户查询应答
struct CXeleRspQryClientAccountFundManagerField{
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///可用余额
  TXeleAvailableFundType          AvailableFund;
  ///预留
  char                            Reserved1[8];
  ///冻结资金
  TXeleFrozeMarginType            FrozeFund;
  ///冻结手续费
  TXeleFrozenFeeType              FrozenFee;
  ///已付手续费
  TXeleUsedFeeType                UsedFee;
  ///初始上场资金（不变
  TXeleTotalFundType              InitTotalFund;
  ///总卖出
  TXeleSellFund                   SellFund;
  ///总买入
  TXeleBuyFund                    BuyFund;
  ///交易所类型
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved2[48];
};

struct ExternInfoField {
  TXeleApiVersion       ApiVersion;
  TXeleApiMode          ApiMode;
};

struct SysLocalInfoField {
  ///mac地址
  TXeleMacAddrType        MacAddr;
  ///硬盘序列号
  TXeleHardDiskSerialType HardDiskSerial;
  ///ip地址
  TXeleIpAddrType         IpAddr;
  ///cpu序列号
  TXeleCpuSerialType      CpuSerial;
  ///主机名称
  TXeleHostNameType       HostName;
};

struct SuperviseExtraInfoField {
  char SuperviseExtraInfo[128];
};

struct AllSuperviseInfoField {
  char AllSuperviseInfo[384];
};

///用户查询自己的股东账号等其他相关信息请求
struct CXeleReqQryInvestorInfoField {
  ///资金账户
  TXeleUserIDType                AccountID;
  ///预留
  TXeleReservedType              Reserved;
};

///用户查询自己的股东账号等其他相关信息应答
struct CXeleRspQryInvestorInfoField {
  ///资金账户
  TXeleUserIDType                AccountID;
  ///市场
  TXeleMarketType                Market;
  ///股东账户
  TXeleInvestorIDType            InvestorID;
  ///股东姓名
  TXeleInvestorNameType          InvestorName;
  ///股东权限
  TXeleInvestorRightsType        InvestorRights;
  ///席位编号
  TXeleInvestorPbuType           InvestorPbu;
  ///客户代码
  TXeleUserIDType                CustID;
  /// 专业投资者标志
  TXeleInvestorFlag              InvestorFlag;
  ///预留
  char                           Reserved[112];
};

///持仓划拨请求(中信柜台专用，其他券商不支持)
struct CXeleReqPosTransferField {
  ///机构代码(可选)
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///股东账户(不使用)
  TXeleInvestorIDType             InvestorID;
  ///市场代码(可选)
  TXeleMarketIDType               MarketID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///股份发生数
  TXeleSignedVolumeType           Volume;
  ///划拨方向
  TXeleDirectionType              TransferDirection;
  ///备注(不使用)
  TXeleRemarkType                 RemarkMsg;
  ///只执行一次集中柜台冻结(不使用)
  TXeleCallOneceFlag              CallOnce;
  ///分支机构(不使用)
  TXeleBranchNoType               BranchNo;
  ///客户代码(不使用)
  TXeleUserIDType                 CustID;
  ///预留
  char                            Reserved[44];
};

///持仓划拨应答(中信柜台专用，其他券商不支持)
struct CXeleRspPosTransferField {
  ///机构代码
  TXeleOrgIDType                  OrgID;
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///股东账户
  TXeleInvestorIDType             InvestorID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///fpga仓位是否更新
  TXeleIsUpdateFpgaFundType       IsUpdateFpgaStock;
  ///操作流水号
  TXeleSnoType                    Sno;
  ///股份发生数
  TXeleSignedVolumeType           stkeffect;
  ///错误信息
  TXeleCentralTradingErrorMsgType ptErrorMsg;
  ///预留
  char                            Reserved[44];
};

///集中交易持仓调拨艾科柜台明细查询请求(中信柜台专用，其他券商不支持)
struct CXeleReqQryPositionTransferRecordField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///预留
  TXeleReservedType               Reserved;
};

///集中交易持仓调拨艾科柜台明细查询应答(中信柜台专用，其他券商不支持)
struct CXeleRspQryPositionTransferRecordField {
  ///机构代码
  TXeleOrgIDType                  OrgID;
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///冻结/解冻仓位
  TXeleVolumeType                 Stkeffect;
  ///操作方向
  TXeleDirectionType              Direction;
  ///fpga仓位是否更新
  TXeleIsUpdateFpgaFundType       IsUpdateFpgaFund;
  ///执行信息
  TXeleCentralTradingErrorMsgType posTransMsg;
  ///操作时间
  TXeleShortTimeType              Time;
  ///操作流水号
  TXeleSnoType                    Sno;
  ///预留
  char                            Reserved[59];
};

///持仓划拨请求(部分券商使用)
struct CXeleReqInOutPositionField {
  ///资金账号(必填)
  TXeleUserIDType                 AccountID;
  ///证券代码(必填)
  TXeleSecuritiesIDType           SecuritiesID;
  ///划拨数量(必填)
  TXeleVolumeType                 Volume;
  ///划拨方向
  TXeleInOutDirectionType         InOutDirection;
  ///预留(客户不填)
  char                            Reserved[128];
};

///持仓划拨应答(部分券商使用)
struct CXeleRspInOutPositionField {
  ///机构代码
  TXeleOrgIDType                      OrgID;
  ///资金账号
  TXeleUserIDType                     AccountID;
  ///证券代码
  TXeleSecuritiesIDType               SecuritiesID;
  ///股东账户
  TXeleInvestorIDType                 InvestorID;
  ///fpga仓位是否更新,暂不使用
  TXeleIsUpdateFpgaFundType           IsUpdateFpgaStock;
  ///操作流水号
  TXeleSnoType                        Sno;
  ///划拨数量
  TXeleVolumeType                     Volume;
  ///划拨方向
  TXeleInOutDirectionType             InOutDirection;
  ///集中交易柜台响应错误码,若没有错误码时，返回-1，代表无效值
  TXeleCentralTradingErrorIdType      CtErrorId;
  ///集中交易柜台响应错误信息
  TXeleCentralTradingErrorMsgLongType CtErrorMsg;
  ///预留
  char                                Reserved[128];
};

///集中交易持仓调拨艾科柜台明细查询请求(部分券商使用)
struct CXeleReqQryInOutPositionDetailsField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码(选填)
  TXeleSecuritiesIDType           SecuritiesID;
  ///预留
  char Reserved[128];
};

///集中交易持仓调拨艾科柜台明细查询应答(部分券商使用)
struct CXeleRspQryInOutPositionDetailsField {
  ///机构代码
  TXeleOrgIDType                      OrgID;
  ///资金账户
  TXeleUserIDType                     AccountID;
  ///证券代码
  TXeleSecuritiesIDType               SecuritiesID;
  ///仓位变动数量
  TXeleVolumeType                     Stkeffect;
  ///划拨方向
  TXeleInOutDirectionType             InOutDirection;
  ///fpga仓位是否更新
  TXeleIsUpdateFpgaFundType           IsUpdateFpgaStock;
  ///艾科柜台响应错误码
  TXeleErrorIDType                    ErrorNo;
  ///艾科柜台响应错误信息
  TXeleErrorMsgType                   ErrorMsg;
  ///集中交易柜台响应错误码,若没有错误码时，返回-1，代表无效值
  TXeleCentralTradingErrorIdType      CtErrorId;
  ///集中交易柜台响应错误信息,
  TXeleCentralTradingErrorMsgLongType CtErrorMsg;
  ///操作时间
  TXeleShortTimeType                  Time;
  ///操作来源
  TXeleActionSourceType               ActionSource;
  ///操作流水号
  TXeleSnoType                        Sno;
  ///预留
  char                                Reserved[123];
};

///用户可用网关信息查询请求(部分券商使用)
struct CXeleReqQryAvailableGateWayRecordField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///预留
  char                            Reserved1;
  ///预留
  TXeleReservedType               Reserved2;
};

struct CXeleRspQryAvailableGateWayRecordField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///交易所类型
  TXeleMarketType                 Market;
  ///竞价网关,报单时需要转换成整型，如'1'转换成1后填充指定网关字段
  TXeleGateWay                    BidGateWays;
  ///债券网关,报单时需要转换成整型，如'1'转换成1后填充指定网关字段
  TXeleGateWay                    BondGateWays;
  ///预留
  TXeleReserved3Type               Reserved;
};

//////////////////////////////
/////// API通用接口系列      //
//////////////////////////////

///上场前写入用户密码请求
struct CXeleReqAccountInitField{
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///交易用户密码
  TXeleUserPasswordType           Password;
  ///交易所类型
  TXeleMarketType                 Market;
  ///命令号
  TXeleCommandNum                 CommandNum;
  ///委托方式 内部使用
  TXeleOperwayType                Operway;
  ///柜台ip 内部使用
  TXeleTradeIPType                QueryURL;
  ///预留
  char                            Reserved[66];
};

struct CXeleRspCommonFuncField{
  ///命令号
  TXeleCommandNum                 CommandNum;
  ///预留
  char                            Reserved[108];
};

///查询程序化风控信息请求(部分券商使用)
struct CXeleReqQryPrcProgramInfoField {
  ///资金账户
  TXeleUserIDType                AccountID;
  ///程序化风控类别
  TXelePrcProgramType            PrcProgramType;
  ///预留
  char                           Reserved[20];
};

struct CXeleRspQryRateLimitInfoField {
  ///单位时间(毫秒)
  TXeleTimeUnitType           timeUnit;
  ///单位时间流速阈值
  TXelePrcProgramTresholdType RateLimit;
  ///证券类别
  TXelePrcSecuritiesType      PrcSecuritiesType;
  ///预留
  char                        Reserved[30];
};

struct CXeleRspQryDailyLimitInfoField {
  ///全天委托笔数阈值
  TXelePrcProgramTresholdType  OrderCountLimit;
  ///当前委撤笔数 (程序化风控类别为全天报撤笔数限制风控时有效)
  TXeleCurrentOrderCountType   CurrentOrderCount;
  ///证券类别
  TXelePrcSecuritiesType       PrcSecuritiesType;
  ///预留
  char                         Reserved[30];
};

///查询程序化风控信息应答(部分券商使用)
struct CXeleRspQryPrcProgramInfoField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///市场
  TXeleMarketType                 Market;
  ///程序化风控类别
  TXelePrcProgramType             PrcProgramType;
  ///风控开关
  TXelePrcProgramEnableType       Enable;
  union {
    CXeleRspQryRateLimitInfoField  orderRateLimit;
    CXeleRspQryDailyLimitInfoField dailyLimit;
  } prcProgrmData;
  ///预留
  char                            Reserved[60];
};

///仓位变化回报通知(部分券商使用)
struct CXeleRtnInOutPositionField {
  ///资金账户
  TXeleUserIDType                 AccountID;
  ///证券代码
  TXeleSecuritiesIDType           SecuritiesID;
  ///市场
  TXeleMarketType                 Market;
  ///仓位变化数量
  TXeleVolumeType                 Volume;
  ///划拨方向
  TXeleInOutDirectionType         InOutDirection;
  ///流水号
  Long                            SerialNum;
  ///操作时间，格式：HHMMSSsssuuunnn,表示柜台接收到请求后处理完请求的时间
  TXeleEnterTime                  Time;
  ///划拨模式
  TXeleInOutMode                  InOutMode;
  ///预留
  char                            Reserved[64];
};

///交易所网关信息通知
struct CXeleRtnExChangeGateWayField {
  ///资金账号
  TXeleUserIDType                 AccountID;
  ///通道类型
  TXeleChannelType                ChannelType;
  ///网关编号
  TXeleGateWayID                  GateWayID;
  ///网关类型
  TXeleGateWayType                GateWayType;
  ///网关状态
  TXeleGateWayStatus              GateWayStatus;
  ///最近一次网关状态的更新时间
  TXeleEnterTime                  EnterTime;
  ///市场
  TXeleMarketType                 Market;
  ///预留
  char                            Reserved[100];
};

#pragma pack(pop)

#endif
