/**
 * @file bareMessageDefine.h
 * @author root
 * @brief 定义了Fair协议的消息ID
 * @date 25-7-16
 *
 * 详细的文件描述或注意事项可以放在这里。
 */
#ifndef SECURITY_TRADER_API_BAREMESSAGEDEFINE_H
#define SECURITY_TRADER_API_BAREMESSAGEDEFINE_H

/*
 * TID 柜台端消息定义
 */

/// 心跳消息定义
#define TID_HEARTBEAT_TRADE_SERVER_2_CLIENT                           2  //报单链路服务端到客户端心跳
#define TID_HEARTBEAT_TRADE_CLIENT_2_SERVER                           3  //报单链路客户端到服务端心跳
#define TID_HEAETBEAT_QUERY_CLIENT_2_SERVER                           5  //查询链路客户端到服务端心跳
#define TID_HEARTBEAT_QUERY_SERVER_2_CLIENT                           6  //查询链路服务端到客户端心跳

/// 查询链路消息定义
#define TID_REQ_USER_UPDATE_PWD                                       11  // 用户改密码请求
#define TID_RSP_USER_UPDATE_PWD                                       12  // 用户改密码应答
#define TID_REQ_USER_LOGIN                                            13  // 用户登录请求
#define TID_RSP_USER_LOGIN                                            14  // 用户登录应答
#define TID_REQ_USER_LOGOUT                                           15  // 用户退出请求
#define TID_RSP_USER_LOGOUT                                           16  // 用户退出应答
#define TID_REQ_INIT_TRADER                                           17  // 用户添加交易链路请求
#define TID_RSP_INIT_TRADER                                           18  // 用户添加交易链路请求应答
#define TID_REQ_QRY_ORDER                                             19  // 查询报单请求
#define TID_RSP_QRY_ORDER                                             20  // 查询报单应答
#define TID_REQ_QRY_TRADE                                             21  // 查询成交请求
#define TID_RSP_QRY_TRADE                                             22  // 查询成交应答
#define TID_REQ_QRY_STOCK_CLIENT_ACCOUNT                              23  // 查询账户资金请求
#define TID_RSP_QRY_STOCK_CLIENT_ACCOUNT                              24  // 查询账户资金应答
#define TID_REQ_QRY_STOCK_POSITION                                    25  // 持仓查询请求
#define TID_RSP_QRY_STOCK_POSITION                                    26  // 持仓查询应答
#define TID_REQ_QRY_STOCK_INISTRUMENT                                 27  // 证券代码信息查询请求
#define TID_RSP_QRY_STOCK_INISTRUMENT                                 28  // 证券代码信息查询应答
#define TID_REQ_QRY_COMMISSION_RATE                                   29  // 查询费率请求
#define TID_RSP_QRY_COMMISSION_RATE                                   30  // 查询费率应答
#define TID_REQ_FREEZE_CAP											  39  // 资金调拨请求(调入艾科柜台)
#define TID_RSP_FREEZE_CAP											  40  // 资金调拨应答(调入艾科柜台)
#define TID_REQ_UNFREEZE_CAP										  41  // 资金调拨请求(调出艾科柜台)
#define TID_RSP_UNFREEZE_CAP										  42  // 资金调拨应答(调出艾科柜台)
#define TID_REQ_QRY_CAP_TRANSFER_RECORD								  43  // 集中资金调拨记录查询请求
#define TID_RSP_QRY_CAP_TRANSFER_RECORD								  44  // 集中资金调拨记录查询应答
#define TID_REQ_FREEZE_POSITION										  55  // 集中持仓调拨请求(调入艾科柜台)
#define TID_RSP_FREEZE_POSITION										  56  // 集中持仓调拨应答(调入艾科柜台)
#define TID_REQ_UNFREEZE_POSITION									  57  // 集中持仓调拨请求(调出艾科柜台)
#define TID_RSP_UNFREEZE_POSITION									  58  // 集中持仓调拨应答(调出艾科柜台)
#define TID_REQ_QRY_CENTRAL_TRADING_FUND							  59  // 集中柜台资金查询请求
#define TID_RSP_QRY_CENTRAL_TRADING_FUND        					  60  // 集中柜台资金查询应答
#define TID_REQ_QRY_STOCK_QUOTA                                       61  // 股份额度查询请求
#define TID_RSP_QRY_STOCK_QUOTA                                       62  // 股份额度查询应答
#define TID_REQ_QRY_INVESTOR_INFO                                     63  // 投资者信息查询请求
#define TID_RSP_QRY_INVESTOR_INFO                                     64  // 投资者信息查询应答
#define TID_REQ_USER_ENCRYPTION_LOGIN                                 65  // 加密方式用户登录请求
#define TID_REQ_USER_ENCRYPTION_UPDATE_PWD                            67  // 加密方式用户改密码请求
#define TID_RSP_USER_ENCRYPTION_UPDATE_PWD                            68  // 加密方式用户改密码应答
#define TID_REQ_QRY_PRC_PROGRAM_INFO                                  69  // 查询程序化风控信息请求
#define TID_RSP_QRY_PRC_PROGRAM_INFO                                  70  // 查询程序化风控信息应答
#define TID_REQ_INOUT_POSTION                                         71  // 集中交易持仓调入/调出艾科柜台请求
#define TID_RSP_INOUT_POSTION                                         72  // 集中交易持仓调入/调出艾科柜台应答
#define TID_REQ_QRY_INOUT_POSTION_DETAILS                             73  // 集中交易持仓调拨艾科柜台明细查询请求
#define TID_RSP_QRY_INOUT_POSTION_DETAILS                             74  // 集中交易持仓调拨艾科柜台明细查询应答
#define TID_REQ_QRY_EXCHANGE_GATEWAY                                  75 /// 交易所网关查询请求
#define TID_RSP_QRY_EXCHANGE_GATEWAY                                  76 /// 交易所网关查询应答
#define TID_RTN_EXCHANGE_GATEWAY                                      77 /// 交易所网关信息通知
#define TID_RTN_INOUT_POSITION                                        78 /// 仓位变化回报通知
#define TID_REQ_QRY_ETF_REDEMPTION                                    96  // 查询etf母基金信息请求
#define TID_RSP_QRY_ETF_REDEMPTION                                    97  // 查询etf母基金信息应答
#define TID_REQ_QRY_ETF_COMPONENT                                     98  // 查询etf成份股信息请求
#define TID_RSP_QRY_ETF_COMPONENT                                     99  // 查询etf成份股信息应答
#define TID_REQ_QRY_POSITION_TRANSFER_RECORD                          151  //持仓划拨查询请求
#define TID_RSP_QRY_POSITION_TRANSFER_RECORD                          152  //持仓划拨查询应答
#define TID_REQ_QRY_GATEWAYS_RECORD                                   153  //启用网关平台配置查询请求
#define TID_RSP_QRY_GATEWAYS_RECORD                                   154  //启用网关平台配置查询应答
#define TID_REQ_QRY_QFII_ORDER                                        155  //查询QFII报单请求
#define TID_RSP_QRY_QFII_ORDER                                        156  //查询QFII报单响应
#define TID_REQ_QRY_QFII_TRADE                                        157  //查询QFII成交请求
#define TID_RSP_QRY_QFII_TRADE                                        158  //查询QFII成交响应
#define TID_REQ_QRY_QFII_STOCK_POSITION                               159 // QFII持仓查询请求
#define TID_RSP_QRY_QFII_STOCK_POSITION                               160 // QFII持仓查询应答

///交易链路消息定义
#define TID_REQ_ORDER_INSERT                                          101  // 报单请求
#define TID_RSP_ORDER_INSERT                                          102  // 报单应答
#define TID_REQ_ORDER_ACTION                                          103  // 撤单请求
#define TID_RSP_ORDER_ACTION                                          104  // 撤单应答
#define TID_ERR_ORDER_INSERT                                          201  // 报单错误应答
#define TID_ERR_ORDER_ACTION                                          203  // 撤单错误应答
#define TID_RTN_ORDER                                                 214  // 报单回报
#define TID_RTN_TRADE                                                 217  // 成交回报
/*
 * MID Manager端消息定义
 */
/// 心跳消息定义
#define MID_HEAETBEAT_CLIENT_2_SERVER                                 2    // 查询链路客户端到服务端心跳（api到manager）
#define MID_HEARTBEAT_SERVER_2_CLIENT                                 3    // 查询链路服务端到客户端心跳（manager到api）

#define MID_REQ_USER_LOGIN                                            11   // 用户登录请求
#define MID_RSP_USER_LOGIN                                            12   // 用户登录应答
#define MID_REQ_USER_LOGOUT                                           13   // 用户退出请求
#define MID_RSP_USER_LOGOUT                                           14   // 用户退出应答
#define MID_REQ_BT_CAP_TRANSFER                                       15   // 柜台间资金调拨请求
#define MID_RSP_BT_CAP_TRANSFER                                       16   // 柜台间资金调拨应答
#define MID_REQ_QRY_BT_CAP_TRANSFER                                   17   // 柜台间资金调拨记录查询请求
#define MID_RSP_QRY_BT_CAP_TRANSFER                                   18   // 柜台间资金调拨记录查询应答
#define MID_REQ_QRY_CLIENT_ACCOUNT_FUND                               19   // 沪深柜台资金查询请求
#define MID_RSP_QRY_CLIENT_ACCOUNT_FUND                               20   // 沪深柜台资金账户查询应答

#endif //SECURITY_TRADER_API_BAREMESSAGEDEFINE_H
