/**
 * @file errorCode_Bare.cpp
 * @author root
 * @brief 简要描述文件的功能或用途
 * @date 25-7-16
 *
 * 详细的文件描述或注意事项可以放在这里。
 */

#include <errorCode_Bare.h>
#include <string.h>

const char* SSStockErrorMsg[SS_STOCK_ERROR_END];
const char* SZSEErrorMsg[SZSE_ERR_CODE_END];
const char* StockCommonErrorMsg[SS_STOCK_ERROR_END];
const char* XeleManagerErrorMsg[SHARE_OTHERS];

int ApiErrorMsg::Init() {
  //SS stock
  SSStockErrorMsg[SS_STOCK_ERROR_202] = "Invalid PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_203] = "Invalid SecurityID";
  SSStockErrorMsg[SS_STOCK_ERROR_204] = "Non-trading time";
  SSStockErrorMsg[SS_STOCK_ERROR_208] = "Invalid Direction";
  SSStockErrorMsg[SS_STOCK_ERROR_209] = "Wrong contract group";
  SSStockErrorMsg[SS_STOCK_ERROR_211] = "This contract unavailable for this account";
  SSStockErrorMsg[SS_STOCK_ERROR_212] = "Wrong request price";
  SSStockErrorMsg[SS_STOCK_ERROR_213] = "Security suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_214] = "The stock not participant in aution";
  SSStockErrorMsg[SS_STOCK_ERROR_215] = "Invalid AccountID";
  SSStockErrorMsg[SS_STOCK_ERROR_216] = "The account not assigned to your seat";
  SSStockErrorMsg[SS_STOCK_ERROR_217] = "Account has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_218] = "Invalid request price";
  SSStockErrorMsg[SS_STOCK_ERROR_219] = "Price can not be 0";
  SSStockErrorMsg[SS_STOCK_ERROR_220] = "Price not meet the minimum step";
  SSStockErrorMsg[SS_STOCK_ERROR_222] = "Price out of range";
  SSStockErrorMsg[SS_STOCK_ERROR_223] = "Volume must be an integer multiple of 1000";
  SSStockErrorMsg[SS_STOCK_ERROR_224] = "Invalid volume";
  SSStockErrorMsg[SS_STOCK_ERROR_225] = "Volume must be greater than 0";
  SSStockErrorMsg[SS_STOCK_ERROR_226] = "New shares Volume at least 1000";
  SSStockErrorMsg[SS_STOCK_ERROR_227] = "Volume not meet the minimum step";
  SSStockErrorMsg[SS_STOCK_ERROR_228] = "Volume exceeds the maximum allowable bid limit";
  SSStockErrorMsg[SS_STOCK_ERROR_231] = "Insufficient balance";
  SSStockErrorMsg[SS_STOCK_ERROR_234] = "Position exceeds the limit";
  SSStockErrorMsg[SS_STOCK_ERROR_236] = "PBU has no permission to buy";
  SSStockErrorMsg[SS_STOCK_ERROR_237] = "PBU has no permission to sell";
  SSStockErrorMsg[SS_STOCK_ERROR_243] = "Fund account or institution account can not buy or sell this securities";
  SSStockErrorMsg[SS_STOCK_ERROR_244] = "'S' account can not buy";
  SSStockErrorMsg[SS_STOCK_ERROR_245] = "Can not cancel";
  SSStockErrorMsg[SS_STOCK_ERROR_246] = "Can not cancel";
  SSStockErrorMsg[SS_STOCK_ERROR_247] = "Can not cancel";
  SSStockErrorMsg[SS_STOCK_ERROR_248] = "Cannel not allowed by CSDC";
  SSStockErrorMsg[SS_STOCK_ERROR_250] = "Wrong B-share firmid";
  SSStockErrorMsg[SS_STOCK_ERROR_252] = "Invalid PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_253] = "No permission";
  SSStockErrorMsg[SS_STOCK_ERROR_257] = "Discontinuous rec_num";
  SSStockErrorMsg[SS_STOCK_ERROR_263] = "Market orders not participate in auction";
  SSStockErrorMsg[SS_STOCK_ERROR_264] = "Counterparty has no unsettled orders";
  SSStockErrorMsg[SS_STOCK_ERROR_265] = "The counterparty and the party have no unsettled orders";
  SSStockErrorMsg[SS_STOCK_ERROR_266] = "This securities group not allowed for market order";
  SSStockErrorMsg[SS_STOCK_ERROR_267] = "Account has no permission to process account-style pledge repurchase transactions and deposits and withdrawals";
  SSStockErrorMsg[SS_STOCK_ERROR_268] = "Uniform error codes for out-put and in-put of warehouse";
  SSStockErrorMsg[SS_STOCK_ERROR_269] = "Wrong OrderType";
  SSStockErrorMsg[SS_STOCK_ERROR_270] = "Wrong OrderType";
  SSStockErrorMsg[SS_STOCK_ERROR_271] = "The account has assigned to your seat";
  SSStockErrorMsg[SS_STOCK_ERROR_272] = "Can not trade without specified participants";
  SSStockErrorMsg[SS_STOCK_ERROR_273] = "Account not be traded through floor offers";
  SSStockErrorMsg[SS_STOCK_ERROR_274] = "The reporting account for credit transactions must be an E-account";
  SSStockErrorMsg[SS_STOCK_ERROR_275] = "The reporting account for ordinary transactions must not be an E-account";
  SSStockErrorMsg[SS_STOCK_ERROR_276] = "The Securities not support trading with collateral";
  SSStockErrorMsg[SS_STOCK_ERROR_277] = "Insufficient permission for credit selling";
  SSStockErrorMsg[SS_STOCK_ERROR_278] = "Not allow to buy by financing";
  SSStockErrorMsg[SS_STOCK_ERROR_279] = "Insufficient permission to repay by selling securities or finance by liquidating";
  SSStockErrorMsg[SS_STOCK_ERROR_280] = "Insufficient permission to return by buying or margin trading by liquidating";
  SSStockErrorMsg[SS_STOCK_ERROR_281] = "The securities are not allowed to be sold for margin selling";
  SSStockErrorMsg[SS_STOCK_ERROR_282] = "The margin selling price is lower than the latest price";
  SSStockErrorMsg[SS_STOCK_ERROR_283] = "Special account must be configured for special business";
  SSStockErrorMsg[SS_STOCK_ERROR_401] = "Invalid PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_403] = "Invalid rec_num";
  SSStockErrorMsg[SS_STOCK_ERROR_404] = "The rec_num of cancelled order checked failed";
  SSStockErrorMsg[SS_STOCK_ERROR_405] = "The stock account of cancelled order checked failed";
  SSStockErrorMsg[SS_STOCK_ERROR_406] = "The SeciritiesID of cancelled order checked failed";
  SSStockErrorMsg[SS_STOCK_ERROR_407] = "Direction of cancelled order checked failed";
  SSStockErrorMsg[SS_STOCK_ERROR_408] = "Order has been cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_409] = "Can only be cancelled by buying 799998";
  SSStockErrorMsg[SS_STOCK_ERROR_410] = "Can only be cancelled by buying 799999";
  SSStockErrorMsg[SS_STOCK_ERROR_411] = "The corresponding bid has been completed and the order can not be cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_412] = "Cancell not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_413] = "Cancel order failed, the order was traded or cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_499] = "None can be cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_507] = "Background application error";
  SSStockErrorMsg[SS_STOCK_ERROR_731] = "Fund companies not upload ETF purchase redemption list";
  SSStockErrorMsg[SS_STOCK_ERROR_732] = "Wrong ETF status";
  SSStockErrorMsg[SS_STOCK_ERROR_733] = "ETF investors have insufficient Position";
  SSStockErrorMsg[SS_STOCK_ERROR_734] = "Substitution Ratio of ETF cash exceed the ratio ruled";
  SSStockErrorMsg[SS_STOCK_ERROR_735] = "Insufficient balance, can not redeem";
  SSStockErrorMsg[SS_STOCK_ERROR_736] = "ETF fund account not buy or redeemed";
  SSStockErrorMsg[SS_STOCK_ERROR_752] = "No cash coupons in this account";
  SSStockErrorMsg[SS_STOCK_ERROR_753] = "Insufficient cash coupons in this account";
  SSStockErrorMsg[SS_STOCK_ERROR_754] = "No standard coupons in this account";
  SSStockErrorMsg[SS_STOCK_ERROR_755] = "Insufficient standard coupons in this account";
  SSStockErrorMsg[SS_STOCK_ERROR_756] = "No pledged bonds in this account";
  SSStockErrorMsg[SS_STOCK_ERROR_757] = "Insufficient pledged coupons int this account";
  SSStockErrorMsg[SS_STOCK_ERROR_758] = "Conversion rate of standard coupon not initialized";
  SSStockErrorMsg[SS_STOCK_ERROR_759] = "Standard coupons code not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_1005] = "Login to host failed";
  SSStockErrorMsg[SS_STOCK_ERROR_1014] = "Failed to log in to PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_1015] = "Failed to change password";
  SSStockErrorMsg[SS_STOCK_ERROR_1021] = "Discontinuous rec_num";
  SSStockErrorMsg[SS_STOCK_ERROR_1022] = "Wrong SecurityID or non-market products";
  SSStockErrorMsg[SS_STOCK_ERROR_1023] = "Wrong Account ID";
  SSStockErrorMsg[SS_STOCK_ERROR_1024] = "Wrong Direction";
  SSStockErrorMsg[SS_STOCK_ERROR_1025] = "Wrong Price";
  SSStockErrorMsg[SS_STOCK_ERROR_1026] = "Wrong Volume";
  SSStockErrorMsg[SS_STOCK_ERROR_1027] = "Wrong Date";
  SSStockErrorMsg[SS_STOCK_ERROR_1028] = "Wrong sign for order or cancel order";
  SSStockErrorMsg[SS_STOCK_ERROR_1029] = "Wrong clearing member ID";
  SSStockErrorMsg[SS_STOCK_ERROR_1030] = "Wrong ordrec domain of cancel order";
  SSStockErrorMsg[SS_STOCK_ERROR_1031] = "Ordrec field of the cancel order greater than or equal to the rec_num field of the cancel order";
  SSStockErrorMsg[SS_STOCK_ERROR_1034] = "Cancelled order discarded";
  SSStockErrorMsg[SS_STOCK_ERROR_1039] = "The status of order is 'P' or 'p'";
  SSStockErrorMsg[SS_STOCK_ERROR_1040] = "The status of order is neither 'P' nor 'p'";
  SSStockErrorMsg[SS_STOCK_ERROR_1042] = "An error occurred while communicating";
  SSStockErrorMsg[SS_STOCK_ERROR_1043] = "Wrong received packet";
  SSStockErrorMsg[SS_STOCK_ERROR_1050] = "The cancelled order not exist or SecurityID of the cancelled order wrong";
  SSStockErrorMsg[SS_STOCK_ERROR_1100] = "The offer number too large";
  SSStockErrorMsg[SS_STOCK_ERROR_1101] = "Records mismatch";
  SSStockErrorMsg[SS_STOCK_ERROR_1102] = "Wrong format of business branchID";
  SSStockErrorMsg[SS_STOCK_ERROR_1103] = "Unable to resolve order";
  SSStockErrorMsg[SS_STOCK_ERROR_2000] = "Connect to exchange failed";
  SSStockErrorMsg[SS_STOCK_ERROR_2001] = "Date of the cancelled order not today";
  SSStockErrorMsg[SS_STOCK_ERROR_2004] = "Account which cancels order not mine";
  SSStockErrorMsg[SS_STOCK_ERROR_2006] = "SecurityID of the cancelled order in record inconsistent with the cancelled order";
  SSStockErrorMsg[SS_STOCK_ERROR_2007] = "Price of the cancelled order in record inconsistent with the cancelled order";
  SSStockErrorMsg[SS_STOCK_ERROR_2008] = "Can only cancel order which exists";
  SSStockErrorMsg[SS_STOCK_ERROR_2101] = "Wrong Direction of cancelled order";
  SSStockErrorMsg[SS_STOCK_ERROR_2102] = "Wrong Volume of cancelled order";
  SSStockErrorMsg[SS_STOCK_ERROR_3000] = "Failed to connect to the database";
  SSStockErrorMsg[SS_STOCK_ERROR_3001] = "The transaction date recorded in the database is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_3002] = "The truncate database record failed";
  SSStockErrorMsg[SS_STOCK_ERROR_3701] = "The release package does not exist or the release package path is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_3702] = "The wrong installation path was selected";
  SSStockErrorMsg[SS_STOCK_ERROR_3703] = "Getting the project name is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_3704] = "If the backup fails, you need to exit the software or close the related files and try again";
  SSStockErrorMsg[SS_STOCK_ERROR_3705] = "ZIP error while extracting";
  SSStockErrorMsg[SS_STOCK_ERROR_3706] = "I/O error during decompression";
  SSStockErrorMsg[SS_STOCK_ERROR_3707] = "The parameters are invalid or incorrect during decompression";
  SSStockErrorMsg[SS_STOCK_ERROR_3708] = "Unable to find the old version configuration file";
  SSStockErrorMsg[SS_STOCK_ERROR_3709] = "The new version configuration file does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_3710] = "Internal storage failure when updating a configuration file";
  SSStockErrorMsg[SS_STOCK_ERROR_3711] = "The file format is not up to specification when updating the configuration file";
  SSStockErrorMsg[SS_STOCK_ERROR_3712] = "IO error while updating the configuration file";
  SSStockErrorMsg[SS_STOCK_ERROR_3713] = "IO error while copying a file";
  SSStockErrorMsg[SS_STOCK_ERROR_3714] = "Software recovery failed";
  SSStockErrorMsg[SS_STOCK_ERROR_4001] = "Failed to get reference data";
  SSStockErrorMsg[SS_STOCK_ERROR_4003] = "Check old password is correct or new password is of correct length";
  SSStockErrorMsg[SS_STOCK_ERROR_4004] = "Failed to connect to host, other errors";
  SSStockErrorMsg[SS_STOCK_ERROR_4005] = "The IP binding failed";
  SSStockErrorMsg[SS_STOCK_ERROR_4006] = "The connection to the host timed out";
  SSStockErrorMsg[SS_STOCK_ERROR_4007] = "Failed to connect to host, underlying I/O unknown error";
  SSStockErrorMsg[SS_STOCK_ERROR_4008] = "Trader login failed";
  SSStockErrorMsg[SS_STOCK_ERROR_4009] = "Failed to get trading schedule";
  SSStockErrorMsg[SS_STOCK_ERROR_4010] = "The format of the ISIX in the reference data is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_4011] = "The RID format in the reference data is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_4500] = "The securitiesID symbol securityid field is malformed";
  SSStockErrorMsg[SS_STOCK_ERROR_4501] = "Order status ordstatus is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_4502] = "The TimeStamp value is incorrect and is not the current trading day";
  SSStockErrorMsg[SS_STOCK_ERROR_4600] = "No counterparty orders were found";
  SSStockErrorMsg[SS_STOCK_ERROR_4601] = "Instruction details are inconsistent";
  SSStockErrorMsg[SS_STOCK_ERROR_4602] = "No counterparty was found";
  SSStockErrorMsg[SS_STOCK_ERROR_4603] = "The database reads the counterparty's instruction abnormally";
  SSStockErrorMsg[SS_STOCK_ERROR_4604] = "The operation of the business data table is abnormal";
  SSStockErrorMsg[SS_TDGW_ERROR_4012] = "Wrong securityID or wrong BizID";
  SSStockErrorMsg[SS_TDGW_ERROR_5000] = "Message exceed mas length 4k";
  SSStockErrorMsg[SS_TDGW_ERROR_5001] = "CheckSum error";
  SSStockErrorMsg[SS_TDGW_ERROR_5002] = "HeartBeat timeout";
  SSStockErrorMsg[SS_TDGW_ERROR_5003] = "Alread login";
  SSStockErrorMsg[SS_TDGW_ERROR_5004] = "Login timeout";
  SSStockErrorMsg[SS_TDGW_ERROR_5005] = "CompId error";
  SSStockErrorMsg[SS_TDGW_ERROR_5006] = "Not ready";
  SSStockErrorMsg[SS_TDGW_ERROR_5007] = "Internal error";
  SSStockErrorMsg[SS_TDGW_ERROR_5008] = "Message type illegal";
  SSStockErrorMsg[SS_TDGW_ERROR_5009] = "Do not Accept new order";
  SSStockErrorMsg[SS_TDGW_ERROR_5010] = "Wrong setID";
  SSStockErrorMsg[SS_TDGW_ERROR_5011] = "Wrong Pbu";
  SSStockErrorMsg[SS_TDGW_ERROR_5012] = "Login first";
  SSStockErrorMsg[SS_TDGW_ERROR_5013] = "Wrong BeginReportIndex";
  SSStockErrorMsg[SS_TDGW_ERROR_5014] = "Unsupported prtcl version";
  SSStockErrorMsg[SS_TDGW_ERROR_5015] = "Message data error";
  SSStockErrorMsg[SS_STOCK_ERROR_10000] = "Internal error, please contact SSE";
  SSStockErrorMsg[SS_STOCK_ERROR_10002] = "User does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10004] = "Different from the original password";
  SSStockErrorMsg[SS_STOCK_ERROR_10006] = "Request has been processed";
  SSStockErrorMsg[SS_STOCK_ERROR_10008] = "Busy,TXN rejected,please try again";
  SSStockErrorMsg[SS_STOCK_ERROR_10018] = "Invalid market type";
  SSStockErrorMsg[SS_STOCK_ERROR_10022] = "Loan term is not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_10028] = "Invalid Net Asset Value (NAV) dates";
  SSStockErrorMsg[SS_STOCK_ERROR_10030] = "Invalid base product";
  SSStockErrorMsg[SS_STOCK_ERROR_10032] = "Product base is not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_10038] = "Invalid price";
  SSStockErrorMsg[SS_STOCK_ERROR_10042] = "Date on which invalid cash dividend equity was recorded";
  SSStockErrorMsg[SS_STOCK_ERROR_10044] = "No ex dividend date filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10046] = "Invalid ex-dividend date";
  SSStockErrorMsg[SS_STOCK_ERROR_10048] = "Bonus amount is not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_10052] = "Invalid stock dividend equity record date";
  SSStockErrorMsg[SS_STOCK_ERROR_10054] = "Ex-rights date is not specified";
  SSStockErrorMsg[SS_STOCK_ERROR_10056] = "Exclusion date not filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10058] = "Dividend rate not filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10062] = "Invalid registration date for rights issue";
  SSStockErrorMsg[SS_STOCK_ERROR_10066] = "Invalid ex right date";
  SSStockErrorMsg[SS_STOCK_ERROR_10070] = "Allotment price has not been filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10074] = "Registration date for shareholder meeting not filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10076] = "Invalid registration date for shareholder meeting";
  SSStockErrorMsg[SS_STOCK_ERROR_10078] = "Date of shareholder meeting not filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10080] = "Invalid date of shareholder meeting";
  SSStockErrorMsg[SS_STOCK_ERROR_10084] = "Total number of invalid stocks";
  SSStockErrorMsg[SS_STOCK_ERROR_10086] = "Ineffective earnings per share (EPS)";
  SSStockErrorMsg[SS_STOCK_ERROR_10088] = "Invalid term: loan days";
  SSStockErrorMsg[SS_STOCK_ERROR_10090] = "DomesticIDentification";
  SSStockErrorMsg[SS_STOCK_ERROR_10092] = "Earnings per share (EPS) date";
  SSStockErrorMsg[SS_STOCK_ERROR_10096] = "Invalid certificate type";
  SSStockErrorMsg[SS_STOCK_ERROR_10098] = "Product abbreviation not filled in";
  SSStockErrorMsg[SS_STOCK_ERROR_10100] = "Invalid product subtype";
  SSStockErrorMsg[SS_STOCK_ERROR_10104] = "Invalid product group name";
  SSStockErrorMsg[SS_STOCK_ERROR_10106] = "Invalid instrument type";
  SSStockErrorMsg[SS_STOCK_ERROR_10108] = "This International SecuritiesIDentification Number (ISIN) already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10112] = "Invalid productID";
  SSStockErrorMsg[SS_STOCK_ERROR_10114] = "Product deletion is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_10116] = "Invalid default trading schedule";
  SSStockErrorMsg[SS_STOCK_ERROR_10118] = "Product group not found";
  SSStockErrorMsg[SS_STOCK_ERROR_10120] = "Product and product group don't match";
  SSStockErrorMsg[SS_STOCK_ERROR_10126] = "Invalid externalIDentification";
  SSStockErrorMsg[SS_STOCK_ERROR_10128] = "Void on date of delisting";
  SSStockErrorMsg[SS_STOCK_ERROR_10132] = "Product data is different";
  SSStockErrorMsg[SS_STOCK_ERROR_10140] = "Invalid product subtype";
  SSStockErrorMsg[SS_STOCK_ERROR_10142] = "Incorrect timestamp";
  SSStockErrorMsg[SS_STOCK_ERROR_10144] = "Invalid settlement currency";
  SSStockErrorMsg[SS_STOCK_ERROR_10146] = "Invalid notional currency";
  SSStockErrorMsg[SS_STOCK_ERROR_10150] = "No records found";
  SSStockErrorMsg[SS_STOCK_ERROR_10156] = "Invalid order lot type";
  SSStockErrorMsg[SS_STOCK_ERROR_10160] = "Duration is not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_10162] = "Startup time is not specified";
  SSStockErrorMsg[SS_STOCK_ERROR_10172] = "Invalid short selling flag";
  SSStockErrorMsg[SS_STOCK_ERROR_10178] = "Minimum number of invalid disclosures";
  SSStockErrorMsg[SS_STOCK_ERROR_10182] = "Invalid volatility range";
  SSStockErrorMsg[SS_STOCK_ERROR_10188] = "Invalid Maximum remaining quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10192] = "Invalid whole lots";
  SSStockErrorMsg[SS_STOCK_ERROR_10194] = "Invalid Maximum Order Quantity (A)";
  SSStockErrorMsg[SS_STOCK_ERROR_10200] = "Invalid closing price calculation";
  SSStockErrorMsg[SS_STOCK_ERROR_10202] = "Invalid reference price";
  SSStockErrorMsg[SS_STOCK_ERROR_10204] = "Upper and lower price limits are not specified";
  SSStockErrorMsg[SS_STOCK_ERROR_10206] = "Number of issues is not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_10208] = "Invalid total quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10210] = "Invalid loan term";
  SSStockErrorMsg[SS_STOCK_ERROR_10218] = "Date of draw was not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_10220] = "Invalid draw dates";
  SSStockErrorMsg[SS_STOCK_ERROR_10222] = "Invalid price upper and lower limits";
  SSStockErrorMsg[SS_STOCK_ERROR_10224] = "Invalid conversion rates";
  SSStockErrorMsg[SS_STOCK_ERROR_10228] = "Invalid minimum negotiated order quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10230] = "Invalid product group code";
  SSStockErrorMsg[SS_STOCK_ERROR_10234] = "Product group does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10236] = "Invalid time stamp";
  SSStockErrorMsg[SS_STOCK_ERROR_10238] = "Access is denied";
  SSStockErrorMsg[SS_STOCK_ERROR_10240] = "Maximum order validity period has been exceeded";
  SSStockErrorMsg[SS_STOCK_ERROR_10242] = "Order is valid before current date";
  SSStockErrorMsg[SS_STOCK_ERROR_10244] = "Incorrect order expiration date";
  SSStockErrorMsg[SS_STOCK_ERROR_10246] = "Wrong product type";
  SSStockErrorMsg[SS_STOCK_ERROR_10248] = "Product could not be read";
  SSStockErrorMsg[SS_STOCK_ERROR_10250] = "Invalid transaction code";
  SSStockErrorMsg[SS_STOCK_ERROR_10252] = "Disable this function during this trading period";
  SSStockErrorMsg[SS_STOCK_ERROR_10254] = "Product is not assigned";
  SSStockErrorMsg[SS_STOCK_ERROR_10256] = "Not authorized by agency account";
  SSStockErrorMsg[SS_STOCK_ERROR_10258] = "Not authorized by market maker account";
  SSStockErrorMsg[SS_STOCK_ERROR_10260] = "Not authorized by self account";
  SSStockErrorMsg[SS_STOCK_ERROR_10262] = "Invalid order type";
  SSStockErrorMsg[SS_STOCK_ERROR_10264] = "Invalid execution restriction type";
  SSStockErrorMsg[SS_STOCK_ERROR_10266] = "Invalid trading restriction type";
  SSStockErrorMsg[SS_STOCK_ERROR_10268] = "Not qualified as market maker";
  SSStockErrorMsg[SS_STOCK_ERROR_10270] = "PBU code of invalid PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10272] = "Current user is not exchange user";
  SSStockErrorMsg[SS_STOCK_ERROR_10274] = "Transaction declined: PBU cannot be traded on this MISS!";
  SSStockErrorMsg[SS_STOCK_ERROR_10276] = "Invalid quoted price or quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10278] = "Invalid Transaction Restriction 'SU'";
  SSStockErrorMsg[SS_STOCK_ERROR_10280] = "Unreasonable quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10282] = "Last modification time has changed";
  SSStockErrorMsg[SS_STOCK_ERROR_10286] = "Invalid processing date";
  SSStockErrorMsg[SS_STOCK_ERROR_10290] = "PBU has no dispensing products";
  SSStockErrorMsg[SS_STOCK_ERROR_10292] = "Invalid date entry";
  SSStockErrorMsg[SS_STOCK_ERROR_10294] = "Invalid date parameter";
  SSStockErrorMsg[SS_STOCK_ERROR_10296] = "ISIN prefix of contract is duplicated";
  SSStockErrorMsg[SS_STOCK_ERROR_10298] = "Invalid product-associated dataIDentifier or trader does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10302] = "Product or privilege is not associated to current subgroup";
  SSStockErrorMsg[SS_STOCK_ERROR_10304] = "Resource information does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10306] = "Contract product abbreviation prefix is duplicated";
  SSStockErrorMsg[SS_STOCK_ERROR_10308] = "Product has been assigned a licensed permission";
  SSStockErrorMsg[SS_STOCK_ERROR_10310] = "PBU does not have privileged permissions assigned";
  SSStockErrorMsg[SS_STOCK_ERROR_10318] = "Minimum quantity of an iceberg order is not a whole lot quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10320] = "Minimum disclosed quantity is not whole lot size";
  SSStockErrorMsg[SS_STOCK_ERROR_10322] = "Invalid minimum quotation quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10324] = "Invalid first day of listing";
  SSStockErrorMsg[SS_STOCK_ERROR_10326] = "Invalid minimum tradable volume";
  SSStockErrorMsg[SS_STOCK_ERROR_10348] = "Invalid IPO issuance method";
  SSStockErrorMsg[SS_STOCK_ERROR_10350] = "Invalid non-identification";
  SSStockErrorMsg[SS_STOCK_ERROR_10352] = "Void Iceberg order minimum quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10354] = "Invalid duration";
  SSStockErrorMsg[SS_STOCK_ERROR_10356] = "Invalid start time";
  SSStockErrorMsg[SS_STOCK_ERROR_10360] = "Invalid price range calculation method";
  SSStockErrorMsg[SS_STOCK_ERROR_10362] = "Invalid price unit";
  SSStockErrorMsg[SS_STOCK_ERROR_10364] = "Invalid transaction model";
  SSStockErrorMsg[SS_STOCK_ERROR_10366] = "RAL cannot be updated to database";
  SSStockErrorMsg[SS_STOCK_ERROR_10368] = "Relationships between invalid values";
  SSStockErrorMsg[SS_STOCK_ERROR_10376] = "Invalid ticker";
  SSStockErrorMsg[SS_STOCK_ERROR_10378] = "Invalid exchange symbol";
  SSStockErrorMsg[SS_STOCK_ERROR_10380] = "Product duplication (code, or abbreviation, or ISIN)";
  SSStockErrorMsg[SS_STOCK_ERROR_10382] = "Dividend parameter is not entered";
  SSStockErrorMsg[SS_STOCK_ERROR_10390] = "Type of calculation of invalid transaction amount";
  SSStockErrorMsg[SS_STOCK_ERROR_10392] = "Market is at a standstill";
  SSStockErrorMsg[SS_STOCK_ERROR_10394] = "Invalid period conversion code";
  SSStockErrorMsg[SS_STOCK_ERROR_10396] = "Unable to transition to target state";
  SSStockErrorMsg[SS_STOCK_ERROR_10398] = "Product cannot be used";
  SSStockErrorMsg[SS_STOCK_ERROR_10400] = "Current state cannot be transitioned to Pending Batch";
  SSStockErrorMsg[SS_STOCK_ERROR_10402] = "Market does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10404] = "State transition request has been triggered";
  SSStockErrorMsg[SS_STOCK_ERROR_10406] = "Trading schedule is already open";
  SSStockErrorMsg[SS_STOCK_ERROR_10408] = "Trading schedule is already closed";
  SSStockErrorMsg[SS_STOCK_ERROR_10410] = "Start time of end of trade has passed";
  SSStockErrorMsg[SS_STOCK_ERROR_10412] = "Invalid product status";
  SSStockErrorMsg[SS_STOCK_ERROR_10414] = "Invalid conversion schedule";
  SSStockErrorMsg[SS_STOCK_ERROR_10416] = "PBU has been removed";
  SSStockErrorMsg[SS_STOCK_ERROR_10420] = "Invalid account type";
  SSStockErrorMsg[SS_STOCK_ERROR_10424] = "Order data has changed";
  SSStockErrorMsg[SS_STOCK_ERROR_10426] = "Invalid execution limits during trading session";
  SSStockErrorMsg[SS_STOCK_ERROR_10428] = "Invalid Transaction Limit'OA'";
  SSStockErrorMsg[SS_STOCK_ERROR_10430] = "Invalid Transaction Limit'AU'";
  SSStockErrorMsg[SS_STOCK_ERROR_10432] = "Invalid Transaction Limit'FP'";
  SSStockErrorMsg[SS_STOCK_ERROR_10434] = "Invalid trade flag";
  SSStockErrorMsg[SS_STOCK_ERROR_10436] = "Account type cannot be changed";
  SSStockErrorMsg[SS_STOCK_ERROR_10438] = "Invalid change of order type";
  SSStockErrorMsg[SS_STOCK_ERROR_10440] = "Market-to-Limit orders cannot change order price";
  SSStockErrorMsg[SS_STOCK_ERROR_10442] = "Combination of number of invalid orders and maximum number revealed";
  SSStockErrorMsg[SS_STOCK_ERROR_10444] = "The order quantity is less than the minimum order quantity requirement";
  SSStockErrorMsg[SS_STOCK_ERROR_10446] = "Invalid trader groupID";
  SSStockErrorMsg[SS_STOCK_ERROR_10448] = "This trader is not an advanced trader";
  SSStockErrorMsg[SS_STOCK_ERROR_10450] = "Order price exceeds range";
  SSStockErrorMsg[SS_STOCK_ERROR_10454] = "PBU already exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10456] = "Participant business unit is not assigned to next level of PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10462] = "Invalid HQ PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10464] = "There are duplicate records";
  SSStockErrorMsg[SS_STOCK_ERROR_10468] = "PBU already exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10470] = "There is no default record for found exchanges";
  SSStockErrorMsg[SS_STOCK_ERROR_10472] = "The relevant PBU relationship does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10476] = "Invalid pbu type";
  SSStockErrorMsg[SS_STOCK_ERROR_10478] = "Invalid timestamps";
  SSStockErrorMsg[SS_STOCK_ERROR_10480] = "Modifications are not permitted";
  SSStockErrorMsg[SS_STOCK_ERROR_10482] = "Inter-Exchange Membership field is empty";
  SSStockErrorMsg[SS_STOCK_ERROR_10486] = "Invalid PBU name";
  SSStockErrorMsg[SS_STOCK_ERROR_10488] = "Invalid PBUID";
  SSStockErrorMsg[SS_STOCK_ERROR_10490] = "Invalid PBU category";
  SSStockErrorMsg[SS_STOCK_ERROR_10492] = "Participant business unit has been assigned next level of PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10498] = "ExchangeIDentity authority is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_10500] = "HOSTSEC initialization failed";
  SSStockErrorMsg[SS_STOCK_ERROR_10502] = "Insufficient permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_10504] = "Activity status permissions are insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_10506] = "DelegateIDentity authority is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_10508] = "The PBU status is either stopped trading or the PBU is not activated";
  SSStockErrorMsg[SS_STOCK_ERROR_10510] = "Transaction requests for different PBU was denied";
  SSStockErrorMsg[SS_STOCK_ERROR_10512] = "PBU has no permission";
  SSStockErrorMsg[SS_STOCK_ERROR_10514] = "Non-senior traders";
  SSStockErrorMsg[SS_STOCK_ERROR_10516] = "Inactive PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10518] = "Unauthorized status";
  SSStockErrorMsg[SS_STOCK_ERROR_10520] = "Execution limit is not valid for acceptance of remaining orders";
  SSStockErrorMsg[SS_STOCK_ERROR_10522] = "Product group already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10524] = "PBU cannot enter a buyer's order";
  SSStockErrorMsg[SS_STOCK_ERROR_10528] = "Invalid market code";
  SSStockErrorMsg[SS_STOCK_ERROR_10532] = "Invalid product groupID";
  SSStockErrorMsg[SS_STOCK_ERROR_10534] = "Invalid PBUID";
  SSStockErrorMsg[SS_STOCK_ERROR_10536] = "Invalid participant business unit group";
  SSStockErrorMsg[SS_STOCK_ERROR_10540] = "Participant business unit remains active";
  SSStockErrorMsg[SS_STOCK_ERROR_10544] = "There are also related products in specified product group";
  SSStockErrorMsg[SS_STOCK_ERROR_10546] = "PBU cannot be entered into seller orders";
  SSStockErrorMsg[SS_STOCK_ERROR_10548] = "Invalid product groupID";
  SSStockErrorMsg[SS_STOCK_ERROR_10550] = "Invalid product group type";
  SSStockErrorMsg[SS_STOCK_ERROR_10552] = "Product group already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10554] = "There are already products assigned to product group that will be deleted";
  SSStockErrorMsg[SS_STOCK_ERROR_10558] = "Product group has already been assigned product";
  SSStockErrorMsg[SS_STOCK_ERROR_10560] = "Buy order quantity cannot be zero";
  SSStockErrorMsg[SS_STOCK_ERROR_10562] = "Sell order quantity cannot be zero";
  SSStockErrorMsg[SS_STOCK_ERROR_10564] = "Group of products that do not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10566] = "Trading session is not defined";
  SSStockErrorMsg[SS_STOCK_ERROR_10568] = "Order type and trading model do not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10570] = "TP_TICSIZ Data errors";
  SSStockErrorMsg[SS_STOCK_ERROR_10572] = "Product is not configured to a market or product group";
  SSStockErrorMsg[SS_STOCK_ERROR_10574] = "Some products are not processed";
  SSStockErrorMsg[SS_STOCK_ERROR_10576] = "Invalid market status";
  SSStockErrorMsg[SS_STOCK_ERROR_10578] = "Status transitions for product groups are not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_10590] = "Number of orders is not a whole lot";
  SSStockErrorMsg[SS_STOCK_ERROR_10594] = "Trading hours that are not current for business";
  SSStockErrorMsg[SS_STOCK_ERROR_10596] = "The order price did not comply with the minimum price rule";
  SSStockErrorMsg[SS_STOCK_ERROR_10604] = "The withdrawn declaration does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10606] = "Investor account type is not valid for quotes";
  SSStockErrorMsg[SS_STOCK_ERROR_10608] = "Incorrect stop loss limit";
  SSStockErrorMsg[SS_STOCK_ERROR_10610] = "Can not find the specified order";
  SSStockErrorMsg[SS_STOCK_ERROR_10614] = "Cancellation of orders is not allowed for this business";
  SSStockErrorMsg[SS_STOCK_ERROR_10616] = "Invalid transaction modelID";
  SSStockErrorMsg[SS_STOCK_ERROR_10618] = "Invalid match priorityID";
  SSStockErrorMsg[SS_STOCK_ERROR_10620] = "Invalid bidding quantity allocation scheme";
  SSStockErrorMsg[SS_STOCK_ERROR_10622] = "Invalid Bid Match algorithm";
  SSStockErrorMsg[SS_STOCK_ERROR_10626] = "Wrong sales office number";
  SSStockErrorMsg[SS_STOCK_ERROR_10630] =
      "It is not permissible to change a past time slot or to change a future time slot to past";
  SSStockErrorMsg[SS_STOCK_ERROR_10632] =
      "Time difference between current change and next time period change is too short";
  SSStockErrorMsg[SS_STOCK_ERROR_10636] = "Product must be in suspended state";
  SSStockErrorMsg[SS_STOCK_ERROR_10640] = "Wrong query date";
  SSStockErrorMsg[SS_STOCK_ERROR_10642] = "Incorrect query limit price";
  SSStockErrorMsg[SS_STOCK_ERROR_10644] = "End of inquiry";
  SSStockErrorMsg[SS_STOCK_ERROR_10646] = "No search results";
  SSStockErrorMsg[SS_STOCK_ERROR_10648] = "Method of allocation of remaining volume of Call Auction is unknown";
  SSStockErrorMsg[SS_STOCK_ERROR_10660] = "PBU unassigned product group";
  SSStockErrorMsg[SS_STOCK_ERROR_10662] = "User group, product group write error";
  SSStockErrorMsg[SS_STOCK_ERROR_10664] = "Currency does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10666] = "Currency already exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10668] = "Product is not assigned to a subgroup";
  SSStockErrorMsg[SS_STOCK_ERROR_10670] = "PBU is not assigned privileged permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_10672] = "Subgroup is not assigned any market maker privileges";
  SSStockErrorMsg[SS_STOCK_ERROR_10674] = "Invalid userID";
  SSStockErrorMsg[SS_STOCK_ERROR_10676] = "Since user is a DEFMBR, system denies access";
  SSStockErrorMsg[SS_STOCK_ERROR_10678] = "User does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10680] = "User already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10682] = "Invalid agent tag can only be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_10684] = "Invalid Proprietary tag, can only be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_10686] = "Invalid Senior token, can only be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_10688] = "Invalid Market Maker token, can only be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_10690] = "Trying to be Market Maker type, but not Proprietary at this moment";
  SSStockErrorMsg[SS_STOCK_ERROR_10694] = "Attempts to remove PBU manager were denied";
  SSStockErrorMsg[SS_STOCK_ERROR_10696] = "Invalid trader status";
  SSStockErrorMsg[SS_STOCK_ERROR_10698] = "Since user is MBRSPV, system denies access";
  SSStockErrorMsg[SS_STOCK_ERROR_10700] = "Order quantity is less than minimum negotiated order transaction quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_10702] = "Investor account not designated to the PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10704] = "Specified trading relationship for Investor account is not activated";
  SSStockErrorMsg[SS_STOCK_ERROR_10706] = "Investor account is suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_10708] = "Invalid AccountID type for this product";
  SSStockErrorMsg[SS_STOCK_ERROR_10712] = "Invalid investor account id";
  SSStockErrorMsg[SS_STOCK_ERROR_10716] = "Invalid negotiated order information type";
  SSStockErrorMsg[SS_STOCK_ERROR_10722] = "Invalid settlement date";
  SSStockErrorMsg[SS_STOCK_ERROR_10726] = "Invalid negotiated order";
  SSStockErrorMsg[SS_STOCK_ERROR_10730] = "Invalid OTC products";
  SSStockErrorMsg[SS_STOCK_ERROR_10732] = "User does not exist or has been deleted";
  SSStockErrorMsg[SS_STOCK_ERROR_10734] = "Closing prices cannot be calculated";
  SSStockErrorMsg[SS_STOCK_ERROR_10738] = "Closing session has begun";
  SSStockErrorMsg[SS_STOCK_ERROR_10740] = "The business declared for this order has ended";
  SSStockErrorMsg[SS_STOCK_ERROR_10744] = "Exceeding highest of day, Range of lowest traded price";
  SSStockErrorMsg[SS_STOCK_ERROR_10746] = "Transaction currencies do not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10748] = "Products don't match";
  SSStockErrorMsg[SS_STOCK_ERROR_10750] = "Order type does not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10752] = "Order order direction mismatch";
  SSStockErrorMsg[SS_STOCK_ERROR_10754] = "System status number does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10756] = "No target address";
  SSStockErrorMsg[SS_STOCK_ERROR_10758] = "Order quantity does not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10760] = "Order price does not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10762] = "There is no market maker for this product";
  SSStockErrorMsg[SS_STOCK_ERROR_10764] = "Counterparty PBU does not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10766] = "Negotiated order numbers do not match";
  SSStockErrorMsg[SS_STOCK_ERROR_10768] = "Billing codes don't match";
  SSStockErrorMsg[SS_STOCK_ERROR_10770] = "Settlement dates don't match";
  SSStockErrorMsg[SS_STOCK_ERROR_10772] = "Settlement currency doesn't match";
  SSStockErrorMsg[SS_STOCK_ERROR_10774] = "Product is suspended from over-the-counter trading";
  SSStockErrorMsg[SS_STOCK_ERROR_10776] = "Product is suspended from negotiating transactions";
  SSStockErrorMsg[SS_STOCK_ERROR_10780] = "Date already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10782] = "Date is no more than two days older than current date";
  SSStockErrorMsg[SS_STOCK_ERROR_10784] = "Date is no earlier than eight days ago";
  SSStockErrorMsg[SS_STOCK_ERROR_10786] = "No license information has been set for specified product";
  SSStockErrorMsg[SS_STOCK_ERROR_10788] = "Message length is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_10790] = "Managed PBU does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10792] = "User context content is too long";
  SSStockErrorMsg[SS_STOCK_ERROR_10794] = "Investor account does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10796] = "Creating specified transaction relationships is not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_10798] = "Invalid type";
  SSStockErrorMsg[SS_STOCK_ERROR_10800] = "Account already designated";
  SSStockErrorMsg[SS_STOCK_ERROR_10802] = "Invalid flags";
  SSStockErrorMsg[SS_STOCK_ERROR_10804] = "Account has assigned to other seats";
  SSStockErrorMsg[SS_STOCK_ERROR_10806] = "Revocating specified transaction relationships is not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_10808] = "Invalid status";
  SSStockErrorMsg[SS_STOCK_ERROR_10812] = "Designated trading not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10820] = "Request Denied: Underlying data maintenance is blocked";
  SSStockErrorMsg[SS_STOCK_ERROR_10822] = "Inactive underlying products (non-bonds)";
  SSStockErrorMsg[SS_STOCK_ERROR_10824] = "Invalid base product (not in same market)";
  SSStockErrorMsg[SS_STOCK_ERROR_10826] = "Data has been illegally modified";
  SSStockErrorMsg[SS_STOCK_ERROR_10828] = "Invalid update of number of positions";
  SSStockErrorMsg[SS_STOCK_ERROR_10836] = "Investor holding position not enough";
  SSStockErrorMsg[SS_STOCK_ERROR_10838] = "Counterparty does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10840] = "Buyer does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10842] = "Seller does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10844] = "Market maker did not authorize entry of quote request";
  SSStockErrorMsg[SS_STOCK_ERROR_10852] = "Invalid transaction status";
  SSStockErrorMsg[SS_STOCK_ERROR_10854] = "The specified unexpired offer does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10868] = "Duplicate records";
  SSStockErrorMsg[SS_STOCK_ERROR_10884] = "There is already allocated managed PBU present";
  SSStockErrorMsg[SS_STOCK_ERROR_10886] = "Invalid hosted PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10888] = "Invalid product group (not in same market)";
  SSStockErrorMsg[SS_STOCK_ERROR_10894] = "Order is not blocked";
  SSStockErrorMsg[SS_STOCK_ERROR_10896] = "Offer is not frozen";
  SSStockErrorMsg[SS_STOCK_ERROR_10900] = "Frozen offer already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10902] = "Unsupported transaction type";
  SSStockErrorMsg[SS_STOCK_ERROR_10916] = "Invalid OTC trade dates";
  SSStockErrorMsg[SS_STOCK_ERROR_10918] = "Authority of agent is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_10920] = "Breed privilege has been assigned";
  SSStockErrorMsg[SS_STOCK_ERROR_10924] = "Varieties is not assigned to PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_10926] = "Breed privileges have been assigned to Subgroup";
  SSStockErrorMsg[SS_STOCK_ERROR_10928] = "Variety privileges are not assigned to Subgroup";
  SSStockErrorMsg[SS_STOCK_ERROR_10930] = "Wrong market status";
  SSStockErrorMsg[SS_STOCK_ERROR_10932] = "Does not have permissions to access product status resource";
  SSStockErrorMsg[SS_STOCK_ERROR_10934] = "Agent is inactive";
  SSStockErrorMsg[SS_STOCK_ERROR_10938] = "Invalid symbol code";
  SSStockErrorMsg[SS_STOCK_ERROR_10940] = "Breed already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_10942] = "There are still contracts under symbol";
  SSStockErrorMsg[SS_STOCK_ERROR_10944] = "Invalid position checks";
  SSStockErrorMsg[SS_STOCK_ERROR_10946] = "Invalid Member Clearing Code";
  SSStockErrorMsg[SS_STOCK_ERROR_10948] = "PBUID used by external system (EAI) is not configured";
  SSStockErrorMsg[SS_STOCK_ERROR_10952] = "Specified ISIN code is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_10956] = "PBU has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_10958] = "Expiration month of invalid contract";
  SSStockErrorMsg[SS_STOCK_ERROR_10960] = "Futures contract for month has been generated";
  SSStockErrorMsg[SS_STOCK_ERROR_10962] = "Invalid message length";
  SSStockErrorMsg[SS_STOCK_ERROR_10964] = "Breed does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_10966] = "Invalid last contract automatic generation date";
  SSStockErrorMsg[SS_STOCK_ERROR_10968] = "Vote on same motion repeatedly";
  SSStockErrorMsg[SS_STOCK_ERROR_10970] = "The margin required to update a position is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_10972] = "Illegal default payment package type";
  SSStockErrorMsg[SS_STOCK_ERROR_10978] = "Total number of ETF requests exceeds threshold for day";
  SSStockErrorMsg[SS_STOCK_ERROR_10980] = "Invalid non-transaction type";
  SSStockErrorMsg[SS_STOCK_ERROR_10982] = "Invalid assignment date";
  SSStockErrorMsg[SS_STOCK_ERROR_10986] = "Invalid numbering rule table";
  SSStockErrorMsg[SS_STOCK_ERROR_10988] = "Invalid proportional allotment ratio";
  SSStockErrorMsg[SS_STOCK_ERROR_10990] = "Invalid delivery price type";
  SSStockErrorMsg[SS_STOCK_ERROR_10992] = "Invalid underwriter PBU code";
  SSStockErrorMsg[SS_STOCK_ERROR_10994] = "Invalid Underwriter Investor Account";
  SSStockErrorMsg[SS_STOCK_ERROR_11002] = "Invalid last traded Date (Conflict with Derivatives)";
  SSStockErrorMsg[SS_STOCK_ERROR_11004] = "Invalid last traded Date (Conflicts with Non-Traded Information)";
  SSStockErrorMsg[SS_STOCK_ERROR_11006] = "Invalid first traded date (conflicting with non-trade information)";
  SSStockErrorMsg[SS_STOCK_ERROR_11008] = "Conversion price is not filled";
  SSStockErrorMsg[SS_STOCK_ERROR_11012] = "Required information is missing";
  SSStockErrorMsg[SS_STOCK_ERROR_11018] = "Removal of underwriter PBU was rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_11024] = "EzCS failed to decrypt PBU password";
  SSStockErrorMsg[SS_STOCK_ERROR_11026] = "Invalid investor type";
  SSStockErrorMsg[SS_STOCK_ERROR_11028] = "Invalid product code";
  SSStockErrorMsg[SS_STOCK_ERROR_11032] = "Product is not applicable";
  SSStockErrorMsg[SS_STOCK_ERROR_11034] = "Request exceeds a limited period of time";
  SSStockErrorMsg[SS_STOCK_ERROR_11036] = "Invalid trader code";
  SSStockErrorMsg[SS_STOCK_ERROR_11038] = "Invalid dividend selection";
  SSStockErrorMsg[SS_STOCK_ERROR_11040] = "Invalid share source or purpose";
  SSStockErrorMsg[SS_STOCK_ERROR_11042] = "Non-transaction type does not match product";
  SSStockErrorMsg[SS_STOCK_ERROR_11044] = "Number of invalid positions have been unfrozen";
  SSStockErrorMsg[SS_STOCK_ERROR_11046] = "Price of invalid non-trading order";
  SSStockErrorMsg[SS_STOCK_ERROR_11048] = "Amount of invalid non-trading order";
  SSStockErrorMsg[SS_STOCK_ERROR_11050] = "Investor holding position status not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_11052] = "Number of invalid ETF orders";
  SSStockErrorMsg[SS_STOCK_ERROR_11054] = "ETF subscription is not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_11056] = "ETF redemption is not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_11058] = "ETF definition not found";
  SSStockErrorMsg[SS_STOCK_ERROR_11060] = "PBU doesn't have buy right for the instrument";
  SSStockErrorMsg[SS_STOCK_ERROR_11062] = "Invalid product trade flag";
  SSStockErrorMsg[SS_STOCK_ERROR_11064] = "PBU doesn't have sell right not the instrument";
  SSStockErrorMsg[SS_STOCK_ERROR_11068] = "PBU has no permission to trade";
  SSStockErrorMsg[SS_STOCK_ERROR_11070] = "Symbol code or expiration month cannot be modified";
  SSStockErrorMsg[SS_STOCK_ERROR_11072] = "Specified transaction type is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_11076] = "Contract abbreviation prefix is duplicated";
  SSStockErrorMsg[SS_STOCK_ERROR_11078] = "Contract product prefix is duplicated";
  SSStockErrorMsg[SS_STOCK_ERROR_11080] = "The investor does not have permission to buy for this product";
  SSStockErrorMsg[SS_STOCK_ERROR_11082] = "The investor does not have permission to sell this product";
  SSStockErrorMsg[SS_STOCK_ERROR_11084] = "Order direction of order cannot be modified";
  SSStockErrorMsg[SS_STOCK_ERROR_11090] = "Invalid suspension status changes";
  SSStockErrorMsg[SS_STOCK_ERROR_11094] = "It is not possible to delete main participant unit of seat-connected group";
  SSStockErrorMsg[SS_STOCK_ERROR_11098] = "Invalid maximum order quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_11100] = "Invalid entry start date";
  SSStockErrorMsg[SS_STOCK_ERROR_11102] = "Invalid input end date";
  SSStockErrorMsg[SS_STOCK_ERROR_11106] = "Invalid listing trading day";
  SSStockErrorMsg[SS_STOCK_ERROR_11108] = "Invalid conversion price";
  SSStockErrorMsg[SS_STOCK_ERROR_11110] = "Number of invalid non-trading orders";
  SSStockErrorMsg[SS_STOCK_ERROR_11116] = "Illegally updating frozen order";
  SSStockErrorMsg[SS_STOCK_ERROR_11118] = "Modification of matching priority is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_11122] = "Combination of matching priority and auction quantity allocation scheme is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_11124] = "Product does not allow entry of one-sided quotes";
  SSStockErrorMsg[SS_STOCK_ERROR_11126] = "PBU does not has non-trading permission";
  SSStockErrorMsg[SS_STOCK_ERROR_11128] = "The investor does not have authorization for this have non-trading";
  SSStockErrorMsg[SS_STOCK_ERROR_11130] = "Non-transaction services not available";
  SSStockErrorMsg[SS_STOCK_ERROR_11132] = "Not available for this sub-type of product";
  SSStockErrorMsg[SS_STOCK_ERROR_11134] = "Investor account is not authorized to create and cancel warrants";
  SSStockErrorMsg[SS_STOCK_ERROR_11138] = "Investor is already frozen";
  SSStockErrorMsg[SS_STOCK_ERROR_11140] = "Investor is already in a state of thawing";
  SSStockErrorMsg[SS_STOCK_ERROR_11148] = "Invalid inspection date";
  SSStockErrorMsg[SS_STOCK_ERROR_11150] = "Invalid switching fund";
  SSStockErrorMsg[SS_STOCK_ERROR_11152] = "The specified trade cancellation request is being processed";
  SSStockErrorMsg[SS_STOCK_ERROR_11154] = "Under-sufficiency of government bond guaranteed investors";
  SSStockErrorMsg[SS_STOCK_ERROR_11156] = "Warrant Secured Accounts cannot be activated";
  SSStockErrorMsg[SS_STOCK_ERROR_11162] = "Invalid transfer to specified transaction target";
  SSStockErrorMsg[SS_STOCK_ERROR_11166] = "The investor has a designated trading relationship with other PBUs";
  SSStockErrorMsg[SS_STOCK_ERROR_11170] = "Invalid cross-exchange symbols";
  SSStockErrorMsg[SS_STOCK_ERROR_11172] = "Invalid product groupID";
  SSStockErrorMsg[SS_STOCK_ERROR_11174] = "There are also associated varieties in specified product group";
  SSStockErrorMsg[SS_STOCK_ERROR_11182] = "There are also associated varieties in specified product group";
  SSStockErrorMsg[SS_STOCK_ERROR_11194] = "Market order or market-to-limit order can cause volatility break";
  SSStockErrorMsg[SS_STOCK_ERROR_11196] = "Invalid audit flag";
  SSStockErrorMsg[SS_STOCK_ERROR_11200] = "The memory order book is depleted";
  SSStockErrorMsg[SS_STOCK_ERROR_11202] = "Invalid pbu";
  SSStockErrorMsg[SS_STOCK_ERROR_11204] = "Calculating closing price...";
  SSStockErrorMsg[SS_STOCK_ERROR_11206] = "Invalid collateral flag";
  SSStockErrorMsg[SS_STOCK_ERROR_11208] = "Invalid financing flag";
  SSStockErrorMsg[SS_STOCK_ERROR_11210] = "Invalid security lending flag";
  SSStockErrorMsg[SS_STOCK_ERROR_11212] = "Credit transaction is not allowed on regular account";
  SSStockErrorMsg[SS_STOCK_ERROR_11214] = "Ordinary transaction is not allowed on credit account";
  SSStockErrorMsg[SS_STOCK_ERROR_11218] = "Wrong credit label type";
  SSStockErrorMsg[SS_STOCK_ERROR_11220] = "Instrument can't be traded as collateral";
  SSStockErrorMsg[SS_STOCK_ERROR_11226] = "There is no corresponding special account for security borrowing and lending";
  SSStockErrorMsg[SS_STOCK_ERROR_11228] = "Invalid credit tag";
  SSStockErrorMsg[SS_STOCK_ERROR_11230] = "Investor has insufficient non-trading position";
  SSStockErrorMsg[SS_STOCK_ERROR_11236] = "PBU has no permission to buy";
  SSStockErrorMsg[SS_STOCK_ERROR_11238] = "PBU has no permission to sell";
  SSStockErrorMsg[SS_STOCK_ERROR_11240] = "Not allowed to delete order during this period";
  SSStockErrorMsg[SS_STOCK_ERROR_11244] = "Limit on number of subscriptions to a broadcast stream is exceeded";
  SSStockErrorMsg[SS_STOCK_ERROR_11246] = "The trading time has not yet arrived";
  SSStockErrorMsg[SS_STOCK_ERROR_11248] = "Benchmark price is not allowed to be updated prior to listing date";
  SSStockErrorMsg[SS_STOCK_ERROR_11250] = "Benchmark price is not allowed to be updated during current session";
  SSStockErrorMsg[SS_STOCK_ERROR_11252] = "It is not allowed to update price range of products with price control";
  SSStockErrorMsg[SS_STOCK_ERROR_11254] = "Special account for security lending and borrowing cannot be activated";
  SSStockErrorMsg[SS_STOCK_ERROR_11258] = "Conversion of fund code is not applicable";
  SSStockErrorMsg[SS_STOCK_ERROR_11262] = "PBU does not have right to buy this product subtype";
  SSStockErrorMsg[SS_STOCK_ERROR_11264] = "PBU does not have sell rights on this product subtype";
  SSStockErrorMsg[SS_STOCK_ERROR_11266] = "The investor does not have purchasing authorization for this product subtype";
  SSStockErrorMsg[SS_STOCK_ERROR_11268] = "The investor does not have selling authorization for this product subtype";
  SSStockErrorMsg[SS_STOCK_ERROR_11270] = "Resend the order";
  SSStockErrorMsg[SS_STOCK_ERROR_11272] = "Old repo does not allow operations";
  SSStockErrorMsg[SS_STOCK_ERROR_11276] = "Background broadcast retransmission is not available";
  SSStockErrorMsg[SS_STOCK_ERROR_11278] = "Invalid broadcast retransmission request range";
  SSStockErrorMsg[SS_STOCK_ERROR_11280] = "Broadcast record found in background is invalid and cannot be retransmitted";
  SSStockErrorMsg[SS_STOCK_ERROR_11282] = "Unknown error occurred with background broadcast retransmission";
  SSStockErrorMsg[SS_STOCK_ERROR_11284] = "Emergency halt cannot be inserted in call auction that has not started";
  SSStockErrorMsg[SS_STOCK_ERROR_11288] = "Account cancel designation disallowed";
  SSStockErrorMsg[SS_STOCK_ERROR_11290] = "Primary PBU does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_11292] = "Primary PBU is not internal PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_11296] = "Primary PBU of primary PBU is not itself";
  SSStockErrorMsg[SS_STOCK_ERROR_11298] = "Attempt is made to modify primary PBU of existing primary PBU to a different PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_11300] = "Missid of PBU cannot be forcibly logged out if it is not assigned";
  SSStockErrorMsg[SS_STOCK_ERROR_11302] = "PBU is not logged in, it cannot be forcibly logged out";
  SSStockErrorMsg[SS_STOCK_ERROR_12000] = "Report authorization relationship already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_12002] = "Report authorization relationship does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_12004] = "Maximum number of authorized PBU has been reached";
  SSStockErrorMsg[SS_STOCK_ERROR_12006] = "PBU does not have permission to upload corresponding ETF definition file";
  SSStockErrorMsg[SS_STOCK_ERROR_12008] = "Invalid ETF types";
  SSStockErrorMsg[SS_STOCK_ERROR_12010] = "Invalid ETF definition file date";
  SSStockErrorMsg[SS_STOCK_ERROR_12012] = "PBU does not have permission to download specified report";
  SSStockErrorMsg[SS_STOCK_ERROR_12014] = "Invalid download file size";
  SSStockErrorMsg[SS_STOCK_ERROR_12016] = "Backend is unable to provide service";
  SSStockErrorMsg[SS_STOCK_ERROR_12018] = "ETF definition file check for error";
  SSStockErrorMsg[SS_STOCK_ERROR_12020] = "Report PBU is same as authorized PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_12022] = "Report can't be downloaded for current period";
  SSStockErrorMsg[SS_STOCK_ERROR_12024] = "ETF product code is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_12026] = "Fund house does not match documents";
  SSStockErrorMsg[SS_STOCK_ERROR_12028] = "Definition file version number is smaller than current version";
  SSStockErrorMsg[SS_STOCK_ERROR_12032] = "Best five levels are timely executed, and remaining cancelled market orders have no unfilled orders on counterparty";
  SSStockErrorMsg[SS_STOCK_ERROR_12034] = "Best five levels are timely executed, and there are no unfilled orders on counterparty and other side of remaining market orders";
  SSStockErrorMsg[SS_STOCK_ERROR_12036] = "Limit price is real-time, all types of orders can be filled, and the counterparty is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_12038] = "The market price is real-time, and the fillable counterparty of all types of orders is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_12040] = "Duplicate orders";
  SSStockErrorMsg[SS_STOCK_ERROR_13300] = "Busy, TXN rejected. Please try again";
  SSStockErrorMsg[SS_STOCK_ERROR_13302] = "Connectivity circle already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_13304] = "Instrument not listed";
  SSStockErrorMsg[SS_STOCK_ERROR_13306] = "Background bounce requests";
  SSStockErrorMsg[SS_STOCK_ERROR_13338] = "Invalid OrderType and product combination";
  SSStockErrorMsg[SS_STOCK_ERROR_13310] = "Trading sessions overlap";
  SSStockErrorMsg[SS_STOCK_ERROR_13312] = "CS bounce request";
  SSStockErrorMsg[SS_STOCK_ERROR_13314] = "ETF subscription and redemption failure (insufficient fund manager's position)";
  SSStockErrorMsg[SS_STOCK_ERROR_13316] = "ETF subscription and redemption failure (insufficient investor holdings)";
  SSStockErrorMsg[SS_STOCK_ERROR_13318] = "ETF subscription and redemption failure (cash substitution ratio exceeded)";
  SSStockErrorMsg[SS_STOCK_ERROR_13322] = "Background does not have any broadcast stream subscription permissions configured";
  SSStockErrorMsg[SS_STOCK_ERROR_13324] = "Do not have any market operation permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_13326] = "Number of invalid IPO issuances";
  SSStockErrorMsg[SS_STOCK_ERROR_13328] = "Operator is already logged in elsewhere";
  SSStockErrorMsg[SS_STOCK_ERROR_13330] = "Invalid base order type";
  SSStockErrorMsg[SS_STOCK_ERROR_13332] = "Invalid order types and limit combinations";
  SSStockErrorMsg[SS_STOCK_ERROR_13334] = "Combination of invalid order types and maximum revealed quantities";
  SSStockErrorMsg[SS_STOCK_ERROR_13336] = "Maximum number of invalid revelations";
  SSStockErrorMsg[SS_STOCK_ERROR_13340] = "The number of invalid orders";
  SSStockErrorMsg[SS_STOCK_ERROR_13342] = "Order quantity is less than maximum revealed quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_13344] = "Minimum requirement for order quantity to be less than number of icebergs";
  SSStockErrorMsg[SS_STOCK_ERROR_13346] = "Minimum requirement for maximum number of revelations to be less than minimum maximum number of revelations";
  SSStockErrorMsg[SS_STOCK_ERROR_13348] = "Invalid order type and trading restriction combinations";
  SSStockErrorMsg[SS_STOCK_ERROR_13350] = "Invalid order type and execution limit combination";
  SSStockErrorMsg[SS_STOCK_ERROR_13354] = "Invalid execution restriction type";
  SSStockErrorMsg[SS_STOCK_ERROR_13356] = "Invalid transaction restriction type";
  SSStockErrorMsg[SS_STOCK_ERROR_13358] = "Product and product group transaction models do not match";
  SSStockErrorMsg[SS_STOCK_ERROR_13360] = "It is not allowed to place a purchase order for products of the distribution type during the call auction";
  SSStockErrorMsg[SS_STOCK_ERROR_13362] = "Update window is too late to update";
  SSStockErrorMsg[SS_STOCK_ERROR_13366] = "IPO are still in issuance cycle cannot be deleted";
  SSStockErrorMsg[SS_STOCK_ERROR_13368] = "New PBU of day is not allowed to log in to system";
  SSStockErrorMsg[SS_STOCK_ERROR_13370] = "Presidency cannot be empty";
  SSStockErrorMsg[SS_STOCK_ERROR_13374] = "Unable to log in, trader not activated";
  SSStockErrorMsg[SS_STOCK_ERROR_13378] = "Underwriter investor account does not have designated trading relationship with PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_13380] = "Underwriter account has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_13382] = "EZOES reference data is empty";
  SSStockErrorMsg[SS_STOCK_ERROR_13384] = "Participation in opening call auction is not permitted";
  SSStockErrorMsg[SS_STOCK_ERROR_13386] = "Public storage area is running out of memory slots";
  SSStockErrorMsg[SS_STOCK_ERROR_13388] = "Timestamp of public storage area update request is outdated.";
  SSStockErrorMsg[SS_STOCK_ERROR_13390] = "There is no data in public storage area memory slot";
  SSStockErrorMsg[SS_STOCK_ERROR_13392] = "Keyword query area contains illegal data";
  SSStockErrorMsg[SS_STOCK_ERROR_13394] = "IP address of user is not in IP address whitelist";
  SSStockErrorMsg[SS_STOCK_ERROR_13396] = "OEF permissions cannot be modified online";
  SSStockErrorMsg[SS_STOCK_ERROR_13398] = "Limit order forbidden";
  SSStockErrorMsg[SS_STOCK_ERROR_13400] = "Market order trading is prohibited";
  SSStockErrorMsg[SS_STOCK_ERROR_13402] = "Market-to-limit order is prohibited";
  SSStockErrorMsg[SS_STOCK_ERROR_13404] = "Iceberg order trading is prohibited";
  SSStockErrorMsg[SS_STOCK_ERROR_13406] = "Forbidden to negotiate order transactions";
  SSStockErrorMsg[SS_STOCK_ERROR_13412] = "Ex-rights of allotment and ex-rights of allotment cannot be carried out on same day";
  SSStockErrorMsg[SS_STOCK_ERROR_13416] = "Suspension period exceeds allowable range";
  SSStockErrorMsg[SS_STOCK_ERROR_13418] = "Resumption time is beyond allowable range";
  SSStockErrorMsg[SS_STOCK_ERROR_13420] = "The product has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_13422] = "Opening call auction does not allow for resumption of trading";
  SSStockErrorMsg[SS_STOCK_ERROR_13424] = "Exceed the maximum Volume configured in the auction";
  SSStockErrorMsg[SS_STOCK_ERROR_13426] = "Order cancellation failed, and declared record of pending order was not found";
  SSStockErrorMsg[SS_STOCK_ERROR_13428] = "Cancelled order has been entered, but it is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13430] = "Failed to cancel the order, order information for the pending cancellation was not found";
  SSStockErrorMsg[SS_STOCK_ERROR_13432] = "Cancelled order itself is chargeback request";
  SSStockErrorMsg[SS_STOCK_ERROR_13434] = "The product code included in this cancellation request does not match the order itself";
  SSStockErrorMsg[SS_STOCK_ERROR_13436] = "Collateral is not allowed to be purchased for this security";
  SSStockErrorMsg[SS_STOCK_ERROR_13438] = "Margin purchases are not permitted for this security";
  SSStockErrorMsg[SS_STOCK_ERROR_13440] = "Not allowed to return by buying or margin trading by liquidating";
  SSStockErrorMsg[SS_STOCK_ERROR_13442] = "Security are not allowed to be sold by security borrowing";
  SSStockErrorMsg[SS_STOCK_ERROR_13444] = "Declared price of security borrowing and selling is lower than last traded price";
  SSStockErrorMsg[SS_STOCK_ERROR_13446] = "The front-end version does not match";
  SSStockErrorMsg[SS_STOCK_ERROR_13448] = "Not allowed to sell collateral,sell securities or repayment,close a position";
  SSStockErrorMsg[SS_STOCK_ERROR_13450] = "Selling is not allowed to declare market order";
  SSStockErrorMsg[SS_STOCK_ERROR_13452] = "Requested order mask entered is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13454] = "Cancel non-transation orders is prohibited";
  SSStockErrorMsg[SS_STOCK_ERROR_13456] = "The ETF subscription or redemption exceeds the maximum limit";
  SSStockErrorMsg[SS_STOCK_ERROR_13458] = "Trading host busy";
  SSStockErrorMsg[SS_STOCK_ERROR_13460] = "Source of instruction operation is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13462] = "Order position operation type is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13464] = "Freeze/unfreeze operation type is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13466] = "Invalid request type";
  SSStockErrorMsg[SS_STOCK_ERROR_13468] = "Transfer PBU has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_13470] = "PBU code of invalid transferor's PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_13472] = "There is no designated trading relationship between transferor's investor account and transferor's PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_13474] = "Transferee investor account has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_13476] = "Invalid Transferee Investor Account";
  SSStockErrorMsg[SS_STOCK_ERROR_13478] = "Invalid transferee investor type";
  SSStockErrorMsg[SS_STOCK_ERROR_13480] = "Request is being processed";
  SSStockErrorMsg[SS_STOCK_ERROR_13482] = "Upload time of ETF definition file is not legal";
  SSStockErrorMsg[SS_STOCK_ERROR_13484] = "Message type of ETFPUT service request is not valid";
  SSStockErrorMsg[SS_STOCK_ERROR_13486] = "Invalid login to PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_13488] = "The buyer's account does not have permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_13490] = "Seller accounts do not have permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_13492] = "The buyer's PBU does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_13494] = "The seller PBU does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_13496] = "The Buyer PBU and the Login PBU are not the same members";
  SSStockErrorMsg[SS_STOCK_ERROR_13498] = "The Seller PBU and the Login PBU are not the same member";
  SSStockErrorMsg[SS_STOCK_ERROR_13500] = "The buyer PBU does not have permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_13502] = "The seller PBU has no permission";
  SSStockErrorMsg[SS_STOCK_ERROR_13504] = "The declaration could not find the corresponding original order";
  SSStockErrorMsg[SS_STOCK_ERROR_13506] = "Declare exceeding the membership quota limit";
  SSStockErrorMsg[SS_STOCK_ERROR_13508] = "The declaration exceeds the actual amount";
  SSStockErrorMsg[SS_STOCK_ERROR_13510] = "The initial transaction exceeds the membership quota limit";
  SSStockErrorMsg[SS_STOCK_ERROR_13516] = "Message not found";
  SSStockErrorMsg[SS_STOCK_ERROR_13518] = "Invalid parameter";
  SSStockErrorMsg[SS_STOCK_ERROR_13520] = "The Buyer Account is not a Member-only account";
  SSStockErrorMsg[SS_STOCK_ERROR_13522] = "Seller accounts are not members-only accounts";
  SSStockErrorMsg[SS_STOCK_ERROR_13524] = "The buyer's account is inconsistent with the original reporting account";
  SSStockErrorMsg[SS_STOCK_ERROR_13526] = "The seller's account is inconsistent with the original reporting account";
  SSStockErrorMsg[SS_STOCK_ERROR_13528] = "The securities code is inconsistent with the original declaration order";
  SSStockErrorMsg[SS_STOCK_ERROR_13530] = "The declared quantity is inconsistent with the original declared order";
  SSStockErrorMsg[SS_STOCK_ERROR_13532] = "No AddIdx permissions, oper:%x, proc:%x";
  SSStockErrorMsg[SS_STOCK_ERROR_13534] = "No Add permissions, oper:%x, proc:%x";
  SSStockErrorMsg[SS_STOCK_ERROR_13536] = "No update permissions, oper:%x, proc:%x";
  SSStockErrorMsg[SS_STOCK_ERROR_13538] = "No read permission, oper:%x, proc:%x";
  SSStockErrorMsg[SS_STOCK_ERROR_13540] = "No del data permissions, oper:%x, proc:%x";
  SSStockErrorMsg[SS_STOCK_ERROR_13542] = "No delIDx permissions, oper:%x, proc:%x";
  SSStockErrorMsg[SS_STOCK_ERROR_13544] = "The value of the chargeback flag is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13546] = "The order type is inconsistent with the original declared order";
  SSStockErrorMsg[SS_STOCK_ERROR_13548] = "The value of the repurchase transaction date is illegal";
  SSStockErrorMsg[SS_STOCK_ERROR_13550] = "The amount field is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13552] = "The price field is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_13554] = "Invalid Membership Information Code";
  SSStockErrorMsg[SS_STOCK_ERROR_13556] = "Opening call auction of product prohibits order cancellation";
  SSStockErrorMsg[SS_STOCK_ERROR_13560] = "Broadcast service data recovery is ongoing";
  SSStockErrorMsg[SS_STOCK_ERROR_13562] = "The available login nodes of the PBU have been exhausted";
  SSStockErrorMsg[SS_STOCK_ERROR_13564] = "Prefix of product abbreviation is illegal";
  SSStockErrorMsg[SS_STOCK_ERROR_13566] = "There is an account where the specified transaction failed";
  SSStockErrorMsg[SS_STOCK_ERROR_13568] = "All account assignments failed";
  SSStockErrorMsg[SS_STOCK_ERROR_13570] = "The specified transaction is being processed";
  SSStockErrorMsg[SS_STOCK_ERROR_13572] = "Insufficient counterparty positions";
  SSStockErrorMsg[SS_STOCK_ERROR_13574] = "Invalid counterparty accounts";
  SSStockErrorMsg[SS_STOCK_ERROR_13576] = "The counterparty account has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_13578] = "Not a designated PBU for a counterparty account";
  SSStockErrorMsg[SS_STOCK_ERROR_13580] = "The counterparty PBU does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_13582] = "Invalid change time";
  SSStockErrorMsg[SS_STOCK_ERROR_13586] = "Invalid resume time";
  SSStockErrorMsg[SS_STOCK_ERROR_13588] = "Invalid suspend time";
  SSStockErrorMsg[SS_STOCK_ERROR_13592] = "Operation is prohibited in non-start phase";
  SSStockErrorMsg[SS_STOCK_ERROR_13594] = "Best market price of party declares that there are no unfilled orders of party";
  SSStockErrorMsg[SS_STOCK_ERROR_13596] = "Counterparty best market orders are declared as unfilled orders without counterparties";
  SSStockErrorMsg[SS_STOCK_ERROR_13598] = "More than protection price";
  SSStockErrorMsg[SS_STOCK_ERROR_13600] = "Invalid protection price";
  SSStockErrorMsg[SS_STOCK_ERROR_13602] = "Transaction gateway protocol conversion error: Invalid declared message length";
  SSStockErrorMsg[SS_STOCK_ERROR_13604] = "Transaction gateway protocol conversion error: Invalid transaction number (BizID)";
  SSStockErrorMsg[SS_STOCK_ERROR_13606] = "Transaction gateway protocol conversion error: Invalid member internal order number (clOrdID)";
  SSStockErrorMsg[SS_STOCK_ERROR_13608] = "Trading Gateway Protocol Conversion Error: Invalid Order Buying and Selling Direction (Side)";
  SSStockErrorMsg[SS_STOCK_ERROR_13610] = "Transaction gateway protocol conversion error: Invalid price";
  SSStockErrorMsg[SS_STOCK_ERROR_13612] = "Transaction Gateway Protocol Conversion Error: Invalid Order Quantity (OrderQty)";
  SSStockErrorMsg[SS_STOCK_ERROR_13614] = "Trading Gateway Protocol Conversion Error: Invalid Order Type (OrdType)";
  SSStockErrorMsg[SS_STOCK_ERROR_13616] = "Trading Gateway Protocol Conversion Error: Invalid Order Time Type (TimeInForce)";
  SSStockErrorMsg[SS_STOCK_ERROR_13618] = "Transaction gateway protocol conversion error: Invalid credit tag (CreditTag)";
  SSStockErrorMsg[SS_STOCK_ERROR_13620] = "Transaction gateway protocol conversion error: Invalid BranchID (BranchID)";
  SSStockErrorMsg[SS_STOCK_ERROR_13622] = "Transaction gateway protocol conversion error: Invalid Custodian (Custodian)";
  SSStockErrorMsg[SS_STOCK_ERROR_13624] = "Trading gateway protocol conversion error: Invalid dividend method (DividendSelect)";
  SSStockErrorMsg[SS_STOCK_ERROR_13626] = "Trading Gateway Protocol Conversion Error: Invalid Target Security Code (DestSecurity)";
  SSStockErrorMsg[SS_STOCK_ERROR_13628] = "Transaction gateway protocol conversion error: Invalid specified transaction registration instruction (DesignationInstruction)";
  SSStockErrorMsg[SS_STOCK_ERROR_13630] = "Transaction Gateway Protocol Conversion Error: Invalid Specified Transaction Registration Type (DesignationTransType)";
  SSStockErrorMsg[SS_STOCK_ERROR_13632] = "Transaction gateway protocol conversion error: Invalid activation code containing invalid characters (validationCode)";
  SSStockErrorMsg[SS_STOCK_ERROR_13700] = "Invalid message type ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13701] = "Invalid certificate format: ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13702] = "Invalid platform";
  SSStockErrorMsg[SS_STOCK_ERROR_13703] = "Invalid SoftwareVersion (ITCS) of TDGW version";
  SSStockErrorMsg[SS_STOCK_ERROR_13704] = "Inconsistent TechPBU during login";
  SSStockErrorMsg[SS_STOCK_ERROR_13705] = "Random number signature wrong signature ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13706] = "Wrong certificate ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13707] = "Login cookie error (wrong cookie) ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13710] = "Wrong password ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13711] = "Login forbidden at non trading day ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13712] = "The number of subscribers to a broadcast stream cannot be greater than 3";
  SSStockErrorMsg[SS_STOCK_ERROR_13713] = "Not platform trading time yet";
  SSStockErrorMsg[SS_STOCK_ERROR_13714] = "Platform out of service";
  SSStockErrorMsg[SS_STOCK_ERROR_13715] = "Unable to parse STEP message body ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13716] = "Illegal business PBU (BizPBU must belong to the same institute as TechPBU) ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_13718] = "Invalid partitionNo";
  SSStockErrorMsg[SS_STOCK_ERROR_13720] = "Repeated partitionNo";
  SSStockErrorMsg[SS_STOCK_ERROR_13722] = "Invalid Sync Type";
  SSStockErrorMsg[SS_STOCK_ERROR_13724] = "Invalid sync seqNum";
  SSStockErrorMsg[SS_STOCK_ERROR_14000] = "Pbu request execution report max seqno failed";
  SSStockErrorMsg[SS_STOCK_ERROR_14002] = "Pbu retransmission execution report failed";
  SSStockErrorMsg[SS_STOCK_ERROR_14004] = "Invalid dsgn adjust reqtype";
  SSStockErrorMsg[SS_STOCK_ERROR_14006] = "Invalid tdgwID";
  SSStockErrorMsg[SS_STOCK_ERROR_14008] = "Paused tdgwID";
  SSStockErrorMsg[SS_STOCK_ERROR_14010] = "TdgwID and cert unauthorized to same member";
  SSStockErrorMsg[SS_STOCK_ERROR_14012] = "TdgwID unauthorized to specified platform";
  SSStockErrorMsg[SS_STOCK_ERROR_17002] = "Exceed limit";
  SSStockErrorMsg[SS_STOCK_ERROR_17004] = "Inst is forbidded to buy";
  SSStockErrorMsg[SS_STOCK_ERROR_17006] = "Inst is forbidded to sell";
  SSStockErrorMsg[SS_STOCK_ERROR_17008] = "Inst is forbidded to buy and sell";
  SSStockErrorMsg[SS_STOCK_ERROR_17010] = "Invalid max price levels";
  SSStockErrorMsg[SS_STOCK_ERROR_17012] = "Invalid Req Or Remote Host Unavailable";
  SSStockErrorMsg[SS_STOCK_ERROR_17014] = "EzEI Host List";
  SSStockErrorMsg[SS_STOCK_ERROR_17016] = "Change to Normal Mode";
  SSStockErrorMsg[SS_STOCK_ERROR_17018] = "Change to Sync Mode";
  SSStockErrorMsg[SS_STOCK_ERROR_17020] = "The product is already sellable only";
  SSStockErrorMsg[SS_STOCK_ERROR_17022] = "The product is no longer available for sale";
  SSStockErrorMsg[SS_STOCK_ERROR_17024] = "The product is already available for sale";
  SSStockErrorMsg[SS_STOCK_ERROR_17026] = "Business is forbidden to buy";
  SSStockErrorMsg[SS_STOCK_ERROR_17028] = "Business is forbidden to sell";
  SSStockErrorMsg[SS_STOCK_ERROR_17030] = "Buying and selling is prohibited";
  SSStockErrorMsg[SS_STOCK_ERROR_17032] = "Invalid business permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_17034] = "Invalid Effective Date";
  SSStockErrorMsg[SS_STOCK_ERROR_17036] = "Invalid statusID";
  SSStockErrorMsg[SS_STOCK_ERROR_17038] = "INVALID TIMEINFORCE";
  SSStockErrorMsg[SS_STOCK_ERROR_17040] = "Invalid amounts";
  SSStockErrorMsg[SS_STOCK_ERROR_17042] = "Permissions are not set";
  SSStockErrorMsg[SS_STOCK_ERROR_17044] = "Permissions are restricted";
  SSStockErrorMsg[SS_STOCK_ERROR_17046] = "The PBU cannot perform permission operations";
  SSStockErrorMsg[SS_STOCK_ERROR_17048] = "Invalid reference exchange rate";
  SSStockErrorMsg[SS_STOCK_ERROR_17566] = "The member's settlement reserve is not enough to open a new position";
  SSStockErrorMsg[SS_STOCK_ERROR_17568] = "The premium price was calculated incorrectly";
  SSStockErrorMsg[SS_STOCK_ERROR_17570] = "Option margin calculation error";
  SSStockErrorMsg[SS_STOCK_ERROR_17572] = "The funds are not sufficient to pay the royalty";
  SSStockErrorMsg[SS_STOCK_ERROR_17574] = "The funds are insufficient to cover the security deposit";
  SSStockErrorMsg[SS_STOCK_ERROR_17576] = "The option is of the wrong type of opening and closing";
  SSStockErrorMsg[SS_STOCK_ERROR_17582] = "Invalid investor type";
  SSStockErrorMsg[SS_STOCK_ERROR_17584] = "The direction of opening and closing positions is inconsistent";
  SSStockErrorMsg[SS_STOCK_ERROR_17586] = "Invalid Clearing Member";
  SSStockErrorMsg[SS_STOCK_ERROR_17588] = "Invalid option code";
  SSStockErrorMsg[SS_STOCK_ERROR_17590] = "Invalid price dimension";
  SSStockErrorMsg[SS_STOCK_ERROR_17592] = "The product is past the last trading day";
  SSStockErrorMsg[SS_STOCK_ERROR_17594] = "The date on which the application for the exercise of the rights was unlawful";
  SSStockErrorMsg[SS_STOCK_ERROR_17598] = "Invalid covered label";
  SSStockErrorMsg[SS_STOCK_ERROR_17602] = "Unimplemented feature requests";
  SSStockErrorMsg[SS_STOCK_ERROR_17604] = "Invalid account type";
  SSStockErrorMsg[SS_STOCK_ERROR_17606] = "The position exceeds the limit of the account's underlying position";
  SSStockErrorMsg[SS_STOCK_ERROR_17608] = "The position exceeds the limit of the member's target";
  SSStockErrorMsg[SS_STOCK_ERROR_17610] = "The position exceeds the member's market-wide limit";
  SSStockErrorMsg[SS_STOCK_ERROR_17612] = "Covered positions are insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_17614] = "Cover is not allowed for buy open positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17616] = "Cover is not allowed to sell to close positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17618] = "Covered put options are not permitted";
  SSStockErrorMsg[SS_STOCK_ERROR_17622] = "Lock-in stock is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_17624] = "FOK order triggers VOLA";
  SSStockErrorMsg[SS_STOCK_ERROR_17626] = "Invalid processing category";
  SSStockErrorMsg[SS_STOCK_ERROR_17628] = "This type of order is not allowed to be declared in the opening call auction";
  SSStockErrorMsg[SS_STOCK_ERROR_17630] = "This type of order is not allowed to be declared in the intraday call auction";
  SSStockErrorMsg[SS_STOCK_ERROR_17632] = "Invalid Funding Account Type";
  SSStockErrorMsg[SS_STOCK_ERROR_17634] = "Failed to set or query product information";
  SSStockErrorMsg[SS_STOCK_ERROR_17636] = "The position exceeds the account's market-wide limit";
  SSStockErrorMsg[SS_STOCK_ERROR_17638] = "The PBU does not have access to the funding account";
  SSStockErrorMsg[SS_STOCK_ERROR_17640] = "The product has removed the limit on open positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17642] = "The product has a limit on opening positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17644] = "Invalid on the current trading day";
  SSStockErrorMsg[SS_STOCK_ERROR_17646] = "The date is less than the current trading date";
  SSStockErrorMsg[SS_STOCK_ERROR_17648] = "VOLA does not allow last-minute deletion of orders";
  SSStockErrorMsg[SS_STOCK_ERROR_17650] = "The amount of funds is too large";
  SSStockErrorMsg[SS_STOCK_ERROR_17652] = "PBUs do not have the permission to open positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17654] = "PBUs do not have the right to close positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17656] = "Invalid investor account subcode";
  SSStockErrorMsg[SS_STOCK_ERROR_17658] = "There is no permission to buy and open a position";
  SSStockErrorMsg[SS_STOCK_ERROR_17660] = "Contracts do not have the right to open positions without covered selling";
  SSStockErrorMsg[SS_STOCK_ERROR_17662] = "Futures do not have the permission to open covered sell positions";
  SSStockErrorMsg[SS_STOCK_ERROR_17664] = "The settlement price of the contract is abnormal";
  SSStockErrorMsg[SS_STOCK_ERROR_17668] = "Closing Call Auction last minute does not allow order deletion";
  SSStockErrorMsg[SS_STOCK_ERROR_17670] = "This type of order is not allowed to be declared in the closing call auction";
  SSStockErrorMsg[SS_STOCK_ERROR_18200] = "Package message header is broken";
  SSStockErrorMsg[SS_STOCK_ERROR_18202] = "Invalid message length";
  SSStockErrorMsg[SS_STOCK_ERROR_18204] = "The two-sided information in the position update order mask is inconsistent with the input parameters";
  SSStockErrorMsg[SS_STOCK_ERROR_18206] = "Invalid request mask";
  SSStockErrorMsg[SS_STOCK_ERROR_18208] = "The mask for the position update order has not yet been enabled";
  SSStockErrorMsg[SS_STOCK_ERROR_18210] = "The mask of the position update order cannot be used for ETF subscription and redemption";
  SSStockErrorMsg[SS_STOCK_ERROR_18600] = "The current time is not within the time period set by the business";
  SSStockErrorMsg[SS_STOCK_ERROR_19000] = "Unspecified format error";
  SSStockErrorMsg[SS_STOCK_ERROR_19002] = "The productID is malformed";
  SSStockErrorMsg[SS_STOCK_ERROR_19004] = "The account format is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19006] = "The quantity is formatted incorrectly";
  SSStockErrorMsg[SS_STOCK_ERROR_19008] = "The date format is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19010] = "The amount is formatted incorrectly";
  SSStockErrorMsg[SS_STOCK_ERROR_19012] = "The price is formatted incorrectly";
  SSStockErrorMsg[SS_STOCK_ERROR_19014] = "The format of the revocation slip flag is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19016] = "The broker number is in the wrong format";
  SSStockErrorMsg[SS_STOCK_ERROR_19018] = "The PBU format is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19020] = "The order request is malformed";
  SSStockErrorMsg[SS_STOCK_ERROR_19022] = "Invalid business type";
  SSStockErrorMsg[SS_STOCK_ERROR_19024] = "The original order transaction number is in the wrong format";
  SSStockErrorMsg[SS_STOCK_ERROR_19026] = "The original order was filled in the wrong format";
  SSStockErrorMsg[SS_STOCK_ERROR_19028] = "The sales office code is in the wrong format";
  SSStockErrorMsg[SS_STOCK_ERROR_19030] = "PBUs do not have the authority to subscribe/redeem ETFs";
  SSStockErrorMsg[SS_STOCK_ERROR_19032] = "Invalid business type";
  SSStockErrorMsg[SS_STOCK_ERROR_19036] = "Invalid order side";
  SSStockErrorMsg[SS_STOCK_ERROR_19038] = "The subscription amount of the ETF exceeds the subscription limit of the day";
  SSStockErrorMsg[SS_STOCK_ERROR_19040] = "The redemption amount of the ETF exceeds the redemption limit on the same day";
  SSStockErrorMsg[SS_STOCK_ERROR_19042] = "The parameter value is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_19044] = "The number of illegal separators";
  SSStockErrorMsg[SS_STOCK_ERROR_19046] = "The template key value is not defined, and the template is not found";
  SSStockErrorMsg[SS_STOCK_ERROR_19048] = "Illegal Accounts";
  SSStockErrorMsg[SS_STOCK_ERROR_19050] = "The price step is illegal";
  SSStockErrorMsg[SS_STOCK_ERROR_19056] = "The content of the service PBU or REFF field does not match the content in the STEP message";
  SSStockErrorMsg[SS_STOCK_ERROR_19058] = "Biz PBU and login PBU belongs different member";
  SSStockErrorMsg[SS_STOCK_ERROR_19060] = "Invalid business number";
  SSStockErrorMsg[SS_STOCK_ERROR_19062] = "When the order is cancelled, it is found that the product code is inconsistent with the original value";
  SSStockErrorMsg[SS_STOCK_ERROR_19064] = "When the order is cancelled, it is found that the PBU is inconsistent with the original value";
  SSStockErrorMsg[SS_STOCK_ERROR_19066] = "When the order is cancelled, it is found that the buying and selling direction is inconsistent with the original value";
  SSStockErrorMsg[SS_STOCK_ERROR_19068] = "Unsupported product types";
  SSStockErrorMsg[SS_STOCK_ERROR_19070] = "The declared quantity is negative";
  SSStockErrorMsg[SS_STOCK_ERROR_19072] = "Invalid account type";
  SSStockErrorMsg[SS_STOCK_ERROR_19074] = "The declared price is negative";
  SSStockErrorMsg[SS_STOCK_ERROR_19076] = "Invalid convention number";
  SSStockErrorMsg[SS_STOCK_ERROR_19078] = "Invalid billingID";
  SSStockErrorMsg[SS_STOCK_ERROR_19080] = "The order has been filled and cannot be deleted";
  SSStockErrorMsg[SS_STOCK_ERROR_19084] = "The convention number is not unique";
  SSStockErrorMsg[SS_STOCK_ERROR_19086] = "The order has been deleted";
  SSStockErrorMsg[SS_STOCK_ERROR_19088] = "The type of illegal message";
  SSStockErrorMsg[SS_STOCK_ERROR_19090] = "Trading in the product has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19092] = "Trading has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19096] = "The number of orders and the amount of the transaction are less than the minimum requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19098] = "The number of orders is not a whole lot";
  SSStockErrorMsg[SS_STOCK_ERROR_19102] = "The order price is out of range";
  SSStockErrorMsg[SS_STOCK_ERROR_19104] = "The PBU has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19106] = "The PBU does not have permissions on the service";
  SSStockErrorMsg[SS_STOCK_ERROR_19108] = "The PBU does not have authority on the product";
  SSStockErrorMsg[SS_STOCK_ERROR_19110] = "The product has been discontinued";
  SSStockErrorMsg[SS_STOCK_ERROR_19112] = "Biz type unavailable";
  SSStockErrorMsg[SS_STOCK_ERROR_19114] = "Instrument unavailable";
  SSStockErrorMsg[SS_STOCK_ERROR_19118] = "Subtypes are not available";
  SSStockErrorMsg[SS_STOCK_ERROR_19122] = "Subscription relationship does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_19124] = "TXNCODE does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_19128] = "Pbu unavailable";
  SSStockErrorMsg[SS_STOCK_ERROR_19132] = "The product index number is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_19134] = "The resource access number is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_19136] = "The permission flag is not legitimate";
  SSStockErrorMsg[SS_STOCK_ERROR_19138] = "You do not have this permission";
  SSStockErrorMsg[SS_STOCK_ERROR_19140] = "Invalid RID";
  SSStockErrorMsg[SS_STOCK_ERROR_19142] = "Invalid periods";
  SSStockErrorMsg[SS_STOCK_ERROR_19144] = "Invalid sales office code";
  SSStockErrorMsg[SS_STOCK_ERROR_19146] = "The order is in the pre-matched state";
  SSStockErrorMsg[SS_STOCK_ERROR_19148] = "The PBU does not have access to the RAL";
  SSStockErrorMsg[SS_STOCK_ERROR_19150] = "Negotiate a matching order in the same direction as the buy and sell";
  SSStockErrorMsg[SS_STOCK_ERROR_19152] = "The productIDs of the negotiated matching orders are not the same";
  SSStockErrorMsg[SS_STOCK_ERROR_19154] = "The negotiation matching order business types are not the same";
  SSStockErrorMsg[SS_STOCK_ERROR_19156] = "The declared price of the negotiated matching order is not the same";
  SSStockErrorMsg[SS_STOCK_ERROR_19158] = "The number of negotiated matching orders declared is not the same";
  SSStockErrorMsg[SS_STOCK_ERROR_19160] = "There is a matchable transaction declaration, The PBU verification between the initiator and the counterparty fails";
  SSStockErrorMsg[SS_STOCK_ERROR_19162] = "Invalid Accounts";
  SSStockErrorMsg[SS_STOCK_ERROR_19164] = "The account has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19166] = "The account does not have trading authority for this transaction";
  SSStockErrorMsg[SS_STOCK_ERROR_19168] = "The account in the cancelled order is different from the original order";
  SSStockErrorMsg[SS_STOCK_ERROR_19170] = "The code of the security in the cancelled order is inconsistent with the original order";
  SSStockErrorMsg[SS_STOCK_ERROR_19172] = "The declared quantity in the cancelled order is inconsistent with the original order";
  SSStockErrorMsg[SS_STOCK_ERROR_19174] = "The direction of the order in the cancellation is inconsistent with the original order";
  SSStockErrorMsg[SS_STOCK_ERROR_19176] = "Trading is invalid during this session";
  SSStockErrorMsg[SS_STOCK_ERROR_19178] = "The term is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_19180] = "It is not the designated PBU of this account";
  SSStockErrorMsg[SS_STOCK_ERROR_19182] = "Invalid rates";
  SSStockErrorMsg[SS_STOCK_ERROR_19184] = "The number of declarations exceeds the upper limit";
  SSStockErrorMsg[SS_STOCK_ERROR_19186] = "Invalid order status";
  SSStockErrorMsg[SS_STOCK_ERROR_19188] = "The product has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19190] = "The product has been reinstated";
  SSStockErrorMsg[SS_STOCK_ERROR_19192] = "Membership does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_19196] = "Members do not have trading authority over the business";
  SSStockErrorMsg[SS_STOCK_ERROR_19198] = "The original order is being processed";
  SSStockErrorMsg[SS_STOCK_ERROR_19200] = "The net subscription on the day exceeds the net subscription limit of the fund";
  SSStockErrorMsg[SS_STOCK_ERROR_19202] = "The net redemption on the same day exceeds the fund's net redemption cap";
  SSStockErrorMsg[SS_STOCK_ERROR_19204] = "The product is already in the indicative auction";
  SSStockErrorMsg[SS_STOCK_ERROR_19206] = "Invalid chargeback reff";
  SSStockErrorMsg[SS_STOCK_ERROR_19210] = "Invalid data format";
  SSStockErrorMsg[SS_STOCK_ERROR_19212] = "The primary key entered is inconsistent with the primary key in the record";
  SSStockErrorMsg[SS_STOCK_ERROR_19214] = "Undefined file name";
  SSStockErrorMsg[SS_STOCK_ERROR_19216] = "Deleting data is not the same as the original record of the file";
  SSStockErrorMsg[SS_STOCK_ERROR_19218] = "The length of the bitmap does not match the number of fields";
  SSStockErrorMsg[SS_STOCK_ERROR_19220] = "Bitmap information is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19222] = "Refinancing has begun";
  SSStockErrorMsg[SS_STOCK_ERROR_19224] = "The instruction has been executed";
  SSStockErrorMsg[SS_STOCK_ERROR_19226] = "The period has been suspended from trading";
  SSStockErrorMsg[SS_STOCK_ERROR_19228] = "The total subscription on the day exceeds the total subscription limit of the fund";
  SSStockErrorMsg[SS_STOCK_ERROR_19230] = "The total redemption of the day exceeds the total redemption limit of the fund";
  SSStockErrorMsg[SS_STOCK_ERROR_19232] = "The subscription exceeds the net subscription limit of a single account on the same day";
  SSStockErrorMsg[SS_STOCK_ERROR_19234] = "The redemption exceeds the net redemption limit of a single account on the same day";
  SSStockErrorMsg[SS_STOCK_ERROR_19236] = "The subscription exceeds the total subscription limit of a single account on the same day";
  SSStockErrorMsg[SS_STOCK_ERROR_19238] = "The redemption exceeds the total redemption limit of a single account on the same day";
  SSStockErrorMsg[SS_STOCK_ERROR_19240] = "Exceeding the callable amount";
  SSStockErrorMsg[SS_STOCK_ERROR_19242] = "Cancellations are not allowed during this time period";
  SSStockErrorMsg[SS_STOCK_ERROR_19244] = "The amount of the order is not a whole lot";
  SSStockErrorMsg[SS_STOCK_ERROR_19246] = "The account exceeds the quota limit";
  SSStockErrorMsg[SS_STOCK_ERROR_19248] = "The account does not have trading access to this instrument";
  SSStockErrorMsg[SS_STOCK_ERROR_19250] = "The buyer's PBU is inconsistent with the original declared PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_19252] = "The seller's PBU is inconsistent with the original declared PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_19254] = "Invalid closing price";
  SSStockErrorMsg[SS_STOCK_ERROR_19256] = "The share reduction mark is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19258] = "The investor account and product symbol are not on the shareholding control list, and it is not allowed to file a specific share reduction sell order";
  SSStockErrorMsg[SS_STOCK_ERROR_19260] = "Investors' free float positions are insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_19262] = "Investors are not able to reduce their holdings in large quantities";
  SSStockErrorMsg[SS_STOCK_ERROR_19264] = "The type of security transfer is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19266] = "The product corresponding to the auction has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19268] = "The negotiation matching order period is not the same";
  SSStockErrorMsg[SS_STOCK_ERROR_19270] = "The combination strategy does not meet the requirements for constituting the underlying contract";
  SSStockErrorMsg[SS_STOCK_ERROR_19272] = "The exercise price of the portfolio strategy constitutes a contract that does not meet the requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19274] = "Combination strategies constitute inconsistent contract multipliers";
  SSStockErrorMsg[SS_STOCK_ERROR_19276] = "The number of shares of the portfolio does not match the proportion of the constituent contracts, or the proportion of the constituent contracts does not match the ratio required by the strategy";
  SSStockErrorMsg[SS_STOCK_ERROR_19278] = "The number of portfolio policy splits exceeds the SM78 record value";
  SSStockErrorMsg[SS_STOCK_ERROR_19280] = "This product does not support strategic placement";
  SSStockErrorMsg[SS_STOCK_ERROR_19282] = "The normal sell to cover strategy of call options does not support splitting";
  SSStockErrorMsg[SS_STOCK_ERROR_19284] = "The split reporting strategy doesn't match the combination";
  SSStockErrorMsg[SS_STOCK_ERROR_19286] = "There is a mismatch between the reporting contract and the combination";
  SSStockErrorMsg[SS_STOCK_ERROR_19288] = "The combination number is not blank when combined";
  SSStockErrorMsg[SS_STOCK_ERROR_19290] = "Splitting reporting accounts is different from combining them";
  SSStockErrorMsg[SS_STOCK_ERROR_19292] = "When splitting, the combination number cannot be empty";
  SSStockErrorMsg[SS_STOCK_ERROR_19294] = "The portfolio position does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_19296] = "The collective subscription transaction number is duplicated 期权平台：Funds are not enough for splitting";
  SSStockErrorMsg[SS_STOCK_ERROR_19298] = "The number of combinations must be greater than 0";
  SSStockErrorMsg[SS_STOCK_ERROR_19300] = "The number of contracts constituting a portfolio strategy does not meet the requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19302] = "The expiration date of the portfolio strategy constitutes a contract that does not meet the requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19304] = "The combination strategy constitutes a contract, and the option type does not meet the requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19306] = "The portfolio strategy constitutes a contract covered label that does not meet the requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19310] = "The product has been independently suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_19312] = "The preset time for the suspension and resumption of trading of the product is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19314] = "Market makers are prohibited from trading on their own";
  SSStockErrorMsg[SS_STOCK_ERROR_19320] = "Failed to open an account";
  SSStockErrorMsg[SS_STOCK_ERROR_19322] = "Seat check failed";
  SSStockErrorMsg[SS_STOCK_ERROR_19324] = "The Unicom circle inspection failed";
  SSStockErrorMsg[SS_STOCK_ERROR_19326] = "Partition sequence number synchronization failed";
  SSStockErrorMsg[SS_STOCK_ERROR_19328] = "Must be a trading day for A-shares";
  SSStockErrorMsg[SS_STOCK_ERROR_19330] = "Must be an H-share trading day";
  SSStockErrorMsg[SS_STOCK_ERROR_19332] = "Hong Kong market error";
  SSStockErrorMsg[SS_STOCK_ERROR_19334] = "Unable to resolve order";
  SSStockErrorMsg[SS_STOCK_ERROR_19336] = "Institutions are not eligible to sell the product";
  SSStockErrorMsg[SS_STOCK_ERROR_19338] = "Institutions are not qualified to make markets for this product";
  SSStockErrorMsg[SS_STOCK_ERROR_19340] = "The certificate data format is not supported";
  SSStockErrorMsg[SS_STOCK_ERROR_19342] = "Invalid certificates";
  SSStockErrorMsg[SS_STOCK_ERROR_19344] = "Before the partition sequence number is synchronized, you need to subscribe to the corresponding PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_19346] = "The random number signature verification fails";
  SSStockErrorMsg[SS_STOCK_ERROR_19348] = "The PBU is not subscribed";
  SSStockErrorMsg[SS_STOCK_ERROR_19352] = "PBU already logged in ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_19354] = "The PBU kicks off the ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_19356] = "TDGW version over low, please update ITCS";
  SSStockErrorMsg[SS_STOCK_ERROR_19358] = "The institution has not opened the fund connect platform sales qualification";
  SSStockErrorMsg[SS_STOCK_ERROR_19360] = "The institution has not opened the market-making qualification of the Fund Connect platform";
  SSStockErrorMsg[SS_STOCK_ERROR_19362] = "Institutions do not have buy-in (transfer-in) permissions;";
  SSStockErrorMsg[SS_STOCK_ERROR_19364] = "Institutions do not have sell (transfer out) permissions";
  SSStockErrorMsg[SS_STOCK_ERROR_19366] = "The securities account does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_19368] = "The securities account status is invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_19370] = "There is no designated PUB for securities accounts";
  SSStockErrorMsg[SS_STOCK_ERROR_19372] = "The on-exchange securities account number is inconsistent with the market-making account reported for the product";
  SSStockErrorMsg[SS_STOCK_ERROR_19374] = "The four elements of the TA account are inconsistent with the market-making special account reported for the product";
  SSStockErrorMsg[SS_STOCK_ERROR_19376] = "The TA account information is incomplete";
  SSStockErrorMsg[SS_STOCK_ERROR_19378] = "The organization type is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19380] = "The elements of TA account information do not match;";
  SSStockErrorMsg[SS_STOCK_ERROR_19382] = "The fund account cannot be empty after the account opening is confirmed;";
  SSStockErrorMsg[SS_STOCK_ERROR_19384] = "The investor'sIDentity information is inconsistent with the fund account information on file";
  SSStockErrorMsg[SS_STOCK_ERROR_19386] = "The status of the exchange account is abnormal";
  SSStockErrorMsg[SS_STOCK_ERROR_19388] = "The status of the TA account information is abnormal";
  SSStockErrorMsg[SS_STOCK_ERROR_19390] = "The investor does not have an exchange account";
  SSStockErrorMsg[SS_STOCK_ERROR_19392] = "The exchange account number does not match the TA account information";
  SSStockErrorMsg[SS_STOCK_ERROR_19394] = "The order quantity does not meet the upper and lower limits of the declared quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_19396] = "The order quantity does not meet the declaration step";
  SSStockErrorMsg[SS_STOCK_ERROR_19398] = "The net buying quota of the day is insufficient";
  SSStockErrorMsg[SS_STOCK_ERROR_19400] = "When the order is cancelled, it is found that the trading account is inconsistent with the original value";
  SSStockErrorMsg[SS_STOCK_ERROR_19402] = "Cancellation of the original order is not allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_19404] = "The requisition ticket number is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19406] = "The security code is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19408] = "The exchange account verification error";
  SSStockErrorMsg[SS_STOCK_ERROR_19410] = "Pending order type verification error";
  SSStockErrorMsg[SS_STOCK_ERROR_19412] = "The overseas brokerage firm is not logged in";
  SSStockErrorMsg[SS_STOCK_ERROR_19414] = "The current maximum index number is being validated incorrectly";
  SSStockErrorMsg[SS_STOCK_ERROR_19416] = "The flow rate is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19418] = "The service time verification error is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19420] = "The pagination size cannot be empty";
  SSStockErrorMsg[SS_STOCK_ERROR_19422] = "The order price does not meet the upper and lower limits";
  SSStockErrorMsg[SS_STOCK_ERROR_19424] = "The order price does not meet the step size requirements";
  SSStockErrorMsg[SS_STOCK_ERROR_19426] = "The institution code cannot be empty";
  SSStockErrorMsg[SS_STOCK_ERROR_19428] = "The length of the organization code exceeds the limit";
  SSStockErrorMsg[SS_STOCK_ERROR_19430] = "The order number is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19432] = "The original member's internal order number is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_19434] = "The system is busy, Please try again later";
  SSStockErrorMsg[SS_STOCK_ERROR_19436] = "Orders that have been matched during this period are not allowed to be cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_19438] = "The selected offerer exceeds the quantity limit";
  SSStockErrorMsg[SS_STOCK_ERROR_19440] = "The requested party is abnormal";
  SSStockErrorMsg[SS_STOCK_ERROR_19442] = "The public packet header information is abnormal";
  SSStockErrorMsg[SS_STOCK_ERROR_19444] = "The information of the selected offeror is abnormal";
  SSStockErrorMsg[SS_STOCK_ERROR_19446] = "The original RFQ is invalid or does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_20000] = "Message type unexpected";
  SSStockErrorMsg[SS_STOCK_ERROR_20001] = "Invalid platform id";
  SSStockErrorMsg[SS_STOCK_ERROR_20002] = "BodyLength field check error";
  SSStockErrorMsg[SS_STOCK_ERROR_20003] = "Pbu duplicate logon";
  SSStockErrorMsg[SS_STOCK_ERROR_20004] = "ClOrdID field check error";
  SSStockErrorMsg[SS_STOCK_ERROR_20005] = "Pbu subscribe other pbu's execution report failed";
  SSStockErrorMsg[SS_STOCK_ERROR_20006] = "The ExecID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20008] = "IOIID field check error";
  SSStockErrorMsg[SS_STOCK_ERROR_20009] = "Pbu kickoff by backend";
  SSStockErrorMsg[SS_STOCK_ERROR_20010] = "IOIRefID field check error";
  SSStockErrorMsg[SS_STOCK_ERROR_20011] = "Invalid origclordid format";
  SSStockErrorMsg[SS_STOCK_ERROR_20012] = "IOITransType field check error";
  SSStockErrorMsg[SS_STOCK_ERROR_20013] = "Invalid clearingfirm format";
  SSStockErrorMsg[SS_STOCK_ERROR_20014] = "LastPx field check error";
  SSStockErrorMsg[SS_STOCK_ERROR_20015] = "Invalid owner type";
  SSStockErrorMsg[SS_STOCK_ERROR_20016] = "The LastQty field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20018] = "The MsgType field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20020] = "The OrderID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20022] = "The OrderQty field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20024] = "The OrdStatus field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20026] = "OrderID";
  SSStockErrorMsg[SS_STOCK_ERROR_20028] = "The OrigClOrdID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20030] = "The OrigTime field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20032] = "The Price field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20034] = "The SecurityID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20036] = "The Side field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20038] = "The Symbol field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20040] = "The Text field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20042] = "The TransactTime field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20044] = "The date of the transaction";
  SSStockErrorMsg[SS_STOCK_ERROR_20046] = "The CxlRejReason field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20048] = "The OrdRejReason field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20050] = "The member internal number refers to the internal number of the member in the quotation declaration/quotation declaration cancellation";
  SSStockErrorMsg[SS_STOCK_ERROR_20052] = "Yesterday's closing price";
  SSStockErrorMsg[SS_STOCK_ERROR_20054] = "The ExecType field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20056] = "The LeavesQty field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20058] = "OrderQty2 constituent security quantity verification error";
  SSStockErrorMsg[SS_STOCK_ERROR_20060] = "Order quantity 2, or coupon value 2. If the side is two-way, enter the sell quantity, and in other cases, set 0";
  SSStockErrorMsg[SS_STOCK_ERROR_20062] = "Reference yield to maturity";
  SSStockErrorMsg[SS_STOCK_ERROR_20064] = "The number of market entries";
  SSStockErrorMsg[SS_STOCK_ERROR_20066] = "Quote category";
  SSStockErrorMsg[SS_STOCK_ERROR_20068] = "Market price";
  SSStockErrorMsg[SS_STOCK_ERROR_20070] = "The MDEntrySize field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20072] = "The type of market update";
  SSStockErrorMsg[SS_STOCK_ERROR_20074] = "Order number";
  SSStockErrorMsg[SS_STOCK_ERROR_20076] = "Quote status";
  SSStockErrorMsg[SS_STOCK_ERROR_20078] = "The TotalVolumeTraded field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20080] = "The CxlRejResponseTo field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20082] = "The PartyID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20084] = "The PartyRole field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20086] = "The NoPartyIDs field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20088] = "The Designation field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20090] = "Whether it is a market-making quote";
  SSStockErrorMsg[SS_STOCK_ERROR_20092] = "The type of quotation declaration";
  SSStockErrorMsg[SS_STOCK_ERROR_20094] = "NoDates field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20096] = "The Price2 field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20098] = "Exchange order number";
  SSStockErrorMsg[SS_STOCK_ERROR_20100] = "The ConfirmID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20102] = "QuoteRespID field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20104] = "QuoteRespType field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20106] = "Refer to the full price";
  SSStockErrorMsg[SS_STOCK_ERROR_20108] = "The AgreementID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20110] = "The StartCash field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20112] = "The EndCash field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20114] = "The RefOrderID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20116] = "Whether the quote is anonymous or not";
  SSStockErrorMsg[SS_STOCK_ERROR_20118] = "The OrigTradeDate field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20120] = "Iceberg order quantity, if it is not an iceberg order, this field is 0";
  SSStockErrorMsg[SS_STOCK_ERROR_20122] = "The type of offer";
  SSStockErrorMsg[SS_STOCK_ERROR_20124] = "The ApplID field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20126] = "Exchange order number, for two-way quotations, it is divided into two quotation market information";
  SSStockErrorMsg[SS_STOCK_ERROR_20128] = "Registration Instructions";
  SSStockErrorMsg[SS_STOCK_ERROR_20130] = "Number of deals";
  SSStockErrorMsg[SS_STOCK_ERROR_20132] = "The TotalValueTraded field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20134] = "The TradeDate field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20136] = "SecurityDesc field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20138] = "The MaturityDate field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20140] = "The OrdType field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20142] = "The CashOrderQty field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20144] = "The VotingProposal field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20146] = "The VotingPreference field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20152] = "GeneralMeetingSeq field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20154] = "Bond code";
  SSStockErrorMsg[SS_STOCK_ERROR_20156] = "Indicates that the current value of PartySubIDType is the bond code";
  SSStockErrorMsg[SS_STOCK_ERROR_20158] = "The trading customer (broker) inquires about the internal number of the application";
  SSStockErrorMsg[SS_STOCK_ERROR_20160] = "The account is associated with a duplicate bond group";
  SSStockErrorMsg[SS_STOCK_ERROR_20162] = "DesignationInstruction field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20164] = "DesignationTransType field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_20166] = "The ValidationCode field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20168] = "The MarginAmt field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20172] = "The parameter value is illegal tag: 59";
  SSStockErrorMsg[SS_STOCK_ERROR_20174] = "The parameter value is illegal tag: 856";
  SSStockErrorMsg[SS_STOCK_ERROR_20176] = "The parameter value is illegal tag: 455";
  SSStockErrorMsg[SS_STOCK_ERROR_20178] = "The parameter value is illegal tag: 8503";
  SSStockErrorMsg[SS_STOCK_ERROR_20202] = "The parameter value is illegal tag: 308";
  SSStockErrorMsg[SS_STOCK_ERROR_20204] = "The parameter value is illegal tag: 522";
  SSStockErrorMsg[SS_STOCK_ERROR_20206] = "The parameter value is illegal tag: 59";
  SSStockErrorMsg[SS_STOCK_ERROR_20208] = "The parameter value is illegal tag: 203";
  SSStockErrorMsg[SS_STOCK_ERROR_20212] = "The parameter value is illegal tag: 8538";
  SSStockErrorMsg[SS_STOCK_ERROR_20214] = "The parameter value is illegal tag: 845";
  SSStockErrorMsg[SS_STOCK_ERROR_20216] = "The parameter value is illegal tag: 77";
  SSStockErrorMsg[SS_STOCK_ERROR_20218] = "The parameter value is illegal tag: 8541";
  SSStockErrorMsg[SS_STOCK_ERROR_20220] = "The parameter value is illegal tag: 963";
  SSStockErrorMsg[SS_STOCK_ERROR_20224] = "The parameter value is illegal tag: 1187";
  SSStockErrorMsg[SS_STOCK_ERROR_20226] = "The parameter value is illegal tag: 1365";
  SSStockErrorMsg[SS_STOCK_ERROR_20228] = "The parameter value is illegal tag: 1443";
  SSStockErrorMsg[SS_STOCK_ERROR_20230] = "The parameter value is illegal tag: 1362";
  SSStockErrorMsg[SS_STOCK_ERROR_20232] = "The parameter value is illegal tag: 8506";
  SSStockErrorMsg[SS_STOCK_ERROR_20234] = "The parameter value is illegal tag: 747";
  SSStockErrorMsg[SS_STOCK_ERROR_20236] = "The parameter value is illegal tag: 1635";
  SSStockErrorMsg[SS_STOCK_ERROR_20238] = "The parameter value is illegal tag: 1643";
  SSStockErrorMsg[SS_STOCK_ERROR_20240] = "The parameter value is illegal tag: 1645";
  SSStockErrorMsg[SS_STOCK_ERROR_20242] = "The parameter value is illegal tag: 1644";
  SSStockErrorMsg[SS_STOCK_ERROR_20244] = "The STEP template is missing the msg type";
  SSStockErrorMsg[SS_STOCK_ERROR_20246] = "The STEP template is missing a separator at the end";
  SSStockErrorMsg[SS_STOCK_ERROR_20248] = "The value of the STEP field tag is a NULL string";
  SSStockErrorMsg[SS_STOCK_ERROR_20250] = "The STEP field tag is not recognized";
  SSStockErrorMsg[SS_STOCK_ERROR_20252] = "STEP field There is an extra space before the equal sign";
  SSStockErrorMsg[SS_STOCK_ERROR_20254] = "The STEP field does not conform to the key-value format";
  SSStockErrorMsg[SS_STOCK_ERROR_20256] = "The number of STEP template tags is different from the configuration";
  SSStockErrorMsg[SS_STOCK_ERROR_20258] = "STEP templates do not allow ending separators";
  SSStockErrorMsg[SS_STOCK_ERROR_20260] = "The parameter value is illegal tag: 198";
  SSStockErrorMsg[SS_STOCK_ERROR_20262] = "The parameter value is illegal tag: 555";
  SSStockErrorMsg[SS_STOCK_ERROR_20264] = "The parameter value is illegal tag: 602";
  SSStockErrorMsg[SS_STOCK_ERROR_20266] = "The parameter value is illegal tag: 624";
  SSStockErrorMsg[SS_STOCK_ERROR_20268] = "The parameter value is illegal tag: 685";
  SSStockErrorMsg[SS_STOCK_ERROR_20270] = "The parameter value is illegal tag: 131";
  SSStockErrorMsg[SS_STOCK_ERROR_20272] = "The parameter value is illegal tag: 1166";
  SSStockErrorMsg[SS_STOCK_ERROR_20274] = "The parameter value is illegal tag: 132";
  SSStockErrorMsg[SS_STOCK_ERROR_20276] = "The parameter value is illegal tag: 133";
  SSStockErrorMsg[SS_STOCK_ERROR_20278] = "The parameter value is illegal tag: 134";
  SSStockErrorMsg[SS_STOCK_ERROR_20280] = "The parameter value is illegal tag: 135";
  SSStockErrorMsg[SS_STOCK_ERROR_20282] = "The parameter value is illegal tag: 300";
  SSStockErrorMsg[SS_STOCK_ERROR_20284] = "The parameter value is illegal tag: 8909";
  SSStockErrorMsg[SS_STOCK_ERROR_20286] = "The parameter value is illegal tag: 8910";
  SSStockErrorMsg[SS_STOCK_ERROR_20288] = "The starting message sequence number";
  SSStockErrorMsg[SS_STOCK_ERROR_20290] = "Cumulative number of executions";
  SSStockErrorMsg[SS_STOCK_ERROR_20292] = "The maximum sequence number of the current message";
  SSStockErrorMsg[SS_STOCK_ERROR_20294] = "Source of the security symbol 101=SH Stock Exchange 103=XG Stock Exchange";
  SSStockErrorMsg[SS_STOCK_ERROR_20296] = "The order is valid for the time type, ExecType=0/4/8";
  SSStockErrorMsg[SS_STOCK_ERROR_20298] = "The order cancelled is valid when ExecType=4";
  SSStockErrorMsg[SS_STOCK_ERROR_20300] = "Data synchronization type  SO=SyncOrder, which synchronizes the delegate data  SR=SyncReport, which synchronizes the report data";
  SSStockErrorMsg[SS_STOCK_ERROR_20302] = "The amount of the order";
  SSStockErrorMsg[SS_STOCK_ERROR_20304] = "The order owner type, the following values: 1 = Individual Investor 103 = Institutional Investors 104 = Proprietary trading";
  SSStockErrorMsg[SS_STOCK_ERROR_20306] = "Credit label, filled in during credit transaction, value: XY=collateral trading, RZ=margin transaction, PC=liquidation transaction";
  SSStockErrorMsg[SS_STOCK_ERROR_20308] = "Business Type: 600020 = Fund Connect Business Transaction Order Declaration;600021 = Fund Connect Business Transfer-in and Transfer-out Order Declaration";
  SSStockErrorMsg[SS_STOCK_ERROR_20310] = "The message record number 1) Delegated messages, which are assigned a number by the SSE cross-border gateway 2) Return messages, which are assigned by overseas OMS";
  SSStockErrorMsg[SS_STOCK_ERROR_20312] = "Explanation of the reason for rejection";
  SSStockErrorMsg[SS_STOCK_ERROR_20314] = "The message record number of the application layer";
  SSStockErrorMsg[SS_STOCK_ERROR_20316] = "For new sessions, fill in 1; otherwise, set to the maximum ApplSeqNum+1 received";
  SSStockErrorMsg[SS_STOCK_ERROR_20318] = "The time when the order is declared, ExecType=F";
  SSStockErrorMsg[SS_STOCK_ERROR_20320] = "Transaction amount, valid when ExecType=F";
  SSStockErrorMsg[SS_STOCK_ERROR_20322] = "Log in to the PBU";
  SSStockErrorMsg[SS_STOCK_ERROR_20324] = "Number of PBUs that are logged in";
  SSStockErrorMsg[SS_STOCK_ERROR_20326] = "The starting sequence number of the partition execution report";
  SSStockErrorMsg[SS_STOCK_ERROR_20328] = "The maximum sequence number of the partition execution report";
  SSStockErrorMsg[SS_STOCK_ERROR_20330] = "The number of the executive report, which is incremented sequentially from 1";
  SSStockErrorMsg[SS_STOCK_ERROR_20332] = "PlatformIDentity";
  SSStockErrorMsg[SS_STOCK_ERROR_20334] = "Platform Status: 0 = NotOpen, not open 1 = PreOpen 2 = Open 3 = Break, pause 4 = Close, closed";
  SSStockErrorMsg[SS_STOCK_ERROR_20336] = "The number of partitions within the platform";
  SSStockErrorMsg[SS_STOCK_ERROR_20338] = "The zone number within the platform";
  SSStockErrorMsg[SS_STOCK_ERROR_20340] = "The parameter value is illegal tag: 1671";
  SSStockErrorMsg[SS_STOCK_ERROR_20342] = "The parameter value is illegal tag: 1691";
  SSStockErrorMsg[SS_STOCK_ERROR_20344] = "The parameter value is illegal tag:1693";
  SSStockErrorMsg[SS_STOCK_ERROR_20346] = "The parameter value is illegal tag: 124";
  SSStockErrorMsg[SS_STOCK_ERROR_20350] = "The QuoteType field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20352] = "The PreTradeAnonymity field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20354] = "The ValidUntilTime field is incorrect";
  SSStockErrorMsg[SS_STOCK_ERROR_20356] = "QuoteReqId field validation error";
  SSStockErrorMsg[SS_STOCK_ERROR_30000] = "UNRECOGNISED";
  SSStockErrorMsg[SS_STOCK_ERROR_30002] = "2025 Broker firm has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30004] = "2021 Trader ' M<999> ' of broker firm ' M<99999> ' has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30006] = "2026 Broker number has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30008] = "2221 Sign On not possible - all brokers suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30010] = "2023 Security ' M<ZZZZ9> ' has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30012] = "2033 Function suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30014] = "2154 Market group suspended for the broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30016] = "2228 Monitor user ' M<999> ' suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30018] = "Invalid Security Code";
  SSStockErrorMsg[SS_STOCK_ERROR_30020] = "Invalid Price";
  SSStockErrorMsg[SS_STOCK_ERROR_30022] = "Invalid Quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30024] = "Invalid Order Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30026] = "Invalid All or Nothing Indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30028] = "Invalid Reference/Comment";
  SSStockErrorMsg[SS_STOCK_ERROR_30030] = "Invalid Trade Classification - Short sell";
  SSStockErrorMsg[SS_STOCK_ERROR_30032] = "Invalid Trade Classification - Origin";
  SSStockErrorMsg[SS_STOCK_ERROR_30034] = "Invalid Trade Classification - Hedge";
  SSStockErrorMsg[SS_STOCK_ERROR_30036] = "Invalid Market Code";
  SSStockErrorMsg[SS_STOCK_ERROR_30038] = "Invalid Include Filled Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30040] = "Invalid Include Trades Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30042] = "Invalid Time";
  SSStockErrorMsg[SS_STOCK_ERROR_30044] = "Invalid Side";
  SSStockErrorMsg[SS_STOCK_ERROR_30046] = "Invalid All Stocks Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30048] = "Invalid Correspondent Broker Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30050] = "Invalid Direct Indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30052] = "Invalid Settlement Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30054] = "Invalid Overseas Indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30056] = "Invalid Print Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30058] = "Invalid Page Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30060] = "Invalid TraderID";
  SSStockErrorMsg[SS_STOCK_ERROR_30062] = "Invalid Password";
  SSStockErrorMsg[SS_STOCK_ERROR_30064] = "Invalid Bid/Ask Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30066] = "Invalid Order Sequence Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30068] = "Invalid Bulk Cancel Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30070] = "Invalid Permanent Sign Off Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30072] = "Invalid Change Settings Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30074] = "Invalid Default Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30076] = "Invalid Trade Ticker Threshold";
  SSStockErrorMsg[SS_STOCK_ERROR_30078] = "Invalid Consideration Threshold";
  SSStockErrorMsg[SS_STOCK_ERROR_30080] = "Invalid Standard Colour Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30082] = "Invalid Main Background Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30084] = "Invalid Secondary Background Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30086] = "Invalid Bid Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30088] = "Invalid Invalid Ask Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30090] = "Invalid High Price Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30092] = "Invalid Low Price Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30094] = "Invalid Message Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30096] = "Invalid Other Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30098] = "Invalid Monitor UserID";
  SSStockErrorMsg[SS_STOCK_ERROR_30100] = "Invalid Smart Card Invalid Broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30102] = "Invalid Invalid System State";
  SSStockErrorMsg[SS_STOCK_ERROR_30104] = "Invalid Disable Audible Alarm Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30106] = "Invalid Trade Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30108] = "Invalid Confirmation Trade Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30110] = "Invalid Bid Price";
  SSStockErrorMsg[SS_STOCK_ERROR_30112] = "Invalid Ask Price";
  SSStockErrorMsg[SS_STOCK_ERROR_30114] = "Invalid Bid Quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30116] = "Invalid Ask Quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30118] = "Invalid BS Order Reference Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30120] = "Invalid BS Transaction Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30122] = "Invalid Cancel/Reduce Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30124] = "Invalid Confirmation Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30126] = "Invalid Ethernet Address";
  SSStockErrorMsg[SS_STOCK_ERROR_30128] = "Invalid News ItemID";
  SSStockErrorMsg[SS_STOCK_ERROR_30130] = "Invalid News SystemID";
  SSStockErrorMsg[SS_STOCK_ERROR_30132] = "Invalid Number of Items";
  SSStockErrorMsg[SS_STOCK_ERROR_30134] = "Invalid Software Version Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30136] = "Invalid BS Trade Reference Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30138] = "Invalid Trade Sequence Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30140] = "Invalid ORS Transaction Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30142] = "Invalid Message Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30144] = "Invalid Audible Alarm (not used by BSS)";
  SSStockErrorMsg[SS_STOCK_ERROR_30146] = "Invalid Auto printing";
  SSStockErrorMsg[SS_STOCK_ERROR_30148] = "Invalid No of Spreads";
  SSStockErrorMsg[SS_STOCK_ERROR_30150] = "9064 Invalid Device";
  SSStockErrorMsg[SS_STOCK_ERROR_30152] = "2035 Invalid stock";
  SSStockErrorMsg[SS_STOCK_ERROR_30154] = "2227 Cancellation not accepted - quote not outstanding";
  SSStockErrorMsg[SS_STOCK_ERROR_30156] = "2057 Invalid USM Sequence Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30158] = "2091 Invalid I/B";
  SSStockErrorMsg[SS_STOCK_ERROR_30160] = "2115 Invalid consideration threshold";
  SSStockErrorMsg[SS_STOCK_ERROR_30162] = "4019 Invalid message length";
  SSStockErrorMsg[SS_STOCK_ERROR_30164] = "4020 Invalid MessageID";
  SSStockErrorMsg[SS_STOCK_ERROR_30166] = "4021 Invalid SenderID";
  SSStockErrorMsg[SS_STOCK_ERROR_30168] = "4022 Invalid ReceiverID";
  SSStockErrorMsg[SS_STOCK_ERROR_30170] = "4003 Invalid Message Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30172] = "4025 Invalid security trailer";
  SSStockErrorMsg[SS_STOCK_ERROR_30174] = "4027 Invalid BS DeviceID";
  SSStockErrorMsg[SS_STOCK_ERROR_30176] = "4029 Invalid Device Availability";
  SSStockErrorMsg[SS_STOCK_ERROR_30178] = "4002 Invalid Market Group";
  SSStockErrorMsg[SS_STOCK_ERROR_30180] = "4037 Invalid Download Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30182] = "4043 Invalid Loop/Array Count";
  SSStockErrorMsg[SS_STOCK_ERROR_30184] = "9025 Illegal recovery sequence number received by Host";
  SSStockErrorMsg[SS_STOCK_ERROR_30186] = "2195 Invalid bid/ask indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30188] = "9063 Invalid trade side";
  SSStockErrorMsg[SS_STOCK_ERROR_30190] = "4008 Invalid transaction for non-RT Broker Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30192] = "4009 Invalid transaction for RT Broker Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30194] = "2208 Invalid orderID";
  SSStockErrorMsg[SS_STOCK_ERROR_30196] = "2426 Invalid Order Side";
  SSStockErrorMsg[SS_STOCK_ERROR_30198] = "2421 Invalid Basket Index code";
  SSStockErrorMsg[SS_STOCK_ERROR_30200] = "2219 Invalid log-off type";
  SSStockErrorMsg[SS_STOCK_ERROR_30202] = "2129 Invalid function";
  SSStockErrorMsg[SS_STOCK_ERROR_30204] = "2192 Invalid authorising trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30206] = "2194 Invalid stock code";
  SSStockErrorMsg[SS_STOCK_ERROR_30208] = "2196 Invalid include filled indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30210] = "9071 Include Last Key Flag must be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_30212] = "9052 Trade Indicator must be M L R or V";
  SSStockErrorMsg[SS_STOCK_ERROR_30214] = "2124 Maximum order size exceeded";
  SSStockErrorMsg[SS_STOCK_ERROR_30216] = "9039 Cancel flag must be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_30218] = "4000 Invitation Number invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_30220] = "9069 Illegal recovery sequence number received by Host";
  SSStockErrorMsg[SS_STOCK_ERROR_30222] = "Missing Security Code";
  SSStockErrorMsg[SS_STOCK_ERROR_30224] = "Missing Price";
  SSStockErrorMsg[SS_STOCK_ERROR_30226] = "Missing Quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30228] = "Missing Order Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30230] = "Missing All or Nothing Indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30232] = "Missing Reference/Comment";
  SSStockErrorMsg[SS_STOCK_ERROR_30234] = "Missing Trade Classification - Short sell";
  SSStockErrorMsg[SS_STOCK_ERROR_30236] = "Missing Trade Classification - Origin";
  SSStockErrorMsg[SS_STOCK_ERROR_30238] = "Missing Trade Classification - Hedge";
  SSStockErrorMsg[SS_STOCK_ERROR_30240] = "Missing Market Code";
  SSStockErrorMsg[SS_STOCK_ERROR_30242] = "Missing Include Filled Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30244] = "Missing Include Trades Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30246] = "Missing Time";
  SSStockErrorMsg[SS_STOCK_ERROR_30248] = "Missing Side";
  SSStockErrorMsg[SS_STOCK_ERROR_30250] = "Missing All Stocks Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30252] = "Missing Correspondent Broker Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30254] = "Missing Direct Indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30256] = "Missing Settlement Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30258] = "Missing Overseas Indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30260] = "Missing Print Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30262] = "Missing Page Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30264] = "Missing TraderID";
  SSStockErrorMsg[SS_STOCK_ERROR_30266] = "Missing Password";
  SSStockErrorMsg[SS_STOCK_ERROR_30268] = "Missing Bid/Ask Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30270] = "Missing Order Sequence Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30272] = "Missing Bulk Cancel Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30274] = "Missing Permanent Sign Off Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30276] = "Missing Change Settings Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30278] = "Missing Default Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30280] = "Missing Trade Ticker Threshold";
  SSStockErrorMsg[SS_STOCK_ERROR_30282] = "Missing Consideration Threshold";
  SSStockErrorMsg[SS_STOCK_ERROR_30284] = "Missing Standard Colour Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30286] = "Missing Main Background Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30288] = "Missing Secondary Background Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30290] = "Missing Bid Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30292] = "Missing Ask Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30294] = "Missing High Price Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30296] = "Missing Low Price Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30298] = "Missing Message Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30300] = "Missing Other Colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30302] = "Missing Monitor UserID";
  SSStockErrorMsg[SS_STOCK_ERROR_30304] = "Missing Smart Card MISSING Broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30306] = "Missing MISSING System State";
  SSStockErrorMsg[SS_STOCK_ERROR_30308] = "Missing Disable Audible Alarm Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30310] = "Missing Trade Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30312] = "Missing Confirmation Trade Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30314] = "Missing Bid Price";
  SSStockErrorMsg[SS_STOCK_ERROR_30316] = "Missing Ask Price";
  SSStockErrorMsg[SS_STOCK_ERROR_30318] = "Missing Bid Quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30320] = "Missing Ask Quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30322] = "Missing BS Order Reference Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30324] = "Missing BS Transaction Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30326] = "Missing Cancel/Reduce Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30328] = "Missing Confirmation Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30330] = "Missing Ethernet Address";
  SSStockErrorMsg[SS_STOCK_ERROR_30332] = "Missing News ItemID";
  SSStockErrorMsg[SS_STOCK_ERROR_30334] = "Missing News SystemID";
  SSStockErrorMsg[SS_STOCK_ERROR_30336] = "Missing Number of Items";
  SSStockErrorMsg[SS_STOCK_ERROR_30338] = "Missing Software Version Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30340] = "Missing BS Trade Reference Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30342] = "Missing Trade Sequence Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30344] = "Missing ORS Transaction Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30346] = "Missing Message Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30348] = "Missing Audible Alarm (not used by BSS)";
  SSStockErrorMsg[SS_STOCK_ERROR_30350] = "Missing Auto printing";
  SSStockErrorMsg[SS_STOCK_ERROR_30352] = "Missing No of Spreads";
  SSStockErrorMsg[SS_STOCK_ERROR_30354] = "2039 If price is input then stock must also be input";
  SSStockErrorMsg[SS_STOCK_ERROR_30356] = "9065 Bid must be specified before ask for quotes";
  SSStockErrorMsg[SS_STOCK_ERROR_30358] = "2187 Bid side missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30360] = "2188 Ask side missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30362] = "4010 Message translation error - mandatory field missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30364] = "9040 Order not found";
  SSStockErrorMsg[SS_STOCK_ERROR_30366] = "9008 AMS system not available";
  SSStockErrorMsg[SS_STOCK_ERROR_30368] = "4013 Host not available";
  SSStockErrorMsg[SS_STOCK_ERROR_30370] = "4016 Requested data not available";
  SSStockErrorMsg[SS_STOCK_ERROR_30372] = "4017 BS-Host tunnel blocked";
  SSStockErrorMsg[SS_STOCK_ERROR_30374] = "2076 Broker number does not match the order";
  SSStockErrorMsg[SS_STOCK_ERROR_30376] = "2160 Corr broker must be for a different broker firm";
  SSStockErrorMsg[SS_STOCK_ERROR_30378] = "2223 Broker must be associated with device";
  SSStockErrorMsg[SS_STOCK_ERROR_30380] = "2158 Target Broker must be different from requesting Broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30382] = "2213 Broker must be assigned to the specified Security";
  SSStockErrorMsg[SS_STOCK_ERROR_30384] = "9048 Security does not belong to the specified market";
  SSStockErrorMsg[SS_STOCK_ERROR_30386] = "2119 Broker firm is not eligible for short-selling";
  SSStockErrorMsg[SS_STOCK_ERROR_30388] = "2120 Stock is not eligible for short-selling";
  SSStockErrorMsg[SS_STOCK_ERROR_30390] = "4024 Invalid MessageID for receiverID";
  SSStockErrorMsg[SS_STOCK_ERROR_30392] = "2162 Direct and OS cannot both be Y";
  SSStockErrorMsg[SS_STOCK_ERROR_30394] = "2201 OrderID does not match stock code";
  SSStockErrorMsg[SS_STOCK_ERROR_30396] = "2214 Trader not registered with the broker firm";
  SSStockErrorMsg[SS_STOCK_ERROR_30398] = "4007 Invitation Market Group mismatch with specified Market";
  SSStockErrorMsg[SS_STOCK_ERROR_30400] = "9043 Trade already rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30402] = "9044 Sale already rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30404] = "9045 Purchase already rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30406] = "2070 Corr broker is signed off";
  SSStockErrorMsg[SS_STOCK_ERROR_30408] = "2401 Trader not signed on";
  SSStockErrorMsg[SS_STOCK_ERROR_30410] = "3043 Market xxxxx not yet open";
  SSStockErrorMsg[SS_STOCK_ERROR_30412] = "3024 xxxxx market is ON HOLD";
  SSStockErrorMsg[SS_STOCK_ERROR_30414] = "2145 Order cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_30416] = "2126 Queue full at this price for the Security";
  SSStockErrorMsg[SS_STOCK_ERROR_30418] = "2125 Maximum permitted orders reached";
  SSStockErrorMsg[SS_STOCK_ERROR_30420] = "2053 Price must be zero for At Auction order type";
  SSStockErrorMsg[SS_STOCK_ERROR_30422] = "2054 Function not allowed for current trading status";
  SSStockErrorMsg[SS_STOCK_ERROR_30424] = "2056 All or Nothing must be null";
  SSStockErrorMsg[SS_STOCK_ERROR_30426] = "2059 Security Code must be blank when market is present";
  SSStockErrorMsg[SS_STOCK_ERROR_30428] = "2061 Broker not eligible for Market";
  SSStockErrorMsg[SS_STOCK_ERROR_30430] = "2064 Price not on spread";
  SSStockErrorMsg[SS_STOCK_ERROR_30432] = "2075 Shortselling not allowed for odd lot orders";
  SSStockErrorMsg[SS_STOCK_ERROR_30434] = "2085 Trade cannot be rejected - direct trade";
  SSStockErrorMsg[SS_STOCK_ERROR_30436] = "2094 Security code must not be blank if price is present";
  SSStockErrorMsg[SS_STOCK_ERROR_30438] = "2098 I/B must be blank for overseas and direct trades";
  SSStockErrorMsg[SS_STOCK_ERROR_30440] = "2099 OS must be N for manual special and odd lot trades";
  SSStockErrorMsg[SS_STOCK_ERROR_30442] = "2103 Trader ' M<999> ' is already signed on at another broker number";
  SSStockErrorMsg[SS_STOCK_ERROR_30444] = "2112 All colours except message colour must be different";
  SSStockErrorMsg[SS_STOCK_ERROR_30446] = "2113 Message colour cannot be the same as a background colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30448] = "2118 Shortsell must be blank";
  SSStockErrorMsg[SS_STOCK_ERROR_30450] = "2121 Quantity not required for manually traded Stock";
  SSStockErrorMsg[SS_STOCK_ERROR_30452] = "2123 Order already exists";
  SSStockErrorMsg[SS_STOCK_ERROR_30454] = "9999 System software error";
  SSStockErrorMsg[SS_STOCK_ERROR_30456] = "9998 System busy - message rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30458] = "9077 Order sequence number length has exceeded the BS limit. Request cannot be accepted";
  SSStockErrorMsg[SS_STOCK_ERROR_30460] = "9076 Host rejected BS message";
  SSStockErrorMsg[SS_STOCK_ERROR_30462] = "9075 Possible Duplicate BS message received";
  SSStockErrorMsg[SS_STOCK_ERROR_30464] = "9074 Basket contains duplicate Security";
  SSStockErrorMsg[SS_STOCK_ERROR_30466] = "9073 Basket contains duplicate Message-reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30468] = "9072 Device details unavailable due to Global node failover";
  SSStockErrorMsg[SS_STOCK_ERROR_30470] = "9066 Non-active Host cannot process recoveries";
  SSStockErrorMsg[SS_STOCK_ERROR_30472] = "9062 Node not active";
  SSStockErrorMsg[SS_STOCK_ERROR_30474] = "9054 Incomplete last order key";
  SSStockErrorMsg[SS_STOCK_ERROR_30476] = "9055 Incomplete last trade key";
  SSStockErrorMsg[SS_STOCK_ERROR_30478] = "2400 Price of ' M<ZZZ9> ' is' M<ZZ9.99> '% > previous close";
  SSStockErrorMsg[SS_STOCK_ERROR_30480] = "9038 Order cancellation not accepted - order not outstanding";
  SSStockErrorMsg[SS_STOCK_ERROR_30482] = "9042 Only one broker must be specified";
  SSStockErrorMsg[SS_STOCK_ERROR_30484] = "2065 Price warning please re-type";
  SSStockErrorMsg[SS_STOCK_ERROR_30486] = "2127 Consideration Warning please re-type price & quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30488] = "2088 Please press ENTER and CONFIRM";
  SSStockErrorMsg[SS_STOCK_ERROR_30490] = "2104 Enter either Y or N here";
  SSStockErrorMsg[SS_STOCK_ERROR_30492] = "2109 System not ready - pls re-try later";
  SSStockErrorMsg[SS_STOCK_ERROR_30494] = "2134 Could not fulfill All or Nothing order";
  SSStockErrorMsg[SS_STOCK_ERROR_30496] = "EzEI login fail with tcp connect fail";
  SSStockErrorMsg[SS_STOCK_ERROR_30498] = "EzEI login with invitation error";
  SSStockErrorMsg[SS_STOCK_ERROR_30500] = "Invalide New Password";
  SSStockErrorMsg[SS_STOCK_ERROR_30502] = "Invalide Disable Auto Printing";
  SSStockErrorMsg[SS_STOCK_ERROR_30504] = "Invalide Smart Card Serial Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30506] = "Invalide Smart Card Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30508] = "Invalide Inputting Broker Number (e.g. the broker number in the message header)";
  SSStockErrorMsg[SS_STOCK_ERROR_30510] = "Missing New Password";
  SSStockErrorMsg[SS_STOCK_ERROR_30512] = "Missing Disable Auto Printing";
  SSStockErrorMsg[SS_STOCK_ERROR_30514] = "Missing Smart Card Serial Number";
  SSStockErrorMsg[SS_STOCK_ERROR_30516] = "Missing Smart Card Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30518] = "Inputting Broker Number (e.g. the broker number in the message header)";
  SSStockErrorMsg[SS_STOCK_ERROR_30520] = "2001 Signed off - broker number suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30522] = "2002 Signed off - trader suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30524] = "2003 Broker number activated";
  SSStockErrorMsg[SS_STOCK_ERROR_30526] = "2004 Broker ' M<9999> ' has been activated";
  SSStockErrorMsg[SS_STOCK_ERROR_30528] = "2005 Broker ' M<9999> ' has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30530] = "2006 Smart Card is currently suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30532] = "2017 Signed off by the Exchange";
  SSStockErrorMsg[SS_STOCK_ERROR_30534] = "2018 Broker firm ' M<99999> ' has been activated";
  SSStockErrorMsg[SS_STOCK_ERROR_30536] = "2019 Broker firm ' M<99999> ' has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30538] = "2020 Trader ' M<999> ' of broker firm ' M<99999> ' has been activated";
  SSStockErrorMsg[SS_STOCK_ERROR_30540] = "2022 Security ' M<ZZZZ9> ' has been re-activated";
  SSStockErrorMsg[SS_STOCK_ERROR_30542] = "2024 Signed off - broker firm suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30544] = "2027 Trader ' M<999> ' has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30546] = "2031 Correspondent Broker permanently signed off";
  SSStockErrorMsg[SS_STOCK_ERROR_30548] = "2032 Broker not signed on by the specified Trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30550] = "2036 Security suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30552] = "2037 Price missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30554] = "2038 Invalid price";
  SSStockErrorMsg[SS_STOCK_ERROR_30556] = "2041 Cnfm trader cannot be the same as the current trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30558] = "2042 Correspondent Broker suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30560] = "2043 Invalid order price";
  SSStockErrorMsg[SS_STOCK_ERROR_30562] = "2044 New password cannot be the same as recent password(s)";
  SSStockErrorMsg[SS_STOCK_ERROR_30564] = "2045 Invalid password - must be at least 6 characters";
  SSStockErrorMsg[SS_STOCK_ERROR_30566] = "2052 Broker must not be registered trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30568] = "2055 Trader not signed on the specified Broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30570] = "2060 Invalid trade price";
  SSStockErrorMsg[SS_STOCK_ERROR_30572] = "2062 Broker must be registered trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30574] = "2067 Invalid quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30576] = "2068 Quantity missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30578] = "2069 Broker submitting the message does not exist";
  SSStockErrorMsg[SS_STOCK_ERROR_30580] = "2071 This broker number is suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30582] = "2072 Authorising trader has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30584] = "2073 Broker firm has been suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30586] = "2074 Invalid Broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30588] = "2077 Order cannot be cancelled from this broker number";
  SSStockErrorMsg[SS_STOCK_ERROR_30590] = "2078 Broker firm of correspondent broker suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30592] = "2081 Warning! Price ' M<ZZ9> ' S from nominal. Please check";
  SSStockErrorMsg[SS_STOCK_ERROR_30594] = "2082 Warning! Price ' M<ZZ9> ' S from nominal. Check again";
  SSStockErrorMsg[SS_STOCK_ERROR_30596] = "2083 Warning! Price ' M<ZZ9> ' S from Alarm nominal. Please check";
  SSStockErrorMsg[SS_STOCK_ERROR_30598] = "2084 Warning! Price ' M<ZZ9> ' S from Alarm nominal. Check again";
  SSStockErrorMsg[SS_STOCK_ERROR_30600] = "2086 Price ' M<ZZ9> ' S from nominal. 2nd traderID/password reqd";
  SSStockErrorMsg[SS_STOCK_ERROR_30602] = "2087 Price ' M<ZZ9> ' S from alarm nom. 2nd trderID/password reqd";
  SSStockErrorMsg[SS_STOCK_ERROR_30604] = "2089 Trade cannot be rejected - invalid trade type";
  SSStockErrorMsg[SS_STOCK_ERROR_30606] = "2090 Invalid time";
  SSStockErrorMsg[SS_STOCK_ERROR_30608] = "2093 Trade cannot be modified from this broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30610] = "2095 ORS details does not match the submitted order details";
  SSStockErrorMsg[SS_STOCK_ERROR_30612] = "2096 Page number not found";
  SSStockErrorMsg[SS_STOCK_ERROR_30614] = "2097 Invalid page number";
  SSStockErrorMsg[SS_STOCK_ERROR_30616] = "2101 Invalid password";
  SSStockErrorMsg[SS_STOCK_ERROR_30618] = "2102 Trader ' M<999> ' suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30620] = "2105 Invalid trader/password";
  SSStockErrorMsg[SS_STOCK_ERROR_30622] = "2107 User ' M<99999> M<999> ' failed to sign on at broker ' M<9999> ' - incorrect password";
  SSStockErrorMsg[SS_STOCK_ERROR_30624] = "2108 User ' M<99999> M<999> ' failed to sign on at broker ' M<9999> ' - un-authorised trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30626] = "2111 Invalid colour";
  SSStockErrorMsg[SS_STOCK_ERROR_30628] = "2116 Invalid Shortsell";
  SSStockErrorMsg[SS_STOCK_ERROR_30630] = "2122 Order at existing price only";
  SSStockErrorMsg[SS_STOCK_ERROR_30632] = "2128 Consideration Warning please press enter and confirm";
  SSStockErrorMsg[SS_STOCK_ERROR_30634] = "2130' M<99:99> X M<ZZZ9> X A X A9 X M<ZZ ZZZ ZZ9> 'filled' M<ZZ ZZZ ZZ9> O/S ref A10";
  SSStockErrorMsg[SS_STOCK_ERROR_30636] = "2131 Residual special limit order rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30638] = "2132 Log-off type must be permanent for Open Gateway";
  SSStockErrorMsg[SS_STOCK_ERROR_30640] = "2133 Order type not permitted in the current trading status";
  SSStockErrorMsg[SS_STOCK_ERROR_30642] = "2135 Residual order rejected - price invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_30644] = "2136 Residual At Auction order rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30646] = "2137 <<no text message>>";
  SSStockErrorMsg[SS_STOCK_ERROR_30648] = "2138 Invalid Market Code";
  SSStockErrorMsg[SS_STOCK_ERROR_30650] = "2139 All or Nothing flag must be N";
  SSStockErrorMsg[SS_STOCK_ERROR_30652] = "2141 Quantity is not a multiple of board lot";
  SSStockErrorMsg[SS_STOCK_ERROR_30654] = "2143 Quantity must not equal to 1 board lot";
  SSStockErrorMsg[SS_STOCK_ERROR_30656] = "2144 Short-selling is not allowed for this type of trade";
  SSStockErrorMsg[SS_STOCK_ERROR_30658] = "2146 Settlement type must be blank for direct trade";
  SSStockErrorMsg[SS_STOCK_ERROR_30660] = "2147 Invalid Settlement type for non-direct trade";
  SSStockErrorMsg[SS_STOCK_ERROR_30662] = "2148 Cannot select a manually traded Stock";
  SSStockErrorMsg[SS_STOCK_ERROR_30664] = "2149 Bulk cancel completed with' M<ZZ9> ' orders cancelled";
  SSStockErrorMsg[SS_STOCK_ERROR_30666] = "2151 Market Code must be blank when Security is present";
  SSStockErrorMsg[SS_STOCK_ERROR_30668] = "2152 Transaction not allowed - cross broker functions not enabled";
  SSStockErrorMsg[SS_STOCK_ERROR_30670] = "2153 Market group of security not assigned to broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30672] = "2155 Broker not signed on";
  SSStockErrorMsg[SS_STOCK_ERROR_30674] = "2156 Broker must belong to the same broker firm";
  SSStockErrorMsg[SS_STOCK_ERROR_30676] = "2157 Only pre-open trades are allowed";
  SSStockErrorMsg[SS_STOCK_ERROR_30678] = "2159 Target Broker must not be assigned to the same Device";
  SSStockErrorMsg[SS_STOCK_ERROR_30680] = "2161 Corr broker must be blank for direct or overseas trades";
  SSStockErrorMsg[SS_STOCK_ERROR_30682] = "2163 ORS details missing from the original Order";
  SSStockErrorMsg[SS_STOCK_ERROR_30684] = "2164 Shortsell not allowed for the current trading session";
  SSStockErrorMsg[SS_STOCK_ERROR_30686] = "2167 Trade cannot be rejected from this broker number";
  SSStockErrorMsg[SS_STOCK_ERROR_30688] = "2168 Purchase already rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30690] = "2169 Purchase not in same session";
  SSStockErrorMsg[SS_STOCK_ERROR_30692] = "2170 Sale already rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30694] = "2171 Trade already rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_30696] = "2172 Trader must not be a Cross Trading Device Authoriser";
  SSStockErrorMsg[SS_STOCK_ERROR_30698] = "2173 ORS details missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30700] = "2174 Authoriser must be a cross trading device authoriser";
  SSStockErrorMsg[SS_STOCK_ERROR_30702] = "2175 Broker not eligible for the specified Security";
  SSStockErrorMsg[SS_STOCK_ERROR_30704] = "2176 Quantity must be less than one board lot";
  SSStockErrorMsg[SS_STOCK_ERROR_30706] = "2177 Quantity must be a multiple of ' M<ZZZ ZZZ ZZ9>";
  SSStockErrorMsg[SS_STOCK_ERROR_30708] = "2183 Order cancellation not accepted - order not outstanding";
  SSStockErrorMsg[SS_STOCK_ERROR_30710] = "2185 Wrong order type - semi-automatic matching not accepted";
  SSStockErrorMsg[SS_STOCK_ERROR_30712] = "2186 Order not found";
  SSStockErrorMsg[SS_STOCK_ERROR_30714] = "2189 Org Broker must be assigned to all Mkt Grps of req Broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30716] = "2193 Invalid authorising trader password";
  SSStockErrorMsg[SS_STOCK_ERROR_30718] = "2199 Invalid bulk cancel indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30720] = "2200 Signed off - cross trading device cancel by ' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_30722] = "2202 No orders cancelled for ' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_30724] = "2203 Single order cancel requires blank bid/ask indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30726] = "2204 Bulk cancel requires blank orderID";
  SSStockErrorMsg[SS_STOCK_ERROR_30728] = "2205' M<ZZZ9> ' orders cancelled for broker ' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_30730] = "2206' M<ZZZ9> ' Orders & ' M<ZZ9> ' Sp/odd lot orders cancelled for broker' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_30732] = "2207 Must not be same as sign on trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30734] = "2209 Quote request not allowed in current trading session";
  SSStockErrorMsg[SS_STOCK_ERROR_30736] = "2210 Must be automatch security";
  SSStockErrorMsg[SS_STOCK_ERROR_30738] = "2211 Must be non-automatch security";
  SSStockErrorMsg[SS_STOCK_ERROR_30740] = "2212 Quantity must be less than original order quantity";
  SSStockErrorMsg[SS_STOCK_ERROR_30742] = "2215 Broker permanently signed off";
  SSStockErrorMsg[SS_STOCK_ERROR_30744] = "2216 Order modification not accepted - order not outstanding";
  SSStockErrorMsg[SS_STOCK_ERROR_30746] = "2217 Quantity must not be multiple of board lot";
  SSStockErrorMsg[SS_STOCK_ERROR_30748] = "2220 Trader must belong to the same broker firm as device";
  SSStockErrorMsg[SS_STOCK_ERROR_30750] = "2222 Quote Request not allowed - RT monitor cut-off time not reached";
  SSStockErrorMsg[SS_STOCK_ERROR_30752] = "2224 If security is present trade sequence number must be present";
  SSStockErrorMsg[SS_STOCK_ERROR_30754] = "2225 Bid side quote price must be less than ask side quote price";
  SSStockErrorMsg[SS_STOCK_ERROR_30756] = "2229 Smart card has expired";
  SSStockErrorMsg[SS_STOCK_ERROR_30758] = "2230 Smart card invalid for device";
  SSStockErrorMsg[SS_STOCK_ERROR_30760] = "2231 ORS Trans Ref &/or InvestorID must be numeric";
  SSStockErrorMsg[SS_STOCK_ERROR_30762] = "2232 ORS Trans Source &/or CAID must be character string";
  SSStockErrorMsg[SS_STOCK_ERROR_30764] = "2402 ' M<ZZZ9> ' total volume exceeds trading volume threshold by ' M<ZZ9.99> '%";
  SSStockErrorMsg[SS_STOCK_ERROR_30766] = "2403 ' M<ZZZ9> ' seller ' M<9999> ' Buyer' M<9999> X A3 (I1) M<ZZZ ZZZ ZZZ ZZ9> in one trade";
  SSStockErrorMsg[SS_STOCK_ERROR_30768] = "2404 ' M<ZZZ9> ' broker firm' M<99999> has dealt more than ' M<ZZ9.99> '% of the total trades";
  SSStockErrorMsg[SS_STOCK_ERROR_30770] = "2405 Index' A8 'up by M<ZZ9.99> '% of previous close";
  SSStockErrorMsg[SS_STOCK_ERROR_30772] = "2406 Index' A8 'up by M<ZZ9.99> '% of previous alert";
  SSStockErrorMsg[SS_STOCK_ERROR_30774] = "2407 Index' A8 'down by M<ZZ9.99> '% of previous close";
  SSStockErrorMsg[SS_STOCK_ERROR_30776] = "2408 Index' A8 'down by M<ZZ9.99> '% of previous alert";
  SSStockErrorMsg[SS_STOCK_ERROR_30778] = "2409 Broker firm ' M<99999> ' trading exposure has reached ' M<ZZ9.99> '% of trading cap";
  SSStockErrorMsg[SS_STOCK_ERROR_30780] = "2411 Signed off by the Exchange - no sign on permitted";
  SSStockErrorMsg[SS_STOCK_ERROR_30782] = "2412 Broker number is now available - sign on permitted";
  SSStockErrorMsg[SS_STOCK_ERROR_30784] = "2415 User ' M<99999> M<999> ' failed to sign on at broker ' M<9999> ' - trader suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30786] = "2416 Order Reduction Quantity too large";
  SSStockErrorMsg[SS_STOCK_ERROR_30788] = "2417 Broker ' M<9999> ' has been activated for Market Group ' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_30790] = "2418 Broker ' M<9999>.' has been suspended for Market Group ' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_30792] = "2419 Broker firm activated";
  SSStockErrorMsg[SS_STOCK_ERROR_30794] = "2420 Member Firm not eligible for Basket Orders";
  SSStockErrorMsg[SS_STOCK_ERROR_30796] = "2422 Invalid Security in Basket Order";
  SSStockErrorMsg[SS_STOCK_ERROR_30798] = "2423 Basket must contain orders for same side";
  SSStockErrorMsg[SS_STOCK_ERROR_30800] = "2424 Invalid Order Type";
  SSStockErrorMsg[SS_STOCK_ERROR_30802] = "2425 Basket must satisfy minimum constituent stocks";
  SSStockErrorMsg[SS_STOCK_ERROR_30804] = "2500 User ' M<999> ' is already signed on another monitor PC";
  SSStockErrorMsg[SS_STOCK_ERROR_30806] = "2501 Invalid monitor user password";
  SSStockErrorMsg[SS_STOCK_ERROR_30808] = "2502 No monitor user signed on the monitor PC";
  SSStockErrorMsg[SS_STOCK_ERROR_30810] = "3001 Market open";
  SSStockErrorMsg[SS_STOCK_ERROR_30812] = "3002 Fixed price orders only";
  SSStockErrorMsg[SS_STOCK_ERROR_30814] = "3003 Sales input only";
  SSStockErrorMsg[SS_STOCK_ERROR_30816] = "3004 Trade rejection only";
  SSStockErrorMsg[SS_STOCK_ERROR_30818] = "3005 Exchange intervention";
  SSStockErrorMsg[SS_STOCK_ERROR_30820] = "3006 Market freeze";
  SSStockErrorMsg[SS_STOCK_ERROR_30822] = "3007 Market closed";
  SSStockErrorMsg[SS_STOCK_ERROR_30824] = "3008 Order cancellation only";
  SSStockErrorMsg[SS_STOCK_ERROR_30826] = "3010 Closing price for this Market has not been calculated";
  SSStockErrorMsg[SS_STOCK_ERROR_30828] = "3011 Security does not belong to the specified Market";
  SSStockErrorMsg[SS_STOCK_ERROR_30830] = "3012 Request not accepted - not a RT security";
  SSStockErrorMsg[SS_STOCK_ERROR_30832] = "3013 Request not accepted - security has enough liquidity";
  SSStockErrorMsg[SS_STOCK_ERROR_30834] = "3016 Exchange: trade date = ' M<99999999> ' half-day manual control";
  SSStockErrorMsg[SS_STOCK_ERROR_30836] = "3017 xxxxx market: trade date = ' M<99999999> ' full-day manual control";
  SSStockErrorMsg[SS_STOCK_ERROR_30838] = "3018 xxxxx market: trade date = ' M<99999999> ' half-day auto control";
  SSStockErrorMsg[SS_STOCK_ERROR_30840] = "3019 xxxxx market: trade date = ' M<99999999> ' full-day auto control";
  SSStockErrorMsg[SS_STOCK_ERROR_30842] = "3020 xxxxx market: trade date = ' M<99999999> ' non-trading manual control";
  SSStockErrorMsg[SS_STOCK_ERROR_30844] = "3021 xxxxx market: trade date = ' M<99999999> ' non-trading auto control";
  SSStockErrorMsg[SS_STOCK_ERROR_30846] = "3022 xxxxx market now under Manual Control";
  SSStockErrorMsg[SS_STOCK_ERROR_30848] = "3023 xxxxx market now under Auto Control";
  SSStockErrorMsg[SS_STOCK_ERROR_30850] = "3025 xxxxx market is not ON HOLD";
  SSStockErrorMsg[SS_STOCK_ERROR_30852] = "3031 Order Input starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30854] = "3032 Pre-order Matching starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30856] = "3033 Order Matching starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30858] = "3034 Blocking starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30860] = "3035 Order cancel starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30862] = "3036 Continuous trading starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30864] = "3037 Fixed price starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30866] = "3038 Sales input starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30868] = "3039 Exchange intervention starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30870] = "3040 Freeze starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30872] = "3041 Close starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30874] = "3042 Day close starts for xxxxx";
  SSStockErrorMsg[SS_STOCK_ERROR_30876] = "4001 Broker Number invalid";
  SSStockErrorMsg[SS_STOCK_ERROR_30878] = "4004 Broker Number not signed on";
  SSStockErrorMsg[SS_STOCK_ERROR_30880] = "4006 Invitation Market Group mismatch with specified Security";
  SSStockErrorMsg[SS_STOCK_ERROR_30882] = "4012 General error";
  SSStockErrorMsg[SS_STOCK_ERROR_30884] = "4014 ORS not available";
  SSStockErrorMsg[SS_STOCK_ERROR_30886] = "4015 BS not available";
  SSStockErrorMsg[SS_STOCK_ERROR_30888] = "4018 BS-ORS tunnel blocked";
  SSStockErrorMsg[SS_STOCK_ERROR_30890] = "4023 Invalid Message Reference";
  SSStockErrorMsg[SS_STOCK_ERROR_30892] = "4026 ACP Logon NOT yet done";
  SSStockErrorMsg[SS_STOCK_ERROR_30894] = "4028 Failed to send message to Host";
  SSStockErrorMsg[SS_STOCK_ERROR_30896] = "4030 Failed to convert to Open Message";
  SSStockErrorMsg[SS_STOCK_ERROR_30898] = "4031 No such security";
  SSStockErrorMsg[SS_STOCK_ERROR_30900] = "4032 Invalid Market Code";
  SSStockErrorMsg[SS_STOCK_ERROR_30902] = "4033 Security Data Check Error";
  SSStockErrorMsg[SS_STOCK_ERROR_30904] = "4034 Non-ORS originated COI contains non-zero ORS-TRAN-REF";
  SSStockErrorMsg[SS_STOCK_ERROR_30906] = "4035 Not Logon to OG yet";
  SSStockErrorMsg[SS_STOCK_ERROR_30908] = "4036 Illegal Terminator in Open Message Header";
  SSStockErrorMsg[SS_STOCK_ERROR_30910] = "4038 Failed to send message to BS";
  SSStockErrorMsg[SS_STOCK_ERROR_30912] = "4039 Failed to convert to Proprietary Message";
  SSStockErrorMsg[SS_STOCK_ERROR_30914] = "4040 Non-ORS originated COC contains non-zero ORS-TRAN-REF";
  SSStockErrorMsg[SS_STOCK_ERROR_30916] = "4041 Non-ORS originated COM contains non-zero ORS-TRAN-REF";
  SSStockErrorMsg[SS_STOCK_ERROR_30918] = "4042 Invitation fee message flow control rate exceeded";
  SSStockErrorMsg[SS_STOCK_ERROR_30920] = "4044 Throttled Transaction is not allowed during OG Recovery";
  SSStockErrorMsg[SS_STOCK_ERROR_30922] = "4045 Binary Security Dynamic Info Flag must be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_30924] = "4046 Device trade feed mode is off";
  SSStockErrorMsg[SS_STOCK_ERROR_30926] = "4047 Long Order Sequence Number Support Flag must be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_30928] = "4048 Dynamic Market Data Feed is off";
  SSStockErrorMsg[SS_STOCK_ERROR_30930] = "9000 System started";
  SSStockErrorMsg[SS_STOCK_ERROR_30932] = "9001 System closed";
  SSStockErrorMsg[SS_STOCK_ERROR_30934] = "9002 Signed off - I/O error";
  SSStockErrorMsg[SS_STOCK_ERROR_30936] = "9003 Terminal I/O error";
  SSStockErrorMsg[SS_STOCK_ERROR_30938] = "9004 Operation being recovered";
  SSStockErrorMsg[SS_STOCK_ERROR_30940] = "9005 Restarted after failure";
  SSStockErrorMsg[SS_STOCK_ERROR_30942] = "9006 Restarting after failure";
  SSStockErrorMsg[SS_STOCK_ERROR_30944] = "9007 Being recovered";
  SSStockErrorMsg[SS_STOCK_ERROR_30946] = "9010 Number of items must be within the maximum allowed number";
  SSStockErrorMsg[SS_STOCK_ERROR_30948] = "9011 Invalid trade sequence number";
  SSStockErrorMsg[SS_STOCK_ERROR_30950] = "9012 System busy re-try later";
  SSStockErrorMsg[SS_STOCK_ERROR_30952] = "9023 Invalid Confirmation Flag";
  SSStockErrorMsg[SS_STOCK_ERROR_30954] = "9024 Confirmation Trade Type must be Y or N";
  SSStockErrorMsg[SS_STOCK_ERROR_30956] = "9026 Non-active Host cannot process recoveries";
  SSStockErrorMsg[SS_STOCK_ERROR_30958] = "9027 Invalid broker number received by Host";
  SSStockErrorMsg[SS_STOCK_ERROR_30960] = "9028 Broker number not recognised by Host";
  SSStockErrorMsg[SS_STOCK_ERROR_30962] = "9029 Recovering device is still not connected or logged on";
  SSStockErrorMsg[SS_STOCK_ERROR_30964] = "9030 Broker number missing";
  SSStockErrorMsg[SS_STOCK_ERROR_30966] = "9031 Broker must belong to the same broker firm as trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30968] = "9032 Broker signed on by another Trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30970] = "9033 Broker suspended";
  SSStockErrorMsg[SS_STOCK_ERROR_30972] = "9034 Broker must not be registered trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30974] = "9035 Broker must be registered trader";
  SSStockErrorMsg[SS_STOCK_ERROR_30976] = "9036 Invalid Bid/Ask indicator";
  SSStockErrorMsg[SS_STOCK_ERROR_30978] = "9037 Order modification not accepted - order not outstanding";
  SSStockErrorMsg[SS_STOCK_ERROR_30980] = "9041 Wrong order side - semi automatic matching not accepted";
  SSStockErrorMsg[SS_STOCK_ERROR_30982] = "9046 Invalid time";
  SSStockErrorMsg[SS_STOCK_ERROR_30984] = "9047 Invalid news itemID";
  SSStockErrorMsg[SS_STOCK_ERROR_30986] = "9049 Invalid Security";
  SSStockErrorMsg[SS_STOCK_ERROR_30988] = "9050 Invalid broker";
  SSStockErrorMsg[SS_STOCK_ERROR_30990] = "9051 Number of items must not be negative";
  SSStockErrorMsg[SS_STOCK_ERROR_30992] = "9053 Invalid news systemID";
  SSStockErrorMsg[SS_STOCK_ERROR_30994] = "9056 Duplicate received of originally rejected ORS transaction";
  SSStockErrorMsg[SS_STOCK_ERROR_30996] = "9057 Duplicate received of originally rejected BS message";
  SSStockErrorMsg[SS_STOCK_ERROR_30998] = "9058 Duplicate received of originally accepted ORS transaction";
  SSStockErrorMsg[SS_STOCK_ERROR_31000] = "9059 Duplicate received of an in progress ORS transaction";
  SSStockErrorMsg[SS_STOCK_ERROR_31002] = "9060 Duplicate received of originally accepted BS message";
  SSStockErrorMsg[SS_STOCK_ERROR_31004] = "9061 Duplicate received of an in progress BS message";
  SSStockErrorMsg[SS_STOCK_ERROR_31006] = "9067 Device not recognised by Host";
  SSStockErrorMsg[SS_STOCK_ERROR_31008] = "9068 Device trade feed mode is off";
  SSStockErrorMsg[SS_STOCK_ERROR_31010] = "9070 Cannot specify Broker Number";
  SSStockErrorMsg[SS_STOCK_ERROR_31012] = "9997 Software error. Invalid S/W version: ' M<9999> ' tandem: ' M<9999>";
  SSStockErrorMsg[SS_STOCK_ERROR_31014] = "2601 Order Reject due to VCM";
  SSStockErrorMsg[SS_STOCK_ERROR_31016] = "2602 Order Reject due to VCM";
  SSStockErrorMsg[SS_STOCK_ERROR_31018] = "2611 Order Cancelled due to Auction Price Limits";
  SSStockErrorMsg[SS_STOCK_ERROR_31020] = "2612 Order Rejected due to Auction Price Limits";
  SSStockErrorMsg[SS_STOCK_ERROR_31022] = "3(Order Exceed Limit)";
  SSStockErrorMsg[SS_STOCK_ERROR_31024] = "6(Duplicate order)";
  SSStockErrorMsg[SS_STOCK_ERROR_31026] = "13(Incorrect Qty)";
  SSStockErrorMsg[SS_STOCK_ERROR_31028] = "16(Price exceeds current price band)";
  SSStockErrorMsg[SS_STOCK_ERROR_31030] = "19(Reference price is not available)";
  SSStockErrorMsg[SS_STOCK_ERROR_31032] = "20(Notional value exceeds threshold)";
  SSStockErrorMsg[SS_STOCK_ERROR_31034] = "101(Price exceeds current price band(overrid not allowed))";
  SSStockErrorMsg[SS_STOCK_ERROR_31036] = "102(Price exceeds current price band)";
  SSStockErrorMsg[SS_STOCK_ERROR_31038] = "0(Too late to cancel)";
  SSStockErrorMsg[SS_STOCK_ERROR_31040] = "1(Unknown Order)";
  SSStockErrorMsg[SS_STOCK_ERROR_31042] = "3(Order already in Pending Cancel or Pending Replace status)";
  SSStockErrorMsg[SS_STOCK_ERROR_31044] = "6(Duplicate Client OrderID received)";
  SSStockErrorMsg[SS_STOCK_ERROR_31046] = "1(Required field missing)";
  SSStockErrorMsg[SS_STOCK_ERROR_31048] = "2(Field not defined for this message)";
  SSStockErrorMsg[SS_STOCK_ERROR_31050] = "3(Undefined field)";
  SSStockErrorMsg[SS_STOCK_ERROR_31052] = "4(Field specified without a value)";
  SSStockErrorMsg[SS_STOCK_ERROR_31054] = "5(Value is incorrect for this field)";
  SSStockErrorMsg[SS_STOCK_ERROR_31056] = "6(Incorrect data format for value)";
  SSStockErrorMsg[SS_STOCK_ERROR_31058] = "9(CompID problem)";
  SSStockErrorMsg[SS_STOCK_ERROR_31060] = "11(Invalid message type)";
  SSStockErrorMsg[SS_STOCK_ERROR_31062] = "13(Field appears more than once)";
  SSStockErrorMsg[SS_STOCK_ERROR_31064] = "1(UnknownID)";
  SSStockErrorMsg[SS_STOCK_ERROR_31066] = "2(Unknown Security)";
  SSStockErrorMsg[SS_STOCK_ERROR_31068] = "3(Unspecified Message Type)";
  SSStockErrorMsg[SS_STOCK_ERROR_31070] = "4(Application not available)";
  SSStockErrorMsg[SS_STOCK_ERROR_31072] = "5(Conditionally required field missing)";
  SSStockErrorMsg[SS_STOCK_ERROR_31074] = "8(Throttle limit exceeded)";
  SSStockErrorMsg[SS_STOCK_ERROR_32000] = "Other due to Order Rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_32002] = "Other due to Order Cancel Rejected";
  SSStockErrorMsg[SS_STOCK_ERROR_32004] = "Other due to Reject";
  SSStockErrorMsg[SS_STOCK_ERROR_32006] = "Other due to Business Message Reject";

  // SZSE
  SZSEErrorMsg[SZSE_ERR_CODE_20001] = "Invalid account:unopened account";
  SZSEErrorMsg[SZSE_ERR_CODE_20002] = "Invalid account:logged out; reported loss; etc.";
  SZSEErrorMsg[SZSE_ERR_CODE_20003] = "Invalid account:no transaction rights for the business product";
  SZSEErrorMsg[SZSE_ERR_CODE_20005] = "Business prohibition:securities business switch off";
  SZSEErrorMsg[SZSE_ERR_CODE_20006] = "Business prohibition:not allowed to declare this type of delegation";
  SZSEErrorMsg[SZSE_ERR_CODE_20007] = "Securities suspension";
  SZSEErrorMsg[SZSE_ERR_CODE_20008] = "Wrong price";
  SZSEErrorMsg[SZSE_ERR_CODE_20009] = "Wrong price";
  SZSEErrorMsg[SZSE_ERR_CODE_20010] = "Wrong volume: Delegated quantity is not an integer multiple of quantity unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20011] = "Illegal volume";
  SZSEErrorMsg[SZSE_ERR_CODE_20012] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20013] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20014] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20015] = "Business prohibition:margin trading is prohibited to declare market orders";
  SZSEErrorMsg[SZSE_ERR_CODE_20016] = "Wrong price:commission price of margin selling not meet the price increase inspection requirements";
  SZSEErrorMsg[SZSE_ERR_CODE_20017] = "Invalid account:credit account can only buy collateral securities";
  SZSEErrorMsg[SZSE_ERR_CODE_20018] = "Invalid account:non-credit account declaration financing and securities lending commission";
  SZSEErrorMsg[SZSE_ERR_CODE_20019] = "Invalid unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20020] = "Invalid account";
  SZSEErrorMsg[SZSE_ERR_CODE_20021] = "Quantity exceeded";
  SZSEErrorMsg[SZSE_ERR_CODE_20022] = "Short selling";
  SZSEErrorMsg[SZSE_ERR_CODE_20023] = "Invalid unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20024] = "Invalid unit:entrusted trading unit has no trading authority for the corresponding product";
  SZSEErrorMsg[SZSE_ERR_CODE_20025] = "Invalid unit:entrusted trading unit has no trading authority for the corresponding product";
  SZSEErrorMsg[SZSE_ERR_CODE_20026] = "Invalid unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20027] = "Invalid unit:QFII account not declared from the designated trading unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20028] = "Invalid unit:trading unit has no business rights for the corresponding product";
  SZSEErrorMsg[SZSE_ERR_CODE_20029] = "Business prohibition:market participant business qualifications are restricted";
  SZSEErrorMsg[SZSE_ERR_CODE_20030] = "Duplicate declaration number";
  SZSEErrorMsg[SZSE_ERR_CODE_20031] = "Pairing failed:declared elements of the two parties of the transaction not match";
  SZSEErrorMsg[SZSE_ERR_CODE_20032] = "Pairing failed:B-share agreement trading domestic accounts and overseas accounts not be traded";
  SZSEErrorMsg[SZSE_ERR_CODE_20033] = "No opponent";
  SZSEErrorMsg[SZSE_ERR_CODE_20034] = "Illegal amount:amount in the commission must be an integer multiple of the amount unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20035] = "Insufficient subscription:insufficient investor stocks when purchasing ETFs";
  SZSEErrorMsg[SZSE_ERR_CODE_20036] = "Insufficient redemption:fund companies have insufficient stocks when redeeming ETFs";
  SZSEErrorMsg[SZSE_ERR_CODE_20037] = "Cash overrun:cash replacement part exceeds the upper limit";
  SZSEErrorMsg[SZSE_ERR_CODE_20038] = "Invalid account";
  SZSEErrorMsg[SZSE_ERR_CODE_20039] = "Repeat subscription:reissue subscription online";
  SZSEErrorMsg[SZSE_ERR_CODE_20040] = "Invalid unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20041] = "Short selling:corresponding pledged shares in the unsecured business are insufficient";
  SZSEErrorMsg[SZSE_ERR_CODE_20042] = "Short selling:insufficient corresponding standard coupons in the discharge";
  SZSEErrorMsg[SZSE_ERR_CODE_20046] = "Unable to deal:market price order not meet the transaction conditions to cancel the order";
  SZSEErrorMsg[SZSE_ERR_CODE_20047] = "Overrun";
  SZSEErrorMsg[SZSE_ERR_CODE_20048] = "Overrun:single account fund cumulative purchase or redemption scale exceeds the limit";
  SZSEErrorMsg[SZSE_ERR_CODE_20049] = "Overrun:fund's total net purchase or net redemption exceeds the limit";
  SZSEErrorMsg[SZSE_ERR_CODE_20050] = "Overrun:single account fund net purchase or net redemption scale exceeds the limit";
  SZSEErrorMsg[SZSE_ERR_CODE_20051] = "Wrong buyback period:repurchase days exceeded business limit";
  SZSEErrorMsg[SZSE_ERR_CODE_20055] = "Invalid member:members have no transaction rights for the corresponding business";
  SZSEErrorMsg[SZSE_ERR_CODE_20056] = "Invalid account:securities account for non-business designated transactions";
  SZSEErrorMsg[SZSE_ERR_CODE_20059] = "Amount exceeded:net purchase amount exceeds the set limit";
  SZSEErrorMsg[SZSE_ERR_CODE_20060] = "Insufficient positions";
  SZSEErrorMsg[SZSE_ERR_CODE_20061] = "Trading volume exceeded";
  SZSEErrorMsg[SZSE_ERR_CODE_20062] = "Position limit exceeded";
  SZSEErrorMsg[SZSE_ERR_CODE_20063] = "Position limit exceeded";
  SZSEErrorMsg[SZSE_ERR_CODE_20064] = "Insufficient funds:insufficient funds available for settlement participants";
  SZSEErrorMsg[SZSE_ERR_CODE_20065] = "Platform is closed";
  SZSEErrorMsg[SZSE_ERR_CODE_20067] = "Redemption label wrong";
  SZSEErrorMsg[SZSE_ERR_CODE_20068] = "Wrong settlement institution:billing agency code error";
  SZSEErrorMsg[SZSE_ERR_CODE_20069] = "Invalid account:account under entrustment is a settlement restricted account";
  SZSEErrorMsg[SZSE_ERR_CODE_20070] = "Invalid account:account under commission is an unqualified account";
  SZSEErrorMsg[SZSE_ERR_CODE_20071] = "Wrong OwnerType";
  SZSEErrorMsg[SZSE_ERR_CODE_20073] = "Wrong quote:bid price declared by the bilateral quotation must be lower than the selling price";
  SZSEErrorMsg[SZSE_ERR_CODE_20074] = "Invalid business:forced commission must be a limit order";
  SZSEErrorMsg[SZSE_ERR_CODE_20075] = "Quote cancellation:quote is updated or withdrawn";
  SZSEErrorMsg[SZSE_ERR_CODE_20076] = "Wrong declaration method";
  SZSEErrorMsg[SZSE_ERR_CODE_20077] = "No quote authority:no market making authority";
  SZSEErrorMsg[SZSE_ERR_CODE_20078] = "Trading volume exceeded:settlement participant transaction limit exceeded";
  SZSEErrorMsg[SZSE_ERR_CODE_20079] = "Insufficient holdings:restriction of restricted shares; insufficient available quota";
  SZSEErrorMsg[SZSE_ERR_CODE_20095] = "Wrong cancellation request";
  SZSEErrorMsg[SZSE_ERR_CODE_20096] = "The order can not be cancelled";
  SZSEErrorMsg[SZSE_ERR_CODE_20097] = "Order not exist";
  SZSEErrorMsg[SZSE_ERR_CODE_20099] = "Repeat order";
  SZSEErrorMsg[SZSE_ERR_CODE_20101] = "Wrong application identification";
  SZSEErrorMsg[SZSE_ERR_CODE_20102] = "Illegal securities:not support the declared business";
  SZSEErrorMsg[SZSE_ERR_CODE_20103] = "Unpacking failed";
  SZSEErrorMsg[SZSE_ERR_CODE_20104] = "Platform not open";
  SZSEErrorMsg[SZSE_ERR_CODE_20105] = "Wrong trading unit:gateway no authority over the trading unit";
  SZSEErrorMsg[SZSE_ERR_CODE_20106] = "Wrong field";
  SZSEErrorMsg[SZSE_ERR_CODE_20107] = "Illegal message type:unsupported message type";
  SZSEErrorMsg[SZSE_ERR_CODE_20108] = "Illegal platform:delegated platform error";
  SZSEErrorMsg[SZSE_ERR_CODE_20110] = "Wrong price type:wrong price type";
  SZSEErrorMsg[SZSE_ERR_CODE_20111] = "Invalid unit:multi-party transaction unit in the transaction declaration not belong to the same member";
  SZSEErrorMsg[SZSE_ERR_CODE_20112] = "No permission:gateway no authority to declare delegation";
  SZSEErrorMsg[SZSE_ERR_CODE_20113] = "Service suspension:fund inquiry service suspended";
  SZSEErrorMsg[SZSE_ERR_CODE_20114] = "Temporary market refusal:temporary market refusal";
  SZSEErrorMsg[SZSE_ERR_CODE_20115] = "Wrong bid";
  SZSEErrorMsg[SZSE_ERR_CODE_20116] = "Wrong bid:deal request originator error";
  SZSEErrorMsg[SZSE_ERR_CODE_20117] = "Invalid account";
  SZSEErrorMsg[SZSE_ERR_CODE_20118] = "Illegal basketPledged bonds illegal";
  SZSEErrorMsg[SZSE_ERR_CODE_20119] = "Illegal Pledged bonds:number of pledged bonds declared by the three parties not meet the business requirements";
  SZSEErrorMsg[SZSE_ERR_CODE_20120] = "Illegal Pledged bonds";
  SZSEErrorMsg[SZSE_ERR_CODE_20121] = "Illegal Pledged bonds";
  SZSEErrorMsg[SZSE_ERR_CODE_20122] = "Illegal Pledged bonds";
  SZSEErrorMsg[SZSE_ERR_CODE_20123] = "Invalid unit:counterparty trading unit in transaction declaration does not exist";
  SZSEErrorMsg[SZSE_ERR_CODE_20124] = "Wrong buyback period";
  SZSEErrorMsg[SZSE_ERR_CODE_20125] = "Contract not exist";
  SZSEErrorMsg[SZSE_ERR_CODE_20126] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20127] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20128] = "Illegal amount";
  SZSEErrorMsg[SZSE_ERR_CODE_20129] = "Illegal securities";
  SZSEErrorMsg[SZSE_ERR_CODE_20130] = "No opponent";
  SZSEErrorMsg[SZSE_ERR_CODE_20131] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20132] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20133] = "Business prohibition:component contract passed the combination automatic release date";
  SZSEErrorMsg[SZSE_ERR_CODE_20134] = "Business prohibition:contract not support the declared strategy";
  SZSEErrorMsg[SZSE_ERR_CODE_20135] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20136] = "Illegal quantity:number of entrusted component contracts not comply with the rules";
  SZSEErrorMsg[SZSE_ERR_CODE_20137] = "Business prohibition:entrusted component contract rights warehouse/obligatory warehouse not comply with the rules";
  SZSEErrorMsg[SZSE_ERR_CODE_20138] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20139] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20140] = "Business prohibition";
  SZSEErrorMsg[SZSE_ERR_CODE_20143] = "Invalid transaction entity";
  SZSEErrorMsg[SZSE_ERR_CODE_20144] = "Invalid traders";
  SZSEErrorMsg[SZSE_ERR_CODE_20145] = "Invalid account ID";
  SZSEErrorMsg[SZSE_ERR_CODE_20146] = "Order has timed out";
  SZSEErrorMsg[SZSE_ERR_CODE_20147] = "Request for quotation transaction ID is duplicated";
  SZSEErrorMsg[SZSE_ERR_CODE_20149] = "Invalid account ID";
  SZSEErrorMsg[SZSE_ERR_CODE_20150] = "Billing method is incorrect";
  SZSEErrorMsg[SZSE_ERR_CODE_20151] = "Billing cycle is incorrect";
  SZSEErrorMsg[SZSE_ERR_CODE_20153] = "Loan term is wrong";
  SZSEErrorMsg[SZSE_ERR_CODE_20154] = "Amount of loan fee paid on spot is wrong";
  SZSEErrorMsg[SZSE_ERR_CODE_20155] = "Declaration grace period error";
  SZSEErrorMsg[SZSE_ERR_CODE_20156] = "Business is forbidden";
  SZSEErrorMsg[SZSE_ERR_CODE_20157] = "Business is forbidden";
  SZSEErrorMsg[SZSE_ERR_CODE_20158] = "Business is forbidden";
  SZSEErrorMsg[SZSE_ERR_CODE_20159] = "Underlying coupon is illegal";
  SZSEErrorMsg[SZSE_ERR_CODE_20160] = "Underlying coupon is illegal";
  SZSEErrorMsg[SZSE_ERR_CODE_20161] = "Total value of coupon is illegal";
  SZSEErrorMsg[SZSE_ERR_CODE_20162] = "Total value of coupon is illegal";
  SZSEErrorMsg[SZSE_ERR_CODE_20164] = "Bidding date is incorrect";
  SZSEErrorMsg[SZSE_ERR_CODE_20165] = "Duplicate declarations";
  SZSEErrorMsg[SZSE_ERR_CODE_20166] = "Cannot be filled";
  SZSEErrorMsg[SZSE_ERR_CODE_20167] = "Trading in securities is temporarily suspended";
  SZSEErrorMsg[SZSE_ERR_CODE_20168] = "Bidding does not exist";
  SZSEErrorMsg[SZSE_ERR_CODE_20169] = "Price error";
  SZSEErrorMsg[SZSE_ERR_CODE_20170] = "Bidding pre-order is now in effect";
  SZSEErrorMsg[SZSE_ERR_CODE_20172] = "Responder Dealer Error";
  SZSEErrorMsg[SZSE_ERR_CODE_20173] = "Business is forbidden";
  SZSEErrorMsg[SZSE_ERR_CODE_20174] = "Original deal does not exist";
  SZSEErrorMsg[SZSE_ERR_CODE_20175] = "Original transaction status is wrong";
  SZSEErrorMsg[SZSE_ERR_CODE_20176] = "Transaction Elements Failed to match";
  SZSEErrorMsg[SZSE_ERR_CODE_20177] = "Trading restrictions in Hong Kong Stock Connect";
  SZSEErrorMsg[SZSE_ERR_CODE_20178] = "Business is forbidden";
  SZSEErrorMsg[SZSE_ERR_CODE_20179] = "Business is forbidden";
  SZSEErrorMsg[SZSE_ERR_CODE_20180] = "Invalid Membership";
  SZSEErrorMsg[SZSE_ERR_CODE_20201] = "Motion code is wrong";
  SZSEErrorMsg[SZSE_ERR_CODE_20202] = "Vote wrong";
  SZSEErrorMsg[SZSE_ERR_CODE_29995] = "Market interconnection rejection:Hong Kong Stock Connect's withdrawal request rejected by the Stock Exchange";
  SZSEErrorMsg[SZSE_ERR_CODE_29996] = "Market interconnection rejection:Hong Kong Stock Connect entrustment revoked by the Stock Exchange";
  SZSEErrorMsg[SZSE_ERR_CODE_29997] = "Market interconnection rejection:Hong Kong Stock Connect commission rejected by the Stock Exchange";
  SZSEErrorMsg[SZSE_ERR_CODE_29998] = "Market interconnection rejection:Hong Kong Stock Connect commission rejected by the Stock Exchange";
  SZSEErrorMsg[SZSE_ERR_CODE_29999] = "Other errors";

  //XeleManager Error msg
  XeleManagerErrorMsg[SHARE_NO_ERROR] = "OK";
  XeleManagerErrorMsg[SHARE_ERROR_55002] = "Empty filled information";
  XeleManagerErrorMsg[SHARE_ERROR_55003] = "Over-the-counter fund transfer option error";
  XeleManagerErrorMsg[SHARE_ERROR_55004] = "SZ counter connect fail";
  XeleManagerErrorMsg[SHARE_ERROR_55005] = "Wrong password";
  XeleManagerErrorMsg[SHARE_ERROR_55006] = "Wrong number of decimal places";
  XeleManagerErrorMsg[SHARE_ERROR_55007] = "User already logined";
  XeleManagerErrorMsg[SHARE_ERROR_55008] = "Cash In Out Timeout";
  XeleManagerErrorMsg[SHARE_ERROR_55009] = "Amount verification failed";
  XeleManagerErrorMsg[SHARE_ERROR_55010] = "OrgID check error";
  XeleManagerErrorMsg[SHARE_ERROR_55011] = "Wrong Market";
  XeleManagerErrorMsg[SHARE_ERROR_55012] = "SS database connect failed";
  XeleManagerErrorMsg[SHARE_ERROR_55013] = "SZ database connect failed";
  XeleManagerErrorMsg[SHARE_ERROR_55014] = "User not login";
  XeleManagerErrorMsg[SHARE_ERROR_55015] = "SS and SZ database connect failed";
  XeleManagerErrorMsg[SHARE_ERROR_55016] = "Wrong AccountID";
  XeleManagerErrorMsg[SHARE_ERROR_55017] = "SS database query failed";
  XeleManagerErrorMsg[SHARE_ERROR_55018] = "SZ database query failed";
  XeleManagerErrorMsg[SHARE_ERROR_55019] = "SS and SZ database query failed";
  XeleManagerErrorMsg[SHARE_ERROR_55020] = "Non double investor, this feature is not supported";
  XeleManagerErrorMsg[SHARE_ERROR_55021] = "Illegal password";
  XeleManagerErrorMsg[SHARE_ERROR_55022] = "SS Counter Cash In Fail";
  XeleManagerErrorMsg[SHARE_ERROR_55023] = "SS Counter Cash Out Fail";
  XeleManagerErrorMsg[SHARE_ERROR_55024] = "SS Counter Cash In Timeout";
  XeleManagerErrorMsg[SHARE_ERROR_55025] = "SS Counter Cash Out Timeout";
  XeleManagerErrorMsg[SHARE_ERROR_55026] = "SZ Counter Cash In Fail";
  XeleManagerErrorMsg[SHARE_ERROR_55027] = "SZ Counter Cash Out Fail";
  XeleManagerErrorMsg[SHARE_ERROR_55028] = "SZ Counter Cash In Timeout";
  XeleManagerErrorMsg[SHARE_ERROR_55029] = "SZ Counter Cash Out Timeout";
  XeleManagerErrorMsg[SHARE_ERROR_55030] = "The amount of money is out of range";
  XeleManagerErrorMsg[SHARE_ERROR_55031] = "Wrong AuthCode";
  XeleManagerErrorMsg[SHARE_ERROR_55032] = "Get ready counter info of master fail,maybe counter not connect";
  XeleManagerErrorMsg[SHARE_ERROR_55033] = "Login sub client index wrong";
  XeleManagerErrorMsg[SHARE_ERROR_55034] = "Market error or counter not connect";
  XeleManagerErrorMsg[SHARE_ERROR_55037] = "AccountID not exist";
  XeleManagerErrorMsg[SHARE_ERROR_55038] = "Wrong token";
  XeleManagerErrorMsg[SHARE_ERROR_55039] = "The order number not increases monotonically";
  XeleManagerErrorMsg[SHARE_ERROR_55041] = "Interactive msg send failed";
  XeleManagerErrorMsg[SHARE_ERROR_55043] = "Failed to insert into database";
  XeleManagerErrorMsg[SHARE_ERROR_55044] = "Duplicate login";
  XeleManagerErrorMsg[SHARE_ERROR_55045] = "Initialization of settlement data not completed";
  XeleManagerErrorMsg[SHARE_ERROR_55046] = "Operate too fast";
  XeleManagerErrorMsg[SHARE_ERROR_55047] = "No relevant records";
  XeleManagerErrorMsg[SHARE_ERROR_55048] = "Login timeout";
  XeleManagerErrorMsg[SHARE_ERROR_55049] = "User has logged in on another link";
  XeleManagerErrorMsg[SHARE_ERROR_55050] = "Wrong API version";
  XeleManagerErrorMsg[SHARE_ERROR_55052] = "Interface not open";
  XeleManagerErrorMsg[SHARE_ERROR_55053] = "Wrong time format";
  XeleManagerErrorMsg[SHARE_ERROR_55054] = "Number segment run out or not configured";
  XeleManagerErrorMsg[SHARE_ERROR_55055] = "Central trading operation failed";
  XeleManagerErrorMsg[SHARE_ERROR_55056] = "User login ip check failed";
  XeleManagerErrorMsg[SHARE_ERROR_55057] = "User login mac address check failed";
  XeleManagerErrorMsg[SHARE_ERROR_55058] = "Failed to transfer";
  XeleManagerErrorMsg[SHARE_ERROR_55059] = "Central trading authentication failed";
  XeleManagerErrorMsg[SHARE_ERROR_55060] = "Failed to connect to headquarter";
  XeleManagerErrorMsg[SHARE_ERROR_55061] = "Capital cannot be less than or equal to zero";
  XeleManagerErrorMsg[SHARE_ERROR_55062] = "Wrong system_id";
  XeleManagerErrorMsg[SHARE_ERROR_55063] = "Login too fast";
  XeleManagerErrorMsg[SHARE_ERROR_55064] = "Position check failed";
  XeleManagerErrorMsg[SHARE_ERROR_55065] = "Wrong comb strategy type";
  XeleManagerErrorMsg[SHARE_ERROR_55068] = "Another account has already logged in this link";
  XeleManagerErrorMsg[SHARE_ERROR_55069] = "SS counter connect fail";
  XeleManagerErrorMsg[SHARE_ERROR_55070] = "Send message to counter error";
  XeleManagerErrorMsg[SHARE_ERROR_55071] = "Account is in auto balance status";
  XeleManagerErrorMsg[SHARE_ERROR_55072] = "SS counter status not in running,this operation can not be done";
  XeleManagerErrorMsg[SHARE_ERROR_55073] = "SZ counter status not in running,this operation can not be done";
  XeleManagerErrorMsg[SHARE_ERROR_55074] = "SS and SZ counter status both not in running,this opetation can not ne done";
  XeleManagerErrorMsg[SHARE_ERROR_55088] = "Api reconnect TradingDay compare failed";
  XeleManagerErrorMsg[SHARE_ERROR_55089] = "TradingDay not sync from trade yet";
  XeleManagerErrorMsg[SHARE_ERROR_55090] = "Contract not found";
  XeleManagerErrorMsg[SHARE_ERROR_55091] = "Api position transfer failed";
  XeleManagerErrorMsg[SHARE_ERROR_55092] = "Soft order too fast";
  XeleManagerErrorMsg[SHARE_ERROR_55093] = "query url is empty";
  XeleManagerErrorMsg[SHARE_ERROR_55103] = "Invalid InOutDirection";

  StockCommonErrorMsg[SHARE_NO_ERROR] = "OK";
  StockCommonErrorMsg[SHARE_ERROR_55002] = "Empty filled information";
  StockCommonErrorMsg[SHARE_ERROR_55003] = "Last query did not end";
  StockCommonErrorMsg[SHARE_ERROR_55004] = "counter connect fail";
  StockCommonErrorMsg[SHARE_ERROR_55005] = "Wrong password";
  StockCommonErrorMsg[SHARE_ERROR_55007] = "User already logined";
  StockCommonErrorMsg[SHARE_ERROR_55011] = "Wrong Market";
  StockCommonErrorMsg[SHARE_ERROR_55014] = "User not login";
  StockCommonErrorMsg[SHARE_ERROR_55015] = "System Memory Not Enough";
  StockCommonErrorMsg[SHARE_ERROR_55016] = "Wrong AccountID";
  StockCommonErrorMsg[SHARE_ERROR_55020] = "Non double investor, this feature is not supported";
  StockCommonErrorMsg[SHARE_ERROR_55021] = "Illegal password";
  StockCommonErrorMsg[SHARE_ERROR_55031] = "Wrong AuthCode";
  StockCommonErrorMsg[SHARE_ERROR_55032] = "Get ready counter info of master fail,maybe counter not connect";
  StockCommonErrorMsg[SHARE_ERROR_55033] = "Login sub client index wrong";
  StockCommonErrorMsg[SHARE_ERROR_55037] = "AccountID not exist";
  StockCommonErrorMsg[SHARE_ERROR_55038] = "Wrong token";
  StockCommonErrorMsg[SHARE_ERROR_55039] = "The order number not increases monotonically";
  StockCommonErrorMsg[SHARE_ERROR_55040] = "Cancelled order not found";
  StockCommonErrorMsg[SHARE_ERROR_55041] = "Interactive msg send failed";
  StockCommonErrorMsg[SHARE_ERROR_55042] = "STEP message encoded failed";
  StockCommonErrorMsg[SHARE_ERROR_55043] = "Failed to insert into database";
  StockCommonErrorMsg[SHARE_ERROR_55044] = "Duplicate login";
  StockCommonErrorMsg[SHARE_ERROR_55045] = "Initialization of settlement data not completed";
  StockCommonErrorMsg[SHARE_ERROR_55046] = "Query too fast";
  StockCommonErrorMsg[SHARE_ERROR_55047] = "No relevant records";
  StockCommonErrorMsg[SHARE_ERROR_55048] = "Login timeout";
  StockCommonErrorMsg[SHARE_ERROR_55049] = "User has logged in on another link";
  StockCommonErrorMsg[SHARE_ERROR_55050] = "Wrong API version";
  StockCommonErrorMsg[SHARE_ERROR_55052] = "Interface not open";
  StockCommonErrorMsg[SHARE_ERROR_55053] = "Wrong time format";
  StockCommonErrorMsg[SHARE_ERROR_55054] = "Number segment run out or not configured";
  StockCommonErrorMsg[SHARE_ERROR_55055] = "Central trading operation failed";
  StockCommonErrorMsg[SHARE_ERROR_55056] = "User login ip check failed";
  StockCommonErrorMsg[SHARE_ERROR_55057] = "User login mac address check failed";
  StockCommonErrorMsg[SHARE_ERROR_55058] = "Failed to transfer";
  StockCommonErrorMsg[SHARE_ERROR_55059] = "Central trading authentication failed";
  StockCommonErrorMsg[SHARE_ERROR_55060] = "failed to connect to headquarter";
  StockCommonErrorMsg[SHARE_ERROR_55061] = "Capital cannot be less than or equal to zero";
  StockCommonErrorMsg[SHARE_ERROR_55062] = "Wrong system_id";
  StockCommonErrorMsg[SHARE_ERROR_55063] = "Login too fast";
  StockCommonErrorMsg[SHARE_ERROR_55064] = "Position check failed";
  StockCommonErrorMsg[SHARE_ERROR_55065] = "Wrong comb strategy type";
  StockCommonErrorMsg[SHARE_ERROR_55067] = "zmq failed";
  StockCommonErrorMsg[SHARE_ERROR_55068] = "Another account has already logged in this link";
  StockCommonErrorMsg[SHARE_ERROR_55069] = "Send to Exchange Failed";
  StockCommonErrorMsg[SHARE_ERROR_55071] = "XeleTrade is recoverying, wait to be finished...";
  StockCommonErrorMsg[SHARE_ERROR_55070] = "Number range is exhausted";
  StockCommonErrorMsg[SHARE_ERROR_55072] = "Cancel other account order";
  StockCommonErrorMsg[SHARE_ERROR_55073] = "Rebuild Failed";
  StockCommonErrorMsg[SHARE_ERROR_55074] = "Xele-Bot login timeout";
  StockCommonErrorMsg[SHARE_ERROR_55075] = "TransfereePbuID is null";
  StockCommonErrorMsg[SHARE_ERROR_55076] = "Number range end is null";
  StockCommonErrorMsg[SHARE_ERROR_55077] = "Number range redeposite_end is null";
  StockCommonErrorMsg[SHARE_ERROR_55078] = "Do not have non-trade tgw session";
  StockCommonErrorMsg[SHARE_ERROR_55079] = "ClOrdID large than number range";
  StockCommonErrorMsg[SHARE_ERROR_55080] = "Order_sys_id length error";
  StockCommonErrorMsg[SHARE_ERROR_55081] = "DropOrder send err";
  StockCommonErrorMsg[SHARE_ERROR_55082] = "Do not find clOrdID in table redeposite";
  StockCommonErrorMsg[SHARE_ERROR_55083] = "Do not logon non-trade link";
  StockCommonErrorMsg[SHARE_ERROR_55084] = "Forced cancellation";
  StockCommonErrorMsg[SHARE_ERROR_55085] = "Operway check fail";
  StockCommonErrorMsg[SHARE_ERROR_55086] = "Api supervise information check fail";
  StockCommonErrorMsg[SHARE_ERROR_55087] = "Capital is too large";
  StockCommonErrorMsg[SHARE_ERROR_55088] = "Api reconnect TradingDay compare failed";
  StockCommonErrorMsg[SHARE_ERROR_55089] = "TradingDay not sync from trade yet";
  StockCommonErrorMsg[SHARE_ERROR_55090] = "Contract not found";
  StockCommonErrorMsg[SHARE_ERROR_55091] = "Api position transfer failed";
  StockCommonErrorMsg[SHARE_ERROR_55092] = "Soft order too fast";
  StockCommonErrorMsg[SHARE_ERROR_55093] = "query url is empty";
  StockCommonErrorMsg[SHARE_ERROR_55094] = "volume is less than zero";
  StockCommonErrorMsg[SHARE_ERROR_55095] = "risk control type error";
  StockCommonErrorMsg[SHARE_ERROR_55096] = "order send to exchange fail";
  StockCommonErrorMsg[SHARE_ERROR_55097] = "Trading gateWay disconnected";
  StockCommonErrorMsg[SHARE_ERROR_55098] = "Exchange closed";
  StockCommonErrorMsg[SHARE_ERROR_55099] = "Invalid SecurityID";
  StockCommonErrorMsg[SHARE_ERROR_55100] = "Insufficient available cover lock positions";
  StockCommonErrorMsg[SHARE_ERROR_55101] = "Insufficient cover lock positions";
  StockCommonErrorMsg[SHARE_ERROR_55102] = "Counter not initialized completed";
  StockCommonErrorMsg[SHARE_ERROR_55103] = "Invalid InOutDirection";
  StockCommonErrorMsg[SHARE_ERROR_55104] = "Invalid Volume";
  StockCommonErrorMsg[SHARE_ERROR_55105] = "Send msg to manager failed";
  StockCommonErrorMsg[SHARE_ERROR_55106] = "Wait rsp msg timeout";
  StockCommonErrorMsg[SHARE_ERROR_55107] = "fileLock operate fail";
  StockCommonErrorMsg[SHARE_ERROR_55108] = "check current fund fail";
  StockCommonErrorMsg[SHARE_ERROR_55109] = "read old fund from fpga fail";
  StockCommonErrorMsg[SHARE_ERROR_55110] = "set new fund to fpga fail";
  StockCommonErrorMsg[SHARE_ERROR_55111] = "Central trading response timeout";
  StockCommonErrorMsg[SHARE_ERROR_55112] = "Creation or redemption time error.";
  StockCommonErrorMsg[SHARE_ERROR_55113] = "SS counter connect fail";
  StockCommonErrorMsg[SHARE_ERROR_55114] = "SZ counter connect fail";
  StockCommonErrorMsg[SHARE_ERROR_55115] = "Insufficient available funds";

  StockCommonErrorMsg[SHARE_ERROR_56000] = "Wrong functionID";
  StockCommonErrorMsg[SHARE_ERROR_56001] = "Occur amount less than or equal to zero";
  StockCommonErrorMsg[SHARE_ERROR_56002] = "Centralized server init failed";
  StockCommonErrorMsg[SHARE_ERROR_56003] = "Set connection option failed";
  StockCommonErrorMsg[SHARE_ERROR_56004] = "Set timeout failed";
  StockCommonErrorMsg[SHARE_ERROR_56005] = "Centralized server connect failed";
  StockCommonErrorMsg[SHARE_ERROR_56006] = "Set system param failed";
  StockCommonErrorMsg[SHARE_ERROR_56007] = "Get CODE Fail";
  StockCommonErrorMsg[SHARE_ERROR_56008] = "Send msg to xxload failed";
  StockCommonErrorMsg[SHARE_ERROR_56009] = "Update fpga account failed";
  StockCommonErrorMsg[SHARE_ERROR_56010] = "Req count is zero";
  StockCommonErrorMsg[SHARE_ERROR_56011] = "Send ufx function id failed";
  StockCommonErrorMsg[SHARE_ERROR_56012] = "Get Centralized server rsp timeout";
  StockCommonErrorMsg[SHARE_ERROR_56013] = "Do not find rsp data";
  StockCommonErrorMsg[SHARE_ERROR_56014] = "Centralized counter rsp prase failed";
  StockCommonErrorMsg[SHARE_ERROR_56015] = "Business operation failed";
  StockCommonErrorMsg[SHARE_ERROR_56016] = "Wait rsp time out";
  StockCommonErrorMsg[SHARE_ERROR_56017] = "Unkown status! please check xxLoad log";
  StockCommonErrorMsg[SHARE_ERROR_56018] = "User do not login trade center, trade pwd is null";
  StockCommonErrorMsg[SHARE_ERROR_56019] = "Custid is null";
  StockCommonErrorMsg[SHARE_ERROR_56020] = "Connect trade center server failed";
  StockCommonErrorMsg[SHARE_ERROR_56021] = "Invalid parameters";
  StockCommonErrorMsg[SHARE_ERROR_56022] = "Read security from fpga failed";
  StockCommonErrorMsg[SHARE_ERROR_56023] = "Check current position failed";
  StockCommonErrorMsg[SHARE_ERROR_56024] = "Write security to fpga failed";
  StockCommonErrorMsg[SHARE_ERROR_56025] = "Get KCBP CODE failed";
  StockCommonErrorMsg[SHARE_ERROR_56026] = "Update fpga position failed";
  StockCommonErrorMsg[SHARE_ERROR_56027] = "Error InoutDirection";
  StockCommonErrorMsg[SHARE_ERROR_56028] = "Unkown error";
  StockCommonErrorMsg[SHARE_ERROR_56029] = "Do not find node config";
  StockCommonErrorMsg[SHARE_ERROR_56030] = "Interface not open";
  StockCommonErrorMsg[SHARE_ERROR_56031] = "Spx init failed";
  StockCommonErrorMsg[SHARE_ERROR_56032] = "Spx Login failed";
  StockCommonErrorMsg[SHARE_ERROR_56033] = "Spx recv timeout";
  StockCommonErrorMsg[SHARE_ERROR_56050] = "Update fpga failed,rollback failed";

  StockCommonErrorMsg[SHARE_ERROR_60000] = "OK";
  StockCommonErrorMsg[SHARE_ERROR_60001] = "Contract restricts buy";
  StockCommonErrorMsg[SHARE_ERROR_60002] = "Contract restricts sell";
  StockCommonErrorMsg[SHARE_ERROR_60003] = "Contract restricts short selling";
  StockCommonErrorMsg[SHARE_ERROR_60004] = "Not support";
  StockCommonErrorMsg[SHARE_ERROR_60005] = "Cross market scanning not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60006] = "Market orders not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60007] = "Price out of range";
  StockCommonErrorMsg[SHARE_ERROR_60008] = "Volume exceeds adv limit";
  StockCommonErrorMsg[SHARE_ERROR_60009] = "Quotation minimum error";
  StockCommonErrorMsg[SHARE_ERROR_60010] = "Single transaction volume too small";
  StockCommonErrorMsg[SHARE_ERROR_60011] = "Single transaction volume too large";
  StockCommonErrorMsg[SHARE_ERROR_60012] = "Too small Volume";
  StockCommonErrorMsg[SHARE_ERROR_60013] = "Too large Volume";
  StockCommonErrorMsg[SHARE_ERROR_60014] = "Client order id Duplicate";
  StockCommonErrorMsg[SHARE_ERROR_60015] = "Contract not found";
  StockCommonErrorMsg[SHARE_ERROR_60016] = "Illegal validity type";
  StockCommonErrorMsg[SHARE_ERROR_60017] = "System stopped trading";
  StockCommonErrorMsg[SHARE_ERROR_60018] = "System restricts to trade";
  StockCommonErrorMsg[SHARE_ERROR_60019] = "Accumulated trading volume of the day too large";
  StockCommonErrorMsg[SHARE_ERROR_60020] = "No loan broker logo";
  StockCommonErrorMsg[SHARE_ERROR_60021] = "Order too fast";
  StockCommonErrorMsg[SHARE_ERROR_60022] = "Order address conflict";
  StockCommonErrorMsg[SHARE_ERROR_60023] = "Illegal OrderType";
  StockCommonErrorMsg[SHARE_ERROR_60024] = "Illegal order direction";
  StockCommonErrorMsg[SHARE_ERROR_60025] = "IPO transaction not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60026] = "Unsettled orders too many";
  StockCommonErrorMsg[SHARE_ERROR_60027] = "Incorrect business scope";
  StockCommonErrorMsg[SHARE_ERROR_60028] = "Short selling with guarantee not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60029] = "Wrong minimum price unit";
  StockCommonErrorMsg[SHARE_ERROR_60030] = "Wrong minimum lot unit";
  StockCommonErrorMsg[SHARE_ERROR_60031] = "Order not match or Order full";
  StockCommonErrorMsg[SHARE_ERROR_60032] = "Missing field";
  StockCommonErrorMsg[SHARE_ERROR_60033] = "System timeout";
  StockCommonErrorMsg[SHARE_ERROR_60034] = "Field error";
  StockCommonErrorMsg[SHARE_ERROR_60035] = "Change order to increase not allow,to decrease allowed";
  StockCommonErrorMsg[SHARE_ERROR_60036] = "Agency to buy not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60037] = "Agency to sell not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60038] = "Agency to short selling not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60039] = "Self buy not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60040] = "Self sell not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60041] = "Self short selling not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60042] = "Restrict to buy";
  StockCommonErrorMsg[SHARE_ERROR_60043] = "Restrict to sell";
  StockCommonErrorMsg[SHARE_ERROR_60044] = "Short sellling not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60045] = "Buy direction accumulated excess";
  StockCommonErrorMsg[SHARE_ERROR_60046] = "Sell direction accumulated excess";
  StockCommonErrorMsg[SHARE_ERROR_60047] = "Sell exceeds position";
  StockCommonErrorMsg[SHARE_ERROR_60048] = "Short selling exceeds borrowing";
  StockCommonErrorMsg[SHARE_ERROR_60049] = "Unanswered order";
  StockCommonErrorMsg[SHARE_ERROR_60050] = "SAMSN refused";
  StockCommonErrorMsg[SHARE_ERROR_60051] = "VENUE busy";
  StockCommonErrorMsg[SHARE_ERROR_60052] = "Contract unsettled and buy order exceeds the upper limit";
  StockCommonErrorMsg[SHARE_ERROR_60053] = "Contract unsettled and sell order exceeds the upper limit";
  StockCommonErrorMsg[SHARE_ERROR_60054] = "Modified contract not match";
  StockCommonErrorMsg[SHARE_ERROR_60055] = "Order not exist";
  StockCommonErrorMsg[SHARE_ERROR_60056] = "Order search timeout";
  StockCommonErrorMsg[SHARE_ERROR_60057] = "Change of capital account";
  StockCommonErrorMsg[SHARE_ERROR_60058] = "Quantity error";
  StockCommonErrorMsg[SHARE_ERROR_60059] = "Contract positions too large";
  StockCommonErrorMsg[SHARE_ERROR_60060] = "Exceeding the buying limit";
  StockCommonErrorMsg[SHARE_ERROR_60061] = "Holding short position of the contract too large";
  StockCommonErrorMsg[SHARE_ERROR_60062] = "Sold lot greater than sellable lot";
  StockCommonErrorMsg[SHARE_ERROR_60063] = "Sellable  quantity not enough";
  StockCommonErrorMsg[SHARE_ERROR_60064] = "Account balance is insufficient";
  StockCommonErrorMsg[SHARE_ERROR_60065] = "Ratio of margin occupying capital too large";
  StockCommonErrorMsg[SHARE_ERROR_60066] = "Cancel order not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60067] = "Customer order ID and login ID  Inconsistent";
  StockCommonErrorMsg[SHARE_ERROR_60068] = "Wrong format of order price";
  StockCommonErrorMsg[SHARE_ERROR_60069] = "Order price conditions field  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60070] = "Condition of buy and sell direction field  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60071] = "Order field  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60072] = "Order speculative hedging mark field  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60073] = "Order period of validity type field  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60074] = "Order operation flag field  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60075] = "Number of order on the way too large";
  StockCommonErrorMsg[SHARE_ERROR_60076] = "System overload:qdr full";
  StockCommonErrorMsg[SHARE_ERROR_60077] = "System overload:ddr full";
  StockCommonErrorMsg[SHARE_ERROR_60078] = "Order speculative hedging mark inconsistent with customer transaction type";
  StockCommonErrorMsg[SHARE_ERROR_60079] = "Flow control reach upper limit";
  StockCommonErrorMsg[SHARE_ERROR_60080] = "Flow control reach upper limit";
  StockCommonErrorMsg[SHARE_ERROR_60081] = "Flow control reach upper limit";
  StockCommonErrorMsg[SHARE_ERROR_60082] = "Client not logged in";
  StockCommonErrorMsg[SHARE_ERROR_60083] = "Duplicate cancel";
  StockCommonErrorMsg[SHARE_ERROR_60084] = "Self closing order refused";
  StockCommonErrorMsg[SHARE_ERROR_60085] = "Forced Liquidation order cannot be cancelled by API";
  StockCommonErrorMsg[SHARE_ERROR_60086] = "Order has been withdrawn";
  StockCommonErrorMsg[SHARE_ERROR_60087] = "Order exceeding limit";
  StockCommonErrorMsg[SHARE_ERROR_60088] = "Contract format error";
  StockCommonErrorMsg[SHARE_ERROR_60089] = "Transaction type  not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60090] = "Trigger conditions not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60091] = "Reasons for Liquidation order not in the range of enumeration";
  StockCommonErrorMsg[SHARE_ERROR_60092] = "Orders lot less than the minimum lot of transactions";
  StockCommonErrorMsg[SHARE_ERROR_60093] = "Flow control reach upper limit";
  StockCommonErrorMsg[SHARE_ERROR_60094] = "Exchange front not ready";
  StockCommonErrorMsg[SHARE_ERROR_60095] = "Exchange front error";
  StockCommonErrorMsg[SHARE_ERROR_60096] = "Open position disallowed";
  StockCommonErrorMsg[SHARE_ERROR_60097] = "Futures FOK order not allowed";
  StockCommonErrorMsg[SHARE_ERROR_60098] = "IAS format error";
  StockCommonErrorMsg[SHARE_ERROR_60099] = "Open position in delivery month disallowed";
  StockCommonErrorMsg[SHARE_ERROR_60100] = "Trading not allowed without login";
  StockCommonErrorMsg[SHARE_ERROR_60101] = "System overload";
  StockCommonErrorMsg[SHARE_ERROR_60102] = "Total bought amount reach the limit";
  StockCommonErrorMsg[SHARE_ERROR_60103] = "Total bought underlying position reach the limit";
  StockCommonErrorMsg[SHARE_ERROR_60104] = "Total today bought underlying position reach the limit";
  StockCommonErrorMsg[SHARE_ERROR_60105] = "Total underlying position reach the limit";
  StockCommonErrorMsg[SHARE_ERROR_60106] = "Self trade is forbidden";
  StockCommonErrorMsg[SHARE_ERROR_60107] = "Trigger price deviation risk";
  StockCommonErrorMsg[SHARE_ERROR_60108] = "Today sell limit";
  StockCommonErrorMsg[SHARE_ERROR_60109] = "Order not allowed withdraw";
  StockCommonErrorMsg[SHARE_ERROR_60110] = "Order insert only one time";
  StockCommonErrorMsg[SHARE_ERROR_60111] = "SecurityType wrong";
  StockCommonErrorMsg[SHARE_ERROR_60113] = "Current balance too larger";
  StockCommonErrorMsg[SHARE_ERROR_60114] = "Tag41_value_mistach";
  StockCommonErrorMsg[SHARE_ERROR_60115] = "Tag1_value_mistach";
  StockCommonErrorMsg[SHARE_ERROR_60116] = "Software trading gateway is unavailable";
  StockCommonErrorMsg[SHARE_ERROR_60200] = "Wrong identification field";
  StockCommonErrorMsg[SHARE_ERROR_60201] = "Message_id not in range";
  StockCommonErrorMsg[SHARE_ERROR_60202] = "Wrong message_len";
  StockCommonErrorMsg[SHARE_ERROR_60203] = "OrderID less than maxorderid or out of range";
  StockCommonErrorMsg[SHARE_ERROR_60204] = "Wrong Direction";
  StockCommonErrorMsg[SHARE_ERROR_60205] = "Positioneffect not in range";
  StockCommonErrorMsg[SHARE_ERROR_60206] = "Price out of system limit";
  StockCommonErrorMsg[SHARE_ERROR_60207] = "Wrong OrderType";
  StockCommonErrorMsg[SHARE_ERROR_60208] = "Wrong TimeCondition";
  StockCommonErrorMsg[SHARE_ERROR_60209] = "Wrong UDP check";
  StockCommonErrorMsg[SHARE_ERROR_60210] = "Wrong User token";
  StockCommonErrorMsg[SHARE_ERROR_60211] = "User not login";
  StockCommonErrorMsg[SHARE_ERROR_60212] = "Web order not allow api to cancel the order";
  StockCommonErrorMsg[SHARE_ERROR_60213] = "Order price cannot be greater than 10000";
  StockCommonErrorMsg[SHARE_ERROR_60214] = "Order Id prefix err";
  StockCommonErrorMsg[SHARE_ERROR_60215] = "Order Id number err";
  StockCommonErrorMsg[SHARE_ERROR_60216] = "Tcp Session Error";
  StockCommonErrorMsg[SHARE_ERROR_60217] = "UserLocalId too large, more than 2176782335";
  StockCommonErrorMsg[SHARE_ERROR_60218] = "OrigSysID is out of number range";
  StockCommonErrorMsg[SHARE_ERROR_60219] = "Can't Cancel Order by OrigUserLocalId";
  StockCommonErrorMsg[SHARE_ERROR_60220] = "Order resource is exhausted";
  StockCommonErrorMsg[SHARE_ERROR_60221] = "Order Price cannot be less than 0";
  StockCommonErrorMsg[SHARE_ERROR_60222] = "Account mismatch";
  StockCommonErrorMsg[SHARE_ERROR_60223] = "Illegal HandlInst";
  StockCommonErrorMsg[SHARE_ERROR_60225] = "Creation disallowed";
  StockCommonErrorMsg[SHARE_ERROR_60226] = "Redemption disallowed";
  StockCommonErrorMsg[SHARE_ERROR_60227] = "Creation component insufficient";
  StockCommonErrorMsg[SHARE_ERROR_60228] = "Redemption component position too large";
  StockCommonErrorMsg[SHARE_ERROR_60229] = "Substitution ratio of ETF creation cash exceeds limit";
  StockCommonErrorMsg[SHARE_ERROR_60230] = "Reversed trade disallowed";
  StockCommonErrorMsg[SHARE_ERROR_60231] = "Creation redemption resource exhausted";
  StockCommonErrorMsg[SHARE_ERROR_60232] = "Cross market full physical etf error";
  StockCommonErrorMsg[SHARE_ERROR_60233] = "Etf fund market error";
  StockCommonErrorMsg[SHARE_ERROR_60234] = "RTGS available amount insufficient";
  StockCommonErrorMsg[SHARE_ERROR_60240] = "Trigger frequent instant order cancellations risk";
  StockCommonErrorMsg[SHARE_ERROR_60241] = "Trigger order cancellation rate limit risk";
  StockCommonErrorMsg[SHARE_ERROR_60242] = "Trigger daily limit on the number of order cancellations risk";
  StockCommonErrorMsg[SHARE_ERROR_64001] = "Tag has empty value";
  StockCommonErrorMsg[SHARE_ERROR_64002] = "Invalid data format for value";
  StockCommonErrorMsg[SHARE_ERROR_64003] = "Required tag missing";
  StockCommonErrorMsg[SHARE_ERROR_64004] = "Duplicate tag";
  StockCommonErrorMsg[SHARE_ERROR_64005] = "Tag undefined for this message";
  StockCommonErrorMsg[SHARE_ERROR_64006] = "Only buy or sell orders supported";
  StockCommonErrorMsg[SHARE_ERROR_64007] = "Only limit or market supported";
  StockCommonErrorMsg[SHARE_ERROR_64008] = "Unsupported message type";
  StockCommonErrorMsg[SHARE_ERROR_64009] = "Packet 2k bytes max";
  StockCommonErrorMsg[SHARE_ERROR_64010] = "Extracted fields 32 chars max";
  StockCommonErrorMsg[SHARE_ERROR_64011] = "Symbol is not 6 chars";
  StockCommonErrorMsg[SHARE_ERROR_64012] = "Message format error";
  StockCommonErrorMsg[SHARE_ERROR_64013] = "Unknown reason";
  StockCommonErrorMsg[SHARE_ERROR_64014] = "CompID mismatch";
  StockCommonErrorMsg[SHARE_ERROR_64015] = "TargetCompID mismatch";
  StockCommonErrorMsg[SHARE_ERROR_64016] = "Invalid BeginSeqNum";
  StockCommonErrorMsg[SHARE_ERROR_64017] = "Tag1 over 12 chars";
  StockCommonErrorMsg[SHARE_ERROR_64018] = "Zxzq tag37 is over 10 chars";
  StockCommonErrorMsg[SHARE_ERROR_64019] = "Invalid EndSeqNum";
  StockCommonErrorMsg[SHARE_ERROR_64020] = "Market mismatch";
  StockCommonErrorMsg[SHARE_ERROR_64021] = "Unsupport tag43=Y";
  StockCommonErrorMsg[SHARE_ERROR_64022] = "Seqnum discontinuity";
  StockCommonErrorMsg[SHARE_ERROR_64023] = "Not login";
  StockCommonErrorMsg[SHARE_ERROR_64024] = "Tag11 over 5 chars";

  return CheckAndResetInitResult();
}   // NOLINT

int ApiErrorMsg::CheckAndResetInitResult() {
  for(int i = SS_STOCK_ERROR_0; i < SS_STOCK_ERROR_END;i++){
    if(SSStockErrorMsg[i] && strlen(SSStockErrorMsg[i]) > ERROR_MSG_MAX_LENGTH){
      char* tmpArray = (char *)malloc(ERROR_MSG_DEFAULT_LENGTH);
      if (tmpArray == nullptr) {
        printf("SS_STOCK_ERROR_END CheckAndResetInitResult malloc failed!\n");
        return -1;
      }
      memset(tmpArray,'\0',ERROR_MSG_DEFAULT_LENGTH);
      memcpy(tmpArray,SSStockErrorMsg[i],ERROR_MSG_DEFAULT_LENGTH - 1);
      SSStockErrorMsg[i] = tmpArray;
    }
  }
  for(int i = SZSE_ERR_CODE_START; i < SZSE_ERR_CODE_END;i++){
    if(SZSEErrorMsg[i] && strlen(SZSEErrorMsg[i]) > ERROR_MSG_MAX_LENGTH){
      char* tmpArray = (char *)malloc(ERROR_MSG_DEFAULT_LENGTH);
      if (tmpArray == nullptr) {
        printf("SZSE_ERR_CODE_END CheckAndResetInitResult malloc failed!\n");
        return -1;
      }
      memset(tmpArray,'\0',ERROR_MSG_DEFAULT_LENGTH);
      memcpy(tmpArray,SZSEErrorMsg[i],ERROR_MSG_DEFAULT_LENGTH - 1);
      SZSEErrorMsg[i] = tmpArray;
    }
  }

  return 0;
}

const char* ApiErrorMsg::ParseSSStock(unsigned int error_code, char *market) {
  if(!SSStockErrorMsg[SS_STOCK_ERROR_202])
    Init();
  if(error_code < SS_STOCK_ERROR_0 || error_code >= SS_STOCK_ERROR_END)
    return nullptr;
  const char *errmsg = SSStockErrorMsg[error_code];
  if (!errmsg) {
    errmsg = ApiErrorMsg::ParseStockCommon(error_code);
  }
  return errmsg;
}

const char* ApiErrorMsg::ParseSZSE(unsigned int error_code, char *market) {
  if(!SZSEErrorMsg[SZSE_ERR_CODE_20001])
    Init();
  if(error_code < SZSE_ERR_CODE_START || error_code >= SZSE_ERR_CODE_END) {
    return nullptr;
  }
  const char *errmsg = SZSEErrorMsg[error_code];
  if (!errmsg) {
    errmsg = ApiErrorMsg::ParseStockCommon(error_code);
  }
  return errmsg;
}

const char* ApiErrorMsg::ParseManager(unsigned int error_code, char *market) {
  if(!XeleManagerErrorMsg[SHARE_ERROR_55002])
    Init();
  if(error_code < SHARE_NO_ERROR || error_code >= SHARE_OTHERS){
    return nullptr;
  }
  const char *errmsg = XeleManagerErrorMsg[error_code];
  if (!errmsg) {
    errmsg = ApiErrorMsg::ParseStockCommon(error_code);
  }
  return errmsg;
}

const char *ApiErrorMsg::ParseMsg(unsigned int error_code, char *market) {
  if (error_code == 0) {
    return "OK";
  }
  const char *errmsg;
  if (market && *market == SH_STOCK) {
    errmsg = ApiErrorMsg::ParseSSStock(error_code, market);
  } else if (market && *market == SZ_STOCK){
    errmsg = ApiErrorMsg::ParseSZSE(error_code, market);
  } else{
    errmsg = ApiErrorMsg::ParseManager(error_code,market);
  }
  if (errmsg == nullptr){
    printf("errid[%u] not defined\n",error_code);
    return "check out the Api documentation";
  }
  else
    return errmsg;
}
const char *ApiErrorMsg::ParseStockCommon(unsigned int error_code) {
  if (!StockCommonErrorMsg[SHARE_NO_ERROR])
    Init();
  if (error_code < SHARE_NO_ERROR || error_code >= SHARE_OTHERS) {
    return nullptr;
  }
  return StockCommonErrorMsg[error_code];
}
