## API返回错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| API | 0   | 正确  |     | OK  |     |
| API | 1   | 调用login之前，未调用registerSpi接口 |     | not registerSpi |     |
| API | 2   | 当前正在处理登录请求 |     | api login in process |     |
| API | 3   | OrderWarm参数填写错误，可填值为1或0 |     | OrderWarm param illegal, check fail |     |
| API | 4   | 绑核参数校验失败，可能绑核参数超出了系统可绑核数,此种情况下默认不绑核 |     | coreNum param check fail |     |
| API | 5   | socket是否阻塞参数校验错误，应该在0和1中选择 |     | socket is block or not, check error |     |
| API | 6   | SoftRspRcv参数填写错误，可填值为1或0 |     | SoftRspRcv param illegal, check fail |     |
| API | 7   | 资金账号长度校验失败，可能没加结束符('\\0')或者长度超过柜台限制 |     | AccountID length check error |     |
| API | 8   | 账号密码长度校验失败，可能没加结束符('\\0')或者长度超过柜台限制 |     | Password length check error |     |
| API | 9   | url参数校验失败，可能参数格式错误 |     | url check error |     |
| API | 10  | 艾科管理中心回报线程创建失败，解决问题后需要重启Api |     | pthread_create fail, manager query tcp rsp thread |     |
| API | 11  | 艾科柜台查询回报线程创建失败，解决问题后需要重启Api |     | pthread_create fail, manager and counter query tcp rsp thread |     |
| API | 12  | 艾科管理中心Tcp连接失败,可能是URL参数地址错误 |     | manager tcp connect refuse |     |
| API | 13  | 回报中校验Api状态时发生错误，需要重启Api |     | api_status check error,please restart api |     |
| API | 14  | 艾科柜台查询Tcp连接失败,可能是URL参数地址错误) |     | query tcp connect refuse |     |
| API | 15  | 交易链路地址获取失败，艾科系统发生异常，需要根据具体情况进行检查 |     | trade ip or trade port empty |     |
| API | 16  | 交易链路连接失败，可以登出后再次调用登录接口 |     | trade tcp connect refuse |     |
| API | 17  | 建立交易链路失败，当前无法进行报撤单操作 |     | init trade failed |     |
| API | 18  | 当前节点没有交易权限，检查配置文件节点权限 |     | no free toe_session |     |
| API | 19  | 期权流水重构失败，可以通过重启Api或者重新登录再次进行尝试 |     | flow rebuild failed |     |
| API | 20  | 批量报单类型错误，目前支持‘1’(等量拆单),‘2’(递减拆单),‘3’(多证券委托组合) |     | input batch type error |     |
| API | 21  | Api运行模式参数校验失败，检查参数 |     | ApiMode param illegal, check fail |     |
| API | 22  | Api正在登录中，可能是上次的连接未处理结束，正在连接尝试 |     | api is logining |     |
| API | 23  | 是否详细打印日志参数校验失败，检查参数 |     | SuperLog param illegal, check fail |     |
| API | 24  | 发送建立交易链路请求失败，可能网络配置问题，检查相关配置 |     | req create trader tcp fail |     |
| API | 25  | 发送建立交易链路消息失败，可能由于网络问题，可以重新尝试一次 |     | send init trader message fail |     |
| API | 26  | 一般是由于配置文件中该字段填写格式错误导致（填写的版本号非Api支持的版本） |     | DependentCounterVersion param illegal, check fail |     |
| API | 27  | 多manager地址格式校验错误 |     | Manager URL Check Fail |     |
| API | 28  | 没有有效URL地址 |     | no valid URL |     |
| API | 29  | 多证券批量报单时，BatchOrderQty字段填写错误，不是实际报单量 |     | batch muilt order volumn check error |     |
| API | 30  | 多证券批量报单数量太大，目前支持一次100单 |     | BatchOrderQty value too large |     |
| API | 31  | 柜台交易链路线程创建失败 |     | pthread_create fail,counter trade tcp rsp thread |     |
| API | 32  | 地址格式校验错误 |     | Query URL Check Fail |     |
| API | 33  | 地址格式校验错误 |     | Trade URL Check Fail |     |
| API | 34  | 内部校验错,需要重启api |     | check fail,please restart api |     |
| API | 35  | 管理链路tcp建立失败 |     | manager tcp not connect |     |
| API | 36  | 查询链路tcp建立失败 |     | query tcp not connect |     |
| API | 37  | api未登录 |     | api not login |     |
| API | 38  | Api是否使用rtnTrade报文构造rtnOrder报文参数校验失败，检查参数 |     | CreateRtnOrderByRtnTrade param illegal, check fail |     |
| API | 39  | AutoReLogin 参数校验失败，可填值为0或1 |     | AutoReLogin param check fail |     |
| API | 40  | LoopRepeatConnect 参数校验失败，可填值为0或1 |     | LoopRepeatConnect param check fail |     |
| API | 41  | RecvSendDetach 参数校验失败，可填值为0或1 |     | RecvSendDetach param check fail |     |
| API | 42  | 通用接口线程创建失败 |     | common func thread create fail |     |
| API | 43  | api版本号校验失败 |     | api version compare failed |     |
| API | 44  | Api已经登录, 不允许重复登录 |     | api already logged |     |
| API | 45  | 是否捕获异常参数校验失败，检查参数 |     | CaptureSignal param illegal, check fail |     |
| API | 46  | 字段长度超过128个字节，确认后重新填写 |     | SuperviseExtraInfo too long, more than 128 |     |
| API | 47  | 字段长度超过384个字节，确认后重新填写 |     | AllSuperviseInfo too long, more then 384 |     |
| API | 48  | FpgaRspRcv参数填写错误，可填值为'1'或'0' |     | FpgaRspRcv param illegal, check fail |     |
| API | 49  | RecvSendDetach参数填写错误，可填值为1或0 |     | RecvSendDetach param illegal, check fail |     |
| API | 50  | CaptureSignal参数填写错误，可填值为1或0 |     | CaptureSignal param illegal, check fail |     |
| API | 51  | AutoReLogin参数填写错误，可填值为1或0 |     | AutoReLogin param illegal, check fail |     |
| API | 52  | LoopRepeatConnect参数填写错误，可填值为1或0 |     | LoopRepeatConnect param illegal, check fail |     |
| API | 53  | OpenEncryption参数填写错误，可填值为1或0 |     | OpenEncryption param illegal, check fail |     |
| API | 54  | 获取硬盘序列号错误 |     | Get hard disk serial fail |     |

## XELE股票柜台错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| TRADE | 55002 | 数据未填写 |     | Empty filled information |     |
| TRADE | 55003 | 上次查询未结束 |     | Last query did not end |     |
| TRADE | 55004 | 上交柜台连接失败 |     | SS counter connect fail |     |
| TRADE | 55005 | 口令错误 |     | Wrong password |     |
| TRADE | 55007 | 用户已登录 |     | User already logined |     |
| TRADE | 55011 | 市场类别错误 |     | Wrong Market |     |
| TRADE | 55014 | 用户尚未登录 |     | User not login |     |
| TRADE | 55015 | 系统内存不足 |     | System Memory Not Enough |     |
| TRADE | 55016 | 错误的资金账号 |     | Wrong AccountID |     |
| TRADE | 55020 | 非双边账户，场景不支持 |     | Non double investor, this feature is not supported |     |
| TRADE | 55021 | 不合法的密码 |     | Illegal password |     |
| TRADE | 55031 | 错误的授权码 |     | Wrong AuthCode |     |
| TRADE | 55033 | 登录子客户端索引错误 |     | Login sub client index wrong |     |
| TRADE | 55037 | 资金账号不存在 |     | AccountID not exist |     |
| TRADE | 55038 | token错误 |     | Wrong token |     |
| TRADE | 55039 | 报单序号不是连续增加 |     | The order number not increases monotonically |     |
| TRADE | 55040 | 被撤单找不到 |     | Cancelled order not found |     |
| TRADE | 55041 | 内部进程间消息发送失败 |     | Interactive msg send failed |     |
| TRADE | 55042 | STEP 信息编码失败 |     | STEP message encoded failed |     |
| TRADE | 55043 | 插入数据库失败 |     | Failed to insert into database |     |
| TRADE | 55044 | 重复登录 |     | Duplicate login |     |
| TRADE | 55045 | 柜台导上场数据初始化未完成 |     | Initialization of settlement data not completed |     |
| TRADE | 55046 | 查询过快 |     | Query too fast |     |
| TRADE | 55047 | 无相关记录 |     | No relevant records |     |
| TRADE | 55048 | 登录超时 |     | Login timeout |     |
| TRADE | 55049 | 该用户已经在其他链路登录 |     | User has logged in on another link |     |
| TRADE | 55050 | api版本错误 |     | Wrong API version |     |
| TRADE | 55052 | 接口未开启 |     | Interface not open |     |
| TRADE | 55053 | 错误的时间格式 |     | Wrong time format |     |
| TRADE | 55054 | 号段用尽或未配置号段 |     | Number segment run out or not configured |     |
| TRADE | 55055 | 集中交易操作失败 |     | Central trading operation failed |     |
| TRADE | 55056 | 用户登录ip检查失败 |     | User login ip check failed |     |
| TRADE | 55057 | 用户登录mac地址检查失败 |     | User login mac address check failed |     |
| TRADE | 55058 | 转移失败 |     | Failed to transfer |     |
| TRADE | 55059 | 集中交易授权失败 |     | Central trading authentication failed |     |
| TRADE | 55060 | 连接headquarter错误 |     | failed to connect to headquarter |     |
| TRADE | 55061 | 资金不能小于等于零 |     | Capital cannot be less than or equal to zero |     |
| TRADE | 55062 | 系统id错误 |     | Wrong system_id |     |
| TRADE | 55063 | 登录太快 |     | Login too fast |     |
| TRADE | 55064 | 仓位检查错误 |     | Position check failed |     |
| TRADE | 55065 | 组合策略类型错误 |     | Wrong comb strategy type |     |
| TRADE | 55067 | Zmq通信错误 |     | zmq failed |     |
| TRADE | 55068 | 已经有其他帐户登录到当前链接 |     | Another account has already logged in this link |     |
| TRADE | 55069 | 发送到交易所失败 |     | Send to Exchange Failed |     |
| TRADE | 55070 | 号码范围已用完 |     | Number range is exhausted |     |
| TRADE | 55071 | 柜台正在数据恢复，等待完成 |     | XeleTrade is recoverying, wait to be finished... |     |
| TRADE | 55072 | 取消其他账户订单 |     | Cancel other account order |     |
| TRADE | 55073 | 重建失败 |     | Rebuild Failed |     |
| TRADE | 55074 | Xele-Bot登录超时 |     | Xele-Bot login timeout |     |
| TRADE | 55075 | TransfereePbuID为空 |     | TransfereePbuID is null |     |
| TRADE | 55076 | 号段结束值为空 |     | Number range end is null |     |
| TRADE | 55077 | 转托管号段结束值为空 |     | Number range redeposite_end is null |     |
| TRADE | 55078 | 没有配置非交易tgw通道 |     | Do not have non-trade tgw session |     |
| TRADE | 55079 | ClOrdID超过号段范围 |     | ClOrdID large than number range |     |
| TRADE | 55080 | Order_sys_id长度错误 |     | Order_sys_id length error |     |
| TRADE | 55081 | 订单发送错误 |     | DropOrder send err |     |
| TRADE | 55082 | 在转托管表中未找到clordid |     | Do not find clOrdID in table redeposite |     |
| TRADE | 55083 | 非交易链路未登录 |     | Do not logon non-trade link |     |
| TRADE | 55084 | 强制撤单（正报单没发往交易所，被强制撤单） |     | Forced cancellation |     |
| TRADE | 55085 | Operway检查失败 |     | Operway check fail |     |
| TRADE | 55086 | Api监管信息检测失败 |     | Api supervise information check fail |     |
| TRADE | 55087 | 资金过大 |     | Capital is too large |     |
| TRADE | 55088 | Api自动重连校验失败 |     | Api reconnect TradingDay compare failed |     |
| TRADE | 55089 | 交易日尚未从柜台同步 |     | Tradingday not sync from trade yet |     |
| TRADE | 55090 | 合约未找到 |     | Contract not found |     |
| TRADE | 55091 | 持仓划拨失败 |     | Api position transfer failed |     |
| TRADE | 55092 | 软件报单速率过快 |     | Soft order too fast |     |
| TRADE | 55093 | 查询链路地址为空 |     | query url is empty |     |
| TRADE | 55094 | 输入的数量小于0 |     | volume is less than zero |     |
| TRADE | 55095 | 风控类别错误 |     | risk control type error |     |
| TRADE | 55096 | 报单发送到交易所失败 |     | order send to exchange fail |     |
| TRADE | 55097 | 交易网关连接断开 |     | Trading gateWay disconnected |     |
| TRADE | 55098 | 交易所已关闭 |     | Exchange closed |     |
| TRADE | 55099 | 无效证券代码 |     | Invalid SecurityID |     |
| TRADE | 55100 | 可备兑锁定持仓不足 |     | Insufficient available cover lock positions |     |
| TRADE | 55101 | 备兑锁定持仓不足 |     | Insufficient cover lock positions |     |
| TRADE | 55102 | 柜台未初始化完成 |     | Counter not initialized completed |     |
| TRADE | 55103 | InOutDirection无效 |     | Invalid InOutDirection |     |
| TRADE | 55104 | Volume无效 |     | Invalid Volume |     |
| TRADE | 55105 | 发送给manager失败 |     | Send msg to manager failed |     |
| TRADE | 55106 | 等待消息超时 |     | Wait rsp msg timeout |     |
| TRADE | 55107 | 文件锁操作失败 |     | fileLock operate fail |     |
| TRADE | 55108 | 检查当前资金失败 |     | check current fund fail |     |
| TRADE | 55109 | 从fpga获取历史资金错误 |     | read old fund from fpga fail |     |
| TRADE | 55110 | 设置新的资金到fpga错误 |     | set new fund to fpga fail |     |
| TRADE | 55111 | 集中交易返回超时 |     | Central trading response timeout |     |
| TRADE | 55112 | 申赎超时 |     | Creation or redemption time error. |     |
| TRADE | 55113 | 上交柜台连接失败 |     | SS counter connect fail |     |
| TRADE | 55114 | 深交柜台连接失败 |     | SZ counter connect fail |     |
| TRADE | 55115 | 可用资金不足 |     | Insufficient available funds |     |
| TRADE | 56000 | 功能号错误 |     | Wrong functionID |     |
| TRADE | 56001 | 资金小于或等于0 |     | Occur amount less than or equal to zero |     |
| TRADE | 56002 | 集中服务环境初始化失败 |     | Centralized server init failed |     |
| TRADE | 56003 | 设置连接参数失败 |     | Set connection option failed |     |
| TRADE | 56004 | 设置超时失败 |     | Set timeout failed |     |
| TRADE | 56005 | 连接集中服务失败 |     | Centralized server connect failed |     |
| TRADE | 56006 | 设置系统参数失败 |     | Set system param failed |     |
| TRADE | 56007 | CODE获取失败 |     | Get CODE Fail |     |
| TRADE | 56008 | 发送消息到xxload失败 |     | Send msg to xxload failed |     |
| TRADE | 56009 | 更新fpga资金失败 |     | Update fpga account failed |     |
| TRADE | 56010 | 请求数量为0 |     | Req count is zero |     |
| TRADE | 56011 | 发送ufx功能ID失败 |     | Send ufx function id failed |     |
| TRADE | 56012 | 获取集中响应超时 |     | Get Centralized server rsp timeout |     |
| TRADE | 56013 | 未发送响应数据 |     | Do not find rsp data |     |
| TRADE | 56014 | 集中柜台响应解析失败 |     | Centralized counter rsp prase failed |     |
| TRADE | 56015 | 业务操作失败 |     | Business operation failed |     |
| TRADE | 56016 | 等待响应超时 |     | Wait rsp time out |     |
| TRADE | 56017 | 未知状态，请检查xxload日志 |     | Unkown status! please check xxLoad log |     |
| TRADE | 56018 | 用户未登陆集中柜台，交易密码为空 |     | User do not login trade center, trade pwd is null |     |
| TRADE | 56019 | Custid为NULL |     | Custid is null" |     |
| TRADE | 56020 | 连接集中服务失败 |     | Connect trade center server failed |     |
| TRADE | 56021 | 无效参数 |     | Invalid parameters |     |
| TRADE | 56022 | 读fpga合约表失败 |     | Read security from fpga failed |     |
| TRADE | 56023 | 检查当前持仓失败 |     | Check current position failed |     |
| TRADE | 56024 | 写入fpga合约表失败 |     | Write security to fpga failed |     |
| TRADE | 56025 | 获取KCBP节点号失败 |     | Get KCBP CODE failed |     |
| TRADE | 56026 | 更新fpga持仓失败 |     | Update fpga position failed |     |
| TRADE | 56027 | InoutDirection错误 |     | Error InoutDirection |     |
| TRADE | 56028 | 未知错误 |     | Unkown error |     |
| TRADE | 56029 | 未发现节点配置 |     | Do not find node config |     |
| TRADE | 56030 | 接口未开放 |     | Interface not open |     |
| TRADE | 56031 | Spx初始化失败 |     | Spx init failed |     |
| TRADE | 56032 | Spx登陆失败 |     | Spx Login failed |     |
| TRADE | 56033 | Spx接收超时 |     | Spx recv timeout |     |
| TRADE | 56034 | 此资金账户无转托管权限 |     | Not have the redeposite right |     |
| TRADE | 56050 | 更新fpga失败，回滚失败 |     | Update fpga failed,rollback failed |     |
| TRADE | 60000 | 正确  |     | OK  |     |
| TRADE | 60001 | 该合约限制买入 |     | Contract restricts buy |     |
| TRADE | 60002 | 该合约限制卖出 |     | Contract restricts sell |     |
| TRADE | 60003 | 该合约限制卖空 |     | Contract restricts short selling |     |
| TRADE | 60004 | 不支持 |     | Not support |     |
| TRADE | 60005 | 不允许跨市扫货单 |     | Cross market scanning not allowed |     |
| TRADE | 60006 | 不允许市价单 |     | Market orders not allowed |     |
| TRADE | 60007 | 价格超出范围 |     | Price out of range |     |
| TRADE | 60008 | 单笔手数超过ADV限制 |     | Volume exceeds adv limit |     |
| TRADE | 60009 | 报价最小值错误 |     | Quotation minimum error |     |
| TRADE | 60010 | 单笔交易额过小 |     | Single transaction volume too small |     |
| TRADE | 60011 | 单笔交易额过大 |     | Single transaction volume too large |     |
| TRADE | 60012 | 单笔手数过小 |     | Too small Volume |     |
| TRADE | 60013 | 单笔手数过大 |     | Too large Volume |     |
| TRADE | 60014 | 当日用户报单ID重复 |     | Client order id Duplicate |     |
| TRADE | 60015 | 没找到合约 |     | Contract not found |     |
| TRADE | 60016 | 不合法的有效期类型 |     | Illegal validity type |     |
| TRADE | 60017 | XeleTrade停止交易 |     | System stopped trading |     |
| TRADE | 60018 | XeleTrade限制交易 |     | System restricts to trade |     |
| TRADE | 60019 | 当日累计交易额过大 |     | Accumulated trading volume of the day too large |     |
| TRADE | 60020 | 没有贷款经纪人标识 |     | No loan broker logo |     |
| TRADE | 60021 | 报单速率过快 |     | Order too fast |     |
| TRADE | 60022 | 报单表地址冲突 |     | Order address conflict |     |
| TRADE | 60023 | 不合法的报单类型 |     | Illegal Order Type |     |
| TRADE | 60024 | 不合法的报单方向 |     | Illegal order direction |     |
| TRADE | 60025 | 不允许IPO交易 |     | IPO transaction not allowed |     |
| TRADE | 60026 | 未成交单过多 |     | Unsettled orders too many |     |
| TRADE | 60027 | 业务范围不正确 |     | Incorrect business scope |     |
| TRADE | 60028 | 不允许有担保单的卖空 |     | Short selling with guarantee not allowed |     |
| TRADE | 60029 | 不正确的最小价格变化值 |     | Wrong minimum price unit |     |
| TRADE | 60030 | 不正确的最小手数单位 |     | Wrong minimum lot unit |     |
| TRADE | 60031 | 报单不匹配或者报单表已满 |     | Order not match or Order full |     |
| TRADE | 60032 | 缺失字段 |     | Missing field |     |
| TRADE | 60033 | 超时(合约表不存在) |     | System timeout |     |
| TRADE | 60034 | 字段错误 |     | Field error |     |
| TRADE | 60035 | 改单时不允许增加，只能减少 |     | Change order to increase not allow,to decrease allowed |     |
| TRADE | 60036 | 该机构不允许买入 |     | Agency to buy not allowed |     |
| TRADE | 60037 | 该机构不允许卖出 |     | Agency to sell not allowed |     |
| TRADE | 60038 | 该机构不允许卖空 |     | Agency to short selling not allowed |     |
| TRADE | 60039 | 不允许自营买 |     | Self buy not allowed |     |
| TRADE | 60040 | 不允许自营卖 |     | Self sell not allowed |     |
| TRADE | 60041 | 不允许自营卖空 |     | Self short selling not allowed |     |
| TRADE | 60042 | 完全不允许买 |     | Restrict to buy |     |
| TRADE | 60043 | 完全不允许卖 |     | Restrict to sell |     |
| TRADE | 60044 | 不允许卖空 |     | Short sellling not allowed |     |
| TRADE | 60045 | 当天买入方向累计超额 |     | Buy direction accumulated excess |     |
| TRADE | 60046 | 当天卖出方向累计超额 |     | Sell direction accumulated excess |     |
| TRADE | 60047 | 卖出超出持仓 |     | Sell exceeds position |     |
| TRADE | 60048 | 卖空超出借入 |     | Short selling exceeds borrowing |     |
| TRADE | 60049 | 未应答报单 |     | Unanswered order |     |
| TRADE | 60050 | SAMSN拒单 |     | SAMSN refused |     |
| TRADE | 60051 | VENUE繁忙 |     | VENUE busy |     |
| TRADE | 60052 | 该合约未成交买单超出上限 |     | Contract unsettled and buy order exceeds the upper limit |     |
| TRADE | 60053 | 该合约未成交卖单超出上限 |     | Contract unsettled and sell order exceeds the upper limit |     |
| TRADE | 60054 | 改单的合约不匹配 |     | Modified contract not match |     |
| TRADE | 60055 | 该报单不存在 |     | Order not exist |     |
| TRADE | 60056 | 报单查找表搜索超时 |     | Order search timeout |     |
| TRADE | 60057 | 资金账户变化 |     | Change of capital account |     |
| TRADE | 60058 | 数量错误 |     | Quantity error |     |
| TRADE | 60059 | 该合约持仓过多 |     | Contract positions too large |     |
| TRADE | 60060 | 该合约多头持仓过多 |     | Holding long position of the contract too large |     |
| TRADE | 60061 | 该合约空头持仓过多 |     | Holding short position of the contract too large |     |
| TRADE | 60063 | 可卖数量不足 |     | Sellable quantity not enough |     |
| TRADE | 60064 | 可用资金量小于该笔报单保证金 |     | Account balance less than margin of the order |     |
| TRADE | 60065 | 保证金占可用资金百分比过高 |     | Ratio of margin occupying capital too large |     |
| TRADE | 60066 | 当天该合约撤单次数超限，不允许撤单 |     | Cancel order not allowed |     |
| TRADE | 60067 | 客户报单ID与登录ID不一致 |     | Customer order ID and login ID Inconsistent |     |
| TRADE | 60068 | 报单价格格式错误 |     | Wrong format of order price |     |
| TRADE | 60069 | 报单价格条件字段不在枚举范围之内 |     | Order price conditions field not in the range of enumeration |     |
| TRADE | 60070 | 报单买卖方向条件字段不在枚举范围之内 |     | Condition of buy and sell direction field not in the range of enumeration |     |
| TRADE | 60071 | 报单开平字段不在枚举范围之内 |     | Order field not in the range of enumeration |     |
| TRADE | 60072 | 报单投机套保标志字段不在枚举范围之内 |     | Order speculative hedging mark field not in the range of enumeration |     |
| TRADE | 60073 | 报单有效期类型字段不在枚举范围之内 |     | Order period of validity type field not in the range of enumeration |     |
| TRADE | 60074 | 报单操作标志字段不在枚举范围之内 |     | Order operation flag field not in the range of enumeration |     |
| TRADE | 60075 | 交易所端在途订单过多，限制报单 |     | Number of order on the way too large |     |
| TRADE | 60076 | xele_trade系统高负载，报单过多，限制报单 |     | System overload:qdr full |     |
| TRADE | 60077 | xele_trade系统高负载，持仓过多，限制报单 |     | System overload:ddr full |     |
| TRADE | 60078 | 报单投机套保标志与客户交易类型不一致 |     | Order speculative hedging mark inconsistent with customer transaction type |     |
| TRADE | 60079 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| TRADE | 60080 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| TRADE | 60081 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| TRADE | 60082 | 客户端未登录 |     | Client not logged in |     |
| TRADE | 60083 | 报单已撤，不能再次撤销 |     | Duplicate cancel |     |
| TRADE | 60084 | 拒绝自成交报单 |     | Self closing order refused |     |
| TRADE | 60085 | xele-monitor强平单不能被用户通过API撤掉 |     | Forced Liquidation order cannot be cancelled by API |     |
| TRADE | 60086 | 报单已经被撤掉了 |     | Order has been withdrawn |     |
| TRADE | 60087 | 订单超限 |     | Order exceeding limit |     |
| TRADE | 60088 | 合约格式错误 |     | Contract format error |     |
| TRADE | 60089 | 成交量类型不在枚举范围内 |     | Transaction type not in the range of enumeration |     |
| TRADE | 60090 | 触发条件不在枚举范围内 |     | Trigger conditions not in the range of enumeration |     |
| TRADE | 60091 | 强平原因不在枚举范围内 |     | Reasons for Liquidation order not in the range of enumeration |     |
| TRADE | 60092 | 报单手数小于最小成交量手数 |     | Orders lot less than the minimum lot of transactions |     |
| TRADE | 60093 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| TRADE | 60094 | 交易所前置未准备 |     | Exchange front not ready |     |
| TRADE | 60095 | 前置错误 |     | Exchange front error |     |
| TRADE | 60096 | 不允许开仓 |     | Open position disallowed |     |
| TRADE | 60097 | 不允许期货FOK报单 |     | Futures FOK order not allowed |     |
| TRADE | 60098 | IAS格式错误 |     | IAS format error |     |
| TRADE | 60099 | 交割月禁止开仓 |     | Open position in delivery month disallowed |     |
| TRADE | 60100 | 未登录不允许交易 |     | Trading not allowed without login |     |
| TRADE | 60101 | 系统负载过高 |     | System overload |     |
| TRADE | 60102 | 限额达到最大值 |     | Total bought amount reach the limit |     |
| TRADE | 60103 | 权利仓已达上限 |     | Total bought underlying position reach the limit |     |
| TRADE | 60104 | 当日权利仓已达上限 |     | Total today bought underlying position reach the limit |     |
| TRADE | 60105 | 总持仓已达上限 |     | Total underlying position reach the limit |     |
| TRADE | 60106 | 禁止自成交 |     | Self trade is forbidden |     |
| TRADE | 60107 | 触发价格偏离度风控 |     | Trigger price deviation risk |     |
| TRADE | 60108 | 今天限卖 |     | Today sell limit |     |
| TRADE | 60109 | 不允许撤单 |     | Order not allowed withdraw |     |
| TRADE | 60110 | 新股配股报单只允许一次 |     | Order insert only one time |     |
| TRADE | 60111 | 合约类型错误 |     | SecurityType wrong |     |
| TRADE | 60116 | 软件交易网关不可用 |     | Software trading gateway is unavailable |     |
| TRADE | 60200 | 报文identification字段错误 |     | Wrong identification field |     |
| TRADE | 60201 | message_id不再范围内 |     | Message_id not in range |     |
| TRADE | 60202 | message_len错误 |     | Wrong message_len |     |
| TRADE | 60203 | 用户报单id小于maxorderid或超出范围 |     | OrderID less than maxorderid or out of range |     |
| TRADE | 60204 | 报单方向错误 |     | Wrong Direction |     |
| TRADE | 60205 | positioneffect不在范围内 |     | Positioneffect not in range |     |
| TRADE | 60206 | 价格超出范围 |     | Price out of system limit |     |
| TRADE | 60207 | 报单类型错误 |     | Wrong OrderType |     |
| TRADE | 60208 | 时间条件错误 |     | Wrong TimeCondition |     |
| TRADE | 60209 | udp 校验错误 |     | Wrong UDP check |     |
| TRADE | 60210 | 用户token错误 |     | Wrong User token |     |
| TRADE | 60211 | 用户未登录 |     | User not login |     |
| TRADE | 60212 | web报单不允许api撤单 |     | Web order not allow api to cancel the order |     |
| TRADE | 60213 | 报单价格不能大于10000 |     | Order price cannot be greater than 10000 |     |
| TRADE | 60214 | 号段前缀错误 |     | Order Id prefix err |     |
| TRADE | 60215 | 号段Id错误 |     | Order Id number err |     |
| TRADE | 60216 | TCP通道错误 |     | Tcp Session Error |     |
| TRADE | 60217 | UserLocalId字段值超过限制，大于2176782335 |     | UserLocalId too large, more than 2176782335 |     |
| TRADE | 60218 | 被撤SysID超过号段范围 |     | OrigSysID is out of number range |     |
| TRADE | 60219 | 不能使用OrigUserLocalId字段撤单 |     | Can't Cancel Order by OrigUserLocalId |     |
| TRADE | 60220 | 报单资源已用尽 |     | Order resource is exhausted |     |
| TRADE | 60221 | 订单价格不能小于0 |     | Order Price cannot be less than 0 |     |
| TRADE | 60222 | 账号错误 |     | Account mismatch |     |
| TRADE | 60223 | HandlInst错误 |     | Illegal HandlInst |     |
| TRADE | 60225 | 禁止ETF申购 |     | Creation disallowed |     |
| TRADE | 60226 | 禁止ETF赎回 |     | Redemption disallowed |     |
| TRADE | 60227 | ETF申购成份股数量不足 |     | Creation component insufficient |     |
| TRADE | 60228 | ETF赎回的成份股持仓超过总股本比例 |     | Redemption component position too large |     |
| TRADE | 60229 | ETF申购的现金替代比例超限 |     | Substitution ratio of ETF creation cash exceeds limit |     |
| TRADE | 60230 | 禁止反向交易 |     | Reversed trade disallowed |     |
| TRADE | 60231 | 在途申购和在途赎回的报单总量超过16384 |     | Creation redemption resource exhausted |     |
| TRADE | 60232 | 跨市场全实物etf申赎错误 |     | Cross market full physical etf error |     |
| TRADE | 60233 | etf申赎基金市场错误 |     | Etf fund market error |     |
| TRADE | 60234 | RTGS交收额度不足 |     | RTGS available amount insufficient |     |
| TRADE | 60240 | 触发频繁瞬时撤单风控 |     | Trigger frequent instant order cancellations risk |     |
| TRADE | 60241 | 触发报撤速率限制风控 |     | Trigger order cancellation rate limit risk |     |
| TRADE | 60242 | 触发全天报撤笔数限制风控 |     | Trigger daily limit on the number of order cancellations risk |     |
| TRADE | 64001 | =后缺少值 |     | Tag has empty value |     |
| TRADE | 64002 | 无效的数据格式 |     | Invalid data format for value |     |
| TRADE | 64003 | 缺少必须的tag |     | Required tag missing |     |
| TRADE | 64004 | 重复的tag |     | Duplicate tag |     |
| TRADE | 64005 | 存在未定义的tag |     | Tag undefined for this message |     |
| TRADE | 64006 | 只支持买或卖 |     | Only buy or sell orders supported |     |
| TRADE | 64007 | 只支持市价或限价 |     | Only limit or market supported |     |
| TRADE | 64008 | 不支持的消息类型 |     | Unsupported message type |     |
| TRADE | 64009 | 报文长度超过2k |     | Packet 2k bytes max |     |
| TRADE | 64010 | 超过32字节 |     | Extracted fields 32 chars max |     |
| TRADE | 64011 | 证券代码非法或错误 |     | Symbol is not 6 chars |     |
| TRADE | 64012 | 消息格式错 |     | Message format error |     |
| TRADE | 64013 | 未知错误 |     | Unknown reason |     |
| TRADE | 64014 | senderCompId不匹配 |     | CompID mismatch |     |
| TRADE | 64015 | targetCompId不匹配 |     | TargetCompID mismatch |     |
| TRADE | 64016 | 无效的beginSeqNo |     | Invalid BeginSeqNum |     |
| TRADE | 64017 | tag1值超过12字节 |     | Tag1 over 12 chars |     |
| TRADE | 64018 | tag37值超过10字节 |     | Zxzq tag37 is over 10 chars |     |
| TRADE | 64019 | 无效的endSeqNo |     | Invalid EndSeqNum |     |
| TRADE | 64020 | 市场错误 |     | Market mismatch |     |
| TRADE | 64021 | 不支持tag43=Y |     | Unsupport tag43=Y |     |
| TRADE | 64022 | 序号不连续 |     | Seqnum discontinuity |     |
| TRADE | 64023 | 用户未登录 |     | Not login |     |
| TRADE | 64024 | tag11超过5字节 |     | Tag11 over 5 chars |     |

## XELE Manager管理管理中错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| MANAGER | 55002 | 数据未填写 |     | Empty filled information |     |
| MANAGER | 55003 | 柜台间资金转账选项错误 |     | Over-the-counter fund transfer option error |     |
| MANAGER | 55004 | 深交柜台连接失败 |     | sz counter connect fail |     |
| MANAGER | 55005 | 口令错误 |     | Wrong password |     |
| MANAGER | 55006 | 小数点后位数错误 |     | Wrong number of decimal places |     |
| MANAGER | 55007 | 用户已登录 |     | User already logined |     |
| MANAGER | 55008 | 资金调拨超时 |     | Cash In Out Timeout |     |
| MANAGER | 55009 | 金额验证失败 |     | amount verification failed |     |
| MANAGER | 55010 | 机构代码检查错误 |     | OrgID check error |     |
| MANAGER | 52011 | 行情错误 |     | Wrong Market |     |
| MANAGER | 52012 | 上交数据库连接失败 |     | SS database connect failed |     |
| MANAGER | 52013 | 深交数据库连接失败 |     | SZ database connect failed |     |
| MANAGER | 55014 | 用户尚未登录 |     | User not login |     |
| MANAGER | 55015 | 上交、深交数据库连接失败 |     | SS and SZ database connect failed |     |
| MANAGER | 55016 | 错误的资金账号 |     | Wrong AccountID |     |
| MANAGER | 55017 | 上交数据库查询失败 |     | SS database query failed |     |
| MANAGER | 55018 | 深交数据库查询失败 |     | SZ database query failed |     |
| MANAGER | 55019 | 上交、深交数据库查询失败 |     | SS and SZ database query failed |     |
| MANAGER | 55020 | 非双边投资者，不支持此功能 |     | Non double investor, this feature is not supported |     |
| MANAGER | 55021 | 不合法的密码 |     | Illegal password |     |
| MANAGER | 55022 | 上交柜台入金失败 |     | SS Counter Cash In Fail |     |
| MANAGER | 55023 | 上交柜台出金失败 |     | SS Counter Cash Out Fail |     |
| MANAGER | 55024 | 上交柜台入金超时 |     | SS Counter Cash In Timeout |     |
| MANAGER | 55025 | 上交柜台出金超时 |     | SS Counter Cash Out Timeout |     |
| MANAGER | 55026 | 深交柜台入金失败 |     | SZ Counter Cash In Fail |     |
| MANAGER | 55027 | 深交柜台出金失败 |     | SZ Counter Cash Out Fail |     |
| MANAGER | 55028 | 深交柜台入金超时 |     | SZ Counter Cash In Timeout |     |
| MANAGER | 55029 | 深交柜台出金超时 |     | SZ Counter Cash Out Timeout |     |
| MANAGER | 55030 | 金额超出范围 |     | The amount of money is out of range |     |
| MANAGER | 55031 | 错误的授权码 |     | Wrong AuthCode |     |
| MANAGER | 55032 | 主柜台的准备信息失败，可能柜台未连接 |     | Get ready counter info of master fail,maybe counter not connect |     |
| MANAGER | 55033 | 登录节点填写错误 |     | Login sub client index wrong |     |
| MANAGER | 55034 | 柜台错误或者柜台未连接 |     | Market error or counter not connect |     |
| MANAGER | 55037 | 资金账号不存在 |     | AccountID not exist |     |
| MANAGER | 55038 | token错误 |     | Wrong token |     |
| MANAGER | 55039 | 报单序号不是连续增加 |     | The order number not increases monotonically |     |
| MANAGER | 55041 | 内部进程间消息发送失败 |     | Interactive msg send failed |     |
| MANAGER | 55043 | 插入数据库失败 |     | Failed to insert into database |     |
| MANAGER | 55044 | 重复登陆 |     | Duplicate login |     |
| MANAGER | 55045 | 柜台导上场数据初始化未完成 |     | Initialization of settlement data not completed |     |
| MANAGER | 55046 | 操作过快 |     | Operate too fast |     |
| MANAGER | 55047 | 无相关记录 |     | No relevant records |     |
| MANAGER | 55048 | 登录超时 |     | Login timeout |     |
| MANAGER | 55049 | 该用户已经在其他链路登录 |     | User has logged in on another link |     |
| MANAGER | 55050 | api版本错误 |     | Wrong API version |     |
| MANAGER | 55052 | 接口未开启 |     | Interface not open |     |
| MANAGER | 55053 | 错误的时间格式 |     | Wrong time format |     |
| MANAGER | 55054 | 号段用尽或未配置号段 |     | Number segment run out or not configured |     |
| MANAGER | 55055 | 集中交易操作失败 |     | Central trading operation failed |     |
| MANAGER | 55056 | 用户登陆ip检查失败 |     | User login ip check failed |     |
| MANAGER | 55057 | 用户登陆mac地址检查失败 |     | User login mac address check failed |     |
| MANAGER | 55058 | 柜台间资金调拨失败 |     | Failed to transfer |     |
| MANAGER | 55059 | 集中交易授权失败 |     | Central trading authentication failed |     |
| MANAGER | 55060 | 连接headquarter错误 |     | failed to connect to headquarter |     |
| MANAGER | 55061 | 资金不能小于等于零 |     | Capital cannot be less than or equal to zero |     |
| MANAGER | 55062 | 系统id错误 |     | Wrong system_id |     |
| MANAGER | 55063 | 登陆太快 |     | Login too fast |     |
| MANAGER | 55064 | 仓位检查错误 |     | Position check failed |     |
| MANAGER | 55065 | 组合策略类型错误 |     | Wrong comb strategy type |     |
| MANAGER | 55068 | 已经有其他帐户登录到当前链接 |     | Another account has already logged in this link |     |
| MANAGER | 55069 | 上交柜台连接失败 |     | ss counter connect fail |     |
| MANAGER | 55070 | 发送消息至柜台错误 |     | send message to counter error |     |
| MANAGER | 55071 | 该账户正在使用自动调拨功能 |     | Account is in auto balance status |     |
| MANAGER | 55072 | 上交柜台状态非正常运行，不能资金调拨 |     | SS counter status not in running,this operation can not be done |     |
| MANAGER | 55073 | 深交柜台状态非正常运行，不能资金调拨 |     | SZ counter status not in running,this operation can not be done |     |
| MANAGER | 55074 | 上交、深交柜台状态都非正常运行，不能资金调拨 |     | SS and SZ counter status both not in running,this opetation can not ne done |     |
| MANAGER | 55088 | Api自动重连校验失败 |     | Api reconnect TradingDay compare failed |     |
| MANAGER | 55089 | 交易日尚未从柜台同步 |     | Tradingday not sync from trade yet |     |
| MANAGER | 55090 | 合约未找到 |     | Contract not found |     |
| MANAGER | 55091 | 持仓划拨失败 |     | Api position transfer failed |     |
| MANAGER | 55092 | 软件报单速率过快 |     | Soft order too fast |     |
| MANAGER | 55093 | 查询链路地址为空 |     | query url is empty |     |

## 上交所错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| 上交所 | 0   | 正确  |     | OK  |     |
| 上交所 | 202 | 无效操作员代码 |     | Invalid PBU |     |
| 上交所 | 203 | 无效证券代码 |     | Invalid SecuritiesID |     |
| 上交所 | 204 | 申报时间为该证券的非交易时间 |     | Non-trading time |     |
| 上交所 | 208 | 无效买卖标志，非‘B’或者‘S’ |     | Invalid Direction |     |
| 上交所 | 209 | 交易品种不对 |     | Wrong contract group |     |
| 上交所 | 211 | 此账号不能进行该证券交易 |     | This contract unavailable for this account |     |
| 上交所 | 212 | 价格申报出错 |     | Wrong request price |     |
| 上交所 | 213 | 证券已被挂起 |     | Securities suspended |     |
| 上交所 | 214 | 该股票不参与集合竞价 |     | The stock not participant in aution |     |
| 上交所 | 215 | 无效帐号 |     | Invalid AccountID |     |
| 上交所 | 216 | 该帐号未指定在你席位 |     | The account not assigned to your seat |     |
| 上交所 | 217 | 帐号已被挂起 |     | Account has been suspended |     |
| 上交所 | 218 | 无效申报价格 |     | Invalid request price |     |
| 上交所 | 219 | 申报价不能为零 |     | Price can not be 0 |     |
| 上交所 | 220 | 申报价格不符合最小价格步长要求 |     | Price not meet the minimum step |     |
| 上交所 | 222 | 申报价格超出范围 |     | Price out of range |     |
| 上交所 | 223 | 申报买入数量必须是1000的整数倍 |     | Volume must be an integer multiple of 1000 |     |
| 上交所 | 224 | 无效的申报数量 |     | Invalid volume |     |
| 上交所 | 225 | 申报数量必须大于0 |     | Volume must be greater than 0 |     |
| 上交所 | 226 | 新股申报数量至少1000 |     | New shares Volume at least 1000 |     |
| 上交所 | 227 | 申报数量不符合最小步长要求 |     | Volume not meet the minimum step |     |
| 上交所 | 228 | 申报数量超过单笔最大允许申报的上限 |     | Volume exceeds the maximum allowable bid limit |     |
| 上交所 | 231 | 账号可卖出的余额不足 |     | Insufficient balance |     |
| 上交所 | 234 | 股票持有量超出限量 |     | Position exceeds the limit |     |
| 上交所 | 236 | PBU没有买入权限 |     | PBU has no permission to buy |     |
| 上交所 | 237 | PBU没有卖出权限 |     | PBU has no permission to sell |     |
| 上交所 | 243 | 基金帐号\\机构帐号不能买卖此证券 |     | Fund account or institution account can not buy or sell this securities |     |
| 上交所 | 244 | 'S'帐号不能买入 |     | 'S' account can not buy |     |
| 上交所 | 245 | 不能撤销指定（有卖空股票，请先补回卖空股票） |     | can not cancel |     |
| 上交所 | 246 | 不能撤销指定（有申报） |     | can not cancel |     |
| 上交所 | 247 | 不能撤销指定（公司卖空） |     | can not cancel |     |
| 上交所 | 248 | 中国证券登记结算公司不允许撤销指定 |     | Cannel not allowed by CSDC |     |
| 上交所 | 250 | B股结算会员代码（数据库接口中的firmid）错，可从中登公司上海分公司查询。 |     | Wrong B-share firmid |     |
| 上交所 | 252 | 无效操作员代码 |     | Invalid PBU |     |
| 上交所 | 253 | 操作员权限不够 |     | No permission |     |
| 上交所 | 257 | 操作员申报的rec_num序号不连续 |     | Discontinuous rec_num |     |
| 上交所 | 263 | 市价订单不参加集合竞价 |     | Market orders not participate in auction |     |
| 上交所 | 264 | 最优五档即时成交剩余撤销市价订单对手方无未成交订单 |     | Counterparty has no unsettled orders |     |
| 上交所 | 265 | 最优五档即时成交剩余转限价市价订单对手方和本方均无未成交订单 |     | The counterparty and the party have no unsettled orders |     |
| 上交所 | 266 | 该券种不允许做市价订单 |     | This securities group not allowed for market order |     |
| 上交所 | 267 | 帐户没有权限进行账户式质押回购的交易及出入库 |     | Account has no permission to process account-style pledge repurchase transactions and deposits and withdrawals |     |
| 上交所 | 268 | 场内报盘对于出入库申报的统一出错代码 |     | Uniform error codes for out-put and in-put of warehouse |     |
| 上交所 | 269 | 申报类型错误 |     | Wrong OrderType |     |
| 上交所 | 270 | 申报类型错误 |     | Wrong OrderType |     |
| 上交所 | 271 | 该帐号已指定在你席位 |     | The accounthas assigned to your seat |     |
| 上交所 | 272 | 未做指定不能交易 |     | Can not trade without specified participants |     |
| 上交所 | 273 | E 帐号不能通过场内申报进行交易 |     | Account not be traded through floor offers |     |
| 上交所 | 274 | 信用交易的申报帐户必须是E 帐户 |     | The reporting account for credit transactions must be an E-account |     |
| 上交所 | 275 | 普通交易的申报帐户必须不是E 帐户 |     | The reporting account for ordinary transactions must not be an E-account |     |
| 上交所 | 276 | 该证券不允许担保品买入 |     | The Securities not support trading with collateral |     |
| 上交所 | 277 | 信用卖出权限不足 |     | Insufficient permission for credit selling |     |
| 上交所 | 278 | 该证券不允许融资买入 |     | Not allow to buyby financing |     |
| 上交所 | 279 | 卖券还款或融资平仓权限不足 |     | Insufficient permission to repay by selling securities or finance by liquidating |     |
| 上交所 | 280 | 买券还券或融券平仓权限不足 |     | Insufficient permission to return by buying or margin trading by liquidating |     |
| 上交所 | 281 | 该证券不允许融券卖出 |     | The securities are not allowed to be sold for margin selling |     |
| 上交所 | 282 | 融券卖出申报价格低于最新成交价 |     | The margin selling price is lower than the latest price |     |
| 上交所 | 283 | 买券还券、融券卖出、融券平仓申报的信用帐户必须配置证券公司融券专用帐户 |     | Special account must be configured for special business |     |
| 上交所 | 401 | 无效操作员代码 |     | Invalid PBU |     |
| 上交所 | 403 | 无效申报序号 |     | Invalid rec_num |     |
| 上交所 | 404 | 撤单对应申报序号检验失败 |     | The rec_num of cancelled order checked failed |     |
| 上交所 | 405 | 撤单对应的证券帐号检验失败 |     | The stock account of cancelled order checked failed |     |
| 上交所 | 406 | 撤单对应的股票代码检验失败 |     | The SeciritiesID of cancelled order checked failed |     |
| 上交所 | 407 | 撤单对应的买卖方向检验失败 |     | Direction of cancelled order checked failed |     |
| 上交所 | 408 | 对应的申报已经被撤单 |     | Order has been cancelled |     |
| 上交所 | 409 | 只能通过买799998撤销指定 |     | Can only be cancelled by buying 799998 |     |
| 上交所 | 410 | 只能通过买799999重新指定 |     | Can only be cancelled by buying 799999 |     |
| 上交所 | 411 | 对应的申报已成交，不能撤单 |     | The corresponding bid has been completed and the order can not be cancelled |     |
| 上交所 | 412 | 不允许撤单 |     | Cancell not allowed |     |
| 上交所 | 413 | 撤单失败,对应的申报已成交或者已经被撤单 |     | Cancel order failed, the order was traded or cancelled |     |
| 上交所 | 499 | 无申报可撤 |     | None can be cancelled |     |
| 上交所 | 507 | 后台应用错误 |     | Background application error |     |
| 上交所 | 731 | 基金公司未上传ETF申购赎回清单 |     | Fund companies not upload ETF purchase redemption list |     |
| 上交所 | 732 | ETF状态不对 |     | Wrong ETF status |     |
| 上交所 | 733 | ETF投资者持股不足 |     | ETF investors have insufficient Position |     |
| 上交所 | 734 | ETF现金替代比例超过基金公司规定的比例 |     | Substitution Ratio of ETF cash exceed the ratio ruled |     |
| 上交所 | 735 | ETF基金账号持股余额不足，投资者不能赎回 |     | Insufficient balance, can not redeem |     |
| 上交所 | 736 | ETF基金账户不能申购或赎回 |     | ETF fund account not buy or redeemed |     |
| 上交所 | 752 | 账户中没有现券 |     | No cash coupons in this account |     |
| 上交所 | 753 | 账户中现券余额不足 |     | Insufficient cash coupons in this account |     |
| 上交所 | 754 | 账户中没有标准券 |     | No standard coupons in this account |     |
| 上交所 | 755 | 账户中标准券余额不足 |     | Insufficient standard coupons in this account |     |
| 上交所 | 756 | 账户没有质押券 |     | No pledged bonds in this account |     |
| 上交所 | 757 | 账户的质押券余额不足 |     | Insufficient pledged coupons int this account |     |
| 上交所 | 758 | 标准券折算率未初始化 |     | Conversion rate of standard coupon not initialized |     |
| 上交所 | 759 | 标准券代码不存在 |     | Standard coupons code not exist |     |
| 上交所 | 1005 | 登录主机失败 |     | Login to host failed |     |
| 上交所 | 1014 | PBU登录失败 |     | Failed to log in to PBU |     |
| 上交所 | 1015 | 修改口令失败 |     | Failed to change password |     |
| 上交所 | 1021 | rec_num 必须连续递增 |     | Discontinuous rec_num |     |
| 上交所 | 1022 | 股票代码错误或者非本市场产品 |     | Wrong SecuritiesID or non-market products |     |
| 上交所 | 1023 | 账号错误 |     | Wrong Account ID |     |
| 上交所 | 1024 | 买卖方向错误 |     | Wrong Direction |     |
| 上交所 | 1025 | 价格错误 |     | Wrong Price |     |
| 上交所 | 1026 | 数量错误 |     | Wrong Volume |     |
| 上交所 | 1027 | 日期错误 |     | Wrong Date |     |
| 上交所 | 1028 | 申报单或撤消单的标志错误 |     | Wrong sign for order or cancel order |     |
| 上交所 | 1029 | 结算会员代码错误 |     | Wrong clearing member ID |     |
| 上交所 | 1030 | 撤消单的ordrec域错误 |     | Wrong ordrec domain of cancel order |     |
| 上交所 | 1031 | 撤消单的ordrec域大于等于撤消单的rec_num域 |     | Ordrec field of the cancel order greater than or equal to the rec_num field of the cancel order |     |
| 上交所 | 1034 | 撤消的申报单是失败的数据单 |     | Cancelled order discarded |     |
| 上交所 | 1039 | 刚读入待处理的单子的status是’P’或’p’ |     | The status of order is 'P' or 'p' |     |
| 上交所 | 1040 | 刚读入待处理的单子的status不是’R’，也不是’P’ |     | The status of order is neither 'P' nor 'p' |     |
| 上交所 | 1042 | 底层通讯接收时发生错 |     | An error occurred while communicating |     |
| 上交所 | 1043 | 接收到的数据包内容错误 |     | Wrong received packet |     |
| 上交所 | 1050 | 撤消的申报单不存在或者撤单申报的证券代码错误 |     | The cancelled order not exist or SecuritiesID of the cancelled order wrong |     |
| 上交所 | 1100 | 申报号太大 |     | The offer number too large |     |
| 上交所 | 1101 | 记录不匹配 |     | Records mismatch |     |
| 上交所 | 1102 | 营业部代码格式错误，格式必须为1到65535的整数 |     | Wrong format of business branchID |     |
| 上交所 | 1103 | 无法解析订单 |     | Unable to resolve order |     |
| 上交所 | 2000 | 与交易所的网络连接出错 |     | Connect to exchange failed |     |
| 上交所 | 2001 | 被撤单的日期不是今天 |     | Date of the cancelled order not today |     |
| 上交所 | 2004 | 被撤单的帐号不是本人 |     | Account which cancels order not mine |     |
| 上交所 | 2006 | 撤单记录中被撤单的股票代码与被撤单不一致 |     | SecuritiesID of the cancelled order in recordinconsistent with the cancelled order |     |
| 上交所 | 2007 | 撤单记录中被撤单的股票价格不正确，与被撤单不一致 |     | Price of the cancelled order in record inconsistent with the cancelled order |     |
| 上交所 | 2008 | 只有申报才可被撤单 |     | Can only cancel order which exists |     |
| 上交所 | 2101 | 撤单记录和被撤单记录的股票买卖方向不同 |     | Wrong Directionof cancelled order |     |
| 上交所 | 2102 | 撤单记录和被撤单记录的股票数量不同 |     | Wrong Volume of cancelled order |     |
| 上交所 | 3000 | 连接数据库失败 |     | Failed to connect to the database |     |
| 上交所 | 3001 | 数据库记录的交易日期不正确 |     | The transaction date recorded in the database is incorrect |     |
| 上交所 | 3002 | truncate数据库记录失败 |     | The truncate database record failed |     |
| 上交所 | 3701 | 发布包不存在或发布包路径错误 |     | The release package does not exist or the release package path is incorrect |     |
| 上交所 | 3702 | 选择的安装路径错误 |     | The wrong installation path was selected |     |
| 上交所 | 3703 | 获取项目名称错误 |     | Getting the project name is incorrect |     |
| 上交所 | 3704 | 备份失败，需退出软件或关闭相关文件再重试 |     | If the backup fails, you need to exit the software or close the related files and try again |     |
| 上交所 | 3705 | 解压时ZIP错误 |     | ZIP error while extracting |     |
| 上交所 | 3706 | 解压时IO错误 |     | I/O error during decompression |     |
| 上交所 | 3707 | 解压时参数不合法或不正确 |     | The parameters are invalid or incorrect during decompression |     |
| 上交所 | 3708 | 无法找到老版本配置文件 |     | Unable to find the old version configuration file |     |
| 上交所 | 3709 | 新版本配置文件不存在 |     | The new version configuration file does not exist |     |
| 上交所 | 3710 | 更新配置文件时内部存储故障 |     | Internal storage failure when updating a configuration file |     |
| 上交所 | 3711 | 更新配置文件时文件格式不符合规范 |     | The file format is not up to specification when updating the configuration file |     |
| 上交所 | 3712 | 更新配置文件时IO错误 |     | IO error while updating the configuration file |     |
| 上交所 | 3713 | 复制文件时IO错误 |     | IO error while copying a file |     |
| 上交所 | 3714 | 软件恢复失败 |     | Software recovery failed |     |
| 上交所 | 4001 | 获取参考数据失败 |     | Failed to get reference data |     |
| 上交所 | 4003 | 请检查旧口令是否正确，或者新口令长度是否正确 |     | Check old password is correct or new password is of correct length |     |
| 上交所 | 4004 | 连接主机失败 ，其他错误 |     | Failed to connect to host, other errors |     |
| 上交所 | 4005 | IP绑定失败 |     | The IP binding failed |     |
| 上交所 | 4006 | 连接主机超时 |     | The connection to the host timed out |     |
| 上交所 | 4007 | 连接主机失败 ，底层I/O未知错误 |     | Failed to connect to host, underlying I/O unknown error |     |
| 上交所 | 4008 | 交易员登录失败 |     | Trader login failed |     |
| 上交所 | 4009 | 获取交易时间表失败 |     | Failed to get trading schedule |     |
| 上交所 | 4010 | 参考数据中isix格式错误 |     | The format of the ISIX in the reference data is incorrect |     |
| 上交所 | 4011 | 参考数据中rid格式错误 |     | The RID format in the reference data is incorrect |     |
| 上交所 | 4012 | 错误的证券代码和BizID |     | Wrong securityID or wrong BizID |     |
| 上交所 | 4500 | 股票代码securityid字段格式错误 |     | The securitiesID symbol securityid field is malformed |     |
| 上交所 | 4501 | 订单状态ordstatus非法 |     | Order status ordstatus is invalid |     |
| 上交所 | 4502 | TimeStamp取值不正确,非当前交易日 |     | The TimeStamp value is incorrect and is not the current trading day |     |
| 上交所 | 4600 | 没有找到对手方指令 |     | No counterparty orders were found |     |
| 上交所 | 4601 | 指令细节不一致 |     | Instruction details are inconsistent |     |
| 上交所 | 4602 | 没有找到对手方 |     | No counterparty was found |     |
| 上交所 | 4603 | 数据库读取对手方指令异常 |     | The database reads the counterparty's instruction abnormally |     |
| 上交所 | 4604 | 业务数据表操作异常 |     | The operation of the business data table is abnormal |     |
| 上交所 | 5000 | 信息长度超过4k |     | Message exceed mas length 4k |     |
| 上交所 | 5001 | 校验码错误 |     | CheckSum error |     |
| 上交所 | 5002 | 心跳超时 |     | HeartBeat timeout |     |
| 上交所 | 5003 | 已经登录 |     | Already login |     |
| 上交所 | 5004 | 登录超时 |     | Login timeout |     |
| 上交所 | 5005 | CompId错误 |     | CompId error |     |
| 上交所 | 5006 | 未准备 |     | Not ready |     |
| 上交所 | 5007 | 网络错误 |     | Internal error |     |
| 上交所 | 5008 | 信息类型不合法 |     | Message type illegal |     |
| 上交所 | 5009 | 不接受新报单 |     | Do not Accept new order |     |
| 上交所 | 5010 | setID错误 |     | Wrong setID |     |
| 上交所 | 5011 | Pbu错误 |     | Wrong Pbu |     |
| 上交所 | 5012 | 先登录 |     | Login first |     |
| 上交所 | 5013 | BeginReportIndex错误 |     | Wrong BeginReportIndex |     |
| 上交所 | 5014 | 不支持prtcl版本 |     | Unsupported prtcl version |     |
| 上交所 | 5015 | 信息错误 |     | Message data error |     |
| 上交所 | 10000 | 内部错误，请联系上交所 |     | Internal error, please contact SSE |     |
| 上交所 | 10002 | 找不到用户 |     | User does not exist |     |
| 上交所 | 10004 | 与原有密码不同 |     | Different from the original password |     |
| 上交所 | 10006 | 请求已经被处理 |     | Request has been processed |     |
| 上交所 | 10008 | 繁忙,TXN被拒绝,请再试一次 |     | Busy,TXN rejected,please try again |     |
| 上交所 | 10018 | 无效市场类型 |     | Invalid market type |     |
| 上交所 | 10022 | 未填写借贷期限 |     | Loan term is not filled |     |
| 上交所 | 10028 | 无效的净资产值（NAV）日期 |     | Invalid Net Asset Value (NAV) dates |     |
| 上交所 | 10030 | 无效的基础产品 |     | Invalid base product |     |
| 上交所 | 10032 | 未填写基础产品 |     | Product base is not filled |     |
| 上交所 | 10038 | 无效的价格 |     | Invalid price |     |
| 上交所 | 10042 | 无效的现金红利股权登记日期 |     | Date on which invalid cash dividend equity was recorded |     |
| 上交所 | 10044 | 未填写除息日期 |     | No ex dividend date filled in |     |
| 上交所 | 10046 | 无效的除息日期 |     | Invalid ex-dividend date |     |
| 上交所 | 10048 | 未填写红利金额 |     | Bonus amount is not filled |     |
| 上交所 | 10052 | 无效的股票红利股权登记日期 |     | Invalid stock dividend equity record date |     |
| 上交所 | 10054 | 未填写除权日期 |     | Ex-rights date is not specified |     |
| 上交所 | 10056 | 无效的除权日期 |     | Exclusion date not filled in |     |
| 上交所 | 10058 | 未填写分红率 |     | Dividend rate not filled in |     |
| 上交所 | 10062 | 无效的配股股权登记日期 |     | Invalid registration date for rights issue |     |
| 上交所 | 10066 | 无效的除权日期 |     | Invalid ex right date |     |
| 上交所 | 10070 | 未填写配股价格 |     | Allotment price has not been filled in |     |
| 上交所 | 10074 | 未填写股东大会登记日期 |     | Registration date for shareholder meeting not filled in |     |
| 上交所 | 10076 | 无效的股东大会登记日期 |     | Invalid registration date for shareholder meeting |     |
| 上交所 | 10078 | 未填写股东大会日期 |     | Date of shareholder meeting not filled in |     |
| 上交所 | 10080 | 无效的股东大会日期 |     | Invalid date of shareholder meeting |     |
| 上交所 | 10084 | 无效的股票总数量 |     | Total number of invalid stocks |     |
| 上交所 | 10086 | 无效的每股收益（EPS） |     | Ineffective earnings per share (EPS) |     |
| 上交所 | 10088 | 无效的期限：借贷天数 |     | Invalid term: loan days |     |
| 上交所 | 10090 | 国内标识 |     | DomesticIDentification |     |
| 上交所 | 10092 | 每股收益（EPS）日期 |     | Earnings per share (EPS) date |     |
| 上交所 | 10096 | 无效的权证类型 |     | Invalid certificate type |     |
| 上交所 | 10098 | 未填写产品简称 |     | Product abbreviation not filled in |     |
| 上交所 | 10100 | 无效的产品子类型 |     | Invalid product subtype |     |
| 上交所 | 10104 | 无效的产品群名称 |     | Invalid product group name |     |
| 上交所 | 10106 | 无效的产品类型 |     | Invalid instrument type |     |
| 上交所 | 10108 | 该国际证券标识码（ISIN）已存在 |     | This International SecuritiesIDentification Number (ISIN) already exists |     |
| 上交所 | 10112 | 无效的产品代码 |     | Invalid productID |     |
| 上交所 | 10114 | 产品删除无效 |     | Product deletion is invalid |     |
| 上交所 | 10116 | 无效的缺省交易时间表 |     | Invalid default trading schedule |     |
| 上交所 | 10118 | 未找到产品组 |     | Product group not found |     |
| 上交所 | 10120 | 产品和产品组不匹配 |     | Product and product group don't match |     |
| 上交所 | 10126 | 无效的外部标识 |     | Invalid externalIDentification |     |
| 上交所 | 10128 | 摘牌日无效 |     | Void on date of delisting |     |
| 上交所 | 10132 | 产品数据不一致 |     | Product data is different |     |
| 上交所 | 10140 | 无效的产品子类型 |     | Invalid product subtype |     |
| 上交所 | 10142 | 错误的时间戳 |     | Incorrect timestamp |     |
| 上交所 | 10144 | 无效的结算货币 |     | Invalid settlement currency |     |
| 上交所 | 10146 | 无效的名义货币 |     | Invalid notional currency |     |
| 上交所 | 10150 | 未找到记录 |     | No records found |     |
| 上交所 | 10156 | 无效的订单手数类型 |     | Invalid order lot type |     |
| 上交所 | 10160 | 未填写持续时间 |     | Duration is not filled |     |
| 上交所 | 10162 | 未填写启动时间 |     | Startup time is not specified |     |
| 上交所 | 10172 | 卖空标识无效 |     | Invalid short selling flag |     |
| 上交所 | 10178 | 无效的最小披露数量 |     | Minimum number of invalid disclosures |     |
| 上交所 | 10182 | 无效的波动范围 |     | Invalid volatility range |     |
| 上交所 | 10188 | 无效的最大剩余数量 |     | Invalid Maximum remaining quantity |     |
| 上交所 | 10192 | 无效的整手数 |     | Invalid whole lots |     |
| 上交所 | 10194 | 无效的最大订单数量（A） |     | Invalid Maximum Order Quantity (A) |     |
| 上交所 | 10200 | 无效的收盘价计算方法 |     | Invalid closing price calculation |     |
| 上交所 | 10202 | 无效的参考价格 |     | Invalid reference price |     |
| 上交所 | 10204 | 未填写价格上下限 |     | Upper and lower price limits are not specified |     |
| 上交所 | 10206 | 未填写发行数量 |     | Number of issues is not filled |     |
| 上交所 | 10208 | 总数量无效 |     | Invalid total quantity |     |
| 上交所 | 10210 | 借贷期限无效 |     | Invalid loan term |     |
| 上交所 | 10218 | 未填写抽签日期 |     | Date of draw was not filled |     |
| 上交所 | 10220 | 无效的抽签日期 |     | Invalid draw dates |     |
| 上交所 | 10222 | 无效的价格上下限 |     | Invalid price upper and lower limits |     |
| 上交所 | 10224 | 无效的转换率 |     | Invalid conversion rates |     |
| 上交所 | 10228 | 无效的最小协商订单数量 |     | Invalid minimum negotiated order quantity |     |
| 上交所 | 10230 | 无效的产品组代码 |     | Invalid product group code |     |
| 上交所 | 10234 | 产品群未找到 |     | Product group does not exist |     |
| 上交所 | 10236 | 无效时间戳 |     | Invalid time stamp |     |
| 上交所 | 10238 | 访问被拒绝 |     | Access is denied |     |
| 上交所 | 10240 | 超过最大订单有效期 |     | Maximum order validity period has been exceeded |     |
| 上交所 | 10242 | 订单有效期早于当前日期 |     | Order is valid before current date |     |
| 上交所 | 10244 | 错误订单有效期 |     | Incorrect order expiration date |     |
| 上交所 | 10246 | 错误产品类型 |     | Wrong product type |     |
| 上交所 | 10248 | 无法读取该产品 |     | Product could not be read |     |
| 上交所 | 10250 | 无效交易事务代码 |     | Invalid transaction code |     |
| 上交所 | 10252 | 该交易时段内禁用该功能 |     | Disable this function during this trading period |     |
| 上交所 | 10254 | 未分配该产品 |     | Product is not assigned |     |
| 上交所 | 10256 | 未获代理帐户授权 |     | Not authorized by agency account |     |
| 上交所 | 10258 | 未获做市商帐户授权 |     | Not authorized by market maker account |     |
| 上交所 | 10260 | 未获自有帐户授权 |     | Not authorized by self account |     |
| 上交所 | 10262 | 无效的报单类型 |     | Invalid order type |     |
| 上交所 | 10264 | 无效执行限制类型 |     | Invalid execution restriction type |     |
| 上交所 | 10266 | 无效交易限制类型 |     | Invalid trading restriction type |     |
| 上交所 | 10268 | 未获取做市商资格 |     | Not qualified as market maker |     |
| 上交所 | 10270 | 无效PBU的PBU代码 |     | PBU code of invalid PBU |     |
| 上交所 | 10272 | 当前用户不是交易所用户 |     | Current user is not exchange user |     |
| 上交所 | 10274 | 交易被拒绝: PBU不能在该MISS上交易! |     | Transaction declined: PBU cannot be traded on this MISS! |     |
| 上交所 | 10276 | 无效报价价格或数量 |     | Invalid quoted price or quantity |     |
| 上交所 | 10278 | 无效交易限制“SU” |     | Invalid Transaction Restriction "SU" |     |
| 上交所 | 10280 | 不合理的数量 |     | Unreasonable quantity |     |
| 上交所 | 10282 | 最后修改时间已改变 |     | Last modification time has changed |     |
| 上交所 | 10286 | 无效处理日期 |     | Invalid processing date |     |
| 上交所 | 10290 | PBU无分配产品 |     | PBU has no dispensing products |     |
| 上交所 | 10292 | 无效的日期输入 |     | Invalid date entry |     |
| 上交所 | 10294 | 无效的日期参数 |     | Invalid date parameter |     |
| 上交所 | 10296 | 合约ISIN前缀重复 |     | ISIN prefix of contract is duplicated |     |
| 上交所 | 10298 | 无效的产品关联数据标识或交易员不存在 |     | Invalid product-associated dataIDentifier or trader does not exist |     |
| 上交所 | 10302 | 产品或特许权限不关联到当前子组 |     | Product or privilege is not associated to current subgroup |     |
| 上交所 | 10304 | 资源信息找不到 |     | Resource information does not exist |     |
| 上交所 | 10306 | 合约产品缩写前缀重复 |     | Contract product abbreviation prefix is duplicated |     |
| 上交所 | 10308 | 该产品已分配特许权限 |     | Product has been assigned a licensed permission |     |
| 上交所 | 10310 | PBU未分配特许权限 |     | PBU does not have privileged permissions assigned |     |
| 上交所 | 10318 | 冰山订单最小数量非整手数量 |     | Minimum quantity of an iceberg order is not a whole lot quantity |     |
| 上交所 | 10320 | 最小披露数量非整手数量 |     | Minimum disclosed quantity is not whole lot size |     |
| 上交所 | 10322 | 无效的最小报价数量 |     | Invalid minimum quotation quantity |     |
| 上交所 | 10324 | 无效的挂牌首日 |     | Invalid first day of listing |     |
| 上交所 | 10326 | 无效最小可交易量 |     | Invalid minimum tradable volume |     |
| 上交所 | 10348 | 无效IPO发行方法 |     | Invalid IPO issuance method |     |
| 上交所 | 10350 | 无效是非标识 |     | Invalid non-identification |     |
| 上交所 | 10352 | 无效冰山订单最小数量 |     | Void Iceberg order minimum quantity |     |
| 上交所 | 10354 | 无效持续时间 |     | Invalid duration |     |
| 上交所 | 10356 | 无效开始时间 |     | Invalid start time |     |
| 上交所 | 10360 | 无效价格区间计算方法 |     | Invalid price range calculation method |     |
| 上交所 | 10362 | 无效价格单位 |     | Invalid price unit |     |
| 上交所 | 10364 | 无效交易模型 |     | Invalid transaction model |     |
| 上交所 | 10366 | 无法将RAL更新至数据库 |     | RAL cannot be updated to database |     |
| 上交所 | 10368 | 无效值间关系 |     | Relationships between invalid values |     |
| 上交所 | 10376 | 无效的市场代号 |     | Invalid ticker |     |
| 上交所 | 10378 | 无效的交易所代号 |     | Invalid exchange symbol |     |
| 上交所 | 10380 | 产品重复(代号，或简称，或ISIN） |     | Product duplication (code, or abbreviation, or ISIN) |     |
| 上交所 | 10382 | 分红参数未输入 |     | Dividend parameter is not entered |     |
| 上交所 | 10390 | 无效的成交金额的计算类型 |     | Type of calculation of invalid transaction amount |     |
| 上交所 | 10392 | 市场处于停盘状态 |     | Market is at a standstill |     |
| 上交所 | 10394 | 无效的时段转换代码 |     | Invalid period conversion code |     |
| 上交所 | 10396 | 无法转换到目标状态 |     | Unable to transition to target state |     |
| 上交所 | 10398 | 产品无法使用 |     | Product cannot be used |     |
| 上交所 | 10400 | 当前状态无法转换到等待批处理 |     | Current state cannot be transitioned to Pending Batch |     |
| 上交所 | 10402 | 未找到该市场 |     | Market does not exist |     |
| 上交所 | 10404 | 状态转换请求已被触发 |     | State transition request has been triggered |     |
| 上交所 | 10406 | 交易时间表已经处于开启状态 |     | Trading schedule is already open |     |
| 上交所 | 10408 | 交易时间表已经处于关闭状态 |     | Trading schedule is already closed |     |
| 上交所 | 10410 | 已超过交易结束时段的开始时间 |     | Start time of end of trade has passed |     |
| 上交所 | 10412 | 无效的产品状态 |     | Invalid product status |     |
| 上交所 | 10414 | 无效的转换时间表 |     | Invalid conversion schedule |     |
| 上交所 | 10416 | PBU已经被删除 |     | PBU has been removed |     |
| 上交所 | 10420 | 无效帐户类型 |     | Invalid account type |     |
| 上交所 | 10424 | 订单数据已变更 |     | Order data has changed |     |
| 上交所 | 10426 | 该交易时段内无效执行限制 |     | Invalid execution limits during trading session |     |
| 上交所 | 10428 | 无效交易限制“OA” |     | Invalid Transaction Limit "OA" |     |
| 上交所 | 10430 | 无效交易限制“AU” |     | Invalid Transaction Limit "AU" |     |
| 上交所 | 10432 | 无效交易限制“FP” |     | Invalid Transaction Limit "FP" |     |
| 上交所 | 10434 | 无效买卖标志 |     | Invalid trade flag |     |
| 上交所 | 10436 | 帐户类型不可更改 |     | Account type cannot be changed |     |
| 上交所 | 10438 | 订单类型无效更改 |     | Invalid change of order type |     |
| 上交所 | 10440 | 市价转限价订单不可更改订单价格 |     | Market-to-Limit orders cannot change order price |     |
| 上交所 | 10442 | 无效订单数量及最高揭示数量组合 |     | Combination of number of invalid orders and maximum number revealed |     |
| 上交所 | 10444 | 订单数量小于最低订单数量要求 |     | The order quantity is less than the minimum order quantity requirement |     |
| 上交所 | 10446 | 无效交易员组代码 |     | Invalid trader groupID |     |
| 上交所 | 10448 | 该交易员不是高级交易员 |     | This trader is not an advanced trader |     |
| 上交所 | 10450 | 订单价格超出范围 |     | Order price exceeds range |     |
| 上交所 | 10454 | PBU 已经存在 |     | PBU already exist |     |
| 上交所 | 10456 | 参与者业务单元没有分配给下一级PBU |     | Participant business unit is not assigned to next level of PBU |     |
| 上交所 | 10462 | 无效的总部PBU |     | Invalid HQ PBU |     |
| 上交所 | 10464 | 存在重复记录 |     | There are duplicate records |     |
| 上交所 | 10468 | PBU 已经存在 |     | PBU already exist |     |
| 上交所 | 10470 | 对于找到的交易所没有默认的记录 |     | There is no default record for found exchanges |     |
| 上交所 | 10472 | 不存在相关的PBU关系 |     | The relevant PBU relationship does not exist |     |
| 上交所 | 10476 | 无效的pbu类型 |     | Invalid pbu type |     |
| 上交所 | 10478 | 无效的时间标记 |     | Invalid timestamps |     |
| 上交所 | 10480 | 不允许修改 |     | Modifications are not permitted |     |
| 上交所 | 10482 | 跨交易所会员字段为空 |     | Inter-Exchange Membership field is empty |     |
| 上交所 | 10486 | 无效PBU名称 |     | Invalid PBU name |     |
| 上交所 | 10488 | 无效的PBUID |     | Invalid PBUID |     |
| 上交所 | 10490 | 无效的PBU 类别 |     | Invalid PBU category |     |
| 上交所 | 10492 | 参与者业务单元已分配了下一级PBU |     | Participant business unit has been assigned next level of PBU |     |
| 上交所 | 10498 | 交易所身份权限不足 |     | ExchangeIDentity authority is insufficient |     |
| 上交所 | 10500 | HOSTSEC初始化失败 |     | HOSTSEC initialization failed |     |
| 上交所 | 10502 | 权限不足 |     | Insufficient permissions |     |
| 上交所 | 10504 | 活动状态权限不足 |     | Activity status permissions are insufficient |     |
| 上交所 | 10506 | 代表身份权限不足 |     | DelegateIDentity authority is insufficient |     |
| 上交所 | 10508 | PBU状态为停止交易或者PBU未激活 |     | The PBU status is either stopped trading or the PBU is not activated |     |
| 上交所 | 10510 | 不同PBU的交易要求被拒绝 |     | Transaction requests for different PBU was denied |     |
| 上交所 | 10512 | PBU交易标识为未激活（暂停状态，权限不足） |     |     |     |
| 上交所 | 10514 | 非高级的交易员 |     | Non-senior traders |     |
| 上交所 | 10516 | 交易员处于不活动状态 |     | Inactive PBU |     |
| 上交所 | 10518 | 未授权状态 |     | Unauthorized status |     |
| 上交所 | 10520 | 该执行限制对接受剩余订单无效 |     | Execution limit is not valid for acceptance of remaining orders |     |
| 上交所 | 10522 | 产品群已经存在 |     | Product group already exists |     |
| 上交所 | 10524 | PBU不能输入买方订单 |     | PBU cannot enter a buyer's order |     |
| 上交所 | 10528 | 无效的市场代码 |     | Invalid market code |     |
| 上交所 | 10532 | 无效的产品组代码 |     | Invalid product groupID |     |
| 上交所 | 10534 | 无效的PBUID |     | Invalid PBUID |     |
| 上交所 | 10536 | 无效参与者业务单元群组 |     | Invalid participant business unit group |     |
| 上交所 | 10540 | 参与者业务单元仍然处于激活状态 |     | Participant business unit remains active |     |
| 上交所 | 10544 | 指定的产品群中还有相关联的产品 |     | There are also related products in specified product group |     |
| 上交所 | 10546 | PBU不能输入卖方订单 |     | PBU cannot be entered into seller orders |     |
| 上交所 | 10548 | 无效产品组代码 |     | Invalid product groupID |     |
| 上交所 | 10550 | 无效产品组类型 |     | Invalid product group type |     |
| 上交所 | 10552 | 产品组已经存在 |     | Product group already exists |     |
| 上交所 | 10554 | 已经有产品分配给了将被删除的产品组 |     | There are already products assigned to product group that will be deleted |     |
| 上交所 | 10558 | 产品组已经分配了产品 |     | Product group has already been assigned product |     |
| 上交所 | 10560 | 买方订单不能为零手 |     | Buy order quantity cannot be zero |     |
| 上交所 | 10562 | 卖方订单不能为零手 |     | Sell order quantity cannot be zero |     |
| 上交所 | 10564 | 不存在的产品群 |     | Group of products that do not exist |     |
| 上交所 | 10566 | 交易时段未定义 |     | Trading session is not defined |     |
| 上交所 | 10568 | 订单类型和交易模型不匹配 |     | Order type and trading model do not match |     |
| 上交所 | 10570 | TP_TICSIZ 数据错误 |     | TP_TICSIZ Data errors |     |
| 上交所 | 10572 | 产品未被配置至市场或产品群 |     | Product is not configured to a market or product group |     |
| 上交所 | 10574 | 部分产品未得到处理 |     | Some products are not processed |     |
| 上交所 | 10576 | 无效的市场状态 |     | Invalid market status |     |
| 上交所 | 10578 | 不允许进行产品群的状态转换 |     | Status transitions for product groups are not allowed |     |
| 上交所 | 10590 | 订单的数量不是整手数 |     | Number of orders is not a whole lot |     |
| 上交所 | 10594 | 非当前业务的交易时间 |     | Trading hours that are not current for business |     |
| 上交所 | 10596 | 订单价格未遵循最小价格单位规则 |     | Order price not round by ticksize |     |
| 上交所 | 10604 | 被撤申报不存在 |     | The withdrawn declaration does not exist |     |
| 上交所 | 10606 | 投资者帐户类型对报价无效 |     | Investor account type is not valid for quotes |     |
| 上交所 | 10608 | 错误的止损限价 |     | Incorrect stop loss limit |     |
| 上交所 | 10610 | 找不到指定订单 |     | Can not find the specified order |     |
| 上交所 | 10614 | 该业务不允许撤单 |     | Cancellation of orders is not allowed for this business |     |
| 上交所 | 10616 | 无效的交易模型代码 |     | Invalid transaction modelID |     |
| 上交所 | 10618 | 无效的匹配优先级代码 |     | Invalid match priorityID |     |
| 上交所 | 10620 | 无效的竞价数量分配方案 |     | Invalid bidding quantity allocation scheme |     |
| 上交所 | 10622 | 无效的竞价匹配算法 |     | Invalid Bid Match algorithm |     |
| 上交所 | 10626 | 错误的营业部号码 |     | Wrong sales office number |     |
| 上交所 | 10630 | 不允许改变过去的时段或把将来的时段改到过去 |     | It is not permissible to change a past time slot or to change a future time slot to past |     |
| 上交所 | 10632 | 当前改变与下次时段改变之间的时差太短 |     | Time difference between current change and next time period change is too short |     |
| 上交所 | 10636 | 产品必须处于暂停状态 |     | Product must be in suspended state |     |
| 上交所 | 10640 | 错误的查询日期 |     | Wrong query date |     |
| 上交所 | 10642 | 错误的查询限价 |     | Incorrect query limit price |     |
| 上交所 | 10644 | 查询结束 |     | End of inquiry |     |
| 上交所 | 10646 | 无查询结果 |     | No search results |     |
| 上交所 | 10648 | 集合竞价剩余量分配方式未知 |     | Method of allocation of remaining volume of Call Auction is unknown |     |
| 上交所 | 10660 | PBU无分配产品组 |     | PBU unassigned product group |     |
| 上交所 | 10662 | 用户群组，产品组写入错误 |     | User group, product group write error |     |
| 上交所 | 10664 | 币别不存在 |     | Currency does not exist |     |
| 上交所 | 10666 | 币别已经存在 |     | Currency already exist |     |
| 上交所 | 10668 | 产品没有分配给子群组 |     | Product is not assigned to a subgroup |     |
| 上交所 | 10670 | PBU没有被分配特许权限 |     | PBU is not assigned privileged permissions |     |
| 上交所 | 10672 | 子群组没有被分配任何做市商特许权限 |     | Subgroup is not assigned any market maker privileges |     |
| 上交所 | 10674 | 无效的用户ID |     | Invalid userID |     |
| 上交所 | 10676 | 由于用户是DEFMBR,系统拒绝访问 |     | Since user is a DEFMBR, system denies access |     |
| 上交所 | 10678 | 用户不存在 |     | User does not exist |     |
| 上交所 | 10680 | 用户已经存在 |     | User already exists |     |
| 上交所 | 10682 | 无效的Agent标记,只能是Y或N |     | Invalid agent tag can only be Y or N |     |
| 上交所 | 10684 | 无效的Proprietary标记,只能是Y或N |     | Invalid Proprietary tag, can only be Y or N |     |
| 上交所 | 10686 | 无效的Senior标记,只能是Y或N |     | Invalid Senior token, can only be Y or N |     |
| 上交所 | 10688 | 无效的Market Maker标记,只能是Y或N |     | Invalid Market Maker token, can only be Y or N |     |
| 上交所 | 10690 | 试图成为Market Maker类型，但是目前尚不是Proprietary类型 |     | Trying to be Market Maker type, but not Proprietary at this moment |     |
| 上交所 | 10694 | 试图删除PBU管理者被拒绝 |     | Attempts to remove PBU manager were denied |     |
| 上交所 | 10696 | 无效的交易员状态 |     | Invalid trader status |     |
| 上交所 | 10698 | 由于用户是MBRSPV,系统拒绝访问 |     | Since user is MBRSPV, system denies access |     |
| 上交所 | 10700 | 订单数量小于最小协商订单交易数量 |     | Order quantity is less than minimum negotiated order transaction quantity |     |
| 上交所 | 10702 | 投资者帐户与PBU无指定交易关系 |     | Investor account not designated to the PBU |     |
| 上交所 | 10704 | 投资者帐户的指定交易关系未被激活 |     | Specified trading relationship for Investor account is not activated |     |
| 上交所 | 10706 | 投资者帐户已被暂停 |     | Investor account is suspended |     |
| 上交所 | 10708 | 投资者帐户类型对该产品无效 |     | Invalid AccountID type for this product |     |
| 上交所 | 10712 | 无效的投资者账户 |     | Invalid investor account id |     |
| 上交所 | 10716 | 无效的协商订单信息类型 |     | Invalid negotiated order information type |     |
| 上交所 | 10722 | 无效的结算日期 |     | Invalid settlement date |     |
| 上交所 | 10726 | 无效的协商订单 |     | Invalid negotiated order |     |
| 上交所 | 10730 | 无效的场外交易产品 |     | Invalid OTC products |     |
| 上交所 | 10732 | 用户不存在或者已经被删除 |     | User does not exist or has been deleted |     |
| 上交所 | 10734 | 不能计算收盘价 |     | Closing prices cannot be calculated |     |
| 上交所 | 10738 | 收市时段已经开始 |     | Closing session has begun |     |
| 上交所 | 10740 | 该订单申报的业务已结束 |     | The business declared for this order has ended |     |
| 上交所 | 10744 | 超出当日最高、最低成交价范围 |     | Exceeding highest of day, Range of lowest traded price |     |
| 上交所 | 10746 | 交易币种不匹配 |     | Transaction currencies do not match |     |
| 上交所 | 10748 | 产品不匹配 |     | Products don't match |     |
| 上交所 | 10750 | 订单类型不匹配 |     | Order type does not match |     |
| 上交所 | 10752 | 订单买卖方向不匹配 |     | Order order direction mismatch |     |
| 上交所 | 10754 | 系统状态编号不存在 |     | System status number does not exist |     |
| 上交所 | 10756 | 无目标地址 |     | No target address |     |
| 上交所 | 10758 | 订单数量不匹配 |     | Order quantity does not match |     |
| 上交所 | 10760 | 订单价格不匹配 |     | Order price does not match |     |
| 上交所 | 10762 | 该产品无做市商 |     | There is no market maker for this product |     |
| 上交所 | 10764 | 对手方PBU不匹配 |     | Counterparty PBU does not match |     |
| 上交所 | 10766 | 协商订单号不匹配 |     | Negotiated order numbers do not match |     |
| 上交所 | 10768 | 结算代码不匹配 |     | Billing codes don't match |     |
| 上交所 | 10770 | 结算日期不匹配 |     | Settlement dates don't match |     |
| 上交所 | 10772 | 结算币种不匹配 |     | Settlement currency doesn't match |     |
| 上交所 | 10774 | 产品被暂停场外交易 |     | Product is suspended from over-the-counter trading |     |
| 上交所 | 10776 | 产品被暂停协商交易 |     | Product is suspended from negotiating transactions |     |
| 上交所 | 10780 | 日期已存在 |     | Date already exists |     |
| 上交所 | 10782 | 日期不多于当前日期两天 |     | Date is no more than two days older than current date |     |
| 上交所 | 10784 | 日期不早于八天前 |     | Date is no earlier than eight days ago |     |
| 上交所 | 10786 | 对指定的产品没有设置许可证信息 |     | No license information has been set for specified product |     |
| 上交所 | 10788 | 消息长度不正确 |     | Message length is incorrect |     |
| 上交所 | 10790 | 托管PBU不存在 |     | Managed PBU does not exist |     |
| 上交所 | 10792 | 用户上下文内容太长 |     | User context content is too long |     |
| 上交所 | 10794 | 投资者账户不存在 |     | Investor account does not exist |     |
| 上交所 | 10796 | 不允许创建指定交易关系 |     | Creating specified transaction relationships is not allowed |     |
| 上交所 | 10798 | 无效类型 |     | Invalid type |     |
| 上交所 | 10800 | 投资者和当前PBU已经存在指定交易关系 |     | Account already designated |     |
| 上交所 | 10802 | 无效标志位 |     | Invalid flags |     |
| 上交所 | 10804 | 该帐号已指定在其它席位 |     | Account has assigned to other seats |     |
| 上交所 | 10806 | 不允许撤销指定交易关系 |     | Revocating specified transaction relationships is not allowed |     |
| 上交所 | 10808 | 无效状态 |     | Invalid status |     |
| 上交所 | 10812 | 指定的交易不存在 |     | Designated trading not exist |     |
| 上交所 | 10820 | 请求被拒绝:基础数据维护阻塞阶段 |     | Request Denied: Underlying data maintenance is blocked |     |
| 上交所 | 10822 | 无效的基础产品（非债券） |     | Inactive underlying products (non-bonds) |     |
| 上交所 | 10824 | 无效的基础产品（不在同一市场） |     | Invalid base product (not in same market) |     |
| 上交所 | 10826 | 数据被非法修改 |     | Data has been illegally modified |     |
| 上交所 | 10828 | 无效更新持仓数量 |     | Invalid update of number of positions |     |
| 上交所 | 10836 | 投资者持仓不足 |     | Investor holding position not enough |     |
| 上交所 | 10838 | 对手方不存在 |     | Counterparty does not exist |     |
| 上交所 | 10840 | 买方用户不存在 |     | Buyer does not exist |     |
| 上交所 | 10842 | 卖方用户不存在 |     | Seller does not exist |     |
| 上交所 | 10844 | 该做市商未授权输入报价请求 |     | Market maker did not authorize entry of quote request |     |
| 上交所 | 10852 | 无效的交易状态 |     | Invalid transaction status |     |
| 上交所 | 10854 | 指定的未到期报价不存在 |     | The specified unexpired offer does not exist |     |
| 上交所 | 10868 | 重复的记录 |     | Duplicate records |     |
| 上交所 | 10884 | 存在已分配的被托管PBU |     | There is already allocated managed PBU present |     |
| 上交所 | 10886 | 无效的托管PBU |     | Invalid hosted PBU |     |
| 上交所 | 10888 | 无效的产品群（不在同一市场） |     | Invalid product group (not in same market) |     |
| 上交所 | 10894 | 订单未被冻结 |     | Order is not blocked |     |
| 上交所 | 10896 | 报价未被冻结 |     | Offer is not frozen |     |
| 上交所 | 10900 | 已存在冻结报价 |     | Frozen offer already exists |     |
| 上交所 | 10902 | 不支持的交易类型 |     | Unsupported transaction type |     |
| 上交所 | 10916 | 无效的场外交易交易日期 |     | Invalid OTC trade dates |     |
| 上交所 | 10918 | 被代理者权限不足 |     | Authority of agent is insufficient |     |
| 上交所 | 10920 | 品种特许权限已被分配 |     | Breed privilege has been assigned |     |
| 上交所 | 10924 | 品种未被分配给PBU |     | Varieties is not assigned to PBU |     |
| 上交所 | 10926 | 品种特许权限已被分配给Subgroup |     | Breed privileges have been assigned to Subgroup |     |
| 上交所 | 10928 | 品种特许权限未被分配给Subgroup |     | Variety privileges are not assigned to Subgroup |     |
| 上交所 | 10930 | 不正确的市场状态 |     | Wrong market status |     |
| 上交所 | 10932 | 产品状态资源访问授权不足 |     | Does not have permissions to access product status resource |     |
| 上交所 | 10934 | 被代理者处于非活动状态 |     | Agent is inactive |     |
| 上交所 | 10938 | 无效品种代码 |     | Invalid symbol code |     |
| 上交所 | 10940 | 品种已经存在 |     | Breed already exists |     |
| 上交所 | 10942 | 品种下仍然存在合约 |     | There are still contracts under symbol |     |
| 上交所 | 10944 | 无效的持仓检查 |     | Invalid position checks |     |
| 上交所 | 10946 | 无效的会员清算代码 |     | Invalid Member Clearing Code |     |
| 上交所 | 10948 | 外部系统(EAI)使用的PBUID没有配置 |     | PBUID used by external system (EAI) is not configured |     |
| 上交所 | 10952 | 指定的ISIN代码无效 |     | Specified ISIN code is invalid |     |
| 上交所 | 10956 | PBU已经被暂停 |     | PBU has been suspended |     |
| 上交所 | 10958 | 无效合约到期月份 |     | Expiration month of invalid contract |     |
| 上交所 | 10960 | 该月期货合约已经生成 |     | Futures contract for month has been generated |     |
| 上交所 | 10962 | 无效消息长度 |     | Invalid message length |     |
| 上交所 | 10964 | 品种不存在 |     | Breed does not exist |     |
| 上交所 | 10966 | 无效最后合约自动生成日 |     | Invalid last contract automatic generation date |     |
| 上交所 | 10968 | 对同一议案重复投票 |     | Vote on same motion repeatedly |     |
| 上交所 | 10970 | 更新持仓时所需保证金不足 |     | The margin required to update a position is insufficient |     |
| 上交所 | 10972 | 非法的默认缴费包类型 |     | Illegal default payment package type |     |
| 上交所 | 10978 | ETF请求总量超过当日阀值 |     | Total number of ETF requests exceeds threshold for day |     |
| 上交所 | 10980 | 无效的非交易类型 |     | Invalid non-transaction type |     |
| 上交所 | 10982 | 无效的分配日期 |     | Invalid assignment date |     |
| 上交所 | 10986 | 无效的配号规则表 |     | Invalid numbering rule table |     |
| 上交所 | 10988 | 无效的比例配售比例 |     | Invalid proportional allotment ratio |     |
| 上交所 | 10990 | 无效的交割价格类型 |     | Invalid delivery price type |     |
| 上交所 | 10992 | 无效的承销商PBU代码 |     | Invalid underwriter PBU code |     |
| 上交所 | 10994 | 无效的承销商投资者账户 |     | Invalid Underwriter Investor Account |     |
| 上交所 | 11002 | 无效的最后交易日期（与衍生产品冲突） |     | Invalid last traded Date (Conflict with Derivatives) |     |
| 上交所 | 11004 | 无效的最后交易日期（与非交易信息冲突） |     | Invalid last traded Date (Conflicts with Non-Traded Information) |     |
| 上交所 | 11006 | 无效的首次交易日期（与非交易信息冲突） |     | Invalid first traded date (conflicting with non-trade information) |     |
| 上交所 | 11008 | 未填写转换价格 |     | Conversion price is not filled |     |
| 上交所 | 11012 | 缺少必填的信息 |     | Required information is missing |     |
| 上交所 | 11018 | 删除承销商PBU被拒绝 |     | Removal of underwriter PBU was rejected |     |
| 上交所 | 11024 | EzCS解密PBU密码失败 |     | EzCS failed to decrypt PBU password |     |
| 上交所 | 11026 | 无效的投资者类型 |     | Invalid investor type |     |
| 上交所 | 11028 | 无效的产品代码 |     | Invalid product code |     |
| 上交所 | 11032 | 该产品不适用 |     | Product is not applicable |     |
| 上交所 | 11034 | 请求超出有效的时期 |     | Request exceeds a limited period of time |     |
| 上交所 | 11036 | 无效的交易员代码 |     | Invalid trader code |     |
| 上交所 | 11038 | 无效的分红选择 |     | Invalid dividend selection |     |
| 上交所 | 11040 | 无效的份额来源/份额目的 |     | Invalid share source or purpose |     |
| 上交所 | 11042 | 非交易类型与产品不匹配 |     | Non-transaction type does not match product |     |
| 上交所 | 11044 | 无效的持仓解冻数量 |     | Number of invalid positions have been unfrozen |     |
| 上交所 | 11046 | 无效的非交易订单价格 |     | Price of invalid non-trading order |     |
| 上交所 | 11048 | 无效的非交易订单金额 |     | Amount of invalid non-trading order |     |
| 上交所 | 11050 | 投资者持仓状态不存在 |     | Investor holding position status not exist |     |
| 上交所 | 11052 | 无效的ETF订单数量 |     | Number of invalid ETF orders |     |
| 上交所 | 11054 | 不允许ETF申购 |     | ETF subscription is not allowed |     |
| 上交所 | 11056 | 不允许ETF赎回 |     | ETF redemption is not allowed |     |
| 上交所 | 11058 | ETF定义未找到 |     | ETF definition not found |     |
| 上交所 | 11060 | 该PBU没有该产品的买权限 |     | PBU doesn't have buy right for the instrument |     |
| 上交所 | 11062 | 产品买卖标志无效。 |     | Invalid product trade flag |     |
| 上交所 | 11064 | 该PBU没有该产品的卖权限 |     | PBU doesn't have sell right not the instrument |     |
| 上交所 | 11068 | 该PBU无权限交易此产品 |     | PBU has no permission to trade |     |
| 上交所 | 11070 | 品种代码或到期月份不能被修改 |     | Symbol code or expiration month cannot be modified |     |
| 上交所 | 11072 | 指定交易类型无效 |     | Specified transaction type is invalid |     |
| 上交所 | 11076 | 合约简称前缀重复 |     | Contract abbreviation prefix is duplicated |     |
| 上交所 | 11078 | 合约产品前缀重复 |     | Contract product prefix is duplicated |     |
| 上交所 | 11080 | 投资者对该产品没有买权限 |     | The investor does not have permission to buy for this product |     |
| 上交所 | 11082 | 投资者对该产品没有卖权限 |     | The investor does not have permission to sell this product |     |
| 上交所 | 11084 | 订单买/卖方向不能修改。 |     | Order direction of order cannot be modified |     |
| 上交所 | 11090 | 无效的停牌状态更改 |     | Invalid suspension status changes |     |
| 上交所 | 11094 | 不能删除一个席位连通群组的主参与者单元. |     | It is not possible to delete main participant unit of seat-connected group |     |
| 上交所 | 11098 | 无效的最大订单数量 |     | Invalid maximum order quantity |     |
| 上交所 | 11100 | 无效的输入开始日期 |     | Invalid entry start date |     |
| 上交所 | 11102 | 无效的输入结束日期 |     | Invalid input end date |     |
| 上交所 | 11106 | 无效的上市交易日 |     | Invalid listing trading day |     |
| 上交所 | 11108 | 无效的转换价格 |     | Invalid conversion price |     |
| 上交所 | 11110 | 无效的非交易订单数量 |     | Number of invalid non-trading orders |     |
| 上交所 | 11116 | 非法更新已冻结的订单 |     | Illegally updating frozen order |     |
| 上交所 | 11118 | 修改撮合优先权无效 |     | Modification of matching priority is invalid |     |
| 上交所 | 11122 | 撮合优先权和竞价数量分配方案组合无效 |     | Combination of matching priority and auction quantity allocation scheme is invalid |     |
| 上交所 | 11124 | 该产品不允许输入单边报价 |     | Product does not allow entry of one-sided quotes |     |
| 上交所 | 11126 | PBU无此非交易权限 |     | PBU does not has non-trading permission |     |
| 上交所 | 11128 | 投资者无此非交易权限 |     | The investor does not have authorization for this have non-trading |     |
| 上交所 | 11130 | 非交易服务不可用 |     | Non-transaction services not available |     |
| 上交所 | 11132 | 不适用于此子类型产品 |     | Not available for this sub-type of product |     |
| 上交所 | 11134 | 投资者账号没有被授权进行权证创设和注销 |     | Investor account is not authorized to create and cancel warrants |     |
| 上交所 | 11138 | 投资者已经是冻结状态 |     | Investor is already frozen |     |
| 上交所 | 11140 | 投资者已经是解冻状态 |     | Investor is already in a state of thawing |     |
| 上交所 | 11148 | 无效的检验日期 |     | Invalid inspection date |     |
| 上交所 | 11150 | 无效的转换基金 |     | Invalid switching fund |     |
| 上交所 | 11152 | 指定交易取消请求正在处理中 |     | The specified trade cancellation request is being processed |     |
| 上交所 | 11154 | 政府债券担保投资者持仓不足 |     | Under-sufficiency of government bond guaranteed investors |     |
| 上交所 | 11156 | 权证担保帐户不可以被激活 |     | Warrant Secured Accounts cannot be activated |     |
| 上交所 | 11162 | 无效的转指定交易目标方 |     | Invalid transfer to specified transaction target |     |
| 上交所 | 11166 | 投资者已与其他PBU存在指定交易关系 |     | The investor has a designated trading relationship with other PBUs |     |
| 上交所 | 11170 | 无效的跨交易所代号 |     | Invalid cross-exchange symbols |     |
| 上交所 | 11172 | 无效的产品群代码 |     | Invalid product groupID |     |
| 上交所 | 11174 | 指定的产品群中还有相关联的品种 |     | There are also associated varieties in specified product group |     |
| 上交所 | 11182 | 指定的产品组中还有相关联的品种 |     | There are also associated varieties in specified product group |     |
| 上交所 | 11194 | 可引起波动性中断的市价或市价转限价订单 |     | Market order or market-to-limit order can cause volatility break |     |
| 上交所 | 11196 | 无效的审核标志 |     | Invalid audit flag |     |
| 上交所 | 11200 | 内存订单簿耗光 |     | The memory order book is depleted |     |
| 上交所 | 11202 | 错误的请求PBU |     | Invalid pbu |     |
| 上交所 | 11204 | 正在计算闭市价格… |     | Calculating closing price... |     |
| 上交所 | 11206 | 无效的担保品标志 |     | Invalid collateral flag |     |
| 上交所 | 11208 | 无效的融资标志 |     | Invalid financing flag |     |
| 上交所 | 11210 | 无效的融券标志 |     | Invalid security lending flag |     |
| 上交所 | 11212 | 普通帐户不允许信用交易 |     | Credit transaction is not allowed on regular account |     |
| 上交所 | 11214 | 信用帐户不允许普通交易 |     | Ordinary transaction is not allowed on credit account |     |
| 上交所 | 11218 | 不正确的信用标签类型 |     | Wrong credit label type |     |
| 上交所 | 11220 | 产品不能作为抵押品交易 |     | Instrument can't be traded as collateral |     |
| 上交所 | 11226 | 没有对应的证券公司融券专用帐户 |     | There is no corresponding special account for security borrowing and lending |     |
| 上交所 | 11228 | 无效信用标签 |     | Invalid credit tag |     |
| 上交所 | 11230 | 投资者非交易持仓不足 |     | Investor has insufficient non-trading position |     |
| 上交所 | 11236 | 该PBU无融资买入权限 |     | PBU has no permission to buy |     |
| 上交所 | 11238 | 该PBU无融券卖出权限 |     | PBU has no permission to sell |     |
| 上交所 | 11240 | 该时段不允许删除订单 |     | Not allowed to delete order during this period |     |
| 上交所 | 11244 | 订阅一个广播流的数量限制被超出 |     | Limit on number of subscriptions to a broadcast stream is exceeded |     |
| 上交所 | 11246 | 交易时间未到 |     | The trading time has not yet arrived |     |
| 上交所 | 11248 | 基准价格在上市日期前不允许被更新 |     | Benchmark price is not allowed to be updated prior to listing date |     |
| 上交所 | 11250 | 基准价格在目前的时段不允许被更新 |     | Benchmark price is not allowed to be updated during current session |     |
| 上交所 | 11252 | 不允许更新有涨跌幅控制产品的价格范围 |     | It is not allowed to update price range of products with price control |     |
| 上交所 | 11254 | 券商融券专用帐户不可以激活 |     | Special account for security lending and borrowing cannot be activated |     |
| 上交所 | 11258 | 转换基金代码不适用 |     | Conversion of fund code is not applicable |     |
| 上交所 | 11262 | PBU对该产品子类型没有买权限。 |     | PBU does not have right to buy this product subtype |     |
| 上交所 | 11264 | PBU对该产品子类型没有卖权限。 |     | PBU does not have sell rights on this product subtype |     |
| 上交所 | 11266 | 投资者对该产品子类型没有买权限 |     | The investor does not have purchasing authorization for this product subtype |     |
| 上交所 | 11268 | 投资者对该产品子类型没有卖权限 |     | The investor does not have selling authorization for this product subtype |     |
| 上交所 | 11270 | 订单重传 |     | Resend the order |     |
| 上交所 | 11272 | 老回购不允许操作 |     | Old repo does not allow operations |     |
| 上交所 | 11276 | 后台广播重传不可用 |     | Background broadcast retransmission is not available |     |
| 上交所 | 11278 | 无效的广播重传请求范围 |     | Invalid broadcast retransmission request range |     |
| 上交所 | 11280 | 后台发现无效的广播记录无法重传 |     | Broadcast record found in background is invalid and cannot be retransmitted |     |
| 上交所 | 11282 | 后台广播重传出现未知错误 |     | Unknown error occurred with background broadcast retransmission |     |
| 上交所 | 11284 | 不能在未开始的集合竞价中插入紧急停牌 |     | Emergency halt cannot be inserted in call auction that has not started |     |
| 上交所 | 11288 | 投资者有未处理的订单 |     | Account cancel designation disallowed |     |
| 上交所 | 11290 | 主PBU不存在 |     | Primary PBU does not exist |     |
| 上交所 | 11292 | 主PBU不是内部PBU |     | Primary PBU is not internal PBU |     |
| 上交所 | 11296 | 主PBU的主PBU不是它自身 |     | Primary PBU of primary PBU is not itself |     |
| 上交所 | 11298 | 试图将现有主PBU的主PBU修改成其它PBU |     | Attempt is made to modify primary PBU of existing primary PBU to a different PBU |     |
| 上交所 | 11300 | PBU的missid未被分配无法强制注销 |     | Missid of PBU cannot be forcibly logged out if it is not assigned |     |
| 上交所 | 11302 | PBU未登录无法强制注销 |     | PBU is not logged in, it cannot be forcibly logged out |     |
| 上交所 | 12000 | 报表授权关系已存在 |     | Report authorization relationship already exists |     |
| 上交所 | 12002 | 报表授权关系不存在 |     | Report authorization relationship does not exist |     |
| 上交所 | 12004 | 已达到最大授权PBU个数 |     | Maximum number of authorized PBU has been reached |     |
| 上交所 | 12006 | 使用的PBU无权限上传对应的ETF定义文件 |     | PBU does not have permission to upload corresponding ETF definition file |     |
| 上交所 | 12008 | 无效的ETF类型 |     | Invalid ETF types |     |
| 上交所 | 12010 | 无效的ETF定义文件日期 |     | Invalid ETF definition file date |     |
| 上交所 | 12012 | PBU无权限下载指定报表 |     | PBU does not have permission to download specified report |     |
| 上交所 | 12014 | 无效的下载文件大小 |     | Invalid download file size |     |
| 上交所 | 12016 | 后台无法提供服务 |     | Backend is unable to provide service |     |
| 上交所 | 12018 | ETF定义文件检查错误 |     | ETF definition file check for error |     |
| 上交所 | 12020 | 报表PBU与授权PBU相同 |     | Report PBU is same as authorized PBU |     |
| 上交所 | 12022 | 当前时段无法下载报表 |     | Report can't be downloaded for current period |     |
| 上交所 | 12024 | ETF产品代码错误 |     | ETF product code is incorrect |     |
| 上交所 | 12026 | 基金公司与文件不匹配 |     | Fund house does not match documents |     |
| 上交所 | 12028 | 定义文件版本号小于当前版本 |     | Definition file version number is smaller than current version |     |
| 上交所 | 12032 | 最优五档及时成交剩余撤销市价订单对手方无未成交订单 |     | Best five levels are timely executed, and remaining cancelled market orders have no unfilled orders on counterparty |     |
| 上交所 | 12034 | 最优五档及时成交剩余转限价市价订单对手方和本方均无未成交订单 |     | Best five levels are timely executed, and there are no unfilled orders on counterparty and other side of remaining market orders |     |
| 上交所 | 12036 | 限价即时全部成交类型订单可成交对手方不足 |     | Limit price is real-time, all types of orders can be filled, and the counterparty is insufficient |     |
| 上交所 | 12038 | 市价即时全部成交类型订单可成交对手方不足 |     | The market price is real-time, and the fillable counterparty of all types of orders is insufficient |     |
| 上交所 | 12040 | 订单重复 |     | Duplicate orders |     |
| 上交所 | 13300 | 繁忙,TXN被拒绝。请再试一次 |     | Busy, TXN rejected. Please try again |     |
| 上交所 | 13302 | 连通圈已经存在 |     | Connectivity circle already exists |     |
| 上交所 | 13304 | 未上市的产品 |     | Instrument not listed |     |
| 上交所 | 13306 | 后台弹回请求 |     | Background bounce requests |     |
| 上交所 | 13310 | 交易时段重迭 |     | Trading sessions overlap |     |
| 上交所 | 13312 | CS弹回请求 |     | CS bounce request |     |
| 上交所 | 13314 | ETF申购赎回失败（基金经理持仓不足） |     | ETF subscription and redemption failure (insufficient fund manager's position) |     |
| 上交所 | 13316 | ETF申购赎回失败（投资者持仓不足） |     | ETF subscription and redemption failure (insufficient investor holdings) |     |
| 上交所 | 13318 | ETF申购赎回失败（现金替代比例超出） |     | ETF subscription and redemption failure (cash substitution ratio exceeded) |     |
| 上交所 | 13322 | 后台未配置任何广播流订阅权限 |     | Background does not have any broadcast stream subscription permissions configured |     |
| 上交所 | 13324 | 无任何市场操作权限 |     | Do not have any market operation permissions |     |
| 上交所 | 13326 | 无效的IPO发行数量 |     | Number of invalid IPO issuances |     |
| 上交所 | 13328 | 该操作员已经在其他地方登录 |     | Operator is already logged in elsewhere |     |
| 上交所 | 13330 | 无效的基本订单类型 |     | Invalid base order type |     |
| 上交所 | 13332 | 无效的订单类型和限价组合 |     | Invalid order types and limit combinations |     |
| 上交所 | 13334 | 无效的订单类型和最高揭示数量组合 |     | Combination of invalid order types and maximum revealed quantities |     |
| 上交所 | 13336 | 无效的最高揭示数量 |     | Maximum number of invalid revelations |     |
| 上交所 | 13338 | 无效的订单类型和产品组合 |     | Invalid OrderType and product combination |     |
| 上交所 | 13340 | 无效的订单数量 |     | The number of invalid orders |     |
| 上交所 | 13342 | 订单数量小于最高揭示数量 |     | Order quantity is less than maximum revealed quantity |     |
| 上交所 | 13344 | 订单数量小于冰山数量的最低要求 |     | Minimum requirement for order quantity to be less than number of icebergs |     |
| 上交所 | 13346 | 最高揭示数量小于最小最高揭示数量的最低要求 |     | Minimum requirement for maximum number of revelations to be less than minimum maximum number of revelations |     |
| 上交所 | 13348 | 无效的订单类型和交易限制组合 |     | Invalid order type and trading restriction combinations |     |
| 上交所 | 13350 | 无效的订单类型和执行限制组合 |     | Invalid order type and execution limit combination |     |
| 上交所 | 13354 | 无效的执行限制类型 |     | Invalid execution restriction type |     |
| 上交所 | 13356 | 无效的交易限制类型 |     | Invalid transaction restriction type |     |
| 上交所 | 13358 | 产品和产品群交易模型不匹配 |     | Product and product group transaction models do not match |     |
| 上交所 | 13360 | 不能在集合竞价时输入分销类型产品的买单 |     | It is not allowed to place a purchase order for products of the distribution type during the call auction |     |
| 上交所 | 13362 | 更新时段太迟,无法更新 |     | Update window is too late to update |     |
| 上交所 | 13366 | 尚在发行周期中的IPO不能删除 |     | IPO are still in issuance cycle cannot be deleted |     |
| 上交所 | 13368 | 当天新增的PBU不允许登录系统 |     | New PBU of day is not allowed to log in to system |     |
| 上交所 | 13370 | 主席位不能为空 |     | Presidency cannot be empty |     |
| 上交所 | 13374 | 无法登陆，交易员未激活 |     | Unable to log in, trader not activated |     |
| 上交所 | 13378 | 承销商投资者帐户与PBU无指定交易关系 |     | Underwriter investor account does not have designated trading relationship with PBU |     |
| 上交所 | 13380 | 承销商账户已被暂停 |     | Underwriter account has been suspended |     |
| 上交所 | 13382 | EZOES参考数据为空 |     | EZOES reference data is empty |     |
| 上交所 | 13384 | 不允许参加开盘集合竞价 |     | Participation in opening call auction is not permitted |     |
| 上交所 | 13386 | 公共存储区域内存槽耗光 |     | Public storage area is running out of memory slots |     |
| 上交所 | 13388 | 公共存储区域更新请求的时间戳已过时。 |     | Timestamp of public storage area update request is outdated. |     |
| 上交所 | 13390 | 公共存储区域内存槽中无数据 |     | There is no data in public storage area memory slot |     |
| 上交所 | 13392 | 关键字查询区含有非法数据 |     | Keyword query area contains illegal data |     |
| 上交所 | 13394 | 用户IP不在IP白名单内 |     | IP address of user is not in IP address whitelist |     |
| 上交所 | 13396 | OEF权限不能在线修改 |     | OEF permissions cannot be modified online |     |
| 上交所 | 13398 | 禁止限价订单交易 |     | Limit order forbidden |     |
| 上交所 | 13400 | 禁止市价订单交易 |     | Market order trading is prohibited |     |
| 上交所 | 13402 | 禁止市价转限价订单交易 |     | Market-to-limit order is prohibited |     |
| 上交所 | 13404 | 禁止冰山订单交易 |     | Iceberg order trading is prohibited |     |
| 上交所 | 13406 | 禁止协商订单交易 |     | Forbidden to negotiate order transactions |     |
| 上交所 | 13412 | 配股除权与送股除权不能在同一天进行 |     | Ex-rights of allotment and ex-rights of allotment cannot be carried out on same day |     |
| 上交所 | 13416 | 停牌时间超出允许范围 |     | Suspension period exceeds allowable range |     |
| 上交所 | 13418 | 复牌时间超出允许范围 |     | Resumption time is beyond allowable range |     |
| 上交所 | 13420 | 产品已经被停牌 |     | The product has been suspended |     |
| 上交所 | 13422 | 开盘集合竞价不允许复牌 |     | Opening call auction does not allow for resumption of trading |     |
| 上交所 | 13424 | 超过集合竞价最大订单配置量 |     | Exceed the maximum Volumeconfigured in the auction |     |
| 上交所 | 13426 | 撤单失败，未找到待撤订单的申报记录 |     | Order cancellation failed, and declared record of pending order was not found |     |
| 上交所 | 13428 | 被撤订单输入过，但是是废单 |     | Cancelled order has been entered, but it is invalid |     |
| 上交所 | 13430 | 撤单失败，未找到待撤订单的订单信息（如：已被完全撮合、已撤单、订单信息有误） |     | Failed to cancel the order, order information for the pending cancellation was not found |     |
| 上交所 | 13432 | 被撤订单本身即是撤单请求 |     | Cancelled order itself is chargeback request |     |
| 上交所 | 13434 | 撤单包含不一致的产品 |     | Cancel order has an inconsistent instrument |     |
| 上交所 | 13436 | 该证券不允许担保品买入 |     | Collateral is not allowed to be purchased for this security |     |
| 上交所 | 13438 | 该证券不允许融资买入 |     | Margin purchases are not permitted for this security |     |
| 上交所 | 13440 | 该证券不允许买券还券或融券平仓 |     | Not allowed to return by buying or margin trading by liquidating |     |
| 上交所 | 13442 | 该证券不允许融券卖出 |     | Security are not allowed to be sold by security borrowing |     |
| 上交所 | 13444 | 融券卖出申报价格低于最新成交价 |     | Declared price of security borrowing and selling is lower than last traded price |     |
| 上交所 | 13446 | 前台版本号不匹配 |     | The front-end version does not match |     |
| 上交所 | 13448 | 该证券不允许进行担保品卖出/卖券还款/平仓卖出 |     | Not allowed to sell collateral,sell securities or repayment,close a position |     |
| 上交所 | 13450 | 融券卖出不允许申报市价订单 |     | Selling is not allowed to declare market order |     |
| 上交所 | 13452 | 输入的请求订单掩码非法 |     | Requested order mask entered is invalid |     |
| 上交所 | 13454 | 不允许撤销非交易订单 |     | Cancel non-transation orders is prohibited |     |
| 上交所 | 13456 | ETF申赎上限超出 |     | The ETF subscription or redemption exceeds the maximum limit |     |
| 上交所 | 13458 | 交易主机忙 |     | Trading host busy |     |
| 上交所 | 13460 | 指令操作来源无效 |     | Source of instruction operation is invalid |     |
| 上交所 | 13462 | 指令持仓操作类型无效 |     | Order position operation type is invalid |     |
| 上交所 | 13464 | 冻结/解冻操作类型无效 |     | Freeze/unfreeze operation type is invalid |     |
| 上交所 | 13466 | 请求类型无效 |     | Invalid request type |     |
| 上交所 | 13468 | 过户方PBU已经被暂停 |     | Transfer PBU has been suspended |     |
| 上交所 | 13470 | 无效过户方PBU的PBU代码 |     | PBU code of invalid transferor's PBU |     |
| 上交所 | 13472 | 过户方投资者帐户与过户方PBU无指定交易关系 |     | There is no designated trading relationship between transferor's investor account and transferor's PBU |     |
| 上交所 | 13474 | 过户方投资者帐户已被暂停 |     | Transferee investor account has been suspended |     |
| 上交所 | 13476 | 无效过户方投资者帐户 |     | Invalid Transferee Investor Account |     |
| 上交所 | 13478 | 无效的过户方投资者类型 |     | Invalid transferee investor type |     |
| 上交所 | 13480 | 请求正在处理中 |     | Request is being processed |     |
| 上交所 | 13482 | ETF定义文件上传时间不合法 |     | Upload time of ETF definition file is not legal |     |
| 上交所 | 13484 | ETFPUT业务请求消息类型不合法 |     | Message type of ETFPUT service request is not valid |     |
| 上交所 | 13486 | 无效的登录PBU |     | Invalid login to PBU |     |
| 上交所 | 13488 | 买方账户无权限 |     | The buyer's account does not have permissions |     |
| 上交所 | 13490 | 卖方账户无权限 |     | Seller accounts do not have permissions |     |
| 上交所 | 13492 | 买方PBU不存在 |     | The buyer's PBU does not exist |     |
| 上交所 | 13494 | 卖方PBU不存在 |     | The seller PBU does not exist |     |
| 上交所 | 13496 | 买方PBU与登陆PBU不为同一会员 |     | The Buyer PBU and the Login PBU are not the same members |     |
| 上交所 | 13498 | 卖方PBU与登陆PBU不为同一会员 |     | The Seller PBU and the Login PBU are not the same member |     |
| 上交所 | 13500 | 买方PBU无权限 |     | The buyer PBU does not have permissions |     |
| 上交所 | 13502 | 卖方PBU无权限 |     | The seller PBU has no permission |     |
| 上交所 | 13504 | 该笔申报找不到对应的原始订单 |     | The declaration could not find the corresponding original order |     |
| 上交所 | 13506 | 申报超出会员配额上限 |     | Declare exceeding the membership quota limit |     |
| 上交所 | 13508 | 申报超出实际额度 |     | The declaration exceeds the actual amount |     |
| 上交所 | 13510 | 初始交易超出会员配额上限 |     | The initial transaction exceeds the membership quota limit |     |
| 上交所 | 13516 | 消息未找到 |     | Message not found |     |
| 上交所 | 13518 | 无效输入参数 |     | Invalid parameter |     |
| 上交所 | 13520 | 买方账户不是会员专属账户 |     | The Buyer Account is not a Member-only account |     |
| 上交所 | 13522 | 卖方账户不是会员专属账户 |     | Seller accounts are not members-only accounts |     |
| 上交所 | 13524 | 买方账户同原申报账户不一致 |     | The buyer's account is inconsistent with the original reporting account |     |
| 上交所 | 13526 | 卖方账户同原申报账户不一致 |     | The seller's account is inconsistent with the original reporting account |     |
| 上交所 | 13528 | 证券代码与原申报订单不一致 |     | The securities code is inconsistent with the original declaration order |     |
| 上交所 | 13530 | 申报数量与原申报订单不一致 |     | The declared quantity is inconsistent with the original declared order |     |
| 上交所 | 13532 | 无AddIdx权限, oper:%x, proc:%x |     | No AddIdx permissions, oper:%x, proc:%x |     |
| 上交所 | 13534 | 无Add权限, oper:%x, proc:%x |     | No Add permissions, oper:%x, proc:%x |     |
| 上交所 | 13536 | 无update权限, oper:%x, proc:%x |     | No update permissions, oper:%x, proc:%x |     |
| 上交所 | 13538 | 无read权限, oper:%x, proc:%x |     | No read permission, oper:%x, proc:%x |     |
| 上交所 | 13540 | 无del data权限, oper:%x, proc:%x |     | No del data permissions, oper:%x, proc:%x |     |
| 上交所 | 13542 | 无delIDx权限, oper:%x, proc:%x |     | No delIDx permissions, oper:%x, proc:%x |     |
| 上交所 | 13544 | 撤单标志的值非法 |     | The value of the chargeback flag is invalid |     |
| 上交所 | 13546 | 订单类型与原申报订单不一致 |     | The order type is inconsistent with the original declared order |     |
| 上交所 | 13548 | 购回交易日的值非法 |     | The value of the repurchase transaction date is illegal |     |
| 上交所 | 13550 | 金额字段非法 |     | The amount field is invalid |     |
| 上交所 | 13552 | 价格字段非法 |     | The price field is invalid |     |
| 上交所 | 13554 | 无效的会员信息代码 |     | Invalid Membership Information Code |     |
| 上交所 | 13556 | 该产品开盘集合竞价禁止撤单 |     | Opening call auction of product prohibits order cancellation |     |
| 上交所 | 13560 | 广播服务数据恢复中 |     | Broadcast service data recovery is ongoing |     |
| 上交所 | 13562 | PBU可用登录节点已用完 |     | The available login nodes of the PBU have been exhausted |     |
| 上交所 | 13564 | 产品简称前缀非法 |     | Prefix of product abbreviation is illegal |     |
| 上交所 | 13566 | 存在指定交易失败的账户 |     | There is an account where the specified transaction failed |     |
| 上交所 | 13568 | 所有账户指定交易失败 |     | All account assignments failed |     |
| 上交所 | 13570 | 指定交易处理中 |     | The specified transaction is being processed |     |
| 上交所 | 13572 | 对手方持仓不足 |     | Insufficient counterparty positions |     |
| 上交所 | 13574 | 无效的对手方账户 |     | Invalid counterparty accounts |     |
| 上交所 | 13576 | 对手方账户已经被暂停 |     | The counterparty account has been suspended |     |
| 上交所 | 13578 | 不是对手方账户的指定PBU |     | Not a designated PBU for a counterparty account |     |
| 上交所 | 13580 | 对手方PBU不存在 |     | The counterparty PBU does not exist |     |
| 上交所 | 13582 | 改变时间无效 |     | Invalid change time |     |
| 上交所 | 13586 | 恢复时间无效 |     | Invalid resume time |     |
| 上交所 | 13588 | 暂停时间无效 |     | Invalid suspend time |     |
| 上交所 | 13592 | 交易在未开始阶段，操作被禁止 |     | Operation is prohibited in non-start phase |     |
| 上交所 | 13594 | 本方最优市价订单申报无本方未成交订单 |     | Best market price of party declares that there are no unfilled orders of party |     |
| 上交所 | 13596 | 对手方最优市价订单申报无对手方未成交订单 |     | Counterparty best market orders are declared as unfilled orders without counterparties |     |
| 上交所 | 13598 | 超过保护价格 |     | More than protection price |     |
| 上交所 | 13600 | 无效的保护价格 |     | Invalid protection price |     |
| 上交所 | 13602 | 交易网关协议转换错误：无效的申报消息长度 |     | Transaction gateway protocol conversion error: Invalid declared message length |     |
| 上交所 | 13604 | 交易网关协议转换错误：无效的业务编号（BizID） |     | Transaction gateway protocol conversion error: Invalid transaction number (BizID) |     |
| 上交所 | 13606 | 交易网关协议转换错误：无效的会员内部订单编号（clOrdID） |     | Transaction gateway protocol conversion error: Invalid member internal order number (clOrdID) |     |
| 上交所 | 13608 | 交易网关协议转换错误：无效的订单买卖方向（Side） |     | Trading Gateway Protocol Conversion Error: Invalid Order Buying and Selling Direction (Side) |     |
| 上交所 | 13610 | 交易网关协议转换错误：无效的价格（Price） |     | Transaction gateway protocol conversion error: Invalid price |     |
| 上交所 | 13612 | 交易网关协议转换错误：无效的订单数量（OrderQty） |     | Transaction Gateway Protocol Conversion Error: Invalid Order Quantity (OrderQty) |     |
| 上交所 | 13614 | 交易网关协议转换错误：无效的订单类型 （OrdType） |     | Trading Gateway Protocol Conversion Error: Invalid Order Type (OrdType) |     |
| 上交所 | 13616 | 交易网关协议转换错误：无效的订单有效时间类型（TimeInForce） |     | Trading Gateway Protocol Conversion Error: Invalid Order Time Type (TimeInForce) |     |
| 上交所 | 13618 | 交易网关协议转换错误：无效的信用标签（CreditTag） |     | Transaction gateway protocol conversion error: Invalid credit tag (CreditTag) |     |
| 上交所 | 13620 | 交易网关协议转换错误：无效的营业部代码（BranchID） |     | Transaction gateway protocol conversion error: Invalid BranchID (BranchID) |     |
| 上交所 | 13622 | 交易网关协议转换错误：无效的销售人代码（Custodian） |     | Transaction gateway protocol conversion error: Invalid Custodian (Custodian) |     |
| 上交所 | 13624 | 交易网关协议转换错误：无效的分红方式（DividendSelect） |     | Trading gateway protocol conversion error: Invalid dividend method (DividendSelect) |     |
| 上交所 | 13626 | 交易网关协议转换错误：无效的目标证券代码（DestSecurity） |     | Trading Gateway Protocol Conversion Error: Invalid Target Security Code (DestSecurity) |     |
| 上交所 | 13628 | 交易网关协议转换错误：无效指定交易注册指令（DesignationInstruction） |     | Transaction gateway protocol conversion error: Invalid specified transaction registration instruction (DesignationInstruction) |     |
| 上交所 | 13630 | 交易网关协议转换错误：无效的指定交易注册类型（DesignationTransType） |     | Transaction Gateway Protocol Conversion Error: Invalid Specified Transaction Registration Type (DesignationTransType) |     |
| 上交所 | 13632 | 交易网关协议转换错误：无效的激活码,包含非法字符 |     | Transaction gateway protocol conversion error: Invalid activation code containing invalid characters (validationCode) |     |
| 上交所 | 13700 | 非法的消息类型 |     | Invalid message type ITCS |     |
| 上交所 | 13701 | 非法的证书类型 |     | Invalid certificate format: ITCS |     |
| 上交所 | 13702 | 非法的平台类型 |     | Invalid platform |     |
| 上交所 | 13703 | 非法的TDGW版本号格式 |     | Invalid SoftwareVersion (ITCS) of TDGW version |     |
| 上交所 | 13704 | 登录过程中techPbu需保持一致 |     | Inconsistent TechPBU during login |     |
| 上交所 | 13705 | 随机数签名错误 |     | Random number signature wrong signature ITCS |     |
| 上交所 | 13706 | 证书错误 |     | Wrong certificate ITCS |     |
| 上交所 | 13707 | 登录Cookie错误 |     | Login cookie error (wrong cookie) ITCS |     |
| 上交所 | 13710 | 密码错误 |     | Wrong password ITCS |     |
| 上交所 | 13711 | 非交易日禁止登录 |     | Login forbidden at non trading day ITCS |     |
| 上交所 | 13712 | 广播流的被订阅数量不可大于3 |     | The number of subscribers to a broadcast stream cannot be greater than 3 |     |
| 上交所 | 13713 | 平台交易时间未到 |     | Not platform trading time yet |     |
| 上交所 | 13714 | 平台停止服务 |     | Platform out of service |     |
| 上交所 | 13715 | 无法解析STEP消息体 |     | Unable to parse STEP message body ITCS |     |
| 上交所 | 13716 | 非法的业务PB |     | Illegal business PBU (BizPBU must belong to the same institute as TechPBU) ITCS |     |
| 上交所 | 13718 | 非法的平台分区号 |     | Invalid partitionNo |     |
| 上交所 | 13720 | 重复的平台扥区号 |     | Repeated partitionNo |     |
| 上交所 | 13722 | 非法的同步类型 |     | Invalid Sync Type |     |
| 上交所 | 13724 | 非法的同步序号 |     | Invalid sync seqNum |     |
| 上交所 | 14000 | pbu成交回报最大序号失败 |     | Pbu request execution report max seqno failed |     |
| 上交所 | 14002 | pbu重新传输执行报告失败 |     | Pbu retransmission execution report failed |     |
| 上交所 | 14004 | 无效的dsgn调整请求类型 |     | Invalid dsgn adjust reqtype |     |
| 上交所 | 14006 | 无效的tdgwID |     | Invalid tdgwID |     |
| 上交所 | 14008 | 已暂停的tdgwID |     | Paused tdgwID |     |
| 上交所 | 14010 | tdgwID和cert未授权给同一成员 |     | TdgwID and cert unauthorized to same member |     |
| 上交所 | 14012 | 未授权到指定平台的tdgwID |     | TdgwID unauthorized to specified platform |     |
| 上交所 | 17002 | 超出限制 |     | Exceed limit |     |
| 上交所 | 17004 | Inst禁止买入 |     | Inst is forbidded to buy |     |
| 上交所 | 17006 | Inst禁止卖出 |     | Inst is forbidded to sell |     |
| 上交所 | 17008 | Inst禁止买卖 |     | Inst is forbidded to buy and sell |     |
| 上交所 | 17010 | 无效的最高价格水平 |     | Invalid max price levels |     |
| 上交所 | 17012 | 无效请求或远程主机不可用 |     | Invalid Req Or Remote Host Unavailable |     |
| 上交所 | 17014 | EzEI主机列表 |     | EzEI Host List |     |
| 上交所 | 17016 | 更改为正常模式 |     | Change to Normal Mode |     |
| 上交所 | 17018 | 更改为同步模式 |     | Change to Sync Mode |     |
| 上交所 | 17020 | 产品已经仅可卖 |     | The product is already sellable only |     |
| 上交所 | 17022 | 产品已经不可买卖 |     | The product is no longer available for sale |     |
| 上交所 | 17024 | 产品已经可买卖 |     | The product is already available for sale |     |
| 上交所 | 17026 | 业务禁止买 |     | Business is forbidden to buy |     |
| 上交所 | 17028 | 业务禁止卖 |     | Business is forbidden to sell |     |
| 上交所 | 17030 | 业务禁止买卖 |     | Buying and selling is prohibited |     |
| 上交所 | 17032 | 无效的业务权限 |     | Invalid business permissions |     |
| 上交所 | 17034 | 无效的生效日期 |     | Invalid Effective Date |     |
| 上交所 | 17036 | 无效的状态标识 |     | Invalid statusID |     |
| 上交所 | 17038 | 非法的有效期 |     | INVALID TIMEINFORCE |     |
| 上交所 | 17040 | 无效的金额 |     | Invalid amounts |     |
| 上交所 | 17042 | 权限未设置 |     | Permissions are not set |     |
| 上交所 | 17044 | 权限已限制 |     | Permissions are restricted |     |
| 上交所 | 17046 | 该pbu不能进行权限操作 |     | The PBU cannot perform permission operations |     |
| 上交所 | 17048 | 无效的参考汇率 |     | Invalid reference exchange rate |     |
| 上交所 | 17566 | 会员结算准备金不足以开新仓 |     | The member's settlement reserve is not enough to open a new position |     |
| 上交所 | 17568 | 计算权利金价格错误 |     | The premium price was calculated incorrectly |     |
| 上交所 | 17570 | 计算期权保证金错误 |     | Option margin calculation error |     |
| 上交所 | 17572 | 资金不足以支付权利金 |     | The funds are not sufficient to pay the royalty |     |
| 上交所 | 17574 | 资金不足以支付保证金 |     | The funds are insufficient to cover the security deposit |     |
| 上交所 | 17576 | 期权开平仓类型错误 |     | The option is of the wrong type of opening and closing |     |
| 上交所 | 17582 | 无效的投资者类型 |     | Invalid investor type |     |
| 上交所 | 17584 | 开平仓方向不一致 |     | The direction of opening and closing positions is inconsistent |     |
| 上交所 | 17586 | 无效的结算会员 |     | Invalid Clearing Member |     |
| 上交所 | 17588 | 无效的期权代码 |     | Invalid option code |     |
| 上交所 | 17590 | 无效的价格量纲 |     | Invalid price dimension |     |
| 上交所 | 17592 | 产品超过最后交易日 |     | The product is past the last trading day |     |
| 上交所 | 17594 | 非法的行权申请日 |     | The date on which the application for the exercise of the rights was unlawful |     |
| 上交所 | 17598 | 无效的备兑标签 |     | Invalid covered label |     |
| 上交所 | 17602 | 未实现的功能请求 |     | Unimplemented feature requests |     |
| 上交所 | 17604 | 无效的账户类型 |     | Invalid account type |     |
| 上交所 | 17606 | 持仓超过账户标的限制 |     | The position exceeds the limit of the account's underlying position |     |
| 上交所 | 17608 | 持仓超过会员标的限制 |     | The position exceeds the limit of the member's target |     |
| 上交所 | 17610 | 持仓超过会员全市场限制 |     | The position exceeds the member's market-wide limit |     |
| 上交所 | 17612 | 备兑持仓不足 |     | Covered positions are insufficient |     |
| 上交所 | 17614 | 买入开仓不允许备兑 |     | Cover is not allowed for buy open positions |     |
| 上交所 | 17616 | 卖出平仓不允许备兑 |     | Cover is not allowed to sell to close positions |     |
| 上交所 | 17618 | 认沽期权不允许备兑 |     | Covered put options are not permitted |     |
| 上交所 | 17622 | 锁定现货不足 |     | Lock-in stock is insufficient |     |
| 上交所 | 17624 | FOK订单触发VOLA |     | FOK order triggers VOLA |     |
| 上交所 | 17626 | 无效的处理类别 |     | Invalid processing category |     |
| 上交所 | 17628 | 开盘集合竞价不允许申报此类型订单 |     | This type of order is not allowed to be declared in the opening call auction |     |
| 上交所 | 17630 | 盘中集合竞价不允许申报此类型订单 |     | This type of order is not allowed to be declared in the intraday call auction |     |
| 上交所 | 17632 | 无效的资金账户类型 |     | Invalid Funding Account Type |     |
| 上交所 | 17634 | 设置或查询产品信息失败 |     | Failed to set or query product information |     |
| 上交所 | 17636 | 持仓超过账户全市场限制 |     | The position exceeds the account's market-wide limit |     |
| 上交所 | 17638 | PBU对该资金账户没有查询权限 |     | The PBU does not have access to the funding account |     |
| 上交所 | 17640 | 该产品已取消限开仓限制 |     | The product has removed the limit on open positions |     |
| 上交所 | 17642 | 该产品已设置限开仓限制 |     | The product has a limit on opening positions |     |
| 上交所 | 117644 | 当前交易日无效 |     | Invalid on the current trading day |     |
| 上交所 | 17646 | 日期小于当前交易日期 |     | The date is less than the current trading date |     |
| 上交所 | 17648 | VOLA最后一分钟不允许删除订单 |     | VOLA does not allow last-minute deletion of orders |     |
| 上交所 | 17650 | 资金额度过大 |     | The amount of funds is too large |     |
| 上交所 | 17652 | PBU无开仓权限 |     | PBUs do not have the permission to open positions |     |
| 上交所 | 17654 | PBU无平仓权限 |     | PBUs do not have the right to close positions |     |
| 上交所 | 17656 | 无效的投资者账户子编码 |     | Invalid investor account subcode |     |
| 上交所 | 17658 | 合约无买入开仓权限 |     | There is no permission to buy and open a position |     |
| 上交所 | 17660 | 合约无非备兑卖出开仓权限 |     | Contracts do not have the right to open positions without covered selling |     |
| 上交所 | 17662 | 合约无备兑卖出开仓权限 |     | Futures do not have the permission to open covered sell positions |     |
| 上交所 | 17664 | 合约结算价异常 |     | The settlement price of the contract is abnormal |     |
| 上交所 | 17668 | 收盘集合竞价最后一分钟不允许删除订单 |     | Closing Call Auction last minute does not allow order deletion |     |
| 上交所 | 17670 | 收盘集合竞价不允许申报此类型订单 |     | This type of order is not allowed to be declared in the closing call auction |     |
| 上交所 | 18200 | 打包消息中消息头的信息错误 |     | Package message header is broken |     |
| 上交所 | 18202 | 打包消息中的指令长度错误 |     | Invalid message length |     |
| 上交所 | 18204 | 持仓更新指令掩码中的双边信息与输入参数不一致 |     | The two-sided information in the position update order mask is inconsistent with the input parameters |     |
| 上交所 | 18206 | 无效的请求掩码 |     | Invalid request mask |     |
| 上交所 | 18208 | 持仓更新指令的掩码尚未启用 |     | The mask for the position update order has not yet been enabled |     |
| 上交所 | 18210 | 持仓更新指令的掩码不可用于ETF申赎 |     | The mask of the position update order cannot be used for ETF subscription and redemption |     |
| 上交所 | 18600 | 当前时间不在业务设置时间段内 |     | The current time is not within the time period set by the business |     |
| 上交所 | 19000 | 未指定的格式错误 |     | Unspecified format error |     |
| 上交所 | 19002 | 产品代码格式错误 |     | The productID is malformed |     |
| 上交所 | 19004 | 账号格式错误 |     | The account format is incorrect |     |
| 上交所 | 19006 | 数量格式错误 |     | The quantity is formatted incorrectly |     |
| 上交所 | 19008 | 日期格式错误 |     | The date format is incorrect |     |
| 上交所 | 19010 | 金额格式错误 |     | The amount is formatted incorrectly |     |
| 上交所 | 19012 | 价格格式错误 |     | The price is formatted incorrectly |     |
| 上交所 | 19014 | 撤销单标志格式错误 |     | The format of the revocation slip flag is incorrect |     |
| 上交所 | 19016 | 券商编号格式错误 |     | The broker number is in the wrong format |     |
| 上交所 | 19018 | PBU格式错误 |     | The PBU format is incorrect |     |
| 上交所 | 19020 | 订单请求格式错误 |     | The order request is malformed |     |
| 上交所 | 19022 | 无效的业务类型 |     | Invalid business type |     |
| 上交所 | 19024 | 原订单成交编号格式错误 |     | The original order transaction number is in the wrong format |     |
| 上交所 | 19026 | 原订单成交日期格式错误 |     | The original order was filled in the wrong format |     |
| 上交所 | 19028 | 营业部代码格式错误 |     | The sales office code is in the wrong format |     |
| 上交所 | 19030 | 使用的PBU无权限上传或下载对应的ZRT文件 |     | PBUs do not have the authority to subscribe/redeem ETFs |     |
| 上交所 | 19032 | 无效的业务类型 |     | Invalid business type |     |
| 上交所 | 19036 | 无效的订单买卖方向 |     | Invalid order side |     |
| 上交所 | 19038 | ETF申购数量超出当日申购限额 |     | The subscription amount of the ETF exceeds the subscription limit of the day |     |
| 上交所 | 19040 | ETF赎回数量超出当日赎回限额 |     | The redemption amount of the ETF exceeds the redemption limit on the same day |     |
| 上交所 | 19042 | 参数值非法 |     | The parameter value is invalid |     |
| 上交所 | 19044 | 非法分隔符个数 |     | The number of illegal separators |     |
| 上交所 | 19046 | 未定义的模板key值，模板未找到 |     | The template key value is not defined, and the template is not found |     |
| 上交所 | 19048 | 非法账户 |     | Illegal Accounts |     |
| 上交所 | 19050 | 价格步长非法 |     | The price step is illegal |     |
| 上交所 | 19056 | 业务PBU或REFF字段于STEP消息中内容不符 |     | The content of the service PBU or REFF field does not match the content in the STEP message |     |
| 上交所 | 19058 | Biz PBU和登录PBU属于不同的成员 |     | Biz PBU and login PBU belongs different member |     |
| 上交所 | 19060 | 无效的业务号 |     | Invalid business number |     |
| 上交所 | 19062 | 撤单时, 发现产品代码与原值不一致 |     | When the order is cancelled, it is found that the product code is inconsistent with the original value |     |
| 上交所 | 19064 | 撤单时, 发现PBU与原值不一致 |     | When the order is cancelled, it is found that the PBU is inconsistent with the original value |     |
| 上交所 | 19066 | 撤单时, 发现买卖方向与原值不一致 |     | When the order is cancelled, it is found that the buying and selling direction is inconsistent with the original value |     |
| 上交所 | 19068 | 不支持的产品类型 |     | Unsupported product types |     |
| 上交所 | 19070 | 申报数量为负数 |     | The declared quantity is negative |     |
| 上交所 | 19072 | 无效的账户类型 |     | Invalid account type |     |
| 上交所 | 19074 | 申报价格为负数 |     | The declared price is negative |     |
| 上交所 | 19076 | 无效的约定号 |     | Invalid convention number |     |
| 上交所 | 19078 | 无效的结算代码 |     | Invalid billingID |     |
| 上交所 | 19080 | 订单已成交，无法删除 |     | The order has been filled and cannot be deleted |     |
| 上交所 | 19084 | 约定号不唯一 |     | The convention number is not unique |     |
| 上交所 | 19086 | 订单已被删除 |     | The order has been deleted |     |
| 上交所 | 19088 | 非法消息类型 |     | The type of illegal message |     |
| 上交所 | 19090 | 产品已被暂停交易 |     | Trading in the product has been suspended |     |
| 上交所 | 19092 | 业务已被暂停交易 |     | Trading has been suspended |     |
| 上交所 | 19096 | 订单数量和交易金额小于最低要求 |     | The number of orders and the amount of the transaction are less than the minimum requirements |     |
| 上交所 | 19098 | 订单的数量不是整手数 |     | The number of orders is not a whole lot |     |
| 上交所 | 19102 | 订单价格超出范围 |     | The order price is out of range |     |
| 上交所 | 19104 | PBU已经被暂停 |     | The PBU has been suspended |     |
| 上交所 | 19106 | PBU对该业务没有权限 |     | The PBU does not have permissions on the service |     |
| 上交所 | 19108 | PBU对该产品没有权限 |     | The PBU does not have authority on the product |     |
| 上交所 | 19110 | 产品已停牌 |     | The product has been discontinued |     |
| 上交所 | 19112 | 业务类型不可用 |     | Biz type unavailable |     |
| 上交所 | 19114 | 产品不可用 |     | Instrument unavailable |     |
| 上交所 | 19118 | 子类型不可用 |     | Subtypes are not available |     |
| 上交所 | 19122 | 订阅关系不存在 |     | Subscription relationship does not exist |     |
| 上交所 | 19124 | TXNCODE不存在 |     | TXNCODE does not exist |     |
| 上交所 | 19128 | PBU无法获取 |     | Pbu unavailable |     |
| 上交所 | 19132 | 产品索引号不合法 |     | The product index number is invalid |     |
| 上交所 | 19134 | 资源访问号不合法 |     | The resource access number is invalid |     |
| 上交所 | 19136 | 权限标志不合法 |     | The permission flag is not legitimate |     |
| 上交所 | 19138 | 无此操作权限 |     | You do not have this permission |     |
| 上交所 | 19140 | 无效的RID |     | Invalid RID |     |
| 上交所 | 19142 | 无效的时段 |     | Invalid periods |     |
| 上交所 | 19144 | 无效的营业部代码 |     | Invalid sales office code |     |
| 上交所 | 19146 | 订单处于预撮合状态 |     | The order is in the pre-matched state |     |
| 上交所 | 19148 | PBU对该RAL没有权限 |     | The PBU does not have access to the RAL |     |
| 上交所 | 19150 | 协商匹配订单买卖方向相同 |     | Negotiate a matching order in the same direction as the buy and sell |     |
| 上交所 | 19152 | 协商匹配订单产品ID不相同 |     | The productIDs of the negotiated matching orders are not the same |     |
| 上交所 | 19154 | 协商匹配订单业务类型不相同 |     | The negotiation matching order business types are not the same |     |
| 上交所 | 19156 | 协商匹配订单申报价格不相同 |     | The declared price of the negotiated matching order is not the same |     |
| 上交所 | 19158 | 协商匹配订单申报数量不相同 |     | The number of negotiated matching orders declared is not the same |     |
| 上交所 | 19160 | 存在可配对成交申报, 发起方与对手方PBU校验失败 |     | There is a matchable transaction declaration, The PBU verification between the initiator and the counterparty fails |     |
| 上交所 | 19162 | 无效的账户 |     | Invalid Accounts |     |
| 上交所 | 19164 | 账户已被暂停 |     | The account has been suspended |     |
| 上交所 | 19166 | 账户对该业务没有交易权限 |     | The account does not have trading authority for this transaction |     |
| 上交所 | 19168 | 撤单中的账户与原单不一 |     | The account in the cancelled order is different from the original order |     |
| 上交所 | 19170 | 撤单中的证券代码与原单不一致 |     | The code of the security in the cancelled order is inconsistent with the original order |     |
| 上交所 | 19172 | 撤单中的申报数量与原单不一致 |     | The declared quantity in the cancelled order is inconsistent with the original order |     |
| 上交所 | 19174 | 撤单中的买卖方向与原单不一致 |     | The direction of the order in the cancellation is inconsistent with the original order |     |
| 上交所 | 19176 | 该时段交易无效 |     | Trading is invalid during this session |     |
| 上交所 | 19178 | 期限无效 |     | The term is invalid |     |
| 上交所 | 19180 | 不是此账号的指定PBU |     | It is not the designated PBU of this account |     |
| 上交所 | 19182 | 无效的费率 |     | Invalid rates |     |
| 上交所 | 19184 | 申报数量超过上限 |     | The number of declarations exceeds the upper limit |     |
| 上交所 | 19186 | 无效的订单状态 |     | Invalid order status |     |
| 上交所 | 19188 | 该产品已停牌 |     | The product has been suspended |     |
| 上交所 | 19190 | 该产品已复牌 |     | The product has been reinstated |     |
| 上交所 | 19192 | 会员不存在 |     | Membership does not exist |     |
| 上交所 | 19196 | 会员对该业务没有交易权限 |     | Members do not have trading authority over the business |     |
| 上交所 | 19198 | 原始订单正在处理当中 |     | The original order is being processed |     |
| 上交所 | 19200 | 当日净申购超过基金净申购上限 |     | The net subscription on the day exceeds the net subscription limit of the fund |     |
| 上交所 | 19202 | 当日净赎回超过基金净赎回上限 |     | The net redemption on the same day exceeds the fund's net redemption cap |     |
| 上交所 | 19204 | 该产品已是参考竞价 |     | The product is already in the indicative auction |     |
| 上交所 | 19206 | 无效的撤单reff |     | Invalid chargeback reff |     |
| 上交所 | 19210 | 无效的数据格式 |     | Invalid data format |     |
| 上交所 | 19212 | 输入的主键与记录中主键不一致 |     | The primary key entered is inconsistent with the primary key in the record |     |
| 上交所 | 19214 | 未定义的文件名 |     | Undefined file name |     |
| 上交所 | 19216 | 删除数据与文件原始记录不同 |     | Deleting data is not the same as the original record of the file |     |
| 上交所 | 19218 | 位图长度与字段个数不符 |     | The length of the bitmap does not match the number of fields |     |
| 上交所 | 19220 | 位图信息错误 |     | Bitmap information is incorrect |     |
| 上交所 | 19222 | 转融通撮合已开始 |     | Refinancing has begun |     |
| 上交所 | 19224 | 该指令已被执行 |     | The instruction has been executed |     |
| 上交所 | 19226 | 该期限已被暂停交易 |     | The period has been suspended from trading |     |
| 上交所 | 19228 | 当日总申购超过基金总申购上限 |     | The total subscription on the day exceeds the total subscription limit of the fund |     |
| 上交所 | 19230 | 当日总赎回超过基金总赎回上限 |     | The total redemption of the day exceeds the total redemption limit of the fund |     |
| 上交所 | 19232 | 申购超过当日单账户净申购上限 |     | The subscription exceeds the net subscription limit of a single account on the same day |     |
| 上交所 | 19234 | 赎回超过当日单账户净赎回上限 |     | The redemption exceeds the net redemption limit of a single account on the same day |     |
| 上交所 | 19236 | 申购超过当日单账户总申购上限 |     | The subscription exceeds the total subscription limit of a single account on the same day |     |
| 上交所 | 19238 | 赎回超过当日单账户总赎回上限 |     | The redemption exceeds the total redemption limit of a single account on the same day |     |
| 上交所 | 19240 | 超出可赎回额度 |     | Exceeding the callable amount |     |
| 上交所 | 19242 | 该时间段不允许撤单 |     | Cancellations are not allowed during this time period |     |
| 上交所 | 19244 | 订单的金额不是整手数 |     | The amount of the order is not a whole lot |     |
| 上交所 | 19246 | 账户超出数量限制 |     | The account exceeds the quota limit |     |
| 上交所 | 19248 | 账户对该交易产品没有交易权限 |     | The account does not have trading access to this instrument |     |
| 上交所 | 19250 | 买方PBU同原申报PBU不一致 |     | The buyer's PBU is inconsistent with the original declared PBU |     |
| 上交所 | 19252 | 卖方PBU同原申报PBU不一致 |     | The seller's PBU is inconsistent with the original declared PBU |     |
| 上交所 | 19254 | 无效的闭市价格 |     | Invalid closing price |     |
| 上交所 | 19256 | 产品已被连续停牌 |     | The share reduction mark is incorrect |     |
| 上交所 | 19258 | 投资者账户和产品代码不在减持控制名单中，不允许申报特定股份减持卖单 |     | The investor account and product symbol are not on the shareholding control list, and it is not allowed to file a specific share reduction sell order |     |
| 上交所 | 19260 | 投资者自由流通持仓不足 |     | Investors' free float positions are insufficient |     |
| 上交所 | 19262 | 投资者大宗减持额度不足 |     | Investors are not able to reduce their holdings in large quantities |     |
| 上交所 | 19264 | 证券划出类型错误 |     | The type of security transfer is incorrect |     |
| 上交所 | 19266 | 竞价对应产品已停牌 |     | The product corresponding to the auction has been suspended |     |
| 上交所 | 19268 | 协商匹配订单期限不相同 |     | The negotiation matching order period is not the same |     |
| 上交所 | 19270 | 组合策略构成合约标的不符合要求 |     | The combination strategy does not meet the requirements for constituting the underlying contract |     |
| 上交所 | 19272 | 组合策略构成合约行权价格不符合要求 |     | The exercise price of the portfolio strategy constitutes a contract that does not meet the requirements |     |
| 上交所 | 19274 | 组合策略构成合约乘数不一致 |     | Combination strategies constitute inconsistent contract multipliers |     |
| 上交所 | 19276 | 组合份数与成分合约比例不符或成分合约比例与策略要求比例不符 |     | The number of shares of the portfolio does not match the proportion of the constituent contracts, or the proportion of the constituent contracts does not match the ratio required by the strategy |     |
| 上交所 | 19278 | 组合策略拆分数量超过SM78记录值 |     | The number of portfolio policy splits exceeds the SM78 record value |     |
| 上交所 | 19280 | 该产品不支持战略配售 |     | This product does not support strategic placement |     |
| 上交所 | 19282 | 认购期权普通卖开转备兑策略不支持拆分 |     | The normal sell to cover strategy of call options does not support splitting |     |
| 上交所 | 19284 | 拆分申报策略与组合时不匹配 |     | The split reporting strategy doesn't match the combination |     |
| 上交所 | 19286 | 拆分申报合约与组合时不匹配 |     | There is a mismatch between the reporting contract and the combination |     |
| 上交所 | 19288 | 组合时组合编号不为空 |     | The combination number is not blank when combined |     |
| 上交所 | 19290 | 拆分申报账户与组合时不同 |     | Splitting reporting accounts is different from combining them |     |
| 上交所 | 19292 | 拆分时，组合编号不能为空 |     | When splitting, the combination number cannot be empty |     |
| 上交所 | 19294 | 该组合持仓不存在 |     | The portfolio position does not exist |     |
| 上交所 | 19296 | 综合业务平台：集合申购交易编号重复 期权平台：资金不足以拆分 |     | 总和业务平台：The collective subscription transaction number is duplicated 期权平台：Funds are not enough for splitting |     |
| 上交所 | 19298 | 组合份数必须大于0 |     | The number of combinations must be greater than 0 |     |
| 上交所 | 19300 | 组合策略构成合约数量不符合要求 |     | The number of contracts constituting a portfolio strategy does not meet the requirements |     |
| 上交所 | 19302 | 组合策略构成合约到期日不符合要求 |     | The expiration date of the portfolio strategy constitutes a contract that does not meet the requirements |     |
| 上交所 | 19304 | 组合策略构成合约期权类型不符合要求 |     | The combination strategy constitutes a contract, and the option type does not meet the requirements |     |
| 上交所 | 19306 | 组合策略构成合约备兑标签不符合要求 |     | The portfolio strategy constitutes a contract covered label that does not meet the requirements |     |
| 上交所 | 19310 | 该产品已经独立停牌 |     | The product has been independently suspended |     |
| 上交所 | 19312 | 该产品停复牌预设时间有误 |     | The preset time for the suspension and resumption of trading of the product is incorrect |     |
| 上交所 | 19314 | 禁止做市商自成交 |     | Market makers are prohibited from trading on their own |     |
| 上交所 | 19320 | 开户失败 |     | Failed to open an account |     |
| 上交所 | 19322 | 席位检查不通过 |     | Seat check failed |     |
| 上交所 | 19324 | 联通圈检查不通过 |     | The Unicom circle inspection failed |     |
| 上交所 | 19326 | 分区序号同步失败 |     | Partition sequence number synchronization failed |     |
| 上交所 | 19328 | 必须为A股交易日 |     | Must be a trading day for A-shares |     |
| 上交所 | 19330 | 必须为H股交易日 |     | Must be an H-share trading day |     |
| 上交所 | 19332 | 香港市场错误 |     | Hong Kong market error |     |
| 上交所 | 19334 | 无法解析订单 |     | Unable to resolve order |     |
| 上交所 | 19336 | 机构对该产品无销售资格 |     | Institutions are not eligible to sell the product |     |
| 上交所 | 19338 | 机构对该产品无做市资格 |     | Institutions are not qualified to make markets for this product |     |
| 上交所 | 19340 | 证书数据格式不支持 |     | The certificate data format is not supported |     |
| 上交所 | 19342 | 无效的证书 |     | Invalid certificates |     |
| 上交所 | 19344 | 分区序号同步前需先订阅对应PBU |     | Before the partition sequence number is synchronized, you need to subscribe to the corresponding PBU |     |
| 上交所 | 19346 | 随机数签名验证不通过 |     | The random number signature verification fails |     |
| 上交所 | 19348 | PBU未订阅 |     | The PBU is not subscribed |     |
| 上交所 | 19352 | PBU已登录ITCS |     | PBU already logged in ITCS |     |
| 上交所 | 19354 | PBU强制剔除ITCS |     | The PBU kicks off the ITCS |     |
| 上交所 | 19356 | TDGW版本过低ITCS |     | TDGW version over low, please update ITCS |     |
| 上交所 | 19358 | 机构未开通基金通平台销售资格 |     | The institution has not opened the fund connect platform sales qualification |     |
| 上交所 | 19360 | 机构未开通基金通平台做市资格 |     | The institution has not opened the market-making qualification of the Fund Connect platform |     |
| 上交所 | 19362 | 机构没有买入（转入）权限； |     | Institutions do not have buy-in (transfer-in) permissions; |     |
| 上交所 | 19364 | 机构没有卖出（转出）权限 |     | Institutions do not have sell (transfer out) permissions |     |
| 上交所 | 19366 | 证券账户不存在 |     | The securities account does not exist |     |
| 上交所 | 19368 | 证券账户状态无效 |     | The securities account status is invalid |     |
| 上交所 | 19370 | 证券账户无指定PUB |     | There is no designated PUB for securities accounts |     |
| 上交所 | 19372 | 场内证券账号与该产品报备的做市专用账户不一致 |     | The on-exchange securities account number is inconsistent with the market-making account reported for the product |     |
| 上交所 | 19374 | TA账户四要素与该产品报备的做市专用账户不一致 |     | The four elements of the TA account are inconsistent with the market-making special account reported for the product |     |
| 上交所 | 19376 | TA账户信息要素不全 |     | The TA account information is incomplete |     |
| 上交所 | 19378 | 机构类型校验错误 |     | The organization type is incorrect |     |
| 上交所 | 19380 | TA账户信息要素不匹配； |     | The elements of TA account information do not match; |     |
| 上交所 | 19382 | 中登开户确认后基金帐号不能为空； |     | The fund account cannot be empty after the account opening is confirmed; |     |
| 上交所 | 19384 | 投资者身份信息与报备的基金账户资料不一致 |     | The investor'sIDentity information is inconsistent with the fund account information on file |     |
| 上交所 | 19386 | 交易所账号状态异常 |     | The status of the exchange account is abnormal |     |
| 上交所 | 19388 | TA账户信息状态异常 |     | The status of the TA account information is abnormal |     |
| 上交所 | 19390 | 投资者未开通交易所帐号 |     | The investor does not have an exchange account |     |
| 上交所 | 19392 | 交易所帐号与TA账户信息不匹配 |     | The exchange account number does not match the TA account information |     |
| 上交所 | 19394 | 订单数量不满足申报数量上下限 |     | The order quantity does not meet the upper and lower limits of the declared quantity |     |
| 上交所 | 19396 | 订单数量不满足申报步长 |     | The order quantity does not meet the declaration step |     |
| 上交所 | 19398 | 当日净买入额度不足 |     | The net buying quota of the day is insufficient |     |
| 上交所 | 19400 | 撤单时，发现买卖账户与原值不一致 |     | When the order is cancelled, it is found that the trading account is inconsistent with the original value |     |
| 上交所 | 19402 | 原始订单不允许撤单 |     | Cancellation of the original order is not allowed |     |
| 上交所 | 19404 | 申请单编号校验错误 |     | The requisition ticket number is incorrect |     |
| 上交所 | 19406 | 证券代码校验错误 |     | The security code is incorrect |     |
| 上交所 | 19408 | 交易所帐号校验错误 |     | The exchange account verification error |     |
| 上交所 | 19410 | 挂单类型检验错误 |     | Pending order type verification error |     |
| 上交所 | 19412 | 境外券商未登录 |     | The overseas brokerage firm is not logged in |     |
| 上交所 | 19414 | 当前最大索引编号检验错误 |     | The current maximum index number is being validated incorrectly |     |
| 上交所 | 19416 | 流速大小校验错误 |     | The flow rate is incorrect |     |
| 上交所 | 19418 | 业务时间校验错误 |     | The service time verification error is incorrect |     |
| 上交所 | 19420 | 分页大小不能为空 |     | The pagination size cannot be empty |     |
| 上交所 | 19422 | 订单价格不满足上下限 |     | The order price does not meet the upper and lower limits |     |
| 上交所 | 19424 | 订单价格不满足步长要求 |     | The order price does not meet the step size requirements |     |
| 上交所 | 19426 | 机构代码不能为空 |     | The institution code cannot be empty |     |
| 上交所 | 19428 | 机构代码长度超出限制 |     | The length of the organization code exceeds the limit |     |
| 上交所 | 19430 | 订单编号校验错误 |     | The order number is incorrect |     |
| 上交所 | 19432 | 原始会员内部订单编号校验错误 |     | The original member's internal order number is incorrect |     |
| 上交所 | 19434 | 系统繁忙，请稍后重试 |     | The system is busy, Please try again later |     |
| 上交所 | 19436 | 该时段已匹配订单不允许撤单 |     | Orders that have been matched during this period are not allowed to be cancelled |     |
| 上交所 | 19438 | 选中的报价方超出数量限制 |     | The selected offerer exceeds the quantity limit |     |
| 上交所 | 19440 | 被询价方状态异常 |     | The requested party is abnormal |     |
| 上交所 | 19442 | 公共报文头信息异常 |     | The public packet header information is abnormal |     |
| 上交所 | 19444 | 选中的报价方信息异常 |     | The information of the selected offeror is abnormal |     |
| 上交所 | 19446 | 原询价单已失效或者不存在 |     | The original RFQ is invalid or does not exist |     |
| 上交所 | 20000 | 不被期待的消息类型 |     | Message type unexpected |     |
| 上交所 | 20001 | 无效的平台ID |     | Invalid platform id |     |
| 上交所 | 20002 | BodyLength字段校验错误 |     | BodyLength field check error |     |
| 上交所 | 20003 | PBU重复登录 |     | Pbu duplicate logon |     |
| 上交所 | 20004 | ClOrdID字段校验错误 |     | ClOrdID field check error |     |
| 上交所 | 20005 | 订阅其他pbu执行报告失败 |     | Pbu subscribe other pbu's execution report failed |     |
| 上交所 | 20006 | ExecID字段校验错误 |     | The ExecID field is incorrect |     |
| 上交所 | 20008 | IOIID字段校验错误 |     | IOIID field check error |     |
| 上交所 | 20009 | 后端PBU启动 |     | Pbu kickoff by backend |     |
| 上交所 | 20010 | IOIRefID字段校验错误 |     | IOIRefID field check error |     |
| 上交所 | 20011 | 无效的origclordid格式 |     | Invalid origclordid format |     |
| 上交所 | 20012 | IOITransType字段校验错误 |     | IOITransType field check error |     |
| 上交所 | 20013 | 无效的clearingfirm格式 |     | Invalid clearingfirm format |     |
| 上交所 | 20014 | LastPx字段校验错误 |     | LastPx field check error |     |
| 上交所 | 20015 | 无效的所有者类型 |     | Invalid owner type |     |
| 上交所 | 20016 | LastQty字段校验错误 |     | The LastQty field is incorrect |     |
| 上交所 | 20018 | MsgType字段校验错误 |     | The MsgType field is incorrect |     |
| 上交所 | 20020 | OrderID字段校验错误 |     | The OrderID field is incorrect |     |
| 上交所 | 20022 | OrderQty字段校验错误 |     | The OrderQty field is incorrect |     |
| 上交所 | 20024 | OrdStatus字段校验错误 |     | The OrdStatus field is incorrect |     |
| 上交所 | 20026 | OrderID对应的订单类型 |     | OrderID |     |
| 上交所 | 20028 | OrigClOrdID字段校验错误 |     | The OrigClOrdID field is incorrect |     |
| 上交所 | 20030 | OrigTime字段校验错误 |     | The OrigTime field is incorrect |     |
| 上交所 | 20032 | Price字段校验错误 |     | The Price field is incorrect |     |
| 上交所 | 20034 | SecurityID字段校验错误 |     | The SecurityID field is incorrect |     |
| 上交所 | 20036 | Side字段校验错误 |     | The Side field is incorrect |     |
| 上交所 | 20038 | Symbol字段校验错误 |     | The Symbol field is incorrect |     |
| 上交所 | 20040 | Text字段校验错误 |     | The Text field is incorrect |     |
| 上交所 | 20042 | TransactTime字段校验错误 |     | The TransactTime field is incorrect |     |
| 上交所 | 20044 | 交易日期 |     | The date of the transaction |     |
| 上交所 | 20046 | CxlRejReason字段校验错误 |     | The CxlRejReason field is incorrect |     |
| 上交所 | 20048 | OrdRejReason字段校验错误 |     | The OrdRejReason field is incorrect |     |
| 上交所 | 20050 | 会员内部编号，指报价申报/报价申报撤销中的会员内部编号 |     | The member internal number refers to the internal number of the member in the quotation declaration/quotation declaration cancellation |     |
| 上交所 | 20052 | 昨收盘价 |     | Yesterday's closing price |     |
| 上交所 | 20054 | ExecType字段校验错误 |     | The ExecType field is incorrect |     |
| 上交所 | 20056 | LeavesQty字段校验错误 |     | The LeavesQty field is incorrect |     |
| 上交所 | 20058 | OrderQty2成分证券数量校验错误 |     | OrderQty2 constituent security quantity verification error |     |
| 上交所 | 20060 | 订单数量2，或券面金额2。在side为双向时填写卖数量，其他情况填写0 |     | Order quantity 2, or coupon value 2. If the side is two-way, enter the sell quantity, and in other cases, set 0 |     |
| 上交所 | 20062 | 参考到期收益率 |     | Reference yield to maturity |     |
| 上交所 | 20064 | 行情条目个数 |     | The number of market entries |     |
| 上交所 | 20066 | 行情类别 |     | Quote category |     |
| 上交所 | 20068 | 行情价格 |     | Market price |     |
| 上交所 | 20070 | MDEntrySize字段校验错误 |     | The MDEntrySize field is incorrect |     |
| 上交所 | 20072 | 行情更新类型 |     | The type of market update |     |
| 上交所 | 20074 | 买卖盘序号 |     | Order number |     |
| 上交所 | 20076 | 报价状态 |     | Quote status |     |
| 上交所 | 20078 | TotalVolumeTraded字段校验错误 |     | The TotalVolumeTraded field is incorrect |     |
| 上交所 | 20080 | CxlRejResponseTo字段校验错误 |     | The CxlRejResponseTo field is incorrect |     |
| 上交所 | 20082 | PartyID字段校验错误 |     | The PartyID field is incorrect |     |
| 上交所 | 20084 | PartyRole字段校验错误 |     | The PartyRole field is incorrect |     |
| 上交所 | 20086 | NoPartyIDs字段校验错误 |     | The NoPartyIDs field is incorrect |     |
| 上交所 | 20088 | Designation字段校验错误 |     | The Designation field is incorrect |     |
| 上交所 | 20090 | 是否做市报价 |     | Whether it is a market-making quote |     |
| 上交所 | 20092 | 报价申报类型 |     | The type of quotation declaration |     |
| 上交所 | 20094 | NoDates字段校验错误 |     | NoDates field validation error |     |
| 上交所 | 20096 | Price2字段校验错误 |     | The Price2 field is incorrect |     |
| 上交所 | 20098 | 交易所订单编号 |     | Exchange order number |     |
| 上交所 | 20100 | ConfirmID字段校验错误 |     | The ConfirmID field is incorrect |     |
| 上交所 | 20102 | QuoteRespID字段校验错误 |     | QuoteRespID field validation error |     |
| 上交所 | 20104 | QuoteRespType字段校验错误 |     | QuoteRespType field validation error |     |
| 上交所 | 20106 | 参考全价价格 |     | Refer to the full price |     |
| 上交所 | 20108 | AgreementID字段校验错误 |     | The AgreementID field is incorrect |     |
| 上交所 | 20110 | StartCash字段校验错误 |     | The StartCash field is incorrect |     |
| 上交所 | 20112 | EndCash字段校验错误 |     | The EndCash field is incorrect |     |
| 上交所 | 20114 | RefOrderID字段校验错误 |     | The RefOrderID field is incorrect |     |
| 上交所 | 20116 | 是否匿名报价 |     | Whether the quote is anonymous or not |     |
| 上交所 | 20118 | OrigTradeDate字段校验错误 |     | The OrigTradeDate field is incorrect |     |
| 上交所 | 20120 | 冰山订单数量，如果不为冰山订单，则此字段为0 |     | Iceberg order quantity, if it is not an iceberg order, this field is 0 |     |
| 上交所 | 20122 | 报价类型 |     | The type of offer |     |
| 上交所 | 20124 | ApplID字段校验错误 |     | The ApplID field is incorrect |     |
| 上交所 | 20126 | 交易所订单编号，对于双向报价，则分两笔报价行情信息 |     | Exchange order number, for two-way quotations, it is divided into two quotation market information |     |
| 上交所 | 20128 | 注册指令 |     | Registration Instructions |     |
| 上交所 | 20130 | 成交笔数 |     | Number of deals |     |
| 上交所 | 20132 | TotalValueTraded字段校验错误 |     | The TotalValueTraded field is incorrect |     |
| 上交所 | 20134 | TradeDate字段校验错误 |     | The TradeDate field is incorrect |     |
| 上交所 | 20136 | SecurityDesc字段校验错误 |     | SecurityDesc field validation error |     |
| 上交所 | 20138 | MaturityDate字段校验错误 |     | The MaturityDate field is incorrect |     |
| 上交所 | 20140 | OrdType字段校验错误 |     | The OrdType field is incorrect |     |
| 上交所 | 20142 | CashOrderQty字段校验错误 |     | The CashOrderQty field is incorrect |     |
| 上交所 | 20144 | VotingProposal字段校验错误 |     | The VotingProposal field is incorrect |     |
| 上交所 | 20146 | VotingPreference字段校验错误 |     | The VotingPreference field is incorrect |     |
| 上交所 | 20152 | GeneralMeetingSeq字段校验错误 |     | GeneralMeetingSeq field validation error |     |
| 上交所 | 20154 | 债券代码 |     | Bond code |     |
| 上交所 | 20156 | 表示当前PartySubIDType的取值为债券代码 |     | Indicates that the current value of PartySubIDType is the bond code |     |
| 上交所 | 20158 | 交易客户方（券商）查询申请内部编号 |     | The trading customer (broker) inquires about the internal number of the application |     |
| 上交所 | 20160 | 账户关联债券重复组 |     | The account is associated with a duplicate bond group |     |
| 上交所 | 20162 | DesignationInstruction字段校验错误 |     | DesignationInstruction field validation error |     |
| 上交所 | 20164 | DesignationTransType字段校验错误 |     | DesignationTransType field validation error |     |
| 上交所 | 20166 | ValidationCode字段校验错误 |     | The ValidationCode field is incorrect |     |
| 上交所 | 20168 | MarginAmt字段校验错误 |     | The MarginAmt field is incorrect |     |
| 上交所 | 20172 | 参数值非法 tag:59 |     | The parameter value is illegal tag: 59 |     |
| 上交所 | 20174 | 参数值非法 tag:856 |     | The parameter value is illegal tag: 856 |     |
| 上交所 | 20176 | 参数值非法 tag:455 |     | The parameter value is illegal tag: 455 |     |
| 上交所 | 20178 | 参数值非法 tag:8503 |     | The parameter value is illegal tag: 8503 |     |
| 上交所 | 20202 | 参数值非法 tag:308 |     | The parameter value is illegal tag: 308 |     |
| 上交所 | 20204 | 参数值非法 tag:522 |     | The parameter value is illegal tag: 522 |     |
| 上交所 | 20206 | 参数值非法 tag:59 |     | The parameter value is illegal tag: 59 |     |
| 上交所 | 20208 | 参数值非法 tag:203 |     | The parameter value is illegal tag: 203 |     |
| 上交所 | 20212 | 参数值非法 tag:8538 |     | The parameter value is illegal tag: 8538 |     |
| 上交所 | 20214 | 参数值非法 tag:845 |     | The parameter value is illegal tag: 845 |     |
| 上交所 | 20216 | 参数值非法 tag:77 |     | The parameter value is illegal tag: 77 |     |
| 上交所 | 20218 | 参数值非法 tag:8541 |     | The parameter value is illegal tag: 8541 |     |
| 上交所 | 20220 | 参数值非法 tag:963 |     | The parameter value is illegal tag: 963 |     |
| 上交所 | 20224 | 参数值非法 tag:1187 |     | The parameter value is illegal tag: 1187 |     |
| 上交所 | 20226 | 参数值非法 tag:1365 |     | The parameter value is illegal tag: 1365 |     |
| 上交所 | 20228 | 参数值非法 tag:1443 |     | The parameter value is illegal tag: 1443 |     |
| 上交所 | 20230 | 参数值非法 tag:1362 |     | The parameter value is illegal tag: 1362 |     |
| 上交所 | 20232 | 参数值非法 tag:8506 |     | The parameter value is illegal tag: 8506 |     |
| 上交所 | 20234 | 参数值非法 tag:747 |     | The parameter value is illegal tag: 747 |     |
| 上交所 | 20236 | 参数值非法 tag:1635 |     | The parameter value is illegal tag: 1635 |     |
| 上交所 | 20238 | 参数值非法 tag:1643 |     | The parameter value is illegal tag: 1643 |     |
| 上交所 | 20240 | 参数值非法 tag:1645 |     | The parameter value is illegal tag: 1645 |     |
| 上交所 | 20242 | 参数值非法 tag:1644 |     | The parameter value is illegal tag: 1644 |     |
| 上交所 | 20244 | STEP模板 缺少msg type |     | The STEP template is missing the msg type |     |
| 上交所 | 20246 | STEP模板 缺少结尾的分隔符 |     | The STEP template is missing a separator at the end |     |
| 上交所 | 20248 | STEP字段 tag取值为NULL字符串 |     | The value of the STEP field tag is a NULL string |     |
| 上交所 | 20250 | STEP字段 tag不可识别 |     | The STEP field tag is not recognized |     |
| 上交所 | 20252 | STEP字段 等号前有多余的空格 |     | STEP field There is an extra space before the equal sign |     |
| 上交所 | 20254 | STEP字段 不符合key-value的格式 |     | The STEP field does not conform to the key-value format |     |
| 上交所 | 20256 | STEP模板 tag个数与配置不同 |     | The number of STEP template tags is different from the configuration |     |
| 上交所 | 20258 | STEP模板 不允许结尾的分隔符 |     | STEP templates do not allow ending separators |     |
| 上交所 | 20260 | 参数值非法 tag:198 |     | The parameter value is illegal tag: 198 |     |
| 上交所 | 20262 | 参数值非法 tag:555 |     | The parameter value is illegal tag: 555 |     |
| 上交所 | 20264 | 参数值非法 tag:602 |     | The parameter value is illegal tag: 602 |     |
| 上交所 | 20266 | 参数值非法 tag:624 |     | The parameter value is illegal tag: 624 |     |
| 上交所 | 20268 | 参数值非法 tag:685 |     | The parameter value is illegal tag: 685 |     |
| 上交所 | 20270 | 参数值非法 tag:131 |     | The parameter value is illegal tag: 131 |     |
| 上交所 | 20272 | 参数值非法 tag:1166 |     | The parameter value is illegal tag: 1166 |     |
| 上交所 | 20274 | 参数值非法 tag:132 |     | The parameter value is illegal tag: 132 |     |
| 上交所 | 20276 | 参数值非法 tag:133 |     | The parameter value is illegal tag: 133 |     |
| 上交所 | 20278 | 参数值非法 tag:134 |     | The parameter value is illegal tag: 134 |     |
| 上交所 | 20280 | 参数值非法 tag:135 |     | The parameter value is illegal tag: 135 |     |
| 上交所 | 20282 | 参数值非法 tag:300 |     | The parameter value is illegal tag: 300 |     |
| 上交所 | 20284 | 参数值非法 tag:8909 |     | The parameter value is illegal tag: 8909 |     |
| 上交所 | 20286 | 参数值非法 tag:8910 |     | The parameter value is illegal tag: 8910 |     |
| 上交所 | 20288 | 起始消息序号 |     | The starting message sequence number |     |
| 上交所 | 20290 | 累计执行数量 |     | Cumulative number of executions |     |
| 上交所 | 20292 | 当前消息最大序号 |     | The maximum sequence number of the current message |     |
| 上交所 | 20294 | 证券代码源 101=SH证券交易所 103=XG联合交易所 |     | Source of the security symbol 101=SH Stock Exchange 103=XG Stock Exchange |     |
| 上交所 | 20296 | 订单有效时间类型，ExecType=0/4/8时有效 |     | The order is valid for the time type, ExecType=0/4/8 |     |
| 上交所 | 20298 | 撤单数量，ExecType=4时有效 |     | The order cancelled is valid when ExecType=4 |     |
| 上交所 | 20300 | 数据同步类型 SO=SyncOrder，同步委托类数据 SR=SyncReport，同步回报类数据 |     | Data synchronization type SO=SyncOrder, which synchronizes the delegate data SR=SyncReport, which synchronizes the report data |     |
| 上交所 | 20302 | 订单金额 |     | The amount of the order |     |
| 上交所 | 20304 | 订单所有者类型，取值包括： 1=个人投资者 103=机构投资者 104=自营交易 |     | The order owner type, the following values: 1 = Individual Investor 103 = Institutional Investors 104 = Proprietary trading |     |
| 上交所 | 20306 | 信用标签，信用交易时填写，取值：XY=担保品买卖、RZ=融资交易、PC=平仓交易 |     | Credit label, filled in during credit transaction, value: XY=collateral trading, RZ=margin transaction, PC=liquidation transaction |     |
| 上交所 | 20308 | 业务类型：600020=基金通业务交易订单申报；600021=基金通业务转入转出订单申报 |     | Business Type: 600020 = Fund Connect Business Transaction Order Declaration;600021 = Fund Connect Business Transfer-in and Transfer-out Order Declaration |     |
| 上交所 | 20310 | 消息记录号 1）委托类消息，由上交所跨境网关对其赋值编号 2）回报类消息，由境外OMS对其赋值编号 |     | The message record number 1) Delegated messages, which are assigned a number by the SSE cross-border gateway 2) Return messages, which are assigned by overseas OMS |     |
| 上交所 | 20312 | 拒绝原因说明 |     | Explanation of the reason for rejection |     |
| 上交所 | 20314 | 应用层的消息记录号 |     | The message record number of the application layer |     |
| 上交所 | 20316 | 对于新会话，填1；否则置为已接收的最大ApplSeqNum+1 |     | For new sessions, fill in 1; otherwise, set to the maximum ApplSeqNum+1 received |     |
| 上交所 | 20318 | 订单申报时间，ExecType=F时有效 |     | The time when the order is declared, ExecType=F |     |
| 上交所 | 20320 | 成交金额，ExecType=F时有效 |     | Transaction amount, valid when ExecType=F |     |
| 上交所 | 20322 | 登录PBU |     | Log in to the PBU |     |
| 上交所 | 20324 | 登录PBU数量 |     | Number of PBUs that are logged in |     |
| 上交所 | 20326 | 分区执行报告起始序号 |     | The starting sequence number of the partition execution report |     |
| 上交所 | 20328 | 分区执行报告最大序号 |     | The maximum sequence number of the partition execution report |     |
| 上交所 | 20330 | 执行报告编号，从1开始连续递增编号 |     | The number of the executive report, which is incremented sequentially from 1 |     |
| 上交所 | 20332 | 平台标识 |     | PlatformIDentity |     |
| 上交所 | 20334 | 平台状态： 0 = NotOpen，未开放 1 = PreOpen，预开放 2 = Open，开放 3 = Break，暂停 4 = Close，关闭 |     | Platform Status: 0 = NotOpen, not open 1 = PreOpen 2 = Open 3 = Break, pause 4 = Close, closed |     |
| 上交所 | 20336 | 平台内分区数量 |     | The number of partitions within the platform |     |
| 上交所 | 20338 | 平台内分区号 |     | The zone number within the platform |     |
| 上交所 | 20340 | 参数值非法 tag:1671 |     | The parameter value is illegal tag: 1671 |     |
| 上交所 | 20342 | 参数值非法 tag:1691 |     | The parameter value is illegal tag: 1691 |     |
| 上交所 | 20344 | 参数值非法 tag:1693 |     | The parameter value is illegal tag:1693 |     |
| 上交所 | 20346 | 参数值非法 tag:124 |     | The parameter value is illegal tag: 124 |     |
| 上交所 | 20350 | QuoteType字段校验错误 |     | The QuoteType field is incorrect |     |
| 上交所 | 20352 | PreTradeAnonymity字段校验错误 |     | The PreTradeAnonymity field is incorrect |     |
| 上交所 | 20354 | ValidUntilTime字段校验错误 |     | The ValidUntilTime field is incorrect |     |
| 上交所 | 20356 | QuoteReqId字段校验错误 |     | QuoteReqId field validation error |     |
| 上交所 | 30000 | 被忽略的 |     | UNRECOGNISED |     |
| 上交所 | 30002 | 2025经纪公司已停牌 |     | 2025 Broker firm has been suspended |     |
| 上交所 | 30004 | 经纪公司“M&lt;99999&gt;”的2021交易员“M&lt;999&gt;”已被停职 |     | 2021 Trader ' M&lt;999&gt; ' of broker firm ' M&lt;99999&gt; ' has been suspended |     |
| 上交所 | 30006 | 2026经纪人号码已暂停 |     | 2026 Broker number has been suspended |     |
| 上交所 | 30008 | 2221无法登录-所有经纪人暂停 |     | 2221 Sign On not possible - all brokers suspended |     |
| 上交所 | 30010 | 2023安全'M&lt;ZZZZ9&gt;'已暂停 |     | 2023 Security ' M&lt;ZZZZ9&gt; ' has been suspended |     |
| 上交所 | 30012 | 2033功能暂停 |     | 2033 Function suspended |     |
| 上交所 | 30014 | 2154市场小组因经纪人被停职 |     | 2154 Market group suspended for the broker |     |
| 上交所 | 30016 | 2228监视器用户'M&lt;999&gt;'已暂停 |     | 2228 Monitor user ' M&lt;999&gt; ' suspended |     |
| 上交所 | 30018 | 无效的安全代码 |     | Invalid Security Code |     |
| 上交所 | 30020 | 无效的价格 |     | Invalid Price |     |
| 上交所 | 30022 | 无效数量 |     | Invalid Quantity |     |
| 上交所 | 30024 | 无效的订单类型 |     | Invalid Order Type |     |
| 上交所 | 30026 | 无效的全有或全无指示符 |     | Invalid All or Nothing Indicator |     |
| 上交所 | 30028 | 无效的引用/注释 |     | Invalid Reference/Comment |     |
| 上交所 | 30030 | 无效交易分类-卖空 |     | Invalid Trade Classification - Short sell |     |
| 上交所 | 30032 | 无效的贸易分类-原产地 |     | Invalid Trade Classification - Origin |     |
| 上交所 | 30034 | 无效的交易分类-对冲 |     | Invalid Trade Classification - Hedge |     |
| 上交所 | 30036 | 无效的市场代码 |     | Invalid Market Code |     |
| 上交所 | 30038 | 无效的包含填充标志 |     | Invalid Include Filled Flag |     |
| 上交所 | 30040 | 无效的包含交易标志 |     | Invalid Include Trades Flag |     |
| 上交所 | 30042 | 无效时间 |     | Invalid Time |     |
| 上交所 | 30044 | 无效的一侧 |     | Invalid Side |     |
| 上交所 | 30046 | 所有股票标志无效 |     | Invalid All Stocks Flag |     |
| 上交所 | 30048 | 无效的代理行编号 |     | Invalid Correspondent Broker Number |     |
| 上交所 | 30050 | 无效的直接指示器 |     | Invalid Direct Indicator |     |
| 上交所 | 30052 | 无效的结算类型 |     | Invalid Settlement Type |     |
| 上交所 | 30054 | 无效的海外指标 |     | Invalid Overseas Indicator |     |
| 上交所 | 30056 | 无效的打印标志 |     | Invalid Print Flag |     |
| 上交所 | 30058 | 无效的页码 |     | Invalid Page Number |     |
| 上交所 | 30060 | 无效的交易者ID |     | Invalid TraderID |     |
| 上交所 | 30062 | 无效密码 |     | Invalid Password |     |
| 上交所 | 30064 | 无效的出价/询价标志 |     | Invalid Bid/Ask Flag |     |
| 上交所 | 30066 | 无效的订单序列号 |     | Invalid Order Sequence Number |     |
| 上交所 | 30068 | 无效的批量取消标志 |     | Invalid Bulk Cancel Flag |     |
| 上交所 | 30070 | 无效的永久注销标志 |     | Invalid Permanent Sign Off Flag |     |
| 上交所 | 30072 | 无效的更改设置标志 |     | Invalid Change Settings Flag |     |
| 上交所 | 30074 | 无效的默认标志 |     | Invalid Default Flag |     |
| 上交所 | 30076 | 无效的交易提示阈值 |     | Invalid Trade Ticker Threshold |     |
| 上交所 | 30078 | 无效的对价阈值 |     | Invalid Consideration Threshold |     |
| 上交所 | 30080 | 无效的标准颜色标志 |     | Invalid Standard Colour Flag |     |
| 上交所 | 30082 | 无效的主背景颜色 |     | Invalid Main Background Colour |     |
| 上交所 | 30084 | 无效的次要背景颜色 |     | Invalid Secondary Background Colour |     |
| 上交所 | 30086 | 无效的投标颜色 |     | Invalid Bid Colour |     |
| 上交所 | 30088 | 无效无效的询问颜色 |     | Invalid Invalid Ask Colour |     |
| 上交所 | 30090 | 无效的高价颜色 |     | Invalid High Price Colour |     |
| 上交所 | 30092 | 无效的低价颜色 |     | Invalid Low Price Colour |     |
| 上交所 | 30094 | 无效的消息颜色 |     | Invalid Message Colour |     |
| 上交所 | 30096 | 无效的其他颜色 |     | Invalid Other Colour |     |
| 上交所 | 30098 | 无效的监视器用户ID |     | Invalid Monitor UserID |     |
| 上交所 | 30100 | 无效的智能卡无效的Broker |     | Invalid Smart Card Invalid Broker |     |
| 上交所 | 30102 | 无效无效的系统状态 |     | Invalid Invalid System State |     |
| 上交所 | 30104 | 无效的禁用声音报警标志 |     | Invalid Disable Audible Alarm Flag |     |
| 上交所 | 30106 | 无效交易类型 |     | Invalid Trade Type |     |
| 上交所 | 30108 | 无效的确认交易类型 |     | Invalid Confirmation Trade Type |     |
| 上交所 | 30110 | 无效的投标价格 |     | Invalid Bid Price |     |
| 上交所 | 30112 | 无效的要价 |     | Invalid Ask Price |     |
| 上交所 | 30114 | 无效的投标数量 |     | Invalid Bid Quantity |     |
| 上交所 | 30116 | 无效的请求数量 |     | Invalid Ask Quantity |     |
| 上交所 | 30118 | 无效的BS订单参考号 |     | Invalid BS Order Reference Number |     |
| 上交所 | 30120 | 无效的BS事务引用 |     | Invalid BS Transaction Reference |     |
| 上交所 | 30122 | 无效的取消/减少标志 |     | Invalid Cancel/Reduce Flag |     |
| 上交所 | 30124 | 无效的确认标志 |     | Invalid Confirmation Flag |     |
| 上交所 | 30126 | 无效的以太网地址 |     | Invalid Ethernet Address |     |
| 上交所 | 30128 | 无效的新闻项目ID |     | Invalid News ItemID |     |
| 上交所 | 30130 | 无效的新闻系统ID |     | Invalid News SystemID |     |
| 上交所 | 30132 | 无效的项数 |     | Invalid Number of Items |     |
| 上交所 | 30134 | 无效的软件版本号 |     | Invalid Software Version Number |     |
| 上交所 | 30136 | BS商业参考号无效 |     | Invalid BS Trade Reference Number |     |
| 上交所 | 30138 | 无效的交易序列号 |     | Invalid Trade Sequence Number |     |
| 上交所 | 30140 | ORS事务引用无效 |     | Invalid ORS Transaction Reference |     |
| 上交所 | 30142 | 无效的消息引用 |     | Invalid Message Reference |     |
| 上交所 | 30144 | 无效声音警报（BSS未使用） |     | Invalid Audible Alarm (not used by BSS) |     |
| 上交所 | 30146 | 无效的自动打印 |     | Invalid Auto printing |     |
| 上交所 | 30148 | 无效的点差数量 |     | Invalid No of Spreads |     |
| 上交所 | 30150 | 9064无效设备 |     | 9064 Invalid Device |     |
| 上交所 | 30152 | 2035无效库存 |     | 2035 Invalid stock |     |
| 上交所 | 30154 | 2227不接受取消-报价未结清 |     | 2227 Cancellation not accepted - quote not outstanding |     |
| 上交所 | 30156 | 2057 USM序列号无效 |     | 2057 Invalid USM Sequence Number |     |
| 上交所 | 30158 | 2091无效的I/B |     | 2091 Invalid I/B |     |
| 上交所 | 30160 | 2115无效的对价阈值 |     | 2115 Invalid consideration threshold |     |
| 上交所 | 30162 | 4019消息长度无效 |     | 4019 Invalid message length |     |
| 上交所 | 30164 | 4020消息ID无效 |     | 4020 Invalid MessageID |     |
| 上交所 | 30166 | 4021发件人ID无效 |     | 4021 Invalid SenderID |     |
| 上交所 | 30168 | 4022无效的接收器ID |     | 4022 Invalid ReceiverID |     |
| 上交所 | 30170 | 4003无效消息类型 |     | 4003 Invalid Message Type |     |
| 上交所 | 30172 | 4025安全拖车无效 |     | 4025 Invalid security trailer |     |
| 上交所 | 30174 | 4027无效的BS设备ID |     | 4027 Invalid BS DeviceID |     |
| 上交所 | 30176 | 4029设备可用性无效 |     | 4029 Invalid Device Availability |     |
| 上交所 | 30178 | 4002无效市场组 |     | 4002 Invalid Market Group |     |
| 上交所 | 30180 | 4037无效的下载类型 |     | 4037 Invalid Download Type |     |
| 上交所 | 30182 | 4043无效循环/数组计数 |     | 4043 Invalid Loop/Array Count |     |
| 上交所 | 30184 | 9025主机接收到非法的恢复序列号 |     | 9025 Illegal recovery sequence number received by Host |     |
| 上交所 | 30186 | 2195无效的出价/出价指示器 |     | 2195 Invalid bid/ask indicator |     |
| 上交所 | 30188 | 9063无效交易方 |     | 9063 Invalid trade side |     |
| 上交所 | 30190 | 4008非RT Broker号码的无效交易 |     | 4008 Invalid transaction for non-RT Broker Number |     |
| 上交所 | 30192 | 4009 RT Broker编号的交易无效 |     | 4009 Invalid transaction for RT Broker Number |     |
| 上交所 | 30194 | 2208订单id无效 |     | 2208 Invalid orderID |     |
| 上交所 | 30196 | 2426无效订单端 |     | 2426 Invalid Order Side |     |
| 上交所 | 30198 | 2421篮子索引代码无效 |     | 2421 Invalid Basket Index code |     |
| 上交所 | 30200 | 2219注销类型无效 |     | 2219 Invalid log-off type |     |
| 上交所 | 30202 | 2129无效功能 |     | 2129 Invalid function |     |
| 上交所 | 30204 | 2192无效授权交易员 |     | 2192 Invalid authorising trader |     |
| 上交所 | 30206 | 2194无效的股票代码 |     | 2194 Invalid stock code |     |
| 上交所 | 30208 | 2196包含填充指示符无效 |     | 2196 Invalid include filled indicator |     |
| 上交所 | 30210 | 9071 Include Last Key标志必须为Y或N |     | 9071 Include Last Key Flag must be Y or N |     |
| 上交所 | 30212 | 9052交易指标必须是M L R或V |     | 9052 Trade Indicator must be M L R or V |     |
| 上交所 | 30214 | 2124超过最大订单量 |     | 2124 Maximum order size exceeded |     |
| 上交所 | 30216 | 9039取消标志必须为Y或N |     | 9039 Cancel flag must be Y or N |     |
| 上交所 | 30218 | 4000邀请号码无效 |     | 4000 Invitation Number invalid |     |
| 上交所 | 30220 | 9069主机接收到非法的恢复序列号 |     | 9069 Illegal recovery sequence number received by Host |     |
| 上交所 | 30222 | 缺少安全代码 |     | Missing Security Code |     |
| 上交所 | 30224 | 缺少价格 |     | Missing Price |     |
| 上交所 | 30226 | 缺少数量 |     | Missing Quantity |     |
| 上交所 | 30228 | 缺少订单类型 |     | Missing Order Type |     |
| 上交所 | 30230 | 缺少全有或全无指示符 |     | Missing All or Nothing Indicator |     |
| 上交所 | 30232 | 缺少参考/注释 |     | Missing Reference/Comment |     |
| 上交所 | 30234 | 缺少交易分类-卖空 |     | Missing Trade Classification - Short sell |     |
| 上交所 | 30236 | 缺少贸易分类-原产地 |     | Missing Trade Classification - Origin |     |
| 上交所 | 30238 | 缺少交易分类-对冲 |     | Missing Trade Classification - Hedge |     |
| 上交所 | 30240 | 缺少市场代码 |     | Missing Market Code |     |
| 上交所 | 30242 | 缺少包含填充标志 |     | Missing Include Filled Flag |     |
| 上交所 | 30244 | 缺少包含交易标志 |     | Missing Include Trades Flag |     |
| 上交所 | 30246 | 缺少时间 |     | Missing Time |     |
| 上交所 | 30248 | 缺失的一面 |     | Missing Side |     |
| 上交所 | 30250 | 缺少所有库存标志 |     | Missing All Stocks Flag |     |
| 上交所 | 30252 | 缺少代理经纪人号码 |     | Missing Correspondent Broker Number |     |
| 上交所 | 30254 | 缺少直接指示器 |     | Missing Direct Indicator |     |
| 上交所 | 30256 | 缺少结算类型 |     | Missing Settlement Type |     |
| 上交所 | 30258 | 缺少海外指标 |     | Missing Overseas Indicator |     |
| 上交所 | 30260 | 缺少打印标志 |     | Missing Print Flag |     |
| 上交所 | 30262 | 缺少页码 |     | Missing Page Number |     |
| 上交所 | 30264 | 缺少交易者ID |     | Missing TraderID |     |
| 上交所 | 30266 | 缺少密码 |     | Missing Password |     |
| 上交所 | 30268 | 缺少投标/询价标志 |     | Missing Bid/Ask Flag |     |
| 上交所 | 30270 | 缺少订单序列号 |     | Missing Order Sequence Number |     |
| 上交所 | 30272 | 缺少批量取消标志 |     | Missing Bulk Cancel Flag |     |
| 上交所 | 30274 | 缺少永久注销标志 |     | Missing Permanent Sign Off Flag |     |
| 上交所 | 30276 | 缺少更改设置标志 |     | Missing Change Settings Flag |     |
| 上交所 | 30278 | 缺少默认标志 |     | Missing Default Flag |     |
| 上交所 | 30280 | 缺少交易提示阈值 |     | Missing Trade Ticker Threshold |     |
| 上交所 | 30282 | 缺少对价阈值 |     | Missing Consideration Threshold |     |
| 上交所 | 30284 | 缺少标准颜色标志 |     | Missing Standard Colour Flag |     |
| 上交所 | 30286 | 缺少主背景颜色 |     | Missing Main Background Colour |     |
| 上交所 | 30288 | 缺少次要背景颜色 |     | Missing Secondary Background Colour |     |
| 上交所 | 30290 | 缺少投标颜色 |     | Missing Bid Colour |     |
| 上交所 | 30292 | 缺少询问颜色 |     | Missing Ask Colour |     |
| 上交所 | 30294 | 缺少高价颜色 |     | Missing High Price Colour |     |
| 上交所 | 30296 | 缺少低价颜色 |     | Missing Low Price Colour |     |
| 上交所 | 30298 | 缺少信息颜色 |     | Missing Message Colour |     |
| 上交所 | 30300 | 缺少其他颜色 |     | Missing Other Colour |     |
| 上交所 | 30302 | 缺少监视器用户ID |     | Missing Monitor UserID |     |
| 上交所 | 30304 | 丢失智能卡丢失代理 |     | Missing Smart Card MISSING Broker |     |
| 上交所 | 30306 | 丢失丢失的系统状态 |     | Missing MISSING System State |     |
| 上交所 | 30308 | 缺少禁用声音报警标志 |     | Missing Disable Audible Alarm Flag |     |
| 上交所 | 30310 | 缺少交易类型 |     | Missing Trade Type |     |
| 上交所 | 30312 | 缺少确认交易类型 |     | Missing Confirmation Trade Type |     |
| 上交所 | 30314 | 缺少投标价格 |     | Missing Bid Price |     |
| 上交所 | 30316 | 缺少要价 |     | Missing Ask Price |     |
| 上交所 | 30318 | 缺少投标数量 |     | Missing Bid Quantity |     |
| 上交所 | 30320 | 缺少询问数量 |     | Missing Ask Quantity |     |
| 上交所 | 30322 | 缺少BS订单参考号 |     | Missing BS Order Reference Number |     |
| 上交所 | 30324 | 缺少BS事务参考 |     | Missing BS Transaction Reference |     |
| 上交所 | 30326 | 缺少取消/减少标志 |     | Missing Cancel/Reduce Flag |     |
| 上交所 | 30328 | 缺少确认标志 |     | Missing Confirmation Flag |     |
| 上交所 | 30330 | 缺少以太网地址 |     | Missing Ethernet Address |     |
| 上交所 | 30332 | 缺少新闻项目ID |     | Missing News ItemID |     |
| 上交所 | 30334 | 缺少新闻系统ID |     | Missing News SystemID |     |
| 上交所 | 30336 | 缺少项目数 |     | Missing Number of Items |     |
| 上交所 | 30338 | 缺少软件版本号 |     | Missing Software Version Number |     |
| 上交所 | 30340 | 缺少BS贸易参考号 |     | Missing BS Trade Reference Number |     |
| 上交所 | 30342 | 缺少交易序列号 |     | Missing Trade Sequence Number |     |
| 上交所 | 30344 | 缺少ORS事务参考 |     | Missing ORS Transaction Reference |     |
| 上交所 | 30346 | 缺少消息引用 |     | Missing Message Reference |     |
| 上交所 | 30348 | 丢失声音警报（BSS未使用） |     | Missing Audible Alarm (not used by BSS) |     |
| 上交所 | 30350 | 缺少自动打印 |     | Missing Auto printing |     |
| 上交所 | 30352 | 缺少点差数量 |     | Missing No of Spreads |     |
| 上交所 | 30354 | 2039如果输入了价格，则还必须输入库存 |     | 2039 If price is input then stock must also be input |     |
| 上交所 | 30356 | 9065询价前必须指定投标书 |     | 9065 Bid must be specified before ask for quotes |     |
| 上交所 | 30358 | 2187投标方缺失 |     | 2187 Bid side missing |     |
| 上交所 | 30360 | 2188询问侧面缺失 |     | 2188 Ask side missing |     |
| 上交所 | 30362 | 4010消息翻译错误-缺少必填字段 |     | 4010 Message translation error - mandatory field missing |     |
| 上交所 | 30364 | 9040未找到订单 |     | 9040 Order not found |     |
| 上交所 | 30366 | 9008 AMS系统不可用 |     | 9008 AMS system not available |     |
| 上交所 | 30368 | 4013主机不可用 |     | 4013 Host not available |     |
| 上交所 | 30370 | 4016请求的数据不可用 |     | 4016 Requested data not available |     |
| 上交所 | 30372 | 4017 BS主机隧道堵塞 |     | 4017 BS-Host tunnel blocked |     |
| 上交所 | 30374 | 2076经纪人编号与订单不匹配 |     | 2076 Broker number does not match the order |     |
| 上交所 | 30376 | 2160 Corr经纪人必须为不同的经纪公司 |     | 2160 Corr broker must be for a different broker firm |     |
| 上交所 | 30378 | 2223 Broker必须与设备关联 |     | 2223 Broker must be associated with device |     |
| 上交所 | 30380 | 2158目标Broker必须与请求Broker不同 |     | 2158 Target Broker must be different from requesting Broker |     |
| 上交所 | 30382 | 2213必须将Broker分配给指定的Security |     | 2213 Broker must be assigned to the specified Security |     |
| 上交所 | 30384 | 9048证券不属于指定市场 |     | 9048 Security does not belong to the specified market |     |
| 上交所 | 30386 | 2119经纪公司没有资格卖空 |     | 2119 Broker firm is not eligible for short-selling |     |
| 上交所 | 30388 | 2120股票不符合卖空条件 |     | 2120 Stock is not eligible for short-selling |     |
| 上交所 | 30390 | 4024接收方ID的消息ID无效 |     | 4024 Invalid MessageID for receiverID |     |
| 上交所 | 30392 | 2162 Direct和OS不能都是Y |     | 2162 Direct and OS cannot both be Y |     |
| 上交所 | 30394 | 2201订单ID与库存代码不匹配 |     | 2201 OrderID does not match stock code |     |
| 上交所 | 30396 | 2214未在经纪公司注册的交易员 |     | 2214 Trader not registered with the broker firm |     |
| 上交所 | 30398 | 4007邀请市场组与指定市场不匹配 |     | 4007 Invitation Market Group mismatch with specified Market |     |
| 上交所 | 30400 | 9043交易已被拒绝 |     | 9043 Trade already rejected |     |
| 上交所 | 30402 | 9044销售已被拒绝 |     | 9044 Sale already rejected |     |
| 上交所 | 30404 | 9045采购已被拒绝 |     | 9045 Purchase already rejected |     |
| 上交所 | 30406 | 2070 Corr经纪人已签字 |     | 2070 Corr broker is signed off |     |
| 上交所 | 30408 | 2401交易员未签字 |     | 2401 Trader not signed on |     |
| 上交所 | 30410 | 3043市场xxxxx尚未开放 |     | 3043 Market xxxxx not yet open |     |
| 上交所 | 30412 | 3024 xxxxx市场暂停 |     | 3024 xxxxx market is ON HOLD |     |
| 上交所 | 30414 | 2145订单取消 |     | 2145 Order cancelled |     |
| 上交所 | 30416 | 2126以这个价格排队等候安检 |     | 2126 Queue full at this price for the Security |     |
| 上交所 | 30418 | 2125已达到最大允许订单数 |     | 2125 Maximum permitted orders reached |     |
| 上交所 | 30420 | 2053拍卖订单类型的价格必须为零 |     | 2053 Price must be zero for At Auction order type |     |
| 上交所 | 30422 | 2054当前交易状态不允许使用功能 |     | 2054 Function not allowed for current trading status |     |
| 上交所 | 30424 | 2056 All or Nothing必须为null |     | 2056 All or Nothing must be null |     |
| 上交所 | 30426 | 2059当市场存在时，安全代码必须为空 |     | 2059 Security Code must be blank when market is present |     |
| 上交所 | 30428 | 2061经纪人不符合市场条件 |     | 2061 Broker not eligible for Market |     |
| 上交所 | 30430 | 2064价格未价差 |     | 2064 Price not on spread |     |
| 上交所 | 30432 | 2075奇数批次订单不允许卖空 |     | 2075 Shortselling not allowed for odd lot orders |     |
| 上交所 | 30434 | 2085贸易不能被拒绝-直接贸易 |     | 2085 Trade cannot be rejected - direct trade |     |
| 上交所 | 30436 | 2094如果存在价格，则安全代码不得为空 |     | 2094 Security code must not be blank if price is present |     |
| 上交所 | 30438 | 2098 I/B对于海外和直接交易必须为空 |     | 2098 I/B must be blank for overseas and direct trades |     |
| 上交所 | 30440 | 2099操作系统必须为N，用于手动特殊和奇数交易 |     | 2099 OS must be N for manual special and odd lot trades |     |
| 上交所 | 30442 | 2103交易者'M&lt;999&gt;'已在另一个经纪人号码登录 |     | 2103 Trader ' M&lt;999&gt; ' is already signed on at another broker number |     |
| 上交所 | 30444 | 2112除信息颜色外的所有颜色都必须不同 |     | 2112 All colours except message colour must be different |     |
| 上交所 | 30446 | 2113信息颜色不能与背景颜色相同 |     | 2113 Message colour cannot be the same as a background colour |     |
| 上交所 | 30448 | 2118卖空必须为空 |     | 2118 Shortsell must be blank |     |
| 上交所 | 30450 | 2121手动交易股票不需要数量 |     | 2121 Quantity not required for manually traded Stock |     |
| 上交所 | 30452 | 2123订单已存在 |     | 2123 Order already exists |     |
| 上交所 | 30454 | 9999系统软件错误 |     | 9999 System software error |     |
| 上交所 | 30456 | 9998系统忙-消息被拒绝 |     | 9998 System busy - message rejected |     |
| 上交所 | 30458 | 9077订单序列号长度已超过BS限制。无法接受请求 |     | 9077 Order sequence number length has exceeded the BS limit. Request cannot be accepted |     |
| 上交所 | 30460 | 9076主机拒绝BS消息 |     | 9076 Host rejected BS message |     |
| 上交所 | 30462 | 9075接收到可能重复的BS消息 |     | 9075 Possible Duplicate BS message received |     |
| 上交所 | 30464 | 9074篮子包含重复的安全 |     | 9074 Basket contains duplicate Security |     |
| 上交所 | 30466 | 9073篮子包含重复的消息引用 |     | 9073 Basket contains duplicate Message-reference |     |
| 上交所 | 30468 | 9072由于全局节点故障切换，设备详细信息不可用 |     | 9072 Device details unavailable due to Global node failover |     |
| 上交所 | 30470 | 9066非活动主机无法处理恢复 |     | 9066 Non-active Host cannot process recoveries |     |
| 上交所 | 30472 | 9062节点未激活 |     | 9062 Node not active |     |
| 上交所 | 30474 | 9054最后一个订单密钥不完整 |     | 9054 Incomplete last order key |     |
| 上交所 | 30476 | 9055最后一个交易密钥不完整 |     | 9055 Incomplete last trade key |     |
| 上交所 | 30478 | 2400“M&lt;ZZZ9&gt;”的价格为“M&lt;ZZ9.99&gt;”%>上一收盘价 |     | 2400 Price of ' M&lt;ZZZ9&gt; ' is' M&lt;ZZ9.99&gt; '% > previous close |     |
| 上交所 | 30480 | 9038订单取消未被接受-订单未完成 |     | 9038 Order cancellation not accepted - order not outstanding |     |
| 上交所 | 30482 | 9042只能指定一个经纪人 |     | 9042 Only one broker must be specified |     |
| 上交所 | 30484 | 2065价格警告请重新键入 |     | 2065 Price warning please re-type |     |
| 上交所 | 30486 | 2127注意事项警告请重新键入价格和数量 |     | 2127 Consideration Warning please re-type price & quantity |     |
| 上交所 | 30488 | 2088请按ENTER并确认 |     | 2088 Please press ENTER and CONFIRM |     |
| 上交所 | 30490 | 2104在此输入Y或N |     | 2104 Enter either Y or N here |     |
| 上交所 | 30492 | 2109系统未就绪-请稍后重试 |     | 2109 System not ready - pls re-try later |     |
| 上交所 | 30494 | 2134无法完成全部或无订单 |     | 2134 Could not fulfill All or Nothing order |     |
| 上交所 | 30496 | EzEI登录失败，tcp连接失败 |     | EzEI login fail with tcp connect fail |     |
| 上交所 | 30498 | EzEI登录时出现邀请错误 |     | EzEI login with invitation error |     |
| 上交所 | 30500 | 使新密码无效 |     | Invalide New Password |     |
| 上交所 | 30502 | 无效禁用自动打印 |     | Invalide Disable Auto Printing |     |
| 上交所 | 30504 | 使智能卡序列号无效 |     | Invalide Smart Card Serial Number |     |
| 上交所 | 30506 | 使智能卡类型无效 |     | Invalide Smart Card Type |     |
| 上交所 | 30508 | 使输入的Broker编号无效（例如消息头中的Broker编号） |     | Invalide Inputting Broker Number (e.g. the broker number in the message header) |     |
| 上交所 | 30510 | 缺少新密码 |     | Missing New Password |     |
| 上交所 | 30512 | 缺少禁用自动打印 |     | Missing Disable Auto Printing |     |
| 上交所 | 30514 | 缺少智能卡序列号 |     | Missing Smart Card Serial Number |     |
| 上交所 | 30516 | 缺少智能卡类型 |     | Missing Smart Card Type |     |
| 上交所 | 30518 | 输入Broker编号（例如消息头中的Broker编号） |     | Inputting Broker Number (e.g. the broker number in the message header) |     |
| 上交所 | 30520 | 2001年注销-经纪人号码暂停 |     | 2001 Signed off - broker number suspended |     |
| 上交所 | 30522 | 2002年注销-交易员被停职 |     | 2002 Signed off - trader suspended |     |
| 上交所 | 30524 | 2003经纪人号码已激活 |     | 2003 Broker number activated |     |
| 上交所 | 30526 | 2004 Broker'M&lt;9999&gt;'已激活 |     | 2004 Broker ' M&lt;9999&gt; ' has been activated |     |
| 上交所 | 30528 | 2005 Broker'M&lt;9999&gt;'已暂停 |     | 2005 Broker ' M&lt;9999&gt; ' has been suspended |     |
| 上交所 | 30530 | 2006年智能卡目前暂停使用 |     | 2006 Smart Card is currently suspended |     |
| 上交所 | 30532 | 2017年由交易所签署 |     | 2017 Signed off by the Exchange |     |
| 上交所 | 30534 | 2018经纪公司“M&lt;99999&gt;”已激活 |     | 2018 Broker firm ' M&lt;99999&gt; ' has been activated |     |
| 上交所 | 30536 | 2019经纪公司“M&lt;99999&gt;”已被暂停 |     | 2019 Broker firm ' M&lt;99999&gt; ' has been suspended |     |
| 上交所 | 30538 | 经纪公司“M&lt;99999&gt;”的2020交易员“M&lt;999&gt;”已被激活 |     | 2020 Trader ' M&lt;999&gt; ' of broker firm ' M&lt;99999&gt; ' has been activated |     |
| 上交所 | 30540 | 2022安全“M&lt;ZZZZ9&gt;”已重新激活 |     | 2022 Security ' M&lt;ZZZZ9&gt; ' has been re-activated |     |
| 上交所 | 30542 | 2024年签署-经纪公司停牌 |     | 2024 Signed off - broker firm suspended |     |
| 上交所 | 30544 | 2027交易员'M&lt;999&gt;'已被停职 |     | 2027 Trader ' M&lt;999&gt; ' has been suspended |     |
| 上交所 | 30546 | 2031代理经纪人永久签字 |     | 2031 Correspondent Broker permanently signed off |     |
| 上交所 | 30548 | 2032指定交易者未签署的经纪人 |     | 2032 Broker not signed on by the specified Trader |     |
| 上交所 | 30550 | 2036安全暂停 |     | 2036 Security suspended |     |
| 上交所 | 30552 | 2037价格缺失 |     | 2037 Price missing |     |
| 上交所 | 30554 | 2038无效价格 |     | 2038 Invalid price |     |
| 上交所 | 30556 | 2041 Cnfm交易员不能与当前交易员相同 |     | 2041 Cnfm trader cannot be the same as the current trader |     |
| 上交所 | 30558 | 2042代理经纪人被暂停 |     | 2042 Correspondent Broker suspended |     |
| 上交所 | 30560 | 2043订单价格无效 |     | 2043 Invalid order price |     |
| 上交所 | 30562 | 2044新密码不能与最近的密码相同 |     | 2044 New password cannot be the same as recent password(s) |     |
| 上交所 | 30564 | 2045无效密码-必须至少有6个字符 |     | 2045 Invalid password - must be at least 6 characters |     |
| 上交所 | 30566 | 2052交易商不得为注册交易商 |     | 2052 Broker must not be registered trader |     |
| 上交所 | 30568 | 2055交易员未在指定经纪商上签字 |     | 2055 Trader not signed on the specified Broker |     |
| 上交所 | 30570 | 2060无效交易价格 |     | 2060 Invalid trade price |     |
| 上交所 | 30572 | 2062交易商必须是注册交易商 |     | 2062 Broker must be registered trader |     |
| 上交所 | 30574 | 2067无效数量 |     | 2067 Invalid quantity |     |
| 上交所 | 30576 | 2068数量缺失 |     | 2068 Quantity missing |     |
| 上交所 | 30578 | 2069提交消息的Broker不存在 |     | 2069 Broker submitting the message does not exist |     |
| 上交所 | 30580 | 2071此经纪人号码已暂停 |     | 2071 This broker number is suspended |     |
| 上交所 | 30582 | 2072授权交易员已被停职 |     | 2072 Authorising trader has been suspended |     |
| 上交所 | 30584 | 2073经纪公司已停牌 |     | 2073 Broker firm has been suspended |     |
| 上交所 | 30586 | 2074无效经纪人 |     | 2074 Invalid Broker |     |
| 上交所 | 30588 | 2077无法从此经纪人号码取消订单 |     | 2077 Order cannot be cancelled from this broker number |     |
| 上交所 | 30590 | 2078代理行经纪公司停牌 |     | 2078 Broker firm of correspondent broker suspended |     |
| 上交所 | 30592 | 2081警告！价格'M&lt;ZZ9&gt;'S从名义价格。请检查 |     | 2081 Warning! Price ' M&lt;ZZ9&gt; ' S from nominal. Please check |     |
| 上交所 | 30594 | 2082警告！价格'M&lt;ZZ9&gt;'S从名义价格。再次检查 |     | 2082 Warning! Price ' M&lt;ZZ9&gt; ' S from nominal. Check again |     |
| 上交所 | 30596 | 2083警告！报警标称价格'M&lt;ZZ9&gt;'S。请检查 |     | 2083 Warning! Price ' M&lt;ZZ9&gt; ' S from Alarm nominal. Please check |     |
| 上交所 | 30598 | 2084警告！报警标称价格'M&lt;ZZ9&gt;'S。再次检查 |     | 2084 Warning! Price ' M&lt;ZZ9&gt; ' S from Alarm nominal. Check again |     |
| 上交所 | 30600 | 2086价格'M&lt;ZZ9&gt;'S从名义价格。需要第二个交易员ID/密码 |     | 2086 Price ' M&lt;ZZ9&gt; ' S from nominal. 2nd traderID/password reqd |     |
| 上交所 | 30602 | 2087价格'M&lt;ZZ9&gt;'S来自报警名称。需要第二个trderID/密码 |     | 2087 Price ' M&lt;ZZ9&gt; ' S from alarm nom. 2nd trderID/password reqd |     |
| 上交所 | 30604 | 2089交易不能被拒绝-无效的交易类型 |     | 2089 Trade cannot be rejected - invalid trade type |     |
| 上交所 | 30606 | 2090无效时间 |     | 2090 Invalid time |     |
| 上交所 | 30608 | 2093无法从此经纪人修改交易 |     | 2093 Trade cannot be modified from this broker |     |
| 上交所 | 30610 | 2095 ORS详细信息与提交的订单详细信息不匹配 |     | 2095 ORS details does not match the submitted order details |     |
| 上交所 | 30612 | 2096找不到页码 |     | 2096 Page number not found |     |
| 上交所 | 30614 | 2097页码无效 |     | 2097 Invalid page number |     |
| 上交所 | 30616 | 2101无效密码 |     | 2101 Invalid password |     |
| 上交所 | 30618 | 2102交易员'M&lt;999&gt;'停牌 |     | 2102 Trader ' M&lt;999&gt; ' suspended |     |
| 上交所 | 30620 | 2105无效的交易者/密码 |     | 2105 Invalid trader/password |     |
| 上交所 | 30622 | 2107用户“M&lt;99999&gt;M&lt;999&gt;”无法在代理“M&lt;9999&gt;”处登录-密码不正确 |     | 2107 User ' M&lt;99999&gt; M&lt;999&gt; ' failed to sign on at broker ' M&lt;9999&gt; ' - incorrect password |     |
| 上交所 | 30624 | 2108用户“M&lt;99999&gt;M&lt;999&gt;”未能在经纪人“M&lt;9999&gt;”处登录-未经授权的交易员 |     | 2108 User ' M&lt;99999&gt; M&lt;999&gt; ' failed to sign on at broker ' M&lt;9999&gt; ' - un-authorised trader |     |
| 上交所 | 30626 | 2111无效颜色 |     | 2111 Invalid colour |     |
| 上交所 | 30628 | 2116无效卖空 |     | 2116 Invalid Shortsell |     |
| 上交所 | 30630 | 2122仅以现有价格订购 |     | 2122 Order at existing price only |     |
| 上交所 | 30632 | 2128注意事项警告请按enter并确认 |     | 2128 Consideration Warning please press enter and confirm |     |
| 上交所 | 30634 | 2130'M99:99X M&lt;ZZZ9&gt;X A X A9 X M&lt;ZZ-ZZZ9&gt;“填充”M&lt;ZZ-ZZZ9&gt;O/S参考A10 |     | 2130' M99:99 X M&lt;ZZZ9&gt; X A X A9 X M&lt;ZZ ZZZ ZZ9&gt; 'filled' M&lt;ZZ ZZZ ZZ9&gt; O/S ref A10 |     |
| 上交所 | 30636 | 2131剩余特别限额订单被拒绝 |     | 2131 Residual special limit order rejected |     |
| 上交所 | 30638 | 2132 Open Gateway的注销类型必须是永久性的 |     | 2132 Log-off type must be permanent for Open Gateway |     |
| 上交所 | 30640 | 2133当前交易状态下不允许订单类型 |     | 2133 Order type not permitted in the current trading status |     |
| 上交所 | 30642 | 2135剩余订单被拒绝-价格无效 |     | 2135 Residual order rejected - price invalid |     |
| 上交所 | 30644 | 2136剩余拍卖订单被拒 |     | 2136 Residual At Auction order rejected |     |
| 上交所 | 30646 | 2137&lt;<无短信&gt;> |     | 2137 &lt;<no text message&gt;> |     |
| 上交所 | 30648 | 2138无效的市场代码 |     | 2138 Invalid Market Code |     |
| 上交所 | 30650 | 2139 All or Nothing标志必须为N |     | 2139 All or Nothing flag must be N |     |
| 上交所 | 30652 | 2141数量不是板批次的倍数 |     | 2141 Quantity is not a multiple of board lot |     |
| 上交所 | 30654 | 2143数量不得等于1个板批次 |     | 2143 Quantity must not equal to 1 board lot |     |
| 上交所 | 30656 | 2144此类交易不允许卖空 |     | 2144 Short-selling is not allowed for this type of trade |     |
| 上交所 | 30658 | 2146直接交易的结算类型必须为空 |     | 2146 Settlement type must be blank for direct trade |     |
| 上交所 | 30660 | 2147非直接交易的结算类型无效 |     | 2147 Invalid Settlement type for non-direct trade |     |
| 上交所 | 30662 | 2148无法选择手动交易的股票 |     | 2148 Cannot select a manually traded Stock |     |
| 上交所 | 30664 | 2149批量取消已完成，“M&lt;ZZ9&gt;”订单已取消 |     | 2149 Bulk cancel completed with' M&lt;ZZ9&gt; ' orders cancelled |     |
| 上交所 | 30666 | 2151当存在证券时，市场代码必须为空 |     | 2151 Market Code must be blank when Security is present |     |
| 上交所 | 30668 | 2152不允许交易-未启用跨代理功能 |     | 2152 Transaction not allowed - cross broker functions not enabled |     |
| 上交所 | 30670 | 2153证券市场组未分配给经纪人 |     | 2153 Market group of security not assigned to broker |     |
| 上交所 | 30672 | 2155经纪人未签字 |     | 2155 Broker not signed on |     |
| 上交所 | 30674 | 2156经纪人必须属于同一家经纪公司 |     | 2156 Broker must belong to the same broker firm |     |
| 上交所 | 30676 | 2157只允许预开放交易 |     | 2157 Only pre-open trades are allowed |     |
| 上交所 | 30678 | 2159不得将目标代理分配给同一设备 |     | 2159 Target Broker must not be assigned to the same Device |     |
| 上交所 | 30680 | 2161直接或海外交易的Corr经纪商必须为空 |     | 2161 Corr broker must be blank for direct or overseas trades |     |
| 上交所 | 30682 | 原始订单中缺少2163 ORS详细信息 |     | 2163 ORS details missing from the original Order |     |
| 上交所 | 30684 | 2164当前交易时段不允许卖空 |     | 2164 Shortsell not allowed for the current trading session |     |
| 上交所 | 30686 | 2167不能拒绝来自此经纪人号码的交易 |     | 2167 Trade cannot be rejected from this broker number |     |
| 上交所 | 30688 | 2168采购已被拒绝 |     | 2168 Purchase already rejected |     |
| 上交所 | 30690 | 2169购买不在同一交易日 |     | 2169 Purchase not in same session |     |
| 上交所 | 30692 | 2170销售已被拒绝 |     | 2170 Sale already rejected |     |
| 上交所 | 30694 | 2171交易已被拒绝 |     | 2171 Trade already rejected |     |
| 上交所 | 30696 | 2172交易者不得为交叉交易设备授权人 |     | 2172 Trader must not be a Cross Trading Device Authoriser |     |
| 上交所 | 30698 | 2173 ORS详细信息缺失 |     | 2173 ORS details missing |     |
| 上交所 | 30700 | 2174授权人必须是交叉交易设备授权人 |     | 2174 Authoriser must be a cross trading device authoriser |     |
| 上交所 | 30702 | 2175经纪人没有资格获得指定的担保 |     | 2175 Broker not eligible for the specified Security |     |
| 上交所 | 30704 | 2176数量必须少于一个板批次 |     | 2176 Quantity must be less than one board lot |     |
| 上交所 | 30706 | 2177数量必须是'M&lt;ZZZ ZZZ ZZ9&gt;的倍数 |     | 2177 Quantity must be a multiple of ' M&lt;ZZZ ZZZ ZZ9&gt; |     |
| 上交所 | 30708 | 2183订单取消未被接受-订单未完成 |     | 2183 Order cancellation not accepted - order not outstanding |     |
| 上交所 | 30710 | 2185订单类型错误-不接受半自动匹配 |     | 2185 Wrong order type - semi-automatic matching not accepted |     |
| 上交所 | 30712 | 2186未找到订单 |     | 2186 Order not found |     |
| 上交所 | 30714 | 2189必须将组织Broker分配给req Broker的所有Mkt组 |     | 2189 Org Broker must be assigned to all Mkt Grps of req Broker |     |
| 上交所 | 30716 | 2193授权交易员密码无效 |     | 2193 Invalid authorising trader password |     |
| 上交所 | 30718 | 2199批量取消指示符无效 |     | 2199 Invalid bulk cancel indicator |     |
| 上交所 | 30720 | 2200注销-交叉交易设备被'M&lt;9999&gt;取消 |     | 2200 Signed off - cross trading device cancel by ' M&lt;9999&gt; |     |
| 上交所 | 30722 | 2202“M<9999”没有订单被取消 |     | 2202 No orders cancelled for ' M&lt;9999&gt; |     |
| 上交所 | 30724 | 2203单笔订单取消需要空白的投标/询价指示器 |     | 2203 Single order cancel requires blank bid/ask indicator |     |
| 上交所 | 30726 | 2204批量取消需要空白订单ID |     | 2204 Bulk cancel requires blank orderID |     |
| 上交所 | 30728 | 2205“M&lt;ZZZ9&gt;”经纪人的订单被取消“M<9999” |     | 2205' M&lt;ZZZ9&gt; ' orders cancelled for broker ' M&lt;9999&gt; |     |
| 上交所 | 30730 | 2206'M&lt;ZZZ9&gt;'订单和'M&lt;ZZ9&gt;'经纪人的Sp/奇数批订单被取消'M&lt;9999&gt; |     | 2206' M&lt;ZZZ9&gt; ' Orders & ' M&lt;ZZ9&gt; ' Sp/odd lot orders cancelled for broker' M&lt;9999&gt; |     |
| 上交所 | 30732 | 2207不得与登录交易者相同 |     | 2207 Must not be same as sign on trader |     |
| 上交所 | 30734 | 2209当前交易时段不允许报价请求 |     | 2209 Quote request not allowed in current trading session |     |
| 上交所 | 30736 | 2210必须是自动安全 |     | 2210 Must be automatch security |     |
| 上交所 | 30738 | 2211必须是非自动安全 |     | 2211 Must be non-automatch security |     |
| 上交所 | 30740 | 2212数量必须小于原始订单数量 |     | 2212 Quantity must be less than original order quantity |     |
| 上交所 | 30742 | 2215经纪人永久签字 |     | 2215 Broker permanently signed off |     |
| 上交所 | 30744 | 2216订单修改未被接受-订单未完成 |     | 2216 Order modification not accepted - order not outstanding |     |
| 上交所 | 30746 | 2217数量不得为板材批次的倍数 |     | 2217 Quantity must not be multiple of board lot |     |
| 上交所 | 30748 | 2220交易者必须与设备属于同一家经纪公司 |     | 2220 Trader must belong to the same broker firm as device |     |
| 上交所 | 30750 | 2222不允许报价请求-未达到RT监视器截止时间 |     | 2222 Quote Request not allowed - RT monitor cut-off time not reached |     |
| 上交所 | 30752 | 2224如果存在担保，则必须存在交易序列号 |     | 2224 If security is present trade sequence number must be present |     |
| 上交所 | 30754 | 2225投标方报价必须小于询价方报价 |     | 2225 Bid side quote price must be less than ask side quote price |     |
| 上交所 | 30756 | 2229智能卡已过期 |     | 2229 Smart card has expired |     |
| 上交所 | 30758 | 2230智能卡对设备无效 |     | 2230 Smart card invalid for device |     |
| 上交所 | 30760 | 2231 ORS Trans Ref和/或投资者ID必须是数字 |     | 2231 ORS Trans Ref &/or InvestorID must be numeric |     |
| 上交所 | 30762 | 2232 ORS事务源和/或CAID必须是字符串 |     | 2232 ORS Trans Source &/or CAID must be character string |     |
| 上交所 | 30764 | 2402'M&lt;ZZZ9&gt;'总交易量超过交易量阈值'M&lt;ZZ9.99&gt;'% |     | 2402 ' M&lt;ZZZ9&gt; ' total volume exceeds trading volume threshold by ' M&lt;ZZ9.99&gt; '% |     |
| 上交所 | 30766 | 2403‘M&lt;ZZZ9&gt;‘卖方’M&lt;9999&gt;‘买方’M&lt;9999&gt;X A3（I1）M&lt;ZZZ ZZZ ZZ9&gt;在一笔交易中 |     | 2403 ' M&lt;ZZZ9&gt; ' seller ' M&lt;9999&gt; ' Buyer' M&lt;9999&gt; X A3 (I1) M&lt;ZZZ ZZZ ZZZ ZZ9&gt; in one trade |     |
| 上交所 | 30768 | 2404“M&lt;ZZZ9&gt;”经纪公司“M&lt;99999&gt;的交易量占总交易量的“M&lt;ZZ9.99&gt;”%以上 |     | 2404 ' M&lt;ZZZ9&gt; ' broker firm' M&lt;99999&gt; has dealt more than ' M&lt;ZZ9.99&gt; '% of the total trades |     |
| 上交所 | 30770 | 2405指数A8上涨M&lt;ZZ9.99&gt;'% |     | 2405 Index' A8 'up by M&lt;ZZ9.99&gt; '% of previous close |     |
| 上交所 | 30772 | 2406指数“A8”上涨M&lt;ZZ9.99&gt;前一警报的“%” |     | 2406 Index' A8 'up by M&lt;ZZ9.99&gt; '% of previous alert |     |
| 上交所 | 30774 | 2407指数A8较前一收盘下跌M&lt;ZZ9.99&gt;'% |     | 2407 Index' A8 'down by M&lt;ZZ9.99&gt; '% of previous close |     |
| 上交所 | 30776 | 2408指数“A8”下跌M&lt;ZZ9.99&gt;'%，为先前警报 |     | 2408 Index' A8 'down by M&lt;ZZ9.99&gt; '% of previous alert |     |
| 上交所 | 30778 | 2409经纪公司“M&lt;99999&gt;”的交易敞口已达到交易上限的“M&lt;ZZ9.99&gt;”% |     | 2409 Broker firm ' M&lt;99999&gt; ' trading exposure has reached ' M&lt;ZZ9.99&gt; '% of trading cap |     |
| 上交所 | 30780 | 2411由交易所签署-不允许签署 |     | 2411 Signed off by the Exchange - no sign on permitted |     |
| 上交所 | 30782 | 2412现在有经纪人号码-允许登录 |     | 2412 Broker number is now available - sign on permitted |     |
| 上交所 | 30784 | 2415用户“M&lt;99999&gt;M&lt;999&gt;”未能在经纪人“M&lt;9999&gt;”处登录-交易员被暂停 |     | 2415 User ' M&lt;99999&gt; M&lt;999&gt; ' failed to sign on at broker ' M&lt;9999&gt; ' - trader suspended |     |
| 上交所 | 30786 | 2416订单减少数量过大 |     | 2416 Order Reduction Quantity too large |     |
| 上交所 | 30788 | 2417市场组“M&lt;9999”的经纪人“M<9999&gt;”已激活 |     | 2417 Broker ' M&lt;9999&gt; ' has been activated for Market Group ' M&lt;9999&gt; |     |
| 上交所 | 30790 | 2418 Broker'M&lt;9999&gt;'已因市场组“M<9999”而暂停 |     | 2418 Broker ' M&lt;9999&gt;.' has been suspended for Market Group ' M&lt;9999&gt; |     |
| 上交所 | 30792 | 2419经纪公司激活 |     | 2419 Broker firm activated |     |
| 上交所 | 30794 | 2420会员公司没有资格获得一揽子订单 |     | 2420 Member Firm not eligible for Basket Orders |     |
| 上交所 | 30796 | 2422一揽子订单中的无效担保 |     | 2422 Invalid Security in Basket Order |     |
| 上交所 | 30798 | 2423篮子必须包含同一侧的订单 |     | 2423 Basket must contain orders for same side |     |
| 上交所 | 30800 | 2424无效的订单类型 |     | 2424 Invalid Order Type |     |
| 上交所 | 30802 | 2425篮子必须满足最低成分股 |     | 2425 Basket must satisfy minimum constituent stocks |     |
| 上交所 | 30804 | 2500用户'M&lt;999&gt;'已在另一台显示器PC上签名 |     | 2500 User ' M&lt;999&gt; ' is already signed on another monitor PC |     |
| 上交所 | 30806 | 2501监视器用户密码无效 |     | 2501 Invalid monitor user password |     |
| 上交所 | 30808 | 2502没有监视器用户在监视器PC上签名 |     | 2502 No monitor user signed on the monitor PC |     |
| 上交所 | 30810 | 3001开盘 |     | 3001 Market open |     |
| 上交所 | 30812 | 3002仅限固定价格订单 |     | 3002 Fixed price orders only |     |
| 上交所 | 30814 | 3003仅限销售输入 |     | 3003 Sales input only |     |
| 上交所 | 30816 | 3004仅交易拒绝 |     | 3004 Trade rejection only |     |
| 上交所 | 30818 | 3005交易所干预 |     | 3005 Exchange intervention |     |
| 上交所 | 30820 | 3006市场冻结 |     | 3006 Market freeze |     |
| 上交所 | 30822 | 3007市场收盘 |     | 3007 Market closed |     |
| 上交所 | 30824 | 3008仅限订单取消 |     | 3008 Order cancellation only |     |
| 上交所 | 30826 | 3010该市场的收盘价尚未计算 |     | 3010 Closing price for this Market has not been calculated |     |
| 上交所 | 30828 | 3011证券不属于指定市场 |     | 3011 Security does not belong to the specified Market |     |
| 上交所 | 30830 | 3012请求未被接受-不是RT安全 |     | 3012 Request not accepted - not a RT security |     |
| 上交所 | 30832 | 3013请求未被接受-证券有足够的流动性 |     | 3013 Request not accepted - security has enough liquidity |     |
| 上交所 | 30834 | 3016交易所：交易日期='M&lt;99999999&gt;'半天手动控制 |     | 3016 Exchange: trade date = ' M&lt;99999999&gt; ' half-day manual control |     |
| 上交所 | 30836 | 3017 xxxxx市场：交易日期='M&lt;99999999&gt;'全天手动控制 |     | 3017 xxxxx market: trade date = ' M&lt;99999999&gt; ' full-day manual control |     |
| 上交所 | 30838 | 3018 xxxxx市场：交易日期='M&lt;99999999&gt;'半天自动控制 |     | 3018 xxxxx market: trade date = ' M&lt;99999999&gt; ' half-day auto control |     |
| 上交所 | 30840 | 3019 xxxxx市场：交易日期='M&lt;99999999&gt;'全天自动控制 |     | 3019 xxxxx market: trade date = ' M&lt;99999999&gt; ' full-day auto control |     |
| 上交所 | 30842 | 3020 xxxxx市场：交易日期='M&lt;99999999&gt;'非交易手动控制 |     | 3020 xxxxx market: trade date = ' M&lt;99999999&gt; ' non-trading manual control |     |
| 上交所 | 30844 | 3021 xxxxx市场：交易日期='M&lt;99999999&gt;'非交易自动控制 |     | 3021 xxxxx market: trade date = ' M&lt;99999999&gt; ' non-trading auto control |     |
| 上交所 | 30846 | 3022 xxxxx市场现在处于手动控制之下 |     | 3022 xxxxx market now under Manual Control |     |
| 上交所 | 30848 | 3023 xxxxx市场现在处于自动控制之下 |     | 3023 xxxxx market now under Auto Control |     |
| 上交所 | 30850 | 3025 xxxxx市场未暂停 |     | 3025 xxxxx market is not ON HOLD |     |
| 上交所 | 30852 | 3031 xxxxx的订单输入开始 |     | 3031 Order Input starts for xxxxx |     |
| 上交所 | 30854 | 3032 xxxxx的预购匹配开始 |     | 3032 Pre-order Matching starts for xxxxx |     |
| 上交所 | 30856 | 3033 xxxxx的订单匹配开始 |     | 3033 Order Matching starts for xxxxx |     |
| 上交所 | 30858 | 3034 xxxxx的阻塞开始 |     | 3034 Blocking starts for xxxxx |     |
| 上交所 | 30860 | 3035 xxxxx的订单取消开始 |     | 3035 Order cancel starts for xxxxx |     |
| 上交所 | 30862 | 3036 xxxxx开始连续交易 |     | 3036 Continuous trading starts for xxxxx |     |
| 上交所 | 30864 | 3037 xxxxx的固定起价 |     | 3037 Fixed price starts for xxxxx |     |
| 上交所 | 30866 | 3038 xxxxx的销售输入开始 |     | 3038 Sales input starts for xxxxx |     |
| 上交所 | 30868 | 3039 xxxxx的Exchange干预开始 |     | 3039 Exchange intervention starts for xxxxx |     |
| 上交所 | 30870 | 3040 xxxxx的冻结开始 |     | 3040 Freeze starts for xxxxx |     |
| 上交所 | 30872 | 3041 xxxxx的关闭启动 |     | 3041 Close starts for xxxxx |     |
| 上交所 | 30874 | 3042 xxxxx开始休市 |     | 3042 Day close starts for xxxxx |     |
| 上交所 | 30876 | 4001经纪人号码无效 |     | 4001 Broker Number invalid |     |
| 上交所 | 30878 | 4004未登录的经纪人号码 |     | 4004 Broker Number not signed on |     |
| 上交所 | 30880 | 4006邀请市场组与指定的安全性不匹配 |     | 4006 Invitation Market Group mismatch with specified Security |     |
| 上交所 | 30882 | 4012一般错误 |     | 4012 General error |     |
| 上交所 | 30884 | 4014 ORS不可用 |     | 4014 ORS not available |     |
| 上交所 | 30886 | 4015 BS不可用 |     | 4015 BS not available |     |
| 上交所 | 30888 | 4018 BS-ORS隧道堵塞 |     | 4018 BS-ORS tunnel blocked |     |
| 上交所 | 30890 | 4023无效消息引用 |     | 4023 Invalid Message Reference |     |
| 上交所 | 30892 | 4026 ACP登录尚未完成 |     | 4026 ACP Logon NOT yet done |     |
| 上交所 | 30894 | 4028无法向主机发送消息 |     | 4028 Failed to send message to Host |     |
| 上交所 | 30896 | 4030无法转换为打开的消息 |     | 4030 Failed to convert to Open Message |     |
| 上交所 | 30898 | 4031无此类担保 |     | 4031 No such security |     |
| 上交所 | 30900 | 4032无效的市场代码 |     | 4032 Invalid Market Code |     |
| 上交所 | 30902 | 4033安全数据检查错误 |     | 4033 Security Data Check Error |     |
| 上交所 | 30904 | 4034非ORS起源的COI包含非零ORS-TRAN-REF |     | 4034 Non-ORS originated COI contains non-zero ORS-TRAN-REF |     |
| 上交所 | 30906 | 4035尚未登录OG |     | 4035 Not Logon to OG yet |     |
| 上交所 | 30908 | 4036打开消息头中的非法终止符 |     | 4036 Illegal Terminator in Open Message Header |     |
| 上交所 | 30910 | 4038向BS发送消息失败 |     | 4038 Failed to send message to BS |     |
| 上交所 | 30912 | 4039无法转换为专有消息 |     | 4039 Failed to convert to Proprietary Message |     |
| 上交所 | 30914 | 4040非ORS起源的COC包含非零ORS-TRAN-REF |     | 4040 Non-ORS originated COC contains non-zero ORS-TRAN-REF |     |
| 上交所 | 30916 | 4041源自非ORS的COM包含非零ORS-TRAN-REF |     | 4041 Non-ORS originated COM contains non-zero ORS-TRAN-REF |     |
| 上交所 | 30918 | 4042超过邀请费消息流量控制率 |     | 4042 Invitation fee message flow control rate exceeded |     |
| 上交所 | 30920 | 4044 OG恢复期间不允许出现阻塞事务 |     | 4044 Throttled Transaction is not allowed during OG Recovery |     |
| 上交所 | 30922 | 4045二进制安全动态信息标志必须是Y或N |     | 4045 Binary Security Dynamic Info Flag must be Y or N |     |
| 上交所 | 30924 | 4046设备交易馈送模式关闭 |     | 4046 Device trade feed mode is off |     |
| 上交所 | 30926 | 4047长订单序列号支持标志必须为Y或N |     | 4047 Long Order Sequence Number Support Flag must be Y or N |     |
| 上交所 | 30928 | 4048动态市场数据馈送关闭 |     | 4048 Dynamic Market Data Feed is off |     |
| 上交所 | 30930 | 9000系统已启动 |     | 9000 System started |     |
| 上交所 | 30932 | 9001系统关闭 |     | 9001 System closed |     |
| 上交所 | 30934 | 9002已注销-I/O错误 |     | 9002 Signed off - I/O error |     |
| 上交所 | 30936 | 9003终端I/O错误 |     | 9003 Terminal I/O error |     |
| 上交所 | 30938 | 9004正在恢复操作 |     | 9004 Operation being recovered |     |
| 上交所 | 30940 | 9005故障后重新启动 |     | 9005 Restarted after failure |     |
| 上交所 | 30942 | 9006故障后重新启动 |     | 9006 Restarting after failure |     |
| 上交所 | 30944 | 9007正在回收 |     | 9007 Being recovered |     |
| 上交所 | 30946 | 9010项目数量必须在允许的最大数量范围内 |     | 9010 Number of items must be within the maximum allowed number |     |
| 上交所 | 30948 | 9011交易序列号无效 |     | 9011 Invalid trade sequence number |     |
| 上交所 | 30950 | 9012系统忙，稍后重试 |     | 9012 System busy re-try later |     |
| 上交所 | 30952 | 9023无效的确认标志 |     | 9023 Invalid Confirmation Flag |     |
| 上交所 | 30954 | 9024确认交易类型必须为Y或N |     | 9024 Confirmation Trade Type must be Y or N |     |
| 上交所 | 30956 | 9026非活动主机无法处理恢复 |     | 9026 Non-active Host cannot process recoveries |     |
| 上交所 | 30958 | 9027主机收到的代理号码无效 |     | 9027 Invalid broker number received by Host |     |
| 上交所 | 30960 | 9028主机无法识别经纪人号码 |     | 9028 Broker number not recognised by Host |     |
| 上交所 | 30962 | 9029恢复设备仍未连接或登录 |     | 9029 Recovering device is still not connected or logged on |     |
| 上交所 | 30964 | 9030缺少经纪人号码 |     | 9030 Broker number missing |     |
| 上交所 | 30966 | 9031经纪人必须与交易员属于同一家经纪公司 |     | 9031 Broker must belong to the same broker firm as trader |     |
| 上交所 | 30968 | 9032由另一交易员签署的经纪人 |     | 9032 Broker signed on by another Trader |     |
| 上交所 | 30970 | 9033经纪人被停职 |     | 9033 Broker suspended |     |
| 上交所 | 30972 | 9034交易商不得为注册交易商 |     | 9034 Broker must not be registered trader |     |
| 上交所 | 30974 | 9035交易商必须是注册交易商 |     | 9035 Broker must be registered trader |     |
| 上交所 | 30976 | 9036无效的出价/询价指标 |     | 9036 Invalid Bid/Ask indicator |     |
| 上交所 | 30978 | 9037订单修改未被接受-订单未完成 |     | 9037 Order modification not accepted - order not outstanding |     |
| 上交所 | 30980 | 9041订单端错误-不接受半自动匹配 |     | 9041 Wrong order side - semi automatic matching not accepted |     |
| 上交所 | 30982 | 9046无效时间 |     | 9046 Invalid time |     |
| 上交所 | 30984 | 9047无效的新闻项目id |     | 9047 Invalid news itemID |     |
| 上交所 | 30986 | 9049无效的安全性 |     | 9049 Invalid Security |     |
| 上交所 | 30988 | 9050无效的broker |     | 9050 Invalid broker |     |
| 上交所 | 30990 | 9051项目数量不得为负数 |     | 9051 Number of items must not be negative |     |
| 上交所 | 30992 | 9053无效的新闻系统id |     | 9053 Invalid news systemID |     |
| 上交所 | 30994 | 9056收到最初被拒绝的ORS交易的副本 |     | 9056 Duplicate received of originally rejected ORS transaction |     |
| 上交所 | 30996 | 9057接收到最初被拒绝的BS消息的重复 |     | 9057 Duplicate received of originally rejected BS message |     |
| 上交所 | 30998 | 9058收到原始接受ORS交易的副本 |     | 9058 Duplicate received of originally accepted ORS transaction |     |
| 上交所 | 31000 | 9059收到正在进行的ORS交易的副本 |     | 9059 Duplicate received of an in progress ORS transaction |     |
| 上交所 | 31002 | 9060接收到原始接受的BS消息的重复 |     | 9060 Duplicate received of originally accepted BS message |     |
| 上交所 | 31004 | 9061接收到重复的正在进行的BS消息 |     | 9061 Duplicate received of an in progress BS message |     |
| 上交所 | 31006 | 9067主机无法识别设备 |     | 9067 Device not recognised by Host |     |
| 上交所 | 31008 | 9068设备交易馈送模式关闭 |     | 9068 Device trade feed mode is off |     |
| 上交所 | 31010 | 9070无法指定Broker编号 |     | 9070 Cannot specify Broker Number |     |
| 上交所 | 31012 | 9997软件错误。无效的S/W版本：'M&lt;9999&gt;'串联：'M&lt;2999&gt; |     | 9997 Software error. Invalid S/W version: ' M&lt;9999&gt; ' tandem: ' M&lt;9999&gt; |     |
| 上交所 | 31014 | 2601因VCM而拒绝订单 |     | 2601 Order Reject due to VCM |     |
| 上交所 | 31016 | 2602因VCM而拒绝订单 |     | 2602 Order Reject due to VCM |     |
| 上交所 | 31018 | 2611因拍卖价格限制而取消订单 |     | 2611 Order Cancelled due to Auction Price Limits |     |
| 上交所 | 31020 | 2612因拍卖价格限制而拒绝订单 |     | 2612 Order Rejected due to Auction Price Limits |     |
| 上交所 | 31022 | 3（订单超限） |     | 3(Order Exceed Limit) |     |
| 上交所 | 31024 | 6（重复订单） |     | 6(Duplicate order) |     |
| 上交所 | 31026 | 13（数量不正确） |     | 13(Incorrect Qty) |     |
| 上交所 | 31028 | 16（价格超过当前价格区间） |     | 16(Price exceeds current price band) |     |
| 上交所 | 31030 | 19（没有参考价格） |     | 19(Reference price is not available) |     |
| 上交所 | 31032 | 20（名义值超过阈值） |     | 20(Notional value exceeds threshold) |     |
| 上交所 | 31034 | 101（价格超过当前价格区间（不允许高估）） |     | 101(Price exceeds current price band(overrid not allowed)) |     |
| 上交所 | 31036 | 102（价格超过当前价格区间） |     | 102(Price exceeds current price band) |     |
| 上交所 | 31038 | 0（取消为时已晚） |     | 0(Too late to cancel) |     |
| 上交所 | 31040 | 1（未知顺序） |     | 1(Unknown Order) |     |
| 上交所 | 31042 | 3（订单已处于“挂起取消”或“挂起替换”状态） |     | 3(Order already in Pending Cancel or Pending Replace status) |     |
| 上交所 | 31044 | 6（收到重复的客户订单ID） |     | 6(Duplicate Client OrderID received) |     |
| 上交所 | 31046 | 1（缺少必填字段） |     | 1(Required field missing) |     |
| 上交所 | 31048 | 2（未为此消息定义字段） |     | 2(Field not defined for this message) |     |
| 上交所 | 31050 | 3（未定义的字段） |     | 3(Undefined field) |     |
| 上交所 | 31052 | 4（指定的字段没有值） |     | 4(Field specified without a value) |     |
| 上交所 | 31054 | 5（此字段的值不正确） |     | 5(Value is incorrect for this field) |     |
| 上交所 | 31056 | 6（值的数据格式不正确） |     | 6(Incorrect data format for value) |     |
| 上交所 | 31058 | 9（CompID问题） |     | 9(CompID problem) |     |
| 上交所 | 31060 | 11（消息类型无效） |     | 11(Invalid message type) |     |
| 上交所 | 31062 | 13（字段出现多次） |     | 13(Field appears more than once) |     |
| 上交所 | 31064 | 1（未知ID） |     | 1(UnknownID) |     |
| 上交所 | 31066 | 2（未知安全性） |     | 2(Unknown Security) |     |
| 上交所 | 31068 | 3（未指定的消息类型） |     | 3(Unspecified Message Type) |     |
| 上交所 | 31070 | 4（应用程序不可用） |     | 4(Application not available) |     |
| 上交所 | 31072 | 5（有条件要求的字段缺失） |     | 5(Conditionally required field missing) |     |
| 上交所 | 31074 | 8（超过油门限制） |     | 8(Throttle limit exceeded) |     |
| 上交所 | 32000 | 其他由于订单被拒 |     | Other due to Order Rejected |     |
| 上交所 | 32002 | 其他由于订单取消被拒绝 |     | Other due to Order Cancel Rejected |     |
| 上交所 | 32004 | 其他因拒绝 |     | Other due to Reject |     |
| 上交所 | 32006 | 其他由于业务消息被拒绝 |     | Other due to Business Message Reject |     |

## 深交所错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| 深交所 | 20001 | 无效账户 | 账户为未开户账户 | Invalid account:unopened account |     |
| 深交所 | 20002 | 无效账户 | 账户是一个无效账户（已注销、挂失等等） | Invalid account:logged out; reported loss; etc. |     |
| 深交所 | 20003 | 无效账户 | 账户无对应业务产品的交易权限 | Invalid account:no transaction rights for the business product |     |
| 深交所 | 20005 | 业务禁止 | 证券的业务开关关闭 | Business prohibition:securities business switch off |     |
| 深交所 | 20006 | 业务禁止 | 当前阶段不允许申报该类委托 | Business prohibition:not allowed to declare this type of delegation |     |
| 深交所 | 20007 | 证券停牌 | 证券停牌，不允许该类申报委托 | Securities suspension |     |
| 深交所 | 20008 | 价格错误 | 委托价格不是价格档位的整数倍;网上发行认购价格不等于发行价;配股认购价格不等于配股价 | Wrong price |     |
| 深交所 | 20009 | 价格错误 | 委托价格超过涨跌幅限制；盘后定价大宗交易委托价格不为指定价格；转融通证券出借委托的费率与公布的不一致 | Wrong price |     |
| 深交所 | 20010 | 数量非法 | 委托数量不是数量单位的整数倍；分级基金分拆合并委托数量非配比的整数倍 | Wrong volume: Delegated quantity is not an integer multiple of quantity unit |     |
| 深交所 | 20011 | 非法数量 | 委托数量和金额都未满足最低交易门槛要求委托数量或金额超过上限;开放式基金申购未满足最低申购金额要求 | Illegal volume |     |
| 深交所 | 20012 | 业务禁止 | 对折算率为 0 的证券不允许申报质押式回购质押申报；对非 A 股证券，成交申报业务子类别必须为非受限股份转让 | Business prohibition |     |
| 深交所 | 20013 | 业务禁止 | 融资融券标的不存在或业务被禁止；申报转融通证券出借委托，证券代码和期限不在当天发布的标的范围内;证券代码不在当天发布的港股通标的范围内;证券代码不在股票质押式回购业务标的范围内 | Business prohibition |     |
| 深交所 | 20014 | 业务禁止 | 证券当天集中竞价没有成交，不能申报以成交量加权平均价交易的委托 | Business prohibition |     |
| 深交所 | 20015 | 业务禁止 | 融券卖出禁止申报市价委托 | Business prohibition:margin trading is prohibited to declare market orders |     |
| 深交所 | 20016 | 价格错误 | 融券卖出委托价格不满足提价检查要求 | Wrong price:commission price of margin selling not meet the price increase inspection requirements |     |
| 深交所 | 20017 | 无效账户 | 信用账户只能买入担保品证券 | Invalid account:credit account can only buy collateral securities |     |
| 深交所 | 20018 | 无效账户 | 非信用账户申报融资融券委托 | Invalid account:non-credit account declaration financing and securities lending commission |     |
| 深交所 | 20019 | 无效单元 | 债券分销业务中，卖委托的交易单元非承销商交易单元 | Invalid unit |     |
| 深交所 | 20020 | 无效账户 | 债券分销业务中，卖委托的证券账户非承销商证券账户或者买委托的证券账户为承销商证券账户 | Invalid account |     |
| 深交所 | 20021 | 数量超限 | 债券分销业务中，自行挂牌量超出自行挂牌总量 | Quantity exceeded |     |
| 深交所 | 20022 | 股份卖空 | 持有股份不足;质押式报价回购初始交易数量大于可用标准券数量 | Short selling |     |
| 深交所 | 20023 | 无效单元 | 委托的交易单元不存在；黄金 ETF 投资者交易单元找不到托管单元 | Invalid unit |     |
| 深交所 | 20024 | 无效单元 | 委托的交易单元无对应产品的交易权限 | Invalid unit:entrusted trading unit has no trading authority for the corresponding product |     |
| 深交所 | 20025 | 无效单元 | 委托的交易单元无对应业务的交易权限 | Invalid unit:entrusted trading unit has no trading authority for the corresponding product |     |
| 深交所 | 20026 | 无效单元 | 信用账户必须通过信用交易单元申报；非信用账户必须通过非信用交易单元申报 | Invalid unit |     |
| 深交所 | 20027 | 无效单元 | QFII 账户未从指定交易单元申报 | Invalid unit:QFII account not declared from the designated trading unit |     |
| 深交所 | 20028 | 无效单元 | 交易单元无对应产品的业务权限 | Invalid unit:trading unit has no business rights for the corresponding product |     |
| 深交所 | 20029 | 业务禁止 | 市场参与者业务资格被限制 | Business prohibition:market participant business qualifications are restricted |     |
| 深交所 | 20030 | 约定号重 | 协议交易成交申报约定号重复 | Duplicate declaration number |     |
| 深交所 | 20031 | 配对失败 | 交易双方申报要素不匹配 | Pairing failed:declared elements of the two parties of the transaction not match |     |
| 深交所 | 20032 | 配对失败 | B 股协议交易境内账户和境外账户不能成交 | Pairing failed:B-share agreement trading domestic accounts and overseas accounts not be traded |     |
| 深交所 | 20033 | 无对手方 | 协议交易点击成交申报约定号错误，未找到对应的定价申报 | No opponent |     |
| 深交所 | 20034 | 金额非法 | 委托中的金额必须为金额单位的整数倍 | Illegal amount:amount in the commission must be an integer multiple of the amount unit |     |
| 深交所 | 20035 | 申购不足 | 申购 ETF 时投资者成份股不足 | Insufficient subscription:insufficient investor stocks when purchasing ETFs |     |
| 深交所 | 20036 | 赎回不足 | 赎回 ETF 时基金公司成份股不足 | Insufficient redemption:fund companies have insufficient stocks when redeeming ETFs |     |
| 深交所 | 20037 | 现金超限 | 现金替代部分超过上限 | Cash overrun:cash replacement part exceeds the upper limit |     |
| 深交所 | 20038 | 无效账户 | 合约账户标识码与申报交易单元对应的结算账号不一致；保证金查询指令中的结算账号与交易单元不匹配或交易单元无对应结算账号 | Invalid account |     |
| 深交所 | 20039 | 重复认购 | 网上发行重复认购 | Repeat subscription:reissue subscription online |     |
| 深交所 | 20040 | 无效单元 | 非证券金融公司专用交易单元申报借入委托；证券金融公司专用交易单元申报出借委托；非金交所专用交易单元申报委托 | Invalid unit |     |
| 深交所 | 20041 | 股份卖空 | 解押业务中对应的已质押股份不足 | Short selling:corresponding pledged shares in the unsecured business are insufficient |     |
| 深交所 | 20042 | 股份卖空 | 解押业务中对应的标准券不足 | Short selling:insufficient corresponding standard coupons in the discharge |     |
| 深交所 | 20046 | 无法成交 | 市价委托不满足成交条件撤单 | Unable to deal:market price order not meet the transaction conditions to cancel the order |     |
| 深交所 | 20047 | 规模超限 | 基金累计申购或赎回总规模超限；质押式报价回购总规模超限;国际市场互联额度不可用 | Overrun |     |
| 深交所 | 20048 | 规模超限 | 单个账户基金累计申购或赎回规模超限 | Overrun:single account fund cumulative purchase or redemption scale exceeds the limit |     |
| 深交所 | 20049 | 规模超限 | 基金净申购或净赎回总规模超限 | Overrun:fund's total net purchase or net redemption exceeds the limit |     |
| 深交所 | 20050 | 规模超限 | 单个账户基金净申购或净赎回规模超限 | Overrun:single account fund net purchase or net redemption scale exceeds the limit |     |
| 深交所 | 20051 | 购回期限错误 | 回购天数超过业务限制 | Wrong buyback period:repurchase days exceeded business limit |     |
| 深交所 | 20055 | 无效会员 | 会员无对应业务的交易权限 | Invalid member:members have no transaction rights for the corresponding business |     |
| 深交所 | 20056 | 无效账户 | 非业务指定交易的证券账户 | Invalid account:securities account for non-business designated transactions |     |
| 深交所 | 20059 | 金额超限 | 当日净买入金额超出设定限额 | Amount exceeded:net purchase amount exceeds the set limit |     |
| 深交所 | 20060 | 仓位不足 | 期权构建组合申报时，成份合约单腿持仓不足; 期权解除组合时，组合策略持仓不足或申报的组合流水号对应的持仓不存在 | Insufficient positions |     |
| 深交所 | 20061 | 交易量超限 | 超过投资者交易量限额 | Trading volume exceeded |     |
| 深交所 | 20062 | 持仓超限 | 超过结算参与人持仓限额 | Position limit exceeded |     |
| 深交所 | 20063 | 持仓超限 | 超过投资者持仓限额 | Position limit exceeded |     |
| 深交所 | 20064 | 资金不足 | 结算参与人可用资金不足 | Insufficient funds:insufficient funds available for settlement participants |     |
| 深交所 | 20065 | 平台已关闭 | 平台已关闭 | Platform is closed |     |
| 深交所 | 20067 | 备兑标签错 | 备兑标签错误，只有卖开认购合约或买平认购合约时备兑标签可以为备兑 | Redemption label wrong |     |
| 深交所 | 20068 | 结算机构错 | 结算机构代码错误 | Wrong settlement institution:billing agency code error |     |
| 深交所 | 20069 | 无效账户 | 委托中的账户为结算受限账户 | Invalid account:account under entrustment is a settlement restricted account |     |
| 深交所 | 20070 | 无效账户 | 委托中的账户为不合格账户 | Invalid account:account under commission is an unqualified account |     |
| 深交所 | 20071 | OwnerType 错误 | 强平主动撤单的 OwnerType 必须与原委托的一致 | Wrong OwnerType |     |
| 深交所 | 20073 | 报价错误 | 双边报价申报的买价必须低于卖价 | Wrong quote:bid price declared by the bilateral quotation must be lower than the selling price |     |
| 深交所 | 20074 | 无效业务 | 强平委托必须是限价委托 | Invalid business:forced commission must be a limit order |     |
| 深交所 | 20075 | 报价撤销 | 报价被更新或撤销 | Quote cancellation:quote is updated or withdrawn |     |
| 深交所 | 20076 | 申报方式错误 | 竞价委托申报方式错误， TimeInForce 、OrdType、MaxPriceLevels、MinQty 字段的组合不合法 | Wrong declaration method |     |
| 深交所 | 20077 | 无报价权限 | 无做市报价权限 | No quote authority:no market making authority |     |
| 深交所 | 20078 | 交易量超限 | 超过结算参与人交易量限额 | Trading volume exceeded:settlement participant transaction limit exceeded |     |
| 深交所 | 20079 | 减持额度不足 | 受限股份减持，可用额度不足 | Insufficient holdings:restriction of restricted shares; insufficient available quota |     |
| 深交所 | 20095 | 撤单请求错误 | 主动撤单请求的 applid 或证券 id 与原委托的不一致 | Wrong cancellation request |     |
| 深交所 | 20096 | 无法撤销 | 报单无法撤销 | The order can not be cancelled |     |
| 深交所 | 20097 | 委托不存在 | 主动撤单未找到原始委托或者没有可以被撤销的报价 | Order not exist |     |
| 深交所 | 20099 | 重单  | 重单  | Repeat order |     |
| 深交所 | 20101 | 应用标识错 | 应用标识错误 | Wrong application identification |     |
| 深交所 | 20102 | 证券非法 | 证券不支持所申报的业务 | Illegal securities:not support the declared business |     |
| 深交所 | 20103 | 解包失败 | 解包失败 | Unpacking failed |     |
| 深交所 | 20104 | 平台未开放 | 平台未开放 | Platform not open |     |
| 深交所 | 20105 | 交易单元错 | 网关对交易单元无权限 | Wrong trading unit:gateway no authority over the trading unit |     |
| 深交所 | 20106 | 字段错误 | 字段取值错误 | Wrong field |     |
| 深交所 | 20107 | 消息类型非法 | 不支持的消息类型 | Illegal message type:unsupported message type |     |
| 深交所 | 20108 | 平台非法 | 委托申报的平台错误，例如向现货集中竞价平台申报发行认购业务的委托 | Illegal platform:delegated platform error |     |
| 深交所 | 20110 | 价格类型错 | 价格类型错误 | Wrong price type:wrong price type |     |
| 深交所 | 20111 | 无效单元 | 成交申报中的多方交易单元不属于同一会员 | Invalid unit:multi-party transaction unit in the transaction declaration not belong to the same member |     |
| 深交所 | 20112 | 无权限 | 网关无申报委托权限 | No permission:gateway no authority to declare delegation |     |
| 深交所 | 20113 | 服务暂停 | 资金查询服务暂停 | Service suspension:fund inquiry service suspended |     |
| 深交所 | 20114 | 临时停市拒绝 | 临时停市拒绝 | Temporary market refusal:temporary market refusal |     |
| 深交所 | 20115 | 申报方式错误 | 成 交 申 报 报 文 TradeHandlingInstr 、TradeReportTransType、TradeReportType 字段组合不合法 | Wrong bid |     |
| 深交所 | 20116 | 申报方式错误 | 成交请求发起方错误 | Wrong bid:deal request originator error |     |
| 深交所 | 20117 | 无效账户 | 证券账户无三方回购业务的正/逆回购权限 | Invalid account |     |
| 深交所 | 20118 | 篮子非法 | 三方回购申报的篮子个数超限；三方回购交易业务申报的篮子编号不在质押券篮子清单范围内 | Illegal basketPledged bonds illegal |     |
| 深交所 | 20119 | 质押券非法 | 三方回购申报质押券个数不符合业务要求 | Illegal Pledged bonds:number of pledged bonds declared by the three parties not meet the business requirements |     |
| 深交所 | 20120 | 质押券非法 | 三方回购初始交易申报的指定质押券不在申报的质押券篮子内; 三方回购补券申报的证券及换券申报的换入证券不在其对应的在途合约指定质押券篮子内 | Illegal Pledged bonds |     |
| 深交所 | 20121 | 质押券非法 | 三方回购初始交易、补券、换券（仅换入）申报的指定质押券全天停牌 | Illegal Pledged bonds |     |
| 深交所 | 20122 | 质押券非法 | 三方回购换券申报的换出证券不在其对应的在途合约质押券列表中 | Illegal Pledged bonds |     |
| 深交所 | 20123 | 无效单元 | 成交申报中的对手方交易单元不存在 | Invalid unit:counterparty trading unit in transaction declaration does not exist |     |
| 深交所 | 20124 | 回购期限错误 | 三方回购初始交易指定质押券的到期日小于合约到期日；三方回购到期续做对应在途合约质押券到期日小于续做合约到期日 | Wrong buyback period |     |
| 深交所 | 20125 | 合约不存在 | 三方回购到期购回、到期续做、提前购回、补券、换券未找到对应的在途合约 | Contract not exist |     |
| 深交所 | 20126 | 业务禁止 | 三方回购到期购回、到期续做委托对应的在途合约不是当日到期合约；三方回购提前购回、换券、补券对应的在途合约不是未到期合约 | Business prohibition |     |
| 深交所 | 20127 | 业务禁止 | 三方回购到期购回、到期续做、提前购回、补券、换券委托中交易单元、证券账户与对应在途合约中交易单元、证券账户不一致 | Business prohibition |     |
| 深交所 | 20128 | 金额非法 | 三方回购到期续做金额超过原合约金额；三方回购提前购回金额小于原合约金额；三方回购解除质押金额（场内结算）小于原合约金额 | Illegal amount |     |
| 深交所 | 20129 | 证券非法 | 三方回购入库证券不在质押券篮子清单范围内；期权构建、解除组合或行权指令合并申报时，成份合约标的证券与委托中 SecurityID 不一致 | Illegal securities |     |
| 深交所 | 20130 | 无对手方 | 成交请求模式下确认方发起的委托未找到提交方申报的委托 | No opponent |     |
| 深交所 | 20131 | 业务禁止 | 三方回购在途合约当前状态不允许申报该类别委托，比如已提前购回的合约不能再申报换券、补券委托，已对合约申报了到期购回，则不能再次申报到期购回或到期续做 | Business prohibition |     |
| 深交所 | 20132 | 业务禁止 | 期权构建组合或行权指令合并申报时，合约的标的、合约单位、到期日不符规则 | Business prohibition |     |
| 深交所 | 20133 | 业务禁止 | 成份合约已过组合自动解除日 | Business prohibition:component contract passed the combination automatic release date |     |
| 深交所 | 20134 | 业务禁止 | 合约不支持申报的策略 | Business prohibition:contract not support the declared strategy |     |
| 深交所 | 20135 | 业务禁止 | 期权构建组合或行权指令合并申报时，委托成份合约个数不符规则 | Business prohibition |     |
| 深交所 | 20136 | 数量非法 | 委托成份合约数量不符规则 | Illegal quantity:number of entrusted component contracts not comply with the rules |     |
| 深交所 | 20137 | 业务禁止 | 委托成份合约权利仓/义务仓不符规则 | Business prohibition:entrusted component contract rights warehouse/obligatory warehouse not comply with the rules |     |
| 深交所 | 20138 | 业务禁止 | 期权构建组合或行权指令合并申报时，委托成份合约认购/认沽不符规则 | Business prohibition |     |
| 深交所 | 20139 | 业务禁止 | 期权构建组合或行权指令合并申报时，委托成份合约行权价不符规则 | Business prohibition |     |
| 深交所 | 20140 | 业务禁止 | 解除组合，申报的组合流水号对应组合策略持仓的参与人信息与委托中的不一致 | Business prohibition |     |
| 深交所 | 20143 | 业务禁止 | 解除组合，申报的组合流水号对应组合策略持仓的参与人信息与委托中的不一致 | Business is forbidden |     |
| 深交所 | 20144 | 无效交易员 | 交易商未报备申报的交易员代码 | Invalid traders |     |
| 深交所 | 20145 | 无效账户 | 证券账户在交易商已报备的交易主体账户列表中不存在 | Invalid account ID |     |
| 深交所 | 20146 | 订单已超时 | 订单已超时 | Order has timed out |     |
| 深交所 | 20147 | 询价交易 ID 重复 | 询价请求 QuoteReqID、报价 QuoteID、报价回复 QuoteRespID 重复 | Request for quotation transaction ID is duplicated |     |
| 深交所 | 20149 | 无效账户 | 债券转让业务回售转售中,卖委托的证券账户非回售转售专用账户 | Invalid account ID |     |
| 深交所 | 20150 | 结算方式错误 | 结算方式错误 | Billing method is incorrect |     |
| 深交所 | 20151 | 结算周期错误 | 结算周期错误 | Billing cycle is incorrect |     |
| 深交所 | 20153 | 借贷期限错 | 债券借贷初始交易、到期续做标的券的到期日小于合约的到期日 | Loan term is wrong |     |
| 深交所 | 20154 | 借贷费用 场内支付金额错 | 借贷费用场内支付金额大于借贷费用金额 | Amount of loan fee paid on spot is wrong |     |
| 深交所 | 20155 | 申报宽限期错 | 申报宽限期不符合规则 | Declaration grace period error |     |
| 深交所 | 20156 | 业务禁止 | 标的券非法 | Business is forbidden |     |
| 深交所 | 20157 | 业务禁止 | 换出质押券不足 | Business is forbidden |     |
| 深交所 | 20158 | 业务禁止 | 债券借贷在途合约不允许申报解除质押 | Business is forbidden |     |
| 深交所 | 20159 | 标的券非法 | 债券借贷初始交易、到期续做的标的券不在允许的标的券范围内；债券借贷提前终止、到期结算已摘牌标的证券不能指定数量 | Underlying coupon is illegal |     |
| 深交所 | 20160 | 标的券非法 | 债券借贷初始交易、到期续做的标的券全天停牌 | Underlying coupon is illegal |     |
| 深交所 | 20161 | 券面总额非法 | 标的证券券面总额不符合规则 | Total value of coupon is illegal |     |
| 深交所 | 20162 | 券面总额非法 | 质押券券面总额不符合规则 | Total value of coupon is illegal |     |
| 深交所 | 20164 | 竞买日期错误 | 竞买预约日期超过业务限制 | Bidding date is incorrect |     |
| 深交所 | 20165 | 重复申报 | 同一证券账户在同一个竞买日对于同一证券代码存在多笔有效竞买预约申报； | Duplicate declarations |     |
| 深交所 | 20166 | 无法成交 | 竞买发起或应价申报不满足成交条件 | Cannot be filled |     |
| 深交所 | 20167 | 证券临时停牌 | 证券发生过临时停牌 | Trading in securities is temporarily suspended |     |
| 深交所 | 20168 | 竞买不存在 | 竞买发起申报找不到对应的有效竞买预约申报；竞买应价申报找不到对应的有效竞买发起申报 | Bidding does not exist |     |
| 深交所 | 20169 | 价格错误 | 单一主体竞买应价申报委托价格低于或等于当前委托簿中应价申报的委托价格 | Price error |     |
| 深交所 | 20170 | 竞买预约已生效 | 竞买预约已申报了竞买发起 | Bidding pre-order is now in effect |     |
| 深交所 | 20172 | 响应方方 交易商错 | 响应方交易商未报备接收转发消息的交易单元 | Responder Dealer Error |     |
| 深交所 | 20173 | 业务禁止 | 合并申报发起方无权限 | Business is forbidden |     |
| 深交所 | 20174 | 原成交不存在 | 交易解除时找不到待解除的成交 | Original deal does not exist |     |
| 深交所 | 20175 | 原成交状态错 | 待解除成交的状态当前已发起交易解除请求或已解除交易 | Original transaction status is wrong |     |
| 深交所 | 20176 | 成交要素 匹配失败 | 交易解除委托要素与待解除成交的成交要素不匹配 | Transaction Elements Failed to match |     |
| 深交所 | 20177 | 港股通限制交易 | 标的属于港股通限制交易证券清单 | Trading restrictions in Hong Kong Stock Connect |     |
| 深交所 | 20178 | 业务禁止 | 本方不支持此申报 | Business is forbidden |     |
| 深交所 | 20179 | 业务禁止 | 对手方不支持此申报 | Business is forbidden |     |
| 深交所 | 20180 | 无效会员 | 会员无对应产品的业务权限 | Invalid Membership |     |
| 深交所 | 20201 | 议案代码错 | 议案号和子议案号错误 | Motion code is wrong |     |
| 深交所 | 20202 | 表决意见错 | 投票意向错误；投票数量应为大于等于 0 的整数 | Vote wrong |     |
| 深交所 | 29995 | 市场互联拒绝 | 港股通撤单请求被联交所拒绝，具体拒绝原因代码见 RejectText | Market interconnection rejection:Hong Kong Stock Connect's withdrawal request rejected by the Stock Exchange |     |
| 深交所 | 29996 | 市场互联拒绝 | 港股通委托被联交所自动撤销，具体撤销原因代码见RejectText，撤销原因说明见IMCRejectText | Market interconnection rejection:Hong Kong Stock Connect entrustment revoked by the Stock Exchange |     |
| 深交所 |     |     |     |     |     |
| 深交所 | 29997 | 市场互联拒绝 | 港股通委托被联交所拒绝，具体拒绝原因代码见RejectText，拒绝原因说明见IMCRejectText | Market interconnection rejection:Hong Kong Stock Connect commission rejected by the Stock Exchange |     |
| 深交所 |     |     |     |     |     |
| 深交所 | 29998 | 市场互联拒绝 | 港股通委托被联交所拒绝，具体拒绝原因代码见RejectText，拒绝原因说明见IMCRejectText | Market interconnection rejection:Hong Kong Stock Connect commission rejected by the Stock Exchange |     |
| 深交所 |     |     |     |     |     |
| 深交所 | 29999 | 其他错误 |     | Other errors |     |
| 深交所 | 55002 | 数据未填写 |     | Empty filled information |     |
| 深交所 | 55003 | 上次查询未结束 |     | Last query did not end |     |
| 深交所 | 55004 | 上交柜台连接失败 |     | SS counter connect fail |     |
| 深交所 | 55005 | 口令错误 |     | Wrong password |     |
| 深交所 | 55007 | 用户已登录 |     | User already logined |     |
| 深交所 | 55014 | 用户尚未登录 |     | User not login |     |
| 深交所 | 55015 | 系统内存不足 |     | System Memory Not Enough |     |
| 深交所 | 55016 | 错误的资金账号 |     | Wrong AccountID |     |
| 深交所 | 55021 | 不合法的密码 |     | Illegal password |     |
| 深交所 | 55031 | 错误的授权码 |     | Wrong AuthCode |     |
| 深交所 | 55033 | 登录子客户端索引错误 |     | Login sub client index wrong |     |
| 深交所 | 55037 | 资金账号不存在 |     | AccountID not exist |     |
| 深交所 | 55038 | token错误 |     | Wrong token |     |
| 深交所 | 55039 | 报单序号不是连续增加 |     | The order number not increases monotonically |     |
| 深交所 | 55040 | 被撤单找不到 |     | Cancelled order not found |     |
| 深交所 | 55041 | 内部进程间消息发送失败 |     | Interactive msg send failed |     |
| 深交所 | 55042 | STEP 信息编码失败 |     | STEP message encoded failed |     |
| 深交所 | 55043 | 插入数据库失败 |     | Failed to insert into database |     |
| 深交所 | 55044 | 重复登录 |     | Duplicate login |     |
| 深交所 | 55045 | 柜台导上场数据初始化未完成 |     | Initialization of settlement data not completed |     |
| 深交所 | 55046 | 查询过快 |     | Query too fast |     |
| 深交所 | 55047 | 无相关记录 |     | No relevant records |     |
| 深交所 | 55048 | 登录超时 |     | Login timeout |     |
| 深交所 | 55049 | 该用户已经在其他链路登录 |     | User has logged in on another link |     |
| 深交所 | 55050 | api版本错误 |     | Wrong API version |     |
| 深交所 | 55052 | 接口未开启 |     | Interface not open |     |
| 深交所 | 55053 | 错误的时间格式 |     | Wrong time format |     |
| 深交所 | 55054 | 号段用尽或未配置号段 |     | Number segment run out or not configured |     |
| 深交所 | 55055 | 集中交易操作失败 |     | Central trading operation failed |     |
| 深交所 | 55056 | 用户登录ip检查失败 |     | User login ip check failed |     |
| 深交所 | 55057 | 用户登录mac地址检查失败 |     | User login mac address check failed |     |
| 深交所 | 55058 | 转移失败 |     | Failed to transfer |     |
| 深交所 | 55059 | 集中交易授权失败 |     | Central trading authentication failed |     |
| 深交所 | 55060 | 连接headquarter错误 |     | failed to connect to headquarter |     |
| 深交所 | 55061 | 资金不能小于等于零 |     | Capital cannot be less than or equal to zero |     |
| 深交所 | 55062 | 系统id错误 |     | Wrong system_id |     |
| 深交所 | 55063 | 登录太快 |     | Login too fast |     |
| 深交所 | 55064 | 仓位检查错误 |     | Position check failed |     |
| 深交所 | 55065 | 组合策略类型错误 |     | Wrong comb strategy type |     |
| 深交所 | 55067 | Zmq通信错误 |     | zmq failed |     |
| 深交所 | 55068 | 已经有其他帐户登录到当前链接 |     | Another account has already logged in this link |     |
| 深交所 | 55069 | 发送到交易所失败 |     | Send to Exchange Failed |     |
| 深交所 | 55070 | 号码范围已用完 |     | Number range is exhausted |     |
| 深交所 | 55071 | 柜台正在数据恢复，等待完成 |     | XeleTrade is recoverying, wait to be finished... |     |
| 深交所 | 55072 | 取消其他账户订单 |     | Cancel other account order |     |
| 深交所 | 55073 | 重建失败 |     | Rebuild Failed |     |
| 深交所 | 55074 | Xele-Bot登录超时 |     | Xele-Bot login timeout |     |
| 深交所 | 55075 | TransfereePbuID为空 |     | TransfereePbuID is null |     |
| 深交所 | 55076 | 号段结束值为空 |     | Number range end is null |     |
| 深交所 | 55077 | 转托管号段结束值为空 |     | Number range redeposite_end is null |     |
| 深交所 | 55078 | 没有配置非交易tgw通道 |     | Do not have non-trade tgw session |     |
| 深交所 | 55079 | ClOrdID超过号段范围 |     | ClOrdID large than number range |     |
| 深交所 | 55080 | Order_sys_id长度错误 |     | Order_sys_id length error |     |
| 深交所 | 55081 | 订单发送错误 |     | DropOrder send err |     |
| 深交所 | 55082 | 在转托管表中未找到clordid |     | Do not find clOrdID in table redeposite |     |
| 深交所 | 55083 | 非交易链路未登录 |     | Do not logon non-trade link |     |
| 深交所 | 55084 | 强制撤单（正报单没发往交易所，被强制撤单） |     | Forced cancellation |     |
| 深交所 | 55085 | Operway检查失败 |     | Operway check fail |     |
| 深交所 | 55086 | Api监管信息检测失败 |     | Api supervise information check fail |     |
| 深交所 | 55087 | 资金过大 |     | Capital is too large |     |
| 深交所 | 55088 | Api自动重连校验失败 |     | Api reconnect TradingDay compare failed |     |
| 深交所 | 55089 | 交易日尚未从柜台同步 |     | Tradingday not sync from trade yet |     |
| 深交所 | 55090 | 合约未找到 |     | Contract not found |     |
| 深交所 | 55091 | 持仓划拨失败 |     | Api position transfer failed |     |
| 深交所 | 55092 | 软件报单速率过快 |     | Soft order too fast |     |
| 深交所 | 55093 | 查询链路地址为空 |     | query url is empty |     |
| 深交所 | 55094 | 输入的数量小于0 |     | volume is less than zero |     |
| 深交所 | 55095 | 风控类别错误 |     | risk control type error |     |
| 深交所 | 55096 | 报单发送到交易所失败 |     | order send to exchange fail |     |
| 深交所 | 55097 | 交易网关连接断开 |     | Trading gateWay disconnected |     |
| 深交所 | 55098 | 交易所已关闭 |     | Exchange closed |     |
| 深交所 | 55099 | 无效证券代码 |     | Invalid SecurityID |     |
| 深交所 | 55100 | 可备兑锁定持仓不足 |     | Insufficient available cover lock positions |     |
| 深交所 | 55101 | 备兑锁定持仓不足 |     | Insufficient cover lock positions |     |
| 深交所 | 55102 | 柜台未初始化完成 |     | Counter not initialized completed |     |
| 深交所 | 55103 | InOutDirection无效 |     | Invalid InOutDirection |     |
| 深交所 | 55104 | Volume无效 |     | Invalid Volume |     |
| 深交所 | 55105 | 发送给manager失败 |     | Send msg to manager failed |     |
| 深交所 | 55106 | 等待消息超时 |     | Wait rsp msg timeout |     |
| 深交所 | 55107 | 文件锁操作失败 |     | fileLock operate fail |     |
| 深交所 | 55108 | 检查当前资金失败 |     | check current fund fail |     |
| 深交所 | 55109 | 从fpga获取历史资金错误 |     | read old fund from fpga fail |     |
| 深交所 | 55110 | 设置新的资金到fpga错误 |     | set new fund to fpga fail |     |
| 深交所 | 55111 | 集中交易返回超时 |     | Central trading response timeout |     |
| 深交所 | 55112 | 申赎超时 |     | Creation or redemption time error. |     |
| 深交所 | 55113 | 上交柜台连接失败 |     | SS counter connect fail |     |
| 深交所 | 55114 | 深交柜台连接失败 |     | SZ counter connect fail |     |
| 深交所 | 60000 | 正确  |     | OK  |     |
| 深交所 | 60001 | 该合约限制买入 |     | Contract restricts buy |     |
| 深交所 | 60002 | 该合约限制卖出 |     | Contract restricts sell |     |
| 深交所 | 60003 | 该合约限制卖空 |     | Contract restricts short selling |     |
| 深交所 | 60004 | 不支持 |     | Not support |     |
| 深交所 | 60005 | 不允许跨市扫货单 |     | Cross market scanning not allowed |     |
| 深交所 | 60006 | 不允许市价单 |     | Market orders not allowed |     |
| 深交所 | 60007 | 价格超出范围 |     | Price out of range |     |
| 深交所 | 60008 | 单笔手数超过ADV限制 |     | Volume exceeds adv limit |     |
| 深交所 | 60009 | 报价最小值错误 |     | Quotation minimum error |     |
| 深交所 | 60010 | 单笔交易额过小 |     | Single transaction volume too small |     |
| 深交所 | 60011 | 单笔交易额过大 |     | Single transaction volume too large |     |
| 深交所 | 60012 | 单笔手数过小 |     | Too small Volume |     |
| 深交所 | 60013 | 单笔手数过大 |     | Too large Volume |     |
| 深交所 | 60014 | 当日用户报单ID重复 |     | Client order id Duplicate |     |
| 深交所 | 60015 | 没找到合约 |     | Contract not found |     |
| 深交所 | 60016 | 不合法的有效期类型 |     | Illegal validity type |     |
| 深交所 | 60017 | XeleTrade停止交易 |     | System stopped trading |     |
| 深交所 | 60018 | XeleTrade限制交易 |     | System restricts to trade |     |
| 深交所 | 60019 | 当日累计交易额过大 |     | Accumulated trading volume of the day too large |     |
| 深交所 | 60020 | 没有贷款经纪人标识 |     | No loan broker logo |     |
| 深交所 | 60021 | 报单速率过快 |     | Order too fast |     |
| 深交所 | 60022 | 报单表地址冲突 |     | Order address conflict |     |
| 深交所 | 60023 | 不合法的报单类型 |     | Illegal Order Type |     |
| 深交所 | 60024 | 不合法的报单方向 |     | Illegal order direction |     |
| 深交所 | 60025 | 不允许IPO交易 |     | IPO transaction not allowed |     |
| 深交所 | 60026 | 未成交单过多 |     | Unsettled orders too many |     |
| 深交所 | 60027 | 业务范围不正确 |     | Incorrect business scope |     |
| 深交所 | 60028 | 不允许有担保单的卖空 |     | Short selling with guarantee not allowed |     |
| 深交所 | 60029 | 不正确的最小价格变化值 |     | Wrong minimum price unit |     |
| 深交所 | 60030 | 不正确的最小手数单位 |     | Wrong minimum lot unit |     |
| 深交所 | 60031 | 报单不匹配或者报单表已满 |     | Order not match or Order full |     |
| 深交所 | 60032 | 缺失字段 |     | Missing field |     |
| 深交所 | 60033 | 超时(合约表不存在) |     | System timeout |     |
| 深交所 | 60034 | 字段错误 |     | Field error |     |
| 深交所 | 60035 | 改单时不允许增加，只能减少 |     | Change order to increase not allow,to decrease allowed |     |
| 深交所 | 60036 | 该机构不允许买入 |     | Agency to buy not allowed |     |
| 深交所 | 60037 | 该机构不允许卖出 |     | Agency to sell not allowed |     |
| 深交所 | 60038 | 该机构不允许卖空 |     | Agency to short selling not allowed |     |
| 深交所 | 60039 | 不允许自营买 |     | Self buy not allowed |     |
| 深交所 | 60040 | 不允许自营卖 |     | Self sell not allowed |     |
| 深交所 | 60041 | 不允许自营卖空 |     | Self short selling not allowed |     |
| 深交所 | 60042 | 完全不允许买 |     | Restrict to buy |     |
| 深交所 | 60043 | 完全不允许卖 |     | Restrict to sell |     |
| 深交所 | 60044 | 不允许卖空 |     | Short sellling not allowed |     |
| 深交所 | 60045 | 当天买入方向累计超额 |     | Buy direction accumulated excess |     |
| 深交所 | 60046 | 当天卖出方向累计超额 |     | Sell direction accumulated excess |     |
| 深交所 | 60047 | 卖出超出持仓 |     | Sell exceeds position |     |
| 深交所 | 60048 | 卖空超出借入 |     | Short selling exceeds borrowing |     |
| 深交所 | 60049 | 未应答报单 |     | Unanswered order |     |
| 深交所 | 60050 | SAMSN拒单 |     | SAMSN refused |     |
| 深交所 | 60051 | VENUE繁忙 |     | VENUE busy |     |
| 深交所 | 60052 | 该合约未成交买单超出上限 |     | Contract unsettled and buy order exceeds the upper limit |     |
| 深交所 | 60053 | 该合约未成交卖单超出上限 |     | Contract unsettled and sell order exceeds the upper limit |     |
| 深交所 | 60054 | 改单的合约不匹配 |     | Modified contract not match |     |
| 深交所 | 60055 | 该报单不存在 |     | Order not exist |     |
| 深交所 | 60056 | 报单查找表搜索超时 |     | Order search timeout |     |
| 深交所 | 60057 | 资金账户变化 |     | Change of capital account |     |
| 深交所 | 60058 | 数量错误 |     | Quantity error |     |
| 深交所 | 60059 | 该合约持仓过多 |     | Contract positions too large |     |
| 深交所 | 60060 | 该合约多头持仓过多 |     | Holding long position of the contract too large |     |
| 深交所 | 60061 | 该合约空头持仓过多 |     | Holding short position of the contract too large |     |
| 深交所 | 60063 | 可卖数量不足 |     | Sellable quantity not enough |     |
| 深交所 | 60064 | 可用资金量小于该笔报单保证金 |     | Account balance less than margin of the order |     |
| 深交所 | 60065 | 保证金占可用资金百分比过高 |     | Ratio of margin occupying capital too large |     |
| 深交所 | 60066 | 当天该合约撤单次数超限，不允许撤单 |     | Cancel order not allowed |     |
| 深交所 | 60067 | 客户报单ID与登录ID不一致 |     | Customer order ID and login ID Inconsistent |     |
| 深交所 | 60068 | 报单价格格式错误 |     | Wrong format of order price |     |
| 深交所 | 60069 | 报单价格条件字段不在枚举范围之内 |     | Order price conditions field not in the range of enumeration |     |
| 深交所 | 60070 | 报单买卖方向条件字段不在枚举范围之内 |     | Condition of buy and sell direction field not in the range of enumeration |     |
| 深交所 | 60071 | 报单开平字段不在枚举范围之内 |     | Order field not in the range of enumeration |     |
| 深交所 | 60072 | 报单投机套保标志字段不在枚举范围之内 |     | Order speculative hedging mark field not in the range of enumeration |     |
| 深交所 | 60073 | 报单有效期类型字段不在枚举范围之内 |     | Order period of validity type field not in the range of enumeration |     |
| 深交所 | 60074 | 报单操作标志字段不在枚举范围之内 |     | Order operation flag field not in the range of enumeration |     |
| 深交所 | 60075 | 交易所端在途订单过多，限制报单 |     | Number of order on the way too large |     |
| 深交所 | 60076 | xele_trade系统高负载，报单过多，限制报单 |     | System overload:qdr full |     |
| 深交所 | 60077 | xele_trade系统高负载，持仓过多，限制报单 |     | System overload:ddr full |     |
| 深交所 | 60078 | 报单投机套保标志与客户交易类型不一致 |     | Order speculative hedging mark inconsistent with customer transaction type |     |
| 深交所 | 60079 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所 | 60080 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所 | 60081 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所 | 60082 | 客户端未登录 |     | Client not logged in |     |
| 深交所 | 60083 | 报单已撤，不能再次撤销 |     | Duplicate cancel |     |
| 深交所 | 60084 | 拒绝自成交报单 |     | Self closing order refused |     |
| 深交所 | 60085 | xele-monitor强平单不能被用户通过API撤掉 |     | Forced Liquidation order cannot be cancelled by API |     |
| 深交所 | 60086 | 报单已经被撤掉了 |     | Order has been withdrawn |     |
| 深交所 | 60087 | 订单超限 |     | Order exceeding limit |     |
| 深交所 | 60088 | 合约格式错误 |     | Contract format error |     |
| 深交所 | 60089 | 成交量类型不在枚举范围内 |     | Transaction type not in the range of enumeration |     |
| 深交所 | 60090 | 触发条件不在枚举范围内 |     | Trigger conditions not in the range of enumeration |     |
| 深交所 | 60091 | 强平原因不在枚举范围内 |     | Reasons for Liquidation order not in the range of enumeration |     |
| 深交所 | 60092 | 报单手数小于最小成交量手数 |     | Orders lot less than the minimum lot of transactions |     |
| 深交所 | 60093 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所 | 60094 | 交易所前置未准备 |     | Exchange front not ready |     |
| 深交所 | 60095 | 前置错误 |     | Exchange front error |     |
| 深交所 | 60096 | 不允许开仓 |     | Open position disallowed |     |
| 深交所 | 60097 | 不允许期货FOK报单 |     | Futures FOK order not allowed |     |
| 深交所 | 60098 | IAS格式错误 |     | IAS format error |     |
| 深交所 | 60099 | 交割月禁止开仓 |     | Open position in delivery month disallowed |     |
| 深交所 | 60100 | 未登录不允许交易 |     | Trading not allowed without login |     |
| 深交所 | 60101 | 系统负载过高 |     | System overload |     |
| 深交所 | 60102 | 限额达到最大值 |     | Total bought amount reach the limit |     |
| 深交所 | 60103 | 权利仓已达上限 |     | Total bought underlying position reach the limit |     |
| 深交所 | 60104 | 当日权利仓已达上限 |     | Total today bought underlying position reach the limit |     |
| 深交所 | 60105 | 总持仓已达上限 |     | Total underlying position reach the limit |     |
| 深交所 | 60106 | 禁止自成交 |     | Self trade is forbidden |     |
| 深交所 | 60107 | 触发价格偏离度风控 |     | Trigger price deviation risk |     |
| 深交所 | 60108 | 今天限卖 |     | Today sell limit |     |
| 深交所 | 60109 | 不允许撤单 |     | Order not allowed withdraw |     |
| 深交所 | 60110 | 新股配股报单只允许一次 |     | Order insert only one time |     |
| 深交所 | 60111 | 合约类型错误 |     | SecurityType wrong |     |
| 深交所 | 60116 | 软件交易网关不可用 |     | Software trading gateway is unavailable |     |
| 深交所 | 60200 | 报文identification字段错误 |     | Wrong identification field |     |
| 深交所 | 60201 | message_id不再范围内 |     | Message_id not in range |     |
| 深交所 | 60202 | message_len错误 |     | Wrong message_len |     |
| 深交所 | 60203 | 用户报单id小于maxorderid或超出范围 |     | OrderID less than maxorderid or out of range |     |
| 深交所 | 60204 | 报单方向错误 |     | Wrong Direction |     |
| 深交所 | 60205 | positioneffect不在范围内 |     | Positioneffect not in range |     |
| 深交所 | 60206 | 价格超出范围 |     | Price out of system limit |     |
| 深交所 | 60207 | 报单类型错误 |     | Wrong OrderType |     |
| 深交所 | 60208 | 时间条件错误 |     | Wrong TimeCondition |     |
| 深交所 | 60209 | udp 校验错误 |     | Wrong UDP check |     |
| 深交所 | 60210 | 用户token错误 |     | Wrong User token |     |
| 深交所 | 60211 | 用户未登录 |     | User not login |     |
| 深交所 | 60212 | web报单不允许api撤单 |     | Web order not allow api to cancel the order |     |
| 深交所 | 60213 | 报单价格不能大于10000 |     | Order price cannot be greater than 10000 |     |
| 深交所 | 60214 | 号段前缀错误 |     | Order Id prefix err |     |
| 深交所 | 60215 | 号段Id错误 |     | Order Id number err |     |
| 深交所 | 60216 | TCP通道错误 |     | Tcp Session Error |     |
| 深交所 | 60217 | UserLocalId字段值超过限制，大于2176782335 |     | UserLocalId too large, more than 2176782335 |     |
| 深交所 | 60218 | 被撤SysID超过号段范围 |     | OrigSysID is out of number range |     |
| 深交所 | 60219 | 不能使用OrigUserLocalId字段撤单 |     | Can't Cancel Order by OrigUserLocalId |     |
| 深交所 | 60220 | 报单资源已用尽 |     | Order resource is exhausted |     |
| 深交所 | 60221 | 订单价格不能小于0 |     | Order Price cannot be less than 0 |     |
| 深交所 | 60240 | 触发频繁瞬时撤单风控 |     | Trigger frequent instant order cancellations risk |     |
| 深交所 | 60241 | 触发报撤速率限制风控 |     | Trigger order cancellation rate limit risk |     |
| 深交所 | 60242 | 触发全天报撤笔数限制风控 |     | Trigger daily limit on the number of order cancellations risk |     |

## 上交期权错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| 上交所期权 | 257 | 交易员申报的reqNum序号不连续 |     | Discontinuous reqNum |     |
| 上交所期权 | 507 | 后台应用错误 |     | Wrong background application |     |
| 上交所期权 | 508 | 后台架构错误 |     | Wrong background architecture |     |
| 上交所期权 | 1014 | PBU登录失败 |     | PBU login failed |     |
| 上交所期权 | 1103 | 无法解析订单 |     | Unable to parse order |     |
| 上交所期权 | 3000 | 连接数据库失败 |     | Connect to the database failed |     |
| 上交所期权 | 3001 | 数据库记录的交易日期不正确 |     | Wrong trading date recorded in the database |     |
| 上交所期权 | 3002 | truncate数据库记录失败 |     | Truncate database record failed |     |
| 上交所期权 | 4004 | 连接主机失败 ，其他错误 |     | Connect to host failed, other errors |     |
| 上交所期权 | 4005 | IP绑定失败 |     | Bind IP failed |     |
| 上交所期权 | 4006 | 连接主机超时 |     | Connect to host timeout |     |
| 上交所期权 | 4007 | 连接主机失败 ，底层I/O未知错误 |     | Connect to host failed, underlying I/O unspecified error |     |
| 上交所期权 | 4008 | 交易员登录失败 |     | Trader login failed |     |
| 上交所期权 | 4009 | 获取交易时间表失败 |     | Obtain trading schedule failed |     |
| 上交所期权 | 4010 | 参考数据中isix格式错误 |     | Wrong isix format in reference data |     |
| 上交所期权 | 4011 | 参考数据中rid格式错误 |     | Wrong rid format in reference data |     |
| 上交所期权 | 4012 | 产品代码SecurityID错误或者业务类型ReqID错误 |     | Wrong isin code SecurityID or wrong business type ReqID |     |
| 上交所期权 | 4500 | 股票代码securityid字段格式错误 |     | Wrong SecurityID format |     |
| 上交所期权 | 4501 | 订单状态ordstatus非法 |     | Illegal OrderStatus |     |
| 上交所期权 | 4502 | TimeStamp取值不正确,非当前交易日 |     | Wrong TimeStamp |     |
| 上交所期权 | 4601 | 没有找到对手方指令 |     | Counterpart instruction not found |     |
| 上交所期权 | 4602 | 找到对手方指令，指令细节不一致 |     | Opponent's instruction found but instruction details inconsistent |     |
| 上交所期权 | 10000 | 未知错误 |     | Unspecified error |     |
| 上交所期权 | 10002 | 找不到用户 |     | User not found |     |
| 上交所期权 | 10004 | 与原有密码不同 |     | Invalid password |     |
| 上交所期权 | 10006 | 请求已经被处理 |     | Request has been processed |     |
| 上交所期权 | 10008 | CN - 请确认它 |     | Please confirm it |     |
| 上交所期权 | 10018 | 无效的市场类型 |     | Invalid market type |     |
| 上交所期权 | 10030 | 无效的基础产品 |     | Invalid underlying instrument |     |
| 上交所期权 | 10038 | 无效的价格 |     | Invalid price |     |
| 上交所期权 | 10100 | 无效的产品子类型 |     | Invalid instrument subtype |     |
| 上交所期权 | 10132 | 产品数据不一致 |     | Inconsistent instrument data |     |
| 上交所期权 | 10150 | 未找到记录 |     | Record not found |     |
| 上交所期权 | 10208 | 总数量无效 |     | Invalid total quantity |     |
| 上交所期权 | 10236 | 非法时间戳 |     | Invalid time stamp |     |
| 上交所期权 | 10244 | 错误订单有效期 |     | Invalid expiry date |     |
| 上交所期权 | 10248 | 无法读取该产品 |     | Instrument not available |     |
| 上交所期权 | 10250 | 无效交易事务代码 |     | Invalid transaction code |     |
| 上交所期权 | 10262 | 无效订单类型 |     | Invalid order type |     |
| 上交所期权 | 10270 | 无效PBU的PBU代码 |     | PBU does not exist |     |
| 上交所期权 | 10276 | 无效报价价格或数量 |     | Invalid quote price or quantity |     |
| 上交所期权 | 10292 | 无效的日期输入 |     | Invalid calendar date |     |
| 上交所期权 | 10294 | 无效的日期参数 |     | Invalid calendar parameter |     |
| 上交所期权 | 10298 | 无效的产品关联数据标识或交易员不存在 |     | Invalid instrument assignment or trader not found |     |
| 上交所期权 | 10302 | 产品或特许权限不关联到当前子组 |     | Instrument or license is not assigned |     |
| 上交所期权 | 10304 | 资源信息找不到 |     | Resource information is not found |     |
| 上交所期权 | 10410 | 已超过交易结束时段的开始时间 |     | End-trading already started |     |
| 上交所期权 | 10412 | 无效的产品状态 |     | Invalid instrument state |     |
| 上交所期权 | 10444 | 订单数量小于最低订单数量要求 |     | Order quantity is less than minimum order quantity |     |
| 上交所期权 | 10450 | 订单价格超出范围 |     | Order price exceeds range |     |
| 上交所期权 | 10534 | 无效的PBU ID |     | Invalid PBU |     |
| 上交所期权 | 10566 | 交易时段未定义 |     | Trading schedule not defined |     |
| 上交所期权 | 10594 | 无效的交易时间表 |     | Invalid trading schedule |     |
| 上交所期权 | 10604 | 未找到报价 |     | Quote is not found |     |
| 上交所期权 | 10610 | 找不到指定的订单 |     | Order can't be found |     |
| 上交所期权 | 10622 | 无效的竞价匹配算法 |     | Invalid auction match algorithm |     |
| 上交所期权 | 10626 | 错误的营业部号码 |     | Invalid branch ID |     |
| 上交所期权 | 10646 | 无查询结果 |     | No record found |     |
| 上交所期权 | 10702 | 投资者帐户与PBU无指定交易关系 |     | Investor account not designated to the PBU |     |
| 上交所期权 | 10706 | 投资者帐户已被暂停 |     | Investor account is suspended |     |
| 上交所期权 | 10712 | 无效投资者帐户 |     | Invalid investor account ID |     |
| 上交所期权 | 10740 | 该订单申报的业务已结束 |     | CLOSE has already finished |     |
| 上交所期权 | 10748 | 产品不匹配 |     | Instrument does not match |     |
| 上交所期权 | 10756 | 无目标地址 |     | No destination to route |     |
| 上交所期权 | 10794 | 投资者账户不存在 |     | Investor not exist |     |
| 上交所期权 | 10802 | 无效标志位 |     | Invalid flag |     |
| 上交所期权 | 10828 | 无效更新持仓数量 |     | Invalid update holding quantity |     |
| 上交所期权 | 10836 | 投资者持仓不足 |     | Investor holdings not enough |     |
| 上交所期权 | 10852 | 无效的交易状态 |     | Invalid transaction status |     |
| 上交所期权 | 10868 | 重复的记录 |     | Duplicated record |     |
| 上交所期权 | 10902 | 不支持的交易类型 |     | Transaction type is not support |     |
| 上交所期权 | 10948 | 外部系统使用的PBUID没有配置 |     | The PBU for external system (EAI) not configured |     |
| 上交所期权 | 10956 | PBU已经被暂停 |     | The PBU has been suspended |     |
| 上交所期权 | 10958 | 无效合约到期月份 |     | Invalid expire month |     |
| 上交所期权 | 10970 | 更新持仓时所需保证金不足 |     | Margin is not enough when updating holding |     |
| 上交所期权 | 11026 | 无效的投资者类型. |     | Invalid investor account type code |     |
| 上交所期权 | 11050 | 投资者持仓状态不存在 |     | Investor holding position does not exist |     |
| 上交所期权 | 11058 | ETF定义未找到 |     | ETF definition not found |     |
| 上交所期权 | 11098 | 无效的最大订单数量 |     | Invalid max order quantity |     |
| 上交所期权 | 11148 | 无效的检验日期 |     | Invalid validation date |     |
| 上交所期权 | 11200 | 内存订单簿耗光 |     | The memory order book slots have been exhaused |     |
| 上交所期权 | 11204 | 正在计算闭市价格… |     | Closing price calculation is in progress |     |
| 上交所期权 | 11210 | 无效的融券标志 |     | Invalid securities borrowing indicator |     |
| 上交所期权 | 11226 | 没有对应的证券公司融券专用帐户 |     | No related PBU security borrowing account |     |
| 上交所期权 | 11228 | 无效的信用标签 |     | Invalid credit tag |     |
| 上交所期权 | 11230 | 投资者非交易持仓不足 |     | Investor NTS holdings not enough |     |
| 上交所期权 | 11240 | 开盘集合竞价最后五分钟不允许删除订单 |     | can not delete order in last 5 minutes of the open call auction |     |
| 上交所期权 | 11246 | 交易时间未到 |     | Trading phase is not ready for trade |     |
| 上交所期权 | 11270 | 订单重传 |     | Resubmit order |     |
| 上交所期权 | 11278 | 无效的广播重传请求序号区间 |     | Invalid broadcast retransmission request range |     |
| 上交所期权 | 11284 | 不能在未开始的集合竞价中插入紧急停牌 |     | Can not insert emergency instrument suspension into future CALL |     |
| 上交所期权 | 12016 | 后台无法提供服务 |     | Back-end service is not available |     |
| 上交所期权 | 12018 | ETF定义文件检查错误 |     | ETF definition file check fail |     |
| 上交所期权 | 12032 | 最优五档及时成交剩余撤销市价订单对手方无未成交订单 |     | Invalid Market Order |     |
| 上交所期权 | 12034 | 最优五档及时成交剩余转限价市价订单对手方和本方均无未成交订单 |     | Invalid Market_to_Limit Order |     |
| 上交所期权 | 12036 | 限价即时全部成交类型订单可成交对手方不足 |     | Invalid Limit_FOK Order |     |
| 上交所期权 | 12038 | 市价即时全部成交类型订单可成交对手方不足 |     | Invalid Market_FOK Order |     |
| 上交所期权 | 13300 | 繁忙  |     | Busy |     |
| 上交所期权 | 13304 | 产品未到上市日 |     | Instrument has not reach to list date |     |
| 上交所期权 | 13306 | 后台弹回请求 |     | The back end bounced back the request |     |
| 上交所期权 | 13312 | CS弹回请求 |     | The CS bounced back the request |     |
| 上交所期权 | 13330 | 无效的基本订单类型 |     | Invalid basic order type |     |
| 上交所期权 | 13332 | 无效的订单类型和限价组合 |     | Invalid combination of order type and limit |     |
| 上交所期权 | 13374 | 无法登录，操作员处于不活跃状态 |     | Can not login, the operator is inactive |     |
| 上交所期权 | 13382 | EZOES参考数据为空 |     | EZ refdatais empty |     |
| 上交所期权 | 13384 | 不允许参加开盘集合竞价 |     | Open auction deny |     |
| 上交所期权 | 13394 | 用户IP不在IP白名单内 |     | The user's ip of Front End is not in the IP white list |     |
| 上交所期权 | 13404 | 禁止冰山订单交易 |     | Forbit iceberg order |     |
| 上交所期权 | 13424 | 超过集合竞价最大订单配置量 |     | Exceed Max order count in Auction |     |
| 上交所期权 | 13426 | 此订单根本没有输入过 |     | Order has not been entered |     |
| 上交所期权 | 13428 | 此订单输入过 |     | Order has been entered but invalid |     |
| 上交所期权 | 13430 | 此订单输入过 |     | Order has been entered but matched or deleted |     |
| 上交所期权 | 13432 | 此订单本身即是撤单请求 |     | The request is a delete order itself |     |
| 上交所期权 | 13446 | 前台版本号不匹配 |     | Invalid version no |     |
| 上交所期权 | 13466 | 请求类型无效 |     | Invalid request type |     |
| 上交所期权 | 13468 | 过户方PBU已经被暂停 |     | The PBU has been suspended |     |
| 上交所期权 | 13470 | 无效过户方PBU的PBU代码 |     | PBU does not exist |     |
| 上交所期权 | 13472 | 过户方投资者帐户与过户方PBU无指定交易关系 |     | Investor account not designated to the PBU |     |
| 上交所期权 | 13474 | 过户方投资者帐户已被暂停 |     | Investor account is suspended |     |
| 上交所期权 | 13476 | 无效过户方投资者帐户 |     | Invalid investor account ID |     |
| 上交所期权 | 13480 | 请求正在处理中 |     | Req in process |     |
| 上交所期权 | 13496 | 买方PBU与登录PBU不为同一会员 |     | Buy Pbu not equal Login PbuId |     |
| 上交所期权 | 13498 | 卖方PBU与登录PBU不为同一会员 |     | Sell Pbu not equal Login PbuId |     |
| 上交所期权 | 13516 | 消息未找到 |     | Message is not found |     |
| 上交所期权 | 13518 | 无效输入参数 |     | Invalid parameter |     |
| 上交所期权 | 13528 | 证券代码与原申报订单不一致 |     | Org-order InstId not match |     |
| 上交所期权 | 13532 | 无AddIdx权限 |     | No AddIdx Priv |     |
| 上交所期权 | 13534 | 无Add权限 |     | No Add Priv |     |
| 上交所期权 | 13536 | 无update权限 |     | No update Priv |     |
| 上交所期权 | 13538 | 无read权限 |     | No read Priv |     |
| 上交所期权 | 13540 | 无del data权限 |     | No del data Priv |     |
| 上交所期权 | 13542 | 无del idx权限 |     | No del idx Priv |     |
| 上交所期权 | 13560 | 广播服务数据恢复中 |     | Broadcast service in recovery |     |
| 上交所期权 | 13562 | PBU可用登录节点已用完 |     | No available PBU login Id is left |     |
| 上交所期权 | 17038 | 非法的有效期 |     | Invalid time in force |     |
| 上交所期权 | 17566 | 会员结算准备金不足以开新仓 |     | Margin is not enough to create new hold |     |
| 上交所期权 | 17568 | 计算权利金价格错误 |     | Calculate royalty error |     |
| 上交所期权 | 17570 | 计算期权保证金错误 |     | Calculate margin error |     |
| 上交所期权 | 17572 | 资金不足以支付权利金 |     | Cash is not enough to cover royalty |     |
| 上交所期权 | 17574 | 资金不足以支付保证金 |     | Cash is not enough to cover margin |     |
| 上交所期权 | 17576 | 期权开平仓类型错误 |     | Option order type error |     |
| 上交所期权 | 17582 | 无效的投资者类型 |     | Invalid invacc type |     |
| 上交所期权 | 17584 | 开平仓方向不一致 |     | Inconsistent opening and closing directions |     |
| 上交所期权 | 17586 | 无效的结算会员 |     | Invalid clrmember |     |
| 上交所期权 | 17588 | 无效的期权代码 |     | Invalid opt code |     |
| 上交所期权 | 17590 | 无效的价格量纲 |     | Invalid price unit |     |
| 上交所期权 | 17592 | 产品超过最后交易日 |     | Instrument exceed the end date |     |
| 上交所期权 | 17594 | 非法的行权申请日 |     | Invalid OEI date |     |
| 上交所期权 | 17598 | 无效的备兑标签 |     | Invalid covered flag |     |
| 上交所期权 | 17602 | 未实现的功能请求 |     | Undefined Function Request |     |
| 上交所期权 | 17604 | 无效的账户类型 |     | Invalid account type |     |
| 上交所期权 | 17606 | 持仓超过账户标的限制 |     | Exceed invacc under limit |     |
| 上交所期权 | 17608 | 持仓超过会员标的限制 |     | Exceed broker under limit |     |
| 上交所期权 | 17610 | 持仓超过会员全市场限制 |     | Exceed broker market limit |     |
| 上交所期权 | 17612 | 备兑持仓不足 |     | Cv holding is not enough to cover margin |     |
| 上交所期权 | 17614 | 买入开仓不允许备兑 |     | Covered is not allowed on buy open side |     |
| 上交所期权 | 17616 | 卖出平仓不允许备兑 |     | Covered is not allowed on sell close side |     |
| 上交所期权 | 17618 | 认沽期权不允许备兑 |     | Covered is not allowed on put option |     |
| 上交所期权 | 17622 | 锁定现货不足 |     | Not enough lock spot hold |     |
| 上交所期权 | 17624 | FOK订单触发VOLA |     | Fok order will trigger vola |     |
| 上交所期权 | 17626 | 无效的处理类别 |     | Invalid exercise method |     |
| 上交所期权 | 17628 | 开盘集合竞价不允许申报此类型订单 |     | This order type is not allowed in OCall |     |
| 上交所期权 | 17630 | 盘中集合竞价不允许申报此类型订单 |     | This order type is not allowed in ICall |     |
| 上交所期权 | 17632 | 无效的资金账户类型 |     | Invalid margin account type |     |
| 上交所期权 | 17634 | 设置或查询产品信息失败 |     | Set or get option infomation failed |     |
| 上交所期权 | 17636 | 持仓超过账户全市场限制 |     | Exceed invacc market limit |     |
| 上交所期权 | 17638 | PBU对该资金账户没有查询权限 |     | PBU doesn't have the inquiry right for the clrmbr |     |
| 上交所期权 | 17640 | 该产品已取消限开仓限制 |     | Instrument open position has been allowed |     |
| 上交所期权 | 17642 | 该产品已设置限开仓限制 |     | Instrument open position has been confined |     |
| 上交所期权 | 17644 | 当前交易日无效 |     | Invalid current biz date |     |
| 上交所期权 | 17646 | 日期小于当前交易日期 |     | Date is less than current biz date |     |
| 上交所期权 | 17648 | VOLA最后一分钟不允许删除订单 |     | Can not delete order in last 1 minutes of the VOLA |     |
| 上交所期权 | 17650 | 资金额度过大 |     | Margin amount overflow |     |
| 上交所期权 | 17652 | PBU无开仓权限 |     | PBU doesn't have right for open position |     |
| 上交所期权 | 17654 | PBU无平仓权限 |     | PBU doesn't have right for close position |     |
| 上交所期权 | 17656 | 无效的投资者账户子编码 |     | Invalid investor account subcode |     |
| 上交所期权 | 17658 | 合约无买入开仓权限 |     | Contract doesn't have right for buy open position |     |
| 上交所期权 | 17660 | 合约无非备兑卖出开仓权限 |     | Contract doesn't have right for uncovered call sell open position |     |
| 上交所期权 | 17662 | 合约无备兑卖出开仓权限 |     | Contract doesn't have right for covered call sell open position |     |
| 上交所期权 | 17664 | 合约结算价异常 |     | Contract(s) Stlprc is(are) abnormal |     |
| 上交所期权 | 17668 | 收盘集合竞价最后一分钟不允许删除订单 |     | Can not delete order in last 1 minutes of the close call auction |     |
| 上交所期权 | 17670 | 收盘集合竞价不允许申报此类型订单 |     | This order type is not allowed in CCall |     |
| 上交所期权 | 18200 | 打包消息中消息头的信息错误 |     | The package message header is broken |     |
| 上交所期权 | 18202 | 打包消息中的指令长度错误 |     | The package message instruction length is invalid |     |
| 上交所期权 | 18204 | 持仓更新指令掩码中的双边信息与输入参数不一致 |     | The request mask is inconsistent with side info |     |
| 上交所期权 | 18206 | 持仓更新指令的掩码不存在 |     | The request mask does not exist |     |
| 上交所期权 | 18208 | 持仓更新指令的掩码尚未启用 |     | The request mask has not been put into use |     |
| 上交所期权 | 18210 | 持仓更新指令的掩码不可用于ETF申赎 |     | The request mask is not applicable to ETF |     |
| 上交所期权 | 18600 | 当前时间不在业务设置时间段内 |     | Current time is not between the time range which has been setted |     |
| 上交所期权 | 19000 | 未指定的格式错误 |     | Unspecified Error |     |
| 上交所期权 | 19002 | 产品代码格式错误 |     | Format invalid InstId |     |
| 上交所期权 | 19006 | 数量格式错误 |     | Format invalid Quantity |     |
| 上交所期权 | 19008 | 日期格式错误 |     | Format invalid Date |     |
| 上交所期权 | 19010 | 金额格式错误 |     | Format invalid Amount |     |
| 上交所期权 | 19022 | 无效的业务类型 |     | Format invalid trade type |     |
| 上交所期权 | 19036 | 无效订单买卖方向 |     | Invalid Order buy/sell side |     |
| 上交所期权 | 19042 | 参数值非法 |     | Invalid parameter |     |
| 上交所期权 | 19044 | 非法分隔符个数 |     | Invalid element count |     |
| 上交所期权 | 19046 | 未定义的模板key值 |     | Undefined template key |     |
| 上交所期权 | 19048 | 非法账户 |     | Invalid accout |     |
| 上交所期权 | 19050 | 价格步长非法 |     | Invalid price of step |     |
| 上交所期权 | 19056 | 业务PBU或REFF字段于STEP消息中内容不符 |     | Invld Resub Key |     |
| 上交所期权 | 19058 | 业务PBU与登录PBU不为同一会员 |     | Biz Pbu not equal Login PbuId |     |
| 上交所期权 | 19088 | 非法消息类型 |     | Invalid message type |     |
| 上交所期权 | 19090 | 产品已被暂停交易 |     | Instrument is suspended for trading |     |
| 上交所期权 | 19092 | 业务已被暂停交易 |     | Business Type is suspended for trading |     |
| 上交所期权 | 19096 | 订单数量和交易金额小于最低要求 |     | Order quantity and tranding money is less than minimum |     |
| 上交所期权 | 19098 | 订单的数量不是整手数 |     | Order quantity is not round lot |     |
| 上交所期权 | 19102 | 订单价格超出范围 |     | Order price exceeds range |     |
| 上交所期权 | 19104 | PBU已经被暂停 |     | The PBU has been suspended |     |
| 上交所期权 | 19106 | PBU对该业务没有权限 |     | PBU doesn't have right for this business type |     |
| 上交所期权 | 19110 | 产品已停牌 |     | Instrument already in suspension |     |
| 上交所期权 | 19112 | 业务类型不可用 |     | Biz Typ not avail |     |
| 上交所期权 | 19114 | 产品不可用 |     | InstId not avail |     |
| 上交所期权 | 19118 | 子类型不可用 |     | Subtyp not avail |     |
| 上交所期权 | 19124 | TXNCODE不存在 |     | TXN Code Not Found |     |
| 上交所期权 | 19128 | PBU不存在 |     | Pbu Not Found |     |
| 上交所期权 | 19132 | 产品索引号不合法 |     | Instrument Index Invalid |     |
| 上交所期权 | 19136 | 权限标志不合法 |     | Permission Flag Invalid |     |
| 上交所期权 | 19140 | 无效的RID |     | RID Invalid |     |
| 上交所期权 | 19142 | 无效的时段 |     | Schedule Invalid |     |
| 上交所期权 | 19162 | 无效的INV |     | INV Invalid |     |
| 上交所期权 | 19164 | 账户已经被暂停 |     | The Inv has been suspended |     |
| 上交所期权 | 19166 | 账户对该业务没有交易权限 |     | The Inv has no authorized |     |
| 上交所期权 | 19176 | 该时段交易无效 |     | Not time auth |     |
| 上交所期权 | 19180 | 不是此账号的指定PBU |     | Invalid Acc PBU |     |
| 上交所期权 | 19182 | 无效的费率 |     | Invalid rate |     |
| 上交所期权 | 19184 | 申报数量超过上限 |     | Order quantity is more than maximum |     |
| 上交所期权 | 19186 | 无效的订单状态 |     | Invalid order status |     |
| 上交所期权 | 19188 | 该产品已停牌 |     | Instrument has been suspended |     |
| 上交所期权 | 19190 | 该产品已复牌 |     | Instrument has been unsuspended |     |
| 上交所期权 | 19192 | 会员不存在 |     | Brokercode not aval |     |
| 上交所期权 | 19196 | 会员对该业务没有交易权限 |     | The brk has no authorized |     |
| 上交所期权 | 19198 | 原始订单正在处理当中 |     | The original order is being processed |     |
| 上交所期权 | 19204 | 该产品已是参考竞价 |     | Instrument has been suspended as under |     |
| 上交所期权 | 19210 | 无效的数据格式 |     | Invalid data format |     |
| 上交所期权 | 19212 | 输入的主键与记录中主键不一致 |     | Key is different in value |     |
| 上交所期权 | 19214 | 未定义的文件名 |     | Undefined file name template key |     |
| 上交所期权 | 19216 | 删除数据与文件原始记录不同 |     | Delete data is different the original data |     |
| 上交所期权 | 19218 | 位图长度与字段个数不符 |     | BitMap length is different with file field |     |
| 上交所期权 | 19220 | 位图信息错误 |     | BitMap msg error |     |
| 上交所期权 | 19256 | 产品已被连续停牌 |     | Instrument is persistent suspended for trading |     |
| 上交所期权 | 19258 | 基础产品已停牌 |     | Underlying instrument is suspended for trading |     |
| 上交所期权 | 19268 | 组合策略构成头寸方向不符合要求 |     | Position direction of combination strategy not meet requirements |     |
| 上交所期权 | 19270 | 组合策略构成合约标的不符合要求 |     | Underlying of combination strategy contract not meet requirements |     |
| 上交所期权 | 19272 | 组合策略构成合约行权价格不符合要求 |     | Exercise price of combination strategy contract not meet requirements |     |
| 上交所期权 | 19274 | 组合策略构成合约乘数不一致 |     | Contract multipliers of composition strategy contract are inconsistents |     |
| 上交所期权 | 19276 | 组合份数与成分合约比例不符或成分合约比例与策略要求比例不符 |     | Combined shares not match the component contract proportion or the component contract proportion not meet requirements of strategy |     |
| 上交所期权 | 19278 | 组合策略拆分数量超过SM78记录值 |     | Combination strategy splits exceed SM78 record value |     |
| 上交所期权 | 19280 | 合约不能进行垂直价差策略的组合 |     | Contracts cannot be combined by vertical spread strategies |     |
| 上交所期权 | 19282 | 认购期权普通卖开转备兑策略不支持拆分 |     | Split not supported for call option strategy of putting general to cover |     |
| 上交所期权 | 19284 | 拆分申报策略与组合时不匹配 |     | Split purchase strategy not match with Combination |     |
| 上交所期权 | 19286 | 拆分申报合约与组合时不匹配 |     | Split purchase contract not match with combination |     |
| 上交所期权 | 19288 | 组合时组合编号不为空 |     | Combination number not empty when combining |     |
| 上交所期权 | 19290 | 拆分申报账户与组合时不同 |     | Split declaration account different from combination |     |
| 上交所期权 | 19292 | 拆分时，组合编号不能为空 |     | Combination number can not be empty when splitting |     |
| 上交所期权 | 19294 | 该组合持仓不存在 |     | Position of combination not exist |     |
| 上交所期权 | 19296 | 资金不足以拆分 |     | Funds not enough to split up |     |
| 上交所期权 | 19298 | 组合份数必须大于0 |     | Combined shares must be greater than 0 |     |
| 上交所期权 | 19300 | 组合策略构成合约数量不符合要求 |     | Quantity of combination strategy contract not meet requirements |     |
| 上交所期权 | 19302 | 组合策略构成合约到期日不符合要求 |     | Expired date of combination strategy contract not meet requirementsss |     |
| 上交所期权 | 19304 | 组合策略构成合约期权类型不符合要求 |     | Contract type of combination strategy not meet requirements |     |
| 上交所期权 | 19306 | 组合策略构成合约备兑标签不符合要求 |     | Label of combination strategy contract not meet requirements |     |
| 上交所期权 | 20002 | 参数值非法 tag:9 |     | Invalid parameter tag:9 |     |
| 上交所期权 | 20004 | 参数值非法 tag:11 |     | Invalid parameter tag:11 |     |
| 上交所期权 | 20006 | 参数值非法 tag:17 |     | Invalid parameter tag:17 |     |
| 上交所期权 | 20008 | 参数值非法 tag:23 |     | Invalid parameter tag:23 |     |
| 上交所期权 | 20010 | 参数值非法 tag:26 |     | Invalid parameter tag:26 |     |
| 上交所期权 | 20012 | 参数值非法 tag:28 |     | Invalid parameter tag:28 |     |
| 上交所期权 | 20014 | 参数值非法 tag:31 |     | Invalid parameter tag:31 |     |
| 上交所期权 | 20016 | 参数值非法 tag:32 |     | Invalid parameter tag:32 |     |
| 上交所期权 | 20018 | 参数值非法 tag:35 |     | Invalid parameter tag:35 |     |
| 上交所期权 | 20020 | 参数值非法 tag:37 |     | Invalid parameter tag:37 |     |
| 上交所期权 | 20022 | 参数值非法 tag:38 |     | Invalid parameter tag:38 |     |
| 上交所期权 | 20024 | 参数值非法 tag:39 |     | Invalid parameter tag:39 |     |
| 上交所期权 | 20028 | 参数值非法 tag:41 |     | Invalid parameter tag:41 |     |
| 上交所期权 | 20030 | 参数值非法 tag:42 |     | Invalid parameter tag:42 |     |
| 上交所期权 | 20032 | 参数值非法 tag:44 |     | Invalid parameter tag:44 |     |
| 上交所期权 | 20034 | 参数值非法 tag:48 |     | Invalid parameter tag:48 |     |
| 上交所期权 | 20036 | 参数值非法 tag:54 |     | Invalid parameter tag:54 |     |
| 上交所期权 | 20038 | 无效参数 tag:55 |     | Invalid parameter tag:55 |     |
| 上交所期权 | 20040 | 无效参数 tag:58 |     | Invalid parameter tag:58 |     |
| 上交所期权 | 20042 | 无效参数 tag:60 |     | Invalid parameter tag:60 |     |
| 上交所期权 | 20046 | 无效参数 tag:102 |     | Invalid parameter tag:102 |     |
| 上交所期权 | 20048 | 无效参数 tag:103 |     | Invalid parameter tag:103 |     |
| 上交所期权 | 20054 | 无效参数 tag:150 |     | Invalid parameter tag:150 |     |
| 上交所期权 | 20056 | 无效参数 tag:151 |     | Invalid parameter tag:151 |     |
| 上交所期权 | 20070 | 无效参数 tag:271 |     | Invalid parameter tag:271 |     |
| 上交所期权 | 20078 | 无效参数 tag:8504 |     | Invalid parameter tag:8504 |     |
| 上交所期权 | 20080 | 无效参数 tag:434 |     | Invalid parameter tag:434 |     |
| 上交所期权 | 20082 | 无效参数 tag:448 |     | Invalid parameter tag:448 |     |
| 上交所期权 | 20084 | 无效参数 tag:452 |     | Invalid parameter tag:452 |     |
| 上交所期权 | 20086 | 无效参数 tag:453 |     | Invalid parameter tag:453 |     |
| 上交所期权 | 20094 | 无效参数 tag:580 |     | Invalid parameter tag:580 |     |
| 上交所期权 | 20100 | 无效参数 tag:664 |     | Invalid parameter tag:664 |     |
| 上交所期权 | 20102 | 参数值非法 tag:693 |     | Invalid parameter tag:693 |     |
| 上交所期权 | 20104 | 参数值非法 tag:694 |     | Invalid parameter tag:694 |     |
| 上交所期权 | 20114 | 参数值非法 tag:1080 |     | Invalid parameter tag:1080 |     |
| 上交所期权 | 20124 | 参数值非法 tag:1180 |     | Invalid parameter tag:1180 |     |
| 上交所期权 | 20132 | 参数值非法 tag:8504 |     | Invalid parameter tag:8504 |     |
| 上交所期权 | 20140 | 参数值非法 tag:40 |     | Invalid parameter tag:40 |     |
| 上交所期权 | 20142 | 参数值非法 tag:152 |     | Invalid parameter tag:152 |     |
| 上交所期权 | 20202 | 参数值非法 tag:308 |     | Invalid parameter tag:308 |     |
| 上交所期权 | 20204 | 参数值非法 tag:522 |     | Invalid parameter tag:522 |     |
| 上交所期权 | 20206 | 参数值非法 tag:59 |     | Invalid parameter tag:59 |     |
| 上交所期权 | 20208 | 参数值非法 tag:203 |     | Invalid parameter tag:203 |     |
| 上交所期权 | 20212 | 参数值非法 tag:8538 |     | Invalid parameter tag:8538 |     |
| 上交所期权 | 20214 | 参数值非法 tag:845 |     | Invalid parameter tag:845 |     |
| 上交所期权 | 20216 | 参数值非法 tag:77 |     | Invalid parameter tag:77 |     |
| 上交所期权 | 20218 | 参数值非法 tag:8541 |     | Invalid parameter tag:8541 |     |
| 上交所期权 | 20220 | 参数值非法 tag:963 |     | Invalid parameter tag:963 |     |
| 上交所期权 | 20224 | 参数值非法 tag:1187 |     | Invalid parameter tag:1187 |     |
| 上交所期权 | 20226 | 参数值非法 tag:1365 |     | Invalid parameter tag:1365 |     |
| 上交所期权 | 20228 | 参数值非法 tag:1443 |     | Invalid parameter tag:1443 |     |
| 上交所期权 | 20230 | 参数值非法 tag:1362 |     | Invalid parameter tag:1362 |     |
| 上交所期权 | 20232 | 参数值非法 tag:8506 |     | Invalid parameter tag:8506 |     |
| 上交所期权 | 20234 | 参数值非法 tag:747 |     | Invalid parameter tag:747 |     |
| 上交所期权 | 20236 | 参数值非法 tag:1635 |     | Invalid parameter tag:1635 |     |
| 上交所期权 | 20238 | 参数值非法 tag:1643 |     | Invalid parameter tag:1643 |     |
| 上交所期权 | 20240 | 参数值非法 tag:1645 |     | Invalid parameter tag:1645 |     |
| 上交所期权 | 20242 | 参数值非法 tag:1644 |     | Invalid parameter tag:1644 |     |
| 上交所期权 | 20244 | STEP模板 缺少msg type |     | STEP body missing msg type |     |
| 上交所期权 | 20246 | STEP模板 缺少结尾的分隔符 |     | STEP body missing ending |     |
| 上交所期权 | 20248 | STEP字段 tag取值为NULL字符串 |     | STEP field NULL value string |     |
| 上交所期权 | 20250 | STEP字段 tag不可识别 |     | STEP field not a valid TAG |     |
| 上交所期权 | 20252 | STEP字段 等号前有多余的空格 |     | STEP field extra SPACE before EQUAL mark |     |
| 上交所期权 | 20254 | STEP字段 不符合key-value的格式 |     | STEP field not a key-value format |     |
| 上交所期权 | 20256 | STEP模板 tag个数与配置不同 |     | STEP body tag count is not same as the template |     |
| 上交所期权 | 20258 | STEP模板 不允许结尾的分隔符 |     | STEP body ending delimiter not allowed |     |
| 上交所期权 | 20260 | 参数值非法 tag:198 |     | Invalid parameter tag:198 |     |
| 上交所期权 | 20262 | 参数值非法 tag:555 |     | Invalid parameter tag:555 |     |
| 上交所期权 | 20264 | 参数值非法 tag:602 |     | Invalid parameter tag:602 |     |
| 上交所期权 | 20266 | 参数值非法 tag:624 |     | Invalid parameter tag:624 |     |
| 上交所期权 | 20268 | 参数值非法 tag:685 |     | Invalid parameter tag:685 |     |
| 上交所期权 | 20270 | 参数值非法 tag:131 |     | Invalid parameter tag:131 |     |
| 上交所期权 | 40000 | 未指定的转化错误 |     | Unspecified conversion error |     |
| 上交所期权 | 40002 | 为指定的MsgLib错误 |     | Unspecified error of MsgLib |     |
| 上交所期权 | 40004 | 当尝试往文件FPSYNSTS或FTRESUB中写记录时 |     | Record already exist when trying to write record into FPSYNSTS or FTRESUB |     |
| 上交所期权 | 40006 | 当获取系统时间时出错 |     | Error occurs when getting current system time |     |
| 上交所期权 | 40008 | 当向文件FPSYNLOG写消息出错 |     | Error occurs when writing a message into FPSYNLOG |     |
| 上交所期权 | 40010 | 检查FPSYNSTS中的重新提交状态信息出错 |     | Error occurs when checking resubmission status of a message from FPSYNSTS |     |
| 上交所期权 | 40012 | 检查FTRESUB中的重新提交状态信息出错 |     | Error occurs when checking resubmission status of a message from FTRESUB |     |
| 上交所期权 | 40014 | 检查FTRESUB中的读取完成信息出错 |     | Error occurs when reading completion code of a message from FTRESUB |     |
| 上交所期权 | 40016 | 检查FTRESUB中的更新完成信息出错 |     | Error occurs when updating completion code of a message in FTRESUB |     |
| 上交所期权 | 40018 | 调用OpenVMS系统服务失败 |     | Call OpenVMS system service error |     |
| 上交所期权 | 40020 | 无效参数 |     | Invalid input parameters |     |
| 上交所期权 | 40022 | 超出预定的范围 |     | Beyond the range |     |
| 上交所期权 | 40024 | 共享内存操作失败 |     | Shared memory operations fail |     |
| 上交所期权 | 40026 | 打开FILEINFO出错 |     | Open the FILEINFO error |     |
| 上交所期权 | 40028 | 读取FILEINFO出错 |     | Read the FILEINFO error |     |
| 上交所期权 | 40030 | 打开文件出错: 文件= |     | Open the file error |     |
| 上交所期权 | 40032 | 非法的区域类型 |     | Invalid location type |     |
| 上交所期权 | 40034 | 检验所有的文件出错 |     | Verify all files error |     |
| 上交所期权 | 40036 | 非法的流号码 |     | Invalid stream no, not 1 or 2 |     |
| 上交所期权 | 40038 | 超过最大文件值50 |     | Exceed the maximum file number 50 |     |
| 上交所期权 | 40040 | 从文件读记录错误: 键值= |     | Read a record from file error |     |
| 上交所期权 | 40042 | 从文件读下一条记录错误 |     | Read next a record from file error |     |
| 上交所期权 | 40044 | 从文件读唯一记录错误 |     | Read unique record from file error |     |
| 上交所期权 | 40046 | 用驱动模式从文件读记录错误 |     | Read a record from file with driver mode error |     |
| 上交所期权 | 40050 | 用锁模式从文件读下一条记录错误 |     | Read next a record from file with lock mode error |     |
| 上交所期权 | 40052 | 用锁模式从文件读唯一记录错误 |     | Read unique record from file with lock mode error |     |
| 上交所期权 | 40054 | 返回值到文件头部错误 |     | Rewind to the start of the file error |     |
| 上交所期权 | 40056 | 唯一的键值为空 |     | The unique key is null |     |
| 上交所期权 | 40058 | 驱动的键值为空 |     | The driver key is null |     |
| 上交所期权 | 40060 | 写入的记录为空 |     | The written record is null |     |
| 上交所期权 | 40062 | 向文件写记录错误 |     | Write the record into file error |     |
| 上交所期权 | 40064 | 禁止向数据库写记录错误 |     | Write the record into database which prohibited |     |
| 上交所期权 | 40066 | 更新的键值为空 |     | The update key is null |     |
| 上交所期权 | 40068 | 更新的记录为空 |     | The update record is null |     |
| 上交所期权 | 40070 | 找不到要更新的记录: 类型= |     | Updated record is not found |     |
| 上交所期权 | 40072 | 向文件更新记录错误 |     | Update the record in file error |     |
| 上交所期权 | 40074 | 禁止向数据库更新记录错误 |     | Update the record into database which prohibited |     |
| 上交所期权 | 40076 | 删除的键值为空 |     | The delete key is null |     |
| 上交所期权 | 40078 | 向文件删除记录错误 |     | Delete the record in file error |     |
| 上交所期权 | 40080 | 禁止向数据库删除记录错误 |     | Delete the record from database which prohibited |     |
| 上交所期权 | 40082 | 关闭文件错误 |     | Close the file error |     |
| 上交所期权 | 40084 | 关闭所有文件错误 |     | Close all the files error |     |
| 上交所期权 | 40086 | 在文件中找不到记录: 类型= |     | Record not found in file |     |
| 上交所期权 | 40088 | 非法的键值数字 |     | Invalid the key number, not P,A1,A2,A3,A4 |     |
| 上交所期权 | 40090 | 非法的访问模式: accMode= |     | Invalid the access mode |     |
| 上交所期权 | 40092 | 参数非法 |     | Invalid parameter |     |
| 上交所期权 | 40094 | 读配置文件出错: rtn_cod = |     | Read configuration file error |     |
| 上交所期权 | 40096 | 写配置文件出错: rtn_cod = |     | Write configuration file error |     |
| 上交所期权 | 40098 | 配置文件中已存在相应的配置项 |     | Same key already exits in configuration file |     |
| 上交所期权 | 40100 | 配置文件中不存在相应的配置项 |     | Can't find cfg item in FPCFG with provided key |     |
| 上交所期权 | 40102 | 打开配置文件出错 |     | Can't open configuration file |     |
| 上交所期权 | 40104 | 非法的配置项关键字 |     | Invalid configuration key |     |
| 上交所期权 | 40106 | 初始化CFGLIB出错 |     | Initialize configuration library fail |     |
| 上交所期权 | 40108 | 关闭CFGLIB出错 |     | Shutdown configuration library fail |     |
| 上交所期权 | 40110 | 使用缺省的配置数据 |     | Use default configuration value |     |
| 上交所期权 | 40112 | 非法的存储设备类型:设备类型 = |     | Invalid storage device type |     |
| 上交所期权 | 40114 | 在配置的缓存中不存在相应的配置项 |     | Can't find cfg item in cfg cache with provided key |     |
| 上交所期权 | 40116 | 配置缓存中已存在相应的配置项 |     | Same key already exits in cfg cache |     |
| 上交所期权 | 40118 | 往配置缓存中添加配置项时出错: key = |     | Insert item to memory cache error |     |
| 上交所期权 | 40122 | CFGLIB没有初始化 |     | CFGLIB not initialized |     |
| 上交所期权 | 40124 | 未定义的错误代码! |     | Unknown error code! |     |
| 上交所期权 | 40126 | 处理错误代码时 |     | For error code, error description truncated! |     |
| 上交所期权 | 40128 | 初始化错误库时，无法打开所有文件 |     | Can not open all files when init error library! |     |
| 上交所期权 | 40130 | 写文件错误 |     | Can not write file! |     |
| 上交所期权 | 40132 | 超过最大允许Hex Dump的字节数 |     | Exceed maximum hex dump size! |     |
| 上交所期权 | 40134 | 不合法的SNMP host名! |     | Invalid SNMP host name! |     |
| 上交所期权 | 40136 | 初始化SNMP库失败! |     | Init SNMP lib fail! |     |
| 上交所期权 | 40138 | 发送SNMP trap失败! |     | Send SNMPtrap fail! |     |
| 上交所期权 | 40140 | 初始化config库失败! |     | Init config lib fail! |     |
| 上交所期权 | 40142 | 取config库参数失败! |     | Get item from config lib fail! |     |
| 上交所期权 | 40144 | 配置项: )! |     | Config item |     |
| 上交所期权 | 40148 | 取进程信息:GetPrcsId失败! |     | Get process information |     |
| 上交所期权 | 40150 | 创建锁失败! |     | Create lock fail! |     |
| 上交所期权 | 40152 | 加锁失败! |     | Lock fail! |     |
| 上交所期权 | 40154 | 解锁失败! |     | Unlock fail! |     |
| 上交所期权 | 40156 | CallSysError |     | CallSysError |     |
| 上交所期权 | 40158 | IssueSysError |     | IssueSysError |     |
| 上交所期权 | 40160 | 系统严重错误 |     | Fatal system error |     |
| 上交所期权 | 40162 | 系统错误 |     | System error |     |
| 上交所期权 | 40164 | 系统错误 |     | System error |     |
| 上交所期权 | 40166 | 函数输入参数不正确: 参数 = |     | Input parameter invalid |     |
| 上交所期权 | 40168 | 找不到逻辑名= |     | No value find for logical name |     |
| 上交所期权 | 40170 | 系统调用getjpi出错 |     | Getjpi system call fails |     |
| 上交所期权 | 40176 | 连接到邮箱出错 |     | Fail to assign mailbox |     |
| 上交所期权 | 40178 | 发送消息到邮箱出错 |     | Fail to send to mailbox |     |
| 上交所期权 | 40180 | 从邮箱接收消息出错 |     | Fail to read from mailbox |     |
| 上交所期权 | 40182 | 发送消息到邮箱出错 |     | Fail to send to mailbox, mailbox full |     |
| 上交所期权 | 40184 | 取本机的逻辑节点名出错 |     | Fail to get logical node name of the localhost |     |
| 上交所期权 | 40190 | 空指针！ |     | Null pointer! |     |
| 上交所期权 | 40192 | 分配指针失败 |     | Unable to allocate memory space for a pointer |     |
| 上交所期权 | 40198 | 无法获得产品数据: isin= |     | Unable to get instrument data |     |
| 上交所期权 | 40204 | 表格未在数据库或模式中定义 |     | Table not defined in the database or schema |     |
| 上交所期权 | 40206 | 无效的退出顺序 |     | Invalid escape sequence |     |
| 上交所期权 | 40208 | set 函数不能为空 |     | Null eliminated in the set function |     |
| 上交所期权 | 40210 | 无效的参数值 |     | Invalid parameter value |     |
| 上交所期权 | 40212 | 标识溢出 |     | Indicator overflow |     |
| 上交所期权 | 40214 | 未终结的C字符串 |     | Unterminated C string |     |
| 上交所期权 | 40216 | 检查选项中存在整数故障 |     | Integer failure with check option |     |
| 上交所期权 | 40218 | 未找到匹配的情形；未指定WHEN |     | Case not found; WHEN not specified |     |
| 上交所期权 | 40220 | 在事务中未保留表格 |     | Table is not reserved in the transaction |     |
| 上交所期权 | 40222 | 元数据不存在 |     | Metadata no longer exists |     |
| 上交所期权 | 40224 | 试图更新只读表格 |     | Attempt to update a read-only table |     |
| 上交所期权 | 40226 | 指定的列范围为负 |     | Negative scale specified for a column |     |
| 上交所期权 | 40228 | 指定的列长度为负 |     | Negative length specified for a column |     |
| 上交所期权 | 40230 | 无执行该操作的权限 |     | No privilege for attempted operation |     |
| 上交所期权 | 40232 | 域未在数据库或模式中定义 |     | Domain is not defined in the database or schema |     |
| 上交所期权 | 40234 | 该域在数据库或模式中已存在 |     | Domain already exists in the database or schema |     |
| 上交所期权 | 40236 | 该表格在数据库或模式中已存在 |     | Table already exists in the database or schema |     |
| 上交所期权 | 40238 | 该列未在表格中定义 |     | Column not defined in the table |     |
| 上交所期权 | 40240 | 该列在表格中已存在 |     | Column already exists in the table |     |
| 上交所期权 | 40242 | 别名已声明 |     | Alias is already declared |     |
| 上交所期权 | 40244 | 未知的别名 |     | Alias is not known |     |
| 上交所期权 | 40246 | 数据库关联错误 |     | Error attaching to the database |     |
| 上交所期权 | 40248 | 数据库规格存在一个句法错误 |     | Database specification contains a syntax error |     |
| 上交所期权 | 40250 | 数据库环境规格存在一个句法错误 |     | Database environment specification contains a syntax error |     |
| 上交所期权 | 40252 | 该连接名已存在 |     | Connection name already exists |     |
| 上交所期权 | 40254 | 该连接不存在 |     | Connection does not exist |     |
| 上交所期权 | 40256 | 未设定动态声明 |     | Dynamic statement is not prepared |     |
| 上交所期权 | 40258 | 模块的调用者非其定义者 |     | Invoker of the module is not the same as the definer |     |
| 上交所期权 | 40260 | 包含该列表的行已被删除 |     | Row that contains the list has been deleted |     |
| 上交所期权 | 40262 | 语境结构中的长度定义不正确 |     | Length in the context structure is defined incorrectly |     |
| 上交所期权 | 40264 | 语境结构中的类型字段定义不正确 |     | Type field in the context structure is defined incorrectly |     |
| 上交所期权 | 40266 | 语境结构中的版本字段定义不正确 |     | Version field in the context structure is defined incorrectly |     |
| 上交所期权 | 40268 | 分布式事务代码错误 |     | Distributed transaction id error |     |
| 上交所期权 | 40270 | 无隐含的分布式事务未处理 |     | No implicit distributed transaction outstanding |     |
| 上交所期权 | 40272 | 触发器引发错误 |     | Trigger forced an error |     |
| 上交所期权 | 40274 | 底层系统的版本不支持该查询所需功能 |     | Version ofunderlying system does not support a feature that this query uses |     |
| 上交所期权 | 40276 | 无活动的事务 |     | No transaction active |     |
| 上交所期权 | 40278 | 无效的事务状态－该事务已启动 |     | Invalid transaction state?Cthe transaction already started |     |
| 上交所期权 | 40280 | 由于资源已被锁定 |     | NO WAIT request failed because resource was locked |     |
| 上交所期权 | 40282 | Valid-if 失败 |     | Valid-if failed |     |
| 上交所期权 | 40284 | 约束失败 |     | Constraint failed |     |
| 上交所期权 | 40286 | 资源死锁导致请求失败 |     | Request failed due to resource deadlock |     |
| 上交所期权 | 40288 | 试图从只读事务进行更新 |     | Attempt to update from a read-only transaction |     |
| 上交所期权 | 40290 | 单选返还一个以上的值 |     | The result of a singleton select returned more than one value |     |
| 上交所期权 | 40292 | 更新将导致唯一性索引的重复 |     | Updating would cause duplication on a unique index |     |
| 上交所期权 | 40294 | UPDATE 或 DELETE操作的指针被定位到一个已删除行 |     | Cursor in an UPDATE or DELETE operation is positioned on a deleted row |     |
| 上交所期权 | 40296 | UPDATE 或 DELETE操作的指针未被定位到行 |     | Cursor in an UPDATE or DELETE operation is not positioned on a row |     |
| 上交所期权 | 40298 | UPDATE 或 DELETE操作的指针未打开 |     | Cursor in an UPDATE or DELETE operation is not opened |     |
| 上交所期权 | 40300 | 指针未打开 |     | Cursor is not open |     |
| 上交所期权 | 40302 | 时间－日期格式无效 |     | Date-time format is invalid |     |
| 上交所期权 | 40304 | 试图存储一个空值至没有标识变量的宿主语言变量 |     | Tried to store null into host language variable with no indicator variable |     |
| 上交所期权 | 40306 | 值超出了宿主变量允许的取值范围 |     | Value is out of range for a host variable |     |
| 上交所期权 | 40308 | 未定义的RDB错误 |     | Undefined RDB error |     |
| 上交所期权 | 40310 | SELECT声明或指针已到达数据流的末尾 |     | SELECT statement or cursor came to the end of stream |     |
| 上交所期权 | 40312 | Set 函数中的空值已被消去 |     | Null value was eliminated in a set function |     |
| 上交所期权 | 40314 | 字符串在指定时已被截短 |     | String truncated during assignment |     |
| 上交所期权 | 40318 | 环缓冲无订单 |     | No orders in the ring buffer |     |
| 上交所期权 | 40322 | 环缓冲溢出 |     | Full in the ring buffer |     |
| 上交所期权 | 40324 | 参数对该函数无效 |     | Invalid parameter |     |
| 上交所期权 | 40326 | 订单簿中未找到订单 |     | Order not found in orderbook |     |
| 上交所期权 | 40328 | 订单簿空间满 |     | Set orderbook memory area is full |     |
| 上交所期权 | 40340 | 删除锁失败! |     | Delete lock fail! |     |
| 上交所期权 | 40342 | 获得共享内存中的槽失败 |     | Get slot failed in SHM |     |
| 上交所期权 | 40344 | 获得共享内存中的根地址失败 |     | Get root address failed in SHM |     |
| 上交所期权 | 40346 | 保留共享内存中的槽失败 |     | Reserve slot failed in SHM |     |
| 上交所期权 | 40348 | 绑定共享内存中的槽失败 |     | Attach slot failed in SHM |     |
| 上交所期权 | 40350 | 释放共享内存中的槽失败 |     | Free slot failed in SHM |     |
| 上交所期权 | 40352 | 获得共享内存中的槽总数失败 |     | Get the sum of slot failed in SHM |     |
| 上交所期权 | 40354 | 读取共享内存中的记录失败 |     | Read record failed in SHM |     |
| 上交所期权 | 40356 | 读取共享内存中的唯一记录失败 |     | Read unique record failed in SHM |     |
| 上交所期权 | 40358 | 读取共享内存中的下一条记录失败 |     | Read next record failed in SHM |     |
| 上交所期权 | 40360 | 关键字的大小为空 |     | The size of key is null |     |
| 上交所期权 | 40362 | 读取数据库中的记录失败 |     | Read record in db failed |     |
| 上交所期权 | 40364 | 读取数据库中的唯一记录失败 |     | Read unique record in db failed |     |
| 上交所期权 | 40366 | 读取数据库中的下一条记录失败 |     | Read next record in db failed |     |
| 上交所期权 | 40368 | 读驱动操作在共享内存和数据库中不允许 |     | Readdrive is unallowed in SHM and DB |     |
| 上交所期权 | 40370 | 读锁操作在共享内存和数据库中不允许 |     | Readlock is unallowed in SHM and DB |     |
| 上交所期权 | 40372 | 读下一个锁操作在共享内存和数据库中不允许 |     | Readnextlock is unallowed in SHM and DB |     |
| 上交所期权 | 40374 | 读唯一锁操作在共享内存和数据库中不允许 |     | Readuniquelock is unallowed in SHM and DB |     |
| 上交所期权 | 40376 | 插入操作在共享内存和数据库中不允许 |     | Insertion is unallowed in SHM and DB |     |
| 上交所期权 | 40378 | 更新在共享内存中的记录失败 |     | Update record failed in SHM |     |
| 上交所期权 | 40380 | 删除操作在共享内存和数据库中不允许 |     | Deletion is unallowed in SHM |     |
| 上交所期权 | 40382 | 读锁操作时间用完 |     | Readlock is timeout |     |
| 上交所期权 | 40384 | 读下一个锁操作时间用完 |     | Readnextlock is timeout |     |
| 上交所期权 | 40386 | 读唯一锁操作时间用完 |     | Readuniquelock is timeout |     |
| 上交所期权 | 40388 | 检验在共享内存中分配的总槽数失败 |     | Validate the total slot num allocated in the SHM failed |     |
| 上交所期权 | 40390 | 创建共享内存出错 |     | Create SHM failed |     |
| 上交所期权 | 40392 | 分配内存出错 |     | Allocate memory error |     |
| 上交所期权 | 40394 | 邮箱: 中没有消息 |     | There is not message in mailbox |     |
| 上交所期权 | 40398 | 无法读取FPASNLOG中的一条记录: 键值= |     | Fail to read a unique record in FPASNLOG |     |
| 上交所期权 | 40400 | 无法读取FPASNLOG中的一条记录的完成状态码: 键值= |     | Fail to readthe asynchronous status code of a record |     |
| 上交所期权 | 40402 | 无法设置FPASNLOG中一条记录的完成状态码: 键值= |     | Fail to setthe asynchronous status code of arecord in FPASNLOG |     |
| 上交所期权 | 40404 | 无法将缓冲的数据写入FPASNLOG |     | Fail to flush the data in buffer into FPASNLOG |     |
| 上交所期权 | 40406 | 非法的/空的槽ID |     | Invalid / empty slot ID |     |
| 上交所期权 | 40408 | 无法生成异步消息计数锁 |     | Fail to create asynchronous counter lock |     |
| 上交所期权 | 40410 | 无法更新异步消息计数锁 |     | Fail to update the asynchronous counter lock |     |
| 上交所期权 | 40412 | 无法初始化Message Library |     | Fail to initiate the Message Library |     |
| 上交所期权 | 40414 | 该异步记录已被处理或已出错 |     | The FPASNLOG records have already been processed or are error |     |
| 上交所期权 | 40416 | 无法读取异步小时计数锁 |     | Fail to read the asynchronous counter lock |     |
| 上交所期权 | 40418 | Set订单簿容量不足 |     | Set orderbook size is insufficient |     |
| 上交所期权 | 40424 | 取系统时间失败 |     | Get systime failed! |     |
| 上交所期权 | 40426 | 无效Socket |     | Invalid socket |     |
| 上交所期权 | 40428 | Multicast Library没有初始化 |     | Multicast library not initialized! |     |
| 上交所期权 | 40430 | Socket出错 |     | Socket failed,errno |     |
| 上交所期权 | 40438 | Select时间用完 |     | Socket |     |
| 上交所期权 | 40440 | Select出错 |     | Select failed |     |
| 上交所期权 | 40444 | 设置nonblock属性出错 |     | Set nonblock option failed |     |
| 上交所期权 | 40446 | IP地址转换出错 |     | IP address conversion failed |     |
| 上交所期权 | 40450 | 无效的Channel状态 |     | Invalid Channel state |     |
| 上交所期权 | 40452 | 无效的Channel类型 |     | Invalid Channel type |     |
| 上交所期权 | 40454 | 无效地址 |     | Invalid address |     |
| 上交所期权 | 40456 | 无效参数 |     | Invalid parameter |     |
| 上交所期权 | 40458 | 内存分配出错: 指针＝ |     | Malloc failed |     |
| 上交所期权 | 40460 | 无效交易限制类型: 类型= |     | Invalid trading restriction type |     |
| 上交所期权 | 40462 | 无效订单簿买卖方向: 方向=%c |     | Invalid orderbook side |     |
| 上交所期权 | 40464 | 无效订单簿排序结构 |     | Invalid tree structure, isxi |     |
| 上交所期权 | 40470 | 无效ISIX: isix= |     | Invalid ISIX input |     |
| 上交所期权 | 40472 | 订单簿函数库未初始化 |     | Orderbook library not initialised |     |
| 上交所期权 | 40474 | 空指针 |     | Null pointer input |     |
| 上交所期权 | 40476 | Set 共享内存已映射 |     | Set shared memory is already mapped |     |
| 上交所期权 | 40486 | 无法构造内部市场数据 |     | Fail to construct inside market data |     |
| 上交所期权 | 40488 | 调用多播库失败 |     | Fail to call multicast library |     |
| 上交所期权 | 40490 | 超出允许的市场个数 |     | Beyond the limit number for market |     |
| 上交所期权 | 40494 | 开始处理事务失败 |     | Start transaction failed |     |
| 上交所期权 | 40496 | 提交处理事务失败 |     | Commit transaction failed |     |
| 上交所期权 | 40498 | 回滚处理事务失败 |     | Rollback transaction failed |     |
| 上交所期权 | 40500 | 读驱动操作时间用完 |     | Readdriver is timeout |     |
| 上交所期权 | 40502 | ISIX转换无效: isix= |     | Converted ISIX is invalid |     |
| 上交所期权 | 40504 | ISIX转换失败 |     | Failed to convert ISIX |     |
| 上交所期权 | 40508 | 取配置参数失败: 参数= |     | Get configuration failed |     |
| 上交所期权 | 40510 | 无效参数 |     | Invalid parameter |     |
| 上交所期权 | 40516 | 无法获取访问产品集合内存区域的锁 |     | Fail to get the primary set lock |     |
| 上交所期权 | 40518 | 创建内存区域失败 |     | Fail to create the set shared memory section |     |
| 上交所期权 | 40528 | 创建内存镜像文件失败 |     | Fail to create the memory dump files |     |
| 上交所期权 | 40538 | 邮箱消息处理中断 |     | Processing of mailbox message is interrupted |     |
| 上交所期权 | 40540 | 无法获取指定的主锁 |     | Fail to get the master lock |     |
| 上交所期权 | 40566 | 进程互锁失败 |     | Fail to interlock with architecture |     |
| 上交所期权 | 40568 | 初始化BIL库失败 |     | Fail to initialize BIL library |     |
| 上交所期权 | 40586 | 配置参数无效: 参数= |     | The configuration parameter is invalid |     |
| 上交所期权 | 40590 | 存储做市商报价信息的内存空间已满 |     | Mmqi memory area is full |     |
| 上交所期权 | 40596 | 缓冲区过小 |     | Buffer too small |     |
| 上交所期权 | 40598 | OPENVMS操作系统错误 |     | OPENVMS error |     |
| 上交所期权 | 40614 | 读IRA文件块错误 |     | Invalid block read for IRA file, curIRA |     |
| 上交所期权 | 40620 | 未找到空闲空间 |     | No free frame found, group |     |
| 上交所期权 | 40628 | 内存溢出 |     | Memory can not be allocated |     |
| 上交所期权 | 40636 | 用重复的键值写记录失败 |     | Write the record failed with duplicate key |     |
| 上交所期权 | 40638 | BIL 初始化失败 |     | BIL initialize failure |     |
| 上交所期权 | 40640 | 不能从BIL取得数据: isin= |     | Can not get data from BIL |     |
| 上交所期权 | 40642 | 无效的产品状态 |     | Invalid instrument state |     |
| 上交所期权 | 40652 | Post Matcher打开文件失败 |     | Post Matcher failed to open file |     |
| 上交所期权 | 40666 | 创建路由表共享内存区域失败 |     | Failed to create the routing table shared memory |     |
| 上交所期权 | 40668 | 加入路由表共享内存区域失败 |     | Failed to attach to the routing table shared memory |     |
| 上交所期权 | 40670 | 更新路由表共享内存区域失败 |     | Failed to update the routing table shared memory |     |
| 上交所期权 | 40672 | 从路由表共享内存区域获取数据失败 |     | Failed to get data from the routing table shared memory |     |
| 上交所期权 | 40674 | 创建连接表共享内存区域失败 |     | Failed to create the connection table shared memory |     |
| 上交所期权 | 40676 | 加入连接表共享内存区域失败 |     | Failed to attach to the connection table shared memory |     |
| 上交所期权 | 40678 | 更新连接表共享内存区域失败 |     | Failed to update the connection table shared memory |     |
| 上交所期权 | 40680 | 从连接表共享内存区域获取数据失败 |     | Failed to get data from the connection table shared memory |     |
| 上交所期权 | 40682 | 创建消息缓存失败 |     | Failed to attach to the message cache |     |
| 上交所期权 | 40684 | 加入消息缓存失败 |     | Failed to create the message cache |     |
| 上交所期权 | 40696 | 未知的进程类型: <> |     | Unknown process type |     |
| 上交所期权 | 40704 | 位向量中未找到对应位 |     | Failed to find bit in the bit vector |     |
| 上交所期权 | 40706 | 释放订单失败 |     | Failed to free order, slot no %u |     |
| 上交所期权 | 40708 | 调用MALLOC失败 |     | Call to MALLOC failed |     |
| 上交所期权 | 40710 | 无效的撮合优先权 |     | Invalid matching priority |     |
| 上交所期权 | 40716 | 无法取得消息缓存中已使用的槽的数量 |     | Failed to get the number of used slots in the message cache |     |
| 上交所期权 | 40718 | 无法取得消息缓存中槽的总数 |     | Failed to get the total number of slots in the message cache |     |
| 上交所期权 | 40720 | 转换锁失败 |     | Error converting lock |     |
| 上交所期权 | 40740 | 无效的指令代码 |     | Invalid maintenance code for matcher library |     |
| 上交所期权 | 40746 | 序列号已经存在于序列号文件之中 |     | The sequence number already exists in the file, and rec is filled with the record |     |
| 上交所期权 | 40758 | ISIX号错误 |     | Invalid ISIX code |     |
| 上交所期权 | 40770 | 批处理 |     | Toff_message |     |
| 上交所期权 | 40772 | 在操作锁的时候出错 |     | Enq error |     |
| 上交所期权 | 40780 | 收到无法识别的消息: 交易码= |     | Received an invalid transaction code |     |
| 上交所期权 | 40786 | 不能取得订单号 |     | Order number not found |     |
| 上交所期权 | 40788 | 不能取得文 |     | Unable to get file handle |     |
| 上交所期权 | 40796 | 集合竞价标志 %c 错误 |     | Invalid auction flag |     |
| 上交所期权 | 40802 | 创建缓冲池失败 |     | Fail to create a buffer pool |     |
| 上交所期权 | 40804 | 无效的缓冲池指针 |     | Invalid buffer pool handle |     |
| 上交所期权 | 40806 | 分配系统存储失败 |     | Fail to allocate system memory |     |
| 上交所期权 | 40828 | 请求的槽号超过了最大值 |     | The requested slot no exceed the maximum |     |
| 上交所期权 | 40832 | 向共享内存写记录失败 |     | Write the record into the shared memory failed |     |
| 上交所期权 | 40840 | dta_init_table 出错: 表= |     | Error executing dta_init_table |     |
| 上交所期权 | 40842 | dta_read_first_rec 出错: 表= |     | Error executing dta_read_first_rec |     |
| 上交所期权 | 40844 | dta_read_next_rec 出错: 表= |     | Error executing dta_read_next_rec |     |
| 上交所期权 | 40852 | 指定的AVL树中存在重复的键值 |     | Duplicate keys exist in the specified AVL tree |     |
| 上交所期权 | 40854 | 链表中存在重复的对象 |     | Duplicate objects in linked list |     |
| 上交所期权 | 40864 | 无效的堆索引号 |     | Invalid index for a heap structure |     |
| 上交所期权 | 40874 | 读取BIL记录失败 |     | Fail to get record from BIL |     |
| 上交所期权 | 40878 | 无效的键获取函数 |     | Invalid get key function for linked list |     |
| 上交所期权 | 40880 | 无效的键比较函数 |     | Invalid key comparison function for linked list |     |
| 上交所期权 | 40882 | 无效的对象比较函数 |     | Invalid object comparison function for linked list |     |
| 上交所期权 | 40884 | 无效的链表排序类型 |     | Invalid sort type for linked list |     |
| 上交所期权 | 40886 | 无效的工作日期符号 |     | Invalid business day |     |
| 上交所期权 | 40888 | 元素已经存在链表中 |     | Item already exists in linked list |     |
| 上交所期权 | 40892 | 元素不属于链表 |     | Item doesn't belong to linked list |     |
| 上交所期权 | 40898 | 对象不在链表中 |     | Object is not in linked list |     |
| 上交所期权 | 40908 | 从FPALSLST读取节点别名失败 |     | Failed to get node alias from FPALSLST |     |
| 上交所期权 | 40910 | FPALSLST中未定义任何交易主机集群的节点别名 |     | There is no trading cluster node alias defined in FPALSLST |     |
| 上交所期权 | 40916 | 输入的集合或者类型无效 |     | Input set or type is invalid |     |
| 上交所期权 | 40930 | 无法更新FPCFG: 关键字= |     | Unable to update item in FPCFG |     |
| 上交所期权 | 40934 | dta_insert_rec 出错: 表= |     | Error executing dta_insert_rec |     |
| 上交所期权 | 40936 | dta_delete_table 出错 |     | Error executing dta_delete_table |     |
| 上交所期权 | 40938 | 订单薄文件没有打开 |     | Order book file is not open |     |
| 上交所期权 | 40940 | 读订单薄文件错误: set= |     | Orderbook file read error |     |
| 上交所期权 | 40946 | 订单薄中MMQI无法找到 |     | Order book MMQI entry not found |     |
| 上交所期权 | 40952 | 产品不存在 |     | Error instrument not available |     |
| 上交所期权 | 40954 | BILLIB没有初始化 |     | BILLIB not initialization |     |
| 上交所期权 | 40956 | BILLIB致命错误 |     | BILLIB fatal error |     |
| 上交所期权 | 40958 | BILLIB锁错误 |     | BILLIB lock error |     |
| 上交所期权 | 40962 | 订单薄BAM数量键没有找到 |     | BAM qty key not found |     |
| 上交所期权 | 40970 | 内部链表中没有储存确认消息 |     | No confirmed message left in the internal link list |     |
| 上交所期权 | 40972 | 取配置参数失败 |     | Get configuration failed |     |
| 上交所期权 | 40974 | 未知消息类型 |     | Unknown transaction code |     |
| 上交所期权 | 40978 | 固定价格订单无价格领先者 |     | No price leader for a fixed price order |     |
| 上交所期权 | 40980 | 订单簿无效集合 |     | Invalid set id for order book library |     |
| 上交所期权 | 40982 | 订单簿输入缓冲不足 |     | Not enough input buffer for order book library |     |
| 上交所期权 | 40984 | 更新投资者持仓失败: 投资者帐号= |     | Failed to update investor holding |     |
| 上交所期权 | 40986 | 获得投资者持仓数据位置失败 |     | Failed to get investor holding position |     |
| 上交所期权 | 40990 | 静态链表无效的控制信息 |     | Invalid control information for static linked list |     |
| 上交所期权 | 40992 | 静态链表无效的根地址 |     | Invalid root address for static linked list |     |
| 上交所期权 | 40994 | 静态链表无效的槽尺寸 |     | Invalid slot size for static linked list |     |
| 上交所期权 | 40996 | 静态链表无效的偏移量 |     | Invalid offset values for static linked list |     |
| 上交所期权 | 40998 | 链表中发现重复的键值 |     | Find duplicate keys in the linked list |     |
| 上交所期权 | 41000 | 槽编号无效的指针 |     | Null pointer for the slot ID |     |
| 上交所期权 | 41002 | 换页文件无效的读/写函数 |     | Invalid read/write function for memory file |     |
| 上交所期权 | 41008 | 无效的产品集合: 集合编号= |     | Invalid set ID |     |
| 上交所期权 | 41018 | 输入的集合号码无效 |     | Input set ID is invalid |     |
| 上交所期权 | 41022 | 无效的事务类型 |     | Invalid transaction type |     |
| 上交所期权 | 41024 | 从Fnunder中读取相应的ISIX失败: isix= |     | Failed to read the corresponding ISIX from Fnunder |     |
| 上交所期权 | 41026 | 无足够的内存读取Fnunder |     | No memory to read Fnunder |     |
| 上交所期权 | 41028 | 在Fnunder中无更多的记录 |     | No more record from Fnunder |     |
| 上交所期权 | 41030 | 无效交易量计算方法 %c |     | Invalid trade value calculation method |     |
| 上交所期权 | 41034 | 创建PBU ID索引内存区域失败 |     | Fail to create the PBU IDs index shared memory |     |
| 上交所期权 | 41038 | 找不到适合条件的帧 |     | Can not find such frame |     |
| 上交所期权 | 41040 | 请首先调用初始化函数 |     | Should call SecLibInit first |     |
| 上交所期权 | 41042 | 安全库初始化失败 |     | Fail to initialize security library |     |
| 上交所期权 | 41044 | 信息加密失败 |     | Fail to encrypt the message |     |
| 上交所期权 | 41046 | 信息解密失败 |     | Fail to decrypt the message |     |
| 上交所期权 | 41048 | 安全身份认证失败 |     | Identity Authentication failed |     |
| 上交所期权 | 41054 | 重复的进程号: 进程号= |     | Duplicate PID in the frame |     |
| 上交所期权 | 41058 | 设置Shell定时器错误 |     | Set shell timer error |     |
| 上交所期权 | 41064 | 批处理 |     | TOFF_MESSAGE |     |
| 上交所期权 | 41066 | 批处理 |     | TOFF_MESSAGE |     |
| 上交所期权 | 41070 | 无效的集合号: 集合号= |     | Invalid set |     |
| 上交所期权 | 41074 | 打开加密/解密的RMS格式输入文件出错 |     | Error opening the input RMS file |     |
| 上交所期权 | 41076 | 打开加密/解密的二进制输入文件出错 |     | Error opening the input binary file |     |
| 上交所期权 | 41078 | 关闭加密/解密的RMS格式输出文件出错 |     | Error closing the input RMS file |     |
| 上交所期权 | 41082 | 打开文件出错 |     | Open the file error |     |
| 上交所期权 | 41084 | 动态分配内存出错 |     | Allocate memory error |     |
| 上交所期权 | 41094 | 访问Bil库出错 |     | Access the bil library error |     |
| 上交所期权 | 41106 | 读文件出错 |     | Read the file error |     |
| 上交所期权 | 41108 | 不能和本地组互锁 |     | Can not interlock in local group |     |
| 上交所期权 | 41110 | 无法获取自己的逻辑名 |     | Can not determine my own logical name |     |
| 上交所期权 | 41112 | 这个节点不是CS: 节点= |     | This node is not a Communication Server |     |
| 上交所期权 | 41114 | 无法获取Area Type |     | Can not determine Area Type |     |
| 上交所期权 | 41116 | 错误的Area Type |     | Wrong Area Type |     |
| 上交所期权 | 41118 | 无效参数 |     | Invalid parameter |     |
| 上交所期权 | 41120 | 不能初始化全局消息空间 |     | Could not initialize Global Message Section |     |
| 上交所期权 | 41122 | 定义邮箱出错 |     | Error defining the Mailbox |     |
| 上交所期权 | 41124 | 连接邮箱出错 |     | Error connecting the Mailbox |     |
| 上交所期权 | 41126 | 读邮箱出错 |     | Error reading the Mailbox |     |
| 上交所期权 | 41128 | 写邮箱出错 |     | Error writing the Mailbox |     |
| 上交所期权 | 41130 | 申请全局消息槽出错: 消息槽= |     | Error requesting a global slot ID |     |
| 上交所期权 | 41132 | 释放全局消息槽出错 |     | Error releasing a global slot |     |
| 上交所期权 | 41136 | MIL 库锁操作出错 |     | MIL library lock error |     |
| 上交所期权 | 41142 | 无法在互锁 |     | Can not interlock in |     |
| 上交所期权 | 41144 | 无法初始化 |     | Can not initiate |     |
| 上交所期权 | 41146 | 无法得到自己的逻辑名 |     | Can not determine my own logical name |     |
| 上交所期权 | 41148 | 本节点不是一个主机设备或者外部接口 |     | This node is not a Host Device or an External Interface |     |
| 上交所期权 | 41150 | 无法得到自己的区域类型 |     | Can not determine my area type |     |
| 上交所期权 | 41152 | 无法得到自己的主机集群名 |     | Can not find out my cluster name |     |
| 上交所期权 | 41156 | 无法以exclusive模式得到广播锁 |     | Can not get the broadcast lock in exclusive mode |     |
| 上交所期权 | 41158 | 节点的信息不是TCP: 节点= |     | Node physical info is not TCP |     |
| 上交所期权 | 41160 | 无法得到主机列表 |     | Can not determine host list |     |
| 上交所期权 | 41162 | 无法在FLEXLINK内创建 |     | Can not create in FLEXLINK |     |
| 上交所期权 | 41164 | 无法在FPARCH中找到全局参数 |     | No global section in FPARCH |     |
| 上交所期权 | 41166 | 在FPARCH中得到无效的全局参数 |     | Invalid global section in FPARCH |     |
| 上交所期权 | 41168 | 无法创建邮箱 |     | Error creating mailbox |     |
| 上交所期权 | 41170 | 无法在FPARCH找到最大弹回值 |     | No maximum bounce section in FPARCH |     |
| 上交所期权 | 41172 | 在FPARCH中最大弹回值非正值 |     | Maximum bounce setting in FPARCH is non-positive, using default of instead |     |
| 上交所期权 | 41174 | 定义TCPIP网络设备出错 |     | Error defining TCPIP network defining device |     |
| 上交所期权 | 41176 | 配置自己的网络对象的DAR出错 |     | Error configuring own network object's DAR |     |
| 上交所期权 | 41178 | 预设置TCPIP网络监听方出错 |     | Error presetting listener on TCPIP network |     |
| 上交所期权 | 41182 | 收到非法的连接请求 |     | Illegal connection request from, request aborted |     |
| 上交所期权 | 41184 | 将来自节点的暂时请求方的读取动作排入队列出错 |     | Error queueing a read for temporary caller on node |     |
| 上交所期权 | 41186 | 节点在连接时超时 |     | Node has timed out during connection |     |
| 上交所期权 | 41188 | 预约消息缓存槽失败 |     | Failed to reserve a slot |     |
| 上交所期权 | 41190 | 读取连接表失败 |     | Failed to read the connection table |     |
| 上交所期权 | 41192 | 从网络收到错误的事务代码 |     | Wrong transaction code received from the network |     |
| 上交所期权 | 41194 | 从邮箱收到错误的事务代码 |     | Wrong transaction code received from the mailbox |     |
| 上交所期权 | 41196 | 收到错误的确认消息事务代码 |     | Wrong confirmed message transaction code received |     |
| 上交所期权 | 41198 | 写邮箱出错 |     | Error writing to the mailbox |     |
| 上交所期权 | 41200 | %lu个消息缓存槽已加载 |     | Message Cache slots allocated |     |
| 上交所期权 | 41202 | 将自己声明为TCPIP网络对象出错 |     | Error declaring myself as TCPIP network object |     |
| 上交所期权 | 41204 | 在TCPIP网络上配置监听方出错 |     | Error configuring listener on TCPIP network |     |
| 上交所期权 | 41206 | 尝试监听TCPIP网络出错 |     | Error attempting to listen to TCPIP network |     |
| 上交所期权 | 41210 | 网络关闭 |     | Network shutting down |     |
| 上交所期权 | 41212 | 无法为未知的远程发起方分配临时链接记录 |     | Can not allocate temporary link record for unknown remote caller |     |
| 上交所期权 | 41214 | 无法为未知的远程发起方定义网络设备 |     | Can not define network device for unknown remote caller |     |
| 上交所期权 | 41216 | 无法接受未知远程发起方 |     | Can not accept unknown remote caller. Request rejected |     |
| 上交所期权 | 41218 | 配置进入的TCPIP网络对象出错 |     | Error configuring incoming TCPIP network object |     |
| 上交所期权 | 41220 | 解密文件时发现错误的交易日 |     | Invalid business day detected while decrypting file |     |
| 上交所期权 | 41222 | 连接时读取节点出错 |     | Read error from node during connection |     |
| 上交所期权 | 41224 | 来自节点的非法链接 |     | Intrusion from node |     |
| 上交所期权 | 41226 | 节点丢失 |     | Node thinks I am logical node |     |
| 上交所期权 | 41228 | 向我发出请求 |     | Node with device type has called me |     |
| 上交所期权 | 41230 | 已经连接! |     | Node already connected! |     |
| 上交所期权 | 41232 | 无法通过连接管理器检查 |     | Node failed ConMan validation |     |
| 上交所期权 | 41234 | 无法为节点分配链接表记录 |     | Can not allocate link table record for node |     |
| 上交所期权 | 41236 | 无法向新连接的HHCM发送登录确认 |     | Can not send login confirmation to new partner! |     |
| 上交所期权 | 41238 | 无法向新连接的HHCM发送连接表 |     | Can not send connection table to new partner! |     |
| 上交所期权 | 41240 | 将读取节点的动作插入队列失败 |     | Error down queuing read to node |     |
| 上交所期权 | 41242 | 从未连接的节点收到了消息 |     | Received message from not connected node |     |
| 上交所期权 | 41244 | 节点未连接，消息丢失 |     | Node is lost |     |
| 上交所期权 | 41246 | 无法向通知连接管理器已丢失 |     | Can not notify ConMan about loss of node! |     |
| 上交所期权 | 41254 | 错误的新广播主机 |     | Wrong New Broadcast Server! |     |
| 上交所期权 | 41256 | 在确认消息头中有错误的upDevId |     | Wrong upDevId is set in the confirmed message header |     |
| 上交所期权 | 41258 | 读取HHCM邮箱出错 |     | Error reading from HHCM Mailbox |     |
| 上交所期权 | 41260 | 将读取HHCM邮箱的动作插入队列失败 |     | Error queueing a read on the HHCM mailbox |     |
| 上交所期权 | 41262 | 从连接表共享内存区域读取中间节点号出错 |     | Error getting mid node number from the Connection Table Shared Memory |     |
| 上交所期权 | 41264 | 节点未知 |     | Error figuring out the node |     |
| 上交所期权 | 41266 | 从邮箱收到错误的消息类型 |     | Error message type received from the mailbox |     |
| 上交所期权 | 41268 | 条发往GSRT的消息被丢失 |     | Messages to GSRT have been lost |     |
| 上交所期权 | 41270 | 非法的HD中 |     | Invalid HD in message, message dropped |     |
| 上交所期权 | 41272 | 节点未连接，消息丢失 |     | Node not connected, message dropped |     |
| 上交所期权 | 41274 | 向节点进行写操作失败 |     | Error writing to node. \[IPCS return code |     |
| 上交所期权 | 41278 | 打开FPCONLST失败 |     | Error opening FPCONLST |     |
| 上交所期权 | 41280 | 启动更新FPCONLST的事务失败 |     | Error starting transaction to update FPCONLST |     |
| 上交所期权 | 41282 | 回滚FPCONLST失败 |     | Error rolling back FPCONLST |     |
| 上交所期权 | 41284 | 清空FPCONLST失败 |     | Error cleaning up FPCONLST |     |
| 上交所期权 | 41286 | 提交更新FPCONLST的事务失败 |     | Error committing transaction to update FPCONLST |     |
| 上交所期权 | 41288 | 定义一个HHCM的DAR出错 |     | Error defining one of the HHCMt's DAR |     |
| 上交所期权 | 41290 | 无法取得主机的地址 |     | Could not get the address for host |     |
| 上交所期权 | 41292 | 预设置监听TCPIP网络对象出错 |     | Error presetting listen TCPIP network object |     |
| 上交所期权 | 41294 | 在HHCM的DAR上配置本地绑定地址出错 |     | Error configuring local bind address on HHCM DAR |     |
| 上交所期权 | 41296 | 释放HHCM的DAR出错 |     | Error releasing the HHCM DAR |     |
| 上交所期权 | 41298 | 无法连接到主机 |     | Could not connect to host |     |
| 上交所期权 | 41300 | 配置监听TCPIP网络对象出错 |     | Error configuring listen TCPIP network object |     |
| 上交所期权 | 41302 | 无法发送登录数据到主机 |     | Could not send login data to host |     |
| 上交所期权 | 41304 | 无法读取其他HHCM的确认 |     | Error reading partner's confirmation |     |
| 上交所期权 | 41306 | 未从节点收到连接确认 |     | Did not receive the connection confirm from node |     |
| 上交所期权 | 41310 | 已建立到节点的连接 |     | Connection to has successfully been established! |     |
| 上交所期权 | 41312 | 我有安全问题 |     | I had security problems |     |
| 上交所期权 | 41314 | 无法从连接管理器接受信息 |     | Could not receive information from ConMan |     |
| 上交所期权 | 41316 | 无法接受中央主机集群的信息 |     | Could not receive information of the Central Cluster |     |
| 上交所期权 | 41318 | 无法接受本交易主机集群的信息 |     | Could not receive information of own Trading Cluster |     |
| 上交所期权 | 41320 | 我不是主机设备/对外接口设备 |     | I should not connect my partners, because I am nothing |     |
| 上交所期权 | 41322 | 呼叫连接管理器出错 |     | Error calling ConMan |     |
| 上交所期权 | 41324 | 连接管理器认为我有安全问题 |     | ConMan tells me I have security problems |     |
| 上交所期权 | 41326 | 丢失了所有到中央主机集群的连接 |     | I have lost all connections to the CC |     |
| 上交所期权 | 41328 | 加密/解密时写入文件失败 |     | Fail to write file during encryption / decryption |     |
| 上交所期权 | 41336 | 该消息发往本主机 |     | The message is for my own |     |
| 上交所期权 | 41338 | 来自网络的异步消息是发往节点 |     | The asynchronous message from network is for another node but not for me |     |
| 上交所期权 | 41340 | 没有定义访问文件的文件访问模式 |     | The file mode has not been defined for accessing file |     |
| 上交所期权 | 41342 | 恢复某进程的操作 |     | Restore frame |     |
| 上交所期权 | 41380 | 非法接口数据项: 文件= |     | Invalid interface file item |     |
| 上交所期权 | 41386 | 从消息缓存取得路由表更新消息出错 |     | Error getting the routing table updating message from the Message Cache |     |
| 上交所期权 | 41388 | 无法将路由表更新消息发送到新连接的HHCM |     | Error sending the routing table updating message to newly connected parnter |     |
| 上交所期权 | 41392 | 指定的文件不存在: 文件 = |     | Specified file does not exist |     |
| 上交所期权 | 41402 | asynlog缓存满 |     | The asynlog buffer is full |     |
| 上交所期权 | 41416 | 状态装换错误: 原始状态= |     | Change state error |     |
| 上交所期权 | 41434 | 交易确认数据没有找到 |     | TC record not found |     |
| 上交所期权 | 41450 | slot为空 |     | The slot number is empty |     |
| 上交所期权 | 41476 | 文件操作数列已满 |     | File operation array is full |     |
| 上交所期权 | 41482 | 记录被锁 |     | The record is locked |     |
| 上交所期权 | 41504 | 无效的产品: 产品= |     | Instrument not available |     |
| 上交所期权 | 41506 | 无效ETF定义文件: 文件= |     | Invd ETF def file |     |
| 上交所期权 | 41508 | 无效的ETF定义行: 行= |     | Invalid ETF definition line |     |
| 上交所期权 | 41516 | 非法的私有广播类型: bcastType= |     | Invalid the private broadcast type |     |
| 上交所期权 | 41522 | 产品关联数据初始化错误 |     | Instruments assignment table initialization fails |     |
| 上交所期权 | 41524 | 资源信息查找类型标志错误 |     | Resource information search flag error |     |
| 上交所期权 | 41550 | 集合ID是无效的: setId= |     | The set Id is not a valid real set |     |
| 上交所期权 | 41554 | 异步日志消息超出读缓存: 键值= |     | The asynlog message exceeds the read buffer |     |
| 上交所期权 | 41566 | 环缓冲区溢出 |     | Ring Buffer Overflow |     |
| 上交所期权 | 41568 | 环缓冲区使用到达上限 |     | Ring Buffer Threshold reached |     |
| 上交所期权 | 41570 | 未知错误 |     | Unspecied error |     |
| 上交所期权 | 41578 | 无消息在事件队列中 |     | No message in the event queue |     |
| 上交所期权 | 41580 | 无效的value block |     | Invalid value block |     |
| 上交所期权 | 41582 | 无效的产品集合状态在订单簿库中 |     | Invalid set status in orderbooklib |     |
| 上交所期权 | 41588 | 非交易类型与产品不匹配 |     | Non-trading order type does not match with instrument |     |
| 上交所期权 | 41600 | 无效参数 |     | Invalid input parameter |     |
| 上交所期权 | 41602 | 参数顺序错误 |     | Invalid input parameter sequence |     |
| 上交所期权 | 41604 | 未知标志 |     | Unknown copy direct flag |     |
| 上交所期权 | 41606 | FCF记录不完整 |     | Incomplete info in FCF record |     |
| 上交所期权 | 41608 | FCF静态记录部分不一致 |     | Inconsistent info in static part of FCF record |     |
| 上交所期权 | 41610 | FCF库未初始化 |     | FCF library not initialised |     |
| 上交所期权 | 41614 | dta_update_rec 出错: 表= |     | Error executing dta_update_rec |     |
| 上交所期权 | 41634 | 此日期不是有效工作日: isin = . |     | The date is not a workday |     |
| 上交所期权 | 41636 | 系统定时器错误 |     | System Timer Error |     |
| 上交所期权 | 41638 | 文件转化错误: 文件= |     | File Conversion Error |     |
| 上交所期权 | 41640 | 文件已关闭: 文件= |     | File has closed |     |
| 上交所期权 | 41642 | 不正确地读写: 模式= |     | Incorrect Read/Write |     |
| 上交所期权 | 41646 | 无效的文件句柄: 句柄= |     | Invalid File Handler |     |
| 上交所期权 | 41648 | 无效的分离标记: 标记= |     | Invalid Split Tag |     |
| 上交所期权 | 41650 | 达到最大处理范围 |     | Maximum Handler Reached |     |
| 上交所期权 | 41652 | 无法打开SPLITMETHODS_FILE |     | Unable to open SPLITMETHODS_FILE |     |
| 上交所期权 | 41654 | 无法打开文件: 文件= |     | Unable to open file |     |
| 上交所期权 | 41656 | 无法打开已分离文件: 文件= |     | Unable to open split file |     |
| 上交所期权 | 41658 | 不支持的文件模式: 模式= |     | Unsupported File Mode |     |
| 上交所期权 | 41660 | 不支持的文件寻址类型: 类型= |     | Unsupported location type |     |
| 上交所期权 | 41662 | 不支持的分离方法: 分离方法= |     | Unsupported split method |     |
| 上交所期权 | 41664 | Split Report Library实例数到达上限 |     | Split Report Library reach the max instance |     |
| 上交所期权 | 41666 | 在多进程模式处理时失败 |     | Processing failed during Multi-Instances mode |     |
| 上交所期权 | 41670 | ECL 加密失败 |     | ECL Encryption Failure |     |
| 上交所期权 | 41674 | ECL 压缩失败 |     | ECL Compression Failure |     |
| 上交所期权 | 41676 | ECL 解压失败 |     | ECL Decompression Failure |     |
| 上交所期权 | 41678 | ECL 库调用失败 |     | ECL Library Failure |     |
| 上交所期权 | 41694 | 数据转换溢出错误: 值= |     | Data conversion overflow |     |
| 上交所期权 | 41696 | 目标设备已满: 目标设备= |     | The receiving device is full |     |
| 上交所期权 | 41698 | 节点消息丢失. |     | Node exceeded OUTST limit |     |
| 上交所期权 | 41704 | 无效的投资者会员: 会员= |     | Invalid investor PBU |     |
| 上交所期权 | 41714 | HHCM的重传缓存区已满 |     | The retransmission buffer of HHCM is full |     |
| 上交所期权 | 41718 | 无效工作组: 组= |     | Invalid working set |     |
| 上交所期权 | 41722 | 查找文件头失败 |     | Seek to head failed |     |
| 上交所期权 | 41724 | 从   |     | Invalid number of items of record |     |
| 上交所期权 | 41726 | 在的记录中item重叠 |     | Items are duplicated in one record |     |
| 上交所期权 | 41732 | 退出取锁队列时出错 |     | Failed to dequeue the lock |     |
| 上交所期权 | 41734 | 文件名错误 |     | The filename is wrong |     |
| 上交所期权 | 41736 | 将写入的RRN小于最大RRN |     | The RRN to be written is less than the last RRN |     |
| 上交所期权 | 41742 | 发送消息的时候事务尚未关闭 |     | Recovery unit still open when sending messages |     |
| 上交所期权 | 41744 | 未找到进程 |     | Monitored process missing |     |
| 上交所期权 | 41746 | 未找到进程: 进程= |     | Monitored process missing |     |
| 上交所期权 | 41768 | 无效的产品代码 |     | Invalid isin code |     |
| 上交所期权 | 41784 | ETF文件传输失败:状态= |     | ETF file transfer fails |     |
| 上交所期权 | 41786 | 重复槽被置于缓冲池中: |     | Duplicate slot returned to pool |     |
| 上交所期权 | 41788 | 准备释放已占用的槽 |     | Trying to free not reserved slot |     |
| 上交所期权 | 41790 | 输入的节点非节点别名 |     | The input node is not an alias |     |
| 上交所期权 | 41792 | 无法得到节点别名信息 |     | Can not get the node alias |     |
| 上交所期权 | 41796 | 由于消息缓存即将填满 |     | Message Cache nearly full |     |
| 上交所期权 | 41798 | 持仓空间满 |     | Investor holding area full |     |
| 上交所期权 | 41800 | 持仓位置错误 |     | Holding position error |     |
| 上交所期权 | 41804 | 产品！ |     | RondLotQty |     |
| 上交所期权 | 41812 | 无法加载所有 |     | Error getting node alias for alles |     |
| 上交所期权 | 41814 | 无法加载所有 |     | Error getting node alias for alles |     |
| 上交所期权 | 41816 | 无法启动Node Services |     | Error start up Node Services. Node services return code |     |
| 上交所期权 | 41818 | 2个进程 |     | Two processes modify memory file simultaneously |     |
| 上交所期权 | 41820 | 内存可用工作页面不足 |     | Not enough free working page |     |
| 上交所期权 | 41822 | 读入的记录的数量 |     | The read-in number of records exceeds the number pre-allocated |     |
| 上交所期权 | 41844 | secSize= |     | secSize |     |
| 上交所期权 | 41866 | 无法以独占模式得到CH启动锁 |     | can not get the first CH lock in exclusive mode |     |
| 上交所期权 | 41878 | 使用了非法的PBU ID |     | Invalid PBU is used |     |
| 上交所期权 | 41882 | 更新失败 |     | Holding update failed |     |
| 上交所期权 | 41884 | 更新持仓失败%llu |     | Update holding failed |     |
| 上交所期权 | 41886 | 读文件出错 |     | Read the file error |     |
| 上交所期权 | 41892 | 错误的操作类型:类型= |     | Error process type |     |
| 上交所期权 | 41900 | 产品) |     | Found mis-match between isix and set (correct set ) |     |
| 上交所期权 | 41902 | IPCS警告 |     | IPCS WARNING |     |
| 上交所期权 | 41904 | IPCS信息 |     | IPCS INFORMATION |     |
| 上交所期权 | 41906 | IPCS错误 |     | IPCS ERROR |     |
| 上交所期权 | 41908 | IPCS严重错误 |     | IPCS FATAL ERROR |     |
| 上交所期权 | 41914 | 读取FPSYNSTS记录出错 |     | Error get FPSYNSTS record |     |
| 上交所期权 | 41916 | 更新FPSYNSTS记录出错 |     | Error update FPSYNSTS record |     |
| 上交所期权 | 41922 | 消息包内没有足够的空间 |     | Not enough space for a message in package |     |
| 上交所期权 | 41924 | 所给消息与网络消息包不匹配 |     | Given message is not compatible with network package |     |
| 上交所期权 | 41928 | 消息包中已为空 |     | No further messages in package |     |
| 上交所期权 | 41930 | 不能压缩该字段 |     | Can not pack field |     |
| 上交所期权 | 41934 | 找不到与该请求ID匹配的交易码 |     | TxnCod for RID is not found |     |
| 上交所期权 | 41994 | 持仓内存槽位越界 |     | Holding memory slot slop over |     |
| 上交所期权 | 41996 | 架构技术重传列表内存槽位越界 |     | Technical completion list memory slot slop over=%04d |     |
| 上交所期权 | 41998 | 指定交易取消内存槽位越界 |     | DTC memory slot slop over=%04d |     |
| 上交所期权 | 42004 | 复制文件出错: src file = est file = |     | copy file fail |     |
| 上交所期权 | 42006 | 事务数 的超过最大限额 |     | The transaction count of memory file exceeds limitation |     |
| 上交所期权 | 42020 | 字段  |     | Overflow parameter |     |
| 上交所期权 | 42086 | 后台通用错误:: |     | Backend general err |     |
| 上交所期权 | 44006 | CPCM 路由表初始化错误 |     | Ini CPCM RTL ERR |     |
| 上交所期权 | 44008 | CPCM 共享内存初始化错误 |     | Ini CPCM Share Memory ERR |     |
| 上交所期权 | 44012 | CPCM 读取消息内存错误 |     | Get CPCM Msg Cache ERR |     |
| 上交所期权 | 44014 | CPCM 写入消息内存错误 |     | Sav CPCM Msg Cache ERR |     |
| 上交所期权 | 44018 | CPCM 路由表操作错误 |     | CPCM RTL ERR |     |
| 上交所期权 | 44022 | CPCM 连接错误 |     | CPCM conncetion FATAL ERR, may need manual recon |     |
| 上交所期权 | 44024 | CPCM 连接异常错误 |     | CPCM connection abnormal ERR |     |
| 上交所期权 | 44026 | CPCM 连接不完全错误 |     | CPCM connection mismatch |     |
| 上交所期权 | 44028 | CPCM ?? |     | CPCM init connetion ERR |     |
| 上交所期权 | 44030 | CPCM 消息处理错误 |     | CPCM proc msg ERR |     |
| 上交所期权 | 44032 | CPCM 共享队列初始化错误 |     | CPCM Init Share Queue ERR |     |
| 上交所期权 | 44034 | CPCM 共享队列严重错误 |     | CPCM Share FAT ERR |     |
| 上交所期权 | 44036 | CPCM 共享队列错误 |     | CPCM Share Queue ERR |     |
| 上交所期权 | 44038 | CPCM 重传队列初始化错误 |     | CPCM Msg Queue ERR |     |
| 上交所期权 | 48018 | 更新持仓事务失败 |     | Update holding fail |     |
| 上交所期权 | 48030 | EZOES 参考文件压缩中: 流已满 |     | EZ ngtsref data compress |     |
| 上交所期权 | 48032 | EZOES 参考文件为空 |     | EZ ngtsref data is empty |     |
| 上交所期权 | 48034 | EZ参考文件中的日期不是当前交易日期 |     | The date in ezrefdata is not the current business date |     |
| 上交所期权 | 48036 | 无法从参考文件获取交易日期 |     | Can not get busdate from refdata |     |
| 上交所期权 | 48038 | 架构功能重传列表内存槽位越界 |     | Functional completion list memory slot slop over |     |
| 上交所期权 | 48040 | 技术重传内存区已满 |     | Technical completion list area full |     |
| 上交所期权 | 48042 | 功能重传内存区已满 |     | Functional completion list area full |     |
| 上交所期权 | 48044 | DTC标志位内存区已满 |     | DTC indicator area full |     |
| 上交所期权 | 48058 | 重复的持仓记录 |     | Duplicate Invest Holding Record |     |
| 上交所期权 | 48066 | 无法计算ISIN校验位 |     | Can not calculate isin checksum |     |
| 上交所期权 | 48078 | Matcher异常 |     | MatchErr |     |
| 上交所期权 | 48104 | 配置值为空 |     | Config value is null |     |
| 上交所期权 | 48112 | 短TC数据 |     | VSTcErr |     |
| 上交所期权 | 48122 | 订单薄处理中有需要paging的slot: set= |     | Orderbook paging slot |     |
| 上交所期权 | 48128 | Matcher 应用错误 |     | Matcher application error |     |
| 上交所期权 | 48130 | Matcher 数据错误 |     | Matcher application data error |     |
| 上交所期权 | 48134 | 持仓类型溢出: |     | Holding Type's index |     |
| 上交所期权 | 48136 | 持仓类型名称不正确. |     | Holding Type's name is not correct |     |
| 上交所期权 | 48142 | 写数据到文件错误 |     | Flush data to file error |     |
| 上交所期权 | 48144 | Matcher 订单向量错误 |     | Matcher ordrVct err |     |
| 上交所期权 | 48148 | std_io_error |     | Std_io_error |     |
| 上交所期权 | 48150 | 最优订单isix不匹配 |     | Best order isix mis-match |     |
| 上交所期权 | 48158 | 撮合非法数据 |     | Matcher invalid data |     |
| 上交所期权 | 48162 | HROM异步事务请求异常 |     | HROM asyn req process error |     |
| 上交所期权 | 48168 | 创建共享内存 |     | SHM is created |     |
| 上交所期权 | 48170 | 校验文件失败 |     | CHECK FILE FAILD |     |
| 上交所期权 | 48184 | 库 未初始化. |     | Library is not initialised |     |
| 上交所期权 | 48188 | 架构错误 |     | Architectural error |     |
| 上交所期权 | 48190 | 批处理 |     | TOFF_MESSAGE |     |
| 上交所期权 | 48192 | 批处理 |     | TOFF_MESSAGE |     |
| 上交所期权 | 48194 | 批处理 |     | TOFF_MESSAGE |     |
| 上交所期权 | 48204 | 分配内存失败 |     | FAIL TO ALLOC MEM |     |
| 上交所期权 | 48216 | 传入参数不正确 |     | PARAM IS INCORRECT |     |
| 上交所期权 | 48218 | 该域是无效域 |     | FIELD IS INVALID |     |
| 上交所期权 | 48238 | 无效的枚举类型数值 |     | ENUM VALUE IS INVALID |     |
| 上交所期权 | 48248 | 内存状态非法: |     | Invalid mem Status |     |
| 上交所期权 | 48250 | 设置内存状态非法 |     | Set MemStatus Invalid |     |
| 上交所期权 | 48252 | 属性标签错误: |     | Property tag error |     |
| 上交所期权 | 48254 | 属性名称错误: |     | Property name error |     |
| 上交所期权 | 48256 | 达到容量上限 |     | Reached volume limit |     |
| 上交所期权 | 48258 | checksum错误 |     | Checksum error |     |
| 上交所期权 | 48260 | 索引位置有误: |     | Pos info invalid |     |
| 上交所期权 | 48262 | 达到遍历尾部 |     | Reached end of iteration |     |
| 上交所期权 | 48264 | 内存句柄错误 |     | Invalid memHandle |     |
| 上交所期权 | 48266 | ERR_NOT_FOUND |     | ERR_NOT_FOUND |     |
| 上交所期权 | 48268 | 映射错误 |     | Mapping errorPos |     |
| 上交所期权 | 48270 | 重复记录 |     | Duplicated records |     |
| 上交所期权 | 48272 | Dump错误 |     | Dump error |     |
| 上交所期权 | 48274 | Load 错误 |     | Load error |     |
| 上交所期权 | 48276 | 重复键值 |     | Duplicated keys |     |
| 上交所期权 | 48278 | 写入长度有误 |     | Invalid dataLen |     |
| 上交所期权 | 48280 | 索引区已读空 |     | Idx area empty for read |     |
| 上交所期权 | 48282 | share queue满 |     | Share queue full |     |
| 上交所期权 | 48284 | 文件句柄未初始化 |     | File handle not init |     |
| 上交所期权 | 48286 | 空指针 |     | Null pointer detected |     |
| 上交所期权 | 48288 | 超过进程权限数量上限 |     | Exceeded max auth record number |     |
| 上交所期权 | 48290 | 配置信息错误 |     | Config item error |     |
| 上交所期权 | 48292 | 索引类型错误 |     | Index type error |     |
| 上交所期权 | 48294 | 文件格式错误 |     | File format error |     |
| 上交所期权 | 48296 | 文件类型错误 |     | File type error |     |
| 上交所期权 | 48298 | 应用路由管理库未初始化 |     | Message routing lib not init |     |
| 上交所期权 | 48300 | 设置业务状态错误 |     | Set business status error |     |
| 上交所期权 | 48302 | 非法参数值: |     | Invalid parameter value |     |
| 上交所期权 | 48304 | 非法内存名值: |     | Invalid shmName value |     |
| 上交所期权 | 48306 | 非法读取操作 |     | Invalid read |     |
| 上交所期权 | 48308 | 索引已被删除 |     | Index already deleted |     |
| 上交所期权 | 48310 | 非法内存名称 |     | Invalid memname |     |
| 上交所期权 | 48312 | 超过shrq数量上限 |     | Exceed max number of shrq |     |
| 上交所期权 | 48314 | shrq不存在 |     | Shrq doesn't exist |     |
| 上交所期权 | 48316 | shrq空间不足 |     | No enough slots of shrq |     |
| 上交所期权 | 48318 | shrq事务已经存在 |     | Transaction of shrq existed |     |
| 上交所期权 | 48322 | 达到数量上限: |     | Reached max cnt |     |
| 上交所期权 | 48324 | 节点不存在: |     | Node not existed |     |
| 上交所期权 | 48326 | 非法设置set: |     | Invalid set |     |
| 上交所期权 | 48328 | 试图删除特殊节点 |     | Try to delete -1, invalid |     |
| 上交所期权 | 48332 | 非法内存操作: |     | Invalid mem operation |     |
| 上交所期权 | 48336 | 非法业务状态 |     | Invalid status |     |
| 上交所期权 | 48338 | 非法路由表节点 |     | Invalid RoutingTable |     |
| 上交所期权 | 48340 | 非法节点: |     | Invalid NodeId |     |
| 上交所期权 | 48342 | shrq读者数目无效:%u |     | Invalid reader num for shrq |     |
| 上交所期权 | 48344 | shrq写者或锁配置有误: %u |     | Invalid writer num for shrq |     |
| 上交所期权 | 48346 | 记录重演结束 <> |     | Total records replay finished |     |
| 上交所期权 | 48348 | FTRDRLOG日期为<> 刷新至当前业务日期 |     | FTRDRLOG with Date<> refresh to Current Date |     |
| 上交所期权 | 48350 | 需要重传的部分消息不存在 |     | Some of Resend msgs are not exist |     |
| 上交所期权 | 48352 | AppResub库未初始化 |     | App Resub library not initialised |     |
| 上交所期权 | 48354 | 无效的参数值 |     | Invalid parameter value |     |
| 上交所期权 | 48356 | 无效的价格单位 |     | Invalid unit of price |     |
| 上交所期权 | 48358 | 无效的最小数量单位 |     | Invalid round lot unit of quantiy |     |
| 上交所期权 | 48360 | 产品有错 |     | Instrument configure suspension time error |     |
| 上交所期权 | 48362 | 产品有错 |     | Instrument configure unsuspension time error |     |
| 上交所期权 | 48364 | 业务有错 |     | Business Type configure start time or end time error |     |
| 上交所期权 | 48368 | 设置的停牌时间不允许大于复牌时间 |     | Suspension time not allow more then unsuspension time |     |
| 上交所期权 | 48370 | 更新标志的值不是Y或N |     | Input upd flag is not Y or N |     |
| 上交所期权 | 48374 | Key没有找到 |     | Key not found |     |
| 上交所期权 | 48376 | Rec没有找到 |     | Rec not found |     |
| 上交所期权 | 48378 | 非法的keytag: |     | Invalid keytag |     |
| 上交所期权 | 48380 | 工作页面中无IRA记录 |     | No IRA record in working page |     |
| 上交所期权 | 48382 | 无工作页面 |     | No working page |     |
| 上交所期权 | 48384 | 工作页面中无数据 |     | No data in working page |     |
| 上交所期权 | 48386 | 工作页面中没有可读数据 |     | Nothing to read in working page |     |
| 上交所期权 | 48388 | 工作页面中没有日志文件数据 |     | No log file data in working page |     |
| 上交所期权 | 48390 | 无初始Block |     | No init block |     |
| 上交所期权 | 48392 | 无效的工作页面类型 |     | Invalid working page type |     |
| 上交所期权 | 48394 | 工作页面未初始化 |     | Working page not initialized |     |
| 上交所期权 | 48396 | 回调函数未定义 |     | Not defined callback function |     |
| 上交所期权 | 48398 | 无效数据 |     | Invalid Data |     |
| 上交所期权 | 48400 | 不连续的IRA号 |     | Inconsistent IRA ID |     |
| 上交所期权 | 48402 | 不连续的工作页面号 IRA |     | Inconsistent working page ID |     |
| 上交所期权 | 48404 | 工作页面指针为空 |     | Working page pointer is null |     |
| 上交所期权 | 48406 | 无效的IO类型 |     | Invalid IO type |     |
| 上交所期权 | 48408 | 超出重演IRA号 输入 |     | Exceed replicated IRA Input |     |
| 上交所期权 | 48410 | 当前未开始事务 |     | No Txn started |     |
| 上交所期权 | 48412 | 没有日志文件初始化 |     | No file to initialize |     |
| 上交所期权 | 48414 | 当前事务无日志数据 |     | Missing log page in txn |     |
| 上交所期权 | 48416 | 当前IO模式不在写模式 |     | Not in write IO mode |     |
| 上交所期权 | 48418 | 文件指针为空 |     | File point is null |     |
| 上交所期权 | 48420 | 当前IRA已递交 |     | IRA already committed |     |
| 上交所期权 | 48422 | 递交的IRA无效 |     | Invalid IRA for commit |     |
| 上交所期权 | 48424 | AppShl未初始化 |     | Appshl not initialized |     |
| 上交所期权 | 48426 | 定时器注册已满 |     | Appshl Full timer registed |     |
| 上交所期权 | 48428 | 环形队列已满 |     | Appshl Full ring buffer |     |
| 上交所期权 | 48432 | 无效的消息队列类型 |     | Invalid message queue type |     |
| 上交所期权 | 48434 | setid无效 |     | Invalid setid |     |
| 上交所期权 | 48438 | 广播状态切换 |     | Broadcast State Changes |     |
| 上交所期权 | 48442 | 广播状态切换未就绪 |     | Broadcast State not ready |     |
| 上交所期权 | 48444 | 内存尚未就绪: |     | Memory not ready |     |
| 上交所期权 | 48446 | 交易时间表库未初始化 |     | trading schedule lib not initialized |     |
| 上交所期权 | 48448 | 对 set 没有WP写权限 |     | No WP write privilege for set |     |
| 上交所期权 | 48450 | 消息 无效 |     | Message Txn order number invalid |     |
| 上交所期权 | 48452 | WP写入数据长度无效 |     | WP write data length is invalid |     |
| 上交所期权 | 48454 | WP写入数据类型无效 |     | WP write data code is invalid |     |
| 上交所期权 | 48456 | 无效的内部数组句柄: 句柄= |     | Invalid internal handler for array |     |
| 上交所期权 | 48458 | 节点在Common Hash的链表中不存在 |     | Item is not found in the list of Common Hash |     |
| 上交所期权 | 48460 | 节点在Common Hash的链表中已存在 |     | Item already exists in the list of Common Hash |     |
| 上交所期权 | 48462 | 链表功能不可用 |     | List function is inavailable for Common Hash |     |
| 上交所期权 | 48464 | 此订单簿不支持协商交易 |     | Negotiate trade is not support for this order book |     |
| 上交所期权 | 48466 | IraWp 所有Ira记录耗尽 |     | No more free ira entry for set |     |
| 上交所期权 | 48468 | IraWp 所有WP耗尽 |     | No more free working page |     |
| 上交所期权 | 48470 | 无效的订单状态 |     | Invalid order status type |     |
| 上交所期权 | 48470 | 无效的订单状态 |     | Invalid order status type |     |
| 上交所期权 | 48474 | 尝试读取自身写入的IraId |     | Tried to read own IraId in transaction |     |
| 上交所期权 | 48476 | IraWp 所有Frame耗尽 |     | No more free wp frame |     |
| 上交所期权 | 48478 | IraWpRef未读到数据 |     | IraWpRef read fails |     |
| 上交所期权 | 48480 | 生成行情文件冲突 |     | Conflicted in market data file generation |     |
| 上交所期权 | 48486 | CONV decimal 字段 |     | CONV decimal overflow |     |
| 上交所期权 | 48488 | RAM IraWp查询表关键字重复: ) |     | Duplicate key for RAM IraWp table |     |
| 上交所期权 | 48506 | RAM IraWp查询表记录重复: ) |     | Duplicate record for RAM IraWp table |     |
| 上交所期权 | 48508 | 连接表中主机连接状态不一致 |     | Connection status in FPConlst inconsistent |     |
| 上交所期权 | 48804 | 账户限仓库未初始化 |     | Invacc hldg limit lib not initialized |     |
| 上交所期权 | 48806 | 账户限仓记录已存在 |     | Invacc hldg limit record already exists |     |
| 上交所期权 | 48808 | 账户限仓记录不存在 |     | Invacc hldg limit record does not exist |     |
| 上交所期权 | 48810 | 会员限仓库未初始化 |     | Broker hldg limit lib not initialized |     |
| 上交所期权 | 48812 | 会员限仓记录已存在 |     | Broker hldg limit record already exists |     |
| 上交所期权 | 48814 | 会员限仓记录不存在 |     | Broker hldg limit record does not exist |     |
| 上交所期权 | 48818 | 合约尚未到vola中止时间 |     | Instrument is not ready to exit vola |     |
| 上交所期权 | 48820 | 合约已经在vola中 |     | Instrument is already in vola |     |
| 上交所期权 | 48822 | 投资者持仓超出限额 |     | Investor exceeds hldg limit |     |
| 上交所期权 | 48824 | 无效的期权合约类型 |     | Invalid option contract type |     |
| 上交所期权 | 48826 | 非法的备兑持仓头寸 |     | Unreasonable covered call position |     |
| 上交所期权 | 48828 | 会员持仓超出限额 |     | Broker exceeds holding limit |     |
| 上交所期权 | 48830 | 无操作权限 |     | No operation permission |     |
| 上交所期权 | 49000 | 非法的消息类型 |     | Invalid message type |     |
| 上交所期权 | 49002 | 指令/响应包已满 |     | The current package is full |     |
| 上交所期权 | 49004 | 本地有尚未获取的打包消息 |     | There is pending local package message in use |     |
| 上交所期权 | 49006 | 新的打包消息内容为空 |     | The new package message is still empty |     |
| 上交所期权 | 49008 | 非法的操作类型 |     | Invalid operation type |     |
| 上交所期权 | 49010 | 非法的指令方向 |     | Invalid side info type |     |
| 上交所期权 | 49012 | 本地打包消息缓存中无可用存储空间 |     | There is no free slot in the local cache |     |
| 上交所期权 | 49014 | 非法的消息序号 |     | Invalid message ID |     |
| 上交所期权 | 49016 | 输入的消息序号未被分配 |     | Incoming message ID is not in use |     |
| 上交所期权 | 49482 | HYXX文件参考数据类型标识符错误 |     | RFStreamID error in record of file hyjc |     |
| 上交所期权 | 49484 | HYXX文件产品代码不错误 |     | InstrumentID error in record of file hyjc |     |
| 上交所期权 | 49486 | HYXX文件标的证券代码错误 |     | UnderlyingSecurityID error in record of file hyjc |     |
| 上交所期权 | 49490 | HYXX文件期权类型错误 |     | CallOrPut error in record of file hyjc |     |
| 上交所期权 | 49492 | HYXX文件期合约单位错误 |     | ContractMultiplierUnit error in record of file hyjc |     |
| 上交所期权 | 49500 | HYXX文件涨跌幅限制类型错误 |     | PriceLimitType error in record of file hyjc |     |
| 上交所期权 | 49502 | HYXX文件合约状态信息标签错误 |     | SecurityStatusFlag error in record of file hyjc |     |
| 上交所期权 | 49504 | HYXX文件标的期权代码错误 |     | SecurityID error in record of file hyjc |     |
| 上交所期权 | 49506 | HYXX文件标的保证金比例错误 |     | Margin ratio error in record of file hyjc |     |
| 上交所期权 | 49508 | HYXX非法的最小报价单位 |     | Invalid minimum quotation unit in record of file hyjc |     |
| 上交所期权 | 49510 | 不存在的广播数据槽 |     | Non-existent broadcast data slot |     |
| 上交所期权 | 49512 | 非法的广播数据偏移 |     | Invalid data offset in a BC data slot, offset |     |
| 上交所期权 | 49514 | 广播数据遍历结束 |     | End of broadcast data iteration |     |
| 上交所期权 | 49516 | 非法广播消息处理主键 |     | Invalid the broadcast msg proc key |     |
| 上交所期权 | 55002 | 数据未填写 |     | Empty filled information |     |
| 上交所期权 | 55003 | 上次查询结果正在处理并返回，请稍后再次查询 |     | The last query result is being processed and return ,please query again later |     |
| 上交所期权 | 55005 | 口令错误 |     | Wrong password |     |
| 上交所期权 | 55007 | 用户已登录 |     | Duplicate login |     |
| 上交所期权 | 55014 | 用户尚未登录 |     | User not login |     |
| 上交所期权 | 55015 | 系统内存不足 |     | System Memory Not Enough |     |
| 上交所期权 | 55016 | 错误的资金账号 |     | Wrong AccountID |     |
| 上交所期权 | 55021 | 不合法的密码 |     | Illegal password |     |
| 上交所期权 | 55031 | 错误的授权码 |     | Error anthenticate code |     |
| 上交所期权 | 55033 | 节点超出 |     | Node exceed |     |
| 上交所期权 | 55037 | 资金账号不存在 |     | AccountID not exist |     |
| 上交所期权 | 55038 | token错误 |     | Wrong token |     |
| 上交所期权 | 55039 | 报单序号不是连续增加 |     | The order number not increases monotonically |     |
| 上交所期权 | 55040 | 被撤单找不到 |     | Cancelled order not found |     |
| 上交所期权 | 55041 | 内部进程间消息发送失败 |     | Interactive msg send failed |     |
| 上交所期权 | 55042 | STEP 信息编码失败 |     | STEP message encoded failed |     |
| 上交所期权 | 55043 | 插入数据库失败 |     | Failed to insert into database |     |
| 上交所期权 | 55044 | 重复登录 |     | Duplicate login |     |
| 上交所期权 | 55045 | 柜台导上场数据初始化未完成 |     | Initialization of settlement data not completed |     |
| 上交所期权 | 55046 | 查询过快 |     | Query too fast |     |
| 上交所期权 | 55047 | 无相关记录 |     | No relevant records |     |
| 上交所期权 | 55048 | 登录超时 |     | Login timeout |     |
| 上交所期权 | 55049 | 该用户已经在其他链路登录 |     | User has logged in on another link |     |
| 上交所期权 | 55050 | api版本错误 |     | Wrong API version |     |
| 上交所期权 | 55052 | 接口未开启 |     | Interface not open |     |
| 上交所期权 | 55053 | 错误的时间格式 |     | Wrong time format |     |
| 上交所期权 | 55054 | 号段用尽或未配置号段 |     | Number segment run out or not configured |     |
| 上交所期权 | 55055 | 集中交易操作失败 |     | Central trading operation failed |     |
| 上交所期权 | 55056 | 用户登录ip检查失败 |     | User login ip check failed |     |
| 上交所期权 | 55057 | 用户登录mac地址检查失败 |     | User login mac address check failed |     |
| 上交所期权 | 55058 | 获取FPGA上限失败 |     | Get FPGA cap failed |     |
| 上交所期权 | 55059 | 出金转账成功，入金失败 |     | Transfered out_cap successfully, but failed to transfer in_cap |     |
| 上交所期权 | 55060 | 连接headquarter错误 |     | failed to connect to headquarter |     |
| 上交所期权 | 55061 | 无效金额 |     | Invalid amount |     |
| 上交所期权 | 55062 | 系统id错误 |     | Wrong system_id |     |
| 上交所期权 | 55063 | 登录太快 |     | Login too fast |     |
| 上交所期权 | 55064 | 仓位检查错误 |     | Position check failed |     |
| 上交所期权 | 55065 | 组合策略类型错误 |     | Wrong comb strategy type |     |
| 上交所期权 | 55067 | Zmq通信错误 |     | Zmq failed |     |
| 上交所期权 | 55068 | 已经有其他帐户登录到当前链接 |     | Another account has already logged in this link |     |
| 上交所期权 | 55069 | 报单未发送到交易所 |     | Failed to send to exchange |     |
| 上交所期权 | 55070 | 号码范围已用完 |     | Number range is exhausted |     |
| 上交所期权 | 55072 | 取消其他账户订单 |     | Cancel other account order |     |
| 上交所期权 | 55073 | 重建失败 |     | Rebuild Failed |     |
| 上交所期权 | 55074 | 使用了错误的目的ip或port |     | Wrong dest ip and port used |     |
| 上交所期权 | 55075 | 登陆次数已达上限 |     | Numbers of login reach limit |     |
| 上交所期权 | 55076 | 当前通道忙，请重试 |     | Current channel is busy, please try again later |     |
| 上交所期权 | 55077 | Xbot登陆超时 |     | Xele-Bot login timeout |     |
| 上交所期权 | 55078 | 报单链路不可用 |     | Trade tcp session not available |     |
| 上交所期权 | 55079 | Fpga资金更新失败 |     | Update fpga account failed |     |
| 上交所期权 | 55080 | 操作资金超出限制 |     | Capital is too large |     |
| 上交所期权 | 55081 | 集中柜台连接失败 |     | Ufx connect failed |     |
| 上交所期权 | 55082 | 此功能当前被禁用 |     | This function is disabled in the current |     |
| 上交所期权 | 55083 | 账号余额不足 |     | Account balance not enough |     |
| 上交所期权 | 55084 | 集中柜台资金回滚 |     | roll back trading center failed |     |
| 上交所期权 | 55088 | Api自动重连校验失败 |     | Api reconnect TradingDay compare failed |     |
| 上交所期权 | 55089 | 交易日尚未从柜台同步 |     | Tradingday not sync from trade yet |     |
| 上交所期权 | 60000 | 正确  |     | OK  |     |
| 上交所期权 | 60001 | 该合约限制买入 |     | Contract restricts buy |     |
| 上交所期权 | 60002 | 该合约限制卖出 |     | Contract restricts sell |     |
| 上交所期权 | 60003 | 该合约限制卖空 |     | Contract restricts short selling |     |
| 上交所期权 | 60004 | 不支持 |     | Not support |     |
| 上交所期权 | 60005 | 不允许跨市扫货单 |     | Cross market scanning not allowed |     |
| 上交所期权 | 60006 | 不允许市价单 |     | Market orders not allowed |     |
| 上交所期权 | 60007 | 价格超出范围 |     | Price out of range |     |
| 上交所期权 | 60008 | 单笔手数超过ADV限制 |     | Volume exceeds adv limit |     |
| 上交所期权 | 60009 | 报价最小值错误 |     | Quotation minimum error |     |
| 上交所期权 | 60010 | 单笔交易额过小 |     | Single transaction volume too small |     |
| 上交所期权 | 60011 | 单笔交易额过大 |     | Single transaction volume too large |     |
| 上交所期权 | 60012 | 单笔手数过小 |     | Too small Volume |     |
| 上交所期权 | 60013 | 单笔手数过大 |     | Too large Volume |     |
| 上交所期权 | 60014 | 当日用户报单ID重复 |     | Client order id Duplicate |     |
| 上交所期权 | 60015 | 没找到合约 |     | Contract not found |     |
| 上交所期权 | 60016 | 不合法的有效期类型 |     | Illegal validity type |     |
| 上交所期权 | 60017 | XeleTrade停止交易 |     | System stopped trading |     |
| 上交所期权 | 60018 | XeleTrade限制交易 |     | System restrict trading |     |
| 上交所期权 | 60019 | 当日累计交易额过大 |     | Accumulated trading volume of the day too large |     |
| 上交所期权 | 60020 | 没有贷款经纪人标识 |     | No loan broker logo |     |
| 上交所期权 | 60021 | 报单速率过快 |     | Order too fast |     |
| 上交所期权 | 60022 | 报单表地址冲突 |     | Order address conflict |     |
| 上交所期权 | 60023 | 不合法的报单类型 |     | Illegal Order Type |     |
| 上交所期权 | 60024 | 不合法的报单方向 |     | Illegal order direction |     |
| 上交所期权 | 60025 | 不允许IPO交易 |     | IPO transaction not allowed |     |
| 上交所期权 | 60026 | 未成交单过多 |     | Unsettled orders too many |     |
| 上交所期权 | 60027 | 业务范围不正确 |     | Incorrect business scope |     |
| 上交所期权 | 60028 | 不允许有担保单的卖空 |     | Short selling with guarantee not allowed |     |
| 上交所期权 | 60029 | 不正确的最小价格变化值 |     | Wrong minimum price unit |     |
| 上交所期权 | 60030 | 不正确的最小手数单位 |     | Wrong minimum lot unit |     |
| 上交所期权 | 60031 | 报单不匹配或者报单表已满 |     | Order not match or Order full |     |
| 上交所期权 | 60032 | 缺失字段 |     | Missing field |     |
| 上交所期权 | 60033 | 超时(合约表不存在) |     | System timeout |     |
| 上交所期权 | 60034 | 字段错误 |     | Field error |     |
| 上交所期权 | 60035 | 改单时不允许增加，只能减少 |     | Change order to increase not allow,to decrease allowed |     |
| 上交所期权 | 60036 | 该机构不允许买入 |     | Agency to buy not allowed |     |
| 上交所期权 | 60037 | 该机构不允许卖出 |     | Agency to sell not allowed |     |
| 上交所期权 | 60038 | 该机构不允许卖空 |     | Agency to short selling not allowed |     |
| 上交所期权 | 60039 | 不允许自营买 |     | Self buy not allowed |     |
| 上交所期权 | 60040 | 不允许自营卖 |     | Self sell not allowed |     |
| 上交所期权 | 60041 | 不允许自营卖空 |     | Self short selling not allowed |     |
| 上交所期权 | 60042 | 禁止买开 |     | Restrict to open buy |     |
| 上交所期权 | 60043 | 禁止卖平 |     | Restrict to close sell |     |
| 上交所期权 | 60044 | 禁止卖开 |     | Restrict to open sell |     |
| 上交所期权 | 60045 | 当天买入方向累计超额 |     | Buy direction accumulated excess |     |
| 上交所期权 | 60046 | 当天卖出方向累计超额 |     | Sell direction accumulated excess |     |
| 上交所期权 | 60047 | 卖出超出持仓 |     | Sell exceeds position |     |
| 上交所期权 | 60048 | 卖空超出借入 |     | Short selling exceeds borrowing |     |
| 上交所期权 | 60049 | 未应答报单 |     | Unanswered order |     |
| 上交所期权 | 60050 | SAMSN拒单 |     | SAMSN refused |     |
| 上交所期权 | 60051 | VENUE繁忙 |     | VENUE busy |     |
| 上交所期权 | 60052 | 该合约未成交买单超出上限 |     | Contract unsettled and buy order exceeds the upper limit |     |
| 上交所期权 | 60053 | 该合约未成交卖单超出上限 |     | Contract unsettled and sell order exceeds the upper limit |     |
| 上交所期权 | 60054 | 改单的合约不匹配 |     | Modified contract not match |     |
| 上交所期权 | 60055 | 该报单不存在 |     | Order not exist |     |
| 上交所期权 | 60056 | 报单查找表搜索超时 |     | Order search timeout |     |
| 上交所期权 | 60057 | 资金账户变化 |     | Change of capital account |     |
| 上交所期权 | 60058 | 数量错误 |     | Quantity error |     |
| 上交所期权 | 60059 | 该合约持仓过多 |     | Contract positions too large |     |
| 上交所期权 | 60060 | 超过买入上限 |     | Exceeding the buying limit |     |
| 上交所期权 | 60061 | 该合约空头持仓过多 |     | Holding short position of the contract too large |     |
| 上交所期权 | 60062 | 该合约空头平仓量大于可平量；平仓买的数量大于可平量 |     | Short position of the contract larger than available while entering close order； |     |
| 上交所期权 | 60063 | 可卖数量不足 |     | Sellable quantity not enough |     |
| 上交所期权 | 60064 | 可用资金量小于该笔报单保证金 |     | Account balance less than margin of the order |     |
| 上交所期权 | 60065 | 保证金占可用资金百分比过高 |     | Ratio of margin occupying capital too large |     |
| 上交所期权 | 60066 | 当天该合约撤单次数超限，不允许撤单 |     | Cancel order not allowed |     |
| 上交所期权 | 60067 | 客户报单ID与登录ID不一致 |     | Customer order ID and login ID Inconsistent |     |
| 上交所期权 | 60068 | 报单价格格式错误 |     | Wrong format of order price |     |
| 上交所期权 | 60069 | 报单价格条件字段不在枚举范围之内 |     | Order price conditions field not in the range of enumeration |     |
| 上交所期权 | 60070 | 报单买卖方向条件字段不在枚举范围之内 |     | Condition of buy and sell direction field not in the range of enumeration |     |
| 上交所期权 | 60071 | 报单开平字段不在枚举范围之内 |     | Order field not in the range of enumeration |     |
| 上交所期权 | 60072 | 报单投机套保标志字段不在枚举范围之内 |     | Order speculative hedging mark field not in the range of enumeration |     |
| 上交所期权 | 60073 | 报单有效期类型字段不在枚举范围之内 |     | Order period of validity type field not in the range of enumeration |     |
| 上交所期权 | 60074 | 报单操作标志字段不在枚举范围之内 |     | Order operation flag field not in the range of enumeration |     |
| 上交所期权 | 60075 | 交易所端在途订单过多，限制报单 |     | Number of order on the way too large |     |
| 上交所期权 | 60076 | xele_trade系统高负载，报单过多，限制报单 |     | System overload:qdr full |     |
| 上交所期权 | 60077 | xele_trade系统高负载，持仓过多，限制报单 |     | System overload:ddr full |     |
| 上交所期权 | 60078 | 报单投机套保标志与客户交易类型不一致 |     | Order speculative hedging mark inconsistent with customer transaction type |     |
| 上交所期权 | 60079 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 上交所期权 | 60080 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 上交所期权 | 60081 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 上交所期权 | 60082 | 客户端未登录 |     | Client not logged in |     |
| 上交所期权 | 60083 | 报单已撤，不能再次撤销 |     | Duplicate cancel |     |
| 上交所期权 | 60084 | 拒绝自成交报单 |     | Self closing order refused |     |
| 上交所期权 | 60085 | xele-monitor强平单不能被用户通过API撤掉 |     | Forced Liquidation order cannot be cancelled by API |     |
| 上交所期权 | 60086 | 报单已经被撤掉了 |     | Order has been withdrawn |     |
| 上交所期权 | 60087 | 报单开仓手数超过限制 |     | Open position exceeded the limit |     |
| 上交所期权 | 60088 | 合约格式错误 |     | Contract format error |     |
| 上交所期权 | 60089 | 成交量类型不在枚举范围内 |     | Transaction type not in the range of enumeration |     |
| 上交所期权 | 60090 | 触发条件不在枚举范围内 |     | Trigger conditions not in the range of enumeration |     |
| 上交所期权 | 60091 | 强平原因不在枚举范围内 |     | Reasons for Liquidation order not in the range of enumeration |     |
| 上交所期权 | 60092 | 报单手数小于最小成交量手数 |     | Orders lot less than the minimum lot of transactions |     |
| 上交所期权 | 60093 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 上交所期权 | 60094 | 交易所前置未登录 |     | Exchange front not login |     |
| 上交所期权 | 60095 | 前置错误 |     | Exchange front error |     |
| 上交所期权 | 60096 | 禁止买平 |     | Restrict to close buy |     |
| 上交所期权 | 60097 | 不允许期货FOK报单 |     | Futures FOK order not allowed |     |
| 上交所期权 | 60098 | IAS格式错误 |     | IAS format error |     |
| 上交所期权 | 60099 | 交割月禁止开仓 |     | Open position in delivery month disallowed |     |
| 上交所期权 | 60100 | 未登录不允许交易 |     | Trading not allowed without login |     |
| 上交所期权 | 60101 | 系统负载过高 |     | System overload |     |
| 上交所期权 | 60102 | 限额达到最大值 |     | Total bought amount reach the limit |     |
| 上交所期权 | 60103 | 权利仓已达上限 |     | Total bought underlying position reach the limit |     |
| 上交所期权 | 60104 | 当日权利仓已达上限 |     | Total today bought underlying position reach the limit |     |
| 上交所期权 | 60105 | 总持仓已达上限 |     | Total underlying position reach the limit |     |
| 上交所期权 | 60106 | 禁止自成交 |     | Self trade is forbidden |     |
| 上交所期权 | 60107 | 触发价格偏离度风控 |     | Trigger price deviation risk |     |
| 上交所期权 | 60108 | 组合保证金组合持仓不足 |     | Comb margin position not enough |     |
| 上交所期权 | 60109 | 组合保证金解组持仓不足 |     | Uncomb margin position not enough |     |
| 上交所期权 | 60110 | 当日累计开仓已达上限 |     | Total today opened underlying position reach the limit |     |
| 上交所期权 | 60111 | 备兑持仓不足 |     | covered pos is not enough |     |
| 上交所期权 | 60112 | 权力仓持仓不足 |     | bought position is not enough |     |
| 上交所期权 | 60200 | 报文identification字段错误 |     | Wrong identification field |     |
| 上交所期权 | 60201 | message_id不再范围内 |     | Message_id not in range |     |
| 上交所期权 | 60202 | message_len错误 |     | Wrong message_len |     |
| 上交所期权 | 60203 | 用户报单id小于maxorderid或超出范围 |     | OrderID less than maxorderid or out of range |     |
| 上交所期权 | 60204 | 报单方向错误 |     | Wrong Direction |     |
| 上交所期权 | 60205 | positioneffect不在范围内 |     | Positioneffect not in range |     |
| 上交所期权 | 60206 | 价格超出范围 |     | Price out of system limit |     |
| 上交所期权 | 60207 | 报单类型错误 |     | Wrong OrderType |     |
| 上交所期权 | 60208 | 时间条件错误 |     | Wrong TimeCondition |     |
| 上交所期权 | 60209 | udp 校验错误 |     | Wrong UDP check |     |
| 上交所期权 | 60210 | 用户token错误 |     | Wrong User token |     |
| 上交所期权 | 60211 | 用户未登录 |     | User not login |     |
| 上交所期权 | 60212 | web报单不允许api撤单 |     | Web order not allow api to cancel the order |     |
| 上交所期权 | 60213 | 合约不允许API报单 |     | Api not allowed to handle certain web orders |     |
| 上交所期权 | 60214 | 号段前缀错误 |     | Order Id prefix err |     |
| 上交所期权 | 60215 | 号段Id错误 |     | Order Id number err |     |
| 上交所期权 | 60216 | TCP通道错误 |     | Tcp Session Error |     |
| 上交所期权 | 60217 | 合约类型错误 |     | Securities Type Error |     |
| 上交所期权 | 60218 | 被撤SysID超过号段范围 |     | OrigSysID is out of number range |     |

## 深交期权错误码

| 系统  | 错误码 | 错误信息 | 补充说明 | Error message | Reasons for error |
| --- | --- | --- | --- | --- | --- |
| 深交所期权 | 20000 | 正确  |     | OK  |     |
| 深交所期权 | 20001 | 无效账户 | 账户为未开户账户 | Invalid account:unopened account |     |
| 深交所期权 | 20002 | 无效账户 | 账户是一个无效账户（已注销、挂失等等） | Invalid account:logged out; reported loss; etc. |     |
| 深交所期权 | 20003 | 无效账户 | 账户无对应业务产品的交易权限 | Invalid account:no transaction rights for the business product |     |
| 深交所期权 | 20005 | 业务禁止 | 证券的业务开关关闭 | Business prohibition:securities business switch off |     |
| 深交所期权 | 20006 | 业务禁止 | 当前阶段不允许申报该类委托 | Business prohibition:not allowed to declare this type of delegation |     |
| 深交所期权 | 20007 | 证券停牌 | 证券停牌，不允许该类申报委托 | Securities suspension |     |
| 深交所期权 | 20008 | 价格错误 | 委托价格不是价格档位的整数倍;网上发行认购价格不等于发行价;配股认购价格不等于配股价 | Wrong price |     |
| 深交所期权 | 20009 | 价格错误 | 委托价格超过涨跌幅限制；盘后定价大宗交易委托价格不为指定价格；转融通证券出借委托的费率与公布的不一致 | Wrong price |     |
| 深交所期权 | 20010 | 数量非法 | 委托数量不是数量单位的整数倍；分级基金分拆合并委托数量非配比的整数倍 | Illegal volume |     |
| 深交所期权 | 20011 | 量额  | 委托数量和金额都未满足最低交易门槛要求委托数量或金额超过上限;开放式基金申购未满足最低申购金额要求 | Illegal amount |     |
| 深交所期权 | 20012 | 业务禁止 | 对折算率为 0 的证券不允许申报质押式回购质押申报；对非 A 股证券，成交申报业务子类别必须为非受限股份转让 | Business prohibition |     |
| 深交所期权 | 20013 | 业务禁止 | 融资融券标的不存在或业务被禁止；申报转融通证券出借委托，证券代码和期限不在当天发布的标的范围内;证券代码不在当天发布的港股通标的范围内;证券代码不在股票质押式回购业务标的范围内 | Business prohibition |     |
| 深交所期权 | 20014 | 业务禁止 | 证券当天集中竞价没有成交，不能申报以成交量加权平均价交易的委托 | Business prohibition:Invalid orders |     |
| 深交所期权 | 20015 | 业务禁止 | 融券卖出禁止申报市价委托 | Business prohibition:margin trading is prohibited to declare market orders |     |
| 深交所期权 | 20016 | 价格错误 | 融券卖出委托价格不满足提价检查要求 | Wrong price:commission price of margin selling not meet the price increase inspection requirements |     |
| 深交所期权 | 20017 | 无效账户 | 信用账户只能买入担保品证券 | Invalid account:credit account can only buy collateral securities |     |
| 深交所期权 | 20018 | 无效账户 | 非信用账户申报融资融券委托 | Invalid account:non-credit account declaration financing and securities lending commission |     |
| 深交所期权 | 20019 | 无效单元 | 债券分销业务中，卖委托的交易单元非承销商交易单元 | Invalid unit |     |
| 深交所期权 | 20020 | 无效账户 | 债券分销业务中，卖委托的证券账户非承销商证券账户或者买委托的证券账户为承销商证券账户 | Invalid account |     |
| 深交所期权 | 20021 | 数量超限 | 债券分销业务中，自行挂牌量超出自行挂牌总量 | Quantity exceeded |     |
| 深交所期权 | 20022 | 股份卖空 | 持有股份不足;质押式报价回购初始交易数量大于可用标准券数量 | Short selling |     |
| 深交所期权 | 20023 | 无效单元 | 委托的交易单元不存在；黄金 ETF 投资者交易单元找不到托管单元 | Invalid unit |     |
| 深交所期权 | 20024 | 无效单元 | 委托的交易单元无对应产品的交易权限 | Invalid unit:entrusted trading unit has no trading authority for the corresponding product |     |
| 深交所期权 | 20025 | 无效单元 | 委托的交易单元无对应业务的交易权限 | Invalid unit:entrusted trading unit has no trading authority for the corresponding product |     |
| 深交所期权 | 20026 | 无效单元 | 信用账户必须通过信用交易单元申报；非信用账户必须通过非信用交易单元申报 | Invalid unit |     |
| 深交所期权 | 20027 | 无效单元 | QFII 账户未从指定交易单元申报 | Invalid unit:QFII account not declared from the designated trading unit |     |
| 深交所期权 | 20028 | 无效单元 | 交易单元无对应产品的业务权限 | Invalid unit:trading unit has no business rights for the corresponding product |     |
| 深交所期权 | 20029 | 业务禁止 | 市场参与者业务资格被限制 | Business prohibition:market participant business qualifications are restricted |     |
| 深交所期权 | 20030 | 约定号重 | 协议交易成交申报约定号重复 | Duplicate declaration number |     |
| 深交所期权 | 20031 | 配对失败 | 交易双方申报要素不匹配 | Pairing failed:declared elements of the two parties of the transaction not match |     |
| 深交所期权 | 20032 | 配对失败 | B 股协议交易境内账户和境外账户不能成交 | Pairing failed:B-share agreement trading domestic accounts and overseas accounts not be traded |     |
| 深交所期权 | 20033 | 无对手方 | 协议交易点击成交申报约定号错误，未找到对应的定价申报 | No opponent |     |
| 深交所期权 | 20034 | 金额非法 | 委托中的金额必须为金额单位的整数倍 | Illegal amount:amount in the commission must be an integer multiple of the amount unit |     |
| 深交所期权 | 20035 | 申购不足 | 申购 ETF 时投资者成份股不足 | Insufficient subscription:insufficient investor stocks when purchasing ETFs |     |
| 深交所期权 | 20036 | 赎回不足 | 赎回 ETF 时基金公司成份股不足 | Insufficient redemption:fund companies have insufficient stocks when redeeming ETFs |     |
| 深交所期权 | 20037 | 现金超限 | 现金替代部分超过上限 | Cash overrun:cash replacement part exceeds the upper limit |     |
| 深交所期权 | 20038 | 无效账户 | 合约账户标识码与申报交易单元对应的结算账号不一致；保证金查询指令中的结算账号与交易单元不匹配或交易单元无对应结算账号 | Invalid account |     |
| 深交所期权 | 20039 | 重复认购 | 网上发行重复认购 | Repeat subscription:reissue subscription online |     |
| 深交所期权 | 20040 | 无效单元 | 非证券金融公司专用交易单元申报借入委托；证券金融公司专用交易单元申报出借委托；非金交所专用交易单元申报委托 | Invalid unit |     |
| 深交所期权 | 20041 | 股份卖空 | 解押业务中对应的已质押股份不足 | Short selling:corresponding pledged shares in the unsecured business are insufficient |     |
| 深交所期权 | 20042 | 股份卖空 | 解押业务中对应的标准券不足 | Short selling:insufficient corresponding standard coupons in the discharge |     |
| 深交所期权 | 20046 | 无法成交 | 市价委托不满足成交条件撤单 | Unable to deal:market price order not meet the transaction conditions to cancel the order |     |
| 深交所期权 | 20047 | 规模超限 | 基金累计申购或赎回总规模超限；质押式报价回购总规模超限;国际市场互联额度不可用 | Overrun |     |
| 深交所期权 | 20048 | 规模超限 | 单个账户基金累计申购或赎回规模超限 | Overrun:single account fund cumulative purchase or redemption scale exceeds the limit |     |
| 深交所期权 | 20049 | 规模超限 | 基金净申购或净赎回总规模超限 | Overrun:fund's total net purchase or net redemption exceeds the limit |     |
| 深交所期权 | 20050 | 规模超限 | 单个账户基金净申购或净赎回规模超限 | Overrun:single account fund net purchase or net redemption scale exceeds the limit |     |
| 深交所期权 | 20051 | 购回期限错误 | 回购天数超过业务限制 | Wrong buyback period:repurchase days exceeded business limit |     |
| 深交所期权 | 20055 | 无效会员 | 会员无对应业务的交易权限 | Invalid member:members have no transaction rights for the corresponding business |     |
| 深交所期权 | 20056 | 无效账户 | 非业务指定交易的证券账户 | Invalid account:securities account for non-business designated transactions |     |
| 深交所期权 | 20059 | 金额超限 | 当日净买入金额超出设定限额 | Amount exceeded:net purchase amount exceeds the set limit |     |
| 深交所期权 | 20060 | 仓位不足 | 期权构建组合申报时，成份合约单腿持仓不足; 期权解除组合时，组合策略持仓不足或申报的组合流水号对应的持仓不存在 | Insufficient positions |     |
| 深交所期权 | 20061 | 交易量超限 | 超过投资者交易量限额 | Trading volume exceeded |     |
| 深交所期权 | 20062 | 持仓超限 | 超过结算参与人持仓限额 | Position limit exceeded |     |
| 深交所期权 | 20063 | 持仓超限 | 超过投资者持仓限额 | Position limit exceeded |     |
| 深交所期权 | 20064 | 资金不足 | 结算参与人可用资金不足 | Insufficient funds:insufficient funds available for settlement participants |     |
| 深交所期权 | 20065 | 平台已关闭 | 平台已关闭 | Platform is closed |     |
| 深交所期权 | 20067 | 备兑标签错 | 备兑标签错误，只有卖开认购合约或买平认购合约时备兑标签可以为备兑 | Redemption label wrong |     |
| 深交所期权 | 20068 | 结算机构错 | 结算机构代码错误 | Wrong settlement institution:billing agency code error |     |
| 深交所期权 | 20069 | 无效账户 | 委托中的账户为结算受限账户 | Invalid account:account under entrustment is a settlement restricted account |     |
| 深交所期权 | 20070 | 无效账户 | 委托中的账户为不合格账户 | Invalid account:account under commission is an unqualified account |     |
| 深交所期权 | 20071 | OwnerType 错误 | 强平主动撤单的 OwnerType 必须与原委托的一致 | Wrong OwnerType |     |
| 深交所期权 | 20073 | 报价错误 | 双边报价申报的买价必须低于卖价 | Wrong quote:bid price declared by the bilateral quotation must be lower than the selling price |     |
| 深交所期权 | 20074 | 无效业务 | 强平委托必须是限价委托 | Invalid business:forced commission must be a limit order |     |
| 深交所期权 | 20075 | 报价撤销 | 报价被更新或撤销 | Quote cancellation:quote is updated or withdrawn |     |
| 深交所期权 | 20076 | 申报方式错误 | 竞价委托申报方式错误， TimeInForce 、OrdType、MaxPriceLevels、MinQty 字段的组合不合法 | Wrong declaration method |     |
| 深交所期权 | 20077 | 无报价权限 | 无做市报价权限 | No quote authority:no market making authority |     |
| 深交所期权 | 20078 | 交易量超限 | 超过结算参与人交易量限额 | Trading volume exceeded:settlement participant transaction limit exceeded |     |
| 深交所期权 | 20079 | 减持额度不足 | 受限股份减持，可用额度不足 | Insufficient holdings:restriction of restricted shares; insufficient available quota |     |
| 深交所期权 | 20095 | 撤单请求错误 | 主动撤单请求的 applid 或证券 id 与原委托的不一致 | Wrong cancellation request |     |
| 深交所期权 | 20096 | 无法撤销 | 主动撤单请求目标委托不能被撤销 | Can not be revoked:target order not be cancelled if the request is cancelled |     |
| 深交所期权 | 20097 | 委托不存在 | 主动撤单未找到原始委托或者没有可以被撤销的报价 | Order not exist |     |
| 深交所期权 | 20099 | 重单  | 重单  | Repeat order |     |
| 深交所期权 | 20101 | 应用标识错 | 应用标识错误 | Wrong application identification |     |
| 深交所期权 | 20102 | 证券非法 | 证券不支持所申报的业务 | Illegal securities:not support the declared business |     |
| 深交所期权 | 20103 | 解包失败 | 解包失败 | Unpacking failed |     |
| 深交所期权 | 20104 | 平台未开放 | 平台未开放 | Platform not open |     |
| 深交所期权 | 20105 | 交易单元错 | 网关对交易单元无权限 | Wrong trading unit:gateway no authority over the trading unit |     |
| 深交所期权 | 20106 | 字段错误 | 字段取值错误 | Wrong field |     |
| 深交所期权 | 20107 | 消息类型非法 | 不支持的消息类型 | Illegal message type:unsupported message type |     |
| 深交所期权 | 20108 | 平台非法 | 委托申报的平台错误，例如向现货集中竞价平台申报发行认购业务的委托 | Illegal platform:delegated platform error |     |
| 深交所期权 | 20110 | 价格类型错 | 价格类型错误 | Wrong price type:wrong price type |     |
| 深交所期权 | 20111 | 无效单元 | 成交申报中的多方交易单元不属于同一会员 | Invalid unit:multi-party transaction unit in the transaction declaration not belong to the same member |     |
| 深交所期权 | 20112 | 无权限 | 网关无申报委托权限 | No permission:gateway no authority to declare delegation |     |
| 深交所期权 | 20113 | 服务暂停 | 资金查询服务暂停 | Service suspension:fund inquiry service suspended |     |
| 深交所期权 | 20114 | 临时停市拒绝 | 临时停市拒绝 | Temporary market refusal:temporary market refusal |     |
| 深交所期权 | 20115 | 申报方式错误 | 成 交 申 报 报 文 TradeHandlingInstr 、TradeReportTransType、TradeReportType 字段组合不合法 | Wrong bid |     |
| 深交所期权 | 20116 | 申报方式错误 | 成交请求发起方错误 | Wrong bid:deal request originator error |     |
| 深交所期权 | 20117 | 无效账户 | 证券账户无三方回购业务的正/逆回购权限 | Invalid account |     |
| 深交所期权 | 20118 | 篮子非法 | 三方回购申报的篮子个数超限；三方回购交易业务申报的篮子编号不在质押券篮子清单范围内 | Illegal basketPledged bonds illegal |     |
| 深交所期权 | 20119 | 质押券非法 | 三方回购申报质押券个数不符合业务要求 | Illegal Pledged bonds:number of pledged bonds declared by the three parties not meet the business requirements |     |
| 深交所期权 | 20120 | 质押券非法 | 三方回购初始交易申报的指定质押券不在申报的质押券篮子内; 三方回购补券申报的证券及换券申报的换入证券不在其对应的在途合约指定质押券篮子内 | Illegal Pledged bonds |     |
| 深交所期权 | 20121 | 质押券非法 | 三方回购初始交易、补券、换券（仅换入）申报的指定质押券全天停牌 | Illegal Pledged bonds |     |
| 深交所期权 | 20122 | 质押券非法 | 三方回购换券申报的换出证券不在其对应的在途合约质押券列表中 | Illegal Pledged bonds |     |
| 深交所期权 | 20123 | 无效单元 | 成交申报中的对手方交易单元不存在 | Invalid unit:counterparty trading unit in transaction declaration does not exist |     |
| 深交所期权 | 20124 | 回购期限错误 | 三方回购初始交易指定质押券的到期日小于合约到期日；三方回购到期续做对应在途合约质押券到期日小于续做合约到期日 | Wrong buyback period |     |
| 深交所期权 | 20125 | 合约不存在 | 三方回购到期购回、到期续做、提前购回、补券、换券未找到对应的在途合约 | Contract not exist |     |
| 深交所期权 | 20126 | 业务禁止 | 三方回购到期购回、到期续做委托对应的在途合约不是当日到期合约；三方回购提前购回、换券、补券对应的在途合约不是未到期合约 | Business prohibition |     |
| 深交所期权 | 20127 | 业务禁止 | 三方回购到期购回、到期续做、提前购回、补券、换券委托中交易单元、证券账户与对应在途合约中交易单元、证券账户不一致 | Business prohibition |     |
| 深交所期权 | 20128 | 金额非法 | 三方回购到期续做金额超过原合约金额；三方回购提前购回金额小于原合约金额；三方回购解除质押金额（场内结算）小于原合约金额 | Illegal amount |     |
| 深交所期权 | 20129 | 证券非法 | 三方回购入库证券不在质押券篮子清单范围内；期权构建、解除组合或行权指令合并申报时，成份合约标的证券与委托中 SecurityID 不一致 | Illegal securities |     |
| 深交所期权 | 20130 | 无对手方 | 成交请求模式下确认方发起的委托未找到提交方申报的委托 | No opponent |     |
| 深交所期权 | 20131 | 业务禁止 | 三方回购在途合约当前状态不允许申报该类别委托，比如已提前购回的合约不能再申报换券、补券委托，已对合约申报了到期购回，则不能再次申报到期购回或到期续做 | Business prohibition |     |
| 深交所期权 | 20132 | 业务禁止 | 期权构建组合或行权指令合并申报时，合约的标的、合约单位、到期日不符规则 | Business prohibition |     |
| 深交所期权 | 20133 | 业务禁止 | 成份合约已过组合自动解除日 | Business prohibition:component contract passed the combination automatic release date |     |
| 深交所期权 | 20134 | 业务禁止 | 合约不支持申报的策略 | Business prohibition:contract not support the declared strategy |     |
| 深交所期权 | 20135 | 业务禁止 | 期权构建组合或行权指令合并申报时，委托成份合约个数不符规则 | Business prohibition |     |
| 深交所期权 | 20136 | 数量非法 | 委托成份合约数量不符规则 | Illegal quantity:number of entrusted component contracts not comply with the rules |     |
| 深交所期权 | 20137 | 业务禁止 | 委托成份合约权利仓/义务仓不符规则 | Business prohibition:entrusted component contract rights warehouse/obligatory warehouse not comply with the rules |     |
| 深交所期权 | 20138 | 业务禁止 | 期权构建组合或行权指令合并申报时，委托成份合约认购/认沽不符规则 | Business prohibition |     |
| 深交所期权 | 20139 | 业务禁止 | 期权构建组合或行权指令合并申报时，委托成份合约行权价不符规则 | Business prohibition |     |
| 深交所期权 | 20140 | 业务禁止 | 解除组合，申报的组合流水号对应组合策略持仓的参与人信息与委托中的不一致 | Business prohibition |     |
| 深交所期权 | 29995 | 市场互联拒绝 | 港股通撤单请求被联交所拒绝，具体拒绝原因代码见 RejectText | Market interconnection rejection:Hong Kong Stock Connect's withdrawal request rejected by the Stock Exchange |     |
| 深交所期权 | 29996 | 市场互联拒绝 | 港股通委托被联交所自动撤销，具体撤销原因代码见RejectText，撤销原因说明见IMCRejectText | Market interconnection rejection:Hong Kong Stock Connect entrustment revoked by the Stock Exchange |     |
| 深交所期权 |     |     |     |     |     |
| 深交所期权 | 29997 | 市场互联拒绝 | 港股通委托被联交所拒绝，具体拒绝原因代码见RejectText，拒绝原因说明见IMCRejectText | Market interconnection rejection:Hong Kong Stock Connect commission rejected by the Stock Exchange |     |
| 深交所期权 |     |     |     |     |     |
| 深交所期权 | 29998 | 市场互联拒绝 | 港股通委托被联交所拒绝，具体拒绝原因代码见RejectText，拒绝原因说明见IMCRejectText | Market interconnection rejection:Hong Kong Stock Connect commission rejected by the Stock Exchange |     |
| 深交所期权 |     |     |     |     |     |
| 深交所期权 | 29999 | 其他错误 |     | Other errors |     |
| 深交所期权 | 55002 | 数据未填写 |     | Empty filled information |     |
| 深交所期权 | 55003 | 上次查询结果正在处理并返回，请稍后再次查询 |     | The last query result is being processed and return ,please query again later |     |
| 深交所期权 | 55005 | 口令错误 |     | Wrong password |     |
| 深交所期权 | 55007 | 用户已登录 |     | Duplicate login |     |
| 深交所期权 | 55014 | 用户尚未登录 |     | User not login |     |
| 深交所期权 | 55015 | 系统内存不足 |     | System Memory Not Enough |     |
| 深交所期权 | 55016 | 错误的资金账号 |     | Wrong AccountID |     |
| 深交所期权 | 55021 | 不合法的密码 |     | Illegal password |     |
| 深交所期权 | 55031 | 错误的授权码 |     | Error anthenticate code |     |
| 深交所期权 | 55033 | 节点超出 |     | Node exceed |     |
| 深交所期权 | 55037 | sessionID不存在 |     | SessionID not exist |     |
| 深交所期权 | 55038 | token错误 |     | Wrong token |     |
| 深交所期权 | 55039 | 报单序号不是连续增加 |     | The order number not increases monotonically |     |
| 深交所期权 | 55040 | 被撤单找不到 |     | Cancelled order not found |     |
| 深交所期权 | 55041 | Zmq发送报文错误 |     | Interactive msg send failed |     |
| 深交所期权 | 55042 | 组step报文失败 |     | STEP message encoded failed |     |
| 深交所期权 | 55043 | 插入数据库失败 |     | Failed to insert into database |     |
| 深交所期权 | 55044 | 重复登录 |     | Duplicate login |     |
| 深交所期权 | 55045 | 柜台导上场数据初始化未完成 |     | Initialization of settlement data not completed |     |
| 深交所期权 | 55046 | 查询过快 |     | Query too fast |     |
| 深交所期权 | 55047 | 无相关记录 |     | No relevant records |     |
| 深交所期权 | 55048 | 登录超时 |     | Login timeout |     |
| 深交所期权 | 55049 | 该用户已经在其他链路登录 |     | User has logged in on another link |     |
| 深交所期权 | 55050 | api版本错误 |     | Wrong API version |     |
| 深交所期权 | 55052 | 接口未开启 |     | Interface not open |     |
| 深交所期权 | 55053 | 错误的时间格式 |     | Wrong time format |     |
| 深交所期权 | 55054 | 号段用尽或未配置号段 |     | Number segment run out or not configured |     |
| 深交所期权 | 55055 | 集中交易操作败 |     | Central trading operation failed |     |
| 深交所期权 | 55056 | 用户登录ip检查失败 |     | User login ip check failed |     |
| 深交所期权 | 55057 | 用户登录mac地址检查失败 |     | User login mac address check failed |     |
| 深交所期权 | 55058 | 获取FPGA上限失败 |     | get FPGA cap failed |     |
| 深交所期权 | 55059 | 出金转账成功，入金失败 |     | Transfered out_cap successfully, but failed to transfer in_cap |     |
| 深交所期权 | 55060 | 连接headquarter错误 |     | failed to connect to headquarter |     |
| 深交所期权 | 55061 | 无效金额 |     | Invalid amount |     |
| 深交所期权 | 55062 | 系统id错误 |     | Wrong system_id |     |
| 深交所期权 | 55063 | 登录太快 |     | Login too fast |     |
| 深交所期权 | 55064 | 仓位检查错误 |     | Position check failed |     |
| 深交所期权 | 55065 | 组合策略类型错误 |     | Wrong comb strategy type |     |
| 深交所期权 | 55067 | Zmq通信错误 |     | zmq failed |     |
| 深交所期权 | 55068 | 已经有其他帐户登录到当前链接 |     | Another account has already logged in this link |     |
| 深交所期权 | 55069 | 报单未发送到交易所 |     | Failed to send to exchange |     |
| 深交所期权 | 55070 | 号码范围已用完 |     | Number range is exhausted |     |
| 深交所期权 | 55072 | 取消其他账户订单 |     | Cancel other account order |     |
| 深交所期权 | 55073 | 重建失败 |     | Rebuild Failed |     |
| 深交所期权 | 55074 | 使用了错误的目的ip或port |     | Wrong dest ip and port used |     |
| 深交所期权 | 55075 | 登陆次数已达上限 |     | Numbers of login reach limit |     |
| 深交所期权 | 55076 | 当前通道忙，请重试 |     | Current channel is busy, please try again later |     |
| 深交所期权 | 55077 | Xbot登陆超时 |     | Xele-Bot login timeout |     |
| 深交所期权 | 55078 | 报单链路不可用 |     | Trade tcp session not available |     |
| 深交所期权 | 55079 | Fpga资金更新失败 |     | Update fpga account failed |     |
| 深交所期权 | 55080 | 操作资金超出限制 |     | Capital is too large |     |
| 深交所期权 | 55081 | 集中柜台连接失败 |     | Ufx connect failed |     |
| 深交所期权 | 55082 | 此功能当前被禁用 |     | This function is disabled in the current |     |
| 深交所期权 | 55083 | 账号余额不足 |     | Account balance not enough |     |
| 深交所期权 | 55084 | 集中柜台资金回滚 |     | roll back trading center failed |     |
| 深交所期权 | 55088 | Api自动重连校验失败 |     | Api reconnect TradingDay compare failed |     |
| 深交所期权 | 55089 | 交易日尚未从柜台同步 |     | Tradingday not sync from trade yet |     |
| 深交所期权 | 60000 | 正确  |     | OK  |     |
| 深交所期权 | 60001 | 该合约限制买入 |     | Contract restricts buy |     |
| 深交所期权 | 60002 | 该合约限制卖出 |     | Contract restricts sell |     |
| 深交所期权 | 60003 | 该合约限制卖空 |     | Contract restricts short selling |     |
| 深交所期权 | 60004 | 不支持 |     | Not support |     |
| 深交所期权 | 60005 | 不允许跨市扫货单 |     | Cross market scanning not allowed |     |
| 深交所期权 | 60006 | 不允许市价单 |     | Market orders not allowed |     |
| 深交所期权 | 60007 | 价格超出范围 |     | Price out of range |     |
| 深交所期权 | 60008 | 单笔手数超过ADV限制 |     | Volume exceeds adv limit |     |
| 深交所期权 | 60009 | 报价最小值错误 |     | Quotation minimum error |     |
| 深交所期权 | 60010 | 单笔交易额过小 |     | Single transaction volume too small |     |
| 深交所期权 | 60011 | 单笔交易额过大 |     | Single transaction volume too large |     |
| 深交所期权 | 60012 | 单笔手数过小 |     | Too small Volume |     |
| 深交所期权 | 60013 | 单笔手数过大 |     | Too large Volume |     |
| 深交所期权 | 60014 | 当日用户报单ID重复 |     | Client order id Duplicate |     |
| 深交所期权 | 60015 | 没找到合约 |     | Contract not found |     |
| 深交所期权 | 60016 | 不合法的有效期类型 |     | Illegal validity type |     |
| 深交所期权 | 60017 | XeleTrade停止交易 |     | System stopped trading |     |
| 深交所期权 | 60018 | XeleTrade限制交易 |     | System restrict trading |     |
| 深交所期权 | 60019 | 当日累计交易额过大 |     | Accumulated trading volume of the day too large |     |
| 深交所期权 | 60020 | 没有贷款经纪人标识 |     | No loan broker logo |     |
| 深交所期权 | 60021 | 报单速率过快 |     | Order too fast |     |
| 深交所期权 | 60022 | 报单表地址冲突 |     | Order address conflict |     |
| 深交所期权 | 60023 | 不合法的报单类型 |     | Illegal Order Type |     |
| 深交所期权 | 60024 | 不合法的报单方向 |     | Illegal order direction |     |
| 深交所期权 | 60025 | 不允许IPO交易 |     | IPO transaction not allowed |     |
| 深交所期权 | 60026 | 未成交单过多 |     | Unsettled orders too many |     |
| 深交所期权 | 60027 | 业务范围不正确 |     | Incorrect business scope |     |
| 深交所期权 | 60028 | 不允许有担保单的卖空 |     | Short selling with guarantee not allowed |     |
| 深交所期权 | 60029 | 不正确的最小价格变化值 |     | Wrong minimum price unit |     |
| 深交所期权 | 60030 | 不正确的最小手数单位 |     | Wrong minimum lot unit |     |
| 深交所期权 | 60031 | 报单不匹配或者报单表已满 |     | Order not match or Order full |     |
| 深交所期权 | 60032 | 缺失字段 |     | Missing field |     |
| 深交所期权 | 60033 | 超时(合约表不存在) |     | System timeout |     |
| 深交所期权 | 60034 | 字段错误 |     | Field error |     |
| 深交所期权 | 60035 | 改单时不允许增加，只能减少 |     | Change order to increase not allow,to decrease allowed |     |
| 深交所期权 | 60036 | 该机构不允许买入 |     | Agency to buy not allowed |     |
| 深交所期权 | 60037 | 该机构不允许卖出 |     | Agency to sell not allowed |     |
| 深交所期权 | 60038 | 该机构不允许卖空 |     | Agency to short selling not allowed |     |
| 深交所期权 | 60039 | 不允许自营买 |     | Self buy not allowed |     |
| 深交所期权 | 60040 | 不允许自营卖 |     | Self sell not allowed |     |
| 深交所期权 | 60041 | 不允许自营卖空 |     | Self short selling not allowed |     |
| 深交所期权 | 60042 | 禁止买开 |     | Restrict to open buy |     |
| 深交所期权 | 60043 | 禁止卖平 |     | Restrict to close sell |     |
| 深交所期权 | 60044 | 禁止卖开 |     | Restrict to open sell |     |
| 深交所期权 | 60045 | 当天买入方向累计超额 |     | Buy direction accumulated excess |     |
| 深交所期权 | 60046 | 当天卖出方向累计超额 |     | Sell direction accumulated excess |     |
| 深交所期权 | 60047 | 卖出超出持仓 |     | Sell exceeds position |     |
| 深交所期权 | 60048 | 卖空超出借入 |     | Short selling exceeds borrowing |     |
| 深交所期权 | 60049 | 未应答报单 |     | Unanswered order |     |
| 深交所期权 | 60050 | SAMSN拒单 |     | SAMSN refused |     |
| 深交所期权 | 60051 | VENUE繁忙 |     | VENUE busy |     |
| 深交所期权 | 60052 | 该合约未成交买单超出上限 |     | Contract unsettled and buy order exceeds the upper limit |     |
| 深交所期权 | 60053 | 该合约未成交卖单超出上限 |     | Contract unsettled and sell order exceeds the upper limit |     |
| 深交所期权 | 60054 | 改单的合约不匹配 |     | Modified contract not match |     |
| 深交所期权 | 60055 | 该报单不存在 |     | Order not exist |     |
| 深交所期权 | 60056 | 报单查找表搜索超时 |     | Order search timeout |     |
| 深交所期权 | 60057 | 资金账户变化 |     | Change of capital account |     |
| 深交所期权 | 60058 | 数量错误 |     | Quantity error |     |
| 深交所期权 | 60059 | 该合约持仓过多 |     | Contract positions too large |     |
| 深交所期权 | 60060 | 该合约多头持仓过多 |     | Holding long position of the contract too large |     |
| 深交所期权 | 60061 | 该合约空头持仓过多 |     | Holding short position of the contract too large |     |
| 深交所期权 | 60062 | 该合约空头平仓量大于可平量；平仓买的数量大于可平量 |     | Short position of the contract larger than available while entering close order； |     |
| 深交所期权 | 60063 | 可卖（可平）手数不足 |     | Long position of the contract larger than available while entering close order |     |
| 深交所期权 | 60064 | 可用资金量小于该笔报单保证金 |     | Account balance less than margin of the order |     |
| 深交所期权 | 60065 | 保证金占可用资金百分比过高 |     | Ratio of margin occupying capital too large |     |
| 深交所期权 | 60066 | 当天该合约撤单次数超限，不允许撤单 |     | Cancel order not allowed |     |
| 深交所期权 | 60067 | 客户报单ID与登录ID不一致 |     | Customer order ID and login ID Inconsistent |     |
| 深交所期权 | 60068 | 报单价格格式错误 |     | Wrong format of order price |     |
| 深交所期权 | 60069 | 报单价格条件字段不在枚举范围之内 |     | Order price conditions field not in the range of enumeration |     |
| 深交所期权 | 60070 | 报单买卖方向条件字段不在枚举范围之内 |     | Condition of buy and sell direction field not in the range of enumeration |     |
| 深交所期权 | 60071 | 报单开平字段不在枚举范围之内 |     | Order field not in the range of enumeration |     |
| 深交所期权 | 60072 | 报单投机套保标志字段不在枚举范围之内 |     | Order speculative hedging mark field not in the range of enumeration |     |
| 深交所期权 | 60073 | 报单有效期类型字段不在枚举范围之内 |     | Order period of validity type field not in the range of enumeration |     |
| 深交所期权 | 60074 | 报单操作标志字段不在枚举范围之内 |     | Order operation flag field not in the range of enumeration |     |
| 深交所期权 | 60075 | 交易所端在途订单过多，限制报单 |     | Number of order on the way too large |     |
| 深交所期权 | 60076 | xele_trade系统高负载，报单过多，限制报单 |     | System overload:qdr full |     |
| 深交所期权 | 60077 | xele_trade系统高负载，持仓过多，限制报单 |     | System overload:ddr full |     |
| 深交所期权 | 60078 | 报单投机套保标志与客户交易类型不一致 |     | Order speculative hedging mark inconsistent with customer transaction type |     |
| 深交所期权 | 60079 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所期权 | 60080 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所期权 | 60081 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所期权 | 60082 | 客户端未登录 |     | Client not logged in |     |
| 深交所期权 | 60083 | 报单已撤，不能再次撤销 |     | Duplicate cancel |     |
| 深交所期权 | 60084 | 拒绝自成交报单 |     | Self closing order refused |     |
| 深交所期权 | 60085 | xele-monitor强平单不能被用户通过API撤掉 |     | Forced Liquidation order cannot be cancelled by API |     |
| 深交所期权 | 60086 | 报单已经被撤掉了 |     | Order has been withdrawn |     |
| 深交所期权 | 60087 | 报单开仓手数超过限制 |     | Open position exceeded the limit |     |
| 深交所期权 | 60088 | 合约格式错误 |     | Contract format error |     |
| 深交所期权 | 60089 | 成交量类型不在枚举范围内 |     | Transaction type not in the range of enumeration |     |
| 深交所期权 | 60090 | 触发条件不在枚举范围内 |     | Trigger conditions not in the range of enumeration |     |
| 深交所期权 | 60091 | 强平原因不在枚举范围内 |     | Reasons for Liquidation order not in the range of enumeration |     |
| 深交所期权 | 60092 | 报单手数小于最小成交量手数 |     | Orders lot less than the minimum lot of transactions |     |
| 深交所期权 | 60093 | 交易所端流控达到上限 |     | Flow control reach upper limit |     |
| 深交所期权 | 60094 | 前置未登录 |     | Exchange front not login |     |
| 深交所期权 | 60095 | 前置错误 |     | Exchange front error |     |
| 深交所期权 | 60096 | 禁止买平 |     | Restrict to close buy |     |
| 深交所期权 | 60097 | 不允许期货FOK报单 |     | Futures FOK order not allowed |     |
| 深交所期权 | 60098 | IAS格式错误 |     | IAS format error |     |
| 深交所期权 | 60099 | 交割月禁止开仓 |     | Open position in delivery month disallowed |     |
| 深交所期权 | 60100 | 未登录不允许交易 |     | Trading not allowed without login |     |
| 深交所期权 | 60101 | 系统负载过高 |     | System overload |     |
| 深交所期权 | 60102 | 限额达到最大值 |     | Total bought amount reach the limit |     |
| 深交所期权 | 60103 | 权利仓已达上限 |     | Total bought underlying position reach the limit |     |
| 深交所期权 | 60104 | 当日权利仓已达上限 |     | Total today bought underlying position reach the limit |     |
| 深交所期权 | 60105 | 总持仓已达上限 |     | Total underlying position reach the limit |     |
| 深交所期权 | 60106 | 禁止自成交 |     | Self trade is forbidden |     |
| 深交所期权 | 60107 | 触发价格偏离度风控 |     | Trigger price deviation risk |     |
| 深交所期权 | 60108 | 组合保证金组合持仓不足 |     | Comb margin position not enough |     |
| 深交所期权 | 60109 | 组合保证金解组持仓不足 |     | Uncomb margin position not enough |     |
| 深交所期权 | 60110 | 当日累计开仓已达上限 |     | Total today opened underlying position reach the limit |     |
| 深交所期权 | 60111 | 备兑持仓不足 |     | covered pos is not enough |     |
| 深交所期权 | 60112 | 权力仓持仓不足 |     | bought position is not enough |     |
| 深交所期权 | 60200 | 报文identification字段错误 |     | Wrong identification field |     |
| 深交所期权 | 60201 | message_id不再范围内 |     | Message_id not in range |     |
| 深交所期权 | 60202 | message_len错误 |     | Wrong message_len |     |
| 深交所期权 | 60203 | 用户报单id小于maxorderid或超出范围 |     | OrderID less than maxorderid or out of range |     |
| 深交所期权 | 60204 | 报单方向错误 |     | Wrong Direction |     |
| 深交所期权 | 60205 | positioneffect不在范围内 |     | Positioneffect not in range |     |
| 深交所期权 | 60206 | 价格超出范围 |     | Price out of system limit |     |
| 深交所期权 | 60207 | 报单类型错误 |     | Wrong OrderType |     |
| 深交所期权 | 60208 | 时间条件错误 |     | Wrong TimeCondition |     |
| 深交所期权 | 60209 | udp 校验错误 |     | Wrong UDP check |     |
| 深交所期权 | 60210 | 用户token错误 |     | Wrong User token |     |
| 深交所期权 | 60211 | 用户未登录 |     | User not login |     |
| 深交所期权 | 60212 | web报单不允许api撤单 |     | Web order not allow api to cancel the order |     |
| 深交所期权 | 60213 | 合约不允许API报单 |     | Api not allowed to handle certain web orders |     |
| 深交所期权 | 60214 | 号段前缀错误 |     | Order Id prefix err |     |
| 深交所期权 | 60215 | 号段Id错误 |     | Order Id number err |     |
| 深交所期权 | 60216 | TCP通道错误 |     | Tcp Session Error |     |
| 深交所期权 | 60217 | 合约类型错误 |     | Securities Type Error |     |
| 深交所期权 | 60218 | 被撤SysID超过号段范围 |     | OrigSysID is out of number range |     |
