﻿/**
 * @file XeleSecuritiesUserApiData_Bare.h
 * @author root
 * @brief 客户端接口使用的业务数据类型
 * @date 25-7-16
 *
 * 详细的文件描述或注意事项可以放在这里。
 */

#ifndef _XELE_SECURITIES_USER_API_DATA_H
#define _XELE_SECURITIES_USER_API_DATA_H

#if defined(_WIN32) || defined(WIN32)
typedef unsigned long long uLong;
typedef long long Long;
#else
typedef unsigned long uLong;
typedef long Long;
#endif

/////////////////////////////////////////////////////////////////////////
///TXeleErrorIDType是错误编号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleErrorIDType;

/////////////////////////////////////////////////////////////////////////
///TXeleErrorMsgType是错误信息类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleErrorMsgType[81];

/////////////////////////////////////////////////////////////////////////
///TXeleFairProtocolType是Fair协议号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleFairProtocolType;

/////////////////////////////////////////////////////////////////////////
///TXeleMessageIDType是消息编号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleMessageIDType;
#define XELE_MSG_ID_ORDER  101  //普通报单类型消息ID
#define XELE_MSG_ID_ACTION 103  //普通撤单类型消息ID


/////////////////////////////////////////////////////////////////////////
///TXeleMessageLenType是消息长度类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned short TXeleMessageLenType;

/////////////////////////////////////////////////////////////////////////
///TXeleSessionIDType是会话编号类型
/////////////////////////////////////////////////////////////////////////
typedef short int TXeleSessionIDType;

/////////////////////////////////////////////////////////////////////////
///TXeleTokenType是令牌类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned short TXeleTokenType;

/////////////////////////////////////////////////////////////////////////
///TXeleSeqNoType是序列号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleSeqNoType;

/////////////////////////////////////////////////////////////////////////
///TXeleRequestIDType是请求编号类型
/////////////////////////////////////////////////////////////////////////
typedef int TXeleRequestIDType;

/////////////////////////////////////////////////////////////////////////
///TXeleSeqSeriesType是流类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleSeqSeriesType;
#define XELE_TSS_DIALOG    1          //对话流
#define XELE_TSS_PRIVATE   2          //会员私有流
#define XELE_TSS_PUBLIC    3          //公共流
#define XELE_TSS_QUERY     4          //查询
#define XELE_TSS_USER      5          //交易员私有流
#define XELE_TSS_FORQUOTE  6          //询价流

/////////////////////////////////////////////////////////////////////////
///TXeleOrigSysIDType是原报单编号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleOrigSysIDType;

/////////////////////////////////////////////////////////////////////////
///TXeleOrderIDType是报单编号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleOrderIDType;

/////////////////////////////////////////////////////////////////////////
///TXeleQFIIOrderIDType 是QFII报单编号类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleQFIIOrderIDType[32];

/////////////////////////////////////////////////////////////////////////
///TXeleOrderExchangeIDType是交易所报单编号类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOrderExchangeIDType[16];

/////////////////////////////////////////////////////////////////////////
///TXeleBusinessUnitType 是客户业务处理单元类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleBusinessUnitType[8];

/////////////////////////////////////////////////////////////////////////
/// TXelePriceType是价格类型
/// 单位：元（期权精度0.0001, 股票精度0.001）
/////////////////////////////////////////////////////////////////////////
typedef double TXelePriceType;

/////////////////////////////////////////////////////////////////////////
/// TXeleVolumeType是数量类型
/// 如果状态是撤单或者部撤 ，leavesVolume是已经成功撤单的数量；
/// 如果报单状态是部分成交 ，leavesVolume表示未成交数量 = 报单数量 - 累计成交数量
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleVolumeType;

/////////////////////////////////////////////////////////////////////////
/// TXeleSignedVolumeType是数量类型
/////////////////////////////////////////////////////////////////////////
typedef int TXeleSignedVolumeType;

/////////////////////////////////////////////////////////////////////////
///TXeleOrderTypeType是订单类型类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOrderTypeType;
#define XELE_MARKET_PRICE_TYPE     '1'  //市价(通用)
#define XELE_LIMIT_PRICE_TYPE      '2'  //限价(通用)
#define XELE_MARKET_LEFT_TO_LIMIT  'K'  //市价剩余转限价
#define XELE_MARKET_SELF_BEST      'U'  //本方最优(深交)

/////////////////////////////////////////////////////////////////////////
///TXeleSecuritiesIDType是合约编码类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleSecuritiesIDType[8];

/////////////////////////////////////////////////////////////////////////
///TXeleMarketType是交易所交易前置描述符类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleMarketType;
///Api登录使用，用来区分所登录的柜台类型
#define XELE_MARKET_SS  '1' //上交股票
#define XELE_MARKET_SZ  '2' //深交股票
#define XELE_MARKET_OS  '3' //上交期权
#define XELE_MARKET_OZ  '4' //深交期权

//与manager交互业务，资金查询接口使用
#define XELE_MARKET_SSE  '1' //上交柜台
#define XELE_MARKET_SZSE '2' //深交柜台

//（上交柜台+深交柜台）汇总后的资金查询 只为沪深柜台汇总资金查询接口使用，其他接口不能使用
#define XELE_MARKET_ALL  'a' //上交柜台+深交柜台


/////////////////////////////////////////////////////////////////////////
//TXeleDayTradingType是日内可转交易类型
//Y表示T+0，N表示T+1
/////////////////////////////////////////////////////////////////////////
typedef char TXeleDayTradingType;
#define T0 'Y'
#define T1 'N'

/////////////////////////////////////////////////////////////////////////
///TXeleOperwayType是委托方式类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOperwayType;
#define API_OPERWAY     '1'    //API报单
#define SOFT_OPERWAY    '2'   //其他方式报单
#define MONITOR_OPERWAY '|'//monitor撤单

/////////////////////////////////////////////////////////////////////////
///TXeleDirectionType是交易方向类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleDirectionType;
//若是报单方向
#define XELE_ORDER_BUY               '1'  //买
#define XELE_ORDER_SELL              '2'  //卖
#define XELE_ETF_CREATION            '3'  //etf申购
#define XELE_ETF_REDETPTION          '4'  //etf赎回
#define XELE_ORDER_WARM              '9'  //WARM单保持接口活性
//若是沪深资金调拨方向
#define XELE_TRANSFER_DIR_SS_2_SZ    '1'  //上交柜台调往深交柜台
#define XELE_TRANSFER_DIR_SZ_2_SS    '2'  //深交柜台调往上交柜台
//若是集中冻结方向
#define XELE_CENTER_CAP_FREEZE       '1'  //冻结集中资金
#define XELE_CENTER_CAP_UNFREEZE     '2'  //解冻集中资金


/////////////////////////////////////////////////////////////////////////
///TXeleInOutDirectionType是资券划拨方向类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleInOutDirectionType;
#define XELE_DIRECTION_IN             '1'  //划入：从集中交易把持仓划入到Xele柜台
#define XELE_DIRECTION_OUT            '2'  //划出：从Xele柜台把持仓划出到集中交易
#define XELE_DIRECTION_COVER_LOCK     '5'  //备兑锁定-CoverLock
#define XELE_DIRECTION_COVER_UNLOCK   '6'  //备兑解锁-CoverUnlock

/////////////////////////////////////////////////////////////////////////
///TXeleTimeConditionType是时间条件类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleTimeConditionType;
#define XELE_TIMEINFORCE_TYPE_GFD         '0'  //当日有效(通用)
#define XELE_TIMEINFORCE_TYPE_FIVE_TRADE  '1'  //市价最优五档全额成交剩余撤销(深交)
#define XELE_TIMEINFORCE_TYPE_IOC         '3'  //即时成交剩余自动撤销(通用)
#define XELE_TIMEINFORCE_TYPE_FOK         '4'  //即时全部成交否则撤销(通用)


/////////////////////////////////////////////////////////////////////////
///TXeleSecuritiesType是合约类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleSecuritiesType;
#define XELE_SECURITIES_TYPE_STOCK               1   //股票
#define XELE_SECURITIES_TYPE_FUND                2   //基金
#define XELE_SECURITIES_TYPE_BOND                3   //可转债券
#define XELE_SECURITIES_TYPE_NEW_STOCK           4   //新股
#define XELE_SECURITIES_TYPE_DIS_STOCK           5   //配股
#define XELE_SECURITIES_TYPE_NEW_BOND            6   //新债申购
#define XELE_SECURITIES_TYPE_DIS_BOND            7   //配债
#define XELE_SECURITIES_TYPE_TECH                8   //科创板or核准制创业板
#define XELE_SECURITIES_TYPE_NEW_TECH            9   //科创板申购or核准制创业板申购
#define XELE_SECURITIES_TYPE_DIS_TECH            10  //科创板配股or核准制创业板配股
#define XELE_SECURITIES_TYPE_NON_TRADING         11  //非交易类型
#define XELE_SECURITIES_TYPE_RISK_STOCK          12  //风险警示股
#define XELE_SECURITIES_TYPE_NEW_FUND            13  //新基金
#define XELE_SECURITIES_TYPE_UNREGIST_TECH       14  //注册制创业板
#define XELE_SECURITIES_TYPE_UNREGIST_NEW_TECH   15  //注册制创业板申购
#define XELE_SECURITIES_TYPE_UNREGIST_DIS_TECH   16  //注册制创业板配股
#define XELE_SECURITIES_TYPE_REV_REPURCHASE      17  //国债逆回购
#define XELE_SECURITIES_TYPE_ETF_FUND            18  //ETF基金
#define XELE_SECURITIES_TYPE_MONETARY_ETF_FUND   19  //货币ETF基金
#define XELE_SECURITIES_TYPE_TREASURY_ETF_FUND   20  //国债ETF基金
#define XELE_SECURITIES_TYPE_LOF_ETF_FUND        23  //LOF基金
#define XELE_SECURITIES_TYPE_CLOSED_ETF_FUND     24  //封闭式基金

/////////////////////////////////////////////////////////////////////////
///TXeleTimeType是长时间类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleTimeType[21];

/////////////////////////////////////////////////////////////////////////
///TXeleOffsetFlagType是开平标志类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOffsetFlagType;
#define XELE_COMBOFFSET_FLAG_CLOSE  'C'  //平仓
#define XELE_COMBOFFSET_FLAG_OPEN   'O'  //开仓

/////////////////////////////////////////////////////////////////////////
///TXeleOrderStatusType是报单状态类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOrderStatusType;
#define ODRSTAT_UNREPORT         '0'  //未报
#define ODRSTAT_REPORTING        '1'  //正报
#define ODRSTAT_REPORTED         '2'  //已报
#define ODRSTAT_REPORTED_ACTION  '3'  //已报待撤
#define ODRSTAT_PTRADE_ACTION    '4'  //部成待撤
#define ODRSTAT_PACTION          '5'  //部撤
#define ODRSTAT_ACTIONED         '6'  //已撤
#define ODRSTAT_PTRADE           '7'  //部成
#define ODRSTAT_TRADED           '8'  //已成
#define ODRSTAT_ERROR            '9'  //废单

/////////////////////////////////////////////////////////////////////////
///TXeleQryStatusType是报单查询中订单状态类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned short TXeleQryStatusType;
#define QRYSTAT_UNREPORT				(1)				// 未报
#define QRYSTAT_REPORTING				(1<<1)			// 正报
#define QRYSTAT_REPORTED				(1<<2)			// 已报
#define QRYSTAT_REPORTED_ACTION			(1<<3)			// 已报待撤
#define QRYSTAT_PTRADE_ACTION			(1<<4)			// 部成待撤
#define QRYSTAT_PACTION					(1<<5)			// 部撤
#define QRYSTAT_ACTIONED				(1<<6)			// 已撤
#define QRYSTAT_PTRADE					(1<<7)			// 部成
#define QRYSTAT_TRADED					(1<<8)			// 已成
#define QRYSTAT_ERROR					(1<<9)			// 废单

/////////////////////////////////////////////////////////////////////////
///TXeleQryStatusType是报单查询中订单业务类型(期权使用)
/////////////////////////////////////////////////////////////////////////
typedef unsigned short TXeleQryBusinessType;
#define OPTION_QRYBUS_ORDER_INSERT				 (1)				// 普通报单
#define OPTION_QRYBUS_ORDER_ACTION				 (1<<1)			    // 普通撤单
#define OPTION_QRYBUS_EXERCISE_INSERT	         (1<<2)	            // 单腿行权报单
#define OPTION_QRYBUS_EXERCISE_ACTION			 (1<<3)			    // 单腿行权撤单
#define OPTION_QRYBUS_COM_EXERCISE_INSERT        (1<<4)			    // 组合行权报单
#define OPTION_QRYBUS_COM_EXERCISE_ACTION		 (1<<5)	            // 组合行权撤单
#define OPTION_QRYBUS_COM_SPLIT_ENTRUST		     (1<<6)			    // 组合与拆分
#define OPTION_QRYBUS_LOCKING_UNLOCKING          (1<<7)				// 锁定与解锁

#define DISPATCHFAIL          '0'  //调拨结果标记，失败
#define DISPATCHSUCCESS       '1'  //调拨结果标记，成功

/////////////////////////////////////////////////////////////////////////
///TXeleMoneyType是资金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleMoneyType;

/////////////////////////////////////////////////////////////////////////
///TXeleUserIDType是交易用户代码类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleUserIDType[15];

/////////////////////////////////////////////////////////////////////////
///TXeleQFIIPositionType是QFII持仓类型
/////////////////////////////////////////////////////////////////////////
typedef int TXeleQFIIPositionType;

/////////////////////////////////////////////////////////////////////////
///调入/调出资金类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleTransferType;
///可用资金
#define XELE_TRANSFER_AMOUNT  0
///RTGS交收额度
#define XELE_TRANSFER_RTGS    1

/////////////////////////////////////////////////////////////////////////
///TXeleUserPasswordType是交易用户密码类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleUserPasswordType[10];

/////////////////////////////////////////////////////////////////////////
///TXeleAppIDType是终端软件AppID类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleAppIDType[29];

/////////////////////////////////////////////////////////////////////////
///TXeleAppIDExtType是终端软件AppID扩展类型，AppID最多支持40字节
/////////////////////////////////////////////////////////////////////////
typedef char TXeleAppIDExtType[11];

/////////////////////////////////////////////////////////////////////////
///TXeleAuthCodeType是终端软件授权码类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleAuthCodeType[17];

/////////////////////////////////////////////////////////////////////////
///TXeleTradeIPType是IP类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleTradeIPType[15];

/////////////////////////////////////////////////////////////////////////
///TXeleTradePortType是Port类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned short TXeleTradePortType;

/////////////////////////////////////////////////////////////////////////
///TXeleTradeFlagType是交易通道是否有效标志类型, 0：无效，1：有效
/////////////////////////////////////////////////////////////////////////
typedef bool TXeleTradeFlagType;
#define TRADEFLAGNOUSE 0
#define TRADEFLAGUSE 1

/////////////////////////////////////////////////////////////////////////
///TXeleTradeType是交易通道标志类型, 0 硬件通道 1 软件通道
/////////////////////////////////////////////////////////////////////////
typedef char TXeleTradeType;
#define TRADETYPEOFFPGA '0'
#define TRADETYPEOFSOFT '1'

/////////////////////////////////////////////////////////////////////////
///TXeleTradeType是互联网环境标识类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleInternetType;
#define NOT_INTERNET_CONNECTION     '0'  //互联网环境
#define IS_INTERNET_CONNECTION      '1'  //非互联网环境

/////////////////////////////////////////////////////////////////////////
///TXeleErrorIdType是错误码类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned short TXeleErrorIdType;

/////////////////////////////////////////////////////////////////////////
///TXeleErrorTypeType是错误类别类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleErrorTypeType;

/////////////////////////////////////////////////////////////////////////
///TXeleIsLastType是结束标志类型
/////////////////////////////////////////////////////////////////////////
typedef bool TXeleIsLastType;

/////////////////////////////////////////////////////////////////////////
///TXeleDateType是日期类型  也是用户自动重连的校验字段
/////////////////////////////////////////////////////////////////////////
typedef char TXeleDateType[9];

/////////////////////////////////////////////////////////////////////////
///TXeleShortTimeType是短时间类型
///格式：HHMMSSmmm(时分秒毫秒)
/////////////////////////////////////////////////////////////////////////
typedef char TXeleShortTimeType[9];

/////////////////////////////////////////////////////////////////////////
///TXeleSecuritiesCommissionType是一个合约佣金费率类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleSecuritiesCommissionType;

/////////////////////////////////////////////////////////////////////////
///TXeleTransferFeeRateType是一个交易所过户费率类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleTransferFeeRateType;

/////////////////////////////////////////////////////////////////////////
///TXeleStampTaxRateType是一个交易所过户费率类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleStampTaxRateType;

/////////////////////////////////////////////////////////////////////////
///TXeleTrafficFeeType是一个交易所流量费率类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleTrafficFeeType;

/////////////////////////////////////////////////////////////////////////
///TXeleMinCommissionType是一个最小佣金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleMinCommissionType;

/////////////////////////////////////////////////////////////////////////
///TXeleMoreFreeze是一个多冻值类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleMoreFreeze;

/////////////////////////////////////////////////////////////////////////
///TXeleETFCreationRedemptionExtraFee是一个ETF申赎附加费类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleETFCreationRedemptionExtraFee;

/////////////////////////////////////////////////////////////////////////
///TXeleETFCreationRedemptionCommFeeRate是一个ETF申赎佣金费率类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleETFCreationRedemptionCommFeeRate;

/////////////////////////////////////////////////////////////////////////
///TXeleETFCreationRedemptionTransferFeeRate是一个ETF申赎过户费类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleETFCreationRedemptionTransferFeeRate;

/////////////////////////////////////////////////////////////////////////
///TXeleTotalFeeType是总手续费类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleTotalFeeType;

/////////////////////////////////////////////////////////////////////////
///TXeleFrozeMarginType是一个冻结保证金（股票叫冻结资金）类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleFrozeMarginType;

/////////////////////////////////////////////////////////////////////////
///TXeleFrozenFeeType是一个冻结手续费类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleFrozenFeeType;

/////////////////////////////////////////////////////////////////////////
///TXeleUsedFeeType是一个已付手续费类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleUsedFeeType;

/////////////////////////////////////////////////////////////////////////
///TXeleAvailableFundType是一个可用资金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleAvailableFundType;

/////////////////////////////////////////////////////////////////////////
///TXeleTotalFundType是一个总资金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleTotalFundType;

/////////////////////////////////////////////////////////////////////////
///TXeleSellFund是一个卖出资金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleSellFund;

/////////////////////////////////////////////////////////////////////////
///TXeleBuyFund是一个买入资金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleBuyFund;

/////////////////////////////////////////////////////////////////////////
///TXeleTdBuyPositionType是一个今买持仓类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleTdBuyPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleTdSellPositionType是一个今卖持仓类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleTdSellPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleYdPositionType是一个昨持仓类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleYdPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleTotalPositionType是一个总持仓类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleTotalPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleTotalCostType是一个持仓成本类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleTotalCostType;

/////////////////////////////////////////////////////////////////////////
///TXeleSecuritiesNameType是一个合约名称类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleSecuritiesNameType[30];

/////////////////////////////////////////////////////////////////////////
///TXeleSecuritiesSubTypeType是一个合约子品种类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleSecuritiesSubTypeType[5];

/////////////////////////////////////////////////////////////////////////
///TXeleSecuritiesSubType是一个证券类别类型,枚举详见文档
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleSecuritiesSubType;

/////////////////////////////////////////////////////////////////////////
///TXelePreSettlePriceType是一个昨结算价类型
/////////////////////////////////////////////////////////////////////////
typedef double TXelePreSettlePriceType;

/////////////////////////////////////////////////////////////////////////
///TXeleLimitPriceClassType是一个涨跌幅限制类型类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleLimitPriceClassType;

/////////////////////////////////////////////////////////////////////////
///TXeleMaxLimitOrderVolumeType是一个限价单最大下单量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleMaxLimitOrderVolumeType;

/////////////////////////////////////////////////////////////////////////
///TXeleMinLimitOrderVolumeType是一个限价单最小下单量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleMinLimitOrderVolumeType;

/////////////////////////////////////////////////////////////////////////
///TXeleMaxMarketOrderVolumeType是一个市价单最大下单量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleMaxMarketOrderVolumeType;

/////////////////////////////////////////////////////////////////////////
///TXeleMinMarketOrderVolumeType是一个市价单最大小单量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleMinMarketOrderVolumeType;

/////////////////////////////////////////////////////////////////////////
///TXeleLowerPriceType是一个跌停板价类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleLowerPriceType;

/////////////////////////////////////////////////////////////////////////
///TXeleFlowRebuildType流水重构类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleFlowRebuildType;
#define XELE_FLOW_REBUILD_DEFAULT        0  // 不进行流水重构
#define XELE_FLOW_REBUILD_CAP            1  // 只进行资金流水重构
#define XELE_FLOW_REBUILD_ORDER          2  // 只进行报文流水重构
#define XELE_FLOW_REBUILD_CAP_AND_ORDER  3  // 资金和报文流水重构同时进行

/////////////////////////////////////////////////////////////////////////
///TXeleUpperPriceType是一个涨停板价类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleUpperPriceType;

/////////////////////////////////////////////////////////////////////////
///TXeleCurrencyType是一个币种类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCurrencyType;
#define XELE_CURRENCY_TYPE_CNY  '0'  //人民币
#define XELE_CURRENCY_TYPE_USD  '1'  //美元
#define XELE_CURRENCY_TYPE_HKD  '2'  //港币

/////////////////////////////////////////////////////////////////////////
///TXeleRtnDateType是一个业务日期类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleRtnDateType[10];

/////////////////////////////////////////////////////////////////////////
///TXeleSnoType是一个流水号类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleSnoType;

/////////////////////////////////////////////////////////////////////////
///TXeleRemarkType是一个备注类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleRemarkType[32];

/////////////////////////////////////////////////////////////////////////
///TXeleOrgIDType是一个机构代码类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOrgIDType[4];

/////////////////////////////////////////////////////////////////////////
///TXeleClientIpType是一个客户端IP类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleClientIpType[25];

/////////////////////////////////////////////////////////////////////////
///TXeleClientMacType是一个客户端MAC类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleClientMacType[18];

/////////////////////////////////////////////////////////////////////////
///TXeleSubClientIndexType是一个客户端登录子节点类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleSubClientIndexType;

/////////////////////////////////////////////////////////////////////////
///TXeleHeartBeatInterval返回的心跳时间
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleHeartBeatInterval;

/////////////////////////////////////////////////////////////////////////
///TXeleHeartBeatTimeout返回的心跳超时时间
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleHeartBeatTimeout;

/////////////////////////////////////////////////////////////////////////
///TXeleReservedType是一个预留类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleReservedType[128];

/////////////////////////////////////////////////////////////////////////
///TXeleReserved1Type是一个预留类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleReserved1Type[64];

/////////////////////////////////////////////////////////////////////////
///TXeleReserved3Type是一个预留类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleReserved3Type[12];

/////////////////////////////////////////////////////////////////////////
///TXeleAvgPxType是一个持仓均价类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleAvgPxType;

/////////////////////////////////////////////////////////////////////////
///TXeleUnTdPositionType是一个在途持仓类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleUnTdPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleCoveredFrozenPositionType是一个备兑冻结量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleCoveredFrozenPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleCoveredFlagType是一个备兑标志类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCoveredFlagType;
#define XELE_SZSE_FLAG_COVERED    '0'  //深交备兑
#define XELE_SZSE_FLAG_UNCOVERED  '1'  //深交非备兑
#define XELE_SSE_FLAG_COVERED     '1'  //上交备兑
#define XELE_SSE_FLAG_UNCOVERED   ' '  //上交非备兑

/////////////////////////////////////////////////////////////////////////
///TXeleExchangeIDType是一个交易所代码类型
///返回值为实际报单的网关id + 1
///返回值为1代表是0号网关,2代表1号网关
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleExchangeIDType;

/////////////////////////////////////////////////////////////////////////
///TXeleExchangeIDType是一个交易所代码类型
///返回值为实际报单的网关id + 1
///例如: 返回值为1代表是0号网关,2代表1号网关
/////////////////////////////////////////////////////////////////////////
typedef int TXeleExchangeIDIntType;

/////////////////////////////////////////////////////////////////////////
///TXeleMarketIDType是一个市场代码类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleMarketIDType;
#define XELE_MARKET_TYPE_SSEA    '1'    //上交A股
#define XELE_MARKET_TYPE_SSEB    '2'    //上交B股
#define XELE_MARKET_TYPE_SZSEA   '3'    //深交A股
#define XELE_MARKET_TYPE_SZSEB   '4'    //深交B股
#define XELE_MARKET_TYPE_SZSETH  '5'    //深交三板

/////////////////////////////////////////////////////////////////////////
///TXeleMinTickPriceType是一个最小价格变动单位类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleMinTickPriceType;

/////////////////////////////////////////////////////////////////////////
///TXeleTradeOwnerType是一个订单所有类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleTradeOwnerType;
#define XELE_OWNER_PERSONAL_TYPE      1    //个人投资者发起
#define XELE_OWNER_EXCHANGE_TYPE      101  //交易所发起
#define XELE_OWNER_PART_TYPE          102  //会员发起
#define XELE_OWNER_ORG_TYPE           103  //机构投资者发起
#define XELE_OWNER_SELF_MANAGE_TYPE   104  //自营交易发起
#define XELE_OWNER_SUPPLY_TYPE        105  //流动性服务提供商发起

/////////////////////////////////////////////////////////////////////////
///TXeleRecoveryFlagType是流水重构报文标记类型, 0:非流水重构  1:流水重构
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleRecoveryFlagType;

/////////////////////////////////////////////////////////////////////////
///TTXeleStrOrderSysIDType是交易所柜台报单编号类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleStrOrderSysIDType[10];

/////////////////////////////////////////////////////////////////////////
///TXeleInvestorIDType是投资者ID类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleInvestorIDType[10];

/////////////////////////////////////////////////////////////////////////
///TXeleInvestorNameType是投资者姓名类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleInvestorNameType[30];

/////////////////////////////////////////////////////////////////////////
///TXeleInvestorRightsType是投资者权限类型
///0: 普通股票交易权限
///1: SS:科创板权限  SZ:核准制创业板权限
///2: 可买入可转债券
///3: SZ:为可买入注册制创业板
///4: 可买入退市整理期股票
/////////////////////////////////////////////////////////////////////////
typedef char TXeleInvestorRightsType[30];

/////////////////////////////////////////////////////////////////////////
///TXeleInvestorPbuType是投资者席位号类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleInvestorPbuType[10];

///TXeleStockLevel股票风险级别 , '0' 正常, '1' 风险警示, '2' 退市整理期
/////////////////////////////////////////////////////////////////////////
typedef char TXeleStockLevel;
#define STOCK_NORMAL '0'
#define STOCK_RISK   '1'
#define STOCK_OUT    '2'

/////////////////////////////////////////////////////////////////////////
///TXeleRemainingPosition剩余持仓数量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleRemainingPosition;

/////////////////////////////////////////////////////////////////////////
///TXeleAvailablePosition剩余持仓数量类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleAvailablePosition;

/////////////////////////////////////////////////////////////////////////
///TXeleLotSize最小价格单位类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleLotSize;

/////////////////////////////////////////////////////////////////////////
///TXeleFundType是集中交易柜台主资金标志类型
/////////////////////////////////////////////////////////////////////////
typedef int TXeleFundType;

/////////////////////////////////////////////////////////////////////////
///TXeleStockQuotaType是一个新股配股额度类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleStockQuotaType;

/////////////////////////////////////////////////////////////////////////
///TXeleUniqueNumberType全局唯一消息编号类型,从1开始递增
/////////////////////////////////////////////////////////////////////////
typedef int TXeleUniqueNumberType;

/////////////////////////////////////////////////////////////////////////
///TXeleIsFundReversalType是否进行了资金冲正操作标记类型
///‘0’：非资金冲正操作，‘1’：资金冲正操作
/////////////////////////////////////////////////////////////////////////
typedef char TXeleIsFundReversalType;

/////////////////////////////////////////////////////////////////////////
///TXeleReversalCounterType资金冲正柜台标记类型
///'SS'表示上交柜台，'SZ'表示深交柜台 '--'表示无效
/////////////////////////////////////////////////////////////////////////
typedef char TXeleReversalCounterType[2];

/////////////////////////////////////////////////////////////////////////
///TXeleReversalResultType资金冲正结果标记类型
///‘1’：正在处理中 ‘2’：处理成功 ‘3’：处理失败 ‘-’表示无效
/////////////////////////////////////////////////////////////////////////
typedef char TXeleReversalResultType;

/////////////////////////////////////////////////////////////////////////
///TXeleCounterURL是一个柜台连接地址类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCounterURL[30];

/////////////////////////////////////////////////////////////////////////
///TXeleApiVersionAPI版本
/////////////////////////////////////////////////////////////////////////
typedef char TXeleApiVersion[30];

/////////////////////////////////////////////////////////////////////////
///TXeleApiModeAPI模式
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleApiMode;

/////////////////////////////////////////////////////////////////////////
///TXeleIpAddrType是客户端ip地址
/////////////////////////////////////////////////////////////////////////
typedef char TXeleIpAddrType[16];

/////////////////////////////////////////////////////////////////////////
///TXeleIpAddrType是客户端mac地址
/////////////////////////////////////////////////////////////////////////
typedef char TXeleMacAddrType[19];

/////////////////////////////////////////////////////////////////////////
///TXeleIpAddrType是客户端主机名称
/////////////////////////////////////////////////////////////////////////
typedef char TXeleHostNameType[21];

/////////////////////////////////////////////////////////////////////////
///TXeleIpAddrType是客户端cpu序列号
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCpuSerialType[21];

/////////////////////////////////////////////////////////////////////////
///TXeleIpAddrType是客户端硬盘序列号
/////////////////////////////////////////////////////////////////////////
typedef char TXeleHardDiskSerialType[33];

/////////////////////////////////////////////////////////////////////////
///TXeleCallOneceFlag 只执行一次集中柜台冻结
/////////////////////////////////////////////////////////////////////////
typedef bool TXeleCallOneceFlag;

/////////////////////////////////////////////////////////////////////////
///TXelePreOrderFlag 预埋单标记
///'0':非预埋单 '1':预埋单
/////////////////////////////////////////////////////////////////////////
typedef char TXelePreOrderFlag;
#define PREORDERFLAGOPEN 1
#define PREORDERFLAGCLOSE 0

/////////////////////////////////////////////////////////////////////////
///TXeleIsAutoTransFlag 资金自动调拨标记
///'0':非自动调拨 '1':自动调拨
/////////////////////////////////////////////////////////////////////////
typedef char TXeleIsAutoTransFlag;

/////////////////////////////////////////////////////////////////////////
///TXeleProtocolFlag Api协议号标记字段 ‘0’表示2.5（含）之前的协议 ‘1’表示3.0协议 用户无需填写
/////////////////////////////////////////////////////////////////////////
typedef char TXeleProtocolFlag;
#define API_PROTOCOL_2_5 '0'
#define API_PROTOCOL_3_0 '1'

/////////////////////////////////////////////////////////////////////////
///TXeleCentralTradingErrorIdType 是集中交易响应错误编码类型
/////////////////////////////////////////////////////////////////////////
typedef int TXeleCentralTradingErrorIdType;

/////////////////////////////////////////////////////////////////////////
///TXeleCentralTradingErrorMsgType 是集中交易响应错误信息类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCentralTradingErrorMsgType[48];

/////////////////////////////////////////////////////////////////////////
///TXeleCentralTradingErrorMsgLongType 是集中交易响应错误信息长类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCentralTradingErrorMsgLongType[256];

/////////////////////////////////////////////////////////////////////////
///TXeleIsUpdateFpgaFundType fpga资金是否更新类型，0表示没有更新， 1表示更新
/////////////////////////////////////////////////////////////////////////
typedef bool TXeleIsUpdateFpgaFundType;

/////////////////////////////////////////////////////////////////////////
///TXeleSortType 报单查询返回排序方式
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleSortType;
#define XELE_SORT_DEFAULT    0     ///默认排序
#define XELE_SORT_TIME       1     ///按时间正排序 先报的单先查到
#define XELE_SORT_TIME_DESC  2     ///按时间倒排序 新报的单先查到

/////////////////////////////////////////////////////////////////////////
///TXeleQryEtfTradeFlag Etf成交记录查询标志
/////////////////////////////////////////////////////////////////////////
typedef bool TXeleQryEtfTradeFlag;
#define XELE_NO_QRY_ETF_TRADE 0 ///请求中表示不查询Etf成交，回报中表示非Etf成交记录
#define XELE_QRY_ETF_TRADE    1 ///请求中表示查询Etf成交，回报中表示Etf成交记录

/////////////////////////////////////////////////////////////////////////
///TXeleSoftRspRcvType是软件节点是否接收其他节点回报信息类型
///0:不接收其他节点消息 1:接收其他节点消息
/////////////////////////////////////////////////////////////////////////
typedef bool TXeleSoftRspRcvType;

/////////////////////////////////////////////////////////////////////////
///TXeleFpgaRspRcvType是硬件节点是否接收其他节点回报信息类型
///'0':不接收其他节点消息 '1':接收其他节点消息
/////////////////////////////////////////////////////////////////////////
typedef char TXeleFpgaRspRcvType;

/////////////////////////////////////////////////////////////////////////
///TXelePcPreFixType是终端站点前缀信息类型
/////////////////////////////////////////////////////////////////////////
typedef char TXelePcPreFixType[33];

/////////////////////////////////////////////////////////////////////////
///TXeleHardDiskPartitionType是终端站点硬盘分区信息类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleHardDiskPartitionType[21];

/////////////////////////////////////////////////////////////////////////
///TXeleFrozenFundType冻结资金类型
/////////////////////////////////////////////////////////////////////////
typedef double TXeleFrozenFundType;

/////////////////////////////////////////////////////////////////////////
///TXeleFrozenPositionType冻结持仓类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleFrozenPositionType;

/////////////////////////////////////////////////////////////////////////
///TXeleBranchNoType分支机构类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleBranchNoType;

/////////////////////////////////////////////////////////////////////////
///TXeleUnSyncOrderFlag主柜台未同步到备机的委托类型 0:从主机同步的单子  1:非主机同步的单子
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleUnSyncOrderFlag;

/////////////////////////////////////////////////////////////////////////
///TXeleGateWay 平台可用网关（格式是1,2,3等以逗号分隔)
/////////////////////////////////////////////////////////////////////////
typedef char TXeleGateWay[90];
#define UNSYNCORDER_0    /// 已同步
#define UNSYNCORDER_1    /// 未同步

/////////////////////////////////////////////////////////////////////////
///TXeleCommandNum 命令号类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleCommandNum[20];

/////////////////////////////////////////////////////////////////////////
///TXelePrcSecuritiesType证券类别,
///'1' 股票、'2' 基金、 '3' 债券
///若柜台多种类型合并配置，则以逗号分隔返回，如'2','3'
/////////////////////////////////////////////////////////////////////////
typedef char TXelePrcSecuritiesType[10];

/////////////////////////////////////////////////////////////////////////
///TXelePrcProgramType程序化风控类别
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXelePrcProgramType;
#define PRCPROGRAM_ALL                  0   ///默认返回所有
#define PRCPROGRAM_DAILY_LIMIT          1   ///全天报撤笔数限制风控
#define PRCPROGRAM_RATE_LIMIT           2   ///流速风控

/////////////////////////////////////////////////////////////////////////
///TXelePrcProgramType程序化风控开关类型
///'0' 关，'1' 开
/////////////////////////////////////////////////////////////////////////
typedef char TXelePrcProgramEnableType;


/////////////////////////////////////////////////////////////////////////
///TXelePrcProgramUnitTimeType ///单位时间(毫秒)
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleTimeUnitType;

/////////////////////////////////////////////////////////////////////////
///TXelePrcProgramTresholdType程序化风控阈值类型
/////////////////////////////////////////////////////////////////////////
typedef uLong TXelePrcProgramTresholdType;

/////////////////////////////////////////////////////////////////////////
///TXeleCurEntrustActionNumType
/////////////////////////////////////////////////////////////////////////
typedef uLong TXeleCurrentOrderCountType;

/////////////////////////////////////////////////////////////////////////
///TXeleOrderSourceType报单来源类型
/////////////////////////////////////////////////////////////////////////
typedef char TXeleOrderSourceType;
#define ORDERSOURCEFPGA          '0'  ///api硬件通道报单
#define ORDERSOURCESOFT          '1'  ///API软件通道报单
#define ORDERSOURCEWEB           '2'  ///web撤单
#define ORDERSOURCEGATEWAYSELF   '3'  ///接入网关报单(本平台报单)
#define ORDERSOURCEGATEWAYOTHER  '4'  ///接入网关报单(其他平台报单)

/////////////////////////////////////////////////////////////////////////
///TXeleQtyType 64位长整型数量类型
/////////////////////////////////////////////////////////////////////////
typedef long long TXeleQtyType;

/////////////////////////////////////////////////////////////////////////
///TXeleQuantityType 32位整型数量类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned int TXeleQuantityType;

/////////////////////////////////////////////////////////////////////////
///TXeleSecuritySourceType 证券来源
/////////////////////////////////////////////////////////////////////////
typedef char TXeleSecuritySourceType;

/////////////////////////////////////////////////////////////////////////
///TXeleRecordNumType 本市场成份证券数
/////////////////////////////////////////////////////////////////////////
typedef short TXeleRecordNumType;

/////////////////////////////////////////////////////////////////////////
///TXeleSecurityName 证券名称
/////////////////////////////////////////////////////////////////////////
typedef char TXeleSecurityName[40];

/////////////////////////////////////////////////////////////////////////
///TXeleSubstituteFlag 现金替代标记
/////////////////////////////////////////////////////////////////////////
typedef char TXeleSubstituteFlag;

/////////////////////////////////////////////////////////////////////////
///TXeleRightFlag 权限标记
/////////////////////////////////////////////////////////////////////////
typedef char TXeleRightFlag;

/////////////////////////////////////////////////////////////////////////
///TXeleTotalRecordNum 所有成份证券数
/////////////////////////////////////////////////////////////////////////
typedef int TXeleTotalRecordNum;

/////////////////////////////////////////////////////////////////////////
///TXeleChannelType通道类型1-FPGA-FpgaChannel, 2-软件-SoftwareChannel
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleChannelType;
#define FpgaChannel 1
#define SoftwareChannel 2

/////////////////////////////////////////////////////////////////////////
///TXeleGateWayID网关编号
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleGateWayID;

/////////////////////////////////////////////////////////////////////////
///TXeleGateWayID网关类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleGateWayType;
#define SZSEMTP  1    ///深交所现货集中竞价交易平台
#define SZSECFP  2    ///深交所综合金融服务平台
#define SZSENTP  3    ///深交所非交易处理平台
#define SZSEDTP  4    ///深交所衍生品集中竞价交易平台
#define SZSEITP  5    ///深交所国际市场互联平台
#define SZSEFISP 6    ///深交所固定收益交易平台
#define SZSEMD   7    ///深交所行情
#define SSEMTP   21   ///上交所竞价撮合平台
#define SSEATP   22   ///上交所综合业务平台
#define SSEDTP   23   ///上交所期权业务平台
#define ITP      24   ///上交所港股通平台
#define SSEXBTP  25   ///上交所新债券交易平台
#define SSEFISP  26   ///上交所固定收益平台
#define SSEIITP  27   ///上交所互联网交易平台
#define SSEMD    28   ///上交所行情

/////////////////////////////////////////////////////////////////////////
///TXeleGateWayID网关状态
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleGateWayStatus;
#define TgwNotOpen  1     ///未开放
#define TgwPreOpen  2     ///预开放
#define TgwOpen     3     ///开放
#define TgwBreak    4     ///暂停
#define TgwClose    5     ///关闭
#define TgwOffline  6     ///离线
#define TgwDisabled 7     ///禁用

/////////////////////////////////////////////////////////////////////////
///TXeleGateWayID最近一次网关状态的更新时间
///格式：HHMMSSsssuuunnn
/////////////////////////////////////////////////////////////////////////
typedef long int TXeleEnterTime;

/////////////////////////////////////////////////////////////////////////
///划拨模式类型
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleInOutMode;
#define INOUT_MODE_THROUGH_CENTRAL          1  ///经过集中柜台
#define INOUT_MODE_NO_THROUGH_CENTRAL       2  ///不经过集中柜台

/////////////////////////////////////////////////////////////////////////
///TXeleInvestorFlag 专业投资者标志
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleInvestorFlag;
#define PersonalInvestor 1      /// 普通投资者
#define ProfessionalInvestor 2  /// 专业投资者

/////////////////////////////////////////////////////////////////////////
///TXeleIssueType 发行方式
/// 1-配股配债-RightsIssue
/// 2-增发-SeasonedEquitOffering
/// 3-新股申购-InitialPublicOffering
/// 4-新债申购-InitialBondOffering
/// 5-基金申购-InitialFundOffering
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleIssueType;

/////////////////////////////////////////////////////////////////////////
///TXeleIssueType 是否注册制,Y-是-Yes,N-否-No
/////////////////////////////////////////////////////////////////////////
typedef char TXeleIsRegistration;

/////////////////////////////////////////////////////////////////////////
///TXeleIsNoTrading 是否非交易,0-否-No,1-是-Yes
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleIsNoTrading;

/////////////////////////////////////////////////////////////////////////
///TXeleIsNoTrading 操作来源
/////////////////////////////////////////////////////////////////////////
typedef unsigned char TXeleActionSourceType;
#define XELE_ACTION_SOURCE_API  1      //API发起的
#define XELE_ACTION_SOURCE_MONITOR  2  //monitor发起的
#define XELE_ACTION_SOURCE_MANAGER  3  //manager发起的

#endif

