# encoding: utf-8

"""
function: 将api旧函数名替换为新函数名
usage: python replace_api_func_name.py 路径
eg: python replace_api_func_name.py ./
author: yifengg
date: 2021/12/17
"""

import os
import time
import sys


func_name_list = [
    ('CreateTraderApi', 'createTraderApi'),
    ('GetVersion', 'getVersion'),
    ('Join', 'join'),
    ('Release', 'release'),
    ('RegisterSpi', 'registerSpi'),
    ('ReqUserLogin', 'reqLogin'),
    ('ReqUserUpdatePwd', 'reqUpdatePwd'),
    ('ReqUserLogout', 'reqLogout'),
    ('OnRspUserLogin', 'onRspLogin'),
    ('OnRspInitTrader', 'onRspInitTrader'),
    ('OnRspUserUpdatePwd', 'onRspUpdatePwd'),
    ('OnRspUserLogout', 'onRspLogout'),
    ('OnFrontQueryDisconnected', 'onFrontQueryDisconnected'),
    ('OnFrontTradeDisconnected', 'onFrontTradeDisconnected'),
    ('OnApiMsg', 'onApiMsg'),
    ('ReqOrderInsert', 'reqInsertOrder'),
    ('ReqOrderAction', 'reqCancelOrder'),
    ('ReqQryOrder', 'reqQryOrder'),
    ('ReqQryTrade', 'reqQryTrade'),
    ('OnRspOrderInsert', 'onRspInsertOrder'),
    ('OnErrRtnOrderInsert', 'onErrRtnInsertOrder'),
    ('OnRspOrderAction', 'onRspCancelOrder'),
    ('OnErrRtnOrderAction', 'onErrRtnCancelOrder'),
    ('OnRtnOrder', 'onRtnOrder'),
    ('OnRtnTrade', 'onRtnTrade'),
    ('OnRspQryOrder', 'onRspQryOrder'),
    ('OnRspQryTrade', 'onRspQryTrade'),
    ('ReqQryStockFee', 'reqQryRate'),
    ('ReqFreezeCap', 'reqInFund'),
    ('ReqUnfreezeCap', 'reqOutFund'),
    ('ReqQryCapTransferRecord', 'reqQryInOutFundRecord'),
    ('ReqBTCapTransfer', 'reqBTFundTransfer'),
    ('ReqBTCapTransferRecord', 'reqQryBTFundTransferRecord'),
    ('ReqQryStockClientAccount', 'reqQryFund'),
    ('ReqQryInvestorStockPosition', 'reqQryPosition'),
    ('ReqQryStockSecurities', 'reqQrySecurities'),
    ('ReqQryStockQuota', 'reqQryRightsAndInterests'),
    ('OnRspQryStockFee', 'onRspQryRate'),
    ('OnRspQryCentralTradingFund', 'onRspQryCentralTradingFund'),
    ('OnRspFreezeCap', 'onRspInFund'),
    ('OnRspUnfreezeCap', 'onRspOutFund'),
    ('OnRspQryCapTransferRecord', 'onRspQryInOutFundRecord'),
    ('OnRspBTCapTransfer', 'onRspBTFundTransfer'),
    ('OnRspBTCapTransferRecord', 'onRspQryBTFundTransferRecord'),
    ('OnRspQryStockClientAccount', 'onRspQryFund'),
    ('OnRspQryStockPosition', 'onRspQryPosition'),
    ('OnRspQryStockSecurities', 'onRspQrySecurities'),
    ('OnRspQryStockQuota', 'reqQryRightsAndInterests'),
    ('GetRebuildFlag', 'getRebuildFlag'),
    ('ReqOptionCombInsert', 'reqInsertCombOrder'),
    ('ReqExerciseInsert', 'reqInsertExercise'),
    ('ReqExerciseInsert', 'reqCancelExercise'),
    ('ReqExerciseCombInsert', 'reqInsertExerciseComb'),
    ('ReqExerciseCombAction', 'reqCanceExerciseComb'),
    ('ReqQryInvestorOptionPosition', 'reqQryOptionPosition'),
    ('ReqQryOptionClientAccount', 'reqQryOptionFund'),
    ('ReqQryOptionSecurities', 'reqQryOptionSecurities'),
    ('ReqQryOptionMarginFee', 'reqQryOptionRate'),
    ('ReqQryOptionCombPosition', 'reqQryOptionCombPosition'),
    ('OnRspRebuildFinish', 'onRspRebuildFinish'),
    ('OnRspOptionCombInsert', 'onRspInsertCombOrder'),
    ('OnRspOptionCombInsert', 'onErrRtnInsertCombOrder'),
    ('OnRtnOptionCombOrder', 'onRtnCombOrder'),
    ('OnRtnOptionCombTrade', 'onRtnCombTrade'),
    ('OnRspExerciseInsert', 'onRspInsertExercise'),
    ('OnErrRtnExerciseOrderInsert', 'onErrRtnInsertExercise'),
    ('OnRspExerciseAction', 'onRspCancelExercise'),
    ('OnErrRtnExerciseAction', 'onErrRtnCancelExercise'),
    ('OnRtnExerciseOrder', 'onRtnExerciseOrder'),
    ('OnErrRtnExerciseCombInsert', 'onRspInsertExerciseComb'),
    ('OnErrRtnExerciseCombInsert', 'onErrRtnInsertExerciseComb'),
    ('OnRspExerciseCombAction', 'onRspCancelExerciseComb'),
    ('OnErrRtnExerciseCombAction', 'onErrRtnCancelExerciseComb'),
    ('OnRtnExerciseCombOrder', 'onRtnExerciseCombOrder'),
    ('OnRspQryOptionPosition', 'onRspQryOptionPosition'),
    ('OnRspQryOptionClientAccount', 'onRspQryOptionFund'),
    ('OnRspQryOptionSecurities', 'onRspQryOptionSecurities'),
    ('OnRspQryOptionMarginFee', 'onRspQryOptionRate'),
    ('OnRspQryOptionCombPosition', 'onRspQryOptionCombPosition'),
    ('OnRtnCapitalTransferDetails', 'onRtnCapitalTransferDetails'),
    ('ReqSecuritiesLock', 'reqOTU'),
    ('ReqOptionDisposal', 'reqOTT'),
    ('ReqOptionDisposalAction', 'reqCancelOTT'),
    ('ReqBilateralOrderInsert', 'reqInsertOQO'),
    ('ReqBilateralOrderAction', 'reqCancelOQO'),
    ('ReqOptionMargin', 'reqOMR'),
    ('OnRspQryOrderFlow', 'onRspQryOrderFlow'),
    ('OnRspSecuritiesLock', 'onRspOTU'),
    ('OnRtnSecuritiesLock', 'onRtnOTU'),
    ('OnErrRtnSecuritiesLock', 'onErrRtnOTU'),
    ('OnRspOptionDisposal', 'onRspOTT'),
    ('OnRtnOptionDisposal', 'onRtnOTT'),
    ('OnErrRtnOptionDisposal', 'onErrRtnOTT'),
    ('OnRspOptionDisposalAction', 'onRspCancelOTT'),
    ('OnErrRtnOptionDisposalAction', 'onErrRtnCancelOTT'),
    ('OnRspBilateralOrderInsert', 'onRspInsertOQO'),
    ('OnRtnBilateralOrderInsert', 'onRtnInsertOQO'),
    ('OnErrRtnBilateralOrderInsert', 'onErrRtnInsertOQO'),
    ('OnRspBilateralOrderAction', 'onRspCancelOQO'),
    ('OnErrRtnBilateralOrderAction', 'onErrRtnCancelOQO'),
    ('OnRspOptionMargin', 'onRspOMR'),
    ('OnRtnOptionMargin', 'onRtnOMR'),
    ('ReqXBotUserLogin', 'reqXBotUserLogin'),
    ('GetSupervisionServerInfo', 'getSupervisionServerInfo'),
]


def main(path):
    os.system("tar -czvf api_bak.tar.gz %s" % path)
    for fn in func_name_list:
        old_name, new_name = fn
        print "%s --> %s" % (old_name, new_name)
        os.system('sed -i "s/%s[(]/%s(/g" `grep "%s(" -rl %s '
                  '--exclude replace_api_func_name.py`'
                 % (old_name, new_name, old_name, path))
        time.sleep(0.5)


if __name__ == '__main__':
    try:
        arg_path = sys.argv[1]
    except IndexError:
        assert False, '请传入路径参数'

    main(arg_path)
